package ONVIF::Device::Types::RuleEngineConfiguration;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Rule_of :ATTR(:get<Rule>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        Rule
        Extension

    ) ],
    {
        'Rule' => \%Rule_of,
        'Extension' => \%Extension_of,
    },
    {
        'Rule' => 'ONVIF::Device::Types::Config',
        'Extension' => 'ONVIF::Device::Types::RuleEngineConfigurationExtension',
    },
    {

        'Rule' => 'Rule',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Device::Types::RuleEngineConfiguration

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
RuleEngineConfiguration from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Rule


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Device::Types::RuleEngineConfiguration
   Rule =>  { # ONVIF::Device::Types::Config
     Parameters =>  { # ONVIF::Device::Types::ItemList
       SimpleItem => ,
       ElementItem =>  {
       },
       Extension =>  { # ONVIF::Device::Types::ItemListExtension
       },
     },
   },
   Extension =>  { # ONVIF::Device::Types::RuleEngineConfigurationExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

