
package ONVIF::Device::Elements::SetSystemDateAndTime;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'http://www.onvif.org/ver10/device/wsdl' }

__PACKAGE__->__set_name('SetSystemDateAndTime');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %DateTimeType_of :ATTR(:get<DateTimeType>);
my %DaylightSavings_of :ATTR(:get<DaylightSavings>);
my %TimeZone_of :ATTR(:get<TimeZone>);
my %UTCDateTime_of :ATTR(:get<UTCDateTime>);

__PACKAGE__->_factory(
    [ qw(        DateTimeType
        DaylightSavings
        TimeZone
        UTCDateTime

    ) ],
    {
        'DateTimeType' => \%DateTimeType_of,
        'DaylightSavings' => \%DaylightSavings_of,
        'TimeZone' => \%TimeZone_of,
        'UTCDateTime' => \%UTCDateTime_of,
    },
    {
        'DateTimeType' => 'ONVIF::Device::Types::SetDateTimeType',
        'DaylightSavings' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'TimeZone' => 'ONVIF::Device::Types::TimeZone',
        'UTCDateTime' => 'ONVIF::Device::Types::DateTime',
    },
    {

        'DateTimeType' => 'DateTimeType',
        'DaylightSavings' => 'DaylightSavings',
        'TimeZone' => 'TimeZone',
        'UTCDateTime' => 'UTCDateTime',
    }
);

} # end BLOCK







} # end of BLOCK



1;


=pod

=head1 NAME

ONVIF::Device::Elements::SetSystemDateAndTime

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
SetSystemDateAndTime from the namespace http://www.onvif.org/ver10/device/wsdl.







=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * DateTimeType

 $element->set_DateTimeType($data);
 $element->get_DateTimeType();




=item * DaylightSavings

 $element->set_DaylightSavings($data);
 $element->get_DaylightSavings();




=item * TimeZone

 $element->set_TimeZone($data);
 $element->get_TimeZone();




=item * UTCDateTime

 $element->set_UTCDateTime($data);
 $element->get_UTCDateTime();





=back


=head1 METHODS

=head2 new

 my $element = ONVIF::Device::Elements::SetSystemDateAndTime->new($data);

Constructor. The following data structure may be passed to new():

 {
   DateTimeType => $some_value, # SetDateTimeType
   DaylightSavings =>  $some_value, # boolean
   TimeZone =>  { # ONVIF::Device::Types::TimeZone
     TZ =>  $some_value, # token
   },
   UTCDateTime =>  { # ONVIF::Device::Types::DateTime
     Time =>  { # ONVIF::Device::Types::Time
       Hour =>  $some_value, # int
       Minute =>  $some_value, # int
       Second =>  $some_value, # int
     },
     Date =>  { # ONVIF::Device::Types::Date
       Year =>  $some_value, # int
       Month =>  $some_value, # int
       Day =>  $some_value, # int
     },
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

