/*
** Copyright (C) 2001-2024 Zabbix SIA
**
** This program is free software: you can redistribute it and/or modify it under the terms of
** the GNU Affero General Public License as published by the Free Software Foundation, version 3.
**
** This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
** without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** See the GNU Affero General Public License for more details.
**
** You should have received a copy of the GNU Affero General Public License along with this program.
** If not, see <https://www.gnu.org/licenses/>.
**/

#ifndef ZABBIX_IPMI_PROTOCOL_H
#define ZABBIX_IPMI_PROTOCOL_H

#include "zbxcommon.h"

#ifdef HAVE_OPENIPMI

#include "zbxtime.h"

#define ZBX_IPC_SERVICE_IPMI	"ipmi"

#define ZBX_IPC_IPMI_REGISTER		1
#define ZBX_IPC_IPMI_VALUE_RESULT	2
#define ZBX_IPC_IPMI_COMMAND_RESULT	3

#define ZBX_IPC_IPMI_VALUE_REQUEST	101
#define ZBX_IPC_IPMI_COMMAND_REQUEST	102
#define ZBX_IPC_IPMI_CLEANUP_REQUEST	103

#define ZBX_IPC_IPMI_SCRIPT_REQUEST	201

#define ZBX_IPC_IPMI_SCRIPT_RESULT	301

zbx_uint32_t	zbx_ipmi_serialize_request(unsigned char **data, zbx_uint64_t hostid, zbx_uint64_t objectid,
		const char *addr, unsigned short port, signed char authtype, unsigned char privilege,
		const char *username, const char *password, const char *sensor, int command, const char *key);

void	zbx_ipmi_deserialize_request(const unsigned char *data, zbx_uint64_t *objectid, char **addr,
		unsigned short *port, signed char *authtype, unsigned char *privilege, char **username, char **password,
		char **sensor, int *command, char **key);

void	zbx_ipmi_deserialize_request_objectid(const unsigned char *data, zbx_uint64_t *objectid);

zbx_uint32_t	zbx_ipmi_serialize_result(unsigned char **data, const zbx_timespec_t *ts, int errcode,
		const char *value);

void	zbx_ipmi_deserialize_result(const unsigned char *data, zbx_timespec_t *ts, int *errcode, char **value);

#endif

#endif
