/* term_minibuf.c generated by valac 0.52.3, the Vala compiler
 * generated from term_minibuf.vala, do not modify */

/* Minibuffer handling

   Copyright (c) 1997-2020 Free Software Foundation, Inc.

   This file is part of GNU Zile.

   GNU Zile is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Zile is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <https://www.gnu.org/licenses/>.  */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <estr.h>

#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_COMPLETION (completion_get_type ())
#define COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION, Completion))
#define COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION, CompletionClass))
#define IS_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION))
#define IS_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION))
#define COMPLETION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION, CompletionClass))

typedef struct _Completion Completion;
typedef struct _CompletionClass CompletionClass;

#define TYPE_WINDOW (window_get_type ())
#define WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WINDOW, Window))
#define WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WINDOW, WindowClass))
#define IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WINDOW))
#define IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WINDOW))
#define WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WINDOW, WindowClass))

typedef struct _Window Window;
typedef struct _WindowClass WindowClass;
typedef struct _CompletionPrivate CompletionPrivate;

#define TYPE_BUFFER (buffer_get_type ())
#define BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUFFER, Buffer))
#define BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUFFER, BufferClass))
#define IS_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUFFER))
#define IS_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUFFER))
#define BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUFFER, BufferClass))

typedef struct _Buffer Buffer;
typedef struct _BufferClass BufferClass;
typedef enum  {
	COMPLETION_FLAGS_POPPEDUP = 1 << 0,
	COMPLETION_FLAGS_CLOSE = 1 << 1,
	COMPLETION_FLAGS_FILENAME = 1 << 2
} CompletionFlags;

#define COMPLETION_TYPE_FLAGS (completion_flags_get_type ())
#define _window_unref0(var) ((var == NULL) ? NULL : (var = (window_unref (var), NULL)))
typedef void (*TermMinibufClosure) (gpointer user_data);

#define TYPE_HISTORY (history_get_type ())
#define HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY, History))
#define HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY, HistoryClass))
#define IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY))
#define IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY))
#define HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY, HistoryClass))

typedef struct _History History;
typedef struct _HistoryClass HistoryClass;
#define _completion_unref0(var) ((var == NULL) ? NULL : (var = (completion_unref (var), NULL)))
typedef struct _Block12Data Block12Data;
typedef enum  {
	COMPLETION_CODE_notmatched,
	COMPLETION_CODE_matched,
	COMPLETION_CODE_matchednonunique,
	COMPLETION_CODE_nonunique
} CompletionCode;

#define COMPLETION_TYPE_CODE (completion_code_get_type ())
typedef guint Keystroke;
#define _immutable_estr_unref0(var) ((var == NULL) ? NULL : (var = (immutable_estr_unref (var), NULL)))

struct _Completion {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CompletionPrivate * priv;
	gchar* match;
	Buffer* old_bp;
	GeeSortedSet* completions;
	GeeSortedSet* matches;
	glong matchsize;
	CompletionFlags flags;
	gchar* path;
};

struct _CompletionClass {
	GTypeClass parent_class;
	void (*finalize) (Completion *self);
};

struct _Block12Data {
	int _ref_count_;
	guint c;
	gint thistab;
	gint lasttab;
	gchar* a;
	glong pos;
	Completion* cp;
};

extern Window* cur_wp;
extern Estr* kill_ring_text;

void term_minibuf_write (const gchar* s);
void term_move (gsize y,
                gsize x);
gsize term_height (void);
void term_clrtoeol (void);
void term_addstr (const gchar* s);
void term_minibuf_draw_read (const gchar* prompt,
                             const gchar* val,
                             gsize prompt_len,
                             const gchar* match,
                             gsize pointo);
gsize term_width (void);
void term_refresh (void);
gpointer completion_ref (gpointer instance);
void completion_unref (gpointer instance);
GParamSpec* param_spec_completion (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
void value_set_completion (GValue* value,
                           gpointer v_object);
void value_take_completion (GValue* value,
                            gpointer v_object);
gpointer value_get_completion (const GValue* value);
GType completion_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Completion, completion_unref)
void term_minibuf_maybe_close_popup (Completion* cp);
gpointer window_ref (gpointer instance);
void window_unref (gpointer instance);
GParamSpec* param_spec_window (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_window (GValue* value,
                       gpointer v_object);
void value_take_window (GValue* value,
                        gpointer v_object);
gpointer value_get_window (const GValue* value);
GType window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Window, window_unref)
gpointer buffer_ref (gpointer instance);
void buffer_unref (gpointer instance);
GParamSpec* param_spec_buffer (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_buffer (GValue* value,
                       gpointer v_object);
void value_take_buffer (GValue* value,
                        gpointer v_object);
gpointer value_get_buffer (const GValue* value);
GType buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Buffer, buffer_unref)
GType completion_flags_get_type (void) G_GNUC_CONST ;
Window* window_find (const gchar* name);
void window_set_current (Window* self);
gboolean funcall (const gchar* name,
                  glong* maybe_uniarg,
                  GeeQueue* args);
void buffer_switch_to (Buffer* self);
void term_redisplay (void);
gpointer history_ref (gpointer instance);
void history_unref (gpointer instance);
GParamSpec* param_spec_history (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
void value_set_history (GValue* value,
                        gpointer v_object);
void value_take_history (GValue* value,
                         gpointer v_object);
gpointer value_get_history (const GValue* value);
GType history_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (History, history_unref)
gchar* term_minibuf_read (const gchar* prompt,
                          const gchar* val,
                          glong pos,
                          Completion* cp,
                          History* hp);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
void history_prepare (History* self);
static void __lambda7_ (Block12Data* _data12_);
void ding (void);
GType completion_code_get_type (void) G_GNUC_CONST ;
void completion_scroll_up (void);
CompletionCode completion_try (Completion* self,
                               const gchar* in_search,
                               gboolean popup_when_complete);
static void ___lambda8_ (Block12Data* _data12_);
static void ____lambda8__term_minibuf_closure (gpointer self);
static void ___lambda7__term_minibuf_closure (gpointer self);
static void __lambda9_ (Block12Data* _data12_);
static void ___lambda9__term_minibuf_closure (gpointer self);
#define KBD_RET ((Keystroke) 00403)
#define KBD_CTRL ((Keystroke) 01000)
#define KBD_CANCEL (KBD_CTRL | 'g')
Keystroke getkeystroke (gint delay);
#define GETKEY_DEFAULT -1
#define KBD_NOKEY ((Keystroke) G_MAXUINT)
#define KBD_HOME ((Keystroke) 00406)
#define KBD_END ((Keystroke) 00407)
#define KBD_LEFT ((Keystroke) 00413)
#define KBD_RIGHT ((Keystroke) 00414)
void maybe_destroy_kill_ring (void);
void kill_ring_push (ImmutableEstr* es);
#define KBD_BS ((Keystroke) 00411)
#define KBD_DEL ((Keystroke) 00410)
#define KBD_META ((Keystroke) 02000)
#define KBD_PGUP ((Keystroke) 00404)
void completion_scroll_down (void);
#define KBD_PGDN ((Keystroke) 00405)
#define KBD_UP ((Keystroke) 00415)
const gchar* history_previous_element (History* self);
#define KBD_DOWN ((Keystroke) 00416)
const gchar* history_next_element (History* self);
#define KBD_TAB ((Keystroke) 00402)
void minibuf_clear (void);

void
term_minibuf_write (const gchar* s)
{
#line 21 "src/term_minibuf.vala"
	g_return_if_fail (s != NULL);
#line 22 "src/term_minibuf.vala"
	term_move (term_height () - 1, (gsize) 0);
#line 23 "src/term_minibuf.vala"
	term_clrtoeol ();
#line 24 "src/term_minibuf.vala"
	term_addstr (s);
#line 260 "term_minibuf.c"
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
#line 1447 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1447 "glib-2.0.vapi"
	end = _tmp0_;
#line 1448 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1448 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1449 "glib-2.0.vapi"
		result = maxlen;
#line 1449 "glib-2.0.vapi"
		return result;
#line 283 "term_minibuf.c"
	} else {
		gchar* _tmp2_;
#line 1451 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1451 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1451 "glib-2.0.vapi"
		return result;
#line 292 "term_minibuf.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
#line 1458 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1460 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1460 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 311 "term_minibuf.c"
	} else {
#line 1460 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 315 "term_minibuf.c"
	}
#line 1460 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1462 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 321 "term_minibuf.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1464 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1464 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1464 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 331 "term_minibuf.c"
	}
#line 1467 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1468 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1469 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 339 "term_minibuf.c"
	} else {
#line 1471 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 343 "term_minibuf.c"
	}
#line 1473 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1474 "glib-2.0.vapi"
		len = string_length - offset;
#line 349 "term_minibuf.c"
	}
#line 1476 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1477 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1477 "glib-2.0.vapi"
	result = _tmp3_;
#line 1477 "glib-2.0.vapi"
	return result;
#line 359 "term_minibuf.c"
}

void
term_minibuf_draw_read (const gchar* prompt,
                        const gchar* val,
                        gsize prompt_len,
                        const gchar* match,
                        gsize pointo)
{
	gint margin = 0;
	gsize n = 0UL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gboolean _tmp7_;
#line 27 "src/term_minibuf.vala"
	g_return_if_fail (prompt != NULL);
#line 27 "src/term_minibuf.vala"
	g_return_if_fail (val != NULL);
#line 27 "src/term_minibuf.vala"
	g_return_if_fail (match != NULL);
#line 29 "src/term_minibuf.vala"
	term_minibuf_write (prompt);
#line 31 "src/term_minibuf.vala"
	margin = 1;
#line 32 "src/term_minibuf.vala"
	n = (gsize) 0;
#line 33 "src/term_minibuf.vala"
	if (((prompt_len + pointo) + 1) >= term_width ()) {
#line 392 "term_minibuf.c"
		gint _tmp0_;
#line 34 "src/term_minibuf.vala"
		_tmp0_ = margin;
#line 34 "src/term_minibuf.vala"
		margin = _tmp0_ + 1;
#line 35 "src/term_minibuf.vala"
		term_addstr ("$");
#line 36 "src/term_minibuf.vala"
		n = pointo - (pointo % ((term_width () - prompt_len) - 2));
#line 402 "term_minibuf.c"
	}
#line 39 "src/term_minibuf.vala"
	_tmp1_ = string_substring (val, (glong) n, (glong) -1);
#line 39 "src/term_minibuf.vala"
	_tmp2_ = _tmp1_;
#line 39 "src/term_minibuf.vala"
	term_addstr (_tmp2_);
#line 39 "src/term_minibuf.vala"
	_g_free0 (_tmp2_);
#line 40 "src/term_minibuf.vala"
	term_addstr (match);
#line 42 "src/term_minibuf.vala"
	_tmp3_ = string_substring (val, (glong) n, (glong) -1);
#line 42 "src/term_minibuf.vala"
	_tmp4_ = _tmp3_;
#line 42 "src/term_minibuf.vala"
	_tmp5_ = strlen (_tmp4_);
#line 42 "src/term_minibuf.vala"
	_tmp6_ = _tmp5_;
#line 42 "src/term_minibuf.vala"
	_tmp7_ = ((gsize) _tmp6_) >= ((term_width () - prompt_len) - margin);
#line 42 "src/term_minibuf.vala"
	_g_free0 (_tmp4_);
#line 42 "src/term_minibuf.vala"
	if (_tmp7_) {
#line 43 "src/term_minibuf.vala"
		term_move (term_height () - 1, term_width () - 1);
#line 44 "src/term_minibuf.vala"
		term_addstr ("$");
#line 432 "term_minibuf.c"
	}
#line 47 "src/term_minibuf.vala"
	term_move (term_height () - 1, ((prompt_len + margin) - 1) + (pointo % ((term_width () - prompt_len) - margin)));
#line 51 "src/term_minibuf.vala"
	term_refresh ();
#line 438 "term_minibuf.c"
}

static gpointer
_window_ref0 (gpointer self)
{
#line 56 "src/term_minibuf.vala"
	return self ? window_ref (self) : NULL;
#line 446 "term_minibuf.c"
}

void
term_minibuf_maybe_close_popup (Completion* cp)
{
	Window* wp = NULL;
	Window* old_wp = NULL;
	Window* _tmp0_;
	Window* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
#line 55 "src/term_minibuf.vala"
	wp = NULL;
#line 56 "src/term_minibuf.vala"
	_tmp0_ = cur_wp;
#line 56 "src/term_minibuf.vala"
	_tmp1_ = _window_ref0 (_tmp0_);
#line 56 "src/term_minibuf.vala"
	old_wp = _tmp1_;
#line 57 "src/term_minibuf.vala"
	if (cp != NULL) {
#line 468 "term_minibuf.c"
		CompletionFlags _tmp4_;
#line 57 "src/term_minibuf.vala"
		_tmp4_ = cp->flags;
#line 57 "src/term_minibuf.vala"
		_tmp3_ = (_tmp4_ & COMPLETION_FLAGS_POPPEDUP) != 0;
#line 474 "term_minibuf.c"
	} else {
#line 57 "src/term_minibuf.vala"
		_tmp3_ = FALSE;
#line 478 "term_minibuf.c"
	}
#line 57 "src/term_minibuf.vala"
	if (_tmp3_) {
#line 482 "term_minibuf.c"
		Window* _tmp5_;
		Window* _tmp6_;
#line 58 "src/term_minibuf.vala"
		_tmp5_ = window_find ("*Completions*");
#line 58 "src/term_minibuf.vala"
		_window_unref0 (wp);
#line 58 "src/term_minibuf.vala"
		wp = _tmp5_;
#line 58 "src/term_minibuf.vala"
		_tmp6_ = wp;
#line 58 "src/term_minibuf.vala"
		_tmp2_ = _tmp6_ != NULL;
#line 495 "term_minibuf.c"
	} else {
#line 57 "src/term_minibuf.vala"
		_tmp2_ = FALSE;
#line 499 "term_minibuf.c"
	}
#line 57 "src/term_minibuf.vala"
	if (_tmp2_) {
#line 503 "term_minibuf.c"
		Window* _tmp7_;
		CompletionFlags _tmp8_;
		Window* _tmp11_;
#line 59 "src/term_minibuf.vala"
		_tmp7_ = wp;
#line 59 "src/term_minibuf.vala"
		window_set_current (_tmp7_);
#line 60 "src/term_minibuf.vala"
		_tmp8_ = cp->flags;
#line 60 "src/term_minibuf.vala"
		if ((_tmp8_ & COMPLETION_FLAGS_CLOSE) != 0) {
#line 61 "src/term_minibuf.vala"
			funcall ("delete-window", NULL, NULL);
#line 517 "term_minibuf.c"
		} else {
			Buffer* _tmp9_;
#line 62 "src/term_minibuf.vala"
			_tmp9_ = cp->old_bp;
#line 62 "src/term_minibuf.vala"
			if (_tmp9_ != NULL) {
#line 524 "term_minibuf.c"
				Buffer* _tmp10_;
#line 63 "src/term_minibuf.vala"
				_tmp10_ = cp->old_bp;
#line 63 "src/term_minibuf.vala"
				buffer_switch_to (_tmp10_);
#line 530 "term_minibuf.c"
			}
		}
#line 64 "src/term_minibuf.vala"
		_tmp11_ = old_wp;
#line 64 "src/term_minibuf.vala"
		window_set_current (_tmp11_);
#line 65 "src/term_minibuf.vala"
		term_redisplay ();
#line 539 "term_minibuf.c"
	}
#line 54 "src/term_minibuf.vala"
	_window_unref0 (old_wp);
#line 54 "src/term_minibuf.vala"
	_window_unref0 (wp);
#line 545 "term_minibuf.c"
}

static gpointer
_completion_ref0 (gpointer self)
{
#line 70 "src/term_minibuf.vala"
	return self ? completion_ref (self) : NULL;
#line 553 "term_minibuf.c"
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
#line 70 "src/term_minibuf.vala"
	g_atomic_int_inc (&_data12_->_ref_count_);
#line 70 "src/term_minibuf.vala"
	return _data12_;
#line 563 "term_minibuf.c"
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
#line 70 "src/term_minibuf.vala"
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
#line 70 "src/term_minibuf.vala"
		_g_free0 (_data12_->a);
#line 70 "src/term_minibuf.vala"
		_completion_unref0 (_data12_->cp);
#line 70 "src/term_minibuf.vala"
		g_slice_free (Block12Data, _data12_);
#line 579 "term_minibuf.c"
	}
}

static void
___lambda8_ (Block12Data* _data12_)
{
	gchar* bs = NULL;
	gchar* _tmp0_;
	CompletionFlags _tmp1_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
#line 96 "src/term_minibuf.vala"
	_tmp0_ = g_strdup ("");
#line 96 "src/term_minibuf.vala"
	bs = _tmp0_;
#line 97 "src/term_minibuf.vala"
	_tmp1_ = _data12_->cp->flags;
#line 97 "src/term_minibuf.vala"
	if ((_tmp1_ & COMPLETION_FLAGS_FILENAME) == COMPLETION_FLAGS_FILENAME) {
#line 609 "term_minibuf.c"
		const gchar* _tmp2_;
		gchar* _tmp3_;
#line 98 "src/term_minibuf.vala"
		_tmp2_ = _data12_->cp->path;
#line 98 "src/term_minibuf.vala"
		_tmp3_ = g_strdup (_tmp2_);
#line 98 "src/term_minibuf.vala"
		_g_free0 (bs);
#line 98 "src/term_minibuf.vala"
		bs = _tmp3_;
#line 620 "term_minibuf.c"
	}
#line 99 "src/term_minibuf.vala"
	_tmp4_ = bs;
#line 99 "src/term_minibuf.vala"
	_tmp5_ = _data12_->cp->match;
#line 99 "src/term_minibuf.vala"
	_tmp6_ = string_substring (_tmp5_, (glong) 0, _data12_->cp->matchsize);
#line 99 "src/term_minibuf.vala"
	_tmp7_ = _tmp6_;
#line 99 "src/term_minibuf.vala"
	_tmp8_ = g_strconcat (_tmp4_, _tmp7_, NULL);
#line 99 "src/term_minibuf.vala"
	_g_free0 (bs);
#line 99 "src/term_minibuf.vala"
	bs = _tmp8_;
#line 99 "src/term_minibuf.vala"
	_g_free0 (_tmp7_);
#line 100 "src/term_minibuf.vala"
	_tmp9_ = _data12_->a;
#line 100 "src/term_minibuf.vala"
	_tmp10_ = bs;
#line 100 "src/term_minibuf.vala"
	if (!g_str_has_prefix (_tmp9_, _tmp10_)) {
#line 101 "src/term_minibuf.vala"
		_data12_->thistab = -1;
#line 646 "term_minibuf.c"
	}
#line 102 "src/term_minibuf.vala"
	_tmp11_ = bs;
#line 102 "src/term_minibuf.vala"
	_tmp12_ = g_strdup (_tmp11_);
#line 102 "src/term_minibuf.vala"
	_g_free0 (_data12_->a);
#line 102 "src/term_minibuf.vala"
	_data12_->a = _tmp12_;
#line 103 "src/term_minibuf.vala"
	_tmp13_ = _data12_->a;
#line 103 "src/term_minibuf.vala"
	_tmp14_ = strlen (_tmp13_);
#line 103 "src/term_minibuf.vala"
	_tmp15_ = _tmp14_;
#line 103 "src/term_minibuf.vala"
	_data12_->pos = (glong) _tmp15_;
#line 95 "src/term_minibuf.vala"
	_g_free0 (bs);
#line 666 "term_minibuf.c"
}

static void
____lambda8__term_minibuf_closure (gpointer self)
{
#line 95 "src/term_minibuf.vala"
	___lambda8_ (self);
#line 674 "term_minibuf.c"
}

static void
__lambda7_ (Block12Data* _data12_)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 83 "src/term_minibuf.vala"
	if (_data12_->cp == NULL) {
#line 84 "src/term_minibuf.vala"
		ding ();
#line 85 "src/term_minibuf.vala"
		return;
#line 688 "term_minibuf.c"
	}
#line 88 "src/term_minibuf.vala"
	if (_data12_->lasttab != -1) {
#line 88 "src/term_minibuf.vala"
		_tmp1_ = _data12_->lasttab != ((gint) COMPLETION_CODE_notmatched);
#line 694 "term_minibuf.c"
	} else {
#line 88 "src/term_minibuf.vala"
		_tmp1_ = FALSE;
#line 698 "term_minibuf.c"
	}
#line 88 "src/term_minibuf.vala"
	if (_tmp1_) {
#line 702 "term_minibuf.c"
		CompletionFlags _tmp2_;
#line 89 "src/term_minibuf.vala"
		_tmp2_ = _data12_->cp->flags;
#line 89 "src/term_minibuf.vala"
		_tmp0_ = (_tmp2_ & COMPLETION_FLAGS_POPPEDUP) == COMPLETION_FLAGS_POPPEDUP;
#line 708 "term_minibuf.c"
	} else {
#line 88 "src/term_minibuf.vala"
		_tmp0_ = FALSE;
#line 712 "term_minibuf.c"
	}
#line 88 "src/term_minibuf.vala"
	if (_tmp0_) {
#line 90 "src/term_minibuf.vala"
		completion_scroll_up ();
#line 91 "src/term_minibuf.vala"
		_data12_->thistab = _data12_->lasttab;
#line 720 "term_minibuf.c"
	} else {
		const gchar* _tmp3_;
		TermMinibufClosure some_match = NULL;
		gpointer some_match_target;
		GDestroyNotify some_match_target_destroy_notify;
#line 93 "src/term_minibuf.vala"
		_tmp3_ = _data12_->a;
#line 93 "src/term_minibuf.vala"
		_data12_->thistab = (gint) completion_try (_data12_->cp, _tmp3_, TRUE);
#line 95 "src/term_minibuf.vala"
		some_match = ____lambda8__term_minibuf_closure;
#line 95 "src/term_minibuf.vala"
		some_match_target = block12_data_ref (_data12_);
#line 95 "src/term_minibuf.vala"
		some_match_target_destroy_notify = block12_data_unref;
#line 106 "src/term_minibuf.vala"
		switch (_data12_->thistab) {
#line 106 "src/term_minibuf.vala"
			case COMPLETION_CODE_matched:
#line 740 "term_minibuf.c"
			{
				CompletionFlags _tmp4_;
				TermMinibufClosure _tmp5_;
				gpointer _tmp5__target;
#line 108 "src/term_minibuf.vala"
				term_minibuf_maybe_close_popup (_data12_->cp);
#line 109 "src/term_minibuf.vala"
				_tmp4_ = _data12_->cp->flags;
#line 109 "src/term_minibuf.vala"
				_data12_->cp->flags = _tmp4_ & (~COMPLETION_FLAGS_POPPEDUP);
#line 110 "src/term_minibuf.vala"
				_tmp5_ = some_match;
#line 110 "src/term_minibuf.vala"
				_tmp5__target = some_match_target;
#line 110 "src/term_minibuf.vala"
				_tmp5_ (_tmp5__target);
#line 111 "src/term_minibuf.vala"
				break;
#line 759 "term_minibuf.c"
			}
#line 106 "src/term_minibuf.vala"
			case COMPLETION_CODE_matchednonunique:
#line 763 "term_minibuf.c"
			{
				TermMinibufClosure _tmp6_;
				gpointer _tmp6__target;
#line 113 "src/term_minibuf.vala"
				_tmp6_ = some_match;
#line 113 "src/term_minibuf.vala"
				_tmp6__target = some_match_target;
#line 113 "src/term_minibuf.vala"
				_tmp6_ (_tmp6__target);
#line 114 "src/term_minibuf.vala"
				break;
#line 775 "term_minibuf.c"
			}
#line 106 "src/term_minibuf.vala"
			case COMPLETION_CODE_nonunique:
#line 779 "term_minibuf.c"
			{
				TermMinibufClosure _tmp7_;
				gpointer _tmp7__target;
#line 116 "src/term_minibuf.vala"
				_tmp7_ = some_match;
#line 116 "src/term_minibuf.vala"
				_tmp7__target = some_match_target;
#line 116 "src/term_minibuf.vala"
				_tmp7_ (_tmp7__target);
#line 117 "src/term_minibuf.vala"
				break;
#line 791 "term_minibuf.c"
			}
#line 106 "src/term_minibuf.vala"
			case COMPLETION_CODE_notmatched:
#line 795 "term_minibuf.c"
			{
#line 119 "src/term_minibuf.vala"
				ding ();
#line 120 "src/term_minibuf.vala"
				break;
#line 801 "term_minibuf.c"
			}
			default:
			{
#line 122 "src/term_minibuf.vala"
				break;
#line 807 "term_minibuf.c"
			}
		}
#line 88 "src/term_minibuf.vala"
		(some_match_target_destroy_notify == NULL) ? NULL : (some_match_target_destroy_notify (some_match_target), NULL);
#line 88 "src/term_minibuf.vala"
		some_match = NULL;
#line 88 "src/term_minibuf.vala"
		some_match_target = NULL;
#line 88 "src/term_minibuf.vala"
		some_match_target_destroy_notify = NULL;
#line 818 "term_minibuf.c"
	}
}

static void
___lambda7__term_minibuf_closure (gpointer self)
{
#line 82 "src/term_minibuf.vala"
	__lambda7_ (self);
#line 827 "term_minibuf.c"
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result = NULL;
#line 1480 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1481 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1481 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1481 "glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1482 "glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 1483 "glib-2.0.vapi"
		start = string_length + start;
#line 854 "term_minibuf.c"
	}
#line 1485 "glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 1486 "glib-2.0.vapi"
		end = string_length + end;
#line 860 "term_minibuf.c"
	}
#line 1488 "glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 1488 "glib-2.0.vapi"
		_tmp2_ = start <= string_length;
#line 866 "term_minibuf.c"
	} else {
#line 1488 "glib-2.0.vapi"
		_tmp2_ = FALSE;
#line 870 "term_minibuf.c"
	}
#line 1488 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp2_, NULL);
#line 1489 "glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1489 "glib-2.0.vapi"
		_tmp3_ = end <= string_length;
#line 878 "term_minibuf.c"
	} else {
#line 1489 "glib-2.0.vapi"
		_tmp3_ = FALSE;
#line 882 "term_minibuf.c"
	}
#line 1489 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp3_, NULL);
#line 1490 "glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1491 "glib-2.0.vapi"
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1491 "glib-2.0.vapi"
	result = _tmp4_;
#line 1491 "glib-2.0.vapi"
	return result;
#line 894 "term_minibuf.c"
}

static void
__lambda9_ (Block12Data* _data12_)
{
	gboolean _tmp0_ = FALSE;
#line 128 "src/term_minibuf.vala"
	if (_data12_->c > ((guint) 255)) {
#line 128 "src/term_minibuf.vala"
		_tmp0_ = TRUE;
#line 905 "term_minibuf.c"
	} else {
#line 128 "src/term_minibuf.vala"
		_tmp0_ = !g_ascii_isprint ((gchar) _data12_->c);
#line 909 "term_minibuf.c"
	}
#line 128 "src/term_minibuf.vala"
	if (_tmp0_) {
#line 129 "src/term_minibuf.vala"
		ding ();
#line 915 "term_minibuf.c"
	} else {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		glong _tmp12_;
#line 131 "src/term_minibuf.vala"
		_tmp1_ = _data12_->a;
#line 131 "src/term_minibuf.vala"
		_tmp2_ = string_slice (_tmp1_, (glong) 0, _data12_->pos);
#line 131 "src/term_minibuf.vala"
		_tmp3_ = _tmp2_;
#line 131 "src/term_minibuf.vala"
		_tmp4_ = g_strdup_printf ("%c", (gchar) _data12_->c);
#line 131 "src/term_minibuf.vala"
		_tmp5_ = _tmp4_;
#line 131 "src/term_minibuf.vala"
		_tmp6_ = g_strconcat (_tmp3_, _tmp5_, NULL);
#line 131 "src/term_minibuf.vala"
		_tmp7_ = _tmp6_;
#line 131 "src/term_minibuf.vala"
		_tmp8_ = _data12_->a;
#line 131 "src/term_minibuf.vala"
		_tmp9_ = string_substring (_tmp8_, _data12_->pos, (glong) -1);
#line 131 "src/term_minibuf.vala"
		_tmp10_ = _tmp9_;
#line 131 "src/term_minibuf.vala"
		_tmp11_ = g_strconcat (_tmp7_, _tmp10_, NULL);
#line 131 "src/term_minibuf.vala"
		_g_free0 (_data12_->a);
#line 131 "src/term_minibuf.vala"
		_data12_->a = _tmp11_;
#line 131 "src/term_minibuf.vala"
		_g_free0 (_tmp10_);
#line 131 "src/term_minibuf.vala"
		_g_free0 (_tmp7_);
#line 131 "src/term_minibuf.vala"
		_g_free0 (_tmp5_);
#line 131 "src/term_minibuf.vala"
		_g_free0 (_tmp3_);
#line 132 "src/term_minibuf.vala"
		_tmp12_ = _data12_->pos;
#line 132 "src/term_minibuf.vala"
		_data12_->pos = _tmp12_ + 1;
#line 967 "term_minibuf.c"
	}
}

static void
___lambda9__term_minibuf_closure (gpointer self)
{
#line 127 "src/term_minibuf.vala"
	__lambda9_ (self);
#line 976 "term_minibuf.c"
}

gchar*
term_minibuf_read (const gchar* prompt,
                   const gchar* val,
                   glong pos,
                   Completion* cp,
                   History* hp)
{
	Block12Data* _data12_;
	Completion* _tmp0_;
	gchar* _tmp1_;
	gchar* saved = NULL;
	gsize prompt_len = 0UL;
	gint _tmp2_;
	gint _tmp3_;
	TermMinibufClosure do_got_tab = NULL;
	gpointer do_got_tab_target;
	GDestroyNotify do_got_tab_target_destroy_notify;
	TermMinibufClosure other_key = NULL;
	gpointer other_key_target;
	GDestroyNotify other_key_target_destroy_notify;
	const gchar* _tmp81_;
	gchar* _tmp82_;
	gchar* result = NULL;
#line 70 "src/term_minibuf.vala"
	g_return_val_if_fail (prompt != NULL, NULL);
#line 70 "src/term_minibuf.vala"
	g_return_val_if_fail (val != NULL, NULL);
#line 70 "src/term_minibuf.vala"
	_data12_ = g_slice_new0 (Block12Data);
#line 70 "src/term_minibuf.vala"
	_data12_->_ref_count_ = 1;
#line 70 "src/term_minibuf.vala"
	_data12_->pos = pos;
#line 70 "src/term_minibuf.vala"
	_tmp0_ = _completion_ref0 (cp);
#line 70 "src/term_minibuf.vala"
	_completion_unref0 (_data12_->cp);
#line 70 "src/term_minibuf.vala"
	_data12_->cp = _tmp0_;
#line 71 "src/term_minibuf.vala"
	if (hp != NULL) {
#line 72 "src/term_minibuf.vala"
		history_prepare (hp);
#line 1022 "term_minibuf.c"
	}
#line 74 "src/term_minibuf.vala"
	_data12_->c = (guint) 0;
#line 75 "src/term_minibuf.vala"
	_data12_->thistab = 0;
#line 75 "src/term_minibuf.vala"
	_data12_->lasttab = -1;
#line 76 "src/term_minibuf.vala"
	_tmp1_ = g_strdup (val);
#line 76 "src/term_minibuf.vala"
	_data12_->a = _tmp1_;
#line 76 "src/term_minibuf.vala"
	saved = NULL;
#line 78 "src/term_minibuf.vala"
	_tmp2_ = strlen (prompt);
#line 78 "src/term_minibuf.vala"
	_tmp3_ = _tmp2_;
#line 78 "src/term_minibuf.vala"
	prompt_len = (gsize) _tmp3_;
#line 79 "src/term_minibuf.vala"
	if (_data12_->pos == G_MAXLONG) {
#line 1044 "term_minibuf.c"
		const gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
#line 80 "src/term_minibuf.vala"
		_tmp4_ = _data12_->a;
#line 80 "src/term_minibuf.vala"
		_tmp5_ = strlen (_tmp4_);
#line 80 "src/term_minibuf.vala"
		_tmp6_ = _tmp5_;
#line 80 "src/term_minibuf.vala"
		_data12_->pos = (glong) _tmp6_;
#line 1056 "term_minibuf.c"
	}
#line 82 "src/term_minibuf.vala"
	do_got_tab = ___lambda7__term_minibuf_closure;
#line 82 "src/term_minibuf.vala"
	do_got_tab_target = block12_data_ref (_data12_);
#line 82 "src/term_minibuf.vala"
	do_got_tab_target_destroy_notify = block12_data_unref;
#line 127 "src/term_minibuf.vala"
	other_key = ___lambda9__term_minibuf_closure;
#line 127 "src/term_minibuf.vala"
	other_key_target = block12_data_ref (_data12_);
#line 127 "src/term_minibuf.vala"
	other_key_target_destroy_notify = block12_data_unref;
#line 1070 "term_minibuf.c"
	{
		gboolean _tmp7_ = FALSE;
#line 136 "src/term_minibuf.vala"
		_tmp7_ = TRUE;
#line 136 "src/term_minibuf.vala"
		while (TRUE) {
#line 1077 "term_minibuf.c"
			gchar* s = NULL;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
#line 136 "src/term_minibuf.vala"
			if (!_tmp7_) {
#line 1083 "term_minibuf.c"
				gboolean _tmp8_ = FALSE;
#line 277 "src/term_minibuf.vala"
				if (_data12_->c != ((guint) KBD_RET)) {
#line 277 "src/term_minibuf.vala"
					_tmp8_ = _data12_->c != ((guint) KBD_CANCEL);
#line 1089 "term_minibuf.c"
				} else {
#line 277 "src/term_minibuf.vala"
					_tmp8_ = FALSE;
#line 1093 "term_minibuf.c"
				}
#line 277 "src/term_minibuf.vala"
				if (!_tmp8_) {
#line 277 "src/term_minibuf.vala"
					break;
#line 1099 "term_minibuf.c"
				}
			}
#line 136 "src/term_minibuf.vala"
			_tmp7_ = FALSE;
#line 138 "src/term_minibuf.vala"
			switch (_data12_->lasttab) {
#line 138 "src/term_minibuf.vala"
				case COMPLETION_CODE_matchednonunique:
#line 1108 "term_minibuf.c"
				{
					gchar* _tmp9_;
#line 140 "src/term_minibuf.vala"
					_tmp9_ = g_strdup (" [Complete, but not unique]");
#line 140 "src/term_minibuf.vala"
					_g_free0 (s);
#line 140 "src/term_minibuf.vala"
					s = _tmp9_;
#line 141 "src/term_minibuf.vala"
					break;
#line 1119 "term_minibuf.c"
				}
#line 138 "src/term_minibuf.vala"
				case COMPLETION_CODE_notmatched:
#line 1123 "term_minibuf.c"
				{
					gchar* _tmp10_;
#line 143 "src/term_minibuf.vala"
					_tmp10_ = g_strdup (" [No match]");
#line 143 "src/term_minibuf.vala"
					_g_free0 (s);
#line 143 "src/term_minibuf.vala"
					s = _tmp10_;
#line 144 "src/term_minibuf.vala"
					break;
#line 1134 "term_minibuf.c"
				}
#line 138 "src/term_minibuf.vala"
				case COMPLETION_CODE_matched:
#line 1138 "term_minibuf.c"
				{
					gchar* _tmp11_;
#line 146 "src/term_minibuf.vala"
					_tmp11_ = g_strdup (" [Sole completion]");
#line 146 "src/term_minibuf.vala"
					_g_free0 (s);
#line 146 "src/term_minibuf.vala"
					s = _tmp11_;
#line 147 "src/term_minibuf.vala"
					break;
#line 1149 "term_minibuf.c"
				}
				default:
				{
					gchar* _tmp12_;
#line 149 "src/term_minibuf.vala"
					_tmp12_ = g_strdup ("");
#line 149 "src/term_minibuf.vala"
					_g_free0 (s);
#line 149 "src/term_minibuf.vala"
					s = _tmp12_;
#line 150 "src/term_minibuf.vala"
					break;
#line 1162 "term_minibuf.c"
				}
			}
#line 152 "src/term_minibuf.vala"
			_tmp13_ = _data12_->a;
#line 152 "src/term_minibuf.vala"
			_tmp14_ = s;
#line 152 "src/term_minibuf.vala"
			term_minibuf_draw_read (prompt, _tmp13_, prompt_len, _tmp14_, (gsize) _data12_->pos);
#line 154 "src/term_minibuf.vala"
			_data12_->thistab = -1;
#line 156 "src/term_minibuf.vala"
			_data12_->c = (guint) getkeystroke (GETKEY_DEFAULT);
#line 156 "src/term_minibuf.vala"
			switch (_data12_->c) {
#line 156 "src/term_minibuf.vala"
				case KBD_NOKEY:
#line 156 "src/term_minibuf.vala"
				case KBD_RET:
#line 1181 "term_minibuf.c"
				{
#line 159 "src/term_minibuf.vala"
					break;
#line 1185 "term_minibuf.c"
				}
#line 156 "src/term_minibuf.vala"
				case KBD_CTRL | 'z':
#line 1189 "term_minibuf.c"
				{
#line 161 "src/term_minibuf.vala"
					funcall ("suspend-emacs", NULL, NULL);
#line 162 "src/term_minibuf.vala"
					break;
#line 1195 "term_minibuf.c"
				}
#line 156 "src/term_minibuf.vala"
				case KBD_CANCEL:
#line 1199 "term_minibuf.c"
				{
#line 164 "src/term_minibuf.vala"
					_g_free0 (_data12_->a);
#line 164 "src/term_minibuf.vala"
					_data12_->a = NULL;
#line 165 "src/term_minibuf.vala"
					break;
#line 1207 "term_minibuf.c"
				}
#line 156 "src/term_minibuf.vala"
				case KBD_CTRL | 'a':
#line 156 "src/term_minibuf.vala"
				case KBD_HOME:
#line 1213 "term_minibuf.c"
				{
#line 168 "src/term_minibuf.vala"
					_data12_->pos = (glong) 0;
#line 169 "src/term_minibuf.vala"
					break;
#line 1219 "term_minibuf.c"
				}
#line 156 "src/term_minibuf.vala"
				case KBD_CTRL | 'e':
#line 156 "src/term_minibuf.vala"
				case KBD_END:
#line 1225 "term_minibuf.c"
				{
					const gchar* _tmp15_;
					gint _tmp16_;
					gint _tmp17_;
#line 172 "src/term_minibuf.vala"
					_tmp15_ = _data12_->a;
#line 172 "src/term_minibuf.vala"
					_tmp16_ = strlen (_tmp15_);
#line 172 "src/term_minibuf.vala"
					_tmp17_ = _tmp16_;
#line 172 "src/term_minibuf.vala"
					_data12_->pos = (glong) _tmp17_;
#line 173 "src/term_minibuf.vala"
					break;
#line 1240 "term_minibuf.c"
				}
#line 156 "src/term_minibuf.vala"
				case KBD_CTRL | 'b':
#line 156 "src/term_minibuf.vala"
				case KBD_LEFT:
#line 1246 "term_minibuf.c"
				{
#line 176 "src/term_minibuf.vala"
					if (_data12_->pos > ((glong) 0)) {
#line 1250 "term_minibuf.c"
						glong _tmp18_;
#line 177 "src/term_minibuf.vala"
						_data12_->pos = _data12_->pos - 1;
#line 177 "src/term_minibuf.vala"
						_tmp18_ = _data12_->pos;
#line 1256 "term_minibuf.c"
					} else {
#line 179 "src/term_minibuf.vala"
						ding ();
#line 1260 "term_minibuf.c"
					}
#line 180 "src/term_minibuf.vala"
					break;
#line 1264 "term_minibuf.c"
				}
#line 156 "src/term_minibuf.vala"
				case KBD_CTRL | 'f':
#line 156 "src/term_minibuf.vala"
				case KBD_RIGHT:
#line 1270 "term_minibuf.c"
				{
					const gchar* _tmp19_;
					gint _tmp20_;
					gint _tmp21_;
#line 183 "src/term_minibuf.vala"
					_tmp19_ = _data12_->a;
#line 183 "src/term_minibuf.vala"
					_tmp20_ = strlen (_tmp19_);
#line 183 "src/term_minibuf.vala"
					_tmp21_ = _tmp20_;
#line 183 "src/term_minibuf.vala"
					if (_data12_->pos < ((glong) _tmp21_)) {
#line 1283 "term_minibuf.c"
						glong _tmp22_;
#line 184 "src/term_minibuf.vala"
						_data12_->pos = _data12_->pos + 1;
#line 184 "src/term_minibuf.vala"
						_tmp22_ = _data12_->pos;
#line 1289 "term_minibuf.c"
					} else {
#line 186 "src/term_minibuf.vala"
						ding ();
#line 1293 "term_minibuf.c"
					}
#line 187 "src/term_minibuf.vala"
					break;
#line 1297 "term_minibuf.c"
				}
#line 156 "src/term_minibuf.vala"
				case KBD_CTRL | 'k':
#line 1301 "term_minibuf.c"
				{
					const gchar* _tmp23_;
					gint _tmp24_;
					gint _tmp25_;
#line 189 "src/term_minibuf.vala"
					maybe_destroy_kill_ring ();
#line 190 "src/term_minibuf.vala"
					_tmp23_ = _data12_->a;
#line 190 "src/term_minibuf.vala"
					_tmp24_ = strlen (_tmp23_);
#line 190 "src/term_minibuf.vala"
					_tmp25_ = _tmp24_;
#line 190 "src/term_minibuf.vala"
					if (_data12_->pos < ((glong) _tmp25_)) {
#line 1316 "term_minibuf.c"
						gchar* rest = NULL;
						const gchar* _tmp26_;
						gchar* _tmp27_;
						const gchar* _tmp28_;
						const gchar* _tmp29_;
						gint _tmp30_;
						gint _tmp31_;
						ImmutableEstr* _tmp32_;
						ImmutableEstr* _tmp33_;
						const gchar* _tmp34_;
						gchar* _tmp35_;
#line 191 "src/term_minibuf.vala"
						_tmp26_ = _data12_->a;
#line 191 "src/term_minibuf.vala"
						_tmp27_ = string_substring (_tmp26_, _data12_->pos, (glong) -1);
#line 191 "src/term_minibuf.vala"
						rest = _tmp27_;
#line 192 "src/term_minibuf.vala"
						_tmp28_ = rest;
#line 192 "src/term_minibuf.vala"
						_tmp29_ = rest;
#line 192 "src/term_minibuf.vala"
						_tmp30_ = strlen (_tmp29_);
#line 192 "src/term_minibuf.vala"
						_tmp31_ = _tmp30_;
#line 192 "src/term_minibuf.vala"
						_tmp32_ = immutable_estr_of (_tmp28_, (gsize) _tmp31_, IMMUTABLE_ESTR_eol_lf);
#line 192 "src/term_minibuf.vala"
						_tmp33_ = _tmp32_;
#line 192 "src/term_minibuf.vala"
						kill_ring_push (_tmp33_);
#line 192 "src/term_minibuf.vala"
						_immutable_estr_unref0 (_tmp33_);
#line 193 "src/term_minibuf.vala"
						_tmp34_ = _data12_->a;
#line 193 "src/term_minibuf.vala"
						_tmp35_ = string_substring (_tmp34_, (glong) 0, _data12_->pos);
#line 193 "src/term_minibuf.vala"
						_g_free0 (_data12_->a);
#line 193 "src/term_minibuf.vala"
						_data12_->a = _tmp35_;
#line 190 "src/term_minibuf.vala"
						_g_free0 (rest);
#line 1360 "term_minibuf.c"
					} else {
#line 195 "src/term_minibuf.vala"
						ding ();
#line 1364 "term_minibuf.c"
					}
#line 196 "src/term_minibuf.vala"
					break;
#line 1368 "term_minibuf.c"
				}
#line 156 "src/term_minibuf.vala"
				case KBD_CTRL | 'y':
#line 1372 "term_minibuf.c"
				{
					const gchar* _tmp36_;
					Estr* _tmp37_;
					gchar* _tmp38_;
					gchar* _tmp39_;
					gchar* _tmp40_;
#line 198 "src/term_minibuf.vala"
					_tmp36_ = _data12_->a;
#line 198 "src/term_minibuf.vala"
					_tmp37_ = kill_ring_text;
#line 198 "src/term_minibuf.vala"
					_tmp38_ = immutable_estr_get_text ((ImmutableEstr*) _tmp37_);
#line 198 "src/term_minibuf.vala"
					_tmp39_ = _tmp38_;
#line 198 "src/term_minibuf.vala"
					_tmp40_ = g_strconcat (_tmp36_, (const gchar*) _tmp39_, NULL);
#line 198 "src/term_minibuf.vala"
					_g_free0 (_data12_->a);
#line 198 "src/term_minibuf.vala"
					_data12_->a = _tmp40_;
#line 199 "src/term_minibuf.vala"
					break;
#line 1395 "term_minibuf.c"
				}
#line 156 "src/term_minibuf.vala"
				case KBD_BS:
#line 1399 "term_minibuf.c"
				{
#line 201 "src/term_minibuf.vala"
					if (_data12_->pos > ((glong) 0)) {
#line 1403 "term_minibuf.c"
						const gchar* _tmp41_;
						gchar* _tmp42_;
						gchar* _tmp43_;
						const gchar* _tmp44_;
						gchar* _tmp45_;
						gchar* _tmp46_;
						gchar* _tmp47_;
						glong _tmp48_;
#line 202 "src/term_minibuf.vala"
						_tmp41_ = _data12_->a;
#line 202 "src/term_minibuf.vala"
						_tmp42_ = string_slice (_tmp41_, (glong) 0, _data12_->pos - 1);
#line 202 "src/term_minibuf.vala"
						_tmp43_ = _tmp42_;
#line 202 "src/term_minibuf.vala"
						_tmp44_ = _data12_->a;
#line 202 "src/term_minibuf.vala"
						_tmp45_ = string_substring (_tmp44_, _data12_->pos, (glong) -1);
#line 202 "src/term_minibuf.vala"
						_tmp46_ = _tmp45_;
#line 202 "src/term_minibuf.vala"
						_tmp47_ = g_strconcat (_tmp43_, _tmp46_, NULL);
#line 202 "src/term_minibuf.vala"
						_g_free0 (_data12_->a);
#line 202 "src/term_minibuf.vala"
						_data12_->a = _tmp47_;
#line 202 "src/term_minibuf.vala"
						_g_free0 (_tmp46_);
#line 202 "src/term_minibuf.vala"
						_g_free0 (_tmp43_);
#line 203 "src/term_minibuf.vala"
						_data12_->pos = _data12_->pos - 1;
#line 203 "src/term_minibuf.vala"
						_tmp48_ = _data12_->pos;
#line 1438 "term_minibuf.c"
					} else {
#line 205 "src/term_minibuf.vala"
						ding ();
#line 1442 "term_minibuf.c"
					}
#line 206 "src/term_minibuf.vala"
					break;
#line 1446 "term_minibuf.c"
				}
#line 156 "src/term_minibuf.vala"
				case KBD_CTRL | 'd':
#line 156 "src/term_minibuf.vala"
				case KBD_DEL:
#line 1452 "term_minibuf.c"
				{
					const gchar* _tmp49_;
					gint _tmp50_;
					gint _tmp51_;
#line 209 "src/term_minibuf.vala"
					_tmp49_ = _data12_->a;
#line 209 "src/term_minibuf.vala"
					_tmp50_ = strlen (_tmp49_);
#line 209 "src/term_minibuf.vala"
					_tmp51_ = _tmp50_;
#line 209 "src/term_minibuf.vala"
					if (_data12_->pos < ((glong) _tmp51_)) {
#line 1465 "term_minibuf.c"
						const gchar* _tmp52_;
						gchar* _tmp53_;
						gchar* _tmp54_;
						const gchar* _tmp55_;
						gchar* _tmp56_;
						gchar* _tmp57_;
						gchar* _tmp58_;
#line 210 "src/term_minibuf.vala"
						_tmp52_ = _data12_->a;
#line 210 "src/term_minibuf.vala"
						_tmp53_ = string_slice (_tmp52_, (glong) 0, _data12_->pos);
#line 210 "src/term_minibuf.vala"
						_tmp54_ = _tmp53_;
#line 210 "src/term_minibuf.vala"
						_tmp55_ = _data12_->a;
#line 210 "src/term_minibuf.vala"
						_tmp56_ = string_substring (_tmp55_, _data12_->pos + 1, (glong) -1);
#line 210 "src/term_minibuf.vala"
						_tmp57_ = _tmp56_;
#line 210 "src/term_minibuf.vala"
						_tmp58_ = g_strconcat (_tmp54_, _tmp57_, NULL);
#line 210 "src/term_minibuf.vala"
						_g_free0 (_data12_->a);
#line 210 "src/term_minibuf.vala"
						_data12_->a = _tmp58_;
#line 210 "src/term_minibuf.vala"
						_g_free0 (_tmp57_);
#line 210 "src/term_minibuf.vala"
						_g_free0 (_tmp54_);
#line 1495 "term_minibuf.c"
					} else {
#line 212 "src/term_minibuf.vala"
						ding ();
#line 1499 "term_minibuf.c"
					}
#line 213 "src/term_minibuf.vala"
					break;
#line 1503 "term_minibuf.c"
				}
#line 156 "src/term_minibuf.vala"
				case KBD_META | 'v':
#line 156 "src/term_minibuf.vala"
				case KBD_PGUP:
#line 1509 "term_minibuf.c"
				{
					CompletionFlags _tmp59_;
#line 216 "src/term_minibuf.vala"
					if (_data12_->cp == NULL) {
#line 217 "src/term_minibuf.vala"
						ding ();
#line 218 "src/term_minibuf.vala"
						break;
#line 1518 "term_minibuf.c"
					}
#line 221 "src/term_minibuf.vala"
					_tmp59_ = _data12_->cp->flags;
#line 221 "src/term_minibuf.vala"
					if ((_tmp59_ & COMPLETION_FLAGS_POPPEDUP) != 0) {
#line 222 "src/term_minibuf.vala"
						completion_scroll_down ();
#line 223 "src/term_minibuf.vala"
						_data12_->thistab = _data12_->lasttab;
#line 1528 "term_minibuf.c"
					}
#line 225 "src/term_minibuf.vala"
					break;
#line 1532 "term_minibuf.c"
				}
#line 156 "src/term_minibuf.vala"
				case KBD_CTRL | 'v':
#line 156 "src/term_minibuf.vala"
				case KBD_PGDN:
#line 1538 "term_minibuf.c"
				{
					CompletionFlags _tmp60_;
#line 228 "src/term_minibuf.vala"
					if (_data12_->cp == NULL) {
#line 229 "src/term_minibuf.vala"
						ding ();
#line 230 "src/term_minibuf.vala"
						break;
#line 1547 "term_minibuf.c"
					}
#line 233 "src/term_minibuf.vala"
					_tmp60_ = _data12_->cp->flags;
#line 233 "src/term_minibuf.vala"
					if ((_tmp60_ & COMPLETION_FLAGS_POPPEDUP) != 0) {
#line 234 "src/term_minibuf.vala"
						completion_scroll_up ();
#line 235 "src/term_minibuf.vala"
						_data12_->thistab = _data12_->lasttab;
#line 1557 "term_minibuf.c"
					}
#line 237 "src/term_minibuf.vala"
					break;
#line 1561 "term_minibuf.c"
				}
#line 156 "src/term_minibuf.vala"
				case KBD_UP:
#line 156 "src/term_minibuf.vala"
				case KBD_META | 'p':
#line 1567 "term_minibuf.c"
				{
#line 240 "src/term_minibuf.vala"
					if (hp != NULL) {
#line 1571 "term_minibuf.c"
						gchar* elem = NULL;
						const gchar* _tmp61_;
						gchar* _tmp62_;
						const gchar* _tmp63_;
#line 241 "src/term_minibuf.vala"
						_tmp61_ = history_previous_element (hp);
#line 241 "src/term_minibuf.vala"
						_tmp62_ = g_strdup (_tmp61_);
#line 241 "src/term_minibuf.vala"
						elem = _tmp62_;
#line 242 "src/term_minibuf.vala"
						_tmp63_ = elem;
#line 242 "src/term_minibuf.vala"
						if (_tmp63_ != NULL) {
#line 1586 "term_minibuf.c"
							const gchar* _tmp64_;
							const gchar* _tmp67_;
							gchar* _tmp68_;
#line 243 "src/term_minibuf.vala"
							_tmp64_ = saved;
#line 243 "src/term_minibuf.vala"
							if (_tmp64_ == NULL) {
#line 1594 "term_minibuf.c"
								const gchar* _tmp65_;
								gchar* _tmp66_;
#line 244 "src/term_minibuf.vala"
								_tmp65_ = _data12_->a;
#line 244 "src/term_minibuf.vala"
								_tmp66_ = g_strdup (_tmp65_);
#line 244 "src/term_minibuf.vala"
								_g_free0 (saved);
#line 244 "src/term_minibuf.vala"
								saved = _tmp66_;
#line 1605 "term_minibuf.c"
							}
#line 245 "src/term_minibuf.vala"
							_tmp67_ = elem;
#line 245 "src/term_minibuf.vala"
							_tmp68_ = g_strdup (_tmp67_);
#line 245 "src/term_minibuf.vala"
							_g_free0 (_data12_->a);
#line 245 "src/term_minibuf.vala"
							_data12_->a = _tmp68_;
#line 1615 "term_minibuf.c"
						}
#line 240 "src/term_minibuf.vala"
						_g_free0 (elem);
#line 1619 "term_minibuf.c"
					}
#line 248 "src/term_minibuf.vala"
					break;
#line 1623 "term_minibuf.c"
				}
#line 156 "src/term_minibuf.vala"
				case KBD_DOWN:
#line 156 "src/term_minibuf.vala"
				case KBD_META | 'n':
#line 1629 "term_minibuf.c"
				{
#line 251 "src/term_minibuf.vala"
					if (hp != NULL) {
#line 1633 "term_minibuf.c"
						gchar* elem = NULL;
						const gchar* _tmp69_;
						gchar* _tmp70_;
						const gchar* _tmp71_;
#line 252 "src/term_minibuf.vala"
						_tmp69_ = history_next_element (hp);
#line 252 "src/term_minibuf.vala"
						_tmp70_ = g_strdup (_tmp69_);
#line 252 "src/term_minibuf.vala"
						elem = _tmp70_;
#line 253 "src/term_minibuf.vala"
						_tmp71_ = elem;
#line 253 "src/term_minibuf.vala"
						if (_tmp71_ != NULL) {
#line 1648 "term_minibuf.c"
							const gchar* _tmp72_;
							gchar* _tmp73_;
#line 254 "src/term_minibuf.vala"
							_tmp72_ = elem;
#line 254 "src/term_minibuf.vala"
							_tmp73_ = g_strdup (_tmp72_);
#line 254 "src/term_minibuf.vala"
							_g_free0 (_data12_->a);
#line 254 "src/term_minibuf.vala"
							_data12_->a = _tmp73_;
#line 1659 "term_minibuf.c"
						} else {
							const gchar* _tmp74_;
#line 255 "src/term_minibuf.vala"
							_tmp74_ = saved;
#line 255 "src/term_minibuf.vala"
							if (_tmp74_ != NULL) {
#line 1666 "term_minibuf.c"
								const gchar* _tmp75_;
								gchar* _tmp76_;
#line 256 "src/term_minibuf.vala"
								_tmp75_ = saved;
#line 256 "src/term_minibuf.vala"
								_tmp76_ = g_strdup (_tmp75_);
#line 256 "src/term_minibuf.vala"
								_g_free0 (_data12_->a);
#line 256 "src/term_minibuf.vala"
								_data12_->a = _tmp76_;
#line 257 "src/term_minibuf.vala"
								_g_free0 (saved);
#line 257 "src/term_minibuf.vala"
								saved = NULL;
#line 1681 "term_minibuf.c"
							}
						}
#line 251 "src/term_minibuf.vala"
						_g_free0 (elem);
#line 1686 "term_minibuf.c"
					}
#line 260 "src/term_minibuf.vala"
					break;
#line 1690 "term_minibuf.c"
				}
#line 156 "src/term_minibuf.vala"
				case KBD_TAB:
#line 1694 "term_minibuf.c"
				{
					TermMinibufClosure _tmp77_;
					gpointer _tmp77__target;
#line 262 "src/term_minibuf.vala"
					_tmp77_ = do_got_tab;
#line 262 "src/term_minibuf.vala"
					_tmp77__target = do_got_tab_target;
#line 262 "src/term_minibuf.vala"
					_tmp77_ (_tmp77__target);
#line 263 "src/term_minibuf.vala"
					break;
#line 1706 "term_minibuf.c"
				}
#line 156 "src/term_minibuf.vala"
				case ' ':
#line 1710 "term_minibuf.c"
				{
					TermMinibufClosure _tmp79_;
					gpointer _tmp79__target;
#line 265 "src/term_minibuf.vala"
					if (_data12_->cp != NULL) {
#line 1716 "term_minibuf.c"
						TermMinibufClosure _tmp78_;
						gpointer _tmp78__target;
#line 266 "src/term_minibuf.vala"
						_tmp78_ = do_got_tab;
#line 266 "src/term_minibuf.vala"
						_tmp78__target = do_got_tab_target;
#line 266 "src/term_minibuf.vala"
						_tmp78_ (_tmp78__target);
#line 267 "src/term_minibuf.vala"
						break;
#line 1727 "term_minibuf.c"
					}
#line 269 "src/term_minibuf.vala"
					_tmp79_ = other_key;
#line 269 "src/term_minibuf.vala"
					_tmp79__target = other_key_target;
#line 269 "src/term_minibuf.vala"
					_tmp79_ (_tmp79__target);
#line 270 "src/term_minibuf.vala"
					break;
#line 1737 "term_minibuf.c"
				}
				default:
				{
					TermMinibufClosure _tmp80_;
					gpointer _tmp80__target;
#line 272 "src/term_minibuf.vala"
					_tmp80_ = other_key;
#line 272 "src/term_minibuf.vala"
					_tmp80__target = other_key_target;
#line 272 "src/term_minibuf.vala"
					_tmp80_ (_tmp80__target);
#line 273 "src/term_minibuf.vala"
					break;
#line 1751 "term_minibuf.c"
				}
			}
#line 276 "src/term_minibuf.vala"
			_data12_->lasttab = _data12_->thistab;
#line 136 "src/term_minibuf.vala"
			_g_free0 (s);
#line 1758 "term_minibuf.c"
		}
	}
#line 279 "src/term_minibuf.vala"
	minibuf_clear ();
#line 280 "src/term_minibuf.vala"
	term_minibuf_maybe_close_popup (_data12_->cp);
#line 281 "src/term_minibuf.vala"
	_tmp81_ = _data12_->a;
#line 281 "src/term_minibuf.vala"
	_tmp82_ = g_strdup (_tmp81_);
#line 281 "src/term_minibuf.vala"
	result = _tmp82_;
#line 281 "src/term_minibuf.vala"
	(other_key_target_destroy_notify == NULL) ? NULL : (other_key_target_destroy_notify (other_key_target), NULL);
#line 281 "src/term_minibuf.vala"
	other_key = NULL;
#line 281 "src/term_minibuf.vala"
	other_key_target = NULL;
#line 281 "src/term_minibuf.vala"
	other_key_target_destroy_notify = NULL;
#line 281 "src/term_minibuf.vala"
	(do_got_tab_target_destroy_notify == NULL) ? NULL : (do_got_tab_target_destroy_notify (do_got_tab_target), NULL);
#line 281 "src/term_minibuf.vala"
	do_got_tab = NULL;
#line 281 "src/term_minibuf.vala"
	do_got_tab_target = NULL;
#line 281 "src/term_minibuf.vala"
	do_got_tab_target_destroy_notify = NULL;
#line 281 "src/term_minibuf.vala"
	_g_free0 (saved);
#line 281 "src/term_minibuf.vala"
	block12_data_unref (_data12_);
#line 281 "src/term_minibuf.vala"
	_data12_ = NULL;
#line 281 "src/term_minibuf.vala"
	return result;
#line 1795 "term_minibuf.c"
}

