<?php
/*
** Copyright (C) 2001-2024 Zabbix SIA
**
** This program is free software: you can redistribute it and/or modify it under the terms of
** the GNU Affero General Public License as published by the Free Software Foundation, version 3.
**
** This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
** without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** See the GNU Affero General Public License for more details.
**
** You should have received a copy of the GNU Affero General Public License along with this program.
** If not, see <https://www.gnu.org/licenses/>.
**/


/**
 * @var CView $this
 * @var array $data
 */

function local_showHeader(array $data): void {
	header('Content-Type: text/html; charset=UTF-8');
	header('Cache-Control: no-store');
	header('X-Content-Type-Options: nosniff');
	header('X-XSS-Protection: 1; mode=block');

	if ($data['config']['x_frame_options'] !== '') {
		if (strcasecmp($data['config']['x_frame_options'], 'SAMEORIGIN') == 0
				|| strcasecmp($data['config']['x_frame_options'], 'DENY') == 0) {
			$x_frame_options = $data['config']['x_frame_options'];
		}
		else {
			$x_frame_options = 'SAMEORIGIN';
			$allowed_urls = explode(',', $data['config']['x_frame_options']);
			$url_to_check = array_key_exists('HTTP_REFERER', $_SERVER)
				? parse_url($_SERVER['HTTP_REFERER'], PHP_URL_HOST)
				: null;

			if ($url_to_check) {
				foreach ($allowed_urls as $allowed_url) {
					if (strcasecmp(trim($allowed_url), $url_to_check) == 0) {
						$x_frame_options = 'ALLOW-FROM '.$allowed_url;
						break;
					}
				}
			}
		}

		header('X-Frame-Options: '.$x_frame_options);
	}

	echo (new CPartial('layout.htmlpage.header', [
		'javascript' => [
			'files' => $data['javascript']['files']
		],
		'stylesheet' => [
			'files' => $data['stylesheet']['files']
		],
		'page' => [
			'title' => $data['page']['title']
		],
		'user' => [
			'lang' => CWebUser::$data['lang'],
			'theme' => CWebUser::$data['theme']
		],
		'web_layout_mode' => $data['web_layout_mode'],
		'config' => [
			'server_check_interval' => $data['config']['server_check_interval']
		]
	]))->getOutput();
}

local_showHeader($data);

echo '<body class="'.ZBX_STYLE_LAYOUT_WRAPPER.'">';

// Display unexpected messages (if any) generated by the layout.
echo get_prepared_messages(['with_current_messages' => true]);

echo $data['main_block'];

require_once 'include/views/js/common.init.js.php';

insertPagePostJs();

echo '</body></html>';
