# Keyboard Shortcuts

Try out these keyboard shortcuts to help save you time.

On Mac, replace `Ctrl` with the `Command` key.

## General

* `Right Click on Tile` - Captures the tile under the mouse (drag to capture  larger areas).
* `Ctrl + MouseWheel` - Zoom in/out on tileset and map
* `Ctrl + Plus/Minus` - Zoom in/out on map
* `Ctrl + 0` - Reset zoom on map
* `Ctrl + Object Move` - Toggles "Snap to Grid" temporarily
* `Ctrl + Object Resize` - Keep aspect ratio
* `Alt + Object Resize` - Toggles "Snap to Grid" temporarily
* `Middle Click` or `Space Bar` - Hold to pan the map view
* `F5` - Run the [first custom command](using-commands.md)
* `Ctrl + X` - Cut (tiles, objects or properties)
* `Ctrl + C` - Copy (tiles, objects or properties)
* `Ctrl + V` - Paste (tiles, objects or properties)
* `Del` - Delete (tiles or objects)
* `H` - Toggle highlighting of the current layer
* `A` - Invokes [Automapping](https://github.com/bjorn/tiled/wiki/Automapping)
* `Alt + C` - Copy current position of mouse cursor to clipboard (in tile coordinates)
* `Ctrl + D` - Duplicate selected objects (since Tiled 1.0, before it was Delete)
* `Ctrl + Shift + D` - Duplicate active layer
* `F2` - Rename (if applicable in context)
* `Tab` - Hide docks and tool bars (since Tiled 1.0)
* `Ctrl + PgUp` - Select previous layer (above current layer)
* `Ctrl + PgDown` - Select next layer (below current layer)
* `Ctrl + Shift + Up` - Move current layer up
* `Ctrl + Shift + Down` - Move current layer down
* `Ctrl + Shift + H` - Show/Hide all other layers (only active layer visible / all layers visible)
* `Ctrl + Tab` - Switch to left document
* `Ctrl + Shift + Tab` - Switch to right document
* `Alt + Left` - Switch to left document
* `Alt + Right` - Switch to right document
* `Ctrl + G` - Toggle displaying of the tile grid
* `Ctrl + W` - Close current document
* `Ctrl + Shift + W` - Close all documents
* `Ctrl + E` - Export current document
* `Ctrl + Shift + E` - Export current document to another file
* `Ctrl + R` - Reload current document
* `Ctrl + T` - Force-reload all tilesets used by the current map (mainly useful when not using the automatic reloading)

## When a tile layer is selected

* `B` - Activate Stamp Brush tool
* `T` - Activate [Terrain Brush](using-the-terrain-tool.md) tool
* `F` - Activate Bucket Fill tool
* `E` - Activate Eraser tool
* `R` - Activate Rectangular Select tool
* `W` - Activate Magic Wand tool
* `S` - Activate Select Same Tile tool
* `Ctrl + 1-9` - Store current tile selection (similar to `Ctrl + C`)
* `1-9` recall the previous selection (similar to `Ctrl + V`)

## When an object layer is selected

* `S` - Activate Select Objects tool
    * `PgUp` - Raise selected objects (with Manual object drawing order)
    * `PgDown` - Lower selected objects (with Manual object drawing order)
    * `Home` - Move selected objects to Top (with Manual object drawing order)
    * `End` - Move selected objects to Bottom (with Manual object drawing order)
* `O` - Activate Edit Polygons tool (was `E` until Tiled 1.0)
* `R` - Activate Insert Rectangle tool
* `C` - Activate Insert Ellipse tool
* `P` - Activate Insert Polygon tool
* `L` - Activate Insert Polyline tool
    * `Enter` - Finish creating object
    * `Escape` - Cancel creating object
* `T` - Activate Insert Tile tool
* `E` - Activate Insert Text tool (since Tiled 1.0)

## When using the brush tool

* `Shift + Click` - Line Tool, auto place tiles between two cells
* `Ctrl + Shift + Click` - Circle Tool, auto place tiles around a radius
* `X` - Flip selection horizontally
* `Y` - Flip selection vertically
* `Z` - Rotate selection clockwise
* `Shift + Z` - Rotate selection counterclockwise

## When using the Rectangular Select tool

* `Ctrl + A` - Select the whole layer
* `Ctrl + Shift + A` - Select nothing

## In the properties dialog

* `Del` or `Backspace` - Deletes a property
