; ***********************************************************
; ; Adapt path if necessary:
; (define path "~/minlog/examples/tait/diplomarbeit_schlenker/")

; ; Defines the function "pload" to load files 
; ; from the path defined above
; (define pload (lambda (x) (load (string-append path x))))

; ; Used Modules:
; (pload "./initiate.scm")
; (pload "./defsLamCalc.scm")
; (pload "./defsSubst.scm")
; (pload "./omega.scm")
; (pload "./defsNT.scm")
; (pload "./defsAxiomsSpecial.scm")
; (pload "./defsAxioms.scm")
; (pload "./trivial.scm")
; (pload "./auxSC.scm")
; (pload "./auxGlobal_SHORT.scm")
; (pload "./auxLem1.scm")
; (pload "./Lem1.scm")
; (pload "./Lem2.scm")
; (pload "./auxLem3_SHORT.scm")
; (pload "./Lem3.scm")
; (pload "./auxNT_SHORT.scm")
;
; NOTICE: Uncomment modules only when file is run on its own
; ***********************************************************


; ================================
;  Section: Normalization Theorem
; ================================
; contains the Normalization Theorem using previous lemmas

; Lemma: "NTheorem"
; -----------------
; the Normalization Theorem 

(set-goal (pf "all rhos,r.
 Cor rhos r -> ex s N rhos (Typ rhos r) r s"))

(assume "rhos" "r" "[Cor]")
(use "LemmaOne" (pt "Lh(rhos)"))
(ng)
(use "[Cor]")
(assert (pf "Sub r (Wrap 0 (Var map(Seq 0(Lh rhos))))=r"))
(use "SubIds")
(use "[Cor]")
(assume "[Sub]")
(simp "<-" "[Sub]")
(use "LemmaThree" (pt "rhos") (pt "Lh(rhos)"))
(ng)
(split)
(use "[Cor]")
(simp "[Sub]")
(ng)
(prop)
(use-with "SCrsSeq" (pt "rhos") (pt "(Nil type)"))
(use "FrIntro1")
(ng)
(use "[Cor]")
(save "NTheorem")
