/* Copyright (C) 2016 Jeremiah Orians
 * This file is part of stage0.
 *
 * stage0 is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * stage0 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with stage0.  If not, see <http://www.gnu.org/licenses/>.
 */

#include<stdlib.h>
#include<string.h>
// void* calloc(int count, int size);
#define TRUE 1
//CONSTANT TRUE 1
#define FALSE 0
//CONSTANT FALSE 0
int in_set(int c, char* s);

char* numerate_number(int a)
{
	char* result = calloc(16, sizeof(char));
	int i = 0;

	/* Deal with Zero case */
	if(0 == a)
	{
		result[0] = '0';
		return result;
	}

	/* Deal with negatives */
	if(0 > a)
	{
		result[0] = '-';
		i = 1;
		a = a * -1;
	}

	/* Using the largest 10^n number possible in 32bits */
	int divisor = 0x3B9ACA00;
	/* Skip leading Zeros */
	while(0 == (a / divisor)) divisor = divisor / 10;

	/* Now simply collect numbers until divisor is gone */
	while(0 < divisor)
	{
		result[i] = ((a / divisor) + 48);
		a = a % divisor;
		divisor = divisor / 10;
		i = i + 1;
	}

	return result;
}

int char2hex(int c)
{
	if (c >= '0' && c <= '9') return (c - 48);
	else if (c >= 'a' && c <= 'f') return (c - 87);
	else if (c >= 'A' && c <= 'F') return (c - 55);
	else return -1;
}

int hex2char(int c)
{
	if((c >= 0) && (c <= 9)) return (c + 48);
	else if((c >= 10) && (c <= 15)) return (c + 55);
	else return -1;
}

int char2dec(int c)
{
	if (c >= '0' && c <= '9') return (c - 48);
	else return -1;
}

int dec2char(int c)
{
	if((c >= 0) && (c <= 9)) return (c + 48);
	else return -1;
}

int index_number(char* s, char c)
{
	int i = 0;
	while(s[i] != c)
	{
		i = i + 1;
		if(0 == s[i]) return -1;
	}
	return i;
}

int toupper(int c)
{
	if(in_set(c, "abcdefghijklmnopqrstuvwxyz")) return (c & 0xDF);
	return c;
}

int set_reader(char* set, int mult, char* input)
{
	int n = 0;
	int i = 0;
	int hold;
	int negative_p = 0;

	if(input[0] == '-')
	{
		negative_p = 1;
		i = i + 1;
	}

	while(in_set(input[i], set))
	{
		n = n * mult;
		hold = index_number(set, toupper(input[i]));
		if(-1 == hold) return 0;
		n = n + hold;
		i = i + 1;
	}

	if(0 != input[i]) return 0;

	if(negative_p)
	{
		n = 0 - n;
	}

	return n;
}

int numerate_string(char *a)
{
	/* If NULL string */
	if(0 == a[0])
	{
		return 0;
	}
	/* Deal with binary*/
	else if ('0' == a[0] && 'b' == a[1])
	{
		return set_reader("01", 2, a+2);
	}
	/* Deal with hex */
	else if ('0' == a[0] &&  'x' == a[1])
	{
		return set_reader("0123456789ABCDEFabcdef", 16, a+2);
	}
	/* Deal with ocal */
	else if('0' == a[0])
	{
		return set_reader("01234567", 8, a+1);
	}
	/* Deal with decimal */
	else
	{
		return set_reader("0123456789", 10, a);
	}
}
