# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::DE;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20241212130805;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            3[02]|
            40|
            [68]9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,13})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            2(?:
              0[1-389]|
              12[0-8]
            )|
            3(?:
              [35-9][15]|
              4[015]
            )|
            906|
            2(?:
              [13][14]|
              2[18]
            )|
            (?:
              2[4-9]|
              4[2-9]|
              [579][1-9]|
              [68][1-8]
            )1
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [24-6]|
            3(?:
              3(?:
                0[1-467]|
                2[127-9]|
                3[124578]|
                7[1257-9]|
                8[1256]|
                9[145]
              )|
              4(?:
                2[135]|
                4[13578]|
                9[1346]
              )|
              5(?:
                0[14]|
                2[1-3589]|
                6[1-4]|
                7[13468]|
                8[13568]
              )|
              6(?:
                2[1-489]|
                3[124-6]|
                6[13]|
                7[12579]|
                8[1-356]|
                9[135]
              )|
              7(?:
                2[1-7]|
                4[145]|
                6[1-5]|
                7[1-4]
              )|
              8(?:
                21|
                3[1468]|
                6|
                7[1467]|
                8[136]
              )|
              9(?:
                0[12479]|
                2[1358]|
                4[134679]|
                6[1-9]|
                7[136]|
                8[147]|
                9[1468]
              )
            )|
            70[2-8]|
            8(?:
              0[2-9]|
              [1-8]
            )|
            90[7-9]|
            [79][1-9]|
            3[68]4[1347]|
            3(?:
              47|
              60
            )[1356]|
            3(?:
              3[46]|
              46|
              5[49]
            )[1246]|
            3[4579]3[1357]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2,11})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '138',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '3',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{2,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '181',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,11})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              3|
              80
            )|
            9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d)(\\d{4,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '1[67]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18500',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18[68]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[1279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            15(?:
              [0568]|
              31
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              6[023]|
              7
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15[279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{7})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{8})'
                }
              ];

my $validators = {
                'fixed_line' => '
          32\\d{9,11}|
          49[1-6]\\d{10}|
          322\\d{6}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'geographic' => '
          32\\d{9,11}|
          49[1-6]\\d{10}|
          322\\d{6}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'mobile' => '
          1(?:
            (?:
              5(?:
                [0-25-9]\\d\\d|
                310
              )|
              76\\d\\d
            )\\d{6}|
            6[023]\\d{7,8}
          )|
          17\\d{8}
        ',
                'pager' => '
          16(?:
            4\\d{1,10}|
            [89]\\d{1,11}
          )
        ',
                'personal_number' => '700\\d{8}',
                'specialrate' => '(
          180\\d{5,11}|
          13(?:
            7[1-6]\\d\\d|
            8
          )\\d{4}
        )|(
          (?:
            137[7-9]|
            900(?:
              [135]|
              9\\d
            )
          )\\d{6}
        )|(
          18(?:
            1\\d{5,11}|
            [2-9]\\d{8}
          )
        )',
                'toll_free' => '800\\d{7,12}',
                'voip' => ''
              };
my %areanames = ();
$areanames{de} = {"4935726", "Groß\ Särchen",
"4939883", "Groß\ Dölln",
"498807", "Dießen\ am\ Ammersee",
"497355", "Hochdorf\ Riß",
"496663", "Steinau\ an\ der\ Straße",
"4938234", "Born\ Darß",
"493647", "Pößneck",
"497351", "Biberach\ an\ der\ Riß",
"494497", "Barßel\-Harkebrügge",
"4934445", "Stößen",
"494509", "Groß\ Grönau",
"4935952", "Großröhrsdorf\ OL",
"4939934", "Groß\ Plasten",
"498536", "Kößlarn",
"492203", "Köln\-Porz",
"499636", "Plößberg",
"4936705", "Oberweißbach\ Thüringer\ Wald",
"495053", "Faßberg\-Müden",
"4936484", "Knau\ bei\ Pößneck",
"4935938", "Großpostwitz\ OL",
"4935753", "Großräschen",
"4989", "München",
"4939976", "Groß\ Bützin",
"4934493", "Gößnitz\ Thüringen",
"495827", "Unterlüß",
"495064", "Groß\ Düngen",
"498367", "Roßhaupten\ Forggensee",
"4935240", "Tauscha\ bei\ Großenhain",
"498633", "Tüßling",
"49221", "Köln",
"4935248", "Schönfeld\ bei\ Großenhain",
"497162", "Süßen",
"4936072", "Weißenborn\-Lüderode",
"496252", "Heppenheim\ Bergstraße",
"4935841", "Großschönau\ Sachsen",
"494483", "Ovelgönne\-Großenmeer",
"49911", "Nürnberg",
"499141", "Weißenburg\ in\ Bayern",
"496321", "Neustadt\ an\ der\ Weinstraße",
"499567", "Seßlach\-Gemünda",
"492339", "Sprockhövel\-Haßlinghausen",
"495384", "Seesen\-Groß\ Rhüden",
"494684", "Langeneß\ Hallig",
"499656", "Moosbach\ bei\ Vohenstrauß",
"499242", "Gößweinstein",
"498170", "Straßlach\-Dingharting",
"496364", "Nußbach\ Pfalz",
"4934901", "Roßlau\ Elbe",
"4936949", "Obermaßfeld\-Grimmenthal",};
$areanames{en} = {"493763", "Glauchau",
"4934600", "Ostrau\ Saalkreis",
"494184", "Hanstedt\ Nordheide",
"496430", "Hahnstätten",
"4938222", "Semlow",
"4934295", "Krensitz",
"4934361", "Dahlen\ Sachsen",
"494523", "Malente",
"498083", "Isen",
"495286", "Ottenstein\ Niedersachsen",
"4936259", "Tabarz\ Thüringer\ Wald",
"4939403", "Gröningen\ Sachsen\-Anhalt",
"496223", "Neckargemünd",
"497477", "Jungingen\ bei\ Hechingen",
"4939329", "Möringen",
"4939482", "Gatersleben",
"497384", "Schelklingen\-Hütten",
"499973", "Furth\ im\ Wald",
"498651", "Bad\ Reichenhall",
"493521", "Meissen",
"494761", "Bremervörde",
"499285", "Kirchenlamitz",
"498446", "Pörnbach",
"492572", "Emsdetten",
"497054", "Wildberg\ Württemberg",
"4938221", "Marlow",
"496675", "Breitenbach\ am\ Herzberg",
"495521", "Herzberg\ am\ Harz",
"49521", "Bielefeld",
"4939481", "Hedersleben\ bei\ Aschersleben",
"498642", "Übersee",
"497231", "Pforzheim",
"4939859", "Fürstenwerder",
"492336", "Schwelm",
"4937609", "Wolkenburg\ Mulde",
"4935265", "Glaubitz",
"4934362", "Mügeln\ bei\ Oschatz",
"497808", "Hohberg\ bei\ Offenburg",
"495763", "Uchte",
"4934443", "Teuchern",
"498549", "Vilshofen\-Pleinting",
"492183", "Rommerskirchen",
"498304", "Wildpoldsried",
"499129", "Wendelstein",
"499232", "Wunsiedel",
"492524", "Ennigerloh",
"496308", "Olsbrücken",
"496527", "Oberweis",
"4939085", "Zichtau",
"492937", "Arnsberg\-Oeventrop",
"499573", "Staffelstein\ Oberfranken",
"497181", "Schorndorf\ Württemberg",
"493921", "Burg\ bei\ Magdeburg",
"4939779", "Eggesin",
"497432", "Albstadt\-Tailfingen",
"495858", "Hitzacker\-Wietzetze",
"498405", "Stammham\ bei\ Ingolstadt",
"492684", "Puderbach\ Westerwald",
"494498", "Saterland\-Ramsloh",
"495053", "Fassberg\-Müden",
"4933769", "Töpchin",
"494381", "Lütjenburg",
"499182", "Velburg",
"4939392", "Rönnebeck\ Sachsen\-Anhalt",
"499431", "Schwandorf",
"495681", "Homberg\ Efze",
"4933202", "Töplitz",
"492268", "Kürten",
"4935329", "Dollenchen",
"498267", "Dirlewang",
"492233", "Hürth\ Rheinland",
"497764", "Herrischried",
"494923", "Krummhörn\-Pewsum",
"4934776", "Rothenschirmbach",
"497485", "Empfingen",
"495136", "Burgdorf\ Kreis\ Hannover",
"493681", "Suhl",
"498538", "Pocking\-Hartkirchen",
"498563", "Bad\ Birnbach\ Rottal",
"494234", "Dörverden",
"4936705", "Oberweissbach\ Thüringer\ Wald",
"497826", "Schuttertal",
"496534", "Mülheim\ Mosel",
"492924", "Möhnesee",
"4933201", "Gross\ Glienicke",
"499277", "Warmensteinach",
"4939391", "Lückstedt",
"497636", "Münstertal\ Schwarzwald",
"495921", "Nordhorn",
"494179", "Winsen\-Tönnhausen",
"492972", "Schmallenberg",
"499135", "Hessdorf\ Mittelfranken",
"494683", "Oldsum",
"498721", "Eggenfelden",
"495383", "Lutter\ am\ Barenberge",
"4933846", "Dippmannsdorf",
"496326", "Deidesheim",
"4939265", "Löderburg",
"4933637", "Beerfelde",
"495442", "Barnstorf\ Kreis\ Diepholz",
"4939824", "Hohenzieritz",
"492565", "Gronau\-Epe",
"496074", "Rödermark",
"497655", "Feldberg\-Altglashütten",
"499156", "Neuhaus\ an\ der\ Pegnitz",
"498282", "Krumbach\ Schwaben",
"496022", "Obernburg\ am\ Main",
"494453", "Zetel",
"4933435", "Rehfelde",
"494404", "Elsfleth",
"499167", "Oberscheinfeld",
"4934602", "Landsberg\ Sachsen\-Anhalt",
"4938854", "Redefin",
"494269", "Ahausen\-Kirchwalsede",
"4937369", "Wolkenstein",
"495155", "Emmerthal",
"492360", "Haltern\-Lippramsdorf",
"4938220", "Wustrow\ Ostseebad",
"49208", "Oberhausen\ Rheinland",
"496569", "Bickendorf",
"4933838", "Päwesin",
"492596", "Nordkirchen",
"497146", "Remseck\ am\ Neckar",
"492454", "Gangelt",
"499645", "Eschenbach\ in\ der\ Oberpfalz",
"492403", "Eschweiler\ Rheinland",
"494947", "Aurich\-Ogenbargen",
"496457", "Burgwald\ Eder",
"4936606", "Kraftsdorf",
"499201", "Gesees",
"495197", "Soltau\-Frielingen",
"497739", "Hilzingen",
"4936649", "Gefell\ bei\ Schleiz",
"494346", "Gettorf",
"496466", "Dautphetal\-Friedensdorf",
"499628", "Ursensollen",
"498177", "Münsing\ Starnberger\ See",
"495646", "Willebadessen",
"497202", "Karlsbad",
"4936744", "Remda",
"4938324", "Velgast",
"4934601", "Teutschenthal",
"495451", "Ibbenbüren",
"494243", "Twistringen",
"497660", "St\ Peter\ Schwarzwald",
"499402", "Regenstauf",
"496543", "Büchenbeuren",
"496359", "Grünstadt",
"492862", "Südlohn",
"4933200", "Bergholz\-Rehbrücke",
"4939390", "Iden",
"493378", "Ludwigsfelde",
"493605", "Leinefelde",
"492355", "Schalksmühle",
"495252", "Bad\ Lippspringe",
"4933929", "Gühlen\-Glienicke",
"4934905", "Wörlitz",
"497725", "Königsfeld\ im\ Schwarzwald",
"495605", "Kaufungen\ Hessen",
"494305", "Westensee",
"496394", "Bundenthal",
"499190", "Heroldsbach",
"492776", "Bad\ Endbach\-Hartenrod",
"495241", "Gütersloh",
"4939294", "Gross\ Rosenburg",
"499606", "Pfreimd",
"492244", "Königswinter\-Oberpleis",
"494547", "Gudow\ Lauenburg",
"497748", "Grafenhausen\ Hochschwarzwald",
"496247", "Worms\-Pfeddersheim",
"495378", "Sassenburg\-Platendorf",
"496266", "Hassmersheim",
"495034", "Neustadt\-Hagen",
"498435", "Ehekirchen",
"4939723", "Krien",
"497402", "Fluorn\-Winzeln",
"495251", "Paderborn",
"4938847", "Boizenburg\ Elbe",
"495864", "Jameln",
"493726", "Flöha",
"494557", "Blunk",
"492254", "Weilerswist",
"492861", "Borken\ Westfalen",
"498686", "Petting",
"496257", "Seeheim\-Jugenheim",
"4939931", "Röbel\ Müritz",
"492203", "Cologne\-Porz",
"4938753", "Wöbbelin",
"499401", "Neutraubling",
"4939243", "Nedlitz\ bei\ Zerbst",
"494253", "Asendorf\ Kreis\ Diepholz",
"4934203", "Zwenkau",
"496504", "Thalfang",
"498670", "Reischach\ Kreis\ Altötting",
"496553", "Schönecken",
"496295", "Rosenberg\ Baden",
"498327", "Rettenberg",
"4935385", "Annaburg",
"494204", "Thedinghausen",
"498131", "Dachau",
"492507", "Havixbeck",
"494469", "Wangerooge",
"496349", "Billigheim\-Ingenheim",
"499725", "Poppenhausen\ Unterfranken",
"495242", "Rheda\-Wiedenbrück",
"4933087", "Bredereiche",
"4939932", "Malchow\ bei\ Waren",
"4939347", "Kade",
"4939886", "Milmersdorf",
"499748", "Motten",
"499105", "Grosshabersdorf",
"4936843", "Benshausen",
"496783", "Baumholder",
"495726", "Wiedensahl",
"49861", "Traunstein",
"4935931", "Königswartha",
"497156", "Ditzingen",
"492444", "Schleiden\-Gemünd",
"496447", "Langgöns\-Niederkleen",
"494367", "Grossenbrode",
"494957", "Detern",
"499655", "Tännesberg",
"4938488", "Demen",
"496400", "Mücke",
"4935243", "Weinböhla",
"49234", "Bochum",
"496021", "Aschaffenburg",
"498281", "Thannhausen\ Schwaben",
"494356", "Gross\ Wittensee",
"494966", "Neubörger",
"4934465", "Bad\ Bibra",
"4935723", "Bernsdorf\ OL",
"4939748", "Viereck",
"495027", "Linsburg",
"4933234", "Wustermark",
"4936022", "Grossengottern",
"495656", "Waldkappel",
"4933363", "Altenhof\ Kreis\ Barnim",
"496661", "Schlüchtern",
"495441", "Diepholz",
"495452", "Mettingen\ Westfalen",
"497838", "Nordrach",
"494775", "Grossenwörden",
"4940", "Hamburg",
"492306", "Lünen",
"4936425", "Isserstedt",
"4935932", "Guttau",
"497645", "Freiamt",
"495128", "Hohenhameln",
"497033", "Weil\ Der\ Stadt",
"494892", "Schenefeld\ Mittelholstein",
"496192", "Hofheim\ am\ Taunus",
"493441", "Zeitz",
"499146", "Markt\ Berolzheim",
"494443", "Dinklage",
"496363", "Niederkirchen",
"4936021", "Schlotheim",
"496338", "Hornbach\ Pfalz",
"4938873", "Carlow",
"498334", "Bad\ Grönenbach",
"499202", "Waischenfeld",
"4938797", "Karstädt\ Kreis\ Prignitz",
"497628", "Efringen\-Kirchen",
"495145", "Beedenbostel",
"498369", "Rückholz",
"495682", "Borken\ Hessen",
"499181", "Neumarkt\ in\ der\ Oberpfalz",
"497573", "Stetten\ am\ kalten\ Markt",
"494382", "Wangels",
"4933973", "Zernitz\ bei\ Neustadt\ Dosse",
"4935697", "Bagenz",
"499764", "Höchheim",
"49541", "Osnabrück",
"4934384", "Grossbothen",
"497431", "Albstadt\-Ebingen",
"497182", "Welzheim",
"493635", "Kölleda",
"499826", "Weidenbach\ Mittelfranken",
"498722", "Gangkofen",
"49341", "Leipzig",
"495848", "Trebel",
"494335", "Hohn\ bei\ Rendsburg",
"492971", "Schmallenberg\-Dorlar",
"498246", "Waal",
"495043", "Lauenau",
"495922", "Bad\ Bentheim",
"4933474", "Neutrebbin",
"495635", "Vöhl",
"495825", "Wieren",
"498102", "Höhenkirchen\-Siegertsbrunn",
"493682", "Zella\-Mehlis",
"498774", "Bayerbach\ bei\ Ergoldsbach",
"497135", "Brackenheim",
"4935054", "Lauenstein\ Sachsen",
"496423", "Wetter\ Hessen",
"497277", "Wörth\-Büchelberg",
"499636", "Plössberg",
"4934494", "Ehrenhain",
"499099", "Kaisheim",
"497044", "Mönsheim",
"494762", "Kutenholz",
"4938735", "Plau\ am\ See",
"493522", "Grossenhain\ Sachsen",
"4933331", "Casekow",
"498652", "Berchtesgaden",
"4936020", "Ebeleben",
"493629", "Stadtilm",
"493574", "Lauchhammer",
"494434", "Colnrade",
"497973", "Obersontheim",
"498343", "Aitrang",
"499384", "Schwanfeld",
"495574", "Oberweser",
"497709", "Wutach",
"494329", "Langwedel\ Holstein",
"499231", "Marktredwitz",
"498467", "Kinding",
"492433", "Hückelhoven",
"494876", "Reher\ Holstein",
"4939054", "Flechtingen",
"4933603", "Falkenhagen\ bei\ Seelow",
"4933332", "Gartz\ Oder",
"497129", "Lichtenstein\ Württemberg",
"495069", "Nordstemmen",
"497232", "Königsbach\-Stein",
"498641", "Grassau\ Kreis\ Traunstein",
"495522", "Osterode\ am\ Harz",
"498205", "Dasing",
"4935930", "Seitschen",
"498456", "Lenting",
"495839", "Wittingen\-Ohrdorf",
"492571", "Greven\ Westfalen",
"494298", "Lilienthal",
"497125", "Bad\ Urach",
"498464", "Dietfurt\ an\ der\ Altmühl",
"495065", "Sibbesse",
"495648", "Brakel\-Gehrden",
"4933977", "Gumtow",
"4935693", "Lauschütz",
"496433", "Hadamar",
"499626", "Hohenburg",
"496468", "Dautphetal\-Mornshausen",
"494348", "Schönkirchen",
"49991", "Deggendorf",
"4934953", "Gräfenhainichen",
"495835", "Wahrenholz",
"4937421", "Oelsnitz\ Vogtland",
"496220", "Wilhelmsfeld",
"496571", "Wittlich",
"495932", "Haren\ Ems",
"497148", "Grossbottwar",
"497705", "Wolterdingen\ Schwarzw",
"495625", "Naumburg\ Hessen",
"494271", "Sulingen",
"492598", "Senden\-Ottmarsbocholt",
"499836", "Gunzenhausen\-Cronheim",
"4936623", "Berga\ Elster",
"498732", "Frontenhausen",
"498555", "Perlesreut",
"498293", "Welden\ bei\ Augsburg",
"4937422", "Markneukirchen",
"499474", "Schmidmühlen",
"4933928", "Wildberg\ Brandenburg",
"495882", "Gorleben",
"499422", "Bogen\ Niederbayern",
"4939934", "Gross\ Plasten",
"49375", "Zwickau",
"4933470", "Lietzen",
"499158", "Offenhausen\ Mittelfranken",
"495273", "Beverungen",
"498076", "Pfaffing",
"498785", "Rottenburg\-Oberroning",
"497746", "Wutöschingen",
"495532", "Stadtoldendorf",
"495829", "Wriedel",
"499608", "Kohlberg\ Oberpfalz",
"4936648", "Dittersdorf\ bei\ Schleiz",
"495376", "Wesendorf\ Kreis\ Gifhorn",
"497139", "Neuenstadt\ am\ Kocher",
"497222", "Rastatt",
"492423", "Langerwehe",
"492778", "Siegbach",
"498841", "Murnau\ am\ Staffelsee",
"4936024", "Diedorf\ bei\ Mühlhausen",
"497274", "Germersheim",
"493585", "Löbau",
"4933232", "Brieselang",
"4935433", "Vetschau",
"499375", "Freudenberg\ Baden",
"49951", "Bamberg",
"499221", "Kulmbach",
"494339", "Christiansholm",
"495977", "Spelle",
"494920", "Wirdum",
"4937368", "Deutschneudorf",
"4935934", "Grossdubrau",
"496002", "Ober\-Mörlen",
"4933839", "Wusterwitz",
"495585", "Herzberg\-Sieber",
"4936735", "Probstzella",
"498365", "Wertach",
"4933231", "Pausin",
"4939050", "Bartensleben",
"494472", "Lastrup",
"495755", "Kalletal\-Varenholz",
"4933607", "Briesen\ Mark",
"495901", "Fürstenau\ bei\ Bramsche",
"497542", "Tettnang",
"492192", "Hückeswagen",
"4938757", "Neustadt\-Glewe",
"4935455", "Walddrehna",
"495149", "Wienhausen",
"496306", "Trippstadt",
"4939247", "Güterglück",
"494779", "Freiburg\ Elbe",
"4939727", "Spantekow",
"499735", "Massbach",
"4934382", "Nerchau",
"497806", "Bad\ Peterstal\-Griesbach",
"4934632", "Mücheln\ Geiseltal",
"49881", "Weilheim\ in\ Oberbayern",
"492904", "Bestwig",
"498337", "Altenstadt\ Iller",
"492363", "Datteln",
"4938843", "Bennin",
"492953", "Wünnenberg",
"492338", "Breckerfeld",
"498121", "Markt\ Schwaben",
"4938456", "Langhagen\ bei\ Güstrow",
"4933083", "Schulzendorf\ Kreis\ Oberhavel",
"4939343", "Jerichow",
"495072", "Neustadt\-Mandelsloh",
"499552", "Burghaslach",
"492447", "Dahlem\ bei\ Kall",
"4936847", "Steinbach\-Hallenberg",
"4933768", "Prieros",
"495664", "Morschen",
"494903", "Wymeer",
"496444", "Bischoffen",
"494954", "Moormerland",
"494364", "Dahme\ Kreis\ Ostholstein",
"4933472", "Golzow\ bei\ Seelow",
"4934207", "Zwochau",
"499659", "Leuchtenberg",
"492661", "Bad\ Marienberg\ Westerwald",
"493901", "Salzwedel",
"4935052", "Kipsdorf\ Kurort",
"498092", "Grafing\ bei\ München",
"497551", "Überlingen\ Bodensee",
"4939778", "Ferdinandshof\ bei\ Torgelow",
"497164", "Boll\ Kreis\ Göppingen",
"495024", "Rohrsen\ Kreis\ Nienburg\ Weser",
"4934381", "Colditz",
"4939426", "Hessen",
"499941", "Kötzting",
"4935727", "Burghammer",
"4934492", "Lucka",
"4938425", "Kirchdorf\ Poel",
"494240", "Syke\-Heiligenfelde",
"497663", "Eichstetten",
"492295", "Ruppichteroth",
"4933367", "Friedrichswalde\ Brandenburg",
"492553", "Ochtrup",
"496328", "Elmstein",
"496507", "Neumagen\-Dhron",
"4939051", "Calvörde",
"4933230", "Börnicke\ Kreis\ Havelland",
"498324", "Hindelang",
"494207", "Oyten",
"4938828", "Schönberg",
"492504", "Telgte",
"495138", "Sehnde",
"4936873", "Themar",
"4939858", "Bietikow",
"497023", "Weilheim\ an\ der\ Teck",
"497942", "Neuenstein\ Württemberg",
"495163", "Fallingbostel\-Dorfmark",
"4937608", "Waldenburg\ Sachsen",
"498372", "Obergünzburg",
"493867", "Lübstorf",
"4935247", "Zehren\ Sachsen",
"499729", "Grettstadt",
"498536", "Kösslarn",
"4939455", "Schierke",
"496345", "Albersweiler",
"494465", "Friedeburg\ Ostfriesland",
"499855", "Dentlein\ am\ Forst",
"493501", "Pirna",
"4934491", "Schmölln\ Thüringen",
"499193", "Höchstadt\ an\ der\ Aisch",
"4939052", "Erxleben\ bei\ Haldensleben",
"492266", "Lindlar",
"4938793", "Dergenthin",
"495037", "Bad\ Rehburg",
"4933334", "Greiffenberg",
"497361", "Aalen",
"497951", "Crailsheim",
"4935343", "Hirschfeld\ bei\ Elsterwerda",
"496031", "Friedberg\ Hessen",
"4936258", "Friemar",
"4939328", "Rochau",
"494554", "Wahlstedt",
"492257", "Reckerscheid",
"494496", "Friesoythe\-Markhausen",
"496203", "Ladenburg",
"498258", "Sielenbach",
"496254", "Lautertal\ Odenwald",
"499952", "Eichendorf",
"496861", "Merzig",
"494161", "Buxtehude",
"494503", "Timmendorfer\ Strand",
"499845", "Oberdachstetten",
"4938850", "Gammelin",
"4938224", "Gresenhorst",
"499663", "Neukirchen\ bei\ Sulzbach\-Rosenberg",
"496776", "Dachsenhausen",
"492394", "Neuenrade\-Affeln",
"499638", "Neualbenreuth",
"496085", "Waldsolms",
"497941", "Öhringen",
"495502", "Dransfeld",
"493693", "Meiningen",
"4939484", "Harzgerode",
"4939975", "Thürkow",
"498225", "Jettingen\-Scheppach",
"496397", "Leimen\ Pfalz",
"495846", "Gartow\ Niedersachsen",
"495609", "Ahnatal",
"497729", "Tennenbronn",
"499828", "Rügland",
"498248", "Lamerdingen",
"4933965", "Herzsprung\ bei\ Wittstock",
"494544", "Berkenthin",
"492247", "Neunkirchen\-Seelscheid",
"4939820", "Triepkendorf",
"496244", "Westhofen\ Rheinhessenen",
"499942", "Viechtach",
"494162", "Jork",
"499951", "Landau\ an\ der\ Isar",
"496550", "Irrhausen",
"4935605", "Komptendorf",
"4938320", "Tribsees",
"492359", "Kierspe",
"493391", "Neuruppin",
"496032", "Bad\ Nauheim",
"497193", "Sulzbach\ an\ der\ Murr",
"492543", "Billerbeck\ Westfalen",
"4934364", "Wermsdorf",
"497952", "Gerabronn",
"497362", "Bopfingen",
"494393", "Boostedt",
"495693", "Volkmarsen",
"4936946", "Erbenhausen\ Thüringen",
"496355", "Albisheim\ Pfrimm",
"4933655", "Grunow\ Kreis\ Oder\-Spree",
"498122", "Erding",
"498239", "Langenneufnach",
"495194", "Bispingen",
"495805", "Oetzen",
"498458", "Gaimersheim",
"4935820", "Zodel",
"496403", "Linden\ Hessen",
"494296", "Schwanewede\-Aschwarden",
"499542", "Schesslitz",
"496596", "Üdersdorf",
"494944", "Wiesmoor",
"496454", "Lichtenfels\-Sachsenberg",
"4937325", "Niederbobritzsch",
"4933204", "Beelitz\ Mark",
"4939394", "Hohenberg\-Krusemark",
"498702", "Wörth\ an\ der\ Isar",
"492191", "Remscheid",
"497541", "Friedrichshafen",
"495902", "Freren",
"4935975", "Hohnstein",
"497735", "Öhningen",
"497552", "Pfullendorf",
"498091", "Kirchseeon",
"493902", "Diesdorf\ Altm",
"495159", "Coppenbrügge\-Bisperode",
"492662", "Hachenburg",
"496565", "Dudeldorf",
"494265", "Fintel",
"4939605", "Gross\ Nemerow",
"499164", "Langenfeld\ Mittelfranken",
"499551", "Burgwindheim",
"495071", "Schwarmstedt",
"4937296", "Stollberg\ Erzgebirge",
"494407", "Wardenburg",
"492943", "Erwitte",
"499222", "Presseck",
"494237", "Bendingbostel",
"492534", "Münster\-Roxel",
"4939822", "Kratzeburg",
"494175", "Egestorf\ Nordheide",
"492927", "Neuengeseke",
"496875", "Nonnweiler\-Primstal",
"495473", "Ostercappeln",
"4934746", "Giersleben",
"499746", "Zeitlofs",
"497570", "Sigmaringen\-Gutenstein",
"498506", "Bad\ Höhenstadt",
"497221", "Baden\-Baden",
"49751", "Ravensburg",
"4935365", "Falkenberg\ Elster",
"4934262", "Falkenhain\ bei\ Wurzen",
"497375", "Obermarchtal",
"4933876", "Buschow",
"4938852", "Wittenburg",
"4934604", "Niemberg",
"4938321", "Martensdorf\ bei\ Stralsund",
"499274", "Hollfeld",
"495108", "Gehrden\ Han",
"495745", "Stemwede\-Levern",
"4939407", "Seehausen\ Börde",
"495531", "Holzminden",
"4936741", "Bad\ Blankenburg",
"4939821", "Carpin",
"492687", "Horhausen\ Westerwald",
"494471", "Cloppenburg",
"496684", "Hofbieber\-Schwarzbach",
"4939749", "Grambow\ bei\ Pasewalk",
"493745", "Falkenstein\ Vogtland",
"493531", "Finsterwalde",
"498851", "Kochel\ am\ See",
"4934261", "Kühren\ bei\ Wurzen",
"494533", "Reinfeld\ Holstein",
"496268", "Hüffenhardt",
"496233", "Frankenthal\ Pfalz",
"493473", "Aschersleben\ Sachsen\-Anhalt",
"4936742", "Uhlstädt",
"497586", "Herbertingen",
"496420", "Lahntal",
"4938322", "Richtenberg",
"4938851", "Zarrentin",
"493881", "Grevesmühlen",
"498731", "Dingolfing",
"49791", "Schwäbisch\ Hall",
"498545", "Hofkirchen\ Bayern",
"496336", "Dellfeld",
"4939365", "Bellingen\ bei\ Stendal",
"494272", "Siedenburg",
"497626", "Kandern",
"495706", "Porta\ Westfalica",
"495931", "Meppen",
"4939291", "Calbe\ Saale",
"496572", "Manderscheid\ Eifel",
"492675", "Ediger\-Eller",
"4933457", "Altreetz",
"4935822", "Hagenwerder",
"492527", "Lippetal\-Lippborg",
"494224", "Gross\ Ippener",
"492308", "Unna\-Hemmerde",
"497836", "Schiltach",
"496524", "Rodershausen",
"492934", "Sundern\-Altenhellefeld",
"499148", "Ettenstatt",
"498340", "Baisweil",
"497066", "Bad\ Rappenau\-Bonfeld",
"495126", "Algermissen",
"496183", "Erlensee",
"494883", "Süderstapel",
"495658", "Wehretal",
"492223", "Königswinter",
"494358", "Loose\ bei\ Eckernförde",
"494968", "Neulehe",
"497474", "Haigerloch",
"494933", "Dornum\ Ostfriesland",
"499289", "Schwarzenbach\ am\ Wald",
"496887", "Schmelz\ Saar",
"494187", "Holm\-Seppensen",
"4939292", "Biederitz",
"499421", "Straubing",
"4933633", "Spreenhagen",
"4935028", "Krippen",
"497158", "Neuhausen\ auf\ den\ Fildern",
"493931", "Stendal",
"497387", "Hohenstein\ Württemberg",
"497422", "Schramberg",
"4938292", "Kröpelin",
"492984", "Hallenberg",
"4933875", "Rhinow",
"4935322", "Doberlug\-Kirchhain",
"498551", "Freyung",
"4939399", "Kleinau",
"494833", "Wesselburen",
"493621", "Gotha\ Thüringen",
"496133", "Oppenheim",
"4933478", "Gross\ Neuendorf",
"4933209", "Caputh",
"4933762", "Zeuthen",
"497425", "Trossingen",
"498781", "Rottenburg\ an\ der\ Laaber",
"495323", "Clausthal\-Zellerfeld",
"496386", "Altenkirchen\ Pfalz",
"4933920", "Walsleben\ bei\ Neuruppin",
"494623", "Böklund",
"493831", "Stralsund",
"4939772", "Rothemühl",
"497448", "Seewald",
"499091", "Monheim\ Schwaben",
"4934745", "Winningen\ Sachsen\-Anhalt",
"4935058", "Pretzschendorf",
"496056", "Bad\ Soden\-Salmünster",
"495208", "Leopoldshöhe",
"496627", "Nentershausen\ Hessen",
"499174", "Hilpoltstein",
"492624", "Höhr\-Grenzhausen",
"495831", "Wittingen",
"49781", "Offenburg",
"498806", "Utting\ am\ Ammersee",
"497121", "Reutlingen",
"498649", "Schleching",
"497337", "Nellingen\ Alb",
"493981", "Neustrelitz",
"492064", "Dinslaken",
"498542", "Ortenburg",
"49631", "Kaiserslautern",
"492834", "Straelen",
"497936", "Schrozberg\-Bartenstein",
"495621", "Bad\ Wildungen",
"494275", "Ehrenburg",
"494321", "Neumünster",
"492672", "Treis\-Karden",
"496575", "Landscheid",
"4934638", "Zöschen",
"494137", "Barendorf",
"496837", "Wallerfangen",
"499122", "Schwabach",
"4939771", "Ueckermünde",
"4936482", "Triptis",
"4939058", "Uthmöden",
"497258", "Oberderdingen\-Flehingen",
"496757", "Becherbach\ bei\ Kirn",
"4935772", "Rietschen",
"4938821", "Lüdersdorf",
"4938352", "Kemnitz\ bei\ Greifswald",
"492754", "Bad\ Laasphe\-Feudingen",
"4937601", "Mülsen\ Skt\ Jacob",
"4936252", "Tambach\-Dietharz",
"495751", "Rinteln",
"4939851", "Göritz\ bei\ Prenzlau",
"4939489", "Strassberg\ Harz",
"496587", "Zerf",
"4939322", "Tangermünde",
"499189", "Berg\ bei\ Neumarkt\ in\ der\ Oberpfalz",
"4939366", "Kehnert",
"494287", "Heeslingen\-Boitzen",
"492584", "Warendorf\-Milte",
"4938229", "Bad\ Sülze",
"4937360", "Olbernhau",
"499673", "Tiefenbach\ Oberpfalz",
"498361", "Nesselwang",
"496766", "Kisselbach",
"495226", "Bruchmühlen\ Westfalen",
"498023", "Bayrischzell",
"4936481", "Neustadt\ an\ der\ Orla",
"496283", "Hardheim\ Odenwald",
"4934498", "Rositz",
"492827", "Goch\-Hassum",
"4938351", "Mesekenhagen",
"4935771", "Bad\ Muskau",
"4938822", "Diedrichshagen\ bei\ Grevesmühlen",
"494124", "Glückstadt",
"496824", "Ottweiler",
"495742", "Preussisch\ Oldendorf",
"499225", "Stadtsteinach",
"496634", "Gemünden\ Felda",
"498638", "Waldkraiburg",
"4939321", "Arneburg",
"496872", "Losheim\ am\ See",
"494172", "Salzhausen",
"4939852", "Schönermark\ bei\ Prenzlau",
"492637", "Weissenthurm",
"499371", "Miltenberg",
"498663", "Ruhpolding",
"4937602", "Kirchberg\ Sachsen",
"4936640", "Remptendorf",
"4936085", "Reinholterode",
"494704", "Drangstedt",
"493581", "Görlitz",
"497324", "Herbrechtingen",
"498845", "Bad\ Kohlgrub",
"494753", "Balje",
"496669", "Neuhof\-Hauswurz",
"4933966", "Dranse",
"4933922", "Karwesee",
"498421", "Eichstätt\ Bayern",
"492843", "Rheinberg",
"496029", "Mömbris",
"4933760", "Münchehofe\ Kreis\ Dahme\-Spreewald",
"497555", "Deggenhausertal",
"496562", "Speicher",
"493546", "Lübben\ Spreewald",
"494262", "Visselhövede",
"4939976", "Gross\ Bützin",
"499340", "Königheim\-Brehmen",
"494844", "Pellworm",
"496144", "Bischofsheim\ bei\ Rüsselsheim",
"498705", "Altfraunhofen",
"497732", "Radolfzell\ am\ Bodensee",
"4933921", "Zechlinerhütte",
"495546", "Scheden",
"495905", "Beesten",
"499528", "Donnersdorf",
"4933656", "Bahro",
"499307", "Altertheim",
"4936945", "Henneberg",
"497464", "Talheim\ Kreis\ Tuttlingen",
"495802", "Wrestedt",
"4935606", "Briesen\ bei\ Cottbus",
"4934979", "Wulfen\ Sachsen\-Anhalt",
"499545", "Buttenheim",
"4933733", "Stülpe",
"499906", "Mariaposching",
"492696", "Nohn\ Eifel",
"4937362", "Seiffen\ Erzgebirge",
"497955", "Wallhausen\ Württemberg",
"499409", "Pielenhofen",
"497365", "Essingen\ Württemberg",
"4937326", "Frauenstein\ Sachsen",
"4934609", "Salzmünde",
"4939320", "Schinne",
"496352", "Kirchheimbolanden",
"499264", "Küps",
"493946", "Quedlinburg",
"499851", "Dinkelsbühl",
"496865", "Mettlach\-Orscholz",
"494165", "Hollenstedt\ Nordheide",
"495259", "Bad\ Driburg\-Neuenheerse",
"4935894", "Hähnichen",
"496035", "Reichelsheim\ Wetterau",
"496643", "Herbstein",
"497852", "Willstätt",
"495438", "Bakum\-Lüsche",
"4938484", "Ventschow",
"497841", "Achern",
"4939606", "Glienke",
"497777", "Sauldorf",
"492291", "Waldbröl",
"495300", "Salzgitter\-Üfingen",
"498274", "Buttenwiesen",
"4937361", "Neuhausen\ Erzgebirge",
"4939224", "Büden",
"499493", "Beratzhausen",
"495347", "Burgdorf\ bei\ Salzgitter",
"4937295", "Lugau\ Erzgebirge",
"4937600", "Neumark\ Sachsen",
"4936642", "Harra",
"499945", "Arnbruck",
"49202", "Wuppertal",
"496341", "Landau\ in\ der\ Pfalz",
"494461", "Jever",
"4939744", "Rothenklempenow",
"499842", "Uffenheim",
"4933238", "Senzke",
"495294", "Hövelhof\-Espeln",
"499928", "Kirchdorf\ im\ Wald",
"495946", "Georgsdorf",
"498222", "Burgau\ Schwaben",
"495505", "Hardegsen",
"498139", "Röhrmoos",
"496082", "Niederreifenberg",
"497264", "Bad\ Rappenau",
"497851", "Kehl",
"4936373", "Buttstädt",
"492733", "Hilchenbach",
"498586", "Hauzenberg",
"4936029", "Menteroda",
"493395", "Pritzwalk",
"495357", "Grasleben",
"499955", "Mamming",
"499365", "Rimpar",
"498756", "Nandlstadt",
"499852", "Feuchtwangen",
"496351", "Eisenberg\ Pfalz",
"499560", "Grub\ am\ Forst",
"4935456", "Terpt",
"494666", "Ladelund",
"4938328", "Miltzow",
"495366", "Jembke",
"495956", "Rastdorf",
"496081", "Usingen",
"497945", "Wüstenrot",
"49851", "Passau",
"498221", "Günzburg",
"4939828", "Wustrow\ Kreis\ Mecklenburg\-Strelitz",
"497506", "Wangen\-Leupolz",
"4935843", "Hirschfelde\ bei\ Zittau",
"498375", "Weitnau",
"499396", "Urspringen\ bei\ Lohr",
"499841", "Bad\ Windsheim",
"496342", "Schweigen\-Rechtenbach",
"4939425", "Dingelstedt\ am\ Huy",
"494462", "Wittmund",
"493366", "Beeskow",
"499777", "Ostheim\ von\ der\ Rhön",
"4938377", "Zinnowitz",
"4938455", "Plaaz",
"494734", "Stadland\-Seefeld",
"4933834", "Pritzerbe",
"496653", "Burghaun",
"493967", "Oertzenhof\ bei\ Strasburg",
"492607", "Kobern\-Gondorf",
"4935939", "Hochkirch",
"492292", "Windeck\ Sieg",
"4938858", "Lassahn",
"497842", "Kappelrodeck",
"499350", "Eussenheim\-Hundsbach",
"494854", "Friedrichskoog",
"496154", "Ober\-Ramstadt",
"494261", "Rotenburg\ Wümme",
"492157", "Nettetal\-Kaldenkirchen",
"499076", "Wittislingen",
"494803", "Pahlen",
"498158", "Tutzing",
"496561", "Bitburg",
"496103", "Langen\ Hessen",
"498387", "Weiler\-Simmerberg",
"49371", "Chemnitz\ Sachsen",
"4939298", "Barby\ Elbe",
"495556", "Lindau\ Harz",
"498095", "Aying",
"495494", "Holdorf\ Niedersachsen",
"492388", "Hamm\-Uentrop",
"4935022", "Bad\ Schandau",
"4939456", "Altenbrak",
"498422", "Dollnstein",
"496723", "Oestrich\-Winkel",
"492166", "Mönchengladbach\-Rheydt",
"496478", "Greifenstein\-Ulm",
"4938426", "Neuburg\-Steinhausen",
"4935793", "Elstra",
"4938462", "Baumgarten",
"4989", "Munich",
"499293", "Berg\ Oberfranken",
"499555", "Schlüsselfeld\-Aschbach",
"4935877", "Cunewalde",
"497307", "Senden\ Iller",
"497528", "Neukirch\ bei\ Tettnang",
"499732", "Hammelburg",
"495459", "Hörstel",
"4935021", "Königstein\ Sächsische\ Schweiz",
"495238", "Nieheim\-Himmighausen",
"497340", "Neenstetten",
"498066", "Bad\ Feilnbach",
"495263", "Barntrup",
"499209", "Emtmannsberg",
"4938461", "Bützow",
"492853", "Schermbeck",
"494107", "Siek\ Kreis\ Stormarn",
"499080", "Harburg\ Schwaben",
"492195", "Radevormwald",
"497545", "Immenstaad\ am\ Bodensee",
"492804", "Xanten\-Marienbaum",
"4935828", "Reichenbach\ OL",
"497906", "Braunsbach",
"4937384", "Wechselburg",
"497731", "Singen\ Hohentwiel",
"49571", "Minden\ Westfalen",
"492058", "Wülfrath",
"498057", "Aschau\-Sachrang",
"493494", "Wolfen",
"4938727", "Mestlin",
"494140", "Estorf\ Kreis\ Stade",
"499464", "Walderbach",
"493741", "Plauen",
"493877", "Wittenberge",
"498362", "Füssen",
"493535", "Herzberg\ Elster",
"495173", "Uetze",
"494475", "Molbergen",
"495752", "Auetal\-Hattendorf",
"499439", "Neunburg\-Kemnath",
"497673", "Schönau\ im\ Schwarzwald",
"495582", "Sankt\ Andreasberg",
"498193", "Geltendorf",
"494743", "Langen\ bei\ Bremerhaven",
"499536", "Kirchlauter",
"496747", "Emmelshausen",
"499372", "Klingenberg\ am\ Main",
"494171", "Winsen\ Luhe",
"497248", "Marxzell",
"496871", "Wadern",
"492744", "Herdorf",
"494630", "Barderup",
"495741", "Lübbecke",
"499324", "Dettelbach",
"495535", "Polle",
"496120", "Aarbergen",
"497371", "Riedlingen\ Württemberg",
"4937465", "Tannenbergsthal\ Vogtland",
"497225", "Gaggenau",
"496046", "Ortenberg\ Hessen",
"494769", "Bremervörde\-Iselersheim",
"499092", "Wemding",
"4934424", "Reuden\ bei\ Zeitz",
"492373", "Menden\ Sauerland",
"4936963", "Dorndorf\ Rhön",
"493529", "Heidenau\ Sachsen",
"498782", "Pfeffenhausen",
"4937203", "Gersdorf\ bei\ Chemnitz",
"496483", "Selters\ Taunus",
"4935020", "Struppen",
"498860", "Bernbeuren",
"495426", "Glandorf",
"499448", "Hausen\ Niederbayern",
"493622", "Waltershausen\ Thüringen",
"498552", "Grafenau\ Niederbayern",
"493935", "Tangerhütte",
"499337", "Gaukönigshofen",
"492671", "Cochem",
"494322", "Bordesholm",
"497702", "Blumberg\ Baden",
"49981", "Ansbach",
"495622", "Fritzlar",
"494487", "Grossenkneten\-Huntlosen",
"495935", "Twist\-Schöninghsdorf",
"496698", "Schrecksbach",
"498735", "Gangkofen\-Kollbach",
"497174", "Mögglingen",
"4936653", "Lehesten\ Thüringer\ Wald",
"498541", "Vilshofen\ Niederbayern",
"4936464", "Wormstedt",
"497122", "St\ Johann\ Württemberg",
"495062", "Holle\ bei\ Hildesheim",
"499936", "Wallerfing",
"499701", "Sandberg\ Unterfranken",
"495832", "Hankensbüttel",
"4934923", "Cobbelsdorf",
"497458", "Ebhausen",
"4936736", "Arnsgereuth",
"495674", "Grebenstein",
"495529", "Rhumspringe",
"497235", "Unterreichenbach\ Kreis\ Calw",
"494976", "Spiekeroog",
"498202", "Althegnenberg",
"499334", "Giebelstadt",
"494830", "Süderhastedt",
"495525", "Walkenried",
"4933239", "Gross\ Behnitz",
"496130", "Schwabenheim\ an\ der\ Selz",
"494484", "Hude\-Wüsting",
"499908", "Schöfweg",
"495320", "Torfhaus",
"498146", "Moorenweis",
"495939", "Sustrum",
"494796", "Teufelsmoor",
"495677", "Calden\-Westuffeln",
"499526", "Riedbach",
"4936693", "Crossen\ an\ der\ Elster",
"4933831", "Weseram",
"496373", "Schönenberg\-Kübelberg",
"493677", "Ilmenau\ Thüringen",
"499281", "Hof\ Saale",
"494765", "Ebersdorf\ bei\ Bremervörde",
"499429", "Rain\ Niederbayern",
"4933832", "Rogäsen",
"493525", "Riesa",
"4933986", "Falkenhagen\ Kreis\ Prignitz",
"49961", "Weiden\ in\ der\ Oberpfalz",
"495822", "Ebstorf",
"496744", "Oberwesel",
"4934978", "Radegast\ Kreis\ Köthen",
"496898", "Völklingen",
"492747", "Molzhain",
"492871", "Bocholt",
"498105", "Gilching",
"497229", "Iffezheim",
"495948", "Itterbeck",
"4935024", "Stadt\ Wehlen",
"496093", "Laufach",
"493685", "Hildburghausen",
"497132", "Neckarsulm",
"499926", "Frauenau",
"498725", "Wurmannsquick",
"4937381", "Penig",
"496276", "Hesseneck",
"4938464", "Bernitt",
"499131", "Erlangen",
"4938736", "Goldberg",
"494332", "Hamdorf\ bei\ Rendsburg",
"495874", "Soltendieck",
"499482", "Wörth\ an\ der\ Donau",
"495632", "Willingen\ Upland",
"4936967", "Geisa",
"495925", "Wietmarschen",
"4937207", "Hainichen\ Sachsen",
"498020", "Weyarn",
"4934927", "Globig\-Bleddin",
"493874", "Ludwigslust",
"495436", "Nortrup",
"493632", "Sondershausen",
"493925", "Stassfurt",
"4937382", "Geringswalde",
"495685", "Knüllwald",
"499435", "Schwarzenfeld",
"494479", "Molbergen\-Peheim",
"494385", "Hohenfelde\ bei\ Kiel",
"499205", "Vorbach",
"493564", "Schwarze\ Pumpe",
"499641", "Grafenwöhr",
"497304", "Blaustein\ Württemberg",
"497353", "Schwendi",
"497963", "Adelmannsfelden",
"495142", "Eschede",
"494724", "Cuxhaven\-Lüdingworth",
"497938", "Mulfingen\ Jagst",
"495455", "Tecklenburg\-Brochterbeck",
"498054", "Breitbrunn\ am\ Chiemsee",
"495206", "Bielefeld\-Jöllenbeck",
"496058", "Gründau",
"4936377", "Rastenberg",
"494772", "Oberndorf\ Oste",
"499467", "Michelsneukirchen",
"496195", "Kelkheim\ Taunus",
"494104", "Aumühle\ bei\ Hamburg",
"498231", "Königsbrunn\ bei\ Augsburg",
"497642", "Endingen\ Kaiserstuhl",
"496804", "Mandelbachtal",
"498808", "Pähl",
"494153", "Lauenburg\ Elbe",
"496853", "Marpingen",
"498384", "Röthenbach\ Allgäu",
"4938373", "Katzow",
"4933830", "Ziesar",
"4935753", "Grossräschen",
"499343", "Lauda\-Königshofen",
"4938228", "Dettmannsdorf\-Kölzow",
"497651", "Titisee\-Neustadt",
"4939885", "Jakobshagen",
"494857", "Barlt",
"496157", "Pfungstadt",
"492561", "Ahaus",
"492103", "Hilden",
"4939488", "Güntersberge",
"492154", "Willich",
"497446", "Lossburg",
"4939059", "Wegenstedt",
"495151", "Hameln",
"499652", "Waidhaus",
"4935386", "Prettin",
"495564", "Dassel",
"4933703", "Sperenberg",
"496166", "Fischbachtal",
"492723", "Kirchhundem",
"497083", "Bad\ Herrenalb",
"498636", "Ampfing",
"4934466", "Janisroda",
"495245", "Herzebrock\-Clarholz",
"4934422", "Osterfeld",
"4935797", "Schwepnitz",
"4934639", "Wallendorf\ Luppe",
"499774", "Oberelsbach",
"499102", "Wilhermsdorf",
"4935873", "Herrnhut",
"497721", "Villingen\ im\ Schwarzwald",
"495601", "Schauenburg",
"495084", "Hambühren",
"498379", "Waltenhofen\-Oberdorf",
"493964", "Bredenfelde\ bei\ Strasburg",
"492604", "Nassau\ Lahn",
"499246", "Pegnitz\-Trockau",
"492653", "Kaisersesch",
"497949", "Pfedelbach\-Untersteinbach",
"493303", "Birkenwerder",
"4936461", "Bad\ Sulza",
"495228", "Vlotho\-Exter",
"496292", "Seckach",
"497563", "Kisslegg",
"499722", "Werneck",
"494737", "Stadland\-Schwei",
"49345", "Halle\ Saale",
"494603", "Havetoft",
"495964", "Lähden",
"495354", "Jerxheim",
"4939386", "Seehausen\ Altmark",
"495303", "Wendeburg",
"497267", "Gemmingen",
"496733", "Gau\-Odernheim",
"4938723", "Kladrum",
"498764", "Mauern\ Kreis\ Freising",
"4939398", "Gross\ Garz",
"4933479", "Küstrin\-Kietz",
"4936462", "Ossmannstedt",
"4933208", "Fahrland",
"4939753", "Strasburg",
"498432", "Burgheim",
"4936426", "Ottendorf\ bei\ Stadtroda",
"499369", "Uettingen",
"497256", "Philippsburg",
"492351", "Lüdenscheid",
"492961", "Brilon",
"493601", "Mühlhausen\ Thüringen",
"495344", "Lengede",
"4938294", "Neubukow",
"4933436", "Prötzel",
"499721", "Schweinfurt",
"4935324", "Crinitz",
"494644", "Karby",
"496291", "Adelsheim",
"498135", "Sulzemoos",
"497774", "Eigeltingen",
"495509", "Rosdorf\ Kreis\ Göttingen",
"4933764", "Mittenwalde\ Mark",
"495602", "Hessisch\ Lichtenau",
"497722", "Triberg\ im\ Schwarzwald",
"499563", "Rödental",
"499101", "Langenzenn",
"494302", "Kirchbarkau",
"4939774", "Mönkebude",
"497246", "Malsch\ Kreis\ Karlsruhe",
"495255", "Altenbeken",
"495593", "Bovenden\-Lenglern",
"492352", "Altena\ Westfalen",
"492962", "Olsberg",
"499267", "Nordhalben",
"494169", "Sauensiek",
"495406", "Belm",
"496869", "Merzig\-Silwingen",
"498431", "Neuburg\ an\ der\ Donau",
"496039", "Karben",
"493344", "Bad\ Freienwalde",
"499256", "Stammbach",
"499405", "Bad\ Abbach",
"497959", "Frankenhardt",
"492643", "Altenahr",
"4936605", "Bad\ Köstritz",
"496650", "Hosenfeld",
"498573", "Ering",
"492865", "Raesfeld",
"499963", "Konzell",
"499353", "Karlstadt",
"493445", "Naumburg\ Saale",
"499938", "Moos\ Niederbayern",
"497641", "Emmendingen",
"4936484", "Knau\ bei\ Pössneck",
"498232", "Schwabmünchen",
"49203", "Duisburg",
"4934906", "Raguhn",
"494771", "Hemmoor",
"494847", "Oster\-Ohrstedt",
"4933338", "Stolpe\/Oder",
"496147", "Trebur",
"499549", "Lisberg",
"4935774", "Boxberg\ Sachsen",
"497456", "Haiterbach",
"4938354", "Wusterhusen",
"498709", "Eching\ Niederbayern",
"4939324", "Kläden\ bei\ Stendal",
"496696", "Gilserberg",
"4936254", "Friedrichswerth",
"495141", "Celle",
"493773", "Johanngeorgenstadt",
"499642", "Kemnath\ Stadt",
"497467", "Neuhausen\ ob\ Eck",
"495909", "Wettrup",
"499446", "Altmannstein",
"498285", "Burtenbach",
"495773", "Stemwede\-Wehdem",
"495428", "Melle\-Neuenkirchen",
"4938824", "Mallentin",
"499651", "Vohenstrauss",
"4939740", "Nechlin",
"497343", "Buch\ bei\ Illertissen",
"493909", "Klötze\ Altmark",
"495152", "Hessisch\ Oldendorf",
"492850", "Rees\-Haldern",
"495445", "Drebber",
"499083", "Möttingen",
"4937604", "Mosel",
"492562", "Gronau\ Westfalen",
"496665", "Sinntal\-Altengronau",
"496048", "Büdingen\-Eckartshausen",
"4939854", "Kleptow",
"497652", "Hinterzarten",
"494143", "Drochtersen",
"496843", "Gersheim",
"492824", "Kalkar",
"499481", "Pfatter",
"495631", "Korbach",
"494331", "Rendsburg",
"499229", "Mainleus",
"494127", "Westerhorn",
"499132", "Herzogenaurach",
"492975", "Schmallenberg\-Oberkirchen",
"496827", "Eppelborn",
"49761", "Freiburg\ im\ Breisgau",
"4933924", "Rägelin",
"4935829", "Gersdorf\ bei\ Görlitz",
"497482", "Horb\-Dettingen",
"494707", "Langen\-Neuenwalde",
"497131", "Heilbronn\ Neckar",
"4934296", "Groitzsch\ bei\ Pegau",
"497327", "Dischingen",
"492872", "Rhede\ Westfalen",
"49511", "Hannover",
"496637", "Feldatal",
"494740", "Loxstedt\-Dedesdorf",
"492634", "Rengsdorf",
"499398", "Birkenfeld\ bei\ Würzburg",
"495821", "Bad\ Bevensen",
"4938391", "Altenkirchen\ Rügen",
"4936043", "Kirchheilingen",
"499185", "Mühlhausen\ Oberpfalz",
"496754", "Martinstein",
"496703", "Wöllstein\ Rheinhessen",
"495333", "Dettum",
"495368", "Parsau",
"494668", "Klanxbüll",
"494633", "Satrup",
"493821", "Ribnitz\-Damgarten",
"4939086", "Jävenitz",
"495186", "Salzhemmendorf\-Wallensen",
"494823", "Wilster",
"493631", "Nordhausen\ Thüringen",
"496123", "Eltville\ am\ Rhein",
"497435", "Albstadt\-Laufen",
"4938392", "Sassnitz",
"4934325", "Mochau\-Lüttewitz",
"498402", "Münchsmünster",
"4935266", "Heyda\ bei\ Riesa",
"496584", "Wellen\ Mosel",
"494284", "Selsingen",
"492587", "Ennigerloh\-Westkirchen",
"4937364", "Reitzenhain\ Erzgebirge",
"4935938", "Grosspostwitz\ OL",
"4938859", "Alt\ Zachun",
"4938481", "Witzin",
"497334", "Deggingen",
"499235", "Thierstein",
"496624", "Heringen\ Werra",
"499177", "Heideck",
"492056", "Heiligenhaus",
"498628", "Kienberg\ Oberbayern",
"4939221", "Möckern\ bei\ Magdeburg",
"4934783", "Gerbstedt",
"492627", "Braubach",
"496672", "Eiterfeld",
"492837", "Weeze",
"492575", "Greven\-Reckenfeld",
"4935892", "Horka\ OL",
"49231", "Dortmund",
"494134", "Embsen\ Kreis\ Lüneburg",
"4939741", "Jatznick",
"496834", "Bous",
"495236", "Blomberg\-Grossenmarpe",
"4936077", "Grossbodungen",
"498033", "Oberaudorf",
"4939829", "Blankenförde",
"4938482", "Warin",
"492133", "Dormagen",
"498167", "Zolling",
"496476", "Mengerskirchen",
"4939222", "Möser",
"4936644", "Hirschberg\ Saale",
"4939266", "Förderstedt",
"499282", "Naila",
"4933845", "Borkheide",
"4939742", "Brüssow\ bei\ Pasewalk",
"499078", "Mertingen",
"4936028", "Kammerforst\ Thüringen",
"4934775", "Wippra",
"4935891", "Rothenburg\ OL",
"499873", "Abenberg\-Wassermungenau",
"497429", "Egesheim",
"497943", "Schöntal\ Jagst",
"495162", "Fallingbostel",
"497022", "Nürtingen",
"493691", "Eisenach\ Thüringen",
"495250", "Delbrück\ Westfalen",
"498373", "Altusried",
"499661", "Sulzbach\-Rosenberg",
"493544", "Luckau\ Brandenburg",
"4934925", "Bad\ Schmiedeberg",
"497569", "Isny\-Eisenbach",
"497662", "Vogtsburg\ im\ Kaiserstuhl",
"492552", "Steinfurt\-Borghorst",
"499447", "Essing",
"496655", "Neuhof\ Kreis\ Fulda",
"497466", "Beuron",
"492541", "Coesfeld",
"497191", "Backnang",
"492735", "Neunkirchen\ Siegerl",
"494488", "Westerstede",
"496202", "Schwetzingen",
"499904", "Lalling",
"496697", "Willingshausen",
"499953", "Pilsting",
"498671", "Altötting",
"499363", "Arnstein\ Unterfranken",
"499338", "Röttingen\ Unterfranken",
"492694", "Wershofen",
"494502", "Lübeck\-Travemünde",
"496146", "Hochheim\ am\ Main",
"495309", "Lehre\-Wendhausen",
"495691", "Bad\ Arolsen",
"494846", "Hattstedt",
"494609", "Eggebek",
"499192", "Gräfenberg",
"497457", "Rottenburg\-Ergenzingen",
"495544", "Reinhardshagen",
"4935436", "Laasow\ bei\ Calau",
"4936965", "Stadtlengsfeld",
"496020", "Heigenbrücken",
"496401", "Grünberg\ Hessen",
"499257", "Zell\ Oberfranken",
"494159", "Basthorst",
"495265", "Dörentrup",
"4939959", "Dargun",
"492952", "Rüthen",
"492362", "Dorsten",
"4937463", "Bergen\ Vogtland",
"4937342", "Cranzahl",
"492855", "Voerde\ Niederrhein",
"496660", "Steinau\-Marjoss",
"497543", "Kressbronn\ am\ Bodensee",
"492193", "Dabringhausen",
"493944", "Blankenburg\ Harz",
"499266", "Mitwitz",
"495407", "Wallenhorst",
"4937430", "Eichigt",
"498744", "Gerzen",
"4935696", "Briesnig",
"496105", "Mörfelden\-Walldorf",
"494805", "Schafstedt",
"497247", "Linkenheim\-Hochstetten",
"494194", "Sievershütten",
"496894", "St\ Ingbert",
"498093", "Glonn\ Kreis\ Ebersberg",
"4934956", "Zörbig",
"4938304", "Garz\ Rügen",
"495944", "Hoogstede",
"4936204", "Stotternheim",
"492941", "Lippstadt",
"496725", "Gau\-Algesheim",
"499349", "Werbach\-Wenkheim",
"495073", "Neustadt\-Esperke",
"497394", "Schelklingen",
"4937341", "Ehrenfriedersdorf",
"498276", "Baar\ Schwaben",
"4936626", "Auma",
"499553", "Ebrach\ Oberfranken",
"499295", "Töpen",
"494902", "Jemgum\-Ditzum",
"4933679", "Wendisch\ Rietz",
"499504", "Stadelhofen",
"492422", "Kreuzau",
"499180", "Pyrbaum",
"496384", "Konken",
"498388", "Hergensweiler",
"495471", "Bohmte",
"492387", "Drensteinfurt\-Walstedde",
"492158", "Grefrath\ bei\ Krefeld",
"498157", "Feldafing",
"4938796", "Viesecke",
"495533", "Bodenwerder",
"492474", "Nideggen\-Schmidt",
"4933742", "Oehna\ Brandenburg",
"4938788", "Gross\ Warnow",
"496477", "Greifenstein\-Nenderoth",
"497223", "Bühl\ Baden",
"498166", "Allershausen\ Oberbayern",
"493533", "Elsterwerda",
"492066", "Duisburg\-Homberg",
"495237", "Augustdorf",
"495175", "Lehrte\-Arpke",
"4935795", "Königsbrück",
"497934", "Weikersheim",
"494473", "Emstek",
"492836", "Wachtendonk",
"497527", "Wolfegg",
"497308", "Nersingen",
"496054", "Birstein",
"497675", "Bernau\ Baden",
"499176", "Allersberg",
"496003", "Rosbach\ von\ der\ Höhe",
"492626", "Selters\ Westerwald",
"493471", "Bernburg\ Saale",
"49291", "Meschede",
"496231", "Hochdorf\-Assenheim",
"4933741", "Niedergörsdorf",
"498195", "Weil\ Kreis\ Landsberg\ am\ Lech",
"494531", "Bad\ Oldesloe",
"494745", "Bad\ Bederkesa",
"494108", "Rosengarten\ Kreis\ Harburg",
"4938453", "Mistorf",
"4933086", "Grieben\ Kreis\ Oberhavel",
"4939887", "Gerswalde",
"495933", "Lathen",
"495358", "Bahrdorf\-Mackendorf",
"4939346", "Tucheim",
"492586", "Beelen",
"495187", "Delligsen",
"498733", "Mengkofen",
"493883", "Hagenow",
"496764", "Rheinböllen",
"494881", "Friedrichstadt",
"496181", "Hanau",
"496432", "Diez",
"4938202", "Volkenshagen",
"4939423", "Wegeleben",
"4937431", "Mehltheuer\ Vogtland",
"499423", "Geiselhöring",
"4939924", "Stuer",
"496636", "Romrod",
"499778", "Fladungen",
"494931", "Norden",
"494706", "Schiffdorf",
"495272", "Brakel\ Westfalen",
"492375", "Balve",
"49251", "Münster",
"497326", "Neresheim",
"4938201", "Gelbensande",
"495224", "Enger\ Westfalen",
"496485", "Nentershausen\ Westerwald",
"493933", "Genthin",
"498292", "Dinkelscherben",
"493968", "Schönbeck",
"492608", "Welschneudorf",
"4936375", "Kindelbrück",
"49209", "Gelsenkirchen",
"498640", "Reit\ Im\ Winkl",
"4937432", "Pausa\ Vogtland",
"495883", "Lemgow",
"496826", "Bexbach",
"497534", "Reichenau\ Baden",
"494126", "Horst\ Holstein",
"49212", "Solingen",
"498869", "Kinsau",
"496431", "Limburg\ an\ der\ Lahn",
"496182", "Seligenstadt",
"4936928", "Neuenhof\ Thüringen",
"498039", "Rott\ am\ Inn",
"494882", "Lunden",
"495437", "Menslage",
"496216", "Ludwigshafen",
"494273", "Kirchdorf\ bei\ Sulingen",
"4937293", "Eppendorf\ Sachsen",
"498650", "Marktschellenberg",
"4934658", "Hayn\ Harz",
"496573", "Gillenfeld",
"493437", "Grimma",
"499326", "Markt\ Einersheim",
"496135", "Bodenheim\ Rhein",
"492274", "Elsdorf\ Rheinland",
"494835", "Albersdorf\ Holstein",
"495520", "Braunlage",
"498291", "Zusmarshausen",
"497423", "Oberndorf\ am\ Neckar",
"499534", "Burgpreppach",
"495325", "Goslar\-Hahnenklee",
"492222", "Bornheim\ Rheinland",
"495271", "Höxter",
"494625", "Jübek",
"499927", "Kirchberg\ Wald",
"494932", "Norderney",
"496285", "Walldürn\-Altheim",
"4939998", "Loitz\ bei\ Demmin",
"495424", "Bad\ Rothenfelde",
"498025", "Miesbach",
"4938331", "Rakow\ Vorpom",
"496044", "Schotten\ Hessen",
"499223", "Rugendorf",
"498665", "Inzell",
"4939832", "Wesenberg",
"495472", "Bad\ Essen",
"4936607", "Niederpöllnitz",
"494755", "Ihlienworth",
"4936943", "Bettenhausen\ Thüringen",
"492421", "Düren",
"499527", "Knetzgau",
"494532", "Bargteheide",
"494829", "Wewelsfleth",
"496129", "Schlangenbad",
"496232", "Speyer",
"4939038", "Henningen",
"4938332", "Gross\ Bisdorf",
"495676", "Liebenau\ Hessen",
"4939831", "Feldberg",
"496709", "Fürfeld\ Kreis\ Bad\ Kreuznach",
"494639", "Schafflund",
"497176", "Spraitbach",
"494977", "Blomberg\ Ostfriesland",
"499675", "Altendorf\ am\ Nabburg",
"495339", "Gielde",
"498754", "Volkenschwand",
"4936083", "Uder",
"497257", "Bruchsal\-Untergrombach",
"496758", "Waldböckelheim",
"498703", "Essenbach",
"494664", "Neukirchen\ bei\ Niebüll",
"495903", "Emsbüren",
"4933847", "Görzke",
"4933636", "Steinhöfel\ Kreis\ Oder\-Spree",
"495954", "Lorup",
"495364", "Velpke",
"498123", "Moosinning",
"497266", "Kirchardt",
"492951", "Büren",
"492361", "Recklinghausen",
"4939009", "Badel",
"499359", "Karlstadt\-Wiesenfeld",
"498584", "Breitenberg\ Niederbayern",
"496402", "Hungen",
"499543", "Hirschaid",
"494288", "Horstedt\ Kreis\ Rotenburg",
"4933398", "Werneuchen",
"496588", "Pluwig",
"4939208", "Loitsche",
"494736", "Butjadingen\-Tossens",
"499089", "Bissingen\-Unterringingen",
"492828", "Emmerich\-Elten",
"494149", "Fredenbeck",
"496849", "Kirkel",
"492942", "Geseke",
"492845", "Neukirchen\-Vluyn",
"497504", "Horgenzell",
"497553", "Salem\ Baden",
"492663", "Westerburg\ Westerwald",
"498637", "Lohkirchen",
"499394", "Esselbach",
"492638", "Waldbreitbach",
"4936075", "Dingelstädt\ Eichsfeld",
"496190", "Hattersheim\ am\ Main",
"493364", "Eisenhüttenstadt",
"492164", "Jüchen\-Otzenrath",
"499569", "Sesslach",
"496167", "Modautal",
"492551", "Steinfurt\-Burgsteinfurt",
"4936334", "Wolkramshausen",
"497661", "Kirchzarten",
"499495", "Breitenbrunn\ Oberpfalz",
"4935208", "Radeburg",
"499943", "Lam\ Oberpfalz",
"494856", "Kronprinzenkoog",
"4938234", "Born\ Darss",
"499074", "Höchstädt\ an\ der\ Donau",
"497447", "Baiersbronn\-Schwarzenberg",
"499662", "Vilseck",
"4934327", "Waldheim\ Sachsen",
"495554", "Moringen",
"497021", "Kirchheim\ unter\ Teck",
"495161", "Walsrode",
"495503", "Nörten\-Hardenberg",
"497363", "Lauchheim",
"497953", "Blaufelden",
"4939863", "Seehausen\ bei\ Prenzlau",
"497904", "Ilshofen",
"498624", "Obing",
"499191", "Forchheim\ Oberfranken",
"4934743", "Ermsleben",
"493496", "Köthen\ Anhalt",
"494392", "Nortorf\ bei\ Neumünster",
"495692", "Wolfhagen",
"495207", "Schloss\ Holte\-Stukenbrock",
"499466", "Stamsried",
"496628", "Oberaula",
"494163", "Horneburg\ Niederelbe",
"494501", "Kastorf\ Holstein",
"494138", "Betzendorf\ Kreis\ Lüneburg",
"4934223", "Dommitzsch",
"496838", "Saarwellingen",
"4933873", "Grosswudicke",
"496201", "Weinheim\ Bergstr",
"496068", "Beerfelden",
"496645", "Ulrichstein",
"496033", "Butzbach",
"497192", "Murrhardt",
"492542", "Gescher",
"498064", "Au\ bei\ Bad\ Aibling",
"495465", "Neuenkirchen\ bei\ Bramsche",
"499178", "Abenberg\ Mittelfranken",
"4934773", "Schwittersdorf",
"498056", "Eggstätt",
"497940", "Künzelsau",
"492628", "Rhens",
"495253", "Bad\ Driburg",
"495204", "Steinhagen\ Westfalen",
"498370", "Wiggensbach",
"496806", "Heusweiler",
"494106", "Quickborn\ Kreis\ Pinneberg",
"497907", "Schwäbisch\ Hall\-Sulzdorf",
"499454", "Aufhausen\ Oberpfalz",
"494242", "Syke",
"4936087", "Wüstheuterode",
"499403", "Donaustauf",
"492645", "Vettelschoss",
"496542", "Bullay",
"498067", "Tuntenhausen",
"4934348", "Frohburg",
"49831", "Kempten\ Allgäu",
"497306", "Vöhringen\ Iller",
"4933843", "Niemegk",
"492863", "Velen",
"492838", "Sonsbeck",
"4933456", "Wriezen",
"498133", "Haimhausen\ Oberbayern",
"498168", "Attenkirchen",
"496551", "Prüm",
"499360", "Thüngen",
"494864", "Oldenswort",
"496164", "Reichelsheim\ Odenwald",
"494251", "Hoya",
"498386", "Oberstaufen",
"496781", "Idar\-Oberstein",
"499565", "Untersiemau",
"492156", "Willich\-Anrath",
"499077", "Bachhagel",
"497444", "Alpirsbach",
"4934785", "Sandersleben",
"499499", "Painten",
"498283", "Neuburg\ an\ der\ Kammel",
"495086", "Celle\-Scheuen",
"499244", "Betzenstein",
"494452", "Zetel\-Neuenburg",
"496023", "Alzenau\ in\ Unterfranken",
"492606", "Winningen\ Mosel",
"493966", "Cölpin",
"495775", "Diepenau",
"494128", "Kollmar",
"498824", "Oberau\ Loisach",
"497345", "Langenau\ Württemberg",
"4934446", "Grosskorbetha",
"499085", "Alerheim",
"498634", "Garching\ an\ der\ Alz",
"4936330", "Grossberndten",
"499397", "Wertheim\-Dertingen",
"495443", "Lemförde",
"496663", "Steinau\ an\ der\ Strasse",
"499776", "Mellrichstadt",
"496638", "Schwalmtal\-Renzendorf",
"497328", "Königsbronn",
"494708", "Ringstedt",
"494667", "Dagebüll",
"499965", "Sankt\ Englmar",
"499355", "Frammersbach",
"493443", "Weissenfels\ Sachsen\-Anhalt",
"4933877", "Nitzahn",
"497031", "Böblingen",
"4938789", "Wolfshagen\ bei\ Perleberg",
"495957", "Lindern\ Oldenburg",
"495367", "Rühen",
"497203", "Walzbachtal",
"492758", "Bad\ Berleburg\-Girkhausen",
"4938334", "Grammendorf",
"497254", "Waghäusel",
"4939406", "Harbke",
"495966", "Meppen\-Apeldorn",
"495356", "Helmstedt\-Barmke",
"492588", "Harsewinkel\-Greffen",
"492402", "Stolberg\ Rheinland",
"4930", "Berlin",
"498766", "Gammelsdorf",
"496361", "Rockenhausen",
"494441", "Vechta",
"498144", "Grafrath",
"499183", "Burgthann",
"497571", "Sigmaringen",
"494794", "Worpswede\-Ostersode",
"4933678", "Storkow\ Mark",
"494848", "Rantrum",
"492129", "Haan\ Rheinland",
"4937297", "Thum\ Sachsen",
"499524", "Zeil\ am\ Main",
"495335", "Schladen",
"492232", "Brühl\ Rheinland",
"494635", "Sörup",
"499937", "Oberpöring",
"494922", "Borkum",
"494825", "Burg\ Dithmarschen",
"499572", "Burgkunstadt",
"494974", "Neuharlingersiel",
"497433", "Balingen",
"499336", "Bütthard",
"494486", "Edewecht\-Friedrichsfehn",
"493382", "Lehnin",
"497220", "Forbach\-Hundsbach",
"495052", "Hermannsburg",
"498669", "Traunreut",
"495041", "Springe\ Deister",
"492973", "Eslohe\ Sauerland",
"495427", "Melle\-Buer",
"494682", "Amrum",
"495382", "Bad\ Gandersheim",
"496421", "Marburg",
"49441", "Oldenburg",
"498029", "Kreuth\ bei\ Tegernsee",
"496047", "Altenstadt\ Hessen",
"498562", "Triftern",
"493335", "Finowfurt",
"496274", "Waldbrunn\ Odenwald",
"499972", "Waldmünchen",
"495329", "Schulenberg\ im\ Oberharz",
"4936603", "Weida",
"4936332", "Ellrich",
"4936947", "Jüchsen",
"493762", "Crimmitschau",
"496746", "Pfalzfeld",
"49228", "Bonn",
"498341", "Kaufbeuren",
"497971", "Gaildorf",
"4938232", "Zingst\ Ostseebad",
"494522", "Plön",
"499875", "Wolframs\-Eschenbach",
"498082", "Schwindegg",
"494839", "Wöhrden\ Dithmarschen",
"496139", "Budenheim",
"496222", "Wiesloch",
"499924", "Bodenmais",
"499420", "Feldkirchen\ Niederbayern",
"492182", "Grevenbroich\-Kapellen",
"492431", "Erkelenz",
"499268", "Teuschnitz",
"499233", "Arzberg\ Oberfranken",
"4936331", "Ilfeld",
"492573", "Nordwalde",
"4938231", "Barth",
"493329", "Stahnsdorf",
"495434", "Essen\ Oldenburg",
"498035", "Raubling",
"493876", "Perleberg",
"496221", "Heidelberg",
"49651", "Trier",
"498081", "Dorfen\ Stadt",
"494521", "Eutin",
"49421", "Bremen",
"496375", "Wallhalben",
"497972", "Gschwend\ bei\ Gaildorf",
"498342", "Marktoberdorf",
"493761", "Werdau\ Sachsen",
"492636", "Burgbrohl",
"492826", "Kranenburg\ Niederrhein",
"494763", "Gnarrenburg",
"4938876", "Roggendorf",
"4938725", "Gross\ Godems",
"493523", "Coswig\ bei\ Dresden",
"499971", "Cham",
"492485", "Schleiden\-Dreiborn",
"492379", "Menden\-Asbeck",
"495184", "Freden\ Leine",
"492764", "Welschen\ Ennest",
"497268", "Bad\ Rappenau\-Obergimpern",
"497233", "Niefern\-Öschelbronn",
"495523", "Bad\ Sachsa",
"496586", "Beuren\ Hochwald",
"4935246", "Ziegenhain\ Sachsen",
"497420", "Deisslingen",
"494286", "Gyhum",
"4935726", "Gross\ Särchen",
"496756", "Winterbach\ Soonwald",
"4935478", "Goyatz",
"4935209", "Mohorn",
"497684", "Glottertal",
"492432", "Wassenberg",
"4933366", "Chorin",
"492181", "Grevenbroich",
"495761", "Stolzenau",
"4935875", "Obercunnersdorf\ bei\ Löbau",
"495051", "Bergen\ Kreis\ Celle",
"4934206", "Rötha",
"493381", "Brandenburg\ an\ der\ Havel",
"497937", "Dörzbach",
"496836", "Überherrn",
"497524", "Bad\ Waldsee",
"494136", "Scharnebeck",
"4938301", "Putbus",
"495234", "Horn\-Bad\ Meinberg",
"494749", "Schiffdorf\-Geestenseth",
"493923", "Zerbst",
"496066", "Michelstadt\-Vielbrunn",
"4939427", "Ströbeck",
"497183", "Rudersberg\ Württemberg",
"499571", "Lichtenfels\ Bayern",
"494921", "Emden\ Stadt",
"498807", "Diessen\ am\ Ammersee",
"4935755", "Ortrand",
"499220", "Kasendorf\-Azendorf",
"4938457", "Krakow\ am\ See",
"4938375", "Koserow",
"4937344", "Crottendorf\ Sachsen",
"4939883", "Gross\ Dölln",
"4936201", "Walschleben",
"497336", "Lonsee",
"496057", "Flörsbachtal",
"495683", "Wabern\ Hessen",
"499433", "Nabburg",
"496626", "Wildeck\-Obersuhl",
"499468", "Zell\ Oberpfalz",
"4936846", "Suhl\-Dietzhausen",
"497572", "Mengen\ Württemberg",
"492054", "Essen\-Kettwig",
"494383", "Grebin",
"4962196", "Ludwigshafen",
"498561", "Pfarrkirchen\ Niederbayern",
"494858", "Sankt\ Margarethen\ Holstein",
"4939726", "Ducherow",
"496158", "Riedstadt",
"4939209", "Wanzleben",
"4936453", "Mellingen",
"493683", "Schmalkalden",
"496095", "Bessenbach",
"4939008", "Kunrau",
"496387", "Sankt\ Julian",
"496422", "Kirchhain",
"492384", "Welver",
"4938302", "Sagard",
"4936202", "Neudietendorf",
"498723", "Arnstorf",
"495381", "Seesen",
"494681", "Wyk\ auf\ Föhr",
"496474", "Villmar\-Aumenau",
"4938756", "Grabow",
"4969", "Frankfurt\ am\ Main",
"495042", "Bad\ Münder\ am\ Deister",
"495923", "Schüttorf",
"4939246", "Lindau\ Anh",
"499345", "Külsheim\ Baden",
"495947", "Laar\ Vechte",
"4933606", "Müllrose",
"497244", "Weingarten\ Baden",
"496897", "Sulzbach\ Saar",
"495346", "Liebenburg",
"496109", "Frankfurt\-Bergen\-Enkheim",
"4939039", "Bonese",
"494646", "Mohrkirch",
"497085", "Enzklösterle",
"494451", "Varel\ Jadebusen",
"492725", "Lennestadt\-Oedingen",
"4933744", "Hohenseefeld",
"496362", "Alsenz",
"499254", "Gefrees",
"494442", "Lohne\ Oldenburg",
"493346", "Seelow",
"499861", "Rothenburg\ ob\ der\ Tauber",
"499203", "Neudrossenfeld",
"492859", "Wesel\-Bislich",
"492401", "Baesweiler",
"497355", "Hochdorf\ Riss",
"497965", "Ellwangen\-Röhlingen",
"495453", "Recke",
"493947", "Thale",
"495404", "Westerkappeln",
"4939999", "Tutow",
"497032", "Herrenberg",
"494893", "Hohenaspe",
"496855", "Freisen",
"494155", "Büchen",
"494605", "Medelby",
"499907", "Zenting",
"496694", "Neukirchen\ Knüll",
"4939921", "Ankershagen",
"495305", "Sickte",
"492697", "Blankenheim\-Ahrhütte",
"492202", "Bergisch\ Gladbach",
"496541", "Traben\-Trarbach",
"496735", "Eppelsheim",
"494241", "Bassum",
"492739", "Wilnsdorf",
"4938204", "Broderstorf",
"499306", "Kist",
"497403", "Dunningen",
"4937467", "Klingenthal\ Sachsen",
"497454", "Sulz\ am\ Neckar",
"497950", "Schnelldorf",
"498046", "Bad\ Heilbrunn",
"4939922", "Dambeck\ bei\ Röbel",
"4934659", "Blankenheim\ bei\ Sangerhausen",
"4936200", "Elxleben\ bei\ Arnstadt",
"496782", "Birkenfeld\ Nahe",
"4936695", "Söllmnitz",
"496659", "Eichenzell",
"494252", "Bruchhausen\-Vilsen",
"499444", "Siegenburg",
"4933976", "Wutike",
"496552", "Olzheim",
"4938300", "Insel\ Hiddensee",
"4936929", "Ruhla",
"492655", "Weibern",
"4937434", "Bobenneukirchen",
"497565", "Aichstetten\ Kreis\ Ravensburg",
"4937752", "Eibenstock",
"494255", "Martfeld",
"493302", "Hennigsdorf",
"492652", "Mendig",
"494406", "Berne",
"4934244", "Mockrehna",
"496293", "Schefflenz",
"4933671", "Lieberose",
"496555", "Bleialf",
"497562", "Isny\ im\ Allgäu",
"499723", "Röthlein",
"4937349", "Scheibenberg",
"4936737", "Drognitz",
"4939952", "Grammentin",
"497669", "St\ Märgen",
"493644", "Apolda",
"499103", "Cadolzburg",
"499561", "Coburg",
"4933605", "Boossen",
"499154", "Pommelsbrunn",
"496785", "Herrstein",
"493591", "Bautzen",
"4933672", "Pfaffendorfb\ Beeskow",
"496464", "Angelburg",
"494344", "Schönberg\ Holstein",
"498468", "Altmannstein\-Pondorf",
"495644", "Willebadessen\-Peckelsheim",
"498433", "Königsmoos",
"494509", "Gross\ Grönau",
"4936764", "Neuhaus\-Schierschnitz",
"496209", "Mörlenbach",
"498571", "Simbach\ am\ Inn",
"499199", "Kunreuth",
"494602", "Freienwill",
"497144", "Marbach\ am\ Neckar",
"492594", "Dülmen",
"494297", "Ottersberg\-Posthausen",
"492456", "Selfkant",
"492205", "Rösrath",
"495302", "Vechelde",
"496597", "Jünkerath",
"4939951", "Faulenrost",
"496732", "Wörrstadt",
"492641", "Bad\ Neuenahr\-Ahrweiler",
"4939204", "Niederndodeleben",
"4938733", "Karbow\-Vietlübbe",
"4933394", "Blumberg\ Kreis\ Barnim",
"4935952", "Grossröhrsdorf\ OL",
"494773", "Lamstedt",
"497643", "Herbolzheim\ Breisgau",
"492369", "Dorsten\-Wulfen",
"493991", "Waren\ Müritz",
"494152", "Geesthacht",
"4934692", "Alsleben\ Saale",
"496852", "Nohfelden",
"494260", "Visselhövede\-Wittorf",
"499961", "Mitterfels",
"499351", "Gemünden\ am\ Main",
"494445", "Visbek\ Kreis\ Vechta",
"493847", "Sternberg",
"493771", "Aue\ Sachsen",
"497962", "Fichtenau",
"495143", "Winsen\ Aller",
"497352", "Ochsenhausen",
"4933983", "Gross\ Pankow\ Kreis\ Prignitz",
"4933975", "Dannenwalde\ Kreis\ Prignitz",
"492246", "Lohmar\ Rheinland",
"499604", "Wernberg\-Köblitz",
"4935951", "Neukirch\ Lausitz",
"499653", "Eslarn",
"492994", "Marsberg\-Westheim",
"495771", "Rahden\ Westfalen",
"4934691", "Könnern",
"4935204", "Wilsdruff",
"492722", "Attendorn",
"4936338", "Bleicherode",
"497082", "Neuenbürg\ Württemberg",
"496841", "Homburg\ Saar",
"494141", "Stade",
"499342", "Wertheim",
"492774", "Dietzhölztal",
"496396", "Hinterweidenthal",
"492102", "Ratingen",
"499081", "Nördlingen",
"4939383", "Sandau\ Elbe",
"497386", "Hayingen",
"4938875", "Schlagsdorf\ bei\ Gadebusch",
"492429", "Hürtgenwald",
"4938726", "Spornitz",
"494958", "Jemgum",
"4938209", "Sanitz\ bei\ Rostock",
"494333", "Erfde",
"495633", "Diemelsee",
"498444", "Schweitenkirchen",
"495045", "Springe\-Bennigsen",
"495823", "Bienenbüttel",
"494186", "Buchholz\-Trelde",
"4936423", "Orlamünde",
"493331", "Angermünde",
"495028", "Pennigsehl",
"496092", "Heimbuchenthal",
"4934341", "Geithain",
"497133", "Lauffen\ am\ Neckar",
"495284", "Schwalenberg",
"496425", "Rauschenberg\ Hessen",
"4938427", "Blowatz",
"4935725", "Wittichenau",
"494631", "Glücksburg\ Ostsee",
"4934463", "Bad\ Kösen",
"495127", "Harsum",
"4937439", "Jocketa",
"495331", "Wolfenbüttel",
"498306", "Ronsberg",
"4936924", "Mihla",
"49731", "Ulm\ Donau",
"492526", "Sendenhorst",
"4933365", "Lüdersdorf\ Kreis\ Barnim",
"496701", "Sprendlingen\ Rheinhessen",
"4935876", "Weissenberg\ Sachsen",
"497575", "Messkirch",
"497837", "Oberharmersbach",
"497056", "Gechingen",
"495707", "Petershagen\ Weser",
"497627", "Steinen\ Kreis\ Lörrach",
"49681", "Saarbrücken",
"4935245", "Burkhardswalde\-Munzig",
"4934654", "Stolberg\ Harz",
"492334", "Hagen\-Hohenlimburg",
"4934342", "Neukieritzsch",
"494821", "Itzehoe",
"4939457", "Benneckenstein\ Harz",
"496337", "Grossbundenbach",
"4938376", "Zirchow",
"4935756", "Hosena",
"497587", "Hosskirch",
"4936845", "Gehlberg",
"492435", "Erkelenz\-Lövenich",
"4939034", "Fleetmark",
"4934205", "Markranstädt",
"496439", "Holzappel",
"4935383", "Elster\ Elbe",
"498031", "Rosenheim\ Oberbayern",
"496258", "Gernsheim",
"498203", "Grossaitingen",
"492686", "Weyerbusch",
"498861", "Schongau",
"494558", "Todesfelde",
"498254", "Altomünster",
"497634", "Sulzburg",
"4939994", "Metschow",
"498328", "Balderschwang",
"498507", "Neuburg\ am\ Inn",
"492131", "Neuss",
"492508", "Drensteinfurt",
"4938755", "Eldena",
"492327", "Bochum\-Wattenscheid",
"492482", "Hellenthal",
"4939245", "Loburg",
"496324", "Hassloch",
"499120", "Leinburg",
"49261", "Koblenz\ am\ Rhein",
"4962195", "Ludwigshafen",
"499747", "Geroda\ Bayern",
"496372", "Bruchmühlbach\-Miesau",
"499871", "Windsbach",
"497975", "Untergröningen",
"494236", "Kirchlinteln",
"498345", "Stöttwang",
"496536", "Kleinich",
"497824", "Schwanau",
"496673", "Haunetal",
"498862", "Steingaden\ Oberbayern",
"499766", "Grosswenkheim",
"493377", "Zossen\ Brandenburg",
"498550", "Philippsreut",
"498032", "Rohrdorf\ Kreis\ Rosenheim",
"495765", "Raddestorf",
"4939607", "Kotelow",
"493976", "Torgelow\ bei\ Ueckermünde",
"499090", "Rain\ Lech",
"495060", "Bodenburg",
"493765", "Reichenbach\ Vogtland",
"495976", "Salzbergen",
"494525", "Ahrensbök",
"499872", "Heilsbronn",
"4934903", "Coswig\ Anhalt",
"496371", "Landstuhl",
"495484", "Lienen\-Kattenvenne",
"499634", "Wiesau",
"498085", "Sankt\ Wolfgang",
"494939", "Baltrum",
"495377", "Ehra\-Lessien",
"499824", "Dietenhofen",
"494320", "Heidmühlen",
"492132", "Meerbusch\-Büderich",
"499975", "Waldmünchen\-Geigant",
"4937327", "Rechenberg\-Bienenmühle",
"497747", "Berau",
"4938784", "Kleinow\ Kreis\ Prignitz",
"499283", "Rehau",
"497483", "Horb\-Mühringen",
"493576", "Weisswasser",
"4935607", "Jänschwalde",
"4939928", "Möllenhagen",
"493332", "Schwedt\/Oder",
"498565", "Dietersburg\-Baumgarten",
"492873", "Isselburg\-Werth",
"499386", "Prosselsheim",
"497046", "Zaberfeld",
"4934673", "Heldrungen",
"4939000", "Beetzendorf",
"499133", "Baiersdorf\ Mittelfranken",
"4933657", "Steinsdorf\ Brandenburg",
"495198", "Schneverdingen\-Wintermoor",
"496239", "Bobenheim\-Roxheim",
"4933433", "Buckow\ Märkische\ Schweiz",
"499575", "Weismain",
"494822", "Kellinghusen",
"496122", "Hofheim\-Wallau",
"499837", "Haundorf",
"49931", "Würzburg",
"494539", "Westerau",
"498403", "Pförring",
"494948", "Wiesmoor\-Marcardsmoor",
"496458", "Rosenthal\ Hessen",
"495055", "Fassberg",
"498454", "Karlshuld",
"4939977", "Jördenstorf",
"493385", "Rathenow",
"4933094", "Löwenberg",
"496174", "Königstein\ im\ Taunus",
"4933967", "Freyenstein",
"492235", "Erftstadt",
"495332", "Schöppenstedt",
"494874", "Todenbüttel",
"494925", "Hinte",
"494632", "Steinbergkirche",
"498178", "Icking",
"499627", "Freudenberg\ Oberpfalz",
"494497", "Barssel\-Harkebrügge",
"4933052", "Leegebruch",
"492256", "Mechernich\-Satzvey",
"497351", "Biberach\ an\ der\ Riss",
"497961", "Ellwangen\ Jagst",
"498684", "Fridolfing",
"493772", "Schneeberg\ Erzgebirge",
"499643", "Auerbach\ in\ der\ Oberpfalz",
"492405", "Würselen",
"495857", "Bleckede\-Brackede",
"4939263", "Unseburg",
"499865", "Adelshofen\ Mittelfranken",
"499352", "Lohr\ am\ Main",
"499962", "Schwarzach\ Niederbayern",
"496264", "Neudenau",
"496851", "St\ Wendel",
"494151", "Schwarzenbek",
"495036", "Neustadt\-Schneeren",
"498233", "Kissing",
"492267", "Wipperfürth",
"494564", "Schashagen",
"498268", "Tussenhausen",
"4935472", "Schlepzig",
"4936782", "Schmiedefeld\ am\ Rennsteig",
"493724", "Burgstädt",
"496409", "Biebertal",
"4936703", "Gräfenthal",
"499082", "Oettingen\ in\ Bayern",
"492563", "Stadtlohn",
"498537", "Bad\ Füssing\-Aigen",
"4933051", "Nassenheide",
"492538", "Drensteinfurt\-Rinkerode",
"497653", "Lenzkirch",
"499341", "Tauberbischofsheim",
"493866", "Cambs",
"494142", "Steinkirchen\ Kreis\ Stade",
"495724", "Obernkirchen",
"496842", "Blieskastel",
"497081", "Bad\ Wildbad",
"4935471", "Birkenhainchen",
"494455", "Jade\-Schweiburg",
"492721", "Lennestadt",
"496506", "Welschbillig",
"495772", "Espelkamp",
"494206", "Stuhr\-Heiligenrode",
"4936781", "Grossbreitenbach",
"499278", "Weidenberg",
"495153", "Salzhemmendorf",
"497723", "Furtwangen\ im\ Schwarzwald",
"493592", "Kirschau",
"495603", "Gudensberg",
"4934445", "Stössen",
"494964", "Rhede\ Ems",
"494354", "Fleckeby",
"497478", "Hirrlingen",
"499562", "Sonnefeld",
"495654", "Herleshausen",
"494303", "Schlesen",
"4938308", "Göhren\ Rügen",
"4939083", "Messdorf",
"493737", "Rochlitz",
"4939002", "Oebisfelde",
"497154", "Kornwestheim",
"492446", "Heimbach\ Eifel",
"4936208", "Ermstedt",
"497561", "Leutkirch\ im\ Allgäu",
"4935263", "Gröditz\ bei\ Riesa",
"493301", "Oranienburg",
"492651", "Mayen",
"494245", "Neuenkirchen\ bei\ Bassum",
"497807", "Neuried\ Ortenaukreis",
"498336", "Erkheim",
"496545", "Blankenrath",
"492642", "Remagen",
"496731", "Alzey",
"4939001", "Apenburg",
"495301", "Lehre\-Essenrode",
"498572", "Tann\ Niederbayern",
"495592", "Gleichen\-Bremke",
"492963", "Brilon\-Messinghausen",
"493603", "Bad\ Langensalza",
"492353", "Halver",
"496307", "Schopp",
"492938", "Ense",
"4934293", "Naunhof\ bei\ Grimma",
"498679", "Burgkirchen\ an\ der\ Alz",
"492304", "Schwerte",
"496340", "Wörth\-Schaidt",
"4939405", "Hötensleben",
"499144", "Pleinfeld",
"497195", "Winnenden",
"492545", "Rosendahl\-Darfeld",
"496642", "Schlitz",
"497804", "Oppenau",
"495462", "Ankum",
"499720", "Üchtelhausen",
"497853", "Kehl\-Bodersweier",
"494249", "Bassum\-Nordwohlde",
"495734", "Bergkirchen\ Westfalen",
"499147", "Nennslingen",
"496304", "Wolfstein\ Pfalz",
"496353", "Freinsheim",
"4933635", "Arensdorf\ Kreis\ Oder\-Spree",
"4939267", "Schneidlingen",
"4938781", "Mellen",
"492528", "Ennigerloh\-Enniger",
"495695", "Twistetal",
"492307", "Kamen",
"499843", "Burgbernheim",
"496888", "Lebach\-Steinbach",
"494188", "Welle\ Nordheide",
"494357", "Sehestedt\ Eider",
"494967", "Rhauderfehn\-Burlage",
"499665", "Königstein\ Oberpfalz",
"4936076", "Niederorschel",
"495026", "Steimbke",
"497166", "Adelberg",
"498223", "Ichenhausen",
"493695", "Bad\ Salzungen",
"495657", "Meissner",
"496083", "Weilrod",
"4939363", "Angern",
"496651", "Rasdorf",
"497388", "Pfronstetten",
"4933748", "Treuenbrietzen",
"497157", "Waldenbuch",
"499492", "Parsberg",
"4938782", "Reetz\ bei\ Perleberg",
"494366", "Grömitz\-Cismar",
"496446", "Hohenahr",
"494956", "Uplengen",
"493462", "Bad\ Dürrenberg",
"492842", "Kamp\-Lintfort",
"494770", "Wischhafen",
"4935267", "Diesbar\-Seusslitz",
"496563", "Kyllburg",
"496101", "Bad\ Vilbel",
"492928", "Soest\-Ostönnen",
"494263", "Scheessel",
"498534", "Tettenweis",
"494238", "Neddenaverbergen",
"49471", "Bremerhaven",
"498326", "Fischen\ im\ Allgäu",
"492945", "Lippstadt\-Benninghausen",
"4939087", "Jerchel\ Altmark",
"4937438", "Bad\ Brambach",
"492506", "Münster\-Wolbeck",
"496721", "Bingen\ am\ Rhein",
"4933932", "Fehrbellin",
"495261", "Lemgo",
"4935363", "Fermerswalde",
"495854", "Bleckede\-Barskamp",
"495803", "Rosche",
"4934297", "Liebertwolkwitz",
"494556", "Ahrensbök\-Gnissau",
"494494", "Bösel\ Oldenburg",
"496405", "Laubach\ Hessen",
"498687", "Taching\-Tengling",
"496256", "Lampertheim\-Hüttenfeld",
"492688", "Kroppach",
"4938208", "Kavelstorf",
"492409", "Stolberg\-Gressenich",
"493727", "Mittweida",
"497733", "Engen\ Hegau",
"496267", "Fahrenbach\ Baden",
"4933931", "Rheinsberg\ Mark",
"499869", "Wettringen\ Mittelfranken",
"492264", "Marienheide",
"492851", "Rees",
"4933054", "Liebenwalde",
"4939603", "Burg\ Stargard",
"498457", "Vohburg\ an\ der\ Donau",
"495171", "Peine",
"494929", "Ihlow\ Kreis\ Aurich",
"494330", "Emkendorf",
"499834", "Theilenhofen",
"499480", "Sünching",
"499672", "Neunburg\ vorm\ Wald",
"494535", "Nahe",
"495820", "Suhlendorf",
"498466", "Denkendorf\ Oberbayern",
"494877", "Hennstedt\ bei\ Itzehoe",
"494741", "Nordholz\ bei\ Bremerhaven",
"4935474", "Schönwalde\ bei\ Lübben",
"496235", "Schifferstadt",
"492174", "Burscheid\ Rheinland",
"498191", "Landsberg\ am\ Lech",
"499624", "Ensdorf\ Oberpfalz",
"497130", "Löwenstein\ Württemberg",
"493475", "Lutherstadt\ Eisleben",
"4936784", "Stützerbach",
"497671", "Todtnau",
"4938780", "Lanz\ Brandenburg",
"496873", "Nonnweiler",
"494173", "Wulfsen",
"498662", "Siegsdorf\ Kreis\ Traunstein",
"4937323", "Lichtenberg\ Erzgebirge",
"4935973", "Stolpen",
"495475", "Bohmte\-Hunteburg",
"498074", "Schnaitsee",
"496078", "Gross\-Umstadt",
"494752", "Neuhaus\ Oste",
"494408", "Hude\ Oldenburg",
"498022", "Tegernsee",
"496282", "Walldürn",
"497373", "Zwiefalten",
"4934907", "Jeber\-Bergfrieden",
"495743", "Espelkamp\-Gestringen",
"492225", "Meckenheim\ Rheinland",
"495322", "Bad\ Harzburg",
"496398", "Vorderweidenthal",
"497276", "Herxheim\ bei\ Landau\ Pfalz",
"494935", "Juist",
"498394", "Lautrach",
"494622", "Taarstedt",
"492371", "Iserlohn",
"499637", "Falkenberg\ Oberpfalz",
"4933653", "Ziltendorf",
"4939004", "Köckte\ bei\ Gardelegen",
"497744", "Stühlingen",
"498247", "Bad\ Wörishofen",
"492248", "Hennef\-Uckerath",
"4935603", "Burg\ Spreewald",
"496229", "Neckarsteinach",
"495374", "Isenbüttel",
"494832", "Meldorf",
"496132", "Ingelheim\ am\ Rhein",
"499827", "Lichtenau\ Mittelfranken",
"494674", "Ockholm",
"494529", "Süsel\-Bujendorf",
"498543", "Aidenbach",
"495769", "Steyerberg\-Voigtei",
"4933963", "Wulfersdorf\ bei\ Wittstock",
"492673", "Ellenz\-Poltersdorf",
"499123", "Lauf\ an\ der\ Pegnitz",
"493322", "Falkensee",
"4933437", "Reichenberg\ bei\ Strausberg",
"494426", "Wangerland\-Horumersiel",
"4937348", "Oberwiesenthal\ Kurort",
"494885", "Bergenhusen",
"496185", "Hammersbach\ Hessen",
"4939973", "Altkalen",
"496482", "Runkel",
"496670", "Ludwigsau\ Hessen",
"498504", "Tittling",
"494208", "Grasberg",
"492324", "Hattingen\ Ruhr",
"4937754", "Zwönitz",
"496131", "Mainz",
"4934242", "Hohenpriessnitz",
"4936427", "Dornburg\ Saale",
"493623", "Friedrichroda",
"496327", "Neustadt\-Lachen",
"498295", "Altenmünster\ Schwaben",
"496508", "Hetzerath\ Mosel",
"498553", "Spiegelau",
"499276", "Bischofsgrün",
"498349", "Stötten\ am\ Auerberg",
"4936761", "Heubisch",
"4939387", "Havelberg",
"4939954", "Stavenhagen\ Reuterstadt",
"492536", "Münster\-Albachten",
"499093", "Polsingen",
"492372", "Hemer",
"495275", "Höxter\-Ottbergen",
"494621", "Schleswig",
"493868", "Rastow",
"4939201", "Wolmirstedt",
"499744", "Zeitlofs\-Detter",
"49661", "Fulda",
"495137", "Seelze",
"495321", "Goslar",
"498783", "Rohr\ in\ Niederbayern",
"4934722", "Preusslitz",
"498266", "Kirchheim\ in\ Schwaben",
"4936875", "Straufhain\-Streufdorf",
"4934241", "Jesewitz",
"497123", "Metzingen\ Württemberg",
"495063", "Bad\ Salzdetfurth",
"4933674", "Trebatsch",
"496435", "Wallmerod",
"495833", "Brome",
"4936762", "Steinach\ Thüringen",
"497584", "Altshausen",
"4939453", "Derenburg",
"4936209", "Klettbach",
"493321", "Nauen\ Brandenburg",
"4938423", "Bad\ Kleinen",
"4936920", "Grossenlupnitz",
"4938309", "Trent",
"497754", "Görwihl",
"494323", "Bornhöved",
"4934467", "Eckartsberga",
"497703", "Bonndorf\ im\ Schwarzwald",
"495623", "Edertal",
"4935796", "Panschwitz\-Kuckau",
"498257", "Inchenhofen",
"4934721", "Nienburg\ Saale",
"4939202", "Gross\ Ammensleben",
"499280", "Selbitz\ Oberfranken",
"497672", "St\ Blasien",
"495583", "Braunlage\-Hohegeiss",
"4935387", "Seyda",
"4935954", "Grossharthau",
"496526", "Bollendorf",
"497834", "Wolfach",
"4935201", "Langebrück",
"498192", "Schondorf\ am\ Ammersee",
"494742", "Dorum",
"498338", "Böhen",
"4933085", "Seilershof",
"499671", "Oberviechtach",
"498363", "Pfronten",
"492337", "Hagen\-Dahl",
"4939030", "Brunau",
"49281", "Wesel",
"4939345", "Parchen",
"496334", "Thaleischweiler\-Fröschen",
"495172", "Ilsede",
"497624", "Grenzach\-Wyhlen",
"497579", "Schwenningen\ Baden",
"495704", "Petershagen\-Friedewalde",
"495753", "Auetal\-Bernsen",
"492448", "Hellenthal\-Rescheid",
"4936376", "Straussfurt",
"496429", "Schweinsberg\ Hessen",
"496281", "Buchen\ Odenwald",
"4938845", "Kaarssen",
"498021", "Waakirchen",
"4935202", "Klingenberg\ Sachsen",
"494751", "Otterndorf",
"492425", "Nideggen\-Embken",
"493583", "Zittau",
"497476", "Bisingen",
"498661", "Grabenstätt\ Chiemsee",
"499373", "Amorbach",
"4935453", "Drahnsdorf",
"496722", "Rüdesheim\ am\ Rhein",
"495844", "Clenze",
"499292", "Konradsreuth",
"494546", "Mustin\ Lauenburg",
"499607", "Luhe\-Wildenau",
"4936921", "Wutha\-Farnroda",
"496246", "Eich\ Rheinhessen",
"495978", "Hörstel\-Dreierwalde",
"498230", "Gablingen",
"494802", "Wrohm",
"496102", "Neu\-Isenburg",
"4934926", "Pretzsch\ Elbe",
"496774", "Kaub",
"4935032", "Langenhennersdorf",
"492841", "Moers",
"4934651", "Rossla",
"498423", "Titting",
"492777", "Breitscheid\ Hessen",
"4936733", "Kaulsdorf",
"492852", "Hamminkeln",
"4939200", "Gommern",
"4936922", "Gerstungen",
"4935435", "Gollmitz\ bei\ Calau",
"4938737", "Ganzlin",
"4937206", "Frankenberg\ Sachsen",
"4936966", "Kaltennordheim",
"493844", "Schwaan",
"499733", "Münnerstadt",
"4934652", "Allstedt",
"4934344", "Kohren\-Sahlis",
"492955", "Büren\-Wewelsburg",
"492365", "Marl",
"4939929", "Jabel\ bei\ Waren",
"495262", "Extertal",
"497720", "Schwenningen\ am\ Neckar",
"499853", "Wilburgstetten",
"4939991", "Daberkow",
"499195", "Adelsdorf\ Mittelfranken",
"499804", "Aurach",
"498176", "Egling\ bei\ Wolfratshausen",
"494347", "Flintbek",
"496467", "Hatzfeld\ Eder",
"495647", "Lichtenau\-Kleinenberg",
"492464", "Aldenhoven\ bei\ Jülich",
"4939032", "Mahlsdorf\ bei\ Salzwedel",
"495461", "Bramsche\ Hase",
"496641", "Lauterbach\ Hessen",
"495196", "Wietzendorf",
"492732", "Kreuztal",
"496205", "Hockenheim",
"492597", "Senden\ Westfalen",
"497147", "Sachsenheim\ Württemberg",
"494294", "Riede\ Kreis\ Verden",
"494505", "Stockelsdorf\-Curau",
"496456", "Haina\ Kloster",
"496594", "Birresborn",
"494946", "Grossefehn\-Bagband",
"499166", "Münchsteinach",
"493461", "Merseburg\ Saale",
"4939992", "Görmin",
"499491", "Hemau",
"497665", "March\ Breisgau",
"4939031", "Dähre",
"496652", "Hünfeld",
"4936625", "Langenwetzendorf",
"492555", "Schöppingen",
"496789", "Heimbach\ Nahe",
"492293", "Nümbrecht",
"497843", "Renchen",
"497025", "Neuffen",
"495165", "Rethem\ Aller",
"4935695", "Simmersdorf",
"496559", "Leidenborn",
"4935200", "Arnsdorf\ bei\ Dresden",
"499157", "Alfeld\ Mittelfranken",
"493578", "Kamenz",
"4934955", "Gossa",
"493647", "Pössneck",
"494463", "Wangerland",
"496343", "Bad\ Bergzabern",
"492261", "Gummersbach",
"4939833", "Mirow\ Kreis\ Neustrelitz",
"497366", "Abtsgmünd",
"492803", "Wesel\-Büderich",
"496857", "Namborn",
"493493", "Bitterfeld",
"499463", "Wald\ Oberpfalz",
"4936337", "Schiedungen",
"499438", "Fensterbach",
"496866", "Perl\-Nennig",
"495409", "Hilter\ am\ Teutoburger\ Wald",
"494166", "Ahlerstedt",
"494491", "Friesoythe",
"497967", "Jagstzell",
"497357", "Attenweiler",
"496036", "Wölfersheim",
"493928", "Schönebeck\ Elbe",
"4934324", "Ostrau\ Sachsen",
"495264", "Kalletal",
"495851", "Dahlenburg",
"496724", "Stromberg\ Hunsrück",
"495842", "Schnega",
"4934909", "Aken\ Elbe",
"498728", "Geratskirchen",
"497395", "Ehingen\-Dächingen",
"4933925", "Wustrau\-Altfriesack",
"499294", "Regnitzlosau",
"497249", "Stutensee",
"499946", "Hohenwarth\ bei\ Kötzing",
"4936941", "Wasungen",
"499505", "Litzendorf",
"498531", "Pocking",
"494853", "Sankt\ Michaelisdonn",
"498745", "Bodenkirchen",
"494804", "Nordhastedt",
"496104", "Heusenstamm",
"494195", "Hartenholm",
"495493", "Neuenkirchen\ Kreis\ Vechta",
"499347", "Wittighausen",
"496772", "Nastätten",
"4938333", "Horst\ bei\ Grimmen",
"4933870", "Zollchow\ bei\ Rathenow",
"495945", "Wilsum",
"495506", "Adelebsen",
"497567", "Leutkirch\-Friesenhofen",
"494768", "Hipstedt",
"494733", "Butjadingen\-Burhave",
"4933844", "Brück\ Brandenburg",
"4936645", "Mühltroff",
"496654", "Gersfeld\ Rhön",
"4937292", "Oederan",
"493307", "Zehdenick",
"492657", "Uersfeld",
"493528", "Radeberg",
"497556", "Uhldingen\-Mühlhofen",
"4934774", "Röblingen\ am\ See",
"492666", "Freilingen\ Westerwald",
"493731", "Freiberg\ Sachsen",
"498706", "Vilsheim",
"499802", "Ansbach\-Katterbach",
"49771", "Donaueschingen",
"4937365", "Sayda",
"496301", "Otterbach\ Pfalz",
"495545", "Hedemünden",
"4933439", "Fredersdorf\-Vogelsdorf",
"495906", "Lünne",
"495731", "Bad\ Oeynhausen",
"4937291", "Augustusburg",
"492462", "Linnich",
"4936738", "Königsee",
"497263", "Waibstadt",
"496737", "Köngernheim",
"492734", "Freudenberg\ Westfalen",
"494607", "Janneby",
"494292", "Ritterhude",
"499546", "Burgebrach",
"497459", "Nagold\-Hochdorf",
"499905", "Bernried\ Niederbayern",
"496592", "Daun",
"495307", "Braunschweig\-Wenden",
"495528", "Gieboldehausen",
"492695", "Insul",
"4934221", "Schildau\ Gneisenaustadt",
"4938326", "Grimmen",
"497582", "Bad\ Buchau",
"495673", "Immenhausen\ Hessen",
"4939861", "Gramzow\ bei\ Prenzlau",
"4936940", "Oepfershausen",
"493371", "Luckenwalde",
"497173", "Heubach",
"4934741", "Frose",
"4936604", "Münchenbernsdorf",
"496765", "Gemünden\ Hunsrück",
"495225", "Spenge",
"4935325", "Rückersdorf\ bei\ Finsterwalde",
"4933872", "Hohennauen",
"494671", "Bredstedt",
"496484", "Beselich",
"498502", "Fürstenzell",
"4934222", "Arzberg\ bei\ Torgau",
"495371", "Gifhorn",
"4938295", "Satow\ bei\ Bad\ Doberan",
"4933765", "Märkisch\ Buchholz",
"497741", "Tiengen\ Hochrhein",
"4938856", "Pritzier\ bei\ Hagenow",
"4939826", "Blankensee\ bei\ Neustrelitz",
"4939862", "Schmölln\ bei\ Prenzlau",
"495248", "Langenberg\ Kreis\ Gütersloh",
"496620", "Philippsthal\ Werra",
"492374", "Iserlohn\-Letmathe",
"4934742", "Sylda",
"499742", "Kalbach\ Rhön",
"4939775", "Ahlbeck\ bei\ Torgelow",
"498846", "Uffing\ am\ Staffelsee",
"499323", "Iphofen",
"4938428", "Hohenkirchen\ bei\ Wismar",
"4939089", "Bismark\ Altmark",
"496580", "Zemmer",
"492389", "Werne",
"4938825", "Klütz",
"497426", "Gosheim",
"4936082", "Ershausen",
"4937605", "Hartenstein\ Sachsen",
"496385", "Reichenbach\-Steegen",
"496479", "Waldbrunn\ Westerwald",
"4939855", "Parmen\-Weggun",
"498071", "Wasserburg\ am\ Inn",
"4939296", "Welsleben",
"4939458", "Heudeber",
"492743", "Daaden",
"496055", "Freigericht",
"497674", "Todtmoos",
"497529", "Waldburg\ Württemberg",
"4935826", "Königshain\ bei\ Görlitz",
"497832", "Haslach\ im\ Kinzigtal",
"495458", "Hopsten",
"492171", "Leverkusen\-Opladen",
"498805", "Hohenpeissenberg",
"498194", "Vilgertshofen",
"499621", "Amberg\ Oberpfalz",
"4938355", "Züssow",
"4935775", "Pechern",
"492630", "Mülheim\-Kärlich",
"496198", "Eppstein",
"497062", "Beilstein\ Württemberg",
"494744", "Loxstedt",
"499208", "Bindlach",
"496332", "Zweibrücken",
"4939325", "Vinzelberg",
"495174", "Lahstedt",
"499831", "Gunzenhausen",
"4936255", "Goldbach\ bei\ Gotha",
"4936081", "Arenshausen",
"495702", "Petershagen\-Lahde",
"497622", "Schopfheim",
"494276", "Borstel\ bei\ Sulingen",
"497935", "Schrozberg",
"4934299", "Gaschwitz",
"496633", "Homberg\ Ohm",
"4939884", "Hassleben\ bei\ Prenzlau",
"499426", "Oberschneiding",
"493337", "Biesenthal\ Brandenburg",
"496045", "Gedern",
"496668", "Birstein\-Lichenroth",
"498664", "Chieming",
"49381", "Rostock",
"495448", "Barver",
"4937343", "Jöhstadt",
"498072", "Haag\ in\ Oberbayern",
"494703", "Loxstedt\-Donnern",
"497323", "Gerstetten",
"4938450", "Tarnow\ bei\ Bützow",
"494754", "Bülkau",
"4939978", "Gross\ Roge",
"496284", "Mudau",
"495425", "Borgholzhausen",
"498024", "Holzkirchen",
"496028", "Sulzbach\ am\ Main",
"4933968", "Meyenburg\ Kreis\ Prignitz",
"4937462", "Rothenkirchen\ Vogtland",
"494123", "Barmstedt",
"493425", "Wurzen",
"492583", "Sassenberg",
"497621", "Lörrach",
"495936", "Twist",
"4935608", "Gross\ Ossnig",
"4939927", "Nossentiner\ Hütte",
"494827", "Wacken",
"499832", "Wassertrüdingen",
"496127", "Niedernhausen\ Taunus",
"496331", "Pirmasens",
"499529", "Oberaurach",
"499674", "Schönsee",
"493886", "Gadebusch",
"4936454", "Magdala",
"495121", "Hildesheim",
"495337", "Kissenbrück",
"494637", "Sterup",
"49581", "Uelzen",
"499622", "Hirschau\ Oberpfalz",
"493448", "Meuselwitz\ Thüringen",
"499935", "Stephansposching",
"497831", "Hausach",
"492753", "Erndtebrück",
"496707", "Windesheim",
"499408", "Altenthann",
"498867", "Rottenbuch\ Oberbayern",
"492833", "Kerken",
"493372", "Jüterbog",
"497751", "Waldshut",
"492623", "Ransbach\-Baumbach",
"4933989", "Sadenbeck",
"495258", "Salzkotten",
"499173", "Thalmässing",
"497581", "Saulgau",
"4937328", "Grossschirma",
"498856", "Penzberg",
"495439", "Bersenbrück",
"499741", "Bad\ Brückenau",
"495324", "Vienenburg",
"499535", "Pfarrweisach",
"494624", "Kropp",
"498392", "Markt\ Rettenbach",
"492983", "Winterberg\-Siedlinghausen",
"495536", "Holzminden\-Neuhaus",
"497742", "Klettgau",
"4939608", "Staven",
"494834", "Büsum",
"495372", "Meinersen",
"496134", "Mainz\-Kastel",
"492275", "Kerpen\-Buir",
"499929", "Ruhmannsfelden",
"492137", "Neuss\-Norf",
"498501", "Thyrnau",
"497226", "Bühl\-Sand",
"498138", "Schwabhausen\ bei\ Dachau",
"494672", "Langenhorn",
"494480", "Ovelgönne\-Strückhausen",
"4938203", "Bad\ Doberan",
"499075", "Glött",
"4939422", "Badersleben",
"4939389", "Schollene",
"495555", "Moringen\-Fredelsloh",
"495293", "Paderborn\-Dahl",
"499567", "Sesslach\-Gemünda",
"4935056", "Altenberg\ Sachsen",
"492165", "Jüchen",
"49395", "Neubrandenburg",
"498273", "Nordendorf",
"4938452", "Lalendorf",
"497449", "Baiersbronn\-Obertal",
"4933476", "Neuhardenberg",
"499556", "Geiselwind",
"493464", "Sangerhausen",
"495209", "Gütersloh\-Friedrichsdorf",
"496591", "Gerolstein",
"497802", "Oberkirch\ Baden",
"49971", "Bad\ Kissingen",
"496644", "Grebenhain",
"4938307", "Poseritz",
"492647", "Kesseling",
"4934636", "Schafstädt",
"4937433", "Gutenfürst",
"498065", "Tuntenhausen\-Schönau",
"4934386", "Dürrweitzschen\ bei\ Grimma",
"495464", "Alfhausen",
"4939421", "Osterwieck",
"4938451", "Hoppenrade\ bei\ Güstrow",
"492461", "Jülich",
"497546", "Oberteuringen",
"495732", "Löhne",
"492196", "Wermelskirchen",
"4936207", "Plaue\ Thüringen",
"497905", "Langenburg",
"496302", "Winnweiler",
"499238", "Röslau",
"499263", "Ludwigsstadt",
"495852", "Bleckede",
"497463", "Mühlheim\ an\ der\ Donau",
"49355", "Cottbus",
"497259", "Östringen\-Odenheim",
"4933743", "Blönsdorf",
"498585", "Grainet",
"494492", "Saterland",
"493841", "Wismar",
"499366", "Geroldshausen\ Unterfranken",
"499956", "Eichendorf\-Aufhausen",
"494843", "Viöl",
"498380", "Achberg",
"499188", "Postbauer\-Heng",
"494665", "Emmelsbüll\-Horsbüll",
"4939056", "Klüden",
"499357", "Gräfendorf\ Bayern",
"4935389", "Holzdorf\ Elster",
"495955", "Esterwegen",
"495365", "Wolfsburg\-Neindorf",
"492150", "Meerbusch\-Lank",
"492262", "Wiehl",
"492844", "Rheinberg\-Orsoy",
"497946", "Bretzfeld",
"497505", "Fronreute",
"498376", "Sulzberg\ Allgäu",
"496771", "St\ Goarshausen",
"499087", "Marktoffingen",
"499395", "Triefenstein",
"4935025", "Liebstadt",
"498532", "Griesbach\ im\ Rottal",
"498639", "Neumarkt\-Sankt\ Veit",
"4934496", "Nöbdenitz",
"497347", "Dietenheim",
"497300", "Roggenburg",
"495841", "Lüchow\ Wendland",
"495777", "Diepenau\-Essern",
"4939882", "Gollin",
"498635", "Pleiskirchen",
"499084", "Bissingen\ Schwaben",
"495246", "Verl",
"498043", "Jachenau",
"4934298", "Taucha\ bei\ Leipzig",
"499228", "Thurnau",
"492771", "Dillenburg",
"494144", "Himmelpforten",
"495722", "Bückeburg",
"496844", "Blieskastel\-Altheim",
"4938207", "Stäbelow",
"499245", "Obertrubach",
"4936451", "Buttelstedt",
"495774", "Wagenfeld\-Ströhen",
"4937464", "Schöneck\ Vogtland",
"495102", "Laatzen",
"492991", "Marsberg\-Bredelar",
"497344", "Blaubeuren",
"498825", "Krün",
"4936203", "Vieselbach",
"4939459", "Hasselfelde",
"493774", "Schwarzenberg",
"498682", "Laufen\ Salzach",
"4939881", "Ringenwalde\ bei\ Templin",
"4935268", "Stauchitz",
"499964", "Stallwang",
"496262", "Aglasterhausen",
"499354", "Rieneck",
"4936452", "Berlstedt",
"496150", "Weiterstadt",
"499303", "Eibelstadt",
"493994", "Malchin",
"494562", "Grömitz",
"4938429", "Glasin",
"4938303", "Sellin\ Ostseebad",
"49841", "Ingolstadt\ Donau",
"493722", "Limbach\-Oberfrohna",
"4937437", "Bad\ Elster",
"497255", "Graben\-Neudorf",
"4939088", "Letzlingen",
"496647", "Herbstein\-Stockhausen",
"492644", "Linz\ am\ Rhein",
"499206", "Mistelgau\-Obernsees",
"495467", "Voltlage",
"496578", "Salmtal",
"498574", "Wittibreut",
"498629", "Palling",
"497141", "Ludwigsburg\ Württemberg",
"492591", "Lüdinghausen",
"4935936", "Sohland\ Spree",
"495456", "Westerkappeln\-Velpe",
"495594", "Bovenden\-Reyershausen",
"495205", "Bielefeld\-Sennestadt",
"4936465", "Oberndorf\ bei\ Apolda",
"492302", "Witten",
"496196", "Bad\ Soden\ am\ Taunus",
"4933747", "Marzahna",
"495641", "Warburg",
"499142", "Treuchtlingen",
"496461", "Biedenkopf",
"4936026", "Struth\ bei\ Mühlhausen",
"499151", "Hersbruck",
"493594", "Bischofswerda",
"494352", "Damp",
"4934425", "Droyssig",
"494962", "Papenburg\-Aschendorf",
"495652", "Bad\ Sooden\-Allendorf",
"499564", "Bad\ Rodach",
"493641", "Jena",
"497445", "Pfalzgrafenweiler",
"497260", "Sinsheim\-Hilsbach",
"497152", "Leonberg\ Württemberg",
"499497", "Seubersdorf\ in\ der\ Oberpfalz",
"494643", "Gelting\ Angeln",
"497773", "Bodman\-Ludwigshafen",
"497428", "Rosenfeld",
"4939268", "Egeln",
"496165", "Breuberg",
"494865", "Osterhever",
"497821", "Lahr\ Schwarzwald",
"49711", "Stuttgart",
"498106", "Vaterstetten",
"495131", "Garbsen",
"499874", "Neuendettelsau",
"495508", "Gleichen\-Rittmarshausen",
"4939424", "Schwanebeck\ Sachsen\-Anhalt",
"495327", "Bad\ Grund\ Harz",
"493686", "Eisfeld",
"494627", "Dörpstedt",
"495482", "Tecklenburg",
"499632", "Waldsassen",
"499925", "Bayerisch\ Eisenstein",
"498726", "Schönau\ Niederbayern",
"494837", "Neuenkirchen\ Dithmarschen",
"499822", "Bechhofen\ an\ der\ Heide",
"49561", "Kassel",
"4933438", "Altlandsberg",
"496321", "Neustadt\ an\ der\ Weinstrasse",
"496275", "Rothenberg\ Odenwald",
"4937347", "Bärenstein\ Kreis\ Annaberg",
"4938454", "Kritzkow",
"49431", "Kiel",
"4936739", "Rottenbach",
"499948", "Eschlkam",
"493435", "Oschatz",
"4933835", "Golzow\ bei\ Brandenburg",
"495926", "Engden",
"497631", "Müllheim\ Baden",
"49361", "Erfurt",
"498251", "Aichach",
"494133", "Wittorf\ Kreis\ Lüneburg",
"496833", "Rehlingen\-Siersburg",
"494168", "Neu\ Wulmstorf\-Elstorf",
"496868", "Mettlach\-Tünsdorf",
"4936450", "Kranichfeld",
"495435", "Berge\ bei\ Quakenbrück",
"498034", "Brannenburg",
"496063", "Bad\ König",
"497333", "Laichingen",
"497958", "Rot\ Am\ See\-Brettheim",
"4939923", "Priborn",
"496623", "Rotenburg\ an\ der\ Fulda",
"493327", "Werder\ Havel",
"499436", "Nittenau",
"495686", "Schwarzenborn\ Knüll",
"494824", "Krempe",
"496124", "Bad\ Schwalbach",
"494975", "Westerholt\ Ostfriesland",
"497236", "Keltern",
"492331", "Hagen\ Westfalen",
"499677", "Oberviechtach\-Pullenried",
"496583", "Palzem",
"499548", "Mühlhausen\ Mittelfranken",
"494283", "Tarmstedt",
"498452", "Geisenfeld",
"496753", "Meisenheim",
"498145", "Mammendorf",
"498708", "Weihmichl\-Unterneuhausen",
"494795", "Garlstedt",
"496704", "Langenlonsheim",
"4933336", "Passow\ Kreis\ Uckermark",
"496172", "Bad\ Homburg\ von\ der\ Höhe",
"499525", "Königsberg\ in\ Bayern",
"494872", "Hanerau\-Hademarschen",
"495334", "Hornburg\ Kreis\ Wolfenbüttel",
"494634", "Husby",
"495908", "Wietmarschen\-Lohne",
"495281", "Bad\ Pyrmont",
"497558", "Illmensee",
"494757", "Wanna",
"495429", "Melle\-Wellingholzhausen",
"493334", "Eberswalde",
"498667", "Seeon\-Seebruck",
"492633", "Brohl\-Lützing",
"492045", "Bottrop\-Kirchhellen",
"494766", "Basdahl",
"492823", "Goch",
"498441", "Pfaffenhofen\ an\ der\ Ilm",
"496049", "Kefenrod",
"496287", "Limbach\ Baden",
"498656", "Anger",
"498027", "Dietramszell",
"496630", "Schwalmtal\-Storndorf",
"494871", "Hohenwestedt",
"496171", "Oberursel\ Taunus",
"494747", "Beverstedt",
"499236", "Nagel",
"4936944", "Rentwertshausen",
"497939", "Schrozberg\-Spielbach",
"496059", "Jossgrund",
"497525", "Aulendorf",
"495235", "Blomberg\ Lippe",
"492332", "Gevelsberg",
"498809", "Wessobrunn",
"494120", "Ellerhoop",
"495177", "Edemissen\-Abbensen",
"4934322", "Rosswein",
"4935388", "Klöden",
"496475", "Weilmünster\-Wolfenhausen",
"495873", "Eimke",
"498442", "Wolnzach",
"4938226", "Dierhagen\ Ostseebad",
"496743", "Bacharach",
"496094", "Weibersbrunn",
"4934321", "Leisnig",
"492750", "Diedenshausen",
"495282", "Schieder\-Schwalenberg",
"492385", "Hamm\-Rhynern",
"498241", "Buchloe",
"497632", "Badenweiler",
"4938485", "Dabel",
"49911", "Nuremberg",
"4939225", "Altengrabow",
"496322", "Bad\ Dürkheim",
"492484", "Mechernich\-Eiserfey",
"4937294", "Grünhainichen",
"498378", "Buchenberg\ bei\ Kempten",
"499631", "Tirschenreuth",
"495481", "Lengerich\ Westfalen",
"492377", "Wickede\ Ruhr",
"492620", "Neuhäusel\ Westerwald",
"497948", "Öhringen\-Ohrnberg",
"4934772", "Helbra",
"495132", "Lehrte",
"499170", "Schwanstetten",
"4939745", "Hetzdorf\ bei\ Strasburg",
"496374", "Weilerbach",
"497822", "Ettenheim",
"4933206", "Fichtenwalde",
"499186", "Lauterhofen\ Oberpfalz",
"4939396", "Neukirchen\ Altmark",
"4936428", "Stadtroda",
"497685", "Gutach\-Bleibach",
"4933841", "Belzig",
"495185", "Duingen",
"4939388", "Goldbeck\ Altm",
"4934771", "Querfurt",
"4935895", "Klitten",
"497436", "Messstetten\-Oberdigisheim",
"499333", "Sommerhausen",
"498252", "Schrobenhausen",
"494483", "Ovelgönne\-Grossenmeer",
"496462", "Gladenbach",
"494342", "Preetz\ Kreis\ Plön",
"4938233", "Prerow\ Ostseebad",
"499141", "Weissenburg\ in\ Bayern",
"495642", "Warburg\-Scherfede",
"49821", "Augsburg",
"492301", "Holzwickede",
"497455", "Dornhan",
"494604", "Grossenwiehe",
"495963", "Bawinkel",
"497142", "Bietigheim\-Bissingen",
"492592", "Selm",
"495353", "Königslutter\ am\ Elm",
"496695", "Jesberg",
"495304", "Meine",
"496734", "Flonheim",
"4936602", "Ronneburg\ Thüringen",
"4936333", "Heringen\ Helme",
"492737", "Netphen\-Deuz",
"493963", "Woldegk",
"499445", "Neustadt\ an\ der\ Donau",
"492603", "Bad\ Ems",
"496026", "Grossostheim",
"495083", "Hohne\ bei\ Celle",
"4933874", "Stechow\ Brandenburg",
"496657", "Hofbieber",
"4934224", "Belgern\ Sachsen",
"492654", "Polch",
"493304", "Velten",
"49340", "Dessau\ Anh",
"497564", "Bad\ Wurzach",
"4934606", "Teicha\ Sachsen\-Anhalt",
"497151", "Waiblingen",
"4937329", "Grosshartmannsdorf",
"495446", "Rehden",
"499773", "Unsleben",
"496666", "Freiensteinau",
"499428", "Kirchroth",
"4936601", "Hermsdorf\ Thüringen",
"495651", "Eschwege",
"494961", "Papenburg",
"494351", "Eckernförde",
"499260", "Wilhelmsthal\ Oberfranken",
"499152", "Hartenstein\ Mittelfranken",
"499602", "Neustadt\ an\ der\ Waldnaab",
"495101", "Pattensen",
"495563", "Kreiensen",
"492992", "Marsberg",
"497228", "Forbach",
"496727", "Gensingen",
"4938738", "Karow\ bei\ Lübz",
"498136", "Markt\ Indersdorf",
"497084", "Schömberg\ bei\ Neuenbürg",
"492724", "Finnentrop\-Serkenrode",
"499344", "Gerchsheim",
"498383", "Grünenbach\ Allgäu",
"495721", "Stadthagen",
"4936084", "Heuthen",
"4934976", "Gröbzig",
"492772", "Herborn\ Hessen",
"492104", "Mettmann",
"496107", "Kelsterbach",
"492153", "Nettetal\-Lobberich",
"4935609", "Drachhausen",
"497245", "Durmersheim",
"4933969", "Stepenitz",
"496008", "Echzell",
"498053", "Bad\ Endorf",
"493721", "Meinersdorf",
"495405", "Hasbergen\ Kreis\ Osnabrück",
"494103", "Wedel",
"498858", "Kochel\-Walchensee",
"494561", "Neustadt\ in\ Holstein",
"496803", "Mandelbachtal\-Ommersheim",
"492857", "Rees\-Mehr",
"496261", "Mosbach\ Baden",
"494154", "Trittau",
"496854", "Oberthal\ Saar",
"499255", "Marktleugast",
"493563", "Spremberg",
"499406", "Mintraching",
"497303", "Illertissen",
"498681", "Waging\ am\ See",
"493949", "Oschersleben\ Bode",
"494478", "Cappeln\ Oldenburg",
"497354", "Erolzheim",
"497964", "Stödtlen",
"494723", "Cuxhaven\-Altenwalde",
"492866", "Dorsten\-Rhade",
"4934672", "Rossleben",
"496364", "Nussbach\ Pfalz",
"499252", "Helmbrechts",
"4939080", "Kalbe\ Milde",
"494444", "Goldenstedt",
"498368", "Halblech",
"492957", "Wünnenberg\-Haaren",
"498333", "Babenhausen\ Schwaben",
"492367", "Henrichenburg",
"49201", "Essen",
"497251", "Bruchsal",
"493606", "Heiligenstadt\ Heilbad",
"495402", "Bissendorf\ Kreis\ Osnabrück",
"497034", "Ehningen",
"497726", "Bad\ Dürrheim",
"495606", "Zierenberg",
"493588", "Niesky",
"495849", "Waddeweitz",
"4934671", "Bad\ Frankenhausen\ Kyffhäuser",
"492775", "Driedorf",
"498170", "Strasslach\-Dingharting",
"497242", "Rheinstetten",
"498631", "Mühldorf\ am\ Inn",
"499378", "Eichenbühl\-Riedern",
"498821", "Garmisch\-Partenkirchen",
"492443", "Mechernich",
"499605", "Weiherhammer",
"49811", "Hallbergmoos",
"4933432", "Müncheberg",
"4935364", "Lebusa",
"495190", "Soltau\-Emmingen",
"4934605", "Gröbers",
"499241", "Pegnitz",
"497441", "Freudenstadt",
"4934975", "Görzig\ Kreis\ Köthen",
"492566", "Legden",
"495167", "Walsrode\-Westenholz",
"497656", "Schluchsee",
"499155", "Simmelsdorf",
"493863", "Crivitz",
"496784", "Weierbach",
"493838", "Bergen\ auf\ Rügen",
"496161", "Brensbach",
"496503", "Hermeskeil",
"498558", "Hohenau\ Niederbayern",
"494861", "Tönning",
"494254", "Eystrup",
"499442", "Riedenburg",
"492557", "Wettringen\ Kreis\ Steinfurt",
"493628", "Arnstadt",
"4936949", "Obermassfeld\-Grimmenthal",
"494203", "Weyhe\ bei\ Bremen",
"496554", "Waxweiler",
"4934901", "Rosslau\ Elbe",
"495156", "Coppenbrügge",
"497667", "Breisach\ am\ Rhein",
"496207", "Wald\-Michelbach",
"496692", "Neustadt\ Hessen",
"497708", "Geisingen\-Leipferdingen",
"497145", "Markgröningen",
"492595", "Olfen",
"4939364", "Dolle",
"492253", "Bad\ Münstereifel",
"499646", "Freihung",
"494328", "Rickling",
"492204", "Bensberg",
"499451", "Schierling",
"496465", "Breidenbach\ bei\ Biedenkopf",
"495645", "Borgentreich\-Borgholz",
"497128", "Sonnenbühl",
"495068", "Elze\ Leine",
"498236", "Fischach",
"495033", "Wunstorf\-Grossenheidorn",
"495201", "Halle\ Westfalen",
"496599", "Weidenbach\ bei\ Gerolstein",
"495863", "Zernien",
"499197", "Egloffstein",
"497452", "Nagold",
"495838", "Gross\ Oesingen",
"4935604", "Krieschow",
"492762", "Wenden\ Südsauerland",
"495182", "Gronau\ Leine",
"499681", "Windischeschenbach",
"495431", "Quakenbrück",
"4934291", "Borsdorf",
"49741", "Rottweil",
"498406", "Böhmfeld",
"498593", "Untergriesbach",
"495573", "Uslar\-Volpriehausen",
"497682", "Elzach",
"4936458", "Bad\ Berka",
"4939082", "Mieste",
"4933654", "Fünfeichen",
"492434", "Wegberg",
"4939003", "Jübar",
"4934292", "Brandis\ bei\ Wurzen",
"495277", "Höxter\-Fürstenau",
"4938225", "Trinwillershagen",
"493573", "Senftenberg",
"497486", "Horb\-Altheim",
"499921", "Regen",
"4939888", "Lychen",
"498509", "Ruderting",
"495135", "Burgwedel\-Fuhrberg",
"496348", "Offenbach\ an\ der\ Queich",
"494468", "Friedeburg\-Reepsholt",
"4939485", "Gernrode\ Harz",
"494433", "Dötlingen",
"497974", "Bühlerzell",
"499383", "Wiesentheid",
"497825", "Kippenheim",
"498344", "Westendorf\ bei\ Kaufbeuren",
"497043", "Maulbronn",
"497635", "Schliengen",
"493431", "Döbeln",
"499749", "Oberbach\ Unterfranken",
"496271", "Eberbach\ Baden",
"4933964", "Fretzdorf",
"4939081", "Kakerbeck\ Sachsen\-Anhalt",
"496325", "Lambrecht\ Pfalz",
"498152", "Herrsching\ am\ Ammersee",
"492041", "Bottrop",
"4935473", "Neu\ Lübbenau",
"495973", "Neuenkirchen\ Kreis\ Steinfurt",
"4939746", "Krackow",
"4936783", "Gehren\ Thüringen",
"492427", "Nideggen",
"498773", "Neufahrn\ in\ Niederbayern",
"4936702", "Lauscha",
"492382", "Ahlen\ Westfalen",
"495285", "Bad\ Pyrmont\-Kleinenberg",
"496424", "Ebsdorfergrund",
"4933053", "Zehlendorf\ Kreis\ Oberhavel",
"496472", "Weilmünster",
"4938486", "Gustävel",
"4939604", "Wildberg\ bei\ Altentreptow",
"4939262", "Güsten\ Anh",
"499286", "Oberkotzau",
"4939226", "Hohenziatz",
"498445", "Gerolsbach",
"495044", "Springe\-Eldagsen",
"499763", "Sulzdorf\ an\ der\ Lederhecke",
"499738", "Rottershausen",
"496676", "Hohenroda\ Hessen",
"497839", "Schapbach",
"497522", "Wangen\ im\ Allgäu",
"495129", "Söhlde",
"494971", "Esens",
"492335", "Wetter\ Ruhr",
"495232", "Lage\ Lippe",
"499270", "Creussen",
"4936701", "Lichte",
"4933205", "Michendorf",
"4937324", "Reinsberg\ Sachsen",
"496339", "Grosssteinhausen",
"4939395", "Wanzer",
"493973", "Pasewalk",
"49921", "Bayreuth",
"499521", "Hassfurt",
"494791", "Osterholz\-Scharmbeck",
"4938787", "Glöwen",
"498141", "Fürstenfeldbruck",
"4935974", "Hinterhermsdorf",
"497629", "Tegernau\ Baden",
"497574", "Gammertingen",
"492052", "Velbert\-Langenberg",
"494684", "Langeness\ Hallig",
"4933982", "Hoppenrade\ Kreis\ Prignitz",
"496471", "Weilburg",
"4939037", "Pretzier",
"4933836", "Butzow\ bei\ Brandenburg",
"495384", "Seesen\-Gross\ Rhüden",
"4935953", "Burkau",
"492381", "Hamm\ Westfalen",
"494233", "Blender",
"498564", "Johanniskirchen",
"494268", "Bötersen",
"496533", "Morbach\ Hunsrück",
"492923", "Lippetal\-Herzfeld",
"496568", "Wolsfeld",
"498151", "Starnberg",
"492051", "Velbert",
"4939997", "Jarmen",
"498142", "Olching",
"494792", "Worpswede",
"494875", "Stafstedt",
"499522", "Eltmann",
"496175", "Friedrichsdorf\ Taunus",
"492234", "Frechen",
"494537", "Sülfeld\ Holstein",
"497763", "Murg",
"496237", "Maxdorf",
"4935454", "Uckro",
"494924", "Moormerland\-Oldersum",
"497738", "Steisslingen",
"4933981", "Putlitz",
"495808", "Gerdau",
"499574", "Marktzeuln",
"495231", "Detmold",
"494972", "Langeoog",
"492683", "Asbach\ Westerwald",
"498206", "Egling\ an\ der\ Paar",
"4936608", "Seelingstädt\ bei\ Gera",
"49721", "Karlsruhe",
"495054", "Bergen\-Sülze",
"495764", "Steyerberg",
"49941", "Regensburg",
"4939953", "Schwinkendorf",
"496187", "Schöneck",
"4938731", "Lübz",
"4933335", "Pinnow\ Kreis\ Uckermark",
"492523", "Wadersloh",
"496358", "Kriegsfeld",
"497681", "Waldkirch\ Breisgau",
"498303", "Waltenhofen",
"493379", "Mahlow",
"497053", "Bad\ Teinach\-Zavelstein",
"499682", "Erbendorf",
"495432", "Löningen",
"495181", "Alfeld\ Leine",
"493636", "Greussen",
"492761", "Olpe\ Biggesee",
"497383", "Münsingen\-Buttenhausen",
"499825", "Herrieden",
"4938424", "Bobitz",
"499974", "Traitsching",
"496272", "Hirschhorn\ Neckar",
"494336", "Owschlag",
"498245", "Türkheim\ Wertach",
"4936927", "Unterellen",
"4938732", "Gallin\ bei\ Lübz",
"495636", "Lichtenfels\-Goddelsheim",
"494183", "Jesteburg",
"493764", "Meerane",
"498460", "Berching\-Holnstein",
"495826", "Suderburg",
"499848", "Simmershofen",
"4933673", "Weichensdorf",
"497136", "Bad\ Friedrichshall",
"4939454", "Elbingerode\ Harz",
"494524", "Scharbeutz\-Pönitz",
"492227", "Bornheim\-Merten",
"496224", "Sandhausen\ Baden",
"499922", "Zwiesel",
"499635", "Bärnau",
"498084", "Taufkirchen\ Vils",
"495379", "Sassenburg\-Grussendorf",
"495485", "Ladbergen",
"492243", "Eitorf",
"49760", "Oberried\ Breisgau",
"499656", "Moosbach\ bei\ Vohenstrauss",
"494550", "Bühnsdorf",
"499441", "Kelheim",
"494862", "Garding",
"496162", "Reinheim\ Odenwald",
"494355", "Rieseby",
"494965", "Surwold",
"496393", "Fischbach\ bei\ Dahn",
"495655", "Wanfried",
"497442", "Baiersbronn",
"497451", "Horb\ am\ Neckar",
"494776", "Osten\-Altendorf",
"492305", "Castrop\-Rauxel",
"495202", "Oerlinghausen",
"497646", "Weisweil\ Breisgau",
"4935207", "Moritzburg",
"499708", "Bad\ Bocklet",
"499145", "Solnhofen",
"499452", "Langquaid",
"494244", "Harpstedt",
"492547", "Rosendahl\-Osterwick",
"498548", "Vilshofen\-Sandbach",
"496544", "Rhaunen",
"499128", "Feucht",
"498677", "Burghausen\ Salzach",
"4934328", "Hartha\ bei\ Döbeln",
"492678", "Büchel\ bei\ Cochem",
"496691", "Schwalmstadt",
"495146", "Wietze",
"498320", "Missen\-Wilhams",
"4935935", "Kleinwelka",
"4936422", "Reinstädt\ Thüringen",
"496265", "Billigheim\ Baden",
"495859", "Thomasburg",
"4936734", "Leutenberg",
"495401", "Georgsmarienhütte",
"4938459", "Laage",
"494499", "Barssel",
"497252", "Bretten",
"493725", "Zschopau",
"4934461", "Nebra\ Unstrut",
"492453", "Heinsberg\-Randerath",
"496407", "Rabenau\ Hessen",
"498685", "Kirchanschöring",
"4939382", "Kamern",
"492404", "Alsdorf\ Rheinland",
"492269", "Kierspe\-Rönsahl",
"49365", "Gera",
"499251", "Münchberg",
"496440", "Kölschhausen",
"494950", "Holtland",
"499242", "Gössweinstein",
"494454", "Jade",
"492947", "Anröchte",
"496296", "Ahorn\ Baden",
"494403", "Bad\ Zwischenahn",
"4936421", "Camburg",
"4934343", "Regis\-Breitingen",
"495105", "Barsinghausen",
"4933848", "Raben",
"498822", "Oberammergau",
"499726", "Euerbach",
"4936025", "Körner",
"4934426", "Kayna",
"494178", "Radbruch",
"4934462", "Laucha\ Unstrut",
"499106", "Markt\ Erlbach",
"496073", "Babenhausen\ Hessen",
"4933397", "Wandlitz",
"495725", "Lindhorst\ bei\ Stadthagen",
"4939207", "Colbitz",
"499163", "Dachsbach",
"4933878", "Nennhausen",
"498330", "Legau",
"4933475", "Letschin",
"492296", "Reichshof\-Brüchermühle",
"4935451", "Dahme\ Brandenburg",
"497391", "Ehingen\ Donau",
"4939061", "Weferlingen",
"4933984", "Blumenthal\ bei\ Pritzwalk",
"492944", "Rietberg\-Mastholte",
"495941", "Neuenhaus\ Dinkel",
"497502", "Wolpertswende",
"499392", "Faulbach\ Unterfranken",
"494191", "Kaltenkirchen\ Holstein",
"493362", "Erkner",
"498535", "Haarbach",
"495109", "Ronnenberg",
"494466", "Wittmund\-Ardorf",
"496346", "Annweiler\ am\ Trifels",
"498741", "Vilsbiburg",
"4935055", "Höckendorf\ bei\ Dippoldiswalde",
"493941", "Halberstadt",
"499856", "Dürrwangen",
"498752", "Au\ in\ der\ Hallertau",
"494662", "Leck",
"4939062", "Bebertal",
"492265", "Reichshof\-Eckenhagen",
"495362", "Wolfsburg\-Fallersleben",
"495952", "Sögel",
"4935452", "Golssen",
"492440", "Nettersheim\-Tondorf",
"495855", "Nahrendorf",
"496269", "Gundelsheim\ Württemberg",
"495193", "Schneverdingen",
"499867", "Geslau",
"494495", "Friesoythe\-Thüle",
"498582", "Röhrnbach",
"496404", "Lich\ Hessen",
"4935203", "Tharandt",
"494943", "Grossefehn",
"496453", "Gemünden\ Wohra",
"4934635", "Bad\ Lauchstädt",
"492407", "Herzogenrath\-Kohlscheid",
"4934385", "Mutzschen",
"495541", "Hann\.\ Münden",
"494394", "Bokhorst",
"498622", "Tacherting\-Peterskirchen",
"496305", "Hochspeyer",
"4939055", "Hörsingen",
"493860", "Raben\ Steinfeld",
"495694", "Diemelstadt",
"4934243", "Bad\ Düben",
"496500", "Waldrach",
"4936730", "Sitzendorf",
"492691", "Adenau",
"492309", "Waltrop",
"496678", "Wildeck\-Hönebach",
"499736", "Oberthulba",
"499901", "Hengersberg\ Bayern",
"497194", "Spiegelberg",
"494247", "Affinghausen",
"497805", "Appenweier",
"499149", "Weissenburg\-Suffersheim",
"4939889", "Boitzenburg",
"4939451", "Wasserleben",
"498062", "Bruckmühl\ Mangfall",
"4938466", "Jürgenshagen",
"495659", "Ringgau",
"492162", "Viersen",
"497071", "Tübingen",
"4938422", "Neukloster",
"4934495", "Dobitschen",
"499288", "Bad\ Steben",
"494543", "Nusse",
"496243", "Monsheim",
"4933393", "Gross\ Schönebeck\ Kreis\ Barnim",
"4936459", "Blankenhain\ Thüringen",
"4939203", "Barleben",
"497159", "Renningen",
"493541", "Calau",
"499072", "Lauingen\ Donau",
"493735", "Marienberg\ Sachsen",
"4934347", "Oelzschau\ bei\ Borna",
"492393", "Sundern\-Allendorf",
"495552", "Katlenburg",
"4939452", "Ilsenburg",
"499664", "Hahnbach",
"4935026", "Dürrröhrsdorf\-Dittersbach",
"498426", "Walting\ Kreis\ Eichstätt",
"49385", "Schwerin",
"497745", "Jestetten",
"497531", "Konstanz",
"4935384", "Steinsdorf\ bei\ Jessen",
"492272", "Bedburg\ Erft",
"495375", "Müden\ Aller",
"499639", "Mähring",
"495221", "Herford",
"49551", "Göttingen",
"499977", "Arnschwang",
"499532", "Maroldsweisach",
"492224", "Bad\ Honnef",
"494308", "Schwedeneck",
"494527", "Bosau",
"497473", "Mössingen",
"498395", "Tannheim\ Württemberg",
"496227", "Walldorf\ Baden",
"494934", "Marienhafe",
"497728", "Niedereschach",
"495608", "Söhrewald",
"493586", "Neugersdorf\ Sachsen",
"499829", "Flachslanden",
"498249", "Ettringen\ Wertach",
"499376", "Collenberg",
"4939033", "Wallstawe",
"494223", "Ganderkesee\-Bookholzberg",
"496523", "Holsthum",
"492933", "Sundern\ Sauerland",
"495586", "Wieda",
"492358", "Meinerzhagen\-Valbert",
"495767", "Warmsen",
"496184", "Langenselbold",
"4936948", "Römhild",
"49906", "Donauwörth",
"494884", "Schwabstedt",
"498366", "Oy\-Mittelberg",
"4939993", "Hohenmocker",
"496761", "Simmern\ Hunsrück",
"493375", "Königs\ Wusterhausen",
"49351", "Dresden",
"497126", "Burladingen\-Melchingen",
"495066", "Sarstedt",
"498263", "Breitenbrunn\ Schwaben",
"494534", "Steinburg\ Kreis\ Storman",
"492237", "Kerpen\ Rheinland\-Türnich",
"4936424", "Kahla\ Thüringen",
"498238", "Gessertshausen",
"496234", "Mutterstadt",
"499932", "Osterhofen",
"492175", "Leichlingen\ Rheinland",
"498801", "Seeshaupt",
"494927", "Krummhörn\-Loquard",
"4937757", "Rittersgrün",
"499625", "Kastl\ bei\ Amberg",
"498459", "Manching",
"4936732", "Könitz",
"495836", "Wittingen\-Radenbeck",
"496051", "Gelnhausen",
"4935033", "Rosenthal\ Sächsische\ Schweiz",
"494326", "Wankendorf",
"499648", "Neustadt\ am\ Kulm",
"496683", "Ehrenberg\ Rhön",
"4939957", "Gielow",
"49871", "Landshut",
"495626", "Bad\ Zwesten",
"497931", "Bad\ Mergentheim",
"497706", "Oberbaldingen",
"4939384", "Arendsee\ Altmark",
"49591", "Lingen\ \(Ems\)",
"499835", "Ehingen\ Mittelfranken",
"495422", "Melle",
"498556", "Haidmühle",
"4933677", "Glienicke\ bei\ Beeskow",
"492471", "Roetgen\ Eifel",
"495158", "Hemeringen",
"4937298", "Oelsnitz\ Erzgebirge",
"49391", "Magdeburg",
"499273", "Bad\ Berneck\ im\ Fichtelgebirge",
"4936731", "Unterloquitz",
"4934653", "Rottleberode",
"496042", "Büdingen\ Hessen",
"4933235", "Friesack",
"492533", "Münster\-Nienberge",
"492568", "Heek",
"4934464", "Freyburg\ Unstrut",
"493836", "Wolgast",
"495474", "Stemwede\-Dielingen",
"498075", "Amerang",
"4936923", "Treffurt",
"496381", "Kusel",
"498546", "Windorf\-Otterskirchen",
"496335", "Trulben",
"497932", "Niederstetten\ Württemberg",
"4934779", "Abberode",
"497625", "Zell\ im\ Wiesental",
"495148", "Steinhorst\ Niedersachsen",
"495705", "Petershagen\-Windheim",
"4933933", "Lindow\ Mark",
"4939007", "Tangeln",
"499126", "Eckental",
"493421", "Torgau",
"492676", "Ulmen",
"494778", "Wingst",
"494423", "Fedderwarden",
"496052", "Bad\ Orb",
"4935361", "Schlieben",
"4933849", "Wiesenburg\ Mark",
"497835", "Zell\ am\ Harmersbach",
"497577", "Veringenstadt",
"4935600", "Döbern\ NL",
"494230", "Verden\-Walle",
"4938325", "Rolofshagen",
"498802", "Huglfing",
"499931", "Plattling",
"492339", "Sprockhövel\-Hasslinghausen",
"496382", "Lauterecken",
"4939825", "Wokuhl",
"4933093", "Fürstenberg\ Havel",
"492424", "Vettweiss",
"496427", "Cölbe\-Schönstadt",
"497273", "Hagenbach\ Pfalz",
"4939428", "Pabstorf",
"4939776", "Hintersee",
"496041", "Glauburg",
"4935326", "Schönborn\ Kreis\ Elbe\-Elster",
"4938458", "Zehna",
"499658", "Georgenberg",
"4935362", "Schönewalde\ bei\ Herzberg",
"4938296", "Rerik\ Ostseebad",
"4933434", "Herzfelde\ bei\ Strausberg",
"492472", "Monschau",
"492680", "Mündersbach",
"4933766", "Teupitz",
"4938855", "Lübtheen",
"495421", "Dissen\ am\ Teutoburger\ Wald",
"4937606", "Lengenfeld\ Vogtland",
"497977", "Oberrot\ bei\ Gaildorf",
"4939856", "Beenz\ bei\ Prenzlau",
"494176", "Marschacht",
"498347", "Friesenried",
"496876", "Weiskirchen\ Saar",
"4939361", "Lüderitz",
"495274", "Nieheim",
"492520", "Wadersloh\-Diestedde",
"496329", "Weidenthal\ Pfalz",
"4939295", "Zuchau",
"4939600", "Zwiedorf",
"499745", "Wildflecken",
"499531", "Ebern",
"498505", "Hutthurm",
"496298", "Möckmühl",
"495139", "Burgwedel",
"492325", "Wanne\-Eickel",
"495222", "Bad\ Salzuflen",
"4935477", "Rietzneuendorf\-Friedrichshof",
"492271", "Bergheim\ Erft",
"497376", "Langenenslingen",
"498294", "Horgau",
"499473", "Kallmünz",
"499728", "Wülfershausen\ Unterfranken",
"495746", "Rödinghausen",
"497532", "Meersburg",
"4938826", "Dassow",
"4939362", "Grieben\ bei\ Tangerhütte",
"497755", "Weilheim\ Kreis\ Waldshut",
"4936256", "Wechmar",
"4937320", "Mulda\ Sachsen",
"496762", "Kastellaun",
"4938783", "Dallmin",
"494180", "Königsmoor",
"498463", "Greding",
"4935825", "Kodersdorf",
"496434", "Bad\ Camberg",
"497585", "Ostrach",
"4938356", "Behrenhoff",
"498259", "Schiltberg",
"4934904", "Oranienbaum",
"498061", "Bad\ Aibling",
"4935602", "Drebkau",
"494349", "Dänischenhagen",
"495806", "Barum\ bei\ Bad\ Bevensen",
"496204", "Viernheim",
"494295", "Emtinghausen",
"494553", "Geschendorf",
"492692", "Kelberg",
"492207", "Kürten\-Dürscheid",
"494504", "Ratekau",
"496253", "Fürth\ Odenwald",
"4935264", "Strehla",
"4939971", "Gnoien",
"496595", "Dockweiler",
"498208", "Eurasburg\ bei\ Augsburg",
"499194", "Ebermannstadt",
"498621", "Trostberg",
"499805", "Burgoberbach",
"492599", "Ascheberg\-Herbern",
"4933652", "Neuzelle",
"497736", "Tengen",
"495542", "Witzenhausen",
"4939084", "Lindstedt",
"492465", "Inden",
"495164", "Hodenhagen",
"497024", "Wendlingen\ am\ Neckar",
"4934294", "Rackwitz",
"4935601", "Peitz",
"495551", "Northeim",
"496787", "Niederbrombach",
"499071", "Dillingen\ an\ der\ Donau",
"4939972", "Walkendorf",
"493542", "Lübbenau\ Spreewald",
"496566", "Körperich",
"494266", "Brockel",
"497664", "Freiburg\-Tiengen",
"4933926", "Herzberg\ Mark",
"494257", "Schweringen",
"497072", "Gomaringen",
"492554", "Laer\ Kreis\ Steinfurt",
"4933962", "Heiligengrabe",
"492161", "Mönchengladbach",
"496557", "Hallschlag",
"4937468", "Treuen\ Vogtland",
"498323", "Immenstadt\ im\ Allgäu",
"499846", "Ipsheim",
"498742", "Velden\ Vils",
"493361", "Fürstenwalde\ Spree",
"494192", "Bad\ Bramstedt",
"495828", "Himbergen",
"499391", "Marktheidenfeld",
"4936704", "Steinheid",
"496775", "Strüth\ Taunus",
"496086", "Grävenwiesbach",
"497138", "Schwaigern",
"498226", "Bibertal",
"497163", "Ebersbach\ an\ der\ Fils",
"495023", "Liebenau\ Kreis\ Nieburg\ Weser",
"495942", "Uelsen",
"495845", "Bergen\ Dumme",
"492779", "Greifenstein\-Beilstein",
"497392", "Laupheim",
"4937321", "Frankenstein\ Sachsen",
"4939602", "Kleeth",
"495663", "Spangenberg",
"4936646", "Tanna\ bei\ Schleiz",
"4939264", "Kroppenstedt",
"4935971", "Sebnitz",
"499502", "Frensdorf",
"494338", "Alt\ Duvenstedt",
"494363", "Lensahn",
"496443", "Ehringshausen\ Dill",
"494953", "Bunde",
"498581", "Waldkirchen\ Niederbayern",
"492903", "Meschede\-Freienohl",
"493663", "Schleiz",
"494447", "Vechta\-Langförden",
"492954", "Rüthen\-Oestereiden",
"492364", "Haltern\ Westfalen",
"4939601", "Friedland",
"495361", "Wolfsburg",
"495951", "Werlte",
"4937322", "Brand\-Erbisdorf",
"494661", "Niebüll",
"4937366", "Rübenau",
"498751", "Mainburg",
"496356", "Carlsberg\ Pfalz",
"496752", "Kirn\ Nahe",
"4936023", "Horsmar",
"4935722", "Lauta\ bei\ Hoyerswerda",
"4934497", "Langenleuba\-Niederhain",
"4938871", "Mühlen\ Eichsen",
"496173", "Kronberg\ im\ Taunus",
"492436", "Wegberg\-Rödgen",
"494873", "Aukrug",
"4933362", "Liepe\ Kreis\ Barnim",
"4936379", "Holzengel",
"4935434", "Altdöbern",
"497765", "Rickenbach\ Hotzenwald",
"498269", "Unteregg\ bei\ Mindelheim",
"493871", "Parchim",
"498404", "Oberdolling",
"496582", "Freudenburg",
"492685", "Flammersfeld",
"4934345", "Bad\ Lausick",
"494282", "Sittensen",
"4935242", "Nossen",
"498453", "Reichertshofen\ Oberbayern",
"496408", "Buseck",
"492822", "Emmerich",
"4938872", "Rehna",
"499134", "Neunkirchen\ am\ Brand",
"4939057", "Rätzlingen\ Sachsen\-Anhalt",
"497620", "Schopfheim\-Gersbach",
"492948", "Lippstadt\-Rebbeke",
"4933361", "Joachimsthal",
"497484", "Simmersfeld",
"4935933", "Neschwitz",
"497976", "Sulzbach\-Laufen",
"494235", "Langwedel\-Etelsen",
"4935241", "Lommatzsch",
"492874", "Isselburg",
"492632", "Andernach",
"496741", "St\ Goar",
"499279", "Mistelgau",
"498346", "Pforzen",
"492925", "Warstein\-Allagen",
"496535", "Osann\-Monzel",
"494177", "Drage\ Elbe",
"499823", "Leutershausen",
"497385", "Gomadingen",
"4936206", "Grossfahner",
"4939242", "Prödel",
"4936841", "Schleusingen",
"4936624", "Teichwolframsdorf",
"4938752", "Zierzow\ bei\ Ludwigslust",
"499284", "Schwarzenbach\ an\ der\ Saale",
"498243", "Fuchstal",
"494185", "Marxen\ Auetal",
"4939722", "Sarnow\ bei\ Anklam",
"4935694", "Gosda\ bei\ Klinge",
"4938306", "Samtens",
"495483", "Lienen",
"499633", "Mitterteich",
"4934637", "Frankleben",
"496426", "Fronhausen",
"4933970", "Neustadt\ Dosse",
"4934954", "Roitzsch\ bei\ Bitterfeld",
"497332", "Lauterstein",
"4939933", "Vollrathsruhe",
"496622", "Bebra",
"492525", "Beckum\-Neubeckum",
"4933477", "Trebnitz\ bei\ Müncheberg",
"4938751", "Picher",
"4936842", "Oberhof\ Thüringen",
"497576", "Krauchenwies",
"4939241", "Leitzkau",
"494481", "Hatten\-Sandkrug",
"497055", "Neuweiler\ Kreis\ Calw",
"496674", "Friedewald\ Hessen",
"494132", "Amelinghausen",
"498678", "Marktl",
"499127", "Rosstal\ Mittelfranken",
"496832", "Beckingen\-Reimsbach",
"4939721", "Liepen\ bei\ Anklam",
"4934202", "Delitzsch",
"492677", "Lutzerath",
"499331", "Ochsenfurt",
"4935057", "Hermsdorf\ Erzgebirge",
"492548", "Dülmen\-Rorup",
"496062", "Erbach\ Odenwald",
"498547", "Osterhofen\-Gergweis",
"492354", "Meinerzhagen",
"492964", "Brilon\-Alme",
"492303", "Unna",
"4935240", "Tauscha\ bei\ Grossenhain",
"496357", "Standenbühl",
"4933675", "Tauche",
"4936874", "Schönbrunn\ bei\ Hildburghaus",
"496188", "Kahl\ am\ Main",
"499143", "Pappenheim\ Mittelfranken",
"498761", "Moosburg\ an\ der\ Isar",
"493342", "Neuenhagen\ bei\ Berlin",
"494446", "Bakum\ Kreis\ Vechta",
"4933237", "Paulinenaue",
"4933601", "Podelzig",
"495961", "Haselünne",
"495351", "Helmstedt",
"492245", "Much",
"497153", "Plochingen",
"494642", "Kappeln\ Schlei",
"4937755", "Schönheide\ Erzgebirge",
"492601", "Nauort",
"493961", "Altentreptow",
"494938", "Hagermarsch",
"495604", "Grossalmerode",
"497724", "St\ Georgen\ im\ Schwarzwald",
"494353", "Ascheffel",
"494963", "Dörpen",
"495653", "Sontra",
"492228", "Remagen\-Rolandseck",
"496087", "Waldems",
"4939955", "Jürgenstorf",
"496395", "Münchweiler\ an\ der\ Rodalb",
"499847", "Ergersheim",
"499771", "Bad\ Neustadt\ an\ der\ Saale",
"496249", "Guntersblum",
"4933602", "Alt\ Zeschdorf",
"4938794", "Cumlosen",
"4933333", "Tantow",
"494256", "Hilgermissen",
"4933972", "Breddin",
"4936969", "Merkers",
"494405", "Edewecht",
"496556", "Pronsfeld",
"4937209", "Einsiedel\ bei\ Chemnitz",
"495561", "Einbeck",
"495103", "Wennigsen\ Deister",
"4938844", "Gülze",
"495154", "Aerzen",
"492151", "Krefeld",
"496567", "Oberkail",
"498042", "Lenggries",
"4939926", "Grabowhöfe",
"494267", "Lauenbrück",
"4938750", "Malliss",
"492564", "Vreden",
"497654", "Löffingen",
"495723", "Bad\ Nenndorf",
"498381", "Lindenberg\ im\ Allgäu",
"496786", "Kempfeld",
"496238", "Dirmstein",
"495199", "Schneverdingen\-Heber",
"4933971", "Kyritz\ Brandenburg",
"496263", "Neckargerach",
"4935955", "Pulsnitz",
"499302", "Rottendorf\ Unterfranken",
"498234", "Bobingen",
"494101", "Pinneberg",
"494563", "Scharbeutz\-Haffkrug",
"493723", "Hohenstein\-Ernstthal",
"498051", "Prien\ am\ Chiemsee",
"494721", "Cuxhaven",
"495840", "Schnackenburg",
"4934929", "Straach",
"492455", "Waldfeucht",
"4939344", "Güsen",
"492206", "Overath",
"499644", "Pressath",
"49671", "Bad\ Kreuznach",
"4936840", "Trusetal",
"4933084", "Gutengermendorf",
"498683", "Tittmoning",
"493561", "Guben",
"495807", "Altenmedingen",
"498179", "Eurasburg\ an\ der\ Loisach",
"4939393", "Werben\ Elbe",
"498382", "Lindau\ Bodensee",
"4933203", "Kleinmachnow",
"498427", "Wellheim",
"492773", "Haiger",
"492428", "Niederzier",
"496449", "Ehringshausen\-Katzenfurt",
"494959", "Dollart",
"498041", "Bad\ Tölz",
"492152", "Kempen",
"495850", "Neetze",
"492445", "Schleiden\ Eifel",
"499603", "Floss",
"492993", "Marsberg\-Canstein",
"495562", "Dassel\-Markoldendorf",
"4935827", "Nieder\-Seifersdorf",
"4933452", "Neulewin",
"499654", "Pleystein",
"4938728", "Domsühl",
"494246", "Twistringen\-Heiligenloh",
"498335", "Fellheim",
"493562", "Forst\ Lausitz",
"4933055", "Kremmen",
"497302", "Pfaffenhofen\ an\ der\ Roth",
"4939297", "Eickendorf\ Kreis\ Schönebeck",
"499737", "Wartmannsroth",
"495144", "Wathlingen",
"494722", "Cuxhaven\-Altenbruch",
"4935475", "Straupitz",
"498052", "Aschau\ im\ Chiemgau",
"4933451", "Heckelberg",
"494774", "Hechthausen",
"494102", "Ahrensburg",
"497644", "Kenzingen",
"496802", "Völklingen\-Lauterbach",
"4936785", "Gräfinau\-Angstedt",
"492255", "Euskirchen\-Flamersheim",
"497143", "Besigheim",
"495962", "Herzlake",
"492593", "Ascheberg\ Westfalen",
"495352", "Schöningen",
"4934441", "Hohenmölsen",
"4939827", "Schwarz\ bei\ Neustrelitz",
"492406", "Herzogenrath",
"4933708", "Rangsdorf",
"493341", "Strausberg",
"498762", "Wartenberg\ Oberbayern",
"4938378", "Heringsdorf\ Seebad",
"494343", "Laboe",
"4938223", "Saal\ Vorpom",
"496438", "Hünfelden",
"495035", "Gross\ Munzel",
"498434", "Rennertshofen",
"495643", "Borgentreich",
"4939402", "Völpke",
"4939483", "Ballenstedt",
"499857", "Schopfloch\ Mittelfranken",
"494559", "Wensin",
"495865", "Gusborn",
"494467", "Wittmund\-Funnix",
"496347", "Hochstadt\ Pfalz",
"499772", "Bischofsheim\ an\ der\ Rhön",
"493643", "Weimar\ Thüringen",
"4939005", "Kusey",
"499104", "Emskirchen",
"492509", "Nottuln\-Appelhülsen",
"495278", "Höxter\-Ovenhausen",
"493865", "Holthusen",
"499153", "Schnaittach",
"492602", "Montabaur",
"493962", "Penzlin\ bei\ Waren",
"492297", "Wildbergerhütte",
"494456", "Varel\-Altjührden",
"495082", "Langlingen",
"496505", "Kordel",
"496294", "Krautheim\ Jagst",
"497771", "Stockach",
"494205", "Ottersberg",
"4934363", "Cavertitz",
"4938327", "Elmenhorst\ Vorpom",
"494641", "Süderbrarup",
"495341", "Salzgitter",
"4939401", "Neuwegersleben",
"499724", "Stadtlauringen",
"495168", "Walsrode\-Stellichte",
"49331", "Potsdam",
"494435", "Grossenkneten",
"499097", "Marxheim",
"497823", "Seelbach\ Schutter",
"499385", "Kolitzheim",
"497633", "Staufen\ im\ Breisgau",
"497045", "Oberderdingen",
"497668", "Ihringen",
"496323", "Edenkoben",
"498557", "Mauth",
"492558", "Horstmar",
"496061", "Michelstadt",
"499576", "Lichtenfels\-Isling",
"498469", "Freystadt\-Burggriesbach",
"499332", "Marktbreit",
"494508", "Krummesse",
"494327", "Grossenaspe",
"496831", "Saarlouis",
"494131", "Lüneburg",
"498204", "Mickhausen",
"495056", "Winsen\-Meissendorf",
"498253", "Pöttmes",
"493386", "Premnitz",
"497707", "Bräunlingen",
"494482", "Hatten",
"4934973", "Osternienburg",
"499198", "Heiligenstadt\ in\ Oberfranken",
"495837", "Sprakensehl",
"49461", "Flensburg",
"49531", "Braunschweig",
"496621", "Bad\ Hersfeld",
"492236", "Wesseling\ Rheinland",
"497127", "Neckartenzlingen",
"4933634", "Berkenbrück\ Kreis\ Oder\-Spree",
"495067", "Bockenem",
"493987", "Templin",
"497331", "Geislingen\ an\ der\ Steige",
"494926", "Krummhörn\-Greetsiel",
"4939400", "Wefensleben",
"494281", "Zeven",
"499765", "Trappstadt",
"496581", "Saarburg",
"492333", "Ennepetal",
"498367", "Rosshaupten\ Forggensee",
"492368", "Oer\-Erkenschwick",
"492958", "Büren\-Harth",
"4934603", "Nauendorf\ Sachsen\-Anhalt",
"493634", "Sömmerda",
"495766", "Rehburg\-Loccum",
"496751", "Bad\ Sobernheim",
"495824", "Bad\ Bodenteich",
"496742", "Boppard",
"492631", "Neuwied",
"499377", "Freudenberg\-Boxtal",
"495975", "Rheine\-Mesum",
"494526", "Ascheberg\ Holstein",
"497134", "Weinsberg",
"496226", "Meckesheim",
"495283", "Lügde\-Rischenau",
"498086", "Buchbach\ Oberbayern",
"499976", "Rötz",
"494334", "Bredenbek\ bei\ Rendsburg",
"495872", "Stoetze",
"49211", "Düsseldorf",
"498443", "Hohenwart\ Paar",
"4936336", "Klettenberg",
"495634", "Waldeck\-Sachsenhausen",
"499484", "Brennberg",
"492821", "Kleve\ Niederrhein",
"492226", "Rheinbach",
"497321", "Heidenheim\ an\ der\ Brenz",
"497275", "Kandel",
"494936", "Grossheide",
"495827", "Unterlüss",
"4934928", "Seegrehna",
"499374", "Eschau",
"496631", "Alsfeld",
"492742", "Wissen",
"494337", "Jevenstedt",
"496821", "Neunkirchen\ Saar",
"494121", "Elmshorn",
"4933454", "Wölsickendorf\/Wollenberg",
"49611", "Wiesbaden",
"49481", "Heide\ Holstein",
"498450", "Ingolstadt\-Zuchering",
"4934977", "Quellendorf",
"498364", "Seeg",
"496333", "Waldfischbach\-Burgalben",
"495703", "Hille",
"497623", "Rheinfelden\ Baden",
"492581", "Warendorf",
"495754", "Extertal\-Bremke",
"494425", "Wangerland\-Hooksiel",
"492751", "Bad\ Berleburg",
"497833", "Hornberg\ Schwarzwaldbahn",
"495584", "Hattorf\ am\ Harz",
"496186", "Grosskrotzenburg",
"4936968", "Rossdorf\ Rhön",
"497063", "Bad\ Wimpfen",
"495123", "Schellerten",
"4937208", "Auerswalde",
"497753", "Albbruck",
"499820", "Lehrberg",
"492208", "Niederkassel",
"494324", "Brokstedt",
"498207", "Affing",
"497704", "Geisingen\ Baden",
"495624", "Bad\ Emstal",
"492831", "Geldern",
"497172", "Lorch\ Württemberg",
"494536", "Steinhorst\ Lauenburg",
"495064", "Gross\ Düngen",
"498465", "Kipfenberg",
"497124", "Trochtelfingen\ Hohenz",
"493984", "Prenzlau",
"496236", "Neuhofen\ Pfalz",
"499171", "Roth\ Mittelfranken",
"497583", "Bad\ Schussenried",
"494372", "Westfehmarn",
"495834", "Wittingen\-Knesebeck",
"493476", "Hettstedt\ Sachsen\-Anhalt",
"492621", "Lahnstein",
"4939404", "Ausleben",
"495672", "Bad\ Karlshafen",
"4934607", "Wettin",
"4934444", "Lützen",
"499094", "Tagmersheim",
"495476", "Ostercappeln\-Venne",
"493834", "Greifswald",
"496788", "Sien",
"493672", "Rudolstadt",
"498784", "Hohenthann",
"492323", "Herne",
"496558", "Büdesheim\ Eifel",
"498161", "Freising",
"498503", "Neuhaus\ am\ Inn",
"498554", "Schönberg\ Niederbayern",
"494258", "Schwarme",
"493624", "Ohrdruf",
"492981", "Winterberg\ Westfalen",
"499107", "Trautskirchen",
"494209", "Schwanewede",
"496509", "Büdlich",
"4935823", "Ostritz",
"498348", "Bidingen",
"496344", "Schwegenheim",
"494464", "Wittmund\-Carolinensiel",
"4939397", "Geestgottberg",
"4933207", "Gross\ Kreutz",
"499727", "Schonungen\-Marktsteinach",
"494732", "Stadland\-Rodenkirchen",
"492294", "Morsbach\ Sieg",
"493869", "Dümmer",
"498271", "Meitingen",
"498325", "Oberstaufen\-Thalkirchdorf",
"496297", "Ravenstein\ Baden",
"4933631", "Bad\ Saarow\-Pieskow",
"497844", "Rheinau",
"4938785", "Berge\ bei\ Perleberg",
"492505", "Altenberge\ Westfalen",
"497262", "Eppingen",
"497150", "Korntal\-Münchingen",
"494555", "Seedorf\ bei\ Bad\ Segeberg",
"494293", "Ottersberg\-Fischerhude",
"496406", "Lollar",
"496593", "Hillesheim\ Eifel",
"496255", "Lindenfels",
"499261", "Kronach",
"499854", "Wittelshofen",
"495650", "Cornberg",
"499803", "Colmberg",
"4939293", "Dreileben",
"4933632", "Hangelsberg",
"492463", "Titz",
"4934263", "Hohburg",
"4938227", "Lüdershagen\ bei\ Barth",
"493843", "Güstrow",
"495147", "Uetze\-Hänigsen",
"499734", "Burkardroth",
"492546", "Coesfeld\-Lette",
"492905", "Bestwig\-Ramsbeck",
"4939487", "Friedrichsbrunn",
"4938853", "Drönnewitz\ bei\ Hagenow",
"497461", "Tuttlingen",
"4939823", "Rechlin",
"492802", "Alpen",
"497578", "Wald\ Hohenz",
"494777", "Cadenberge",
"499462", "Falkenstein\ Oberpfalz",
"495696", "Bad\ Arolsen\-Landau",
"494841", "Husum\ Nordsee",
"494852", "Brunsbüttel",
"496152", "Gross\-Gerau",
"492449", "Blankenheim\ Ahr",
"495492", "Steinfeld\ Oldenburg",
"496773", "Kamp\-Bornhofen",
"499666", "Illschwang",
"4938323", "Prohn",
"496428", "Stadtallendorf",
"498424", "Nassenfels",
"495025", "Estorf\ Weser",
"497165", "Göppingen\-Hohenstaufen",
"4936743", "Teichel",
"495843", "Wustrow\ Wendland",
"4936378", "Ostramondra",
"495665", "Guxhagen",
"494365", "Heringsdorf\ Holstein",
"496445", "Schöffengrund",
"494955", "Westoverledingen",
"499657", "Waldthurn",
"494842", "Nordstrand",
"496142", "Rüsselsheim",
"499461", "Roding",
"4933233", "Ketzin",
"492770", "Eschenburg",
"499196", "Wiesenttal",
"4935724", "Lohsa",
"493491", "Lutherstadt\ Wittenberg",
"494928", "Ihlow\-Riepe",
"497734", "Gailingen",
"492801", "Xanten",
"492238", "Pulheim",
"4936925", "Marksuhl",
"4933364", "Gross\ Ziethen\ Kreis\ Barnim",
"498237", "Aindling",
"492263", "Engelskirchen",
"495853", "Neu\ Darchau",
"497462", "Immendingen",
"495195", "Neuenkirchen\ bei\ Soltau",
"495804", "Rätzlingen\ Kreis\ Uelzen",
"49271", "Siegen",
"496206", "Lampertheim",
"494493", "Friesoythe\-Gehlenberg",
"494506", "Stockelsdorf\-Krumbeck",
"499647", "Kirchenthumbach",
"496455", "Frankenau\ Hessen",
"4936870", "Masserberg",
"494945", "Grossefehn\-Timmel",
"4935244", "Krögis",
"499165", "Sugenheim",
"4938874", "Lützow",
"495157", "Emmerthal\-Börry",
"497666", "Denzlingen",
"492556", "Metelen",
"4933337", "Altkünkendorf",
"494409", "Westerstede\-Ocholt",
"497026", "Lenningen",
"495166", "Walsrode\-Kirchboitzen",
"497657", "Eisenbach\ Hochschwarzwald",
"495491", "Damme\ Dümmer",
"496564", "Neuerburg\ Eifel",
"496151", "Darmstadt",
"494851", "Marne",
"498533", "Rotthalmünster",
"492567", "Ahaus\-Alstätte",
"494264", "Sottrum\ Kreis\ Rotenburg",
"492590", "Dülmen\-Buldern",
"4939995", "Nossendorf",
"499978", "Schönthal\ Oberpfalz",
"498272", "Wertingen",
"494731", "Nordenham",
"494545", "Seedorf\ Lauenburg",
"4939244", "Steutz",
"4936622", "Triebes",
"4938754", "Leussow\ bei\ Ludwigslust",
"496245", "Biblis",
"4939724", "Klein\ Bünzow",
"499844", "Obernzenn",
"494340", "Achterwehr",
"493733", "Annaberg\-Buchholz",
"4935692", "Kerkwitz",
"496228", "Schönau\ Odenwald",
"497727", "Vöhrenbach",
"492395", "Finnentrop\-Rönkhausen",
"495607", "Fuldatal",
"495292", "Lichtenau\-Atteln",
"496084", "Schmitten\ Taunus",
"494528", "Schönwalde\ am\ Bungsberg",
"494307", "Raisdorf",
"498224", "Offingen\ Donau",
"495733", "Vlotho",
"495768", "Petershagen\-Heimsen",
"4937346", "Geyer",
"496303", "Enkenbach\-Alsenborn",
"4939035", "Kuhfelde",
"4936621", "Elsterberg\ bei\ Plauen",
"492357", "Herscheid\ Westfalen",
"4933080", "Marienthal\ Kreis\ Oberhavel",
"499262", "Wallenfels",
"4936844", "Rohr\ Thüringen",
"4935691", "Bärenklau\ NL",
"4934204", "Schkeuditz",
"497803", "Gengenbach",
"4937423", "Adorf\ Vogtland",
"497261", "Sinsheim",
"492366", "Herten\ Westfalen",
"497854", "Kehl\-Goldscheuer",
"495671", "Hofgeismar",
"4935341", "Bad\ Liebenwerda",
"492622", "Bendorf\ am\ Rhein",
"494371", "Burg\ auf\ Fehmarn",
"499172", "Georgensgmünd",
"495130", "Wedemark",
"492935", "Sundern\-Hachen",
"496525", "Irrel",
"499704", "Euerdorf",
"4936027", "Lengenfeld\ Unterm\ Stein",
"497171", "Schwäbisch\ Gmünd",
"494248", "Bassum\-Neubruchhausen",
"4934493", "Gössnitz\ Thüringen",
"498544", "Eging\ am\ See",
"492832", "Kevelaer",
"496677", "Neuenstein\ Hessen",
"4939205", "Langenweddingen",
"4938791", "Bad\ Wilsnack",
"4933395", "Zerpenschleuse",
"492674", "Bad\ Bertrich",
"492529", "Oelde\-Stromberg",
"492982", "Medebach",
"497743", "Ühlingen\-Birkendorf",
"4936871", "Bad\ Colberg\-Heldburg",
"4935937", "Prischwitz",
"499287", "Selb",
"4935342", "Mühlberg\ Elbe",
"494189", "Undeloh",
"495373", "Hillerse\ Kreis\ Gifhorn",
"4938379", "Benz\ Usedom",
"4933746", "Werbig\ bei\ Jüterbog",
"498250", "Hilgertshausen\-Tandern",
"494673", "Joldelund",
"492426", "Nörvenich",
"493671", "Saalfeld\ Saale",
"497475", "Burladingen",
"498393", "Holzgünz",
"497389", "Heroldstatt",
"4939053", "Süplingen",
"4938792", "Lenzen\ \(Elbe\)",
"4933604", "Lebus",
"494458", "Wiefelstede\-Spohle",
"498296", "Villenbach",
"497374", "Uttenweiler",
"4933974", "Dessow",
"499275", "Speichersdorf",
"4935205", "Ottendorf\-Okrilla",
"4938842", "Lüttenmark",
"492330", "Herdecke",
"4934383", "Trebsen\ Mulde",
"494122", "Uetersen",
"495744", "Hüllhorst",
"4934633", "Braunsbedra",
"499321", "Kitzingen",
"494239", "Dörverden\-Westen",
"4937436", "Weischlitz",
"492741", "Betzdorf",
"492535", "Sendenhorst\-Albersloh",
"496874", "Wadern\-Nunkirchen",
"4939341", "Redekin",
"494174", "Stelle\ Kreis\ Harburg",
"498073", "Gars\ am\ Inn",
"495276", "Marienmünster",
"494702", "Sandstedt",
"497322", "Giengen\ an\ der\ Brenz",
"4938206", "Graal\-Müritz\ Seeheilbad",
"498265", "Pfaffenhausen\ Schwaben",
"4938729", "Marnitz",
"496436", "Dornburg\ Hessen",
"492173", "Langenfeld\ Rheinland",
"4935053", "Glashütte\ Sachsen",
"492752", "Bad\ Laasphe",
"4938841", "Neuhaus\ Elbe",
"492689", "Dierdorf",
"498407", "Grossmehring",
"4939342", "Gladau",
"492408", "Aachen\-Kornelimünster",
"492582", "Everswinkel",
"4933082", "Menz\ Kreis\ Oberhavel",
"499833", "Heidenheim\ Mittelfranken",
"499868", "Schillingsfürst",
"4933473", "Zechin",
"493744", "Auerbach\ Vogtland",
"4935792", "Ossling",
"4937200", "Wittgensdorf\ bei\ Chemnitz",
"493423", "Eilenburg",
"496682", "Tann\ Rhön",
"492585", "Warendorf\-Hoetmar",
"4962199", "Ludwigshafen",
"4939206", "Eichenbarleben",
"4933396", "Klosterfelde",
"4938759", "Tewswoos",
"498262", "Mittelneufnach",
"493998", "Demmin",
"499933", "Wallersdorf",
"499358", "Gössenheim",
"49641", "Giessen",
"499187", "Altdorf\ bei\ Nürnberg",
"494289", "Kirchtimke",
"494421", "Wilhelmshaven",
"492755", "Bad\ Berleburg\-Schwarzenau",
"4936766", "Schalkau",
"4933638", "Rüdersdorf\ bei\ Berlin",
"496589", "Kell\ am\ See",
"4935023", "Bad\ Gottleuba",
"496043", "Nidda",
"492532", "Ostbevern",
"496635", "Kirtorf",
"499088", "Mönchsdeggingen",
"494148", "Drochtersen\-Assel",
"497271", "Wörth\ am\ Rhein",
"494705", "Wremen",
"496848", "Homburg\-Einöd",
"497325", "Sontheim\ an\ der\ Brenz",
"495423", "Versmold",
"4936849", "Kleinschmalkalden",
"496486", "Katzenelnbogen",
"497520", "Bodnegg",
"4934920", "Kropstädt",
"497348", "Beimerstetten",
"492639", "Anhausen\ Kreis\ Neuwied",
"4933745", "Petkus",
"499272", "Fichtelberg",
"492977", "Schmallenberg\-Bödefeld",
"496825", "Illingen\ Saar",
"494125", "Seestermühe",
"499533", "Untermerzbach",
"4935249", "Basslitz",
"499568", "Neustadt\ bei\ Coburg",
"497472", "Rottenburg\ am\ Neckar",
"4936694", "Schkölen\ Thüringen",
"4936372", "Kleinneuhausen",
"4933369", "Oderberg",
"492985", "Winterberg\-Niedersfeld",
"4935841", "Grossschönau\ Sachsen",
"499471", "Burglengenfeld",
"4935206", "Kreischa\ bei\ Dresden",
"492273", "Kerpen\-Horrem",
"4937435", "Reuth\ bei\ Plauen",
"497424", "Spaichingen",
"498165", "Neufahrn\ bei\ Freising",
"492065", "Duisburg\-Rheinhausen",
"495176", "Edemissen",
"494274", "Varrel\ bei\ Sulingen",
"492835", "Issum",
"496629", "Schenklengsfeld",
"496574", "Hasborn",
"4935842", "Oderwitz",
"494222", "Ganderkesee",
"4938205", "Tessin\ bei\ Rostock",
"494139", "Hohnstorf\ Elbe",
"497676", "Feldberg\ Schwarzwald",
"496522", "Mettendorf",
"492932", "Neheim\-Hüsten",
"499175", "Spalt",
"492625", "Ochtendung",
"4936371", "Schlossvippach",
"498196", "Pürgen",
"498461", "Beilngries",
"494746", "Hagen\ bei\ Bremerhaven",
"496251", "Bensheim",
"494164", "Harsefeld",
"496864", "Mettlach",
"498868", "Schwabsoien",
"494551", "Bad\ Segeberg",
"492867", "Heiden\ Kreis\ Borken",
"496034", "Wöllstadt",
"4934921", "Kemberg",
"495266", "Lemgo\-Kirchheide",
"498063", "Feldkirchen\-Westerham",
"4934656", "Wallhausen\ Sachsen\-Anhalt",
"499407", "Wenzenbach",
"498038", "Vogtareuth",
"497364", "Oberkochen",
"497954", "Kirchberg\ an\ der\ Jagst",
"492856", "Hamminkeln\-Brünen",
"497903", "Mainhardt",
"4933979", "Wusterhausen\ Dosse",
"4936962", "Vacha",
"495257", "Hövelhof",
"4936651", "Lobenstein",
"498623", "Kirchweidach",
"4935874", "Bernstadt\ an\ der\ Eigen",
"4937202", "Claussnitz\ bei\ Chemnitz",
"4936926", "Creuzburg",
"499265", "Pressig",
"493504", "Dippoldiswalde",
"4939754", "Löcknitz\ Vorpom",
"496106", "Rodgau",
"494806", "Sarzbüttel",
"499073", "Gundelfingen\ an\ der\ Donau",
"495295", "Lichtenau\ Westfalen",
"495553", "Kalefeld",
"492392", "Werdohl",
"4934922", "Mühlanger",
"495504", "Friedland\ Kreis\ Göttingen",
"498321", "Sonthofen",
"492163", "Schwalmtal\ Niederrhein",
"498137", "Petershausen",
"492501", "Münster\-Hiltrup",
"496726", "Lorch\ Rheingau",
"494542", "Mölln\ Lauenburg",
"499944", "Miltach",
"496242", "Osthofen",
"4936652", "Wurzbach",
"4938724", "Siggelkow",
"4936961", "Bad\ Liebenstein",
"497161", "Göppingen",
"497503", "Wilhelmsdorf\ Württemberg",
"495021", "Nienburg\ Weser",
"497554", "Heiligenberg\ Baden",
"495447", "Lembruch",
"499393", "Rothenfels\ Unterfranken",
"493904", "Haldensleben",
"492664", "Rennerod",
"4936370", "Grossenehrich",
"493338", "Bernau\ Brandenburg",
"496667", "Steinau\-Ulmbach",
"496441", "Wetzlar",
"494361", "Oldenburg\ in\ Holstein",
"494951", "Weener",
"4939996", "Törpin",
"499162", "Scheinfeld",
"495661", "Melsungen",
"496027", "Stockstadt\ am\ Main",
"496656", "Ebersburg",
"498124", "Forstern\ Oberbayern",
"497465", "Emmingen\-Liptingen",
"494828", "Lägerdorf",
"496128", "Taunusstein",
"492736", "Burbach\ Siegerl",
"493661", "Greiz",
"495192", "Munster",
"4933609", "Brieskow\-Finkenheerd",
"499544", "Baunach",
"498583", "Neureichenau",
"4933704", "Baruth\ Mark",
"496452", "Battenberg\ Eder",
"494942", "Südbrookmerland",
"496145", "Flörsheim\ am\ Main",
"496708", "Bad\ Münster\ am\ Stein\-Ebernburg",
"494845", "Ostenfeld\ Husum",
"498753", "Elsendorf\ Niederbayern",
"498704", "Altdorf\-Pfettrach",
"4938374", "Lassan\ bei\ Wolgast",
"4935754", "Klettwitz",
"494638", "Tarp",
"4939036", "Binde",
"493447", "Altenburg\ Thüringen",
"494663", "Süderlügum",
"495904", "Lengerich\ Emsl",
"497240", "Pfinztal",
"495953", "Börger",
"495363", "Wolfsburg\-Vorsfelde",
"4933837", "Brielow",
"498389", "Weissensberg",
"497393", "Munderkingen",
"495074", "Rodewald",
"4936253", "Georgenthal\ Thüringer\ Wald",
"4939409", "Eilsleben",
"4939323", "Schönhausen\ Elbe",
"495662", "Felsberg\ Hessen",
"492159", "Meerbusch\-Osterath",
"499554", "Untersteinbach\ Unterfranken",
"499161", "Neustadt\ an\ der\ Aisch",
"499503", "Oberhaid\ Oberfranken",
"493466", "Artern\ Unstrut",
"496442", "Braunfels",
"494952", "Rhauderfehn",
"494362", "Heiligenhafen",
"496155", "Griesheim\ Hessen",
"494855", "Eddelak",
"498743", "Geisenhausen",
"4936483", "Ziegenrück",
"494193", "Henstedt\-Ulzburg",
"496893", "Saarbrücken\-Ensheim",
"4935773", "Schleife",
"4938353", "Gützkow\ bei\ Greifswald",
"498094", "Steinhöring",
"495495", "Vörden\ Kreis\ Vechta",
"4936072", "Weissenborn\-Lüderode",
"497250", "Kraichtal",
"497162", "Süssen",
"495022", "Wietzen",
"495943", "Emlichheim",
"4939853", "Holzendorf\ bei\ Prenzlau",
"4936878", "Oberland",
"498630", "Oberneukirchen",
"4937603", "Wildenfels",
"497544", "Markdorf",
"498171", "Wolfratshausen",
"495457", "Hopsten\-Schale",
"497309", "Weissenhorn",
"499465", "Neukirchen\-Balbini",
"493943", "Wernigerode",
"496451", "Frankenberg\ Eder",
"494941", "Aurich",
"4939747", "Züsedom",
"496646", "Grebenau",
"492902", "Warstein",
"495191", "Soltau",
"4936071", "Teistungen",
"499207", "Königsfeld\ Oberfranken",
"494109", "Tangstedt\ Bz\ Hamburg",
"495466", "Merzen",
"496809", "Grossrosseln",
"4938823", "Selmsdorf",
"495543", "Staufenberg\ Niedersachsen",
"4939773", "Altwarp",
"497440", "Bad\ Rippoldsau",
"4933088", "Falkenthal",
"497265", "Angelbachtal",
"4935323", "Sonnewalde",
"4938293", "Kühlungsborn\ Ostseebad",
"4939348", "Klitsche",
"499903", "Schöllnach",
"4933763", "Bestensee",
"493394", "Wittstock\ Dosse",
"494552", "Leezen",
"492693", "Antweiler",
"499954", "Simbach\ Niederbayern",
"499364", "Zellingen",
"496252", "Heppenheim\ Bergstrasse",
"499779", "Nordheim\ von\ der\ Rhön",
"496241", "Worms",
"494735", "Butjadingen\-Stollhamm",
"494541", "Ratzeburg",
"497073", "Ammerbuch",
"492502", "Nottuln",
"4938848", "Vellahn",
"498322", "Oberstdorf",
"497944", "Kupferzell",
"498374", "Dietmannsried",
"492391", "Plettenberg",
"493969", "Siedenbollentin",
"495247", "Harsewinkel",
"496286", "Walldürn\-Rippberg",
"498657", "Ramsau\ bei\ Berchtesgaden",
"498026", "Hausham",
"495223", "Bünde",
"499472", "Hohenfels\ Oberpfalz",
"494767", "Bremervörde\-Bevern",
"497533", "Allensbach",
"497568", "Bad\ Wurzach\-Hauerz",
"499424", "Strasskirchen",
"4937363", "Zöblitz",
"498666", "Teisendorf",
"497471", "Hechingen",
"494756", "Odisheim",
"493675", "Sonneberg\ Thüringen",
"498462", "Berching",
"494489", "Apen",
"492931", "Arnsberg",
"49621", "Mannheim",
"499920", "Bischofsmais",
"499339", "Ippesheim",
"49451", "Lübeck",
"495675", "Trendelburg",
"494221", "Delmenhorst",
"495308", "Lehre",
"495527", "Duderstadt",
"494608", "Handewitt",
"495934", "Haren\-Rütenbrock",
"4936643", "Thimmendorf",
"498734", "Reisbach\ Niederbayern",
"497175", "Leinzell",
"497237", "Neulingen\ Enzkreis",
"496763", "Kirchberg\ Hunsrück",
"499676", "Winklarn",
"494422", "Sande\ Kreis\ Friesl",
"496053", "Wächtersbach",
"496004", "Lich\-Eberstadt",
"4933731", "Trebbin",
"494158", "Roseburg",
"498803", "Peissenberg",
"496858", "Ottweiler\-Fürth",
"498261", "Mindelheim",
"496215", "Ludwigshafen",
"497933", "Creglingen",
"494474", "Garrel",
"497358", "Eberhardzell\-Füramoos",
"496681", "Hilders",
"4933923", "Flecken\ Zechlin",
"499325", "Kleinlangheim",
"495534", "Eschershausen\ an\ der\ Lenne",
"499271", "Thurnau\-Alladorf",
"496136", "Nieder\-Olm",
"498727", "Falkenberg\ Niederbayern",
"492473", "Simmerath",
"494836", "Hennstedt\ Dithmarschen",
"4936628", "Zeulenroda",
"497224", "Gernsbach",
"4933732", "Hennickendorf\ bei\ Luckenwalde",
"496383", "Glan\-Münchweiler",
"4935698", "Hornow",
"495326", "Langelsheim",
"499348", "Werbach\-Gamburg",
"494626", "Treia",
"497272", "Rülzheim",
"49491", "Leer\ Ostfriesland",
"492745", "Brachbach\ Sieg",
"498724", "Massing",
"497227", "Lichtenau\ Baden",
"4937367", "Lengefeld\ Erzgebirge",
"496473", "Leun",
"496728", "Ober\-Hilbersheim",
"495875", "Emmendorf",
"495924", "Bad\ Bentheim\-Gildehaus",
"498153", "Wessling",
"496108", "Mühlheim\ am\ Main",
"496745", "Gondershausen",
"492921", "Soest",
"496531", "Bernkastel\-Kues",
"498104", "Sauerlach",
"494231", "Verden\ Aller",
"498772", "Mallersdorf\-Pfaffenberg",
"499876", "Rohr\ Mittelfranken",
"492383", "Bönen",
"4936074", "Worbis",
"4933608", "Jacobsdorf\ Mark",
"497761", "Bad\ Säckingen",
"498857", "Benediktbeuern",
"492858", "Hünxe",
"4936647", "Saalburg\ Thüringen",
"499434", "Bodenwöhr",
"495684", "Frielendorf",
"496007", "Rosbach\-Rodheim",
"494384", "Selent",
"492053", "Velbert\-Neviges",
"499762", "Saal\ an\ der\ Saale",
"494477", "Lastrup\-Hemmelte",
"492681", "Altenkirchen\ Westerwald",
"498036", "Stephanskirchen\ Simssee",
"493537", "Jessen\ Elster",
"495233", "Steinheim\ Westfalen",
"497184", "Kaisersbach",
"495572", "Bodenfelde",
"497683", "Simonswald",
"492521", "Beckum",
"49221", "Cologne",
"496706", "Wallhausen\ Nahe",
"495336", "Semmenstedt",
"4933927", "Linum",
"494636", "Langballig",
"496126", "Idstein",
"492763", "Drolshagen\-Bleche",
"494826", "Hohenlockstedt",
"495183", "Lamspringe",
"492738", "Netphen",
"497234", "Tiefenbronn",
"495524", "Bad\ Lauterberg\ im\ Harz",
"499335", "Aub\ Kreis\ Würzburg",
"494485", "Elsfleth\-Huntorf",
"497051", "Calw",
"495937", "Geeste\-Gross\ Hesepe",
"498592", "Wegscheid\ Niederbayern",
"497042", "Vaihingen\ an\ der\ Enz",
"4933978", "Segeletz",
"494764", "Gnarrenburg\-Klenkendorf",
"498654", "Freilassing",
"493679", "Neuhaus\ am\ Rennweg",
"4936335", "Grosswechsungen",
"497381", "Münsingen",
"493937", "Osterburg\ Altmark",
"496658", "Poppenhausen\ Wasserkuppe",
"494432", "Dötlingen\-Brettorf",
"499427", "Leiblfing",
"499382", "Gerolzhofen",
"494181", "Buchholz\ in\ der\ Nordheide",
"496881", "Lebach",
"4935893", "Mücka",
"496502", "Schweich",
"495085", "Burgdorf\-Ehlershausen",
"499443", "Abensberg",
"493965", "Burow\ bei\ Altentreptow",
"492605", "Löf",
"494202", "Achim\ bei\ Bremen",
"495776", "Preussisch\ Ströhen",
"497346", "Illerkirchberg",
"492241", "Siegburg",
"499086", "Fremdingen",
"495244", "Rietberg",
"4936257", "Luisenthal\ Thüringen",
"499775", "Schönau\ an\ der\ Brend",
"4939327", "Klietz",
"497947", "Forchtenberg",
"4934782", "Mansfeld\ Südharz",
"496391", "Dahn",
"498377", "Unterthingau",
"494146", "Stade\-Bützfleth",
"492378", "Fröndenberg\-Langschede",
"4935476", "Wittmannsdorf\-Bückchen",
"4935728", "Uhyst\ Spree",
"499356", "Burgsinn",
"499966", "Wiesenfelden",
"497269", "Sulzfeld\ Baden",
"4939743", "Zerrenthin",
"495032", "Neustadt\ am\ Rübenberge",
"499070", "Tapfheim",
"493996", "Teterow",
"4933368", "Hohensaaten",
"497404", "Epfendorf",
"495862", "Hitzacker\ Elbe",
"497453", "Altensteig\ Württemberg",
"4938827", "Kalkhorst",
"496693", "Neuental",
"4939857", "Drense",
"495355", "Frellstedt",
"495965", "Klein\ Berssen",
"492252", "Zülpich",
"4937607", "Ebersbrunn\ Sachsen",
"4933056", "Mühlenbeck\ Kreis\ Oberhavel",
"499367", "Unterpleichfeld",
"4938483", "Brüel",
"4935248", "Schönfeld\ bei\ Grossenhain",
"498765", "Bruckberg\ Niederbayern",
"4934781", "Greifenhagen",
"4939223", "Theessen",
"495454", "Hörstel\-Riesenbeck",
"498055", "Halfing",
"4935327", "Priessen",
"495403", "Bad\ Iburg",
"4938297", "Moitin",
"4933767", "Friedersdorf\ bei\ Berlin",
"4936848", "Wernshausen",
"49465", "Sylt",
"496805", "Kleinblittersdorf",
"494105", "Seevetal",
"494748", "Stubben\ bei\ Bremerhaven",
"4934208", "Löbnitz\ bei\ Delitzsch",
"499253", "Weissenstadt",
"4936041", "Bad\ Tennstedt",
"499204", "Plankenfels",
"492646", "Königsfeld\ Eifel",
"498332", "Ottobeuren",
"499469", "Roding\-Neubäu",
"497305", "Erbach\ Donau",
"494725", "Helgoland",
"4939777", "Borkenfriede",
"492451", "Geilenkirchen",
"494859", "Windbergen",
"496159", "Messel",
"495565", "Einbeck\-Wenzen",
"4938758", "Dömitz",
"494401", "Brake\ Unterweser",
"4933734", "Felgentreu",
"4938393", "Binz\ Ostseebad",
"4939248", "Dobritz",
"498385", "Hergatz",
"493596", "Neustadt\ in\ Sachsen",
"496071", "Dieburg",
"4936042", "Tonna",
"4939728", "Medow\ bei\ Anklam",
"499566", "Meeder",
"4939006", "Miesterhorst",
"497243", "Ettlingen",
"49335", "Frankfurt\ \(Oder\)",
"499547", "Zapfendorf",
"492452", "Heinsberg\ Rheinland",
"494606", "Wanderup",
"495306", "Cremlingen",
"494849", "Hooge",
"498331", "Memmingen",
"496736", "Bechenheim",
"495907", "Geeste",
"499305", "Estenfeld",
"4933676", "Friedland\ bei\ Beeskow",
"497204", "Malsch\-Völkersbach",
"498707", "Adlkofen",
"497253", "Bad\ Schönborn",
"498045", "Lenggries\-Fall",
"495444", "Wagenfeld",
"4937383", "Lunzenau",
"492667", "Stein\-Neukirch",
"498633", "Tüssling",
"493907", "Gardelegen",
"4938720", "Grebbin",
"4939956", "Neukalen",
"496664", "Sinntal\-Sterbfritz",
"494758", "Nordleda",
"497557", "Herdwangen\-Schönach",
"499243", "Pottenstein",
"496024", "Schöllkrippen",
"498284", "Ziemetshausen",
"494402", "Rastede",
"498028", "Fischbachau",
"4937756", "Breitenbrunn\ Erzgebirge",
"493306", "Gransee",
"492656", "Virneburg",
"497566", "Argenbühl",
"492441", "Kall",
"498823", "Mittenwald",
"499346", "Grünsfeld",
"493861", "Plate",
"496392", "Hauenstein\ Pfalz",
"4939925", "Wredenhagen",
"495328", "Altenau\ Harz",
"495507", "Ebergötzen",
"4936692", "Bürgel",
"497443", "Dornstetten",
"495345", "Baddeckenstedt",
"492242", "Hennef\ Sieg",
"4935439", "Zinnitz",
"4936374", "Weissensee",
"499947", "Neukirchen\ bei\ Hl\ Blut",
"497775", "Mühlingen",
"498134", "Odelzhausen",
"494838", "Tellingstedt",
"496138", "Mommenheim",
"494863", "Sankt\ Peter\-Ording",
"496163", "Höchst\ im\ Odenwald",
"496501", "Konz",
"499453", "Thalmassing",
"49214", "Leverkusen",
"499404", "Nittendorf",
"499269", "Tettau\ Kreis\ Kronach",
"494167", "Apensen",
"496867", "Perl",
"492251", "Euskirchen",
"492864", "Reken",
"4933833", "Wollin\ bei\ Brandenburg",
"497356", "Schemmerhofen",
"497966", "Unterschneidheim",
"4938370", "Kröslin",
"4936691", "Eisenberg\ Thüringen",
"495254", "Paderborn\-Schloss\ Neuhaus",
"4935844", "Oybin\ Kurort",
"495861", "Dannenberg\ Elbe",
"493328", "Teltow",
"495203", "Werther\ Westfalen",
"495031", "Wunstorf",
"497957", "Kressberg",
"497367", "Aalen\-Ebnat",
"496856", "St\ Wendel\-Niederkirchen",
"494156", "Talkau",
"499179", "Freystadt",
"498591", "Obernzell",
"492574", "Saerbeck",
"497052", "Bad\ Liebenzell",
"494277", "Schwaförden",
"496835", "Beckingen",
"4939751", "Penkun",
"494135", "Kirchgellersen",
"495433", "Badbergen",
"499683", "Friedenfels",
"495468", "Bramsche\-Engter",
"4934346", "Narsdorf",
"496648", "Bad\ Salzschlirf",
"4935027", "Weesenstein",
"4934423", "Heuckewalde",
"497335", "Wiesensteig",
"4935872", "Neusalza\-Spremberg",
"499234", "Neusorg",
"4938721", "Ziegendorf",
"4937204", "Lichtenstein\ Sachsen",
"492522", "Oelde",
"496625", "Niederaula",
"4936964", "Dermbach\ Rhön",
"498302", "Görisried",
"492839", "Straelen\-Herongen",
"495571", "Uslar",
"4939752", "Blumenhagen\ bei\ Strasburg",
"494182", "Tostedt",
"499381", "Volkach",
"494431", "Wildeshausen",
"4936463", "Gebstedt",
"496096", "Wiesen\ Unterfranken",
"4933089", "Himmelpfort",
"499923", "Teisnach",
"4934924", "Zahna",
"4939349", "Parey\ Elbe",
"493571", "Hoyerswerda",
"497382", "Römerstein",
"4933458", "Falkenberg\ Mark",
"497427", "Schömberg\ bei\ Balingen",
"493433", "Borna\ Stadt",
"499498", "Laaber",
"4938722", "Raduhn",
"497041", "Mühlacker",
"496050", "Biebergemünd",
"498771", "Ergoldsbach",
"498847", "Obersöchering",
"499227", "Neuenmarkt",
"4938305", "Gingst",
"4933701", "Grossbeeren",
"494232", "Langwedel\ Kreis\ Verden",
"494129", "Haseldorf",
"495971", "Rheine",
"496532", "Zeltingen\-Rachtig",
"492922", "Werl",
"492043", "Gladbeck",
"492635", "Rheinbrohl",
"4935751", "Welzow",
"492825", "Uedem",
"4938371", "Karlshagen",
"4936205", "Gräfenroda",
"492974", "Schmallenberg\-Fredeburg",
"496639", "Ottrau",
"497930", "Boxberg\ Baden",
"497329", "Steinheim\ am\ Albuch",
"492486", "Nettersheim",
"494973", "Wittmund\-Burhafe",
"497434", "Winterlingen",
"492682", "Hamm\ Sieg",
"496585", "Ralingen",
"492759", "Bad\ Berleburg\-Aue",
"4933702", "Wünsdorf",
"494285", "Rhade\ bei\ Zeven",
"499761", "Bad\ Königshofen\ im\ Grabfeld",
"499184", "Deining\ Oberpfalz",
"498143", "Inning\ am\ Ammersee",
"496755", "Odernheim\ am\ Glan",
"4938372", "Usedom",
"49241", "Aachen",
"4935752", "Ruhland",
"494793", "Hambergen",
"499523", "Hofheim\ in\ Unterfranken",
"493971", "Anklam",
"497762", "Wehr\ Baden",
"4939408", "Hadmersleben",};
my $timezones = {
               '' => [
                       'Europe/Berlin'
                     ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+49|\D)//g;
      my $self = bless({ country_code => '49', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '49', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;