Lattice-based cryptography is dangerous.
Fast attacks have been demonstrated breaking, e.g.,
[Compact LWE](https://groups.google.com/a/list.nist.gov/g/pqc-forum/c/_fOnZNYHdE4/m/-WNWqwUFAwAJ),
[HILA5](https://eprint.iacr.org/2017/1214),
and [Round2](https://eprint.iacr.org/2020/241),
all of which were small lattice-based cryptosystems
submitted to the NIST post-quantum competition.
The
[supposedly](https://web.archive.org/web/20231125213807/https://finiterealities.net/kyber512/)
[well-studied](https://web.archive.org/web/20231219201240/https://csrc.nist.gov/csrc/media/Projects/post-quantum-cryptography/documents/faq/Kyber-512-FAQ.pdf)
problems
at the heart of all lattice-based cryptosystems
[continue](https://cr.yp.to/papers.html#hybrid)
to [lose](https://eprint.iacr.org/2024/80)
[security](https://eprint.iacr.org/2024/739).
The "constant-time" reference software for Kyber (ML-KEM)
has had two rounds of security patches for two different timing attacks
[demonstrated](https://kyberslash.cr.yp.to)
to be
[exploitable](https://groups.google.com/a/list.nist.gov/g/pqc-forum/c/hqbtIGFKIpU).

Unlike most proposals of lattice-based cryptosystems,
`sntrup`
[acknowledges lattice risks](https://ntruprime.cr.yp.to/warnings.html)
and is
[designed accordingly](https://ntruprime.cr.yp.to).
Furthermore,
the `sntrup` software in libntruprime
includes state-of-the-art defenses against timing attacks.
But small lattice-based cryptosystems, even when carefully designed, remain dangerous,
both at the
[mathematical](https://s-unit.attacks.cr.yp.to) level
and at the software level.
**When you're deploying post-quantum cryptography,
make sure to deploy it as an
[_extra_ layer of encryption](https://blog.cr.yp.to/20240102-hybrid.html)
on top of your existing use of ECC,
not as a replacement for ECC.**

One risk for libntruprime
is the risk of bugs getting past the libntruprime tests.
The main defense in progress is
[software verification](verification.html).
Until verification is complete,
libntruprime is limiting code size:
it includes
[general AVX2 optimizations](speed.html)
but skips the software from
[nine publications with further `sntrup` speedups](speed.html#faster).

Regarding timing attacks:
libntruprime is designed to avoid all data flow from
secret data to memory addresses and branch conditions.
libntruprime uses operations that naturally avoid such data flow,
and includes `valgrind` tests (based on TIMECOP from SUPERCOP)
designed to catch any such data flow introduced by compilers.
Fully protecting the user against timing attacks requires addressing more issues,
such as the following:

* Other CPU instructions can take variable time.
  For example, there are some CPUs, especially embedded CPUs,
  where integer multiplication takes variable time.
  Most software for public-key cryptography relies on integer multiplication,
  although there are exceptions such as
  [code-based cryptography](https://lib.mceliece.org).

* Many CPUs include dynamic frequency-selection mechanisms
  such as
  [Turbo Boost](https://blog.cr.yp.to/20230609-turboboost.html),
  exposing power information via timing information.
  Fortunately,
  these CPUs are normally shipped with simple options
  to disable Turbo Boost etc., closing this leak;
  unfortunately,
  Turbo Boost is enabled by default on CPUs that support it.

* Cryptographic keys are normally handled by cryptographic software, but
  other user secrets are handled by many different pieces of software.

See [https://timing.attacks.cr.yp.to](https://timing.attacks.cr.yp.to)
for a timing-attack survey and many references.

Speculative-execution attacks:
Some countermeasures against speculative-execution attacks are planned
but are not included in the current version of libntruprime.
Full protection again requires addressing issues at other system layers.

Further side-channel attacks:
Even if all legitimate user sensors are successfully kept isolated from attackers,
attackers can set up their own
power sensors, electromagnetic sensors, acoustic sensors, etc.
Keeping cryptographic operations physically separated from sensors
tends to make such attacks much more expensive but is often infeasible.
"Masking" cryptographic computations
seems to help and can be affordable,
although the security of masking is difficult to evaluate
and there are many broken masked implementations.
Currently libntruprime does not include any masked implementations,
so presumably it is easily breakable by power attacks
in environments where attackers can see power consumption.

Further attacks:
Presumably libntruprime is easily breakable by fault attacks
in environments where attackers can trigger faults.
Beyond attacker-triggered faults,
natural DRAM faults occur surprisingly often.
Implicit rejection [fails](https://cr.yp.to/papers.html#ntrw)
to provide IND-CCA2 security
when DRAM faults corrupt the secret key used for implicit rejection,
although attacks can be stopped by "plaintext confirmation",
another layer of defense included in `sntrup`.
Error correction is in any case recommended
(and often not provided by hardware),
and there is a general-purpose
[libsecded](https://pqsrc.cr.yp.to/downloads.html) library
that applies error correction to any array,
although this does not catch errors that occur during computations.
