/*
* JBoss, Home of Professional Open Source
* Copyright 2007, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.managed.plugins.factory;

import java.security.AccessController;
import java.security.PrivilegedAction;

import org.jboss.managed.api.factory.ManagedObjectFactory;

/**
 * ManagedObjectFactoryBuilder factory for ManagedObjectFactory. 
 * 
 * TODO this class only creates a singleton implementation for now, configurable
 * via the org.jboss.managed.api.factory.ManagedObjectFactory system property.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @author Scott.Stark@jboss.org
 * @version $Revision: 76500 $
 */
public class ManagedObjectFactoryBuilder
{
   /** The singleton */
   private static final ManagedObjectFactory singleton;

   static
   {
      singleton = AccessController.doPrivileged(new PrivilegedAction<ManagedObjectFactory>()
         {
            public ManagedObjectFactory run()
            {
               ManagedObjectFactory mof = null;
               String defaultMOF = AbstractManagedObjectFactory.class.getName();
               // The system property for the ManagedObjectFactory class to use
               String className = System.getProperty(ManagedObjectFactory.class.getName(), defaultMOF);
               try
               {
                  Class<?> clazz;
                  try
                  {
                     clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
                  }
                  catch (ClassNotFoundException e)
                  {
                     try
                     {
                        clazz = getClass().getClassLoader().loadClass(className);
                     }
                     catch (ClassNotFoundException ignored)
                     {
                        throw e;
                     }
                  }
                  Object result = clazz.newInstance();
                  mof = ManagedObjectFactory.class.cast(result);
               }
               catch (RuntimeException e)
               {
                  throw e;
               }
               catch (Exception e)
               {
                  throw new Error("Unexpected error loading ManagedObjectFactory " + className, e);
               }

               return mof;
            }
         });
   }

   /**
    * Create the factory
    * 
    * @return the factory
    */
   public static ManagedObjectFactory create()
   {
      return singleton;
   }
}
