/*
 * @(#)SourceHtmlReportStyle.java
 *
 * Copyright (C) 2003-2004 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2.ant;

import java.io.File;
import java.io.IOException;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.w3c.dom.Document;


/**
 * Describes a report style, used to generate readable reports from the
 * XML output.  This is a combo report, which means that it only works
 * with the combined coverage file.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2004/04/15 05:48:25 $
 * @since     November 22, 2003
 */
public class SourceHtmlReportStyle extends SourceXslReportStyle
{
    private File stylesheet = null;
    private String title = null;
    private String footerText = null;
    private String footerLink = null;
    
    private boolean hasSetup = false;
    
    
    public SourceHtmlReportStyle()
    {
        SourceXslReportStyle.StyleType st;
        
        st = new SourceXslReportStyle.StyleType();
        st.setUrl( "xsl/1x1.png" );
        st.setDest( "/1x1.png" );
        addFile( st );
        
        st = new SourceXslReportStyle.StyleType();
        st.setUrl( "xsl/source-frame-html.xsl" );
        st.setDest( ".html" );
        addSourceStyle( st );
        
        st = new SourceXslReportStyle.StyleType();
        st.setUrl( "xsl/source-frame-html.xsl" );
        st.setDest( "/package-frame.html" );
        addPackageStyle( st );
        
        st = new SourceXslReportStyle.StyleType();
        st.setUrl( "xsl/overview-frame.xsl" );
        st.setDest( "/package-classes.html" );
        addPackageStyle( st );
        
        st = new SourceXslReportStyle.StyleType();
        st.setUrl( "xsl/index.xsl" );
        st.setDest( "/index.html" );
        addRootStyle( st );
        
        st = new SourceXslReportStyle.StyleType();
        st.setUrl( "xsl/overview-frame.xsl" );
        st.setDest( "/overview-frame.html" );
        addRootStyle( st );
        
        st = new SourceXslReportStyle.StyleType();
        st.setUrl( "xsl/allclasses-frame.xsl" );
        st.setDest( "/allclasses-frame.html" );
        addRootStyle( st );
        
        st = new SourceXslReportStyle.StyleType();
        st.setUrl( "xsl/source-frame-html.xsl" );
        st.setDest( "/overview-summary.html" );
        addRootStyle( st );
    }
    
    
    /** Well-defined XSL parameters */
    public void setTitle( String title )
    {
        this.title = title;
    }
    
    
    public void setFooterText( String t )
    {
        this.footerText = t;
    }
    
    
    public void setFooterHref( String t )
    {
        this.footerLink = t;
    }
    
    
    public void setStylesheet( File f )
    {
        this.stylesheet = f;
    }
    
    
    public void generateReport( Project project, Document doc,
            String moduleName )
            throws BuildException, IOException
    {
        if (!this.hasSetup)
        {
            SourceXslReportStyle.StyleType st =
                new SourceXslReportStyle.StyleType();
            st.setDest( "stylesheet.css" );
            if (this.stylesheet == null)
            {
                st.setUrl( "xsl/stylesheet.css" );
            }
            else
            {
                st.setFile( this.stylesheet );
            }
            addFile( st );
            st = null;
            
            addMyParam( "title", this.title );
            addMyParam( "footerText", this.footerText );
            addMyParam( "footerLink", this.footerLink );
            
            this.hasSetup = true;
        }
        
        super.generateReport( project, doc, moduleName );
    }
    
    
    private void addMyParam( String name, String value )
    {
        if (value != null)
        {
            SimpleXslReportStyle.ParamType pt =
                new SimpleXslReportStyle.ParamType();
            pt.setName( name );
            pt.setExpression( value );
            addParam( pt );
        }
    }
}