/* DbField.c generated by valac 0.26.2, the Vala compiler
 * generated from DbField.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * libgdadata
 * Copyright (C) Daniel Espinosa Ortiz 2011 <esodan@gmail.com>
 * 
 * libgda is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * libgda is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <libgda/libgda.h>


#define GDA_DATA_TYPE_DB_FIELD (gda_data_db_field_get_type ())
#define GDA_DATA_DB_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_FIELD, GdaDataDbField))
#define GDA_DATA_IS_DB_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_FIELD))
#define GDA_DATA_DB_FIELD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_FIELD, GdaDataDbFieldIface))

typedef struct _GdaDataDbField GdaDataDbField;
typedef struct _GdaDataDbFieldIface GdaDataDbFieldIface;

#define GDA_DATA_DB_FIELD_TYPE_ATTRIBUTE (gda_data_db_field_attribute_get_type ())
#define __vala_GdaNumeric_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdaNumeric_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

typedef enum  {
	GDA_DATA_DB_FIELD_ATTRIBUTE_NONE = 1 << 0,
	GDA_DATA_DB_FIELD_ATTRIBUTE_IS_NULL = 1 << 1,
	GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_NULL = 1 << 2,
	GDA_DATA_DB_FIELD_ATTRIBUTE_IS_DEFAULT = 1 << 3,
	GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_DEFAULT = 1 << 4,
	GDA_DATA_DB_FIELD_ATTRIBUTE_IS_UNCHANGED = 1 << 5,
	GDA_DATA_DB_FIELD_ATTRIBUTE_ACTIONS_SHOWN = 1 << 6,
	GDA_DATA_DB_FIELD_ATTRIBUTE_DATA_NON_VALID = 1 << 7,
	GDA_DATA_DB_FIELD_ATTRIBUTE_HAS_VALUE_ORIG = 1 << 8,
	GDA_DATA_DB_FIELD_ATTRIBUTE_NO_MODIF = 1 << 9,
	GDA_DATA_DB_FIELD_ATTRIBUTE_UNUSED = 1 << 10
} GdaDataDbFieldAttribute;

struct _GdaDataDbFieldIface {
	GTypeInterface parent_iface;
	gboolean (*equal) (GdaDataDbField* self, GdaDataDbField* field);
	gchar* (*to_string) (GdaDataDbField* self);
	GValue* (*get_value) (GdaDataDbField* self);
	void (*set_value) (GdaDataDbField* self, GValue* value);
	const gchar* (*get_name) (GdaDataDbField* self);
	void (*set_name) (GdaDataDbField* self, const gchar* value);
	const gchar* (*get_column_name) (GdaDataDbField* self);
	GdaDataDbFieldAttribute (*get_attributes) (GdaDataDbField* self);
};



GType gda_data_db_field_attribute_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_get_type (void) G_GNUC_CONST;
GdaDataDbFieldAttribute* gda_data_db_field_attribute_items (int* result_length1);
gchar* gda_data_db_field_attribute_to_string (GdaDataDbFieldAttribute self);
gboolean gda_data_db_field_equal (GdaDataDbField* self, GdaDataDbField* field);
static gboolean gda_data_db_field_real_equal (GdaDataDbField* self, GdaDataDbField* field);
const gchar* gda_data_db_field_get_name (GdaDataDbField* self);
const gchar* gda_data_db_field_get_column_name (GdaDataDbField* self);
GdaDataDbFieldAttribute gda_data_db_field_get_attributes (GdaDataDbField* self);
static gboolean _vala_gda_data_db_field_attribute_array_contains (GdaDataDbFieldAttribute* stack, int stack_length, GdaDataDbFieldAttribute needle);
GValue* gda_data_db_field_value_from_string (const gchar* as_string, GType type);
static void _vala_GdaNumeric_free (GdaNumeric* self);
gchar* gda_data_db_field_to_string (GdaDataDbField* self);
static gchar* gda_data_db_field_real_to_string (GdaDataDbField* self);
GValue* gda_data_db_field_get_value (GdaDataDbField* self);
void gda_data_db_field_set_value (GdaDataDbField* self, GValue* value);
void gda_data_db_field_set_name (GdaDataDbField* self, const gchar* value);


GdaDataDbFieldAttribute* gda_data_db_field_attribute_items (int* result_length1) {
	GdaDataDbFieldAttribute* result = NULL;
	GdaDataDbFieldAttribute* _tmp0_ = NULL;
	GdaDataDbFieldAttribute* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	_tmp0_ = g_new0 (GdaDataDbFieldAttribute, 11);
	_tmp0_[0] = GDA_DATA_DB_FIELD_ATTRIBUTE_NONE;
	_tmp0_[1] = GDA_DATA_DB_FIELD_ATTRIBUTE_IS_NULL;
	_tmp0_[2] = GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_NULL;
	_tmp0_[3] = GDA_DATA_DB_FIELD_ATTRIBUTE_IS_DEFAULT;
	_tmp0_[4] = GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_DEFAULT;
	_tmp0_[5] = GDA_DATA_DB_FIELD_ATTRIBUTE_IS_UNCHANGED;
	_tmp0_[6] = GDA_DATA_DB_FIELD_ATTRIBUTE_ACTIONS_SHOWN;
	_tmp0_[7] = GDA_DATA_DB_FIELD_ATTRIBUTE_DATA_NON_VALID;
	_tmp0_[8] = GDA_DATA_DB_FIELD_ATTRIBUTE_HAS_VALUE_ORIG;
	_tmp0_[9] = GDA_DATA_DB_FIELD_ATTRIBUTE_NO_MODIF;
	_tmp0_[10] = GDA_DATA_DB_FIELD_ATTRIBUTE_UNUSED;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 11;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


gchar* gda_data_db_field_attribute_to_string (GdaDataDbFieldAttribute self) {
	gchar* result = NULL;
	switch (self) {
		case GDA_DATA_DB_FIELD_ATTRIBUTE_NONE:
		{
			gchar* _tmp0_ = NULL;
			_tmp0_ = g_strdup ("None");
			result = _tmp0_;
			return result;
		}
		case GDA_DATA_DB_FIELD_ATTRIBUTE_IS_NULL:
		{
			gchar* _tmp1_ = NULL;
			_tmp1_ = g_strdup ("IsNull");
			result = _tmp1_;
			return result;
		}
		case GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_NULL:
		{
			gchar* _tmp2_ = NULL;
			_tmp2_ = g_strdup ("CanBeNull");
			result = _tmp2_;
			return result;
		}
		case GDA_DATA_DB_FIELD_ATTRIBUTE_IS_DEFAULT:
		{
			gchar* _tmp3_ = NULL;
			_tmp3_ = g_strdup ("IsDefault");
			result = _tmp3_;
			return result;
		}
		case GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_DEFAULT:
		{
			gchar* _tmp4_ = NULL;
			_tmp4_ = g_strdup ("CanBeDefault");
			result = _tmp4_;
			return result;
		}
		case GDA_DATA_DB_FIELD_ATTRIBUTE_IS_UNCHANGED:
		{
			gchar* _tmp5_ = NULL;
			_tmp5_ = g_strdup ("IsUnchanged");
			result = _tmp5_;
			return result;
		}
		case GDA_DATA_DB_FIELD_ATTRIBUTE_ACTIONS_SHOWN:
		{
			gchar* _tmp6_ = NULL;
			_tmp6_ = g_strdup ("ActionsShown");
			result = _tmp6_;
			return result;
		}
		case GDA_DATA_DB_FIELD_ATTRIBUTE_DATA_NON_VALID:
		{
			gchar* _tmp7_ = NULL;
			_tmp7_ = g_strdup ("DataNonValid");
			result = _tmp7_;
			return result;
		}
		case GDA_DATA_DB_FIELD_ATTRIBUTE_HAS_VALUE_ORIG:
		{
			gchar* _tmp8_ = NULL;
			_tmp8_ = g_strdup ("HasValueOrig");
			result = _tmp8_;
			return result;
		}
		case GDA_DATA_DB_FIELD_ATTRIBUTE_NO_MODIF:
		{
			gchar* _tmp9_ = NULL;
			_tmp9_ = g_strdup ("NoModif");
			result = _tmp9_;
			return result;
		}
		case GDA_DATA_DB_FIELD_ATTRIBUTE_UNUSED:
		{
			gchar* _tmp10_ = NULL;
			_tmp10_ = g_strdup ("CanBeNull");
			result = _tmp10_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


GType gda_data_db_field_attribute_get_type (void) {
	static volatile gsize gda_data_db_field_attribute_type_id__volatile = 0;
	if (g_once_init_enter (&gda_data_db_field_attribute_type_id__volatile)) {
		static const GFlagsValue values[] = {{GDA_DATA_DB_FIELD_ATTRIBUTE_NONE, "GDA_DATA_DB_FIELD_ATTRIBUTE_NONE", "none"}, {GDA_DATA_DB_FIELD_ATTRIBUTE_IS_NULL, "GDA_DATA_DB_FIELD_ATTRIBUTE_IS_NULL", "is-null"}, {GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_NULL, "GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_NULL", "can-be-null"}, {GDA_DATA_DB_FIELD_ATTRIBUTE_IS_DEFAULT, "GDA_DATA_DB_FIELD_ATTRIBUTE_IS_DEFAULT", "is-default"}, {GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_DEFAULT, "GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_DEFAULT", "can-be-default"}, {GDA_DATA_DB_FIELD_ATTRIBUTE_IS_UNCHANGED, "GDA_DATA_DB_FIELD_ATTRIBUTE_IS_UNCHANGED", "is-unchanged"}, {GDA_DATA_DB_FIELD_ATTRIBUTE_ACTIONS_SHOWN, "GDA_DATA_DB_FIELD_ATTRIBUTE_ACTIONS_SHOWN", "actions-shown"}, {GDA_DATA_DB_FIELD_ATTRIBUTE_DATA_NON_VALID, "GDA_DATA_DB_FIELD_ATTRIBUTE_DATA_NON_VALID", "data-non-valid"}, {GDA_DATA_DB_FIELD_ATTRIBUTE_HAS_VALUE_ORIG, "GDA_DATA_DB_FIELD_ATTRIBUTE_HAS_VALUE_ORIG", "has-value-orig"}, {GDA_DATA_DB_FIELD_ATTRIBUTE_NO_MODIF, "GDA_DATA_DB_FIELD_ATTRIBUTE_NO_MODIF", "no-modif"}, {GDA_DATA_DB_FIELD_ATTRIBUTE_UNUSED, "GDA_DATA_DB_FIELD_ATTRIBUTE_UNUSED", "unused"}, {0, NULL, NULL}};
		GType gda_data_db_field_attribute_type_id;
		gda_data_db_field_attribute_type_id = g_flags_register_static ("GdaDataDbFieldAttribute", values);
		g_once_init_leave (&gda_data_db_field_attribute_type_id__volatile, gda_data_db_field_attribute_type_id);
	}
	return gda_data_db_field_attribute_type_id__volatile;
}


static gboolean _vala_gda_data_db_field_attribute_array_contains (GdaDataDbFieldAttribute* stack, int stack_length, GdaDataDbFieldAttribute needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}


static gboolean gda_data_db_field_real_equal (GdaDataDbField* self, GdaDataDbField* field) {
	gboolean result = FALSE;
	GdaDataDbField* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GdaDataDbField* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GdaDataDbFieldAttribute* attributes = NULL;
	gint _tmp10_ = 0;
	GdaDataDbFieldAttribute* _tmp11_ = NULL;
	gint attributes_length1 = 0;
	gint _attributes_size_ = 0;
	GdaDataDbFieldAttribute* _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	g_return_val_if_fail (field != NULL, FALSE);
	_tmp0_ = field;
	_tmp1_ = gda_data_db_field_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gda_data_db_field_get_name (self);
	_tmp4_ = _tmp3_;
	if (g_strcmp0 (_tmp2_, _tmp4_) != 0) {
		result = FALSE;
		return result;
	}
	_tmp5_ = field;
	_tmp6_ = gda_data_db_field_get_column_name (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = gda_data_db_field_get_column_name (self);
	_tmp9_ = _tmp8_;
	if (g_strcmp0 (_tmp7_, _tmp9_) != 0) {
		result = FALSE;
		return result;
	}
	_tmp11_ = gda_data_db_field_attribute_items (&_tmp10_);
	attributes = _tmp11_;
	attributes_length1 = _tmp10_;
	_attributes_size_ = attributes_length1;
	_tmp12_ = attributes;
	_tmp12__length1 = attributes_length1;
	{
		GdaDataDbFieldAttribute* att_collection = NULL;
		gint att_collection_length1 = 0;
		gint _att_collection_size_ = 0;
		gint att_it = 0;
		att_collection = _tmp12_;
		att_collection_length1 = _tmp12__length1;
		for (att_it = 0; att_it < _tmp12__length1; att_it = att_it + 1) {
			GdaDataDbFieldAttribute att = 0;
			att = att_collection[att_it];
			{
				gboolean _tmp13_ = FALSE;
				GdaDataDbFieldAttribute _tmp14_ = 0;
				GdaDataDbField* _tmp15_ = NULL;
				GdaDataDbFieldAttribute _tmp16_ = 0;
				GdaDataDbFieldAttribute _tmp17_ = 0;
				_tmp14_ = att;
				_tmp15_ = field;
				_tmp16_ = gda_data_db_field_get_attributes (_tmp15_);
				_tmp17_ = _tmp16_;
				if ((_tmp17_ & _tmp14_) == _tmp14_) {
					GdaDataDbFieldAttribute _tmp18_ = 0;
					GdaDataDbFieldAttribute* _tmp19_ = NULL;
					gint _tmp19__length1 = 0;
					_tmp18_ = att;
					_tmp19_ = attributes;
					_tmp19__length1 = attributes_length1;
					_tmp13_ = !_vala_gda_data_db_field_attribute_array_contains (_tmp19_, _tmp19__length1, _tmp18_);
				} else {
					_tmp13_ = FALSE;
				}
				if (_tmp13_) {
					result = FALSE;
					attributes = (g_free (attributes), NULL);
					return result;
				}
			}
		}
	}
	result = TRUE;
	attributes = (g_free (attributes), NULL);
	return result;
}


gboolean gda_data_db_field_equal (GdaDataDbField* self, GdaDataDbField* field) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GDA_DATA_DB_FIELD_GET_INTERFACE (self)->equal (self, field);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gint64 int64_parse (const gchar* str) {
	gint64 result = 0LL;
	const gchar* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	g_return_val_if_fail (str != NULL, 0LL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoll (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static guint64 uint64_parse (const gchar* str) {
	guint64 result = 0ULL;
	const gchar* _tmp0_ = NULL;
	guint64 _tmp1_ = 0ULL;
	g_return_val_if_fail (str != NULL, 0ULL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoull (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	g_return_val_if_fail (str != NULL, 0.0);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
	result = _tmp1_;
	return result;
}


static void _vala_GdaNumeric_free (GdaNumeric* self) {
	g_boxed_free (gda_numeric_get_type (), self);
}


GValue* gda_data_db_field_value_from_string (const gchar* as_string, GType type) {
	GValue* result = NULL;
	GType _tmp0_ = 0UL;
	GType _tmp22_ = 0UL;
	GType _tmp26_ = 0UL;
	GType _tmp30_ = 0UL;
	GType _tmp34_ = 0UL;
	GType _tmp38_ = 0UL;
	GType _tmp42_ = 0UL;
	const gchar* _tmp47_ = NULL;
	GValue* _tmp48_ = NULL;
	g_return_val_if_fail (as_string != NULL, NULL);
	_tmp0_ = type;
	if (_tmp0_ == G_TYPE_BOOLEAN) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		const gchar* _tmp3_ = NULL;
		gchar _tmp4_ = '\0';
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		const gchar* _tmp11_ = NULL;
		gchar _tmp12_ = '\0';
		gint i = 0;
		const gchar* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		gboolean _tmp19_ = FALSE;
		gint _tmp20_ = 0;
		GValue* _tmp21_ = NULL;
		_tmp3_ = as_string;
		_tmp4_ = string_get (_tmp3_, (glong) 0);
		if (_tmp4_ == 't') {
			_tmp2_ = TRUE;
		} else {
			const gchar* _tmp5_ = NULL;
			gchar _tmp6_ = '\0';
			_tmp5_ = as_string;
			_tmp6_ = string_get (_tmp5_, (glong) 0);
			_tmp2_ = _tmp6_ == 'T';
		}
		if (_tmp2_) {
			_tmp1_ = TRUE;
		} else {
			const gchar* _tmp7_ = NULL;
			_tmp7_ = as_string;
			_tmp1_ = g_strcmp0 (_tmp7_, "true") == 0;
		}
		if (_tmp1_) {
			GValue* _tmp8_ = NULL;
			_tmp8_ = g_new0 (GValue, 1);
			g_value_init (_tmp8_, G_TYPE_BOOLEAN);
			g_value_set_boolean (_tmp8_, TRUE);
			result = _tmp8_;
			return result;
		}
		_tmp11_ = as_string;
		_tmp12_ = string_get (_tmp11_, (glong) 0);
		if (_tmp12_ == 'f') {
			_tmp10_ = TRUE;
		} else {
			const gchar* _tmp13_ = NULL;
			gchar _tmp14_ = '\0';
			_tmp13_ = as_string;
			_tmp14_ = string_get (_tmp13_, (glong) 0);
			_tmp10_ = _tmp14_ == 'F';
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			const gchar* _tmp15_ = NULL;
			_tmp15_ = as_string;
			_tmp9_ = g_strcmp0 (_tmp15_, "false") == 0;
		}
		if (_tmp9_) {
			GValue* _tmp16_ = NULL;
			_tmp16_ = g_new0 (GValue, 1);
			g_value_init (_tmp16_, G_TYPE_BOOLEAN);
			g_value_set_boolean (_tmp16_, FALSE);
			result = _tmp16_;
			return result;
		}
		_tmp17_ = as_string;
		_tmp18_ = atoi (_tmp17_);
		i = _tmp18_;
		_tmp20_ = i;
		if (_tmp20_ == 0) {
			_tmp19_ = FALSE;
		} else {
			_tmp19_ = TRUE;
		}
		_tmp21_ = g_new0 (GValue, 1);
		g_value_init (_tmp21_, G_TYPE_BOOLEAN);
		g_value_set_boolean (_tmp21_, _tmp19_);
		result = _tmp21_;
		return result;
	}
	_tmp22_ = type;
	if (_tmp22_ == G_TYPE_INT64) {
		const gchar* _tmp23_ = NULL;
		gint64 _tmp24_ = 0LL;
		GValue* _tmp25_ = NULL;
		_tmp23_ = as_string;
		_tmp24_ = int64_parse (_tmp23_);
		_tmp25_ = g_new0 (GValue, 1);
		g_value_init (_tmp25_, G_TYPE_INT64);
		g_value_set_int64 (_tmp25_, _tmp24_);
		result = _tmp25_;
		return result;
	}
	_tmp26_ = type;
	if (_tmp26_ == G_TYPE_UINT64) {
		const gchar* _tmp27_ = NULL;
		guint64 _tmp28_ = 0ULL;
		GValue* _tmp29_ = NULL;
		_tmp27_ = as_string;
		_tmp28_ = uint64_parse (_tmp27_);
		_tmp29_ = g_new0 (GValue, 1);
		g_value_init (_tmp29_, G_TYPE_UINT64);
		g_value_set_uint64 (_tmp29_, _tmp28_);
		result = _tmp29_;
		return result;
	}
	_tmp30_ = type;
	if (_tmp30_ == G_TYPE_INT) {
		const gchar* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		GValue* _tmp33_ = NULL;
		_tmp31_ = as_string;
		_tmp32_ = atoi (_tmp31_);
		_tmp33_ = g_new0 (GValue, 1);
		g_value_init (_tmp33_, G_TYPE_INT);
		g_value_set_int (_tmp33_, _tmp32_);
		result = _tmp33_;
		return result;
	}
	_tmp34_ = type;
	if (_tmp34_ == G_TYPE_LONG) {
		const gchar* _tmp35_ = NULL;
		glong _tmp36_ = 0L;
		GValue* _tmp37_ = NULL;
		_tmp35_ = as_string;
		_tmp36_ = atol (_tmp35_);
		_tmp37_ = g_new0 (GValue, 1);
		g_value_init (_tmp37_, G_TYPE_LONG);
		g_value_set_long (_tmp37_, _tmp36_);
		result = _tmp37_;
		return result;
	}
	_tmp38_ = type;
	if (_tmp38_ == G_TYPE_DOUBLE) {
		const gchar* _tmp39_ = NULL;
		gdouble _tmp40_ = 0.0;
		GValue* _tmp41_ = NULL;
		_tmp39_ = as_string;
		_tmp40_ = double_parse (_tmp39_);
		_tmp41_ = g_new0 (GValue, 1);
		g_value_init (_tmp41_, G_TYPE_DOUBLE);
		g_value_set_double (_tmp41_, _tmp40_);
		result = _tmp41_;
		return result;
	}
	_tmp42_ = type;
	if (_tmp42_ == gda_numeric_get_type ()) {
		GdaNumeric* n = NULL;
		GdaNumeric* _tmp43_ = NULL;
		GdaNumeric* _tmp44_ = NULL;
		const gchar* _tmp45_ = NULL;
		GValue* _tmp46_ = NULL;
		_tmp43_ = gda_numeric_new ();
		n = _tmp43_;
		_tmp44_ = n;
		_tmp45_ = as_string;
		gda_numeric_set_from_string (_tmp44_, _tmp45_);
		_tmp46_ = g_new0 (GValue, 1);
		g_value_init (_tmp46_, gda_numeric_get_type ());
		g_value_take_boxed (_tmp46_, n);
		result = _tmp46_;
		return result;
	}
	_tmp47_ = as_string;
	_tmp48_ = g_new0 (GValue, 1);
	g_value_init (_tmp48_, G_TYPE_STRING);
	g_value_set_string (_tmp48_, _tmp47_);
	result = _tmp48_;
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gchar* gda_data_db_field_real_to_string (GdaDataDbField* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GdaDataDbFieldAttribute _tmp6_ = 0;
	GdaDataDbFieldAttribute _tmp7_ = 0;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	GValue* _tmp12_ = NULL;
	GValue* _tmp13_ = NULL;
	GValue _tmp14_ = {0};
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	_tmp0_ = gda_data_db_field_get_name (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = gda_data_db_field_get_column_name (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_to_string (_tmp4_);
	_tmp6_ = gda_data_db_field_get_attributes (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = gda_data_db_field_attribute_to_string (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat ("([", _tmp2_, "],[", _tmp5_, "],[%s],[", _tmp9_, "])", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = gda_data_db_field_get_value (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = *_tmp13_;
	_tmp15_ = gda_value_stringify (&_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strdup_printf (_tmp11_, _tmp16_);
	_tmp18_ = _tmp17_;
	_g_free0 (_tmp16_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	result = _tmp18_;
	return result;
}


gchar* gda_data_db_field_to_string (GdaDataDbField* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GDA_DATA_DB_FIELD_GET_INTERFACE (self)->to_string (self);
}


GValue* gda_data_db_field_get_value (GdaDataDbField* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GDA_DATA_DB_FIELD_GET_INTERFACE (self)->get_value (self);
}


void gda_data_db_field_set_value (GdaDataDbField* self, GValue* value) {
	g_return_if_fail (self != NULL);
	GDA_DATA_DB_FIELD_GET_INTERFACE (self)->set_value (self, value);
}


const gchar* gda_data_db_field_get_name (GdaDataDbField* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GDA_DATA_DB_FIELD_GET_INTERFACE (self)->get_name (self);
}


void gda_data_db_field_set_name (GdaDataDbField* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	GDA_DATA_DB_FIELD_GET_INTERFACE (self)->set_name (self, value);
}


const gchar* gda_data_db_field_get_column_name (GdaDataDbField* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GDA_DATA_DB_FIELD_GET_INTERFACE (self)->get_column_name (self);
}


GdaDataDbFieldAttribute gda_data_db_field_get_attributes (GdaDataDbField* self) {
	g_return_val_if_fail (self != NULL, 0);
	return GDA_DATA_DB_FIELD_GET_INTERFACE (self)->get_attributes (self);
}


static void gda_data_db_field_base_init (GdaDataDbFieldIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("column-name", "column-name", "column-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_flags ("attributes", "attributes", "attributes", GDA_DATA_DB_FIELD_TYPE_ATTRIBUTE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		iface->equal = gda_data_db_field_real_equal;
		iface->to_string = gda_data_db_field_real_to_string;
	}
}


GType gda_data_db_field_get_type (void) {
	static volatile gsize gda_data_db_field_type_id__volatile = 0;
	if (g_once_init_enter (&gda_data_db_field_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GdaDataDbFieldIface), (GBaseInitFunc) gda_data_db_field_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gda_data_db_field_type_id;
		gda_data_db_field_type_id = g_type_register_static (G_TYPE_INTERFACE, "GdaDataDbField", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gda_data_db_field_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&gda_data_db_field_type_id__volatile, gda_data_db_field_type_id);
	}
	return gda_data_db_field_type_id__volatile;
}



