package net.noderunner.amazon.s3;

import static org.junit.Assert.assertEquals;

import java.security.Key;
import java.util.Collections;
import java.util.Map;

import net.noderunner.amazon.s3.Bucket;
import net.noderunner.amazon.s3.CanonicalString;
import net.noderunner.amazon.s3.Headers;
import net.noderunner.amazon.s3.Method;

import org.junit.Test;

public class CanonicalStringTest {

	@Test
	public void testMacOlder() throws Exception {
		String access = "213321324ksadjfkasjfdasfdjksadf";
		String canon = "XXYasfajkjaslkfdjalksjflkasjflkajskfjasjflksadjflksajfdkljsadlkfjaslkfd";
		Key key = CanonicalString.key(access);
		String encode = CanonicalString.encode(key, canon);
		assertEquals("hAu+ibd/CZIw6/5OR69i2+40bfc=", encode);
	}
	
	@Test
	public void testMac2() throws Exception {
		String access = "213321324ksadjfkasjfdasfdjksadf";
		String canon = "XXYasfajkjaslkfdjalksjflkasjflkajskfjasjflksadjflksajfdkljsadlkfjaslkfd";
		Key key = CanonicalString.key(access);
		String encode = CanonicalString.encode(key, canon);
		assertEquals("hAu+ibd/CZIw6/5OR69i2+40bfc=", encode);
	}
	
	@Test
	public void testMake() throws Exception {
		Map<String, String> path = Collections.singletonMap("auth", "");
		Headers h = new Headers();
		h.put("x", "y");
		String expires = "whenever";
    	String make = CanonicalString.make(Method.PUT, new Bucket("xyz"), "key", path, h, expires);
    	assertEquals("PUT\n\n\nwhenever\n/xyz/key", make);
	}
}
