#!/usr/bin/env perl -w
use strict;
use Test;

my %local_checks = (
    AT      =>  ['V12345678', '123456789', 'U1234567', 'U123456789'],
    BE      =>  ['1234567890', '012345678', '123456789', '012345678L'],
    BG      =>  ['12345678', '12345678901', '012345678L'],
    CY      =>  ['12345678', '1234567A', '123456789A'],
    CZ	    =>  ['1234567', '12345678901', '123456A890'],
    DE      =>  ['12345678A', '1234567A', '123456789A'],
    DK      =>  ['1234567','123456789', '12345 78 90'],
    EE	    =>  ['12345678', '1234567A', '123456789A'],
    EL      =>  ['12345678', '1234567A', '123456789A'],
    ES      =>  ['12345678', 'A234567B9'],
    FI      =>  ['1234567', '123456789', '1234567L'],
    FR      =>  ['12 45678901A', 'A245678901', '1B 4567890123', 'AB 45678901'],
    GB      =>  ['123 5678 0A', '123 5678 1B 234','GD34', 'HA1234'],
    HU      =>  ['1234567', '123456789', '1234567L'],
    IE      =>  ['123456AB', '1B3456C8', '1-34567C', '1*3456C8'],
    IT      =>  ['1234567890A', '1234567890', '123456789011'],
    LT      =>  ['12345678', '123456789A12', '1234567890123'],
    LU      =>  ['1234567', '123456789', '1234567L'],
    LV      =>  ['1234567890A', '1234567890', '123456789011'],
    MT	    =>  ['1234567', '123456789', '1234567L'],
    NL      =>  ['123456789012', '23456789B12', '123456789C12'],
    PL      =>  ['123456', '124567890', '123456L7'],
    PT      =>  ['1234567', '1234567A', '123456789A'],
    RO      =>  ['1', '12A', '1234567890A'],
    SE      =>  ['123456789A12', '12345678901', '01234567890123'],
    SI	    =>  ['1234567', '123456789', '1234567L'],
    SK	    =>  ['123456789', '12345678901', '123456789L']
);

use Business::Tax::VAT::Validation;

my $tests = 0;

for my $ms (keys %local_checks) {
    $tests+= $#{$local_checks{$ms}} + 1
}

plan tests => $tests;

my $hvat=Business::Tax::VAT::Validation->new();
for my $ms (keys %local_checks) {
    for my $t (@{$local_checks{$ms}}) {
        my $res=$hvat->local_check($t, $ms);
        if (!$res){
            ok(1);
        } else {
            warn("Local check for $ms$t failed");
        }        
    }
}
exit;
__END__
