/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.noarg;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("plugins/noarg/noarg-cli/testData/bytecodeListing")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class BytecodeListingTestForNoArgGenerated extends AbstractBytecodeListingTestForNoArg {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
    }

    public void testAllFilesPresentInBytecodeListing() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("plugins/noarg/noarg-cli/testData/bytecodeListing"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("annoOnNotClass.kt")
    public void testAnnoOnNotClass() throws Exception {
        runTest("plugins/noarg/noarg-cli/testData/bytecodeListing/annoOnNotClass.kt");
    }

    @TestMetadata("defaultParameters.kt")
    public void testDefaultParameters() throws Exception {
        runTest("plugins/noarg/noarg-cli/testData/bytecodeListing/defaultParameters.kt");
    }

    @TestMetadata("inherited.kt")
    public void testInherited() throws Exception {
        runTest("plugins/noarg/noarg-cli/testData/bytecodeListing/inherited.kt");
    }

    @TestMetadata("noNoArg.kt")
    public void testNoNoArg() throws Exception {
        runTest("plugins/noarg/noarg-cli/testData/bytecodeListing/noNoArg.kt");
    }

    @TestMetadata("severalNoArg.kt")
    public void testSeveralNoArg() throws Exception {
        runTest("plugins/noarg/noarg-cli/testData/bytecodeListing/severalNoArg.kt");
    }

    @TestMetadata("simple.kt")
    public void testSimple() throws Exception {
        runTest("plugins/noarg/noarg-cli/testData/bytecodeListing/simple.kt");
    }

    @TestMetadata("superTypes.kt")
    public void testSuperTypes() throws Exception {
        runTest("plugins/noarg/noarg-cli/testData/bytecodeListing/superTypes.kt");
    }
}
