/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.j2k;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("j2k/testData/fileOrElement")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class JavaToKotlinConverterSingleFileTestGenerated extends AbstractJavaToKotlinConverterSingleFileTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
    }

    public void testAllFilesPresentInFileOrElement() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
    }

    @TestMetadata("j2k/testData/fileOrElement/annotations")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Annotations extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAnnotations() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/annotations"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("annotationArrayArgument.java")
        public void testAnnotationArrayArgument() throws Exception {
            runTest("j2k/testData/fileOrElement/annotations/annotationArrayArgument.java");
        }

        @TestMetadata("annotationDefault.java")
        public void testAnnotationDefault() throws Exception {
            runTest("j2k/testData/fileOrElement/annotations/annotationDefault.java");
        }

        @TestMetadata("annotationFromConstructorParamToProperty.java")
        public void testAnnotationFromConstructorParamToProperty() throws Exception {
            runTest("j2k/testData/fileOrElement/annotations/annotationFromConstructorParamToProperty.java");
        }

        @TestMetadata("annotationInterface1.java")
        public void testAnnotationInterface1() throws Exception {
            runTest("j2k/testData/fileOrElement/annotations/annotationInterface1.java");
        }

        @TestMetadata("annotationInterface2.java")
        public void testAnnotationInterface2() throws Exception {
            runTest("j2k/testData/fileOrElement/annotations/annotationInterface2.java");
        }

        @TestMetadata("annotationInterface3.java")
        public void testAnnotationInterface3() throws Exception {
            runTest("j2k/testData/fileOrElement/annotations/annotationInterface3.java");
        }

        @TestMetadata("annotationInterface4.java")
        public void testAnnotationInterface4() throws Exception {
            runTest("j2k/testData/fileOrElement/annotations/annotationInterface4.java");
        }

        @TestMetadata("annotationUsages.java")
        public void testAnnotationUsages() throws Exception {
            runTest("j2k/testData/fileOrElement/annotations/annotationUsages.java");
        }

        @TestMetadata("annotationsFromPropertyAccessors.java")
        public void testAnnotationsFromPropertyAccessors() throws Exception {
            runTest("j2k/testData/fileOrElement/annotations/annotationsFromPropertyAccessors.java");
        }

        @TestMetadata("javaClassArgument.java")
        public void testJavaClassArgument() throws Exception {
            runTest("j2k/testData/fileOrElement/annotations/javaClassArgument.java");
        }

        @TestMetadata("javaClassArrayArgument.java")
        public void testJavaClassArrayArgument() throws Exception {
            runTest("j2k/testData/fileOrElement/annotations/javaClassArrayArgument.java");
        }

        @TestMetadata("jetbrainsNotNull.java")
        public void testJetbrainsNotNull() throws Exception {
            runTest("j2k/testData/fileOrElement/annotations/jetbrainsNotNull.java");
        }

        @TestMetadata("jetbrainsNotNullChainExpr.java")
        public void testJetbrainsNotNullChainExpr() throws Exception {
            runTest("j2k/testData/fileOrElement/annotations/jetbrainsNotNullChainExpr.java");
        }

        @TestMetadata("jetbrainsNullable.java")
        public void testJetbrainsNullable() throws Exception {
            runTest("j2k/testData/fileOrElement/annotations/jetbrainsNullable.java");
        }

        @TestMetadata("modifiersToAnnotationsFromPropertyAccessors.java")
        public void testModifiersToAnnotationsFromPropertyAccessors() throws Exception {
            runTest("j2k/testData/fileOrElement/annotations/modifiersToAnnotationsFromPropertyAccessors.java");
        }

        @TestMetadata("primaryConstructorAnnotation.java")
        public void testPrimaryConstructorAnnotation() throws Exception {
            runTest("j2k/testData/fileOrElement/annotations/primaryConstructorAnnotation.java");
        }

        @TestMetadata("serialVersionUID.java")
        public void testSerialVersionUID() throws Exception {
            runTest("j2k/testData/fileOrElement/annotations/serialVersionUID.java");
        }

        @TestMetadata("suppressWarnings.java")
        public void testSuppressWarnings() throws Exception {
            runTest("j2k/testData/fileOrElement/annotations/suppressWarnings.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/anonymousBlock")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AnonymousBlock extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAnonymousBlock() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/anonymousBlock"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("oneAnonBlock.java")
        public void testOneAnonBlock() throws Exception {
            runTest("j2k/testData/fileOrElement/anonymousBlock/oneAnonBlock.java");
        }

        @TestMetadata("oneStaticAnonBlock.java")
        public void testOneStaticAnonBlock() throws Exception {
            runTest("j2k/testData/fileOrElement/anonymousBlock/oneStaticAnonBlock.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/anonymousClass")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AnonymousClass extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAnonymousClass() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/anonymousClass"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("kt-13146.java")
        public void testKt_13146() throws Exception {
            runTest("j2k/testData/fileOrElement/anonymousClass/kt-13146.java");
        }

        @TestMetadata("localSelfReference.java")
        public void testLocalSelfReference() throws Exception {
            runTest("j2k/testData/fileOrElement/anonymousClass/localSelfReference.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/arrayAccessExpression")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ArrayAccessExpression extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInArrayAccessExpression() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/arrayAccessExpression"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("expressionIndex.java")
        public void testExpressionIndex() throws Exception {
            runTest("j2k/testData/fileOrElement/arrayAccessExpression/expressionIndex.java");
        }

        @TestMetadata("intIndex.java")
        public void testIntIndex() throws Exception {
            runTest("j2k/testData/fileOrElement/arrayAccessExpression/intIndex.java");
        }

        @TestMetadata("variableIndex.java")
        public void testVariableIndex() throws Exception {
            runTest("j2k/testData/fileOrElement/arrayAccessExpression/variableIndex.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/arrayInitializerExpression")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ArrayInitializerExpression extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInArrayInitializerExpression() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/arrayInitializerExpression"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("doubleArray.java")
        public void testDoubleArray() throws Exception {
            runTest("j2k/testData/fileOrElement/arrayInitializerExpression/doubleArray.java");
        }

        @TestMetadata("doubleArrayWithVariables.java")
        public void testDoubleArrayWithVariables() throws Exception {
            runTest("j2k/testData/fileOrElement/arrayInitializerExpression/doubleArrayWithVariables.java");
        }

        @TestMetadata("floatArray.java")
        public void testFloatArray() throws Exception {
            runTest("j2k/testData/fileOrElement/arrayInitializerExpression/floatArray.java");
        }

        @TestMetadata("intArrayWithLength.java")
        public void testIntArrayWithLength() throws Exception {
            runTest("j2k/testData/fileOrElement/arrayInitializerExpression/intArrayWithLength.java");
        }

        @TestMetadata("javaLangDoubleArray.java")
        public void testJavaLangDoubleArray() throws Exception {
            runTest("j2k/testData/fileOrElement/arrayInitializerExpression/javaLangDoubleArray.java");
        }

        @TestMetadata("javaLangFloatArray.java")
        public void testJavaLangFloatArray() throws Exception {
            runTest("j2k/testData/fileOrElement/arrayInitializerExpression/javaLangFloatArray.java");
        }

        @TestMetadata("newByte.java")
        public void testNewByte() throws Exception {
            runTest("j2k/testData/fileOrElement/arrayInitializerExpression/newByte.java");
        }

        @TestMetadata("newInt.java")
        public void testNewInt() throws Exception {
            runTest("j2k/testData/fileOrElement/arrayInitializerExpression/newInt.java");
        }

        @TestMetadata("objectArrayWithLength.java")
        public void testObjectArrayWithLength() throws Exception {
            runTest("j2k/testData/fileOrElement/arrayInitializerExpression/objectArrayWithLength.java");
        }

        @TestMetadata("oneDim.java")
        public void testOneDim() throws Exception {
            runTest("j2k/testData/fileOrElement/arrayInitializerExpression/oneDim.java");
        }

        @TestMetadata("oneDimWithVariables.java")
        public void testOneDimWithVariables() throws Exception {
            runTest("j2k/testData/fileOrElement/arrayInitializerExpression/oneDimWithVariables.java");
        }

        @TestMetadata("twoDim.java")
        public void testTwoDim() throws Exception {
            runTest("j2k/testData/fileOrElement/arrayInitializerExpression/twoDim.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/arrayType")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ArrayType extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInArrayType() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/arrayType"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("arrayInitializationStatement.java")
        public void testArrayInitializationStatement() throws Exception {
            runTest("j2k/testData/fileOrElement/arrayType/arrayInitializationStatement.java");
        }

        @TestMetadata("arrayInitializationStatementWithDimension.java")
        public void testArrayInitializationStatementWithDimension() throws Exception {
            runTest("j2k/testData/fileOrElement/arrayType/arrayInitializationStatementWithDimension.java");
        }

        @TestMetadata("arrayInitializationStatementWithDimension3d.java")
        public void testArrayInitializationStatementWithDimension3d() throws Exception {
            runTest("j2k/testData/fileOrElement/arrayType/arrayInitializationStatementWithDimension3d.java");
        }

        @TestMetadata("arrayInitializationStatementWithDimensionExplicit.java")
        public void testArrayInitializationStatementWithDimensionExplicit() throws Exception {
            runTest("j2k/testData/fileOrElement/arrayType/arrayInitializationStatementWithDimensionExplicit.java");
        }

        @TestMetadata("d2StringEmptyArray.java")
        public void testD2StringEmptyArray() throws Exception {
            runTest("j2k/testData/fileOrElement/arrayType/d2StringEmptyArray.java");
        }

        @TestMetadata("d3StringEmptyArray.java")
        public void testD3StringEmptyArray() throws Exception {
            runTest("j2k/testData/fileOrElement/arrayType/d3StringEmptyArray.java");
        }

        @TestMetadata("longArray.java")
        public void testLongArray() throws Exception {
            runTest("j2k/testData/fileOrElement/arrayType/longArray.java");
        }

        @TestMetadata("methodArrayArgs.java")
        public void testMethodArrayArgs() throws Exception {
            runTest("j2k/testData/fileOrElement/arrayType/methodArrayArgs.java");
        }

        @TestMetadata("newIntArray.java")
        public void testNewIntArray() throws Exception {
            runTest("j2k/testData/fileOrElement/arrayType/newIntArray.java");
        }

        @TestMetadata("newStringArray.java")
        public void testNewStringArray() throws Exception {
            runTest("j2k/testData/fileOrElement/arrayType/newStringArray.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/assertStatement")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AssertStatement extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAssertStatement() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/assertStatement"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("assertNotNull.java")
        public void testAssertNotNull() throws Exception {
            runTest("j2k/testData/fileOrElement/assertStatement/assertNotNull.java");
        }

        @TestMetadata("onlyCondition.java")
        public void testOnlyCondition() throws Exception {
            runTest("j2k/testData/fileOrElement/assertStatement/onlyCondition.java");
        }

        @TestMetadata("onlyConditionWithBraces.java")
        public void testOnlyConditionWithBraces() throws Exception {
            runTest("j2k/testData/fileOrElement/assertStatement/onlyConditionWithBraces.java");
        }

        @TestMetadata("withStringDetail.java")
        public void testWithStringDetail() throws Exception {
            runTest("j2k/testData/fileOrElement/assertStatement/withStringDetail.java");
        }

        @TestMetadata("withStringDetail2.java")
        public void testWithStringDetail2() throws Exception {
            runTest("j2k/testData/fileOrElement/assertStatement/withStringDetail2.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/assignmentExpression")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AssignmentExpression extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAssignmentExpression() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/assignmentExpression"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("and.java")
        public void testAnd() throws Exception {
            runTest("j2k/testData/fileOrElement/assignmentExpression/and.java");
        }

        @TestMetadata("assignment.java")
        public void testAssignment() throws Exception {
            runTest("j2k/testData/fileOrElement/assignmentExpression/assignment.java");
        }

        @TestMetadata("assignmentAsExpression.java")
        public void testAssignmentAsExpression() throws Exception {
            runTest("j2k/testData/fileOrElement/assignmentExpression/assignmentAsExpression.java");
        }

        @TestMetadata("bitOperationPriority.java")
        public void testBitOperationPriority() throws Exception {
            runTest("j2k/testData/fileOrElement/assignmentExpression/bitOperationPriority.java");
        }

        @TestMetadata("bitOperationPriorityComments.java")
        public void testBitOperationPriorityComments() throws Exception {
            runTest("j2k/testData/fileOrElement/assignmentExpression/bitOperationPriorityComments.java");
        }

        @TestMetadata("divideAssign.java")
        public void testDivideAssign() throws Exception {
            runTest("j2k/testData/fileOrElement/assignmentExpression/divideAssign.java");
        }

        @TestMetadata("minusAssign.java")
        public void testMinusAssign() throws Exception {
            runTest("j2k/testData/fileOrElement/assignmentExpression/minusAssign.java");
        }

        @TestMetadata("multiplyAssign.java")
        public void testMultiplyAssign() throws Exception {
            runTest("j2k/testData/fileOrElement/assignmentExpression/multiplyAssign.java");
        }

        @TestMetadata("nullability.java")
        public void testNullability() throws Exception {
            runTest("j2k/testData/fileOrElement/assignmentExpression/nullability.java");
        }

        @TestMetadata("nullability-settings.java")
        public void testNullability_settings() throws Exception {
            runTest("j2k/testData/fileOrElement/assignmentExpression/nullability-settings.java");
        }

        @TestMetadata("or.java")
        public void testOr() throws Exception {
            runTest("j2k/testData/fileOrElement/assignmentExpression/or.java");
        }

        @TestMetadata("plusAssign.java")
        public void testPlusAssign() throws Exception {
            runTest("j2k/testData/fileOrElement/assignmentExpression/plusAssign.java");
        }

        @TestMetadata("reminder.java")
        public void testReminder() throws Exception {
            runTest("j2k/testData/fileOrElement/assignmentExpression/reminder.java");
        }

        @TestMetadata("shiftLeft.java")
        public void testShiftLeft() throws Exception {
            runTest("j2k/testData/fileOrElement/assignmentExpression/shiftLeft.java");
        }

        @TestMetadata("shiftRight.java")
        public void testShiftRight() throws Exception {
            runTest("j2k/testData/fileOrElement/assignmentExpression/shiftRight.java");
        }

        @TestMetadata("simpleAssignment.java")
        public void testSimpleAssignment() throws Exception {
            runTest("j2k/testData/fileOrElement/assignmentExpression/simpleAssignment.java");
        }

        @TestMetadata("unsignedRightShift.java")
        public void testUnsignedRightShift() throws Exception {
            runTest("j2k/testData/fileOrElement/assignmentExpression/unsignedRightShift.java");
        }

        @TestMetadata("xor.java")
        public void testXor() throws Exception {
            runTest("j2k/testData/fileOrElement/assignmentExpression/xor.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/binaryExpression")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class BinaryExpression extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInBinaryExpression() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/binaryExpression"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("and.java")
        public void testAnd() throws Exception {
            runTest("j2k/testData/fileOrElement/binaryExpression/and.java");
        }

        @TestMetadata("conditionalAnd.java")
        public void testConditionalAnd() throws Exception {
            runTest("j2k/testData/fileOrElement/binaryExpression/conditionalAnd.java");
        }

        @TestMetadata("conditionalOr.java")
        public void testConditionalOr() throws Exception {
            runTest("j2k/testData/fileOrElement/binaryExpression/conditionalOr.java");
        }

        @TestMetadata("divide.java")
        public void testDivide() throws Exception {
            runTest("j2k/testData/fileOrElement/binaryExpression/divide.java");
        }

        @TestMetadata("greaterThan.java")
        public void testGreaterThan() throws Exception {
            runTest("j2k/testData/fileOrElement/binaryExpression/greaterThan.java");
        }

        @TestMetadata("greaterThanEqual.java")
        public void testGreaterThanEqual() throws Exception {
            runTest("j2k/testData/fileOrElement/binaryExpression/greaterThanEqual.java");
        }

        @TestMetadata("lessThan.java")
        public void testLessThan() throws Exception {
            runTest("j2k/testData/fileOrElement/binaryExpression/lessThan.java");
        }

        @TestMetadata("lessThanEqual.java")
        public void testLessThanEqual() throws Exception {
            runTest("j2k/testData/fileOrElement/binaryExpression/lessThanEqual.java");
        }

        @TestMetadata("lhsObjectPlusString.java")
        public void testLhsObjectPlusString() throws Exception {
            runTest("j2k/testData/fileOrElement/binaryExpression/lhsObjectPlusString.java");
        }

        @TestMetadata("minus.java")
        public void testMinus() throws Exception {
            runTest("j2k/testData/fileOrElement/binaryExpression/minus.java");
        }

        @TestMetadata("multiplePlusMinus.java")
        public void testMultiplePlusMinus() throws Exception {
            runTest("j2k/testData/fileOrElement/binaryExpression/multiplePlusMinus.java");
        }

        @TestMetadata("multiply.java")
        public void testMultiply() throws Exception {
            runTest("j2k/testData/fileOrElement/binaryExpression/multiply.java");
        }

        @TestMetadata("or.java")
        public void testOr() throws Exception {
            runTest("j2k/testData/fileOrElement/binaryExpression/or.java");
        }

        @TestMetadata("orWithNewLine.java")
        public void testOrWithNewLine() throws Exception {
            runTest("j2k/testData/fileOrElement/binaryExpression/orWithNewLine.java");
        }

        @TestMetadata("plus.java")
        public void testPlus() throws Exception {
            runTest("j2k/testData/fileOrElement/binaryExpression/plus.java");
        }

        @TestMetadata("remainder.java")
        public void testRemainder() throws Exception {
            runTest("j2k/testData/fileOrElement/binaryExpression/remainder.java");
        }

        @TestMetadata("shiftLeft.java")
        public void testShiftLeft() throws Exception {
            runTest("j2k/testData/fileOrElement/binaryExpression/shiftLeft.java");
        }

        @TestMetadata("shiftRight.java")
        public void testShiftRight() throws Exception {
            runTest("j2k/testData/fileOrElement/binaryExpression/shiftRight.java");
        }

        @TestMetadata("unsignedRightShift.java")
        public void testUnsignedRightShift() throws Exception {
            runTest("j2k/testData/fileOrElement/binaryExpression/unsignedRightShift.java");
        }

        @TestMetadata("xor.java")
        public void testXor() throws Exception {
            runTest("j2k/testData/fileOrElement/binaryExpression/xor.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/blocks")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Blocks extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInBlocks() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/blocks"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("Blocks.java")
        public void testBlocks() throws Exception {
            runTest("j2k/testData/fileOrElement/blocks/Blocks.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/boxedType")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class BoxedType extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInBoxedType() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/boxedType"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("boolean.java")
        public void testBoolean() throws Exception {
            runTest("j2k/testData/fileOrElement/boxedType/boolean.java");
        }

        @TestMetadata("Boxing.java")
        public void testBoxing() throws Exception {
            runTest("j2k/testData/fileOrElement/boxedType/Boxing.java");
        }

        @TestMetadata("byte.java")
        public void testByte() throws Exception {
            runTest("j2k/testData/fileOrElement/boxedType/byte.java");
        }

        @TestMetadata("character.java")
        public void testCharacter() throws Exception {
            runTest("j2k/testData/fileOrElement/boxedType/character.java");
        }

        @TestMetadata("double.java")
        public void testDouble() throws Exception {
            runTest("j2k/testData/fileOrElement/boxedType/double.java");
        }

        @TestMetadata("float.java")
        public void testFloat() throws Exception {
            runTest("j2k/testData/fileOrElement/boxedType/float.java");
        }

        @TestMetadata("integer.java")
        public void testInteger() throws Exception {
            runTest("j2k/testData/fileOrElement/boxedType/integer.java");
        }

        @TestMetadata("kt-671.java")
        public void testKt_671() throws Exception {
            runTest("j2k/testData/fileOrElement/boxedType/kt-671.java");
        }

        @TestMetadata("long.java")
        public void testLong() throws Exception {
            runTest("j2k/testData/fileOrElement/boxedType/long.java");
        }

        @TestMetadata("object.java")
        public void testObject() throws Exception {
            runTest("j2k/testData/fileOrElement/boxedType/object.java");
        }

        @TestMetadata("short.java")
        public void testShort() throws Exception {
            runTest("j2k/testData/fileOrElement/boxedType/short.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/breakStatement")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class BreakStatement extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInBreakStatement() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/breakStatement"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("breakWithLabel.java")
        public void testBreakWithLabel() throws Exception {
            runTest("j2k/testData/fileOrElement/breakStatement/breakWithLabel.java");
        }

        @TestMetadata("breakWithoutLabel.java")
        public void testBreakWithoutLabel() throws Exception {
            runTest("j2k/testData/fileOrElement/breakStatement/breakWithoutLabel.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/callChainExpression")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CallChainExpression extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInCallChainExpression() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/callChainExpression"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("libraryFieldCall.java")
        public void testLibraryFieldCall() throws Exception {
            runTest("j2k/testData/fileOrElement/callChainExpression/libraryFieldCall.java");
        }

        @TestMetadata("libraryMethodCall.java")
        public void testLibraryMethodCall() throws Exception {
            runTest("j2k/testData/fileOrElement/callChainExpression/libraryMethodCall.java");
        }

        @TestMetadata("libraryMethodCallFromInstance.java")
        public void testLibraryMethodCallFromInstance() throws Exception {
            runTest("j2k/testData/fileOrElement/callChainExpression/libraryMethodCallFromInstance.java");
        }

        @TestMetadata("libraryMethodCallFromInstance-settings.java")
        public void testLibraryMethodCallFromInstance_settings() throws Exception {
            runTest("j2k/testData/fileOrElement/callChainExpression/libraryMethodCallFromInstance-settings.java");
        }

        @TestMetadata("libraryStringFieldCall.java")
        public void testLibraryStringFieldCall() throws Exception {
            runTest("j2k/testData/fileOrElement/callChainExpression/libraryStringFieldCall.java");
        }

        @TestMetadata("sout.java")
        public void testSout() throws Exception {
            runTest("j2k/testData/fileOrElement/callChainExpression/sout.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/class")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Class extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("abstractClass.java")
        public void testAbstractClass() throws Exception {
            runTest("j2k/testData/fileOrElement/class/abstractClass.java");
        }

        @TestMetadata("abstractClassShape.java")
        public void testAbstractClassShape() throws Exception {
            runTest("j2k/testData/fileOrElement/class/abstractClassShape.java");
        }

        public void testAllFilesPresentInClass() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/class"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("anonymousClass.java")
        public void testAnonymousClass() throws Exception {
            runTest("j2k/testData/fileOrElement/class/anonymousClass.java");
        }

        @TestMetadata("class.java")
        public void testClass() throws Exception {
            runTest("j2k/testData/fileOrElement/class/class.java");
        }

        @TestMetadata("ClassShadowing.java")
        public void testClassShadowing() throws Exception {
            runTest("j2k/testData/fileOrElement/class/ClassShadowing.java");
        }

        @TestMetadata("classWithEmptyMethods.java")
        public void testClassWithEmptyMethods() throws Exception {
            runTest("j2k/testData/fileOrElement/class/classWithEmptyMethods.java");
        }

        @TestMetadata("classWithFields.java")
        public void testClassWithFields() throws Exception {
            runTest("j2k/testData/fileOrElement/class/classWithFields.java");
        }

        @TestMetadata("classWithMultiplyFields.java")
        public void testClassWithMultiplyFields() throws Exception {
            runTest("j2k/testData/fileOrElement/class/classWithMultiplyFields.java");
        }

        @TestMetadata("emptyClass.java")
        public void testEmptyClass() throws Exception {
            runTest("j2k/testData/fileOrElement/class/emptyClass.java");
        }

        @TestMetadata("extendsOneClassAndImplementsOneInterface.java")
        public void testExtendsOneClassAndImplementsOneInterface() throws Exception {
            runTest("j2k/testData/fileOrElement/class/extendsOneClassAndImplementsOneInterface.java");
        }

        @TestMetadata("extendsOneClassAndImplementsSeveralInterfaces.java")
        public void testExtendsOneClassAndImplementsSeveralInterfaces() throws Exception {
            runTest("j2k/testData/fileOrElement/class/extendsOneClassAndImplementsSeveralInterfaces.java");
        }

        @TestMetadata("finalClass.java")
        public void testFinalClass() throws Exception {
            runTest("j2k/testData/fileOrElement/class/finalClass.java");
        }

        @TestMetadata("genericClass.java")
        public void testGenericClass() throws Exception {
            runTest("j2k/testData/fileOrElement/class/genericClass.java");
        }

        @TestMetadata("innerClassInInterface.java")
        public void testInnerClassInInterface() throws Exception {
            runTest("j2k/testData/fileOrElement/class/innerClassInInterface.java");
        }

        @TestMetadata("innerEmptyClass.java")
        public void testInnerEmptyClass() throws Exception {
            runTest("j2k/testData/fileOrElement/class/innerEmptyClass.java");
        }

        @TestMetadata("innerEnum.java")
        public void testInnerEnum() throws Exception {
            runTest("j2k/testData/fileOrElement/class/innerEnum.java");
        }

        @TestMetadata("innerInterface.java")
        public void testInnerInterface() throws Exception {
            runTest("j2k/testData/fileOrElement/class/innerInterface.java");
        }

        @TestMetadata("innerStaticClass.java")
        public void testInnerStaticClass() throws Exception {
            runTest("j2k/testData/fileOrElement/class/innerStaticClass.java");
        }

        @TestMetadata("internalClass.java")
        public void testInternalClass() throws Exception {
            runTest("j2k/testData/fileOrElement/class/internalClass.java");
        }

        @TestMetadata("kt-639.java")
        public void testKt_639() throws Exception {
            runTest("j2k/testData/fileOrElement/class/kt-639.java");
        }

        @TestMetadata("notUtilityClass.java")
        public void testNotUtilityClass() throws Exception {
            runTest("j2k/testData/fileOrElement/class/notUtilityClass.java");
        }

        @TestMetadata("oneStaticFieldOneNonStatic.java")
        public void testOneStaticFieldOneNonStatic() throws Exception {
            runTest("j2k/testData/fileOrElement/class/oneStaticFieldOneNonStatic.java");
        }

        @TestMetadata("oneStaticMethod.java")
        public void testOneStaticMethod() throws Exception {
            runTest("j2k/testData/fileOrElement/class/oneStaticMethod.java");
        }

        @TestMetadata("oneStaticMethodOneNonStatic.java")
        public void testOneStaticMethodOneNonStatic() throws Exception {
            runTest("j2k/testData/fileOrElement/class/oneStaticMethodOneNonStatic.java");
        }

        @TestMetadata("pivateClass.java")
        public void testPivateClass() throws Exception {
            runTest("j2k/testData/fileOrElement/class/pivateClass.java");
        }

        @TestMetadata("privateInit.java")
        public void testPrivateInit() throws Exception {
            runTest("j2k/testData/fileOrElement/class/privateInit.java");
        }

        @TestMetadata("protectedClass.java")
        public void testProtectedClass() throws Exception {
            runTest("j2k/testData/fileOrElement/class/protectedClass.java");
        }

        @TestMetadata("publicClass.java")
        public void testPublicClass() throws Exception {
            runTest("j2k/testData/fileOrElement/class/publicClass.java");
        }

        @TestMetadata("simpleInheritance.java")
        public void testSimpleInheritance() throws Exception {
            runTest("j2k/testData/fileOrElement/class/simpleInheritance.java");
        }

        @TestMetadata("twoStaticMethod.java")
        public void testTwoStaticMethod() throws Exception {
            runTest("j2k/testData/fileOrElement/class/twoStaticMethod.java");
        }

        @TestMetadata("utilityClass1.java")
        public void testUtilityClass1() throws Exception {
            runTest("j2k/testData/fileOrElement/class/utilityClass1.java");
        }

        @TestMetadata("utilityClass2.java")
        public void testUtilityClass2() throws Exception {
            runTest("j2k/testData/fileOrElement/class/utilityClass2.java");
        }

        @TestMetadata("utilityClass3.java")
        public void testUtilityClass3() throws Exception {
            runTest("j2k/testData/fileOrElement/class/utilityClass3.java");
        }

        @TestMetadata("utilityClass4.java")
        public void testUtilityClass4() throws Exception {
            runTest("j2k/testData/fileOrElement/class/utilityClass4.java");
        }

        @TestMetadata("utilityClass5.java")
        public void testUtilityClass5() throws Exception {
            runTest("j2k/testData/fileOrElement/class/utilityClass5.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/classExpression")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ClassExpression extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInClassExpression() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/classExpression"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("complexExample.java")
        public void testComplexExample() throws Exception {
            runTest("j2k/testData/fileOrElement/classExpression/complexExample.java");
        }

        @TestMetadata("objectClass.java")
        public void testObjectClass() throws Exception {
            runTest("j2k/testData/fileOrElement/classExpression/objectClass.java");
        }

        @TestMetadata("primitivesAndArrays.java")
        public void testPrimitivesAndArrays() throws Exception {
            runTest("j2k/testData/fileOrElement/classExpression/primitivesAndArrays.java");
        }

        @TestMetadata("stringClass.java")
        public void testStringClass() throws Exception {
            runTest("j2k/testData/fileOrElement/classExpression/stringClass.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/comments")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Comments extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInComments() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/comments"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("commentInsideCall.java")
        public void testCommentInsideCall() throws Exception {
            runTest("j2k/testData/fileOrElement/comments/commentInsideCall.java");
        }

        @TestMetadata("comments.java")
        public void testComments() throws Exception {
            runTest("j2k/testData/fileOrElement/comments/comments.java");
        }

        @TestMetadata("comments2.java")
        public void testComments2() throws Exception {
            runTest("j2k/testData/fileOrElement/comments/comments2.java");
        }

        @TestMetadata("commentsForConstructors.java")
        public void testCommentsForConstructors() throws Exception {
            runTest("j2k/testData/fileOrElement/comments/commentsForConstructors.java");
        }

        @TestMetadata("fieldWithEndOfLineComment.java")
        public void testFieldWithEndOfLineComment() throws Exception {
            runTest("j2k/testData/fileOrElement/comments/fieldWithEndOfLineComment.java");
        }

        @TestMetadata("fieldsInitializedFromParams.java")
        public void testFieldsInitializedFromParams() throws Exception {
            runTest("j2k/testData/fileOrElement/comments/fieldsInitializedFromParams.java");
        }

        @TestMetadata("removeNoInspectionComment.java")
        public void testRemoveNoInspectionComment() throws Exception {
            runTest("j2k/testData/fileOrElement/comments/removeNoInspectionComment.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/conditionalExpression")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConditionalExpression extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConditionalExpression() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/conditionalExpression"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("multiline.java")
        public void testMultiline() throws Exception {
            runTest("j2k/testData/fileOrElement/conditionalExpression/multiline.java");
        }

        @TestMetadata("simple.java")
        public void testSimple() throws Exception {
            runTest("j2k/testData/fileOrElement/conditionalExpression/simple.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/constructors")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Constructors extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("allCallsPrimary.java")
        public void testAllCallsPrimary() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/allCallsPrimary.java");
        }

        @TestMetadata("allCallsPrimary2.java")
        public void testAllCallsPrimary2() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/allCallsPrimary2.java");
        }

        public void testAllFilesPresentInConstructors() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/constructors"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("artificialPrimary.java")
        public void testArtificialPrimary() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/artificialPrimary.java");
        }

        @TestMetadata("chain.java")
        public void testChain() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/chain.java");
        }

        @TestMetadata("constructorAnnotations.java")
        public void testConstructorAnnotations() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/constructorAnnotations.java");
        }

        @TestMetadata("customerBuilder.java")
        public void testCustomerBuilder() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/customerBuilder.java");
        }

        @TestMetadata("fieldsInitializedFromParams1.java")
        public void testFieldsInitializedFromParams1() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/fieldsInitializedFromParams1.java");
        }

        @TestMetadata("fieldsInitializedFromParams2.java")
        public void testFieldsInitializedFromParams2() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/fieldsInitializedFromParams2.java");
        }

        @TestMetadata("fieldsInitializedFromParams3.java")
        public void testFieldsInitializedFromParams3() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/fieldsInitializedFromParams3.java");
        }

        @TestMetadata("fieldsInitializedFromParams4.java")
        public void testFieldsInitializedFromParams4() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/fieldsInitializedFromParams4.java");
        }

        @TestMetadata("fieldsInitializedFromParams5.java")
        public void testFieldsInitializedFromParams5() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/fieldsInitializedFromParams5.java");
        }

        @TestMetadata("fieldsInitializedFromParams6.java")
        public void testFieldsInitializedFromParams6() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/fieldsInitializedFromParams6.java");
        }

        @TestMetadata("fieldsInitializedFromParams7.java")
        public void testFieldsInitializedFromParams7() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/fieldsInitializedFromParams7.java");
        }

        @TestMetadata("fieldsInitializedFromParams8.java")
        public void testFieldsInitializedFromParams8() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/fieldsInitializedFromParams8.java");
        }

        @TestMetadata("fieldsInitializedFromParams9.java")
        public void testFieldsInitializedFromParams9() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/fieldsInitializedFromParams9.java");
        }

        @TestMetadata("fieldsInitializedFromParamsAnnotations.java")
        public void testFieldsInitializedFromParamsAnnotations() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/fieldsInitializedFromParamsAnnotations.java");
        }

        @TestMetadata("genericIdentifier.java")
        public void testGenericIdentifier() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/genericIdentifier.java");
        }

        @TestMetadata("identifier.java")
        public void testIdentifier() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/identifier.java");
        }

        @TestMetadata("lineBreaksBetweenParameters.java")
        public void testLineBreaksBetweenParameters() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/lineBreaksBetweenParameters.java");
        }

        @TestMetadata("methodCallInFactoryFun.java")
        public void testMethodCallInFactoryFun() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/methodCallInFactoryFun.java");
        }

        @TestMetadata("nestedClassNameInParameterDefaults.java")
        public void testNestedClassNameInParameterDefaults() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/nestedClassNameInParameterDefaults.java");
        }

        @TestMetadata("nestedClassNameInParameterDefaults2.java")
        public void testNestedClassNameInParameterDefaults2() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/nestedClassNameInParameterDefaults2.java");
        }

        @TestMetadata("nestedClassNameInParameterDefaults3.java")
        public void testNestedClassNameInParameterDefaults3() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/nestedClassNameInParameterDefaults3.java");
        }

        @TestMetadata("nestedClassNameInParameterDefaults4.java")
        public void testNestedClassNameInParameterDefaults4() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/nestedClassNameInParameterDefaults4.java");
        }

        @TestMetadata("nestedClassNameInSuperParameters.java")
        public void testNestedClassNameInSuperParameters() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/nestedClassNameInSuperParameters.java");
        }

        @TestMetadata("noPrimary.java")
        public void testNoPrimary() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/noPrimary.java");
        }

        @TestMetadata("parameterDefaults1.java")
        public void testParameterDefaults1() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/parameterDefaults1.java");
        }

        @TestMetadata("parameterDefaults2.java")
        public void testParameterDefaults2() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/parameterDefaults2.java");
        }

        @TestMetadata("parameterDefaults3.java")
        public void testParameterDefaults3() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/parameterDefaults3.java");
        }

        @TestMetadata("parameterDefaults4.java")
        public void testParameterDefaults4() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/parameterDefaults4.java");
        }

        @TestMetadata("parameterDefaults5.java")
        public void testParameterDefaults5() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/parameterDefaults5.java");
        }

        @TestMetadata("parameterModification.java")
        public void testParameterModification() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/parameterModification.java");
        }

        @TestMetadata("privateConstructors.java")
        public void testPrivateConstructors() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/privateConstructors.java");
        }

        @TestMetadata("qualifiedRefInFactoryFun.java")
        public void testQualifiedRefInFactoryFun() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/qualifiedRefInFactoryFun.java");
        }

        @TestMetadata("secondaryConstructorWithDefaultValues.java")
        public void testSecondaryConstructorWithDefaultValues() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/secondaryConstructorWithDefaultValues.java");
        }

        @TestMetadata("secondaryConstructorWithDefaultValues2.java")
        public void testSecondaryConstructorWithDefaultValues2() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/secondaryConstructorWithDefaultValues2.java");
        }

        @TestMetadata("secondaryConstructorsInInnerClass.java")
        public void testSecondaryConstructorsInInnerClass() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/secondaryConstructorsInInnerClass.java");
        }

        @TestMetadata("secondaryConstructorsInNestedClass.java")
        public void testSecondaryConstructorsInNestedClass() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/secondaryConstructorsInNestedClass.java");
        }

        @TestMetadata("secondaryConstructorsVisibility.java")
        public void testSecondaryConstructorsVisibility() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/secondaryConstructorsVisibility.java");
        }

        @TestMetadata("staticFieldRefInFactoryFun.java")
        public void testStaticFieldRefInFactoryFun() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/staticFieldRefInFactoryFun.java");
        }

        @TestMetadata("withManyDefaultParams.java")
        public void testWithManyDefaultParams() throws Exception {
            runTest("j2k/testData/fileOrElement/constructors/withManyDefaultParams.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/continueStatement")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ContinueStatement extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInContinueStatement() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/continueStatement"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("continueWithLabel.java")
        public void testContinueWithLabel() throws Exception {
            runTest("j2k/testData/fileOrElement/continueStatement/continueWithLabel.java");
        }

        @TestMetadata("continueWithoutLabel.java")
        public void testContinueWithoutLabel() throws Exception {
            runTest("j2k/testData/fileOrElement/continueStatement/continueWithoutLabel.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/declarationStatement")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DeclarationStatement extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInDeclarationStatement() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/declarationStatement"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("multiplyFinalIntDeclaration.java")
        public void testMultiplyFinalIntDeclaration() throws Exception {
            runTest("j2k/testData/fileOrElement/declarationStatement/multiplyFinalIntDeclaration.java");
        }

        @TestMetadata("multiplyIntDeclaration.java")
        public void testMultiplyIntDeclaration() throws Exception {
            runTest("j2k/testData/fileOrElement/declarationStatement/multiplyIntDeclaration.java");
        }

        @TestMetadata("singleFinalIntDeclaration.java")
        public void testSingleFinalIntDeclaration() throws Exception {
            runTest("j2k/testData/fileOrElement/declarationStatement/singleFinalIntDeclaration.java");
        }

        @TestMetadata("singleFinalStringDeclaration.java")
        public void testSingleFinalStringDeclaration() throws Exception {
            runTest("j2k/testData/fileOrElement/declarationStatement/singleFinalStringDeclaration.java");
        }

        @TestMetadata("singleIntDeclaration.java")
        public void testSingleIntDeclaration() throws Exception {
            runTest("j2k/testData/fileOrElement/declarationStatement/singleIntDeclaration.java");
        }

        @TestMetadata("singleStringDeclaration.java")
        public void testSingleStringDeclaration() throws Exception {
            runTest("j2k/testData/fileOrElement/declarationStatement/singleStringDeclaration.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/detectProperties")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DetectProperties extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("AbstractPropertyPrivateSetter.java")
        public void testAbstractPropertyPrivateSetter() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/AbstractPropertyPrivateSetter.java");
        }

        @TestMetadata("AccessInGetterWithThis.java")
        public void testAccessInGetterWithThis() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/AccessInGetterWithThis.java");
        }

        @TestMetadata("AccessorsImplementInterface.java")
        public void testAccessorsImplementInterface() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/AccessorsImplementInterface.java");
        }

        public void testAllFilesPresentInDetectProperties() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/detectProperties"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("AnonymousClass.java")
        public void testAnonymousClass() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/AnonymousClass.java");
        }

        @TestMetadata("AssignFieldInsideSetter.java")
        public void testAssignFieldInsideSetter() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/AssignFieldInsideSetter.java");
        }

        @TestMetadata("AssignFieldInsideSetter2.java")
        public void testAssignFieldInsideSetter2() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/AssignFieldInsideSetter2.java");
        }

        @TestMetadata("CannotDropOnlySetter.java")
        public void testCannotDropOnlySetter() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/CannotDropOnlySetter.java");
        }

        @TestMetadata("Comments.java")
        public void testComments() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/Comments.java");
        }

        @TestMetadata("DataClass.java")
        public void testDataClass() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/DataClass.java");
        }

        @TestMetadata("DataClassWithAnnotations.java")
        public void testDataClassWithAnnotations() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/DataClassWithAnnotations.java");
        }

        @TestMetadata("DataClassWithMutableField.java")
        public void testDataClassWithMutableField() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/DataClassWithMutableField.java");
        }

        @TestMetadata("DifferentFieldName.java")
        public void testDifferentFieldName() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/DifferentFieldName.java");
        }

        @TestMetadata("DifferentFieldNameAndDefaultParameterValue.java")
        public void testDifferentFieldNameAndDefaultParameterValue() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/DifferentFieldNameAndDefaultParameterValue.java");
        }

        @TestMetadata("DifferentFieldNameAndSuperClass.java")
        public void testDifferentFieldNameAndSuperClass() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/DifferentFieldNameAndSuperClass.java");
        }

        @TestMetadata("DifferentProtectedFieldName.java")
        public void testDifferentProtectedFieldName() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/DifferentProtectedFieldName.java");
        }

        @TestMetadata("DropGetter.java")
        public void testDropGetter() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/DropGetter.java");
        }

        @TestMetadata("DropGetterAndSetter.java")
        public void testDropGetterAndSetter() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/DropGetterAndSetter.java");
        }

        @TestMetadata("DropGetterForMutable.java")
        public void testDropGetterForMutable() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/DropGetterForMutable.java");
        }

        @TestMetadata("FalseGetter.java")
        public void testFalseGetter() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/FalseGetter.java");
        }

        @TestMetadata("FalseSetter.java")
        public void testFalseSetter() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/FalseSetter.java");
        }

        @TestMetadata("FieldUsagesInFactoryMethods.java")
        public void testFieldUsagesInFactoryMethods() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/FieldUsagesInFactoryMethods.java");
        }

        @TestMetadata("GetterAndSetterNamesDifferent.java")
        public void testGetterAndSetterNamesDifferent() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/GetterAndSetterNamesDifferent.java");
        }

        @TestMetadata("GetterSetterUsages.java")
        public void testGetterSetterUsages() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/GetterSetterUsages.java");
        }

        @TestMetadata("GetterTypeNotMatch.java")
        public void testGetterTypeNotMatch() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/GetterTypeNotMatch.java");
        }

        @TestMetadata("GetterWithSideEffect1.java")
        public void testGetterWithSideEffect1() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/GetterWithSideEffect1.java");
        }

        @TestMetadata("GetterWithSideEffect2.java")
        public void testGetterWithSideEffect2() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/GetterWithSideEffect2.java");
        }

        @TestMetadata("GetterWithSideEffect3.java")
        public void testGetterWithSideEffect3() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/GetterWithSideEffect3.java");
        }

        @TestMetadata("GetterWithSideEffect4.java")
        public void testGetterWithSideEffect4() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/GetterWithSideEffect4.java");
        }

        @TestMetadata("GetterWithSideEffect5.java")
        public void testGetterWithSideEffect5() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/GetterWithSideEffect5.java");
        }

        @TestMetadata("InCompanionObject.java")
        public void testInCompanionObject() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/InCompanionObject.java");
        }

        @TestMetadata("InInterface.java")
        public void testInInterface() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/InInterface.java");
        }

        @TestMetadata("InObject.java")
        public void testInObject() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/InObject.java");
        }

        @TestMetadata("IsPrefix.java")
        public void testIsPrefix() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/IsPrefix.java");
        }

        @TestMetadata("JavaKeywordPropertyName.java")
        public void testJavaKeywordPropertyName() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/JavaKeywordPropertyName.java");
        }

        @TestMetadata("KeywordPropertyName.java")
        public void testKeywordPropertyName() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/KeywordPropertyName.java");
        }

        @TestMetadata("Overrides.java")
        public void testOverrides() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/Overrides.java");
        }

        @TestMetadata("OverridesOfExternalCode.java")
        public void testOverridesOfExternalCode() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/OverridesOfExternalCode.java");
        }

        @TestMetadata("PropertyAndFieldConflicts.java")
        public void testPropertyAndFieldConflicts() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/PropertyAndFieldConflicts.java");
        }

        @TestMetadata("PropertyType.java")
        public void testPropertyType() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/PropertyType.java");
        }

        @TestMetadata("SetterTypeNotMatch.java")
        public void testSetterTypeNotMatch() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/SetterTypeNotMatch.java");
        }

        @TestMetadata("SetterWithSideEffect1.java")
        public void testSetterWithSideEffect1() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/SetterWithSideEffect1.java");
        }

        @TestMetadata("SetterWithSideEffect2.java")
        public void testSetterWithSideEffect2() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/SetterWithSideEffect2.java");
        }

        @TestMetadata("SetterWithSideEffect3.java")
        public void testSetterWithSideEffect3() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/SetterWithSideEffect3.java");
        }

        @TestMetadata("SetterWithSideEffect4.java")
        public void testSetterWithSideEffect4() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/SetterWithSideEffect4.java");
        }

        @TestMetadata("SetterWithSideEffect5.java")
        public void testSetterWithSideEffect5() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/SetterWithSideEffect5.java");
        }

        @TestMetadata("SetterWithSideEffect6.java")
        public void testSetterWithSideEffect6() throws Exception {
            runTest("j2k/testData/fileOrElement/detectProperties/SetterWithSideEffect6.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/doWhileStatement")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DoWhileStatement extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInDoWhileStatement() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/doWhileStatement"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("whileWithAssignmentAsExpression.java")
        public void testWhileWithAssignmentAsExpression() throws Exception {
            runTest("j2k/testData/fileOrElement/doWhileStatement/whileWithAssignmentAsExpression.java");
        }

        @TestMetadata("whileWithBlock.java")
        public void testWhileWithBlock() throws Exception {
            runTest("j2k/testData/fileOrElement/doWhileStatement/whileWithBlock.java");
        }

        @TestMetadata("whileWithEmptyBlock.java")
        public void testWhileWithEmptyBlock() throws Exception {
            runTest("j2k/testData/fileOrElement/doWhileStatement/whileWithEmptyBlock.java");
        }

        @TestMetadata("whileWithExpression.java")
        public void testWhileWithExpression() throws Exception {
            runTest("j2k/testData/fileOrElement/doWhileStatement/whileWithExpression.java");
        }

        @TestMetadata("whileWithReturn.java")
        public void testWhileWithReturn() throws Exception {
            runTest("j2k/testData/fileOrElement/doWhileStatement/whileWithReturn.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/docComments")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DocComments extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("aWithoutHref.java")
        public void testAWithoutHref() throws Exception {
            runTest("j2k/testData/fileOrElement/docComments/aWithoutHref.java");
        }

        public void testAllFilesPresentInDocComments() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/docComments"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("deprecatedDocTag.java")
        public void testDeprecatedDocTag() throws Exception {
            runTest("j2k/testData/fileOrElement/docComments/deprecatedDocTag.java");
        }

        @TestMetadata("deprecatedDocTagWithAnnotation.java")
        public void testDeprecatedDocTagWithAnnotation() throws Exception {
            runTest("j2k/testData/fileOrElement/docComments/deprecatedDocTagWithAnnotation.java");
        }

        @TestMetadata("deprecatedDocTagWithMultiLineMessage.java")
        public void testDeprecatedDocTagWithMultiLineMessage() throws Exception {
            runTest("j2k/testData/fileOrElement/docComments/deprecatedDocTagWithMultiLineMessage.java");
        }

        @TestMetadata("docCommentWithParamTag.java")
        public void testDocCommentWithParamTag() throws Exception {
            runTest("j2k/testData/fileOrElement/docComments/docCommentWithParamTag.java");
        }

        @TestMetadata("escapedCharactersInCodeQuote.java")
        public void testEscapedCharactersInCodeQuote() throws Exception {
            runTest("j2k/testData/fileOrElement/docComments/escapedCharactersInCodeQuote.java");
        }

        @TestMetadata("htmlInDocComment.java")
        public void testHtmlInDocComment() throws Exception {
            runTest("j2k/testData/fileOrElement/docComments/htmlInDocComment.java");
        }

        @TestMetadata("inlineTagsInDocComment.java")
        public void testInlineTagsInDocComment() throws Exception {
            runTest("j2k/testData/fileOrElement/docComments/inlineTagsInDocComment.java");
        }

        @TestMetadata("linkTag.java")
        public void testLinkTag() throws Exception {
            runTest("j2k/testData/fileOrElement/docComments/linkTag.java");
        }

        @TestMetadata("linkTagWithLabel.java")
        public void testLinkTagWithLabel() throws Exception {
            runTest("j2k/testData/fileOrElement/docComments/linkTagWithLabel.java");
        }

        @TestMetadata("onlyDeprecatedDocTag.java")
        public void testOnlyDeprecatedDocTag() throws Exception {
            runTest("j2k/testData/fileOrElement/docComments/onlyDeprecatedDocTag.java");
        }

        @TestMetadata("preserveUnknownTags.java")
        public void testPreserveUnknownTags() throws Exception {
            runTest("j2k/testData/fileOrElement/docComments/preserveUnknownTags.java");
        }

        @TestMetadata("primaryConstructorDoc.java")
        public void testPrimaryConstructorDoc() throws Exception {
            runTest("j2k/testData/fileOrElement/docComments/primaryConstructorDoc.java");
        }

        @TestMetadata("quoted.java")
        public void testQuoted() throws Exception {
            runTest("j2k/testData/fileOrElement/docComments/quoted.java");
        }

        @TestMetadata("seeTag.java")
        public void testSeeTag() throws Exception {
            runTest("j2k/testData/fileOrElement/docComments/seeTag.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/enum")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Enum extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInEnum() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/enum"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("colorEnum.java")
        public void testColorEnum() throws Exception {
            runTest("j2k/testData/fileOrElement/enum/colorEnum.java");
        }

        @TestMetadata("companionObject.java")
        public void testCompanionObject() throws Exception {
            runTest("j2k/testData/fileOrElement/enum/companionObject.java");
        }

        @TestMetadata("constantsWithBody1.java")
        public void testConstantsWithBody1() throws Exception {
            runTest("j2k/testData/fileOrElement/enum/constantsWithBody1.java");
        }

        @TestMetadata("constantsWithBody2.java")
        public void testConstantsWithBody2() throws Exception {
            runTest("j2k/testData/fileOrElement/enum/constantsWithBody2.java");
        }

        @TestMetadata("emptyEnum.java")
        public void testEmptyEnum() throws Exception {
            runTest("j2k/testData/fileOrElement/enum/emptyEnum.java");
        }

        @TestMetadata("enumConstantIsNotNull.java")
        public void testEnumConstantIsNotNull() throws Exception {
            runTest("j2k/testData/fileOrElement/enum/enumConstantIsNotNull.java");
        }

        @TestMetadata("enumImplementsOneInterface.java")
        public void testEnumImplementsOneInterface() throws Exception {
            runTest("j2k/testData/fileOrElement/enum/enumImplementsOneInterface.java");
        }

        @TestMetadata("enumImplementsSeveralInterfaces.java")
        public void testEnumImplementsSeveralInterfaces() throws Exception {
            runTest("j2k/testData/fileOrElement/enum/enumImplementsSeveralInterfaces.java");
        }

        @TestMetadata("enumWithNameField.java")
        public void testEnumWithNameField() throws Exception {
            runTest("j2k/testData/fileOrElement/enum/enumWithNameField.java");
        }

        @TestMetadata("fieldsWithPrimaryPrivateConstructor.java")
        public void testFieldsWithPrimaryPrivateConstructor() throws Exception {
            runTest("j2k/testData/fileOrElement/enum/fieldsWithPrimaryPrivateConstructor.java");
        }

        @TestMetadata("internalEnum.java")
        public void testInternalEnum() throws Exception {
            runTest("j2k/testData/fileOrElement/enum/internalEnum.java");
        }

        @TestMetadata("overrideToString.java")
        public void testOverrideToString() throws Exception {
            runTest("j2k/testData/fileOrElement/enum/overrideToString.java");
        }

        @TestMetadata("primaryPrivateConstructor.java")
        public void testPrimaryPrivateConstructor() throws Exception {
            runTest("j2k/testData/fileOrElement/enum/primaryPrivateConstructor.java");
        }

        @TestMetadata("privateEnum.java")
        public void testPrivateEnum() throws Exception {
            runTest("j2k/testData/fileOrElement/enum/privateEnum.java");
        }

        @TestMetadata("protectedEnum.java")
        public void testProtectedEnum() throws Exception {
            runTest("j2k/testData/fileOrElement/enum/protectedEnum.java");
        }

        @TestMetadata("publicEnum.java")
        public void testPublicEnum() throws Exception {
            runTest("j2k/testData/fileOrElement/enum/publicEnum.java");
        }

        @TestMetadata("runnableImplementation.java")
        public void testRunnableImplementation() throws Exception {
            runTest("j2k/testData/fileOrElement/enum/runnableImplementation.java");
        }

        @TestMetadata("typeSafeEnum.java")
        public void testTypeSafeEnum() throws Exception {
            runTest("j2k/testData/fileOrElement/enum/typeSafeEnum.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/equals")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Equals extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInEquals() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/equals"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("EqOperator.java")
        public void testEqOperator() throws Exception {
            runTest("j2k/testData/fileOrElement/equals/EqOperator.java");
        }

        @TestMetadata("Equals1.java")
        public void testEquals1() throws Exception {
            runTest("j2k/testData/fileOrElement/equals/Equals1.java");
        }

        @TestMetadata("Equals2.java")
        public void testEquals2() throws Exception {
            runTest("j2k/testData/fileOrElement/equals/Equals2.java");
        }

        @TestMetadata("Equals3.java")
        public void testEquals3() throws Exception {
            runTest("j2k/testData/fileOrElement/equals/Equals3.java");
        }

        @TestMetadata("Equals4.java")
        public void testEquals4() throws Exception {
            runTest("j2k/testData/fileOrElement/equals/Equals4.java");
        }

        @TestMetadata("ObjectsEquals.java")
        public void testObjectsEquals() throws Exception {
            runTest("j2k/testData/fileOrElement/equals/ObjectsEquals.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/field")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Field extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInField() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/field"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("classChildExtendsBase.java")
        public void testClassChildExtendsBase() throws Exception {
            runTest("j2k/testData/fileOrElement/field/classChildExtendsBase.java");
        }

        @TestMetadata("conversion.java")
        public void testConversion() throws Exception {
            runTest("j2k/testData/fileOrElement/field/conversion.java");
        }

        @TestMetadata("internalField.java")
        public void testInternalField() throws Exception {
            runTest("j2k/testData/fileOrElement/field/internalField.java");
        }

        @TestMetadata("needInitializer.java")
        public void testNeedInitializer() throws Exception {
            runTest("j2k/testData/fileOrElement/field/needInitializer.java");
        }

        @TestMetadata("privateField.java")
        public void testPrivateField() throws Exception {
            runTest("j2k/testData/fileOrElement/field/privateField.java");
        }

        @TestMetadata("protectedField.java")
        public void testProtectedField() throws Exception {
            runTest("j2k/testData/fileOrElement/field/protectedField.java");
        }

        @TestMetadata("publicField.java")
        public void testPublicField() throws Exception {
            runTest("j2k/testData/fileOrElement/field/publicField.java");
        }

        @TestMetadata("specifyType.java")
        public void testSpecifyType() throws Exception {
            runTest("j2k/testData/fileOrElement/field/specifyType.java");
        }

        @TestMetadata("valOrVar.java")
        public void testValOrVar() throws Exception {
            runTest("j2k/testData/fileOrElement/field/valOrVar.java");
        }

        @TestMetadata("valWithInit.java")
        public void testValWithInit() throws Exception {
            runTest("j2k/testData/fileOrElement/field/valWithInit.java");
        }

        @TestMetadata("varWithInit.java")
        public void testVarWithInit() throws Exception {
            runTest("j2k/testData/fileOrElement/field/varWithInit.java");
        }

        @TestMetadata("varWithoutInit.java")
        public void testVarWithoutInit() throws Exception {
            runTest("j2k/testData/fileOrElement/field/varWithoutInit.java");
        }

        @TestMetadata("volatileTransientAndStrictFp.java")
        public void testVolatileTransientAndStrictFp() throws Exception {
            runTest("j2k/testData/fileOrElement/field/volatileTransientAndStrictFp.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/for")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class For extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInFor() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/for"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("arrayIndicesReversed.java")
        public void testArrayIndicesReversed() throws Exception {
            runTest("j2k/testData/fileOrElement/for/arrayIndicesReversed.java");
        }

        @TestMetadata("assignmentAsExpressionInBody.java")
        public void testAssignmentAsExpressionInBody() throws Exception {
            runTest("j2k/testData/fileOrElement/for/assignmentAsExpressionInBody.java");
        }

        @TestMetadata("commonCaseForTest.java")
        public void testCommonCaseForTest() throws Exception {
            runTest("j2k/testData/fileOrElement/for/commonCaseForTest.java");
        }

        @TestMetadata("downTo1.java")
        public void testDownTo1() throws Exception {
            runTest("j2k/testData/fileOrElement/for/downTo1.java");
        }

        @TestMetadata("downTo2.java")
        public void testDownTo2() throws Exception {
            runTest("j2k/testData/fileOrElement/for/downTo2.java");
        }

        @TestMetadata("downTo3.java")
        public void testDownTo3() throws Exception {
            runTest("j2k/testData/fileOrElement/for/downTo3.java");
        }

        @TestMetadata("downTo4.java")
        public void testDownTo4() throws Exception {
            runTest("j2k/testData/fileOrElement/for/downTo4.java");
        }

        @TestMetadata("falseArrayIndicesReversed.java")
        public void testFalseArrayIndicesReversed() throws Exception {
            runTest("j2k/testData/fileOrElement/for/falseArrayIndicesReversed.java");
        }

        @TestMetadata("falseArrayIndicesReversed2.java")
        public void testFalseArrayIndicesReversed2() throws Exception {
            runTest("j2k/testData/fileOrElement/for/falseArrayIndicesReversed2.java");
        }

        @TestMetadata("falseForRange.java")
        public void testFalseForRange() throws Exception {
            runTest("j2k/testData/fileOrElement/for/falseForRange.java");
        }

        @TestMetadata("falseIndicesReversed.java")
        public void testFalseIndicesReversed() throws Exception {
            runTest("j2k/testData/fileOrElement/for/falseIndicesReversed.java");
        }

        @TestMetadata("forRangeWithBlock.java")
        public void testForRangeWithBlock() throws Exception {
            runTest("j2k/testData/fileOrElement/for/forRangeWithBlock.java");
        }

        @TestMetadata("forRangeWithLE.java")
        public void testForRangeWithLE() throws Exception {
            runTest("j2k/testData/fileOrElement/for/forRangeWithLE.java");
        }

        @TestMetadata("forRangeWithLT.java")
        public void testForRangeWithLT() throws Exception {
            runTest("j2k/testData/fileOrElement/for/forRangeWithLT.java");
        }

        @TestMetadata("forRangeWithLT2.java")
        public void testForRangeWithLT2() throws Exception {
            runTest("j2k/testData/fileOrElement/for/forRangeWithLT2.java");
        }

        @TestMetadata("forRangeWithNE.java")
        public void testForRangeWithNE() throws Exception {
            runTest("j2k/testData/fileOrElement/for/forRangeWithNE.java");
        }

        @TestMetadata("forThroughArrayIndices.java")
        public void testForThroughArrayIndices() throws Exception {
            runTest("j2k/testData/fileOrElement/for/forThroughArrayIndices.java");
        }

        @TestMetadata("forThroughCollectionIndices.java")
        public void testForThroughCollectionIndices() throws Exception {
            runTest("j2k/testData/fileOrElement/for/forThroughCollectionIndices.java");
        }

        @TestMetadata("forThroughListIndices.java")
        public void testForThroughListIndices() throws Exception {
            runTest("j2k/testData/fileOrElement/for/forThroughListIndices.java");
        }

        @TestMetadata("forThroughListIndicesNE.java")
        public void testForThroughListIndicesNE() throws Exception {
            runTest("j2k/testData/fileOrElement/for/forThroughListIndicesNE.java");
        }

        @TestMetadata("forThroughNonArrayIndices.java")
        public void testForThroughNonArrayIndices() throws Exception {
            runTest("j2k/testData/fileOrElement/for/forThroughNonArrayIndices.java");
        }

        @TestMetadata("forThroughNonCollectionIndices.java")
        public void testForThroughNonCollectionIndices() throws Exception {
            runTest("j2k/testData/fileOrElement/for/forThroughNonCollectionIndices.java");
        }

        @TestMetadata("forWithBlock.java")
        public void testForWithBlock() throws Exception {
            runTest("j2k/testData/fileOrElement/for/forWithBlock.java");
        }

        @TestMetadata("forWithBlockAndDoubleUpdate.java")
        public void testForWithBlockAndDoubleUpdate() throws Exception {
            runTest("j2k/testData/fileOrElement/for/forWithBlockAndDoubleUpdate.java");
        }

        @TestMetadata("forWithEmptyBlock.java")
        public void testForWithEmptyBlock() throws Exception {
            runTest("j2k/testData/fileOrElement/for/forWithEmptyBlock.java");
        }

        @TestMetadata("forWithExpression.java")
        public void testForWithExpression() throws Exception {
            runTest("j2k/testData/fileOrElement/for/forWithExpression.java");
        }

        @TestMetadata("forWithNullCondition.java")
        public void testForWithNullCondition() throws Exception {
            runTest("j2k/testData/fileOrElement/for/forWithNullCondition.java");
        }

        @TestMetadata("forWithNullInit.java")
        public void testForWithNullInit() throws Exception {
            runTest("j2k/testData/fileOrElement/for/forWithNullInit.java");
        }

        @TestMetadata("forWithNullUpdate.java")
        public void testForWithNullUpdate() throws Exception {
            runTest("j2k/testData/fileOrElement/for/forWithNullUpdate.java");
        }

        @TestMetadata("forWithReturn.java")
        public void testForWithReturn() throws Exception {
            runTest("j2k/testData/fileOrElement/for/forWithReturn.java");
        }

        @TestMetadata("forWithoutBody.java")
        public void testForWithoutBody() throws Exception {
            runTest("j2k/testData/fileOrElement/for/forWithoutBody.java");
        }

        @TestMetadata("indicesReversed.java")
        public void testIndicesReversed() throws Exception {
            runTest("j2k/testData/fileOrElement/for/indicesReversed.java");
        }

        @TestMetadata("infiniteFor.java")
        public void testInfiniteFor() throws Exception {
            runTest("j2k/testData/fileOrElement/for/infiniteFor.java");
        }

        @TestMetadata("nameConflict1.java")
        public void testNameConflict1() throws Exception {
            runTest("j2k/testData/fileOrElement/for/nameConflict1.java");
        }

        @TestMetadata("nameConflict2.java")
        public void testNameConflict2() throws Exception {
            runTest("j2k/testData/fileOrElement/for/nameConflict2.java");
        }

        @TestMetadata("nameConflict3.java")
        public void testNameConflict3() throws Exception {
            runTest("j2k/testData/fileOrElement/for/nameConflict3.java");
        }

        @TestMetadata("nameConflict4.java")
        public void testNameConflict4() throws Exception {
            runTest("j2k/testData/fileOrElement/for/nameConflict4.java");
        }

        @TestMetadata("nameConflict5.java")
        public void testNameConflict5() throws Exception {
            runTest("j2k/testData/fileOrElement/for/nameConflict5.java");
        }

        @TestMetadata("notInBlock.java")
        public void testNotInBlock() throws Exception {
            runTest("j2k/testData/fileOrElement/for/notInBlock.java");
        }

        @TestMetadata("overMapEntries.java")
        public void testOverMapEntries() throws Exception {
            runTest("j2k/testData/fileOrElement/for/overMapEntries.java");
        }

        @TestMetadata("withContinue1.java")
        public void testWithContinue1() throws Exception {
            runTest("j2k/testData/fileOrElement/for/withContinue1.java");
        }

        @TestMetadata("withContinue2.java")
        public void testWithContinue2() throws Exception {
            runTest("j2k/testData/fileOrElement/for/withContinue2.java");
        }

        @TestMetadata("withContinue3.java")
        public void testWithContinue3() throws Exception {
            runTest("j2k/testData/fileOrElement/for/withContinue3.java");
        }

        @TestMetadata("withContinueAndLabels.java")
        public void testWithContinueAndLabels() throws Exception {
            runTest("j2k/testData/fileOrElement/for/withContinueAndLabels.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/foreachStatement")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ForeachStatement extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInForeachStatement() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/foreachStatement"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("enhancedForWithBlock.java")
        public void testEnhancedForWithBlock() throws Exception {
            runTest("j2k/testData/fileOrElement/foreachStatement/enhancedForWithBlock.java");
        }

        @TestMetadata("enhancedForWithEmptyBlock.java")
        public void testEnhancedForWithEmptyBlock() throws Exception {
            runTest("j2k/testData/fileOrElement/foreachStatement/enhancedForWithEmptyBlock.java");
        }

        @TestMetadata("enhancedForWithExpression.java")
        public void testEnhancedForWithExpression() throws Exception {
            runTest("j2k/testData/fileOrElement/foreachStatement/enhancedForWithExpression.java");
        }

        @TestMetadata("enhancedForWithReturn.java")
        public void testEnhancedForWithReturn() throws Exception {
            runTest("j2k/testData/fileOrElement/foreachStatement/enhancedForWithReturn.java");
        }

        @TestMetadata("foreachWithoutBody.java")
        public void testForeachWithoutBody() throws Exception {
            runTest("j2k/testData/fileOrElement/foreachStatement/foreachWithoutBody.java");
        }

        @TestMetadata("nullableIterable.java")
        public void testNullableIterable() throws Exception {
            runTest("j2k/testData/fileOrElement/foreachStatement/nullableIterable.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/formatting")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Formatting extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInFormatting() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/formatting"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("chainedCall.java")
        public void testChainedCall() throws Exception {
            runTest("j2k/testData/fileOrElement/formatting/chainedCall.java");
        }

        @TestMetadata("lineBreaksBetweenArguments.java")
        public void testLineBreaksBetweenArguments() throws Exception {
            runTest("j2k/testData/fileOrElement/formatting/lineBreaksBetweenArguments.java");
        }

        @TestMetadata("nonStaticMembers.java")
        public void testNonStaticMembers() throws Exception {
            runTest("j2k/testData/fileOrElement/formatting/nonStaticMembers.java");
        }

        @TestMetadata("nonStaticMembersWithComments.java")
        public void testNonStaticMembersWithComments() throws Exception {
            runTest("j2k/testData/fileOrElement/formatting/nonStaticMembersWithComments.java");
        }

        @TestMetadata("parameterList.java")
        public void testParameterList() throws Exception {
            runTest("j2k/testData/fileOrElement/formatting/parameterList.java");
        }

        @TestMetadata("staticAndNonStaticMembersWithComments.java")
        public void testStaticAndNonStaticMembersWithComments() throws Exception {
            runTest("j2k/testData/fileOrElement/formatting/staticAndNonStaticMembersWithComments.java");
        }

        @TestMetadata("staticMembersWithComments.java")
        public void testStaticMembersWithComments() throws Exception {
            runTest("j2k/testData/fileOrElement/formatting/staticMembersWithComments.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/function")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Function extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("abstractMethod.java")
        public void testAbstractMethod() throws Exception {
            runTest("j2k/testData/fileOrElement/function/abstractMethod.java");
        }

        public void testAllFilesPresentInFunction() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/function"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("classGenericParam.java")
        public void testClassGenericParam() throws Exception {
            runTest("j2k/testData/fileOrElement/function/classGenericParam.java");
        }

        @TestMetadata("emptyVoidMethod.java")
        public void testEmptyVoidMethod() throws Exception {
            runTest("j2k/testData/fileOrElement/function/emptyVoidMethod.java");
        }

        @TestMetadata("extendsBaseWhichExtendsObject.java")
        public void testExtendsBaseWhichExtendsObject() throws Exception {
            runTest("j2k/testData/fileOrElement/function/extendsBaseWhichExtendsObject.java");
        }

        @TestMetadata("final.java")
        public void testFinal() throws Exception {
            runTest("j2k/testData/fileOrElement/function/final.java");
        }

        @TestMetadata("functionInFinalClass.java")
        public void testFunctionInFinalClass() throws Exception {
            runTest("j2k/testData/fileOrElement/function/functionInFinalClass.java");
        }

        @TestMetadata("internal.java")
        public void testInternal() throws Exception {
            runTest("j2k/testData/fileOrElement/function/internal.java");
        }

        @TestMetadata("java8Lambdas.java")
        public void testJava8Lambdas() throws Exception {
            runTest("j2k/testData/fileOrElement/function/java8Lambdas.java");
        }

        @TestMetadata("java8MRKFunctionExpectedType.java")
        public void testJava8MRKFunctionExpectedType() throws Exception {
            runTest("j2k/testData/fileOrElement/function/java8MRKFunctionExpectedType.java");
        }

        @TestMetadata("java8MRSamConstructor.java")
        public void testJava8MRSamConstructor() throws Exception {
            runTest("j2k/testData/fileOrElement/function/java8MRSamConstructor.java");
        }

        @TestMetadata("lineBreaksBetweenParameters.java")
        public void testLineBreaksBetweenParameters() throws Exception {
            runTest("j2k/testData/fileOrElement/function/lineBreaksBetweenParameters.java");
        }

        @TestMetadata("main.java")
        public void testMain() throws Exception {
            runTest("j2k/testData/fileOrElement/function/main.java");
        }

        @TestMetadata("main2.java")
        public void testMain2() throws Exception {
            runTest("j2k/testData/fileOrElement/function/main2.java");
        }

        @TestMetadata("mainAndNullabilitySetting.java")
        public void testMainAndNullabilitySetting() throws Exception {
            runTest("j2k/testData/fileOrElement/function/mainAndNullabilitySetting.java");
        }

        @TestMetadata("methodClassType.java")
        public void testMethodClassType() throws Exception {
            runTest("j2k/testData/fileOrElement/function/methodClassType.java");
        }

        @TestMetadata("methodPrimitiveType.java")
        public void testMethodPrimitiveType() throws Exception {
            runTest("j2k/testData/fileOrElement/function/methodPrimitiveType.java");
        }

        @TestMetadata("methodPrimitiveType2.java")
        public void testMethodPrimitiveType2() throws Exception {
            runTest("j2k/testData/fileOrElement/function/methodPrimitiveType2.java");
        }

        @TestMetadata("methodWithReturnStatement.java")
        public void testMethodWithReturnStatement() throws Exception {
            runTest("j2k/testData/fileOrElement/function/methodWithReturnStatement.java");
        }

        @TestMetadata("nativeMethods.java")
        public void testNativeMethods() throws Exception {
            runTest("j2k/testData/fileOrElement/function/nativeMethods.java");
        }

        @TestMetadata("open.java")
        public void testOpen() throws Exception {
            runTest("j2k/testData/fileOrElement/function/open.java");
        }

        @TestMetadata("override.java")
        public void testOverride() throws Exception {
            runTest("j2k/testData/fileOrElement/function/override.java");
        }

        @TestMetadata("overrideAndOpen.java")
        public void testOverrideAndOpen() throws Exception {
            runTest("j2k/testData/fileOrElement/function/overrideAndOpen.java");
        }

        @TestMetadata("overrideObject.java")
        public void testOverrideObject() throws Exception {
            runTest("j2k/testData/fileOrElement/function/overrideObject.java");
        }

        @TestMetadata("overrideObject2.java")
        public void testOverrideObject2() throws Exception {
            runTest("j2k/testData/fileOrElement/function/overrideObject2.java");
        }

        @TestMetadata("overrideObject3.java")
        public void testOverrideObject3() throws Exception {
            runTest("j2k/testData/fileOrElement/function/overrideObject3.java");
        }

        @TestMetadata("overrideWithHigherVisibility.java")
        public void testOverrideWithHigherVisibility() throws Exception {
            runTest("j2k/testData/fileOrElement/function/overrideWithHigherVisibility.java");
        }

        @TestMetadata("ownGenericParam.java")
        public void testOwnGenericParam() throws Exception {
            runTest("j2k/testData/fileOrElement/function/ownGenericParam.java");
        }

        @TestMetadata("ownSeveralGenericParams.java")
        public void testOwnSeveralGenericParams() throws Exception {
            runTest("j2k/testData/fileOrElement/function/ownSeveralGenericParams.java");
        }

        @TestMetadata("parameterModification.java")
        public void testParameterModification() throws Exception {
            runTest("j2k/testData/fileOrElement/function/parameterModification.java");
        }

        @TestMetadata("private.java")
        public void testPrivate() throws Exception {
            runTest("j2k/testData/fileOrElement/function/private.java");
        }

        @TestMetadata("protected.java")
        public void testProtected() throws Exception {
            runTest("j2k/testData/fileOrElement/function/protected.java");
        }

        @TestMetadata("public.java")
        public void testPublic() throws Exception {
            runTest("j2k/testData/fileOrElement/function/public.java");
        }

        @TestMetadata("synchronizedMethod.java")
        public void testSynchronizedMethod() throws Exception {
            runTest("j2k/testData/fileOrElement/function/synchronizedMethod.java");
        }

        @TestMetadata("throws.java")
        public void testThrows() throws Exception {
            runTest("j2k/testData/fileOrElement/function/throws.java");
        }

        @TestMetadata("varVararg.java")
        public void testVarVararg() throws Exception {
            runTest("j2k/testData/fileOrElement/function/varVararg.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/identifier")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Identifier extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInIdentifier() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/identifier"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("finalFieldReference.java")
        public void testFinalFieldReference() throws Exception {
            runTest("j2k/testData/fileOrElement/identifier/finalFieldReference.java");
        }

        @TestMetadata("keywords.java")
        public void testKeywords() throws Exception {
            runTest("j2k/testData/fileOrElement/identifier/keywords.java");
        }

        @TestMetadata("withDollar.java")
        public void testWithDollar() throws Exception {
            runTest("j2k/testData/fileOrElement/identifier/withDollar.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/ifStatement")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class IfStatement extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInIfStatement() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/ifStatement"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("assignmentAsExpressionInIf.java")
        public void testAssignmentAsExpressionInIf() throws Exception {
            runTest("j2k/testData/fileOrElement/ifStatement/assignmentAsExpressionInIf.java");
        }

        @TestMetadata("elseIf.java")
        public void testElseIf() throws Exception {
            runTest("j2k/testData/fileOrElement/ifStatement/elseIf.java");
        }

        @TestMetadata("ifWithoutThen.java")
        public void testIfWithoutThen() throws Exception {
            runTest("j2k/testData/fileOrElement/ifStatement/ifWithoutThen.java");
        }

        @TestMetadata("multiLine.java")
        public void testMultiLine() throws Exception {
            runTest("j2k/testData/fileOrElement/ifStatement/multiLine.java");
        }

        @TestMetadata("singleLine.java")
        public void testSingleLine() throws Exception {
            runTest("j2k/testData/fileOrElement/ifStatement/singleLine.java");
        }

        @TestMetadata("withBlocks.java")
        public void testWithBlocks() throws Exception {
            runTest("j2k/testData/fileOrElement/ifStatement/withBlocks.java");
        }

        @TestMetadata("withEmptyBlocks.java")
        public void testWithEmptyBlocks() throws Exception {
            runTest("j2k/testData/fileOrElement/ifStatement/withEmptyBlocks.java");
        }

        @TestMetadata("withoutElse.java")
        public void testWithoutElse() throws Exception {
            runTest("j2k/testData/fileOrElement/ifStatement/withoutElse.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/importStatement")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ImportStatement extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInImportStatement() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/importStatement"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("importWithKeywords.java")
        public void testImportWithKeywords() throws Exception {
            runTest("j2k/testData/fileOrElement/importStatement/importWithKeywords.java");
        }

        @TestMetadata("importWithStar.java")
        public void testImportWithStar() throws Exception {
            runTest("j2k/testData/fileOrElement/importStatement/importWithStar.java");
        }

        @TestMetadata("oneImport.java")
        public void testOneImport() throws Exception {
            runTest("j2k/testData/fileOrElement/importStatement/oneImport.java");
        }

        @TestMetadata("onlyImports.java")
        public void testOnlyImports() throws Exception {
            runTest("j2k/testData/fileOrElement/importStatement/onlyImports.java");
        }

        @TestMetadata("simpleImport.java")
        public void testSimpleImport() throws Exception {
            runTest("j2k/testData/fileOrElement/importStatement/simpleImport.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/inheritance")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Inheritance extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInInheritance() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/inheritance"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("classOneExtendsBaseGeneric.java")
        public void testClassOneExtendsBaseGeneric() throws Exception {
            runTest("j2k/testData/fileOrElement/inheritance/classOneExtendsBaseGeneric.java");
        }

        @TestMetadata("classOneExtendsBaseWithOneParam.java")
        public void testClassOneExtendsBaseWithOneParam() throws Exception {
            runTest("j2k/testData/fileOrElement/inheritance/classOneExtendsBaseWithOneParam.java");
        }

        @TestMetadata("classOneExtendsBaseWithZeroParams.java")
        public void testClassOneExtendsBaseWithZeroParams() throws Exception {
            runTest("j2k/testData/fileOrElement/inheritance/classOneExtendsBaseWithZeroParams.java");
        }

        @TestMetadata("classOneExtendsBaseWithZeroParamsNonEmptyConstructor.java")
        public void testClassOneExtendsBaseWithZeroParamsNonEmptyConstructor() throws Exception {
            runTest("j2k/testData/fileOrElement/inheritance/classOneExtendsBaseWithZeroParamsNonEmptyConstructor.java");
        }

        @TestMetadata("openModifier.java")
        public void testOpenModifier() throws Exception {
            runTest("j2k/testData/fileOrElement/inheritance/openModifier.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/isOperator")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class IsOperator extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInIsOperator() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/isOperator"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("complicatedExpression.java")
        public void testComplicatedExpression() throws Exception {
            runTest("j2k/testData/fileOrElement/isOperator/complicatedExpression.java");
        }

        @TestMetadata("rawType.java")
        public void testRawType() throws Exception {
            runTest("j2k/testData/fileOrElement/isOperator/rawType.java");
        }

        @TestMetadata("simpleReference.java")
        public void testSimpleReference() throws Exception {
            runTest("j2k/testData/fileOrElement/isOperator/simpleReference.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/issues")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Issues extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInIssues() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/issues"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("arrayLength.java")
        public void testArrayLength() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/arrayLength.java");
        }

        @TestMetadata("comments.java")
        public void testComments() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/comments.java");
        }

        @TestMetadata("doNotQualifyStatic.java")
        public void testDoNotQualifyStatic() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/doNotQualifyStatic.java");
        }

        @TestMetadata("kt-1016.java")
        public void testKt_1016() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-1016.java");
        }

        @TestMetadata("kt-1048.java")
        public void testKt_1048() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-1048.java");
        }

        @TestMetadata("kt-1074.java")
        public void testKt_1074() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-1074.java");
        }

        @TestMetadata("kt-14248.java")
        public void testKt_14248() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-14248.java");
        }

        @TestMetadata("kt-17379.java")
        public void testKt_17379() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-17379.java");
        }

        @TestMetadata("kt-19634.java")
        public void testKt_19634() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-19634.java");
        }

        @TestMetadata("kt-19943.java")
        public void testKt_19943() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-19943.java");
        }

        @TestMetadata("kt-5294.java")
        public void testKt_5294() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-5294.java");
        }

        @TestMetadata("kt-5400.java")
        public void testKt_5400() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-5400.java");
        }

        @TestMetadata("kt-543.java")
        public void testKt_543() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-543.java");
        }

        @TestMetadata("kt-543-boxed.java")
        public void testKt_543_boxed() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-543-boxed.java");
        }

        @TestMetadata("kt-543-mixed.java")
        public void testKt_543_mixed() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-543-mixed.java");
        }

        @TestMetadata("kt-638.java")
        public void testKt_638() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-638.java");
        }

        @TestMetadata("kt-6790.java")
        public void testKt_6790() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-6790.java");
        }

        @TestMetadata("kt-696.java")
        public void testKt_696() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-696.java");
        }

        @TestMetadata("kt-792.java")
        public void testKt_792() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-792.java");
        }

        @TestMetadata("kt-792-mixed.java")
        public void testKt_792_mixed() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-792-mixed.java");
        }

        @TestMetadata("kt-794.java")
        public void testKt_794() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-794.java");
        }

        @TestMetadata("kt-794-mixed.java")
        public void testKt_794_mixed() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-794-mixed.java");
        }

        @TestMetadata("kt-807.java")
        public void testKt_807() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-807.java");
        }

        @TestMetadata("kt-809.java")
        public void testKt_809() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-809.java");
        }

        @TestMetadata("kt-809-string.java")
        public void testKt_809_string() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-809-string.java");
        }

        @TestMetadata("kt-820.java")
        public void testKt_820() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-820.java");
        }

        @TestMetadata("kt-820-field.java")
        public void testKt_820_field() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-820-field.java");
        }

        @TestMetadata("kt-820-string.java")
        public void testKt_820_string() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-820-string.java");
        }

        @TestMetadata("kt-824.java")
        public void testKt_824() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-824.java");
        }

        @TestMetadata("kt-824-isDir.java")
        public void testKt_824_isDir() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-824-isDir.java");
        }

        @TestMetadata("kt-828.java")
        public void testKt_828() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-828.java");
        }

        @TestMetadata("kt-836.java")
        public void testKt_836() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-836.java");
        }

        @TestMetadata("kt-837.java")
        public void testKt_837() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-837.java");
        }

        @TestMetadata("kt-851.java")
        public void testKt_851() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-851.java");
        }

        @TestMetadata("kt-852.java")
        public void testKt_852() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-852.java");
        }

        @TestMetadata("kt-871.java")
        public void testKt_871() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-871.java");
        }

        @TestMetadata("kt-879.java")
        public void testKt_879() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-879.java");
        }

        @TestMetadata("kt-893.java")
        public void testKt_893() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-893.java");
        }

        @TestMetadata("kt-899.java")
        public void testKt_899() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-899.java");
        }

        @TestMetadata("kt-963.java")
        public void testKt_963() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-963.java");
        }

        @TestMetadata("kt-9997.java")
        public void testKt_9997() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/kt-9997.java");
        }

        @TestMetadata("operationsWithChar.java")
        public void testOperationsWithChar() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/operationsWithChar.java");
        }

        @TestMetadata("qualifyStatic.java")
        public void testQualifyStatic() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/qualifyStatic.java");
        }

        @TestMetadata("spaceBeforeAssignment.java")
        public void testSpaceBeforeAssignment() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/spaceBeforeAssignment.java");
        }

        @TestMetadata("unfinishedReferenceExpression.java")
        public void testUnfinishedReferenceExpression() throws Exception {
            runTest("j2k/testData/fileOrElement/issues/unfinishedReferenceExpression.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/kotlinApiAccess")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class KotlinApiAccess extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInKotlinApiAccess() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/kotlinApiAccess"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("ClassObjectMembers.java")
        public void testClassObjectMembers() throws Exception {
            runTest("j2k/testData/fileOrElement/kotlinApiAccess/ClassObjectMembers.java");
        }

        @TestMetadata("CorrectFunNullabilityDetected.java")
        public void testCorrectFunNullabilityDetected() throws Exception {
            runTest("j2k/testData/fileOrElement/kotlinApiAccess/CorrectFunNullabilityDetected.java");
        }

        @TestMetadata("CorrectNullabilityDetected.java")
        public void testCorrectNullabilityDetected() throws Exception {
            runTest("j2k/testData/fileOrElement/kotlinApiAccess/CorrectNullabilityDetected.java");
        }

        @TestMetadata("ExtensionFunction.java")
        public void testExtensionFunction() throws Exception {
            runTest("j2k/testData/fileOrElement/kotlinApiAccess/ExtensionFunction.java");
        }

        @TestMetadata("ExtensionProperty.java")
        public void testExtensionProperty() throws Exception {
            runTest("j2k/testData/fileOrElement/kotlinApiAccess/ExtensionProperty.java");
        }

        @TestMetadata("GlobalFunction.java")
        public void testGlobalFunction() throws Exception {
            runTest("j2k/testData/fileOrElement/kotlinApiAccess/GlobalFunction.java");
        }

        @TestMetadata("GlobalGenericFunction.java")
        public void testGlobalGenericFunction() throws Exception {
            runTest("j2k/testData/fileOrElement/kotlinApiAccess/GlobalGenericFunction.java");
        }

        @TestMetadata("GlobalValue1.java")
        public void testGlobalValue1() throws Exception {
            runTest("j2k/testData/fileOrElement/kotlinApiAccess/GlobalValue1.java");
        }

        @TestMetadata("GlobalValue2.java")
        public void testGlobalValue2() throws Exception {
            runTest("j2k/testData/fileOrElement/kotlinApiAccess/GlobalValue2.java");
        }

        @TestMetadata("InheritedProperty.java")
        public void testInheritedProperty() throws Exception {
            runTest("j2k/testData/fileOrElement/kotlinApiAccess/InheritedProperty.java");
        }

        @TestMetadata("ObjectMembers.java")
        public void testObjectMembers() throws Exception {
            runTest("j2k/testData/fileOrElement/kotlinApiAccess/ObjectMembers.java");
        }

        @TestMetadata("Property.java")
        public void testProperty() throws Exception {
            runTest("j2k/testData/fileOrElement/kotlinApiAccess/Property.java");
        }

        @TestMetadata("Property2.java")
        public void testProperty2() throws Exception {
            runTest("j2k/testData/fileOrElement/kotlinApiAccess/Property2.java");
        }

        @TestMetadata("StaticImportAllFromFileFacade.java")
        public void testStaticImportAllFromFileFacade() throws Exception {
            runTest("j2k/testData/fileOrElement/kotlinApiAccess/StaticImportAllFromFileFacade.java");
        }

        @TestMetadata("StaticImportAllFromObject.java")
        public void testStaticImportAllFromObject() throws Exception {
            runTest("j2k/testData/fileOrElement/kotlinApiAccess/StaticImportAllFromObject.java");
        }

        @TestMetadata("StaticImportFromCompanionObject.java")
        public void testStaticImportFromCompanionObject() throws Exception {
            runTest("j2k/testData/fileOrElement/kotlinApiAccess/StaticImportFromCompanionObject.java");
        }

        @TestMetadata("StaticImportFromCompanionObject2.java")
        public void testStaticImportFromCompanionObject2() throws Exception {
            runTest("j2k/testData/fileOrElement/kotlinApiAccess/StaticImportFromCompanionObject2.java");
        }

        @TestMetadata("StaticImportFromCompanionObject3.java")
        public void testStaticImportFromCompanionObject3() throws Exception {
            runTest("j2k/testData/fileOrElement/kotlinApiAccess/StaticImportFromCompanionObject3.java");
        }

        @TestMetadata("StaticImportFromFileFacade.java")
        public void testStaticImportFromFileFacade() throws Exception {
            runTest("j2k/testData/fileOrElement/kotlinApiAccess/StaticImportFromFileFacade.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/labelStatement")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class LabelStatement extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInLabelStatement() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/labelStatement"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("complicatedExampleFromJavaTutorial.java")
        public void testComplicatedExampleFromJavaTutorial() throws Exception {
            runTest("j2k/testData/fileOrElement/labelStatement/complicatedExampleFromJavaTutorial.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/list")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class List extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInList() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/list"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("ForEach.java")
        public void testForEach() throws Exception {
            runTest("j2k/testData/fileOrElement/list/ForEach.java");
        }

        @TestMetadata("Lists.java")
        public void testLists() throws Exception {
            runTest("j2k/testData/fileOrElement/list/Lists.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/literalExpression")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class LiteralExpression extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInLiteralExpression() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/literalExpression"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("char.java")
        public void testChar() throws Exception {
            runTest("j2k/testData/fileOrElement/literalExpression/char.java");
        }

        @TestMetadata("charOctal.java")
        public void testCharOctal() throws Exception {
            runTest("j2k/testData/fileOrElement/literalExpression/charOctal.java");
        }

        @TestMetadata("charToNumber.java")
        public void testCharToNumber() throws Exception {
            runTest("j2k/testData/fileOrElement/literalExpression/charToNumber.java");
        }

        @TestMetadata("charToString.java")
        public void testCharToString() throws Exception {
            runTest("j2k/testData/fileOrElement/literalExpression/charToString.java");
        }

        @TestMetadata("dollarInsideString.java")
        public void testDollarInsideString() throws Exception {
            runTest("j2k/testData/fileOrElement/literalExpression/dollarInsideString.java");
        }

        @TestMetadata("double.java")
        public void testDouble() throws Exception {
            runTest("j2k/testData/fileOrElement/literalExpression/double.java");
        }

        @TestMetadata("endsWithDFL.java")
        public void testEndsWithDFL() throws Exception {
            runTest("j2k/testData/fileOrElement/literalExpression/endsWithDFL.java");
        }

        @TestMetadata("exponentDouble.java")
        public void testExponentDouble() throws Exception {
            runTest("j2k/testData/fileOrElement/literalExpression/exponentDouble.java");
        }

        @TestMetadata("exponentFloat.java")
        public void testExponentFloat() throws Exception {
            runTest("j2k/testData/fileOrElement/literalExpression/exponentFloat.java");
        }

        @TestMetadata("float.java")
        public void testFloat() throws Exception {
            runTest("j2k/testData/fileOrElement/literalExpression/float.java");
        }

        @TestMetadata("hex.java")
        public void testHex() throws Exception {
            runTest("j2k/testData/fileOrElement/literalExpression/hex.java");
        }

        @TestMetadata("long.java")
        public void testLong() throws Exception {
            runTest("j2k/testData/fileOrElement/literalExpression/long.java");
        }

        @TestMetadata("octal.java")
        public void testOctal() throws Exception {
            runTest("j2k/testData/fileOrElement/literalExpression/octal.java");
        }

        @TestMetadata("stringOctalChars.java")
        public void testStringOctalChars() throws Exception {
            runTest("j2k/testData/fileOrElement/literalExpression/stringOctalChars.java");
        }

        @TestMetadata("trueOrFalse.java")
        public void testTrueOrFalse() throws Exception {
            runTest("j2k/testData/fileOrElement/literalExpression/trueOrFalse.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/localVariable")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class LocalVariable extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInLocalVariable() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/localVariable"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("autoBangBang.java")
        public void testAutoBangBang() throws Exception {
            runTest("j2k/testData/fileOrElement/localVariable/autoBangBang.java");
        }

        @TestMetadata("conversion.java")
        public void testConversion() throws Exception {
            runTest("j2k/testData/fileOrElement/localVariable/conversion.java");
        }

        @TestMetadata("literalConversion.java")
        public void testLiteralConversion() throws Exception {
            runTest("j2k/testData/fileOrElement/localVariable/literalConversion.java");
        }

        @TestMetadata("nullIInitializer.java")
        public void testNullIInitializer() throws Exception {
            runTest("j2k/testData/fileOrElement/localVariable/nullIInitializer.java");
        }

        @TestMetadata("object.java")
        public void testObject() throws Exception {
            runTest("j2k/testData/fileOrElement/localVariable/object.java");
        }

        @TestMetadata("unboxing.java")
        public void testUnboxing() throws Exception {
            runTest("j2k/testData/fileOrElement/localVariable/unboxing.java");
        }

        @TestMetadata("valTypeDoNotMatch.java")
        public void testValTypeDoNotMatch() throws Exception {
            runTest("j2k/testData/fileOrElement/localVariable/valTypeDoNotMatch.java");
        }

        @TestMetadata("varTypeDoNotMatch.java")
        public void testVarTypeDoNotMatch() throws Exception {
            runTest("j2k/testData/fileOrElement/localVariable/varTypeDoNotMatch.java");
        }

        @TestMetadata("varWithNoInitializer.java")
        public void testVarWithNoInitializer() throws Exception {
            runTest("j2k/testData/fileOrElement/localVariable/varWithNoInitializer.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/methodCallExpression")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MethodCallExpression extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInMethodCallExpression() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/methodCallExpression"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("callWithKeywords.java")
        public void testCallWithKeywords() throws Exception {
            runTest("j2k/testData/fileOrElement/methodCallExpression/callWithKeywords.java");
        }

        @TestMetadata("collectionsMethods.java")
        public void testCollectionsMethods() throws Exception {
            runTest("j2k/testData/fileOrElement/methodCallExpression/collectionsMethods.java");
        }

        @TestMetadata("collectionsMethods2.java")
        public void testCollectionsMethods2() throws Exception {
            runTest("j2k/testData/fileOrElement/methodCallExpression/collectionsMethods2.java");
        }

        @TestMetadata("emptyCall.java")
        public void testEmptyCall() throws Exception {
            runTest("j2k/testData/fileOrElement/methodCallExpression/emptyCall.java");
        }

        @TestMetadata("genericMethod.java")
        public void testGenericMethod() throws Exception {
            runTest("j2k/testData/fileOrElement/methodCallExpression/genericMethod.java");
        }

        @TestMetadata("getClass.java")
        public void testGetClass() throws Exception {
            runTest("j2k/testData/fileOrElement/methodCallExpression/getClass.java");
        }

        @TestMetadata("parameterToReceiver.java")
        public void testParameterToReceiver() throws Exception {
            runTest("j2k/testData/fileOrElement/methodCallExpression/parameterToReceiver.java");
        }

        @TestMetadata("simpleCall.java")
        public void testSimpleCall() throws Exception {
            runTest("j2k/testData/fileOrElement/methodCallExpression/simpleCall.java");
        }

        @TestMetadata("specialBuiltinMembers.java")
        public void testSpecialBuiltinMembers() throws Exception {
            runTest("j2k/testData/fileOrElement/methodCallExpression/specialBuiltinMembers.java");
        }

        @TestMetadata("stringMethods.java")
        public void testStringMethods() throws Exception {
            runTest("j2k/testData/fileOrElement/methodCallExpression/stringMethods.java");
        }

        @TestMetadata("systemOut.java")
        public void testSystemOut() throws Exception {
            runTest("j2k/testData/fileOrElement/methodCallExpression/systemOut.java");
        }

        @TestMetadata("vararg1.java")
        public void testVararg1() throws Exception {
            runTest("j2k/testData/fileOrElement/methodCallExpression/vararg1.java");
        }

        @TestMetadata("vararg2.java")
        public void testVararg2() throws Exception {
            runTest("j2k/testData/fileOrElement/methodCallExpression/vararg2.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/misc")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Misc extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInMisc() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/misc"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("packageWithClass.java")
        public void testPackageWithClass() throws Exception {
            runTest("j2k/testData/fileOrElement/misc/packageWithClass.java");
        }

        @TestMetadata("packageWithClasses.java")
        public void testPackageWithClasses() throws Exception {
            runTest("j2k/testData/fileOrElement/misc/packageWithClasses.java");
        }

        @TestMetadata("packageWithImports.java")
        public void testPackageWithImports() throws Exception {
            runTest("j2k/testData/fileOrElement/misc/packageWithImports.java");
        }

        @TestMetadata("packageWithMixedImports.java")
        public void testPackageWithMixedImports() throws Exception {
            runTest("j2k/testData/fileOrElement/misc/packageWithMixedImports.java");
        }

        @TestMetadata("packageWithOpenClass.java")
        public void testPackageWithOpenClass() throws Exception {
            runTest("j2k/testData/fileOrElement/misc/packageWithOpenClass.java");
        }

        @TestMetadata("packageWithStaticImports.java")
        public void testPackageWithStaticImports() throws Exception {
            runTest("j2k/testData/fileOrElement/misc/packageWithStaticImports.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/mutableCollections")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MutableCollections extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInMutableCollections() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/mutableCollections"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("FunctionParameters.java")
        public void testFunctionParameters() throws Exception {
            runTest("j2k/testData/fileOrElement/mutableCollections/FunctionParameters.java");
        }

        @TestMetadata("FunctionParameters2.java")
        public void testFunctionParameters2() throws Exception {
            runTest("j2k/testData/fileOrElement/mutableCollections/FunctionParameters2.java");
        }

        @TestMetadata("FunctionReturnValue.java")
        public void testFunctionReturnValue() throws Exception {
            runTest("j2k/testData/fileOrElement/mutableCollections/FunctionReturnValue.java");
        }

        @TestMetadata("FunctionReturnValue2.java")
        public void testFunctionReturnValue2() throws Exception {
            runTest("j2k/testData/fileOrElement/mutableCollections/FunctionReturnValue2.java");
        }

        @TestMetadata("Iterator.java")
        public void testIterator() throws Exception {
            runTest("j2k/testData/fileOrElement/mutableCollections/Iterator.java");
        }

        @TestMetadata("Iterator2.java")
        public void testIterator2() throws Exception {
            runTest("j2k/testData/fileOrElement/mutableCollections/Iterator2.java");
        }

        @TestMetadata("Overrides.java")
        public void testOverrides() throws Exception {
            runTest("j2k/testData/fileOrElement/mutableCollections/Overrides.java");
        }

        @TestMetadata("Recursion.java")
        public void testRecursion() throws Exception {
            runTest("j2k/testData/fileOrElement/mutableCollections/Recursion.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/newClassExpression")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class NewClassExpression extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInNewClassExpression() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/newClassExpression"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("classWithParam.java")
        public void testClassWithParam() throws Exception {
            runTest("j2k/testData/fileOrElement/newClassExpression/classWithParam.java");
        }

        @TestMetadata("classWithParams.java")
        public void testClassWithParams() throws Exception {
            runTest("j2k/testData/fileOrElement/newClassExpression/classWithParams.java");
        }

        @TestMetadata("classWithoutBody.java")
        public void testClassWithoutBody() throws Exception {
            runTest("j2k/testData/fileOrElement/newClassExpression/classWithoutBody.java");
        }

        @TestMetadata("fullQualifiedName.java")
        public void testFullQualifiedName() throws Exception {
            runTest("j2k/testData/fileOrElement/newClassExpression/fullQualifiedName.java");
        }

        @TestMetadata("fullQualifiedName2.java")
        public void testFullQualifiedName2() throws Exception {
            runTest("j2k/testData/fileOrElement/newClassExpression/fullQualifiedName2.java");
        }

        @TestMetadata("genericClassInvocation.java")
        public void testGenericClassInvocation() throws Exception {
            runTest("j2k/testData/fileOrElement/newClassExpression/genericClassInvocation.java");
        }

        @TestMetadata("javaLangObject.java")
        public void testJavaLangObject() throws Exception {
            runTest("j2k/testData/fileOrElement/newClassExpression/javaLangObject.java");
        }

        @TestMetadata("lineBreaks.java")
        public void testLineBreaks() throws Exception {
            runTest("j2k/testData/fileOrElement/newClassExpression/lineBreaks.java");
        }

        @TestMetadata("newAnonymousClass.java")
        public void testNewAnonymousClass() throws Exception {
            runTest("j2k/testData/fileOrElement/newClassExpression/newAnonymousClass.java");
        }

        @TestMetadata("newAnonymousClass2.java")
        public void testNewAnonymousClass2() throws Exception {
            runTest("j2k/testData/fileOrElement/newClassExpression/newAnonymousClass2.java");
        }

        @TestMetadata("newAnonymousClass3.java")
        public void testNewAnonymousClass3() throws Exception {
            runTest("j2k/testData/fileOrElement/newClassExpression/newAnonymousClass3.java");
        }

        @TestMetadata("newClassByFullName.java")
        public void testNewClassByFullName() throws Exception {
            runTest("j2k/testData/fileOrElement/newClassExpression/newClassByFullName.java");
        }

        @TestMetadata("newInnerClass.java")
        public void testNewInnerClass() throws Exception {
            runTest("j2k/testData/fileOrElement/newClassExpression/newInnerClass.java");
        }

        @TestMetadata("newListAndNewMember.java")
        public void testNewListAndNewMember() throws Exception {
            runTest("j2k/testData/fileOrElement/newClassExpression/newListAndNewMember.java");
        }

        @TestMetadata("newStaticInnerClass.java")
        public void testNewStaticInnerClass() throws Exception {
            runTest("j2k/testData/fileOrElement/newClassExpression/newStaticInnerClass.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/nullability")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Nullability extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInNullability() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/nullability"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("autoNotNull.java")
        public void testAutoNotNull() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/autoNotNull.java");
        }

        @TestMetadata("FieldAssignedWithNull.java")
        public void testFieldAssignedWithNull() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/FieldAssignedWithNull.java");
        }

        @TestMetadata("FieldComparedWithNull.java")
        public void testFieldComparedWithNull() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/FieldComparedWithNull.java");
        }

        @TestMetadata("FieldComparedWithNull2.java")
        public void testFieldComparedWithNull2() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/FieldComparedWithNull2.java");
        }

        @TestMetadata("FieldComparedWithNull3.java")
        public void testFieldComparedWithNull3() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/FieldComparedWithNull3.java");
        }

        @TestMetadata("FieldComparedWithNull4.java")
        public void testFieldComparedWithNull4() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/FieldComparedWithNull4.java");
        }

        @TestMetadata("FieldInitializedWithNull.java")
        public void testFieldInitializedWithNull() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/FieldInitializedWithNull.java");
        }

        @TestMetadata("IndirectOverride.java")
        public void testIndirectOverride() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/IndirectOverride.java");
        }

        @TestMetadata("LocalValReassignment.java")
        public void testLocalValReassignment() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/LocalValReassignment.java");
        }

        @TestMetadata("MethodInvokedWithNullArg.java")
        public void testMethodInvokedWithNullArg() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/MethodInvokedWithNullArg.java");
        }

        @TestMetadata("MethodInvokedWithNullArg2.java")
        public void testMethodInvokedWithNullArg2() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/MethodInvokedWithNullArg2.java");
        }

        @TestMetadata("MethodInvokedWithTernaryNullArg.java")
        public void testMethodInvokedWithTernaryNullArg() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/MethodInvokedWithTernaryNullArg.java");
        }

        @TestMetadata("MethodResultComparedWithNull.java")
        public void testMethodResultComparedWithNull() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/MethodResultComparedWithNull.java");
        }

        @TestMetadata("MethodResultComparedWithNull2.java")
        public void testMethodResultComparedWithNull2() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/MethodResultComparedWithNull2.java");
        }

        @TestMetadata("MethodResultComparedWithNull3.java")
        public void testMethodResultComparedWithNull3() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/MethodResultComparedWithNull3.java");
        }

        @TestMetadata("MethodResultComparedWithNull4.java")
        public void testMethodResultComparedWithNull4() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/MethodResultComparedWithNull4.java");
        }

        @TestMetadata("MethodResultInitializesNullableField.java")
        public void testMethodResultInitializesNullableField() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/MethodResultInitializesNullableField.java");
        }

        @TestMetadata("MethodReturnsNull.java")
        public void testMethodReturnsNull() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/MethodReturnsNull.java");
        }

        @TestMetadata("MethodReturnsNullInAnonymousClass.java")
        public void testMethodReturnsNullInAnonymousClass() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/MethodReturnsNullInAnonymousClass.java");
        }

        @TestMetadata("MethodReturnsNullInLocalClass.java")
        public void testMethodReturnsNullInLocalClass() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/MethodReturnsNullInLocalClass.java");
        }

        @TestMetadata("MethodReturnsTernaryNull.java")
        public void testMethodReturnsTernaryNull() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/MethodReturnsTernaryNull.java");
        }

        @TestMetadata("notNullCast.java")
        public void testNotNullCast() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/notNullCast.java");
        }

        @TestMetadata("nullableField.java")
        public void testNullableField() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/nullableField.java");
        }

        @TestMetadata("nullableInitializer1.java")
        public void testNullableInitializer1() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/nullableInitializer1.java");
        }

        @TestMetadata("nullableInitializer2.java")
        public void testNullableInitializer2() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/nullableInitializer2.java");
        }

        @TestMetadata("nullableInitializer3.java")
        public void testNullableInitializer3() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/nullableInitializer3.java");
        }

        @TestMetadata("nullableInitializer4.java")
        public void testNullableInitializer4() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/nullableInitializer4.java");
        }

        @TestMetadata("NullableIntNoCrash.java")
        public void testNullableIntNoCrash() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/NullableIntNoCrash.java");
        }

        @TestMetadata("NullableMethodDotAccess.java")
        public void testNullableMethodDotAccess() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/NullableMethodDotAccess.java");
        }

        @TestMetadata("NullableVariableDotAccess.java")
        public void testNullableVariableDotAccess() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/NullableVariableDotAccess.java");
        }

        @TestMetadata("OverrideWithInheritanceLoop.java")
        public void testOverrideWithInheritanceLoop() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/OverrideWithInheritanceLoop.java");
        }

        @TestMetadata("Overrides.java")
        public void testOverrides() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/Overrides.java");
        }

        @TestMetadata("ParameterComparedWithNull.java")
        public void testParameterComparedWithNull() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/ParameterComparedWithNull.java");
        }

        @TestMetadata("VariableAssignedWithNull.java")
        public void testVariableAssignedWithNull() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/VariableAssignedWithNull.java");
        }

        @TestMetadata("VariableComparedWithNull.java")
        public void testVariableComparedWithNull() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/VariableComparedWithNull.java");
        }

        @TestMetadata("VariableInitializedWithNull.java")
        public void testVariableInitializedWithNull() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/VariableInitializedWithNull.java");
        }

        @TestMetadata("VariableInitializedWithTernaryNull.java")
        public void testVariableInitializedWithTernaryNull() throws Exception {
            runTest("j2k/testData/fileOrElement/nullability/VariableInitializedWithTernaryNull.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/objectLiteral")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ObjectLiteral extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInObjectLiteral() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/objectLiteral"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("MyFrame.java")
        public void testMyFrame() throws Exception {
            runTest("j2k/testData/fileOrElement/objectLiteral/MyFrame.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/overloads")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Overloads extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("Abstract.java")
        public void testAbstract() throws Exception {
            runTest("j2k/testData/fileOrElement/overloads/Abstract.java");
        }

        @TestMetadata("AccessorToDrop.java")
        public void testAccessorToDrop() throws Exception {
            runTest("j2k/testData/fileOrElement/overloads/AccessorToDrop.java");
        }

        public void testAllFilesPresentInOverloads() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/overloads"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("Annotations.java")
        public void testAnnotations() throws Exception {
            runTest("j2k/testData/fileOrElement/overloads/Annotations.java");
        }

        @TestMetadata("Override.java")
        public void testOverride() throws Exception {
            runTest("j2k/testData/fileOrElement/overloads/Override.java");
        }

        @TestMetadata("Private.java")
        public void testPrivate() throws Exception {
            runTest("j2k/testData/fileOrElement/overloads/Private.java");
        }

        @TestMetadata("Simple.java")
        public void testSimple() throws Exception {
            runTest("j2k/testData/fileOrElement/overloads/Simple.java");
        }

        @TestMetadata("Synchronized.java")
        public void testSynchronized() throws Exception {
            runTest("j2k/testData/fileOrElement/overloads/Synchronized.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/packageStatement")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class PackageStatement extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInPackageStatement() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/packageStatement"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("keywordInPackageName.java")
        public void testKeywordInPackageName() throws Exception {
            runTest("j2k/testData/fileOrElement/packageStatement/keywordInPackageName.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/parenthesizedExpression")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ParenthesizedExpression extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInParenthesizedExpression() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/parenthesizedExpression"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("parenthesized.java")
        public void testParenthesized() throws Exception {
            runTest("j2k/testData/fileOrElement/parenthesizedExpression/parenthesized.java");
        }

        @TestMetadata("parenthesized2.java")
        public void testParenthesized2() throws Exception {
            runTest("j2k/testData/fileOrElement/parenthesizedExpression/parenthesized2.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/polyadicExpression")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class PolyadicExpression extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInPolyadicExpression() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/polyadicExpression"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("divide.java")
        public void testDivide() throws Exception {
            runTest("j2k/testData/fileOrElement/polyadicExpression/divide.java");
        }

        @TestMetadata("minus.java")
        public void testMinus() throws Exception {
            runTest("j2k/testData/fileOrElement/polyadicExpression/minus.java");
        }

        @TestMetadata("multiply.java")
        public void testMultiply() throws Exception {
            runTest("j2k/testData/fileOrElement/polyadicExpression/multiply.java");
        }

        @TestMetadata("plus.java")
        public void testPlus() throws Exception {
            runTest("j2k/testData/fileOrElement/polyadicExpression/plus.java");
        }

        @TestMetadata("remainder.java")
        public void testRemainder() throws Exception {
            runTest("j2k/testData/fileOrElement/polyadicExpression/remainder.java");
        }

        @TestMetadata("unassignedShiftRight.java")
        public void testUnassignedShiftRight() throws Exception {
            runTest("j2k/testData/fileOrElement/polyadicExpression/unassignedShiftRight.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/postProcessing")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class PostProcessing extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInPostProcessing() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/postProcessing"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("AnonymousObject.java")
        public void testAnonymousObject() throws Exception {
            runTest("j2k/testData/fileOrElement/postProcessing/AnonymousObject.java");
        }

        @TestMetadata("GetOperator.java")
        public void testGetOperator() throws Exception {
            runTest("j2k/testData/fileOrElement/postProcessing/GetOperator.java");
        }

        @TestMetadata("IfNullReturnToElvis.java")
        public void testIfNullReturnToElvis() throws Exception {
            runTest("j2k/testData/fileOrElement/postProcessing/IfNullReturnToElvis.java");
        }

        @TestMetadata("IfToElvis.java")
        public void testIfToElvis() throws Exception {
            runTest("j2k/testData/fileOrElement/postProcessing/IfToElvis.java");
        }

        @TestMetadata("IfToSafeCall.java")
        public void testIfToSafeCall() throws Exception {
            runTest("j2k/testData/fileOrElement/postProcessing/IfToSafeCall.java");
        }

        @TestMetadata("java8MapForEachWithFullJdk.java")
        public void testJava8MapForEachWithFullJdk() throws Exception {
            runTest("j2k/testData/fileOrElement/postProcessing/java8MapForEachWithFullJdk.java");
        }

        @TestMetadata("NotIs.java")
        public void testNotIs() throws Exception {
            runTest("j2k/testData/fileOrElement/postProcessing/NotIs.java");
        }

        @TestMetadata("RedundantTypeCast.java")
        public void testRedundantTypeCast() throws Exception {
            runTest("j2k/testData/fileOrElement/postProcessing/RedundantTypeCast.java");
        }

        @TestMetadata("RedundantTypeCastAndInline.java")
        public void testRedundantTypeCastAndInline() throws Exception {
            runTest("j2k/testData/fileOrElement/postProcessing/RedundantTypeCastAndInline.java");
        }

        @TestMetadata("RedunduntTypeCastAndProhibitedInline.java")
        public void testRedunduntTypeCastAndProhibitedInline() throws Exception {
            runTest("j2k/testData/fileOrElement/postProcessing/RedunduntTypeCastAndProhibitedInline.java");
        }

        @TestMetadata("SyntheticExtensionPropertyAccess.java")
        public void testSyntheticExtensionPropertyAccess() throws Exception {
            runTest("j2k/testData/fileOrElement/postProcessing/SyntheticExtensionPropertyAccess.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/postfixOperator")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class PostfixOperator extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInPostfixOperator() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/postfixOperator"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("decrement.java")
        public void testDecrement() throws Exception {
            runTest("j2k/testData/fileOrElement/postfixOperator/decrement.java");
        }

        @TestMetadata("increment.java")
        public void testIncrement() throws Exception {
            runTest("j2k/testData/fileOrElement/postfixOperator/increment.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/prefixOperator")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class PrefixOperator extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInPrefixOperator() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/prefixOperator"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("decrement.java")
        public void testDecrement() throws Exception {
            runTest("j2k/testData/fileOrElement/prefixOperator/decrement.java");
        }

        @TestMetadata("excl.java")
        public void testExcl() throws Exception {
            runTest("j2k/testData/fileOrElement/prefixOperator/excl.java");
        }

        @TestMetadata("increment.java")
        public void testIncrement() throws Exception {
            runTest("j2k/testData/fileOrElement/prefixOperator/increment.java");
        }

        @TestMetadata("kt-667.java")
        public void testKt_667() throws Exception {
            runTest("j2k/testData/fileOrElement/prefixOperator/kt-667.java");
        }

        @TestMetadata("nullableIf.java")
        public void testNullableIf() throws Exception {
            runTest("j2k/testData/fileOrElement/prefixOperator/nullableIf.java");
        }

        @TestMetadata("tilde.java")
        public void testTilde() throws Exception {
            runTest("j2k/testData/fileOrElement/prefixOperator/tilde.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/projections")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Projections extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInProjections() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/projections"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("projections.java")
        public void testProjections() throws Exception {
            runTest("j2k/testData/fileOrElement/projections/projections.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/protected")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Protected extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInProtected() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/protected"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("constructorProperty.java")
        public void testConstructorProperty() throws Exception {
            runTest("j2k/testData/fileOrElement/protected/constructorProperty.java");
        }

        @TestMetadata("inheritorsSamePackage.java")
        public void testInheritorsSamePackage() throws Exception {
            runTest("j2k/testData/fileOrElement/protected/inheritorsSamePackage.java");
        }

        @TestMetadata("onlyProtectedConstructor.java")
        public void testOnlyProtectedConstructor() throws Exception {
            runTest("j2k/testData/fileOrElement/protected/onlyProtectedConstructor.java");
        }

        @TestMetadata("protectedInSamePackage.java")
        public void testProtectedInSamePackage() throws Exception {
            runTest("j2k/testData/fileOrElement/protected/protectedInSamePackage.java");
        }

        @TestMetadata("severalInheritors.java")
        public void testSeveralInheritors() throws Exception {
            runTest("j2k/testData/fileOrElement/protected/severalInheritors.java");
        }

        @TestMetadata("superInSamePackage.java")
        public void testSuperInSamePackage() throws Exception {
            runTest("j2k/testData/fileOrElement/protected/superInSamePackage.java");
        }

        @TestMetadata("usages.java")
        public void testUsages() throws Exception {
            runTest("j2k/testData/fileOrElement/protected/usages.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/rawGenerics")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RawGenerics extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRawGenerics() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/rawGenerics"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("kt-540.java")
        public void testKt_540() throws Exception {
            runTest("j2k/testData/fileOrElement/rawGenerics/kt-540.java");
        }

        @TestMetadata("kt-540-map.java")
        public void testKt_540_map() throws Exception {
            runTest("j2k/testData/fileOrElement/rawGenerics/kt-540-map.java");
        }

        @TestMetadata("kt-540-rawGenericClass.java")
        public void testKt_540_rawGenericClass() throws Exception {
            runTest("j2k/testData/fileOrElement/rawGenerics/kt-540-rawGenericClass.java");
        }

        @TestMetadata("rawGenericMethod.java")
        public void testRawGenericMethod() throws Exception {
            runTest("j2k/testData/fileOrElement/rawGenerics/rawGenericMethod.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/returnStatement")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReturnStatement extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInReturnStatement() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/returnStatement"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("currentMethodBug.java")
        public void testCurrentMethodBug() throws Exception {
            runTest("j2k/testData/fileOrElement/returnStatement/currentMethodBug.java");
        }

        @TestMetadata("returnChar.java")
        public void testReturnChar() throws Exception {
            runTest("j2k/testData/fileOrElement/returnStatement/returnChar.java");
        }

        @TestMetadata("returnLiteral.java")
        public void testReturnLiteral() throws Exception {
            runTest("j2k/testData/fileOrElement/returnStatement/returnLiteral.java");
        }

        @TestMetadata("returnNumber.java")
        public void testReturnNumber() throws Exception {
            runTest("j2k/testData/fileOrElement/returnStatement/returnNumber.java");
        }

        @TestMetadata("returnString.java")
        public void testReturnString() throws Exception {
            runTest("j2k/testData/fileOrElement/returnStatement/returnString.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/settings")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Settings extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInSettings() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/settings"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("openByDefault.java")
        public void testOpenByDefault() throws Exception {
            runTest("j2k/testData/fileOrElement/settings/openByDefault.java");
        }

        @TestMetadata("specifyFieldTypeByDefault.java")
        public void testSpecifyFieldTypeByDefault() throws Exception {
            runTest("j2k/testData/fileOrElement/settings/specifyFieldTypeByDefault.java");
        }

        @TestMetadata("specifyLocalVariableTypeByDefault.java")
        public void testSpecifyLocalVariableTypeByDefault() throws Exception {
            runTest("j2k/testData/fileOrElement/settings/specifyLocalVariableTypeByDefault.java");
        }

        @TestMetadata("specifyLocalVariableTypeByDefaultInFor.java")
        public void testSpecifyLocalVariableTypeByDefaultInFor() throws Exception {
            runTest("j2k/testData/fileOrElement/settings/specifyLocalVariableTypeByDefaultInFor.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/staticMembers")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class StaticMembers extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInStaticMembers() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/staticMembers"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("PrivateStaticMembers.java")
        public void testPrivateStaticMembers() throws Exception {
            runTest("j2k/testData/fileOrElement/staticMembers/PrivateStaticMembers.java");
        }

        @TestMetadata("PrivateStaticMethods1.java")
        public void testPrivateStaticMethods1() throws Exception {
            runTest("j2k/testData/fileOrElement/staticMembers/PrivateStaticMethods1.java");
        }

        @TestMetadata("PrivateStaticMethods2.java")
        public void testPrivateStaticMethods2() throws Exception {
            runTest("j2k/testData/fileOrElement/staticMembers/PrivateStaticMethods2.java");
        }

        @TestMetadata("PrivateStaticMethods3.java")
        public void testPrivateStaticMethods3() throws Exception {
            runTest("j2k/testData/fileOrElement/staticMembers/PrivateStaticMethods3.java");
        }

        @TestMetadata("PrivateStaticMethods4.java")
        public void testPrivateStaticMethods4() throws Exception {
            runTest("j2k/testData/fileOrElement/staticMembers/PrivateStaticMethods4.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/strings")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Strings extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInStrings() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/strings"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("escapedBackslash.java")
        public void testEscapedBackslash() throws Exception {
            runTest("j2k/testData/fileOrElement/strings/escapedBackslash.java");
        }

        @TestMetadata("escapedDollar.java")
        public void testEscapedDollar() throws Exception {
            runTest("j2k/testData/fileOrElement/strings/escapedDollar.java");
        }

        @TestMetadata("formattedString.java")
        public void testFormattedString() throws Exception {
            runTest("j2k/testData/fileOrElement/strings/formattedString.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/superExpression")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SuperExpression extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInSuperExpression() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/superExpression"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("classAdotSuperFoo.java")
        public void testClassAdotSuperFoo() throws Exception {
            runTest("j2k/testData/fileOrElement/superExpression/classAdotSuperFoo.java");
        }

        @TestMetadata("classAextendsB.java")
        public void testClassAextendsB() throws Exception {
            runTest("j2k/testData/fileOrElement/superExpression/classAextendsB.java");
        }

        @TestMetadata("superStatement.java")
        public void testSuperStatement() throws Exception {
            runTest("j2k/testData/fileOrElement/superExpression/superStatement.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/switch")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Switch extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInSwitch() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/switch"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("caseWithBlock.java")
        public void testCaseWithBlock() throws Exception {
            runTest("j2k/testData/fileOrElement/switch/caseWithBlock.java");
        }

        @TestMetadata("comlicatedFallDown.java")
        public void testComlicatedFallDown() throws Exception {
            runTest("j2k/testData/fileOrElement/switch/comlicatedFallDown.java");
        }

        @TestMetadata("continueAndBreakWithLabel.java")
        public void testContinueAndBreakWithLabel() throws Exception {
            runTest("j2k/testData/fileOrElement/switch/continueAndBreakWithLabel.java");
        }

        @TestMetadata("emptySwitch.java")
        public void testEmptySwitch() throws Exception {
            runTest("j2k/testData/fileOrElement/switch/emptySwitch.java");
        }

        @TestMetadata("enumConstants.java")
        public void testEnumConstants() throws Exception {
            runTest("j2k/testData/fileOrElement/switch/enumConstants.java");
        }

        @TestMetadata("fallDown.java")
        public void testFallDown() throws Exception {
            runTest("j2k/testData/fileOrElement/switch/fallDown.java");
        }

        @TestMetadata("fallDownWithBlocks.java")
        public void testFallDownWithBlocks() throws Exception {
            runTest("j2k/testData/fileOrElement/switch/fallDownWithBlocks.java");
        }

        @TestMetadata("invalidSwitch.java")
        public void testInvalidSwitch() throws Exception {
            runTest("j2k/testData/fileOrElement/switch/invalidSwitch.java");
        }

        @TestMetadata("KT-13552.java")
        public void testKT_13552() throws Exception {
            runTest("j2k/testData/fileOrElement/switch/KT-13552.java");
        }

        @TestMetadata("kt-539.java")
        public void testKt_539() throws Exception {
            runTest("j2k/testData/fileOrElement/switch/kt-539.java");
        }

        @TestMetadata("nestedIf.java")
        public void testNestedIf() throws Exception {
            runTest("j2k/testData/fileOrElement/switch/nestedIf.java");
        }

        @TestMetadata("nestedIfFallback.java")
        public void testNestedIfFallback() throws Exception {
            runTest("j2k/testData/fileOrElement/switch/nestedIfFallback.java");
        }

        @TestMetadata("nestedSwitch.java")
        public void testNestedSwitch() throws Exception {
            runTest("j2k/testData/fileOrElement/switch/nestedSwitch.java");
        }

        @TestMetadata("nestedSwitchFallback.java")
        public void testNestedSwitchFallback() throws Exception {
            runTest("j2k/testData/fileOrElement/switch/nestedSwitchFallback.java");
        }

        @TestMetadata("nondefault.java")
        public void testNondefault() throws Exception {
            runTest("j2k/testData/fileOrElement/switch/nondefault.java");
        }

        @TestMetadata("returnsAndThrows.java")
        public void testReturnsAndThrows() throws Exception {
            runTest("j2k/testData/fileOrElement/switch/returnsAndThrows.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/synchronizedStatement")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SynchronizedStatement extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInSynchronizedStatement() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/synchronizedStatement"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("singleLineExample.java")
        public void testSingleLineExample() throws Exception {
            runTest("j2k/testData/fileOrElement/synchronizedStatement/singleLineExample.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/thisExpression")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ThisExpression extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInThisExpression() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/thisExpression"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("classAdotThisFoo.java")
        public void testClassAdotThisFoo() throws Exception {
            runTest("j2k/testData/fileOrElement/thisExpression/classAdotThisFoo.java");
        }

        @TestMetadata("thisStatement.java")
        public void testThisStatement() throws Exception {
            runTest("j2k/testData/fileOrElement/thisExpression/thisStatement.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/throwStatement")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ThrowStatement extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInThrowStatement() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/throwStatement"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("simpleThrowStatement.java")
        public void testSimpleThrowStatement() throws Exception {
            runTest("j2k/testData/fileOrElement/throwStatement/simpleThrowStatement.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/toArray")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ToArray extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInToArray() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/toArray"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("toArray.java")
        public void testToArray() throws Exception {
            runTest("j2k/testData/fileOrElement/toArray/toArray.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/toKotlinClasses")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ToKotlinClasses extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInToKotlinClasses() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/toKotlinClasses"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("iterableAndIterator.java")
        public void testIterableAndIterator() throws Exception {
            runTest("j2k/testData/fileOrElement/toKotlinClasses/iterableAndIterator.java");
        }

        @TestMetadata("iterableAndIterator2.java")
        public void testIterableAndIterator2() throws Exception {
            runTest("j2k/testData/fileOrElement/toKotlinClasses/iterableAndIterator2.java");
        }

        @TestMetadata("iterableAndIterator3.java")
        public void testIterableAndIterator3() throws Exception {
            runTest("j2k/testData/fileOrElement/toKotlinClasses/iterableAndIterator3.java");
        }

        @TestMetadata("LibraryFunctions.java")
        public void testLibraryFunctions() throws Exception {
            runTest("j2k/testData/fileOrElement/toKotlinClasses/LibraryFunctions.java");
        }

        @TestMetadata("TypeParameterBound.java")
        public void testTypeParameterBound() throws Exception {
            runTest("j2k/testData/fileOrElement/toKotlinClasses/TypeParameterBound.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/trait")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Trait extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("abstactInterface.java")
        public void testAbstactInterface() throws Exception {
            runTest("j2k/testData/fileOrElement/trait/abstactInterface.java");
        }

        public void testAllFilesPresentInTrait() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/trait"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("emptyInterface.java")
        public void testEmptyInterface() throws Exception {
            runTest("j2k/testData/fileOrElement/trait/emptyInterface.java");
        }

        @TestMetadata("extendsOneClassAndImplementsSeveralInterfaces.java")
        public void testExtendsOneClassAndImplementsSeveralInterfaces() throws Exception {
            runTest("j2k/testData/fileOrElement/trait/extendsOneClassAndImplementsSeveralInterfaces.java");
        }

        @TestMetadata("extendsOneInterface.java")
        public void testExtendsOneInterface() throws Exception {
            runTest("j2k/testData/fileOrElement/trait/extendsOneInterface.java");
        }

        @TestMetadata("interfaceWithFields.java")
        public void testInterfaceWithFields() throws Exception {
            runTest("j2k/testData/fileOrElement/trait/interfaceWithFields.java");
        }

        @TestMetadata("interfaceWithMethodDeclaration.java")
        public void testInterfaceWithMethodDeclaration() throws Exception {
            runTest("j2k/testData/fileOrElement/trait/interfaceWithMethodDeclaration.java");
        }

        @TestMetadata("interfaceWithStaticFields.java")
        public void testInterfaceWithStaticFields() throws Exception {
            runTest("j2k/testData/fileOrElement/trait/interfaceWithStaticFields.java");
        }

        @TestMetadata("internalInterface.java")
        public void testInternalInterface() throws Exception {
            runTest("j2k/testData/fileOrElement/trait/internalInterface.java");
        }

        @TestMetadata("privateInterface.java")
        public void testPrivateInterface() throws Exception {
            runTest("j2k/testData/fileOrElement/trait/privateInterface.java");
        }

        @TestMetadata("protectedInterface.java")
        public void testProtectedInterface() throws Exception {
            runTest("j2k/testData/fileOrElement/trait/protectedInterface.java");
        }

        @TestMetadata("publicInterface.java")
        public void testPublicInterface() throws Exception {
            runTest("j2k/testData/fileOrElement/trait/publicInterface.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/tryStatement")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class TryStatement extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInTryStatement() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/tryStatement"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("commonCaseForTryStatement.java")
        public void testCommonCaseForTryStatement() throws Exception {
            runTest("j2k/testData/fileOrElement/tryStatement/commonCaseForTryStatement.java");
        }

        @TestMetadata("disjunctionType.java")
        public void testDisjunctionType() throws Exception {
            runTest("j2k/testData/fileOrElement/tryStatement/disjunctionType.java");
        }

        @TestMetadata("emptyTryWithTwoCatchesWithEmptyFinally.java")
        public void testEmptyTryWithTwoCatchesWithEmptyFinally() throws Exception {
            runTest("j2k/testData/fileOrElement/tryStatement/emptyTryWithTwoCatchesWithEmptyFinally.java");
        }

        @TestMetadata("emptyTryWithTwoCatchesWithFinally.java")
        public void testEmptyTryWithTwoCatchesWithFinally() throws Exception {
            runTest("j2k/testData/fileOrElement/tryStatement/emptyTryWithTwoCatchesWithFinally.java");
        }

        @TestMetadata("emptyTryWithTwoCatchesWithoutFinally.java")
        public void testEmptyTryWithTwoCatchesWithoutFinally() throws Exception {
            runTest("j2k/testData/fileOrElement/tryStatement/emptyTryWithTwoCatchesWithoutFinally.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/tryWithResource")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class TryWithResource extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInTryWithResource() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/tryWithResource"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("Multiline.java")
        public void testMultiline() throws Exception {
            runTest("j2k/testData/fileOrElement/tryWithResource/Multiline.java");
        }

        @TestMetadata("MultipleResources.java")
        public void testMultipleResources() throws Exception {
            runTest("j2k/testData/fileOrElement/tryWithResource/MultipleResources.java");
        }

        @TestMetadata("Simple.java")
        public void testSimple() throws Exception {
            runTest("j2k/testData/fileOrElement/tryWithResource/Simple.java");
        }

        @TestMetadata("WithCatch.java")
        public void testWithCatch() throws Exception {
            runTest("j2k/testData/fileOrElement/tryWithResource/WithCatch.java");
        }

        @TestMetadata("WithCatchAndFinally.java")
        public void testWithCatchAndFinally() throws Exception {
            runTest("j2k/testData/fileOrElement/tryWithResource/WithCatchAndFinally.java");
        }

        @TestMetadata("WithCatches.java")
        public void testWithCatches() throws Exception {
            runTest("j2k/testData/fileOrElement/tryWithResource/WithCatches.java");
        }

        @TestMetadata("WithFinally.java")
        public void testWithFinally() throws Exception {
            runTest("j2k/testData/fileOrElement/tryWithResource/WithFinally.java");
        }

        @TestMetadata("WithReturnAtEnd.java")
        public void testWithReturnAtEnd() throws Exception {
            runTest("j2k/testData/fileOrElement/tryWithResource/WithReturnAtEnd.java");
        }

        @TestMetadata("WithReturnInAnonymousClass.java")
        public void testWithReturnInAnonymousClass() throws Exception {
            runTest("j2k/testData/fileOrElement/tryWithResource/WithReturnInAnonymousClass.java");
        }

        @TestMetadata("WithReturnInAnonymousClass2.java")
        public void testWithReturnInAnonymousClass2() throws Exception {
            runTest("j2k/testData/fileOrElement/tryWithResource/WithReturnInAnonymousClass2.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/typeCastExpression")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class TypeCastExpression extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInTypeCastExpression() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/typeCastExpression"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("beforeDot.java")
        public void testBeforeDot() throws Exception {
            runTest("j2k/testData/fileOrElement/typeCastExpression/beforeDot.java");
        }

        @TestMetadata("castNullObject.java")
        public void testCastNullObject() throws Exception {
            runTest("j2k/testData/fileOrElement/typeCastExpression/castNullObject.java");
        }

        @TestMetadata("castNullable.java")
        public void testCastNullable() throws Exception {
            runTest("j2k/testData/fileOrElement/typeCastExpression/castNullable.java");
        }

        @TestMetadata("extendsWildcardCast.java")
        public void testExtendsWildcardCast() throws Exception {
            runTest("j2k/testData/fileOrElement/typeCastExpression/extendsWildcardCast.java");
        }

        @TestMetadata("fooCast.java")
        public void testFooCast() throws Exception {
            runTest("j2k/testData/fileOrElement/typeCastExpression/fooCast.java");
        }

        @TestMetadata("intCast.java")
        public void testIntCast() throws Exception {
            runTest("j2k/testData/fileOrElement/typeCastExpression/intCast.java");
        }

        @TestMetadata("primitiveType.java")
        public void testPrimitiveType() throws Exception {
            runTest("j2k/testData/fileOrElement/typeCastExpression/primitiveType.java");
        }

        @TestMetadata("simpleGenericCast.java")
        public void testSimpleGenericCast() throws Exception {
            runTest("j2k/testData/fileOrElement/typeCastExpression/simpleGenericCast.java");
        }

        @TestMetadata("stringCast.java")
        public void testStringCast() throws Exception {
            runTest("j2k/testData/fileOrElement/typeCastExpression/stringCast.java");
        }

        @TestMetadata("superWildcardCast.java")
        public void testSuperWildcardCast() throws Exception {
            runTest("j2k/testData/fileOrElement/typeCastExpression/superWildcardCast.java");
        }

        @TestMetadata("wildcardCast.java")
        public void testWildcardCast() throws Exception {
            runTest("j2k/testData/fileOrElement/typeCastExpression/wildcardCast.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/typeParameters")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class TypeParameters extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInTypeParameters() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/typeParameters"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("classDoubleParametrizationWithTwoBoundsWithExtending.java")
        public void testClassDoubleParametrizationWithTwoBoundsWithExtending() throws Exception {
            runTest("j2k/testData/fileOrElement/typeParameters/classDoubleParametrizationWithTwoBoundsWithExtending.java");
        }

        @TestMetadata("classParametrizationWithTwoBounds.java")
        public void testClassParametrizationWithTwoBounds() throws Exception {
            runTest("j2k/testData/fileOrElement/typeParameters/classParametrizationWithTwoBounds.java");
        }

        @TestMetadata("classParametrizationWithTwoBoundsWithExtending.java")
        public void testClassParametrizationWithTwoBoundsWithExtending() throws Exception {
            runTest("j2k/testData/fileOrElement/typeParameters/classParametrizationWithTwoBoundsWithExtending.java");
        }

        @TestMetadata("complexExampleWithClassExtending.java")
        public void testComplexExampleWithClassExtending() throws Exception {
            runTest("j2k/testData/fileOrElement/typeParameters/complexExampleWithClassExtending.java");
        }

        @TestMetadata("complexExampleWithClassMultiplyExtending.java")
        public void testComplexExampleWithClassMultiplyExtending() throws Exception {
            runTest("j2k/testData/fileOrElement/typeParameters/complexExampleWithClassMultiplyExtending.java");
        }

        @TestMetadata("genericClass.java")
        public void testGenericClass() throws Exception {
            runTest("j2k/testData/fileOrElement/typeParameters/genericClass.java");
        }

        @TestMetadata("genericParam.java")
        public void testGenericParam() throws Exception {
            runTest("j2k/testData/fileOrElement/typeParameters/genericParam.java");
        }

        @TestMetadata("genericParam-settings.java")
        public void testGenericParam_settings() throws Exception {
            runTest("j2k/testData/fileOrElement/typeParameters/genericParam-settings.java");
        }

        @TestMetadata("manyGenericParams.java")
        public void testManyGenericParams() throws Exception {
            runTest("j2k/testData/fileOrElement/typeParameters/manyGenericParams.java");
        }

        @TestMetadata("methodDoubleParametrizationWithTwoBounds.java")
        public void testMethodDoubleParametrizationWithTwoBounds() throws Exception {
            runTest("j2k/testData/fileOrElement/typeParameters/methodDoubleParametrizationWithTwoBounds.java");
        }

        @TestMetadata("needTypeArgs.java")
        public void testNeedTypeArgs() throws Exception {
            runTest("j2k/testData/fileOrElement/typeParameters/needTypeArgs.java");
        }

        @TestMetadata("rawTypeCast.java")
        public void testRawTypeCast() throws Exception {
            runTest("j2k/testData/fileOrElement/typeParameters/rawTypeCast.java");
        }

        @TestMetadata("traitDoubleParametrizationWithTwoBoundsWithExtending.java")
        public void testTraitDoubleParametrizationWithTwoBoundsWithExtending() throws Exception {
            runTest("j2k/testData/fileOrElement/typeParameters/traitDoubleParametrizationWithTwoBoundsWithExtending.java");
        }

        @TestMetadata("typeFromOtherFile.java")
        public void testTypeFromOtherFile() throws Exception {
            runTest("j2k/testData/fileOrElement/typeParameters/typeFromOtherFile.java");
        }

        @TestMetadata("where.java")
        public void testWhere() throws Exception {
            runTest("j2k/testData/fileOrElement/typeParameters/where.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/varArg")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class VarArg extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInVarArg() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/varArg"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("ellipsisTypeSeveralParams.java")
        public void testEllipsisTypeSeveralParams() throws Exception {
            runTest("j2k/testData/fileOrElement/varArg/ellipsisTypeSeveralParams.java");
        }

        @TestMetadata("ellipsisTypeSingleParams.java")
        public void testEllipsisTypeSingleParams() throws Exception {
            runTest("j2k/testData/fileOrElement/varArg/ellipsisTypeSingleParams.java");
        }
    }

    @TestMetadata("j2k/testData/fileOrElement/whileStatement")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class WhileStatement extends AbstractJavaToKotlinConverterSingleFileTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInWhileStatement() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("j2k/testData/fileOrElement/whileStatement"), Pattern.compile("^(.+)\\.java$"), TargetBackend.ANY, true);
        }

        @TestMetadata("whileWithAssignmentAsExpression.java")
        public void testWhileWithAssignmentAsExpression() throws Exception {
            runTest("j2k/testData/fileOrElement/whileStatement/whileWithAssignmentAsExpression.java");
        }

        @TestMetadata("whileWithBlock.java")
        public void testWhileWithBlock() throws Exception {
            runTest("j2k/testData/fileOrElement/whileStatement/whileWithBlock.java");
        }

        @TestMetadata("whileWithEmptyBlock.java")
        public void testWhileWithEmptyBlock() throws Exception {
            runTest("j2k/testData/fileOrElement/whileStatement/whileWithEmptyBlock.java");
        }

        @TestMetadata("whileWithExpression.java")
        public void testWhileWithExpression() throws Exception {
            runTest("j2k/testData/fileOrElement/whileStatement/whileWithExpression.java");
        }

        @TestMetadata("whileWithReturn.java")
        public void testWhileWithReturn() throws Exception {
            runTest("j2k/testData/fileOrElement/whileStatement/whileWithReturn.java");
        }

        @TestMetadata("whileWithoutBody.java")
        public void testWhileWithoutBody() throws Exception {
            runTest("j2k/testData/fileOrElement/whileStatement/whileWithoutBody.java");
        }
    }
}
