/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.renderer;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/testData/renderer")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class DescriptorRendererTestGenerated extends AbstractDescriptorRendererTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
    }

    public void testAllFilesPresentInRenderer() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/renderer"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("Classes.kt")
    public void testClasses() throws Exception {
        runTest("compiler/testData/renderer/Classes.kt");
    }

    @TestMetadata("Enum.kt")
    public void testEnum() throws Exception {
        runTest("compiler/testData/renderer/Enum.kt");
    }

    @TestMetadata("ErrorType.kt")
    public void testErrorType() throws Exception {
        runTest("compiler/testData/renderer/ErrorType.kt");
    }

    @TestMetadata("FunctionTypes.kt")
    public void testFunctionTypes() throws Exception {
        runTest("compiler/testData/renderer/FunctionTypes.kt");
    }

    @TestMetadata("FunctionTypesInSignature.kt")
    public void testFunctionTypesInSignature() throws Exception {
        runTest("compiler/testData/renderer/FunctionTypesInSignature.kt");
    }

    @TestMetadata("GlobalFunctions.kt")
    public void testGlobalFunctions() throws Exception {
        runTest("compiler/testData/renderer/GlobalFunctions.kt");
    }

    @TestMetadata("GlobalProperties.kt")
    public void testGlobalProperties() throws Exception {
        runTest("compiler/testData/renderer/GlobalProperties.kt");
    }

    @TestMetadata("InheritedMembersVisibility.kt")
    public void testInheritedMembersVisibility() throws Exception {
        runTest("compiler/testData/renderer/InheritedMembersVisibility.kt");
    }

    @TestMetadata("KeywordsInNames.kt")
    public void testKeywordsInNames() throws Exception {
        runTest("compiler/testData/renderer/KeywordsInNames.kt");
    }

    @TestMetadata("ObjectWithConstructor.kt")
    public void testObjectWithConstructor() throws Exception {
        runTest("compiler/testData/renderer/ObjectWithConstructor.kt");
    }

    @TestMetadata("StarProjection.kt")
    public void testStarProjection() throws Exception {
        runTest("compiler/testData/renderer/StarProjection.kt");
    }

    @TestMetadata("TraitWithConstructor.kt")
    public void testTraitWithConstructor() throws Exception {
        runTest("compiler/testData/renderer/TraitWithConstructor.kt");
    }

    @TestMetadata("TypeAnnotations.kt")
    public void testTypeAnnotations() throws Exception {
        runTest("compiler/testData/renderer/TypeAnnotations.kt");
    }

    @TestMetadata("UnitType.kt")
    public void testUnitType() throws Exception {
        runTest("compiler/testData/renderer/UnitType.kt");
    }
}
