
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQAbstractAudioOutput.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QAbstractAudioOutput>
#include <QAudioFormat>
#include <QChildEvent>
#include <QEvent>
#include <QIODevice>
#include <QMetaMethod>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QAbstractAudioOutput

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QAbstractAudioOutput::staticMetaObject);
}


// int QAbstractAudioOutput::bufferSize()


static void _init_f_bufferSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_bufferSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractAudioOutput *)cls)->bufferSize ());
}


// int QAbstractAudioOutput::bytesFree()


static void _init_f_bytesFree_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_bytesFree_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractAudioOutput *)cls)->bytesFree ());
}


// QString QAbstractAudioOutput::category()


static void _init_f_category_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_category_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QAbstractAudioOutput *)cls)->category ());
}


// qint64 QAbstractAudioOutput::elapsedUSecs()


static void _init_f_elapsedUSecs_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_elapsedUSecs_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QAbstractAudioOutput *)cls)->elapsedUSecs ());
}


// QAudio::Error QAbstractAudioOutput::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAudio::Error>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QAudio::Error>::target_type > ((qt_gsi::Converter<QAudio::Error>::target_type)qt_gsi::CppToQtAdaptor<QAudio::Error>(((QAbstractAudioOutput *)cls)->error ()));
}


// void QAbstractAudioOutput::errorChanged(QAudio::Error)


static void _init_f_errorChanged_1653 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QAudio::Error>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_errorChanged_1653 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAudio::Error>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QAudio::Error>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioOutput *)cls)->errorChanged (qt_gsi::QtToCppAdaptor<QAudio::Error>(arg1).cref());
}


// QAudioFormat QAbstractAudioOutput::format()


static void _init_f_format_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAudioFormat > ();
}

static void _call_f_format_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAudioFormat > ((QAudioFormat)((QAbstractAudioOutput *)cls)->format ());
}


// void QAbstractAudioOutput::notify()


static void _init_f_notify_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_notify_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioOutput *)cls)->notify ();
}


// int QAbstractAudioOutput::notifyInterval()


static void _init_f_notifyInterval_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_notifyInterval_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractAudioOutput *)cls)->notifyInterval ());
}


// int QAbstractAudioOutput::periodSize()


static void _init_f_periodSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_periodSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractAudioOutput *)cls)->periodSize ());
}


// qint64 QAbstractAudioOutput::processedUSecs()


static void _init_f_processedUSecs_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_processedUSecs_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QAbstractAudioOutput *)cls)->processedUSecs ());
}


// void QAbstractAudioOutput::reset()


static void _init_f_reset_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_reset_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioOutput *)cls)->reset ();
}


// void QAbstractAudioOutput::resume()


static void _init_f_resume_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_resume_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioOutput *)cls)->resume ();
}


// void QAbstractAudioOutput::setBufferSize(int value)


static void _init_f_setBufferSize_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBufferSize_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioOutput *)cls)->setBufferSize (arg1);
}


// void QAbstractAudioOutput::setCategory(const QString &)


static void _init_f_setCategory_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCategory_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioOutput *)cls)->setCategory (arg1);
}


// void QAbstractAudioOutput::setFormat(const QAudioFormat &fmt)


static void _init_f_setFormat_2509 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fmt");
  decl->add_arg<const QAudioFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFormat_2509 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QAudioFormat &arg1 = gsi::arg_reader<const QAudioFormat & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioOutput *)cls)->setFormat (arg1);
}


// void QAbstractAudioOutput::setNotifyInterval(int milliSeconds)


static void _init_f_setNotifyInterval_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("milliSeconds");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNotifyInterval_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioOutput *)cls)->setNotifyInterval (arg1);
}


// void QAbstractAudioOutput::setVolume(double)


static void _init_f_setVolume_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVolume_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioOutput *)cls)->setVolume (arg1);
}


// void QAbstractAudioOutput::start(QIODevice *device)


static void _init_f_start_1447 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_start_1447 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QIODevice *arg1 = gsi::arg_reader<QIODevice * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioOutput *)cls)->start (arg1);
}


// QIODevice *QAbstractAudioOutput::start()


static void _init_f_start_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QIODevice * > ();
}

static void _call_f_start_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QIODevice * > ((QIODevice *)((QAbstractAudioOutput *)cls)->start ());
}


// QAudio::State QAbstractAudioOutput::state()


static void _init_f_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAudio::State>::target_type > ();
}

static void _call_f_state_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QAudio::State>::target_type > ((qt_gsi::Converter<QAudio::State>::target_type)qt_gsi::CppToQtAdaptor<QAudio::State>(((QAbstractAudioOutput *)cls)->state ()));
}


// void QAbstractAudioOutput::stateChanged(QAudio::State)


static void _init_f_stateChanged_1644 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QAudio::State>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_stateChanged_1644 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAudio::State>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QAudio::State>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioOutput *)cls)->stateChanged (qt_gsi::QtToCppAdaptor<QAudio::State>(arg1).cref());
}


// void QAbstractAudioOutput::stop()


static void _init_f_stop_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_stop_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioOutput *)cls)->stop ();
}


// void QAbstractAudioOutput::suspend()


static void _init_f_suspend_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_suspend_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioOutput *)cls)->suspend ();
}


// double QAbstractAudioOutput::volume()


static void _init_f_volume_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_volume_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QAbstractAudioOutput *)cls)->volume ());
}


// static QString QAbstractAudioOutput::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QAbstractAudioOutput::tr (arg1, arg2, arg3));
}


// static QString QAbstractAudioOutput::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QAbstractAudioOutput::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QAbstractAudioOutput () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":bufferSize", "@brief Method int QAbstractAudioOutput::bufferSize()\n", true, &_init_f_bufferSize_c0, &_call_f_bufferSize_c0);
  methods += new qt_gsi::GenericMethod ("bytesFree", "@brief Method int QAbstractAudioOutput::bytesFree()\n", true, &_init_f_bytesFree_c0, &_call_f_bytesFree_c0);
  methods += new qt_gsi::GenericMethod (":category", "@brief Method QString QAbstractAudioOutput::category()\n", true, &_init_f_category_c0, &_call_f_category_c0);
  methods += new qt_gsi::GenericMethod ("elapsedUSecs", "@brief Method qint64 QAbstractAudioOutput::elapsedUSecs()\n", true, &_init_f_elapsedUSecs_c0, &_call_f_elapsedUSecs_c0);
  methods += new qt_gsi::GenericMethod ("error", "@brief Method QAudio::Error QAbstractAudioOutput::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
  methods += new qt_gsi::GenericMethod ("errorChanged", "@brief Method void QAbstractAudioOutput::errorChanged(QAudio::Error)\n", false, &_init_f_errorChanged_1653, &_call_f_errorChanged_1653);
  methods += new qt_gsi::GenericMethod (":format", "@brief Method QAudioFormat QAbstractAudioOutput::format()\n", true, &_init_f_format_c0, &_call_f_format_c0);
  methods += new qt_gsi::GenericMethod ("notify", "@brief Method void QAbstractAudioOutput::notify()\n", false, &_init_f_notify_0, &_call_f_notify_0);
  methods += new qt_gsi::GenericMethod (":notifyInterval", "@brief Method int QAbstractAudioOutput::notifyInterval()\n", true, &_init_f_notifyInterval_c0, &_call_f_notifyInterval_c0);
  methods += new qt_gsi::GenericMethod ("periodSize", "@brief Method int QAbstractAudioOutput::periodSize()\n", true, &_init_f_periodSize_c0, &_call_f_periodSize_c0);
  methods += new qt_gsi::GenericMethod ("processedUSecs", "@brief Method qint64 QAbstractAudioOutput::processedUSecs()\n", true, &_init_f_processedUSecs_c0, &_call_f_processedUSecs_c0);
  methods += new qt_gsi::GenericMethod ("reset", "@brief Method void QAbstractAudioOutput::reset()\n", false, &_init_f_reset_0, &_call_f_reset_0);
  methods += new qt_gsi::GenericMethod ("resume", "@brief Method void QAbstractAudioOutput::resume()\n", false, &_init_f_resume_0, &_call_f_resume_0);
  methods += new qt_gsi::GenericMethod ("setBufferSize|bufferSize=", "@brief Method void QAbstractAudioOutput::setBufferSize(int value)\n", false, &_init_f_setBufferSize_767, &_call_f_setBufferSize_767);
  methods += new qt_gsi::GenericMethod ("setCategory|category=", "@brief Method void QAbstractAudioOutput::setCategory(const QString &)\n", false, &_init_f_setCategory_2025, &_call_f_setCategory_2025);
  methods += new qt_gsi::GenericMethod ("setFormat|format=", "@brief Method void QAbstractAudioOutput::setFormat(const QAudioFormat &fmt)\n", false, &_init_f_setFormat_2509, &_call_f_setFormat_2509);
  methods += new qt_gsi::GenericMethod ("setNotifyInterval|notifyInterval=", "@brief Method void QAbstractAudioOutput::setNotifyInterval(int milliSeconds)\n", false, &_init_f_setNotifyInterval_767, &_call_f_setNotifyInterval_767);
  methods += new qt_gsi::GenericMethod ("setVolume|volume=", "@brief Method void QAbstractAudioOutput::setVolume(double)\n", false, &_init_f_setVolume_1071, &_call_f_setVolume_1071);
  methods += new qt_gsi::GenericMethod ("start", "@brief Method void QAbstractAudioOutput::start(QIODevice *device)\n", false, &_init_f_start_1447, &_call_f_start_1447);
  methods += new qt_gsi::GenericMethod ("start", "@brief Method QIODevice *QAbstractAudioOutput::start()\n", false, &_init_f_start_0, &_call_f_start_0);
  methods += new qt_gsi::GenericMethod ("state", "@brief Method QAudio::State QAbstractAudioOutput::state()\n", true, &_init_f_state_c0, &_call_f_state_c0);
  methods += new qt_gsi::GenericMethod ("stateChanged", "@brief Method void QAbstractAudioOutput::stateChanged(QAudio::State)\n", false, &_init_f_stateChanged_1644, &_call_f_stateChanged_1644);
  methods += new qt_gsi::GenericMethod ("stop", "@brief Method void QAbstractAudioOutput::stop()\n", false, &_init_f_stop_0, &_call_f_stop_0);
  methods += new qt_gsi::GenericMethod ("suspend", "@brief Method void QAbstractAudioOutput::suspend()\n", false, &_init_f_suspend_0, &_call_f_suspend_0);
  methods += new qt_gsi::GenericMethod (":volume", "@brief Method double QAbstractAudioOutput::volume()\n", true, &_init_f_volume_c0, &_call_f_volume_c0);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QAbstractAudioOutput::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QAbstractAudioOutput::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QAbstractAudioOutput> decl_QAbstractAudioOutput (qtdecl_QObject (), "QtMultimedia", "QAbstractAudioOutput_Native",
  methods_QAbstractAudioOutput (),
  "@hide\n@alias QAbstractAudioOutput");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QAbstractAudioOutput> &qtdecl_QAbstractAudioOutput () { return decl_QAbstractAudioOutput; }

}


class QAbstractAudioOutput_Adaptor : public QAbstractAudioOutput, public qt_gsi::QtObjectBase
{
public:

  virtual ~QAbstractAudioOutput_Adaptor();

  //  [adaptor ctor] QAbstractAudioOutput::QAbstractAudioOutput()
  QAbstractAudioOutput_Adaptor() : QAbstractAudioOutput()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QAbstractAudioOutput::isSignalConnected(const QMetaMethod &signal)
  bool fp_QAbstractAudioOutput_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QAbstractAudioOutput::isSignalConnected(signal);
  }

  //  [expose] int QAbstractAudioOutput::receivers(const char *signal)
  int fp_QAbstractAudioOutput_receivers_c1731 (const char *signal) const {
    return QAbstractAudioOutput::receivers(signal);
  }

  //  [expose] QObject *QAbstractAudioOutput::sender()
  QObject * fp_QAbstractAudioOutput_sender_c0 () const {
    return QAbstractAudioOutput::sender();
  }

  //  [expose] int QAbstractAudioOutput::senderSignalIndex()
  int fp_QAbstractAudioOutput_senderSignalIndex_c0 () const {
    return QAbstractAudioOutput::senderSignalIndex();
  }

  //  [adaptor impl] int QAbstractAudioOutput::bufferSize()
  int cbs_bufferSize_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("bufferSize");
  }

  virtual int bufferSize() const
  {
    if (cb_bufferSize_c0_0.can_issue()) {
      return cb_bufferSize_c0_0.issue<QAbstractAudioOutput_Adaptor, int>(&QAbstractAudioOutput_Adaptor::cbs_bufferSize_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("bufferSize");
    }
  }

  //  [adaptor impl] int QAbstractAudioOutput::bytesFree()
  int cbs_bytesFree_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("bytesFree");
  }

  virtual int bytesFree() const
  {
    if (cb_bytesFree_c0_0.can_issue()) {
      return cb_bytesFree_c0_0.issue<QAbstractAudioOutput_Adaptor, int>(&QAbstractAudioOutput_Adaptor::cbs_bytesFree_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("bytesFree");
    }
  }

  //  [adaptor impl] QString QAbstractAudioOutput::category()
  QString cbs_category_c0_0() const
  {
    return QAbstractAudioOutput::category();
  }

  virtual QString category() const
  {
    if (cb_category_c0_0.can_issue()) {
      return cb_category_c0_0.issue<QAbstractAudioOutput_Adaptor, QString>(&QAbstractAudioOutput_Adaptor::cbs_category_c0_0);
    } else {
      return QAbstractAudioOutput::category();
    }
  }

  //  [adaptor impl] qint64 QAbstractAudioOutput::elapsedUSecs()
  qint64 cbs_elapsedUSecs_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("elapsedUSecs");
  }

  virtual qint64 elapsedUSecs() const
  {
    if (cb_elapsedUSecs_c0_0.can_issue()) {
      return cb_elapsedUSecs_c0_0.issue<QAbstractAudioOutput_Adaptor, qint64>(&QAbstractAudioOutput_Adaptor::cbs_elapsedUSecs_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("elapsedUSecs");
    }
  }

  //  [adaptor impl] QAudio::Error QAbstractAudioOutput::error()
  qt_gsi::Converter<QAudio::Error>::target_type cbs_error_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("error");
  }

  virtual QAudio::Error error() const
  {
    if (cb_error_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QAudio::Error>(cb_error_c0_0.issue<QAbstractAudioOutput_Adaptor, qt_gsi::Converter<QAudio::Error>::target_type>(&QAbstractAudioOutput_Adaptor::cbs_error_c0_0)).cref();
    } else {
      throw qt_gsi::AbstractMethodCalledException("error");
    }
  }

  //  [adaptor impl] bool QAbstractAudioOutput::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QAbstractAudioOutput::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QAbstractAudioOutput_Adaptor, bool, QEvent *>(&QAbstractAudioOutput_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QAbstractAudioOutput::event(arg1);
    }
  }

  //  [adaptor impl] bool QAbstractAudioOutput::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QAbstractAudioOutput::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QAbstractAudioOutput_Adaptor, bool, QObject *, QEvent *>(&QAbstractAudioOutput_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QAbstractAudioOutput::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] QAudioFormat QAbstractAudioOutput::format()
  QAudioFormat cbs_format_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("format");
  }

  virtual QAudioFormat format() const
  {
    if (cb_format_c0_0.can_issue()) {
      return cb_format_c0_0.issue<QAbstractAudioOutput_Adaptor, QAudioFormat>(&QAbstractAudioOutput_Adaptor::cbs_format_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("format");
    }
  }

  //  [adaptor impl] int QAbstractAudioOutput::notifyInterval()
  int cbs_notifyInterval_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("notifyInterval");
  }

  virtual int notifyInterval() const
  {
    if (cb_notifyInterval_c0_0.can_issue()) {
      return cb_notifyInterval_c0_0.issue<QAbstractAudioOutput_Adaptor, int>(&QAbstractAudioOutput_Adaptor::cbs_notifyInterval_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("notifyInterval");
    }
  }

  //  [adaptor impl] int QAbstractAudioOutput::periodSize()
  int cbs_periodSize_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("periodSize");
  }

  virtual int periodSize() const
  {
    if (cb_periodSize_c0_0.can_issue()) {
      return cb_periodSize_c0_0.issue<QAbstractAudioOutput_Adaptor, int>(&QAbstractAudioOutput_Adaptor::cbs_periodSize_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("periodSize");
    }
  }

  //  [adaptor impl] qint64 QAbstractAudioOutput::processedUSecs()
  qint64 cbs_processedUSecs_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("processedUSecs");
  }

  virtual qint64 processedUSecs() const
  {
    if (cb_processedUSecs_c0_0.can_issue()) {
      return cb_processedUSecs_c0_0.issue<QAbstractAudioOutput_Adaptor, qint64>(&QAbstractAudioOutput_Adaptor::cbs_processedUSecs_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("processedUSecs");
    }
  }

  //  [adaptor impl] void QAbstractAudioOutput::reset()
  void cbs_reset_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("reset");
  }

  virtual void reset()
  {
    if (cb_reset_0_0.can_issue()) {
      cb_reset_0_0.issue<QAbstractAudioOutput_Adaptor>(&QAbstractAudioOutput_Adaptor::cbs_reset_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("reset");
    }
  }

  //  [adaptor impl] void QAbstractAudioOutput::resume()
  void cbs_resume_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("resume");
  }

  virtual void resume()
  {
    if (cb_resume_0_0.can_issue()) {
      cb_resume_0_0.issue<QAbstractAudioOutput_Adaptor>(&QAbstractAudioOutput_Adaptor::cbs_resume_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("resume");
    }
  }

  //  [adaptor impl] void QAbstractAudioOutput::setBufferSize(int value)
  void cbs_setBufferSize_767_0(int value)
  {
    __SUPPRESS_UNUSED_WARNING (value);
    throw qt_gsi::AbstractMethodCalledException("setBufferSize");
  }

  virtual void setBufferSize(int value)
  {
    if (cb_setBufferSize_767_0.can_issue()) {
      cb_setBufferSize_767_0.issue<QAbstractAudioOutput_Adaptor, int>(&QAbstractAudioOutput_Adaptor::cbs_setBufferSize_767_0, value);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setBufferSize");
    }
  }

  //  [adaptor impl] void QAbstractAudioOutput::setCategory(const QString &)
  void cbs_setCategory_2025_0(const QString &arg1)
  {
    QAbstractAudioOutput::setCategory(arg1);
  }

  virtual void setCategory(const QString &arg1)
  {
    if (cb_setCategory_2025_0.can_issue()) {
      cb_setCategory_2025_0.issue<QAbstractAudioOutput_Adaptor, const QString &>(&QAbstractAudioOutput_Adaptor::cbs_setCategory_2025_0, arg1);
    } else {
      QAbstractAudioOutput::setCategory(arg1);
    }
  }

  //  [adaptor impl] void QAbstractAudioOutput::setFormat(const QAudioFormat &fmt)
  void cbs_setFormat_2509_0(const QAudioFormat &fmt)
  {
    __SUPPRESS_UNUSED_WARNING (fmt);
    throw qt_gsi::AbstractMethodCalledException("setFormat");
  }

  virtual void setFormat(const QAudioFormat &fmt)
  {
    if (cb_setFormat_2509_0.can_issue()) {
      cb_setFormat_2509_0.issue<QAbstractAudioOutput_Adaptor, const QAudioFormat &>(&QAbstractAudioOutput_Adaptor::cbs_setFormat_2509_0, fmt);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setFormat");
    }
  }

  //  [adaptor impl] void QAbstractAudioOutput::setNotifyInterval(int milliSeconds)
  void cbs_setNotifyInterval_767_0(int milliSeconds)
  {
    __SUPPRESS_UNUSED_WARNING (milliSeconds);
    throw qt_gsi::AbstractMethodCalledException("setNotifyInterval");
  }

  virtual void setNotifyInterval(int milliSeconds)
  {
    if (cb_setNotifyInterval_767_0.can_issue()) {
      cb_setNotifyInterval_767_0.issue<QAbstractAudioOutput_Adaptor, int>(&QAbstractAudioOutput_Adaptor::cbs_setNotifyInterval_767_0, milliSeconds);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setNotifyInterval");
    }
  }

  //  [adaptor impl] void QAbstractAudioOutput::setVolume(double)
  void cbs_setVolume_1071_0(double arg1)
  {
    QAbstractAudioOutput::setVolume(arg1);
  }

  virtual void setVolume(double arg1)
  {
    if (cb_setVolume_1071_0.can_issue()) {
      cb_setVolume_1071_0.issue<QAbstractAudioOutput_Adaptor, double>(&QAbstractAudioOutput_Adaptor::cbs_setVolume_1071_0, arg1);
    } else {
      QAbstractAudioOutput::setVolume(arg1);
    }
  }

  //  [adaptor impl] void QAbstractAudioOutput::start(QIODevice *device)
  void cbs_start_1447_0(QIODevice *device)
  {
    __SUPPRESS_UNUSED_WARNING (device);
    throw qt_gsi::AbstractMethodCalledException("start");
  }

  virtual void start(QIODevice *device)
  {
    if (cb_start_1447_0.can_issue()) {
      cb_start_1447_0.issue<QAbstractAudioOutput_Adaptor, QIODevice *>(&QAbstractAudioOutput_Adaptor::cbs_start_1447_0, device);
    } else {
      throw qt_gsi::AbstractMethodCalledException("start");
    }
  }

  //  [adaptor impl] QIODevice *QAbstractAudioOutput::start()
  QIODevice * cbs_start_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("start");
  }

  virtual QIODevice * start()
  {
    if (cb_start_0_0.can_issue()) {
      return cb_start_0_0.issue<QAbstractAudioOutput_Adaptor, QIODevice *>(&QAbstractAudioOutput_Adaptor::cbs_start_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("start");
    }
  }

  //  [adaptor impl] QAudio::State QAbstractAudioOutput::state()
  qt_gsi::Converter<QAudio::State>::target_type cbs_state_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("state");
  }

  virtual QAudio::State state() const
  {
    if (cb_state_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QAudio::State>(cb_state_c0_0.issue<QAbstractAudioOutput_Adaptor, qt_gsi::Converter<QAudio::State>::target_type>(&QAbstractAudioOutput_Adaptor::cbs_state_c0_0)).cref();
    } else {
      throw qt_gsi::AbstractMethodCalledException("state");
    }
  }

  //  [adaptor impl] void QAbstractAudioOutput::stop()
  void cbs_stop_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("stop");
  }

  virtual void stop()
  {
    if (cb_stop_0_0.can_issue()) {
      cb_stop_0_0.issue<QAbstractAudioOutput_Adaptor>(&QAbstractAudioOutput_Adaptor::cbs_stop_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("stop");
    }
  }

  //  [adaptor impl] void QAbstractAudioOutput::suspend()
  void cbs_suspend_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("suspend");
  }

  virtual void suspend()
  {
    if (cb_suspend_0_0.can_issue()) {
      cb_suspend_0_0.issue<QAbstractAudioOutput_Adaptor>(&QAbstractAudioOutput_Adaptor::cbs_suspend_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("suspend");
    }
  }

  //  [adaptor impl] double QAbstractAudioOutput::volume()
  double cbs_volume_c0_0() const
  {
    return QAbstractAudioOutput::volume();
  }

  virtual double volume() const
  {
    if (cb_volume_c0_0.can_issue()) {
      return cb_volume_c0_0.issue<QAbstractAudioOutput_Adaptor, double>(&QAbstractAudioOutput_Adaptor::cbs_volume_c0_0);
    } else {
      return QAbstractAudioOutput::volume();
    }
  }

  //  [adaptor impl] void QAbstractAudioOutput::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QAbstractAudioOutput::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QAbstractAudioOutput_Adaptor, QChildEvent *>(&QAbstractAudioOutput_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QAbstractAudioOutput::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractAudioOutput::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QAbstractAudioOutput::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QAbstractAudioOutput_Adaptor, QEvent *>(&QAbstractAudioOutput_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QAbstractAudioOutput::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractAudioOutput::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QAbstractAudioOutput::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QAbstractAudioOutput_Adaptor, const QMetaMethod &>(&QAbstractAudioOutput_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QAbstractAudioOutput::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QAbstractAudioOutput::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QAbstractAudioOutput::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QAbstractAudioOutput_Adaptor, QTimerEvent *>(&QAbstractAudioOutput_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QAbstractAudioOutput::timerEvent(arg1);
    }
  }

  gsi::Callback cb_bufferSize_c0_0;
  gsi::Callback cb_bytesFree_c0_0;
  gsi::Callback cb_category_c0_0;
  gsi::Callback cb_elapsedUSecs_c0_0;
  gsi::Callback cb_error_c0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_format_c0_0;
  gsi::Callback cb_notifyInterval_c0_0;
  gsi::Callback cb_periodSize_c0_0;
  gsi::Callback cb_processedUSecs_c0_0;
  gsi::Callback cb_reset_0_0;
  gsi::Callback cb_resume_0_0;
  gsi::Callback cb_setBufferSize_767_0;
  gsi::Callback cb_setCategory_2025_0;
  gsi::Callback cb_setFormat_2509_0;
  gsi::Callback cb_setNotifyInterval_767_0;
  gsi::Callback cb_setVolume_1071_0;
  gsi::Callback cb_start_1447_0;
  gsi::Callback cb_start_0_0;
  gsi::Callback cb_state_c0_0;
  gsi::Callback cb_stop_0_0;
  gsi::Callback cb_suspend_0_0;
  gsi::Callback cb_volume_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QAbstractAudioOutput_Adaptor::~QAbstractAudioOutput_Adaptor() { }

//  Constructor QAbstractAudioOutput::QAbstractAudioOutput() (adaptor class)

static void _init_ctor_QAbstractAudioOutput_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QAbstractAudioOutput_Adaptor> ();
}

static void _call_ctor_QAbstractAudioOutput_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAbstractAudioOutput_Adaptor *> (new QAbstractAudioOutput_Adaptor ());
}


// int QAbstractAudioOutput::bufferSize()

static void _init_cbs_bufferSize_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_bufferSize_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractAudioOutput_Adaptor *)cls)->cbs_bufferSize_c0_0 ());
}

static void _set_callback_cbs_bufferSize_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioOutput_Adaptor *)cls)->cb_bufferSize_c0_0 = cb;
}


// int QAbstractAudioOutput::bytesFree()

static void _init_cbs_bytesFree_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_bytesFree_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractAudioOutput_Adaptor *)cls)->cbs_bytesFree_c0_0 ());
}

static void _set_callback_cbs_bytesFree_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioOutput_Adaptor *)cls)->cb_bytesFree_c0_0 = cb;
}


// QString QAbstractAudioOutput::category()

static void _init_cbs_category_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_cbs_category_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QAbstractAudioOutput_Adaptor *)cls)->cbs_category_c0_0 ());
}

static void _set_callback_cbs_category_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioOutput_Adaptor *)cls)->cb_category_c0_0 = cb;
}


// void QAbstractAudioOutput::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioOutput_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioOutput_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QAbstractAudioOutput::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioOutput_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioOutput_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// void QAbstractAudioOutput::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioOutput_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioOutput_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// qint64 QAbstractAudioOutput::elapsedUSecs()

static void _init_cbs_elapsedUSecs_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_cbs_elapsedUSecs_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QAbstractAudioOutput_Adaptor *)cls)->cbs_elapsedUSecs_c0_0 ());
}

static void _set_callback_cbs_elapsedUSecs_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioOutput_Adaptor *)cls)->cb_elapsedUSecs_c0_0 = cb;
}


// QAudio::Error QAbstractAudioOutput::error()

static void _init_cbs_error_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAudio::Error>::target_type > ();
}

static void _call_cbs_error_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QAudio::Error>::target_type > ((qt_gsi::Converter<QAudio::Error>::target_type)((QAbstractAudioOutput_Adaptor *)cls)->cbs_error_c0_0 ());
}

static void _set_callback_cbs_error_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioOutput_Adaptor *)cls)->cb_error_c0_0 = cb;
}


// bool QAbstractAudioOutput::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QAbstractAudioOutput_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioOutput_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QAbstractAudioOutput::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QAbstractAudioOutput_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioOutput_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// QAudioFormat QAbstractAudioOutput::format()

static void _init_cbs_format_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAudioFormat > ();
}

static void _call_cbs_format_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAudioFormat > ((QAudioFormat)((QAbstractAudioOutput_Adaptor *)cls)->cbs_format_c0_0 ());
}

static void _set_callback_cbs_format_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioOutput_Adaptor *)cls)->cb_format_c0_0 = cb;
}


// exposed bool QAbstractAudioOutput::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QAbstractAudioOutput_Adaptor *)cls)->fp_QAbstractAudioOutput_isSignalConnected_c2394 (arg1));
}


// int QAbstractAudioOutput::notifyInterval()

static void _init_cbs_notifyInterval_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_notifyInterval_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractAudioOutput_Adaptor *)cls)->cbs_notifyInterval_c0_0 ());
}

static void _set_callback_cbs_notifyInterval_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioOutput_Adaptor *)cls)->cb_notifyInterval_c0_0 = cb;
}


// int QAbstractAudioOutput::periodSize()

static void _init_cbs_periodSize_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_periodSize_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractAudioOutput_Adaptor *)cls)->cbs_periodSize_c0_0 ());
}

static void _set_callback_cbs_periodSize_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioOutput_Adaptor *)cls)->cb_periodSize_c0_0 = cb;
}


// qint64 QAbstractAudioOutput::processedUSecs()

static void _init_cbs_processedUSecs_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_cbs_processedUSecs_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QAbstractAudioOutput_Adaptor *)cls)->cbs_processedUSecs_c0_0 ());
}

static void _set_callback_cbs_processedUSecs_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioOutput_Adaptor *)cls)->cb_processedUSecs_c0_0 = cb;
}


// exposed int QAbstractAudioOutput::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QAbstractAudioOutput_Adaptor *)cls)->fp_QAbstractAudioOutput_receivers_c1731 (arg1));
}


// void QAbstractAudioOutput::reset()

static void _init_cbs_reset_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_reset_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioOutput_Adaptor *)cls)->cbs_reset_0_0 ();
}

static void _set_callback_cbs_reset_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioOutput_Adaptor *)cls)->cb_reset_0_0 = cb;
}


// void QAbstractAudioOutput::resume()

static void _init_cbs_resume_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_resume_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioOutput_Adaptor *)cls)->cbs_resume_0_0 ();
}

static void _set_callback_cbs_resume_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioOutput_Adaptor *)cls)->cb_resume_0_0 = cb;
}


// exposed QObject *QAbstractAudioOutput::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QAbstractAudioOutput_Adaptor *)cls)->fp_QAbstractAudioOutput_sender_c0 ());
}


// exposed int QAbstractAudioOutput::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractAudioOutput_Adaptor *)cls)->fp_QAbstractAudioOutput_senderSignalIndex_c0 ());
}


// void QAbstractAudioOutput::setBufferSize(int value)

static void _init_cbs_setBufferSize_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setBufferSize_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioOutput_Adaptor *)cls)->cbs_setBufferSize_767_0 (arg1);
}

static void _set_callback_cbs_setBufferSize_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioOutput_Adaptor *)cls)->cb_setBufferSize_767_0 = cb;
}


// void QAbstractAudioOutput::setCategory(const QString &)

static void _init_cbs_setCategory_2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setCategory_2025_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioOutput_Adaptor *)cls)->cbs_setCategory_2025_0 (arg1);
}

static void _set_callback_cbs_setCategory_2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioOutput_Adaptor *)cls)->cb_setCategory_2025_0 = cb;
}


// void QAbstractAudioOutput::setFormat(const QAudioFormat &fmt)

static void _init_cbs_setFormat_2509_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fmt");
  decl->add_arg<const QAudioFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setFormat_2509_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QAudioFormat &arg1 = args.read<const QAudioFormat & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioOutput_Adaptor *)cls)->cbs_setFormat_2509_0 (arg1);
}

static void _set_callback_cbs_setFormat_2509_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioOutput_Adaptor *)cls)->cb_setFormat_2509_0 = cb;
}


// void QAbstractAudioOutput::setNotifyInterval(int milliSeconds)

static void _init_cbs_setNotifyInterval_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("milliSeconds");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setNotifyInterval_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioOutput_Adaptor *)cls)->cbs_setNotifyInterval_767_0 (arg1);
}

static void _set_callback_cbs_setNotifyInterval_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioOutput_Adaptor *)cls)->cb_setNotifyInterval_767_0 = cb;
}


// void QAbstractAudioOutput::setVolume(double)

static void _init_cbs_setVolume_1071_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVolume_1071_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = args.read<double > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioOutput_Adaptor *)cls)->cbs_setVolume_1071_0 (arg1);
}

static void _set_callback_cbs_setVolume_1071_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioOutput_Adaptor *)cls)->cb_setVolume_1071_0 = cb;
}


// void QAbstractAudioOutput::start(QIODevice *device)

static void _init_cbs_start_1447_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_start_1447_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QIODevice *arg1 = args.read<QIODevice * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioOutput_Adaptor *)cls)->cbs_start_1447_0 (arg1);
}

static void _set_callback_cbs_start_1447_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioOutput_Adaptor *)cls)->cb_start_1447_0 = cb;
}


// QIODevice *QAbstractAudioOutput::start()

static void _init_cbs_start_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QIODevice * > ();
}

static void _call_cbs_start_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QIODevice * > ((QIODevice *)((QAbstractAudioOutput_Adaptor *)cls)->cbs_start_0_0 ());
}

static void _set_callback_cbs_start_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioOutput_Adaptor *)cls)->cb_start_0_0 = cb;
}


// QAudio::State QAbstractAudioOutput::state()

static void _init_cbs_state_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAudio::State>::target_type > ();
}

static void _call_cbs_state_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QAudio::State>::target_type > ((qt_gsi::Converter<QAudio::State>::target_type)((QAbstractAudioOutput_Adaptor *)cls)->cbs_state_c0_0 ());
}

static void _set_callback_cbs_state_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioOutput_Adaptor *)cls)->cb_state_c0_0 = cb;
}


// void QAbstractAudioOutput::stop()

static void _init_cbs_stop_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_stop_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioOutput_Adaptor *)cls)->cbs_stop_0_0 ();
}

static void _set_callback_cbs_stop_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioOutput_Adaptor *)cls)->cb_stop_0_0 = cb;
}


// void QAbstractAudioOutput::suspend()

static void _init_cbs_suspend_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_suspend_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioOutput_Adaptor *)cls)->cbs_suspend_0_0 ();
}

static void _set_callback_cbs_suspend_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioOutput_Adaptor *)cls)->cb_suspend_0_0 = cb;
}


// void QAbstractAudioOutput::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioOutput_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioOutput_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// double QAbstractAudioOutput::volume()

static void _init_cbs_volume_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_cbs_volume_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QAbstractAudioOutput_Adaptor *)cls)->cbs_volume_c0_0 ());
}

static void _set_callback_cbs_volume_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioOutput_Adaptor *)cls)->cb_volume_c0_0 = cb;
}


namespace gsi
{

gsi::Class<QAbstractAudioOutput> &qtdecl_QAbstractAudioOutput ();

static gsi::Methods methods_QAbstractAudioOutput_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAbstractAudioOutput::QAbstractAudioOutput()\nThis method creates an object of class QAbstractAudioOutput.", &_init_ctor_QAbstractAudioOutput_Adaptor_0, &_call_ctor_QAbstractAudioOutput_Adaptor_0);
  methods += new qt_gsi::GenericMethod ("bufferSize", "@brief Virtual method int QAbstractAudioOutput::bufferSize()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_bufferSize_c0_0, &_call_cbs_bufferSize_c0_0);
  methods += new qt_gsi::GenericMethod ("bufferSize", "@hide", true, &_init_cbs_bufferSize_c0_0, &_call_cbs_bufferSize_c0_0, &_set_callback_cbs_bufferSize_c0_0);
  methods += new qt_gsi::GenericMethod ("bytesFree", "@brief Virtual method int QAbstractAudioOutput::bytesFree()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_bytesFree_c0_0, &_call_cbs_bytesFree_c0_0);
  methods += new qt_gsi::GenericMethod ("bytesFree", "@hide", true, &_init_cbs_bytesFree_c0_0, &_call_cbs_bytesFree_c0_0, &_set_callback_cbs_bytesFree_c0_0);
  methods += new qt_gsi::GenericMethod ("category", "@brief Virtual method QString QAbstractAudioOutput::category()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_category_c0_0, &_call_cbs_category_c0_0);
  methods += new qt_gsi::GenericMethod ("category", "@hide", true, &_init_cbs_category_c0_0, &_call_cbs_category_c0_0, &_set_callback_cbs_category_c0_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QAbstractAudioOutput::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QAbstractAudioOutput::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QAbstractAudioOutput::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("elapsedUSecs", "@brief Virtual method qint64 QAbstractAudioOutput::elapsedUSecs()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_elapsedUSecs_c0_0, &_call_cbs_elapsedUSecs_c0_0);
  methods += new qt_gsi::GenericMethod ("elapsedUSecs", "@hide", true, &_init_cbs_elapsedUSecs_c0_0, &_call_cbs_elapsedUSecs_c0_0, &_set_callback_cbs_elapsedUSecs_c0_0);
  methods += new qt_gsi::GenericMethod ("error", "@brief Virtual method QAudio::Error QAbstractAudioOutput::error()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_error_c0_0, &_call_cbs_error_c0_0);
  methods += new qt_gsi::GenericMethod ("error", "@hide", true, &_init_cbs_error_c0_0, &_call_cbs_error_c0_0, &_set_callback_cbs_error_c0_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QAbstractAudioOutput::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QAbstractAudioOutput::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("format", "@brief Virtual method QAudioFormat QAbstractAudioOutput::format()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_format_c0_0, &_call_cbs_format_c0_0);
  methods += new qt_gsi::GenericMethod ("format", "@hide", true, &_init_cbs_format_c0_0, &_call_cbs_format_c0_0, &_set_callback_cbs_format_c0_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QAbstractAudioOutput::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("notifyInterval", "@brief Virtual method int QAbstractAudioOutput::notifyInterval()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_notifyInterval_c0_0, &_call_cbs_notifyInterval_c0_0);
  methods += new qt_gsi::GenericMethod ("notifyInterval", "@hide", true, &_init_cbs_notifyInterval_c0_0, &_call_cbs_notifyInterval_c0_0, &_set_callback_cbs_notifyInterval_c0_0);
  methods += new qt_gsi::GenericMethod ("periodSize", "@brief Virtual method int QAbstractAudioOutput::periodSize()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_periodSize_c0_0, &_call_cbs_periodSize_c0_0);
  methods += new qt_gsi::GenericMethod ("periodSize", "@hide", true, &_init_cbs_periodSize_c0_0, &_call_cbs_periodSize_c0_0, &_set_callback_cbs_periodSize_c0_0);
  methods += new qt_gsi::GenericMethod ("processedUSecs", "@brief Virtual method qint64 QAbstractAudioOutput::processedUSecs()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_processedUSecs_c0_0, &_call_cbs_processedUSecs_c0_0);
  methods += new qt_gsi::GenericMethod ("processedUSecs", "@hide", true, &_init_cbs_processedUSecs_c0_0, &_call_cbs_processedUSecs_c0_0, &_set_callback_cbs_processedUSecs_c0_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QAbstractAudioOutput::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("reset", "@brief Virtual method void QAbstractAudioOutput::reset()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_reset_0_0, &_call_cbs_reset_0_0);
  methods += new qt_gsi::GenericMethod ("reset", "@hide", false, &_init_cbs_reset_0_0, &_call_cbs_reset_0_0, &_set_callback_cbs_reset_0_0);
  methods += new qt_gsi::GenericMethod ("resume", "@brief Virtual method void QAbstractAudioOutput::resume()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resume_0_0, &_call_cbs_resume_0_0);
  methods += new qt_gsi::GenericMethod ("resume", "@hide", false, &_init_cbs_resume_0_0, &_call_cbs_resume_0_0, &_set_callback_cbs_resume_0_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QAbstractAudioOutput::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QAbstractAudioOutput::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setBufferSize", "@brief Virtual method void QAbstractAudioOutput::setBufferSize(int value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setBufferSize_767_0, &_call_cbs_setBufferSize_767_0);
  methods += new qt_gsi::GenericMethod ("setBufferSize", "@hide", false, &_init_cbs_setBufferSize_767_0, &_call_cbs_setBufferSize_767_0, &_set_callback_cbs_setBufferSize_767_0);
  methods += new qt_gsi::GenericMethod ("setCategory", "@brief Virtual method void QAbstractAudioOutput::setCategory(const QString &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setCategory_2025_0, &_call_cbs_setCategory_2025_0);
  methods += new qt_gsi::GenericMethod ("setCategory", "@hide", false, &_init_cbs_setCategory_2025_0, &_call_cbs_setCategory_2025_0, &_set_callback_cbs_setCategory_2025_0);
  methods += new qt_gsi::GenericMethod ("setFormat", "@brief Virtual method void QAbstractAudioOutput::setFormat(const QAudioFormat &fmt)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setFormat_2509_0, &_call_cbs_setFormat_2509_0);
  methods += new qt_gsi::GenericMethod ("setFormat", "@hide", false, &_init_cbs_setFormat_2509_0, &_call_cbs_setFormat_2509_0, &_set_callback_cbs_setFormat_2509_0);
  methods += new qt_gsi::GenericMethod ("setNotifyInterval", "@brief Virtual method void QAbstractAudioOutput::setNotifyInterval(int milliSeconds)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setNotifyInterval_767_0, &_call_cbs_setNotifyInterval_767_0);
  methods += new qt_gsi::GenericMethod ("setNotifyInterval", "@hide", false, &_init_cbs_setNotifyInterval_767_0, &_call_cbs_setNotifyInterval_767_0, &_set_callback_cbs_setNotifyInterval_767_0);
  methods += new qt_gsi::GenericMethod ("setVolume", "@brief Virtual method void QAbstractAudioOutput::setVolume(double)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVolume_1071_0, &_call_cbs_setVolume_1071_0);
  methods += new qt_gsi::GenericMethod ("setVolume", "@hide", false, &_init_cbs_setVolume_1071_0, &_call_cbs_setVolume_1071_0, &_set_callback_cbs_setVolume_1071_0);
  methods += new qt_gsi::GenericMethod ("start", "@brief Virtual method void QAbstractAudioOutput::start(QIODevice *device)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_start_1447_0, &_call_cbs_start_1447_0);
  methods += new qt_gsi::GenericMethod ("start", "@hide", false, &_init_cbs_start_1447_0, &_call_cbs_start_1447_0, &_set_callback_cbs_start_1447_0);
  methods += new qt_gsi::GenericMethod ("start", "@brief Virtual method QIODevice *QAbstractAudioOutput::start()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_start_0_0, &_call_cbs_start_0_0);
  methods += new qt_gsi::GenericMethod ("start", "@hide", false, &_init_cbs_start_0_0, &_call_cbs_start_0_0, &_set_callback_cbs_start_0_0);
  methods += new qt_gsi::GenericMethod ("state", "@brief Virtual method QAudio::State QAbstractAudioOutput::state()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_state_c0_0, &_call_cbs_state_c0_0);
  methods += new qt_gsi::GenericMethod ("state", "@hide", true, &_init_cbs_state_c0_0, &_call_cbs_state_c0_0, &_set_callback_cbs_state_c0_0);
  methods += new qt_gsi::GenericMethod ("stop", "@brief Virtual method void QAbstractAudioOutput::stop()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_stop_0_0, &_call_cbs_stop_0_0);
  methods += new qt_gsi::GenericMethod ("stop", "@hide", false, &_init_cbs_stop_0_0, &_call_cbs_stop_0_0, &_set_callback_cbs_stop_0_0);
  methods += new qt_gsi::GenericMethod ("suspend", "@brief Virtual method void QAbstractAudioOutput::suspend()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_suspend_0_0, &_call_cbs_suspend_0_0);
  methods += new qt_gsi::GenericMethod ("suspend", "@hide", false, &_init_cbs_suspend_0_0, &_call_cbs_suspend_0_0, &_set_callback_cbs_suspend_0_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QAbstractAudioOutput::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("volume", "@brief Virtual method double QAbstractAudioOutput::volume()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_volume_c0_0, &_call_cbs_volume_c0_0);
  methods += new qt_gsi::GenericMethod ("volume", "@hide", true, &_init_cbs_volume_c0_0, &_call_cbs_volume_c0_0, &_set_callback_cbs_volume_c0_0);
  return methods;
}

gsi::Class<QAbstractAudioOutput_Adaptor> decl_QAbstractAudioOutput_Adaptor (qtdecl_QAbstractAudioOutput (), "QtMultimedia", "QAbstractAudioOutput",
  methods_QAbstractAudioOutput_Adaptor (),
  "@qt\n@brief Binding of QAbstractAudioOutput");

}

