#ifndef _GICBayer_H
#define _GICBayer_H

/* Class which describes a single colour channel of an image in a generalized
 * way allowing for easy and accurate scaling to any size.  These subclasses
 * of GImageComponent are ideal for de-Bayerizing Bayer pattern images.
 * 
 * Written by:  Chris Studholme
 * Last Update: 7-January-2000
 * Copyright:   GPL (http://www.fsf.org/copyleft/gpl.html)
 */

#include "GImageComponent.h"

class GICBayer_Green : public GImageComponent {
  /*
   * Creates a continuous function to describe a set of observed pixel data.
   * This class is appropriate for images where the pixels completely cover
   * the imaged area (a typical image).
   *
   * General function is piecewise quasi-linear function with pieces of:
   *   f(x,y) = alpha*x + beta*y + gamma*x*y + omega, x,y e [0,1]
   *   
   * Creates a continuous function to describe a set of observed pixel data.
   * The pixel data must be arranged as follows:
   *
   *     GRGRGRGR ... GR
   *     BGBGBGBG ... BG
   *     GRGRGRGR ... GR
   *     BGBGBGBG ... BG
   *         .        .
   *         .        .
   *     GRGRGRGR ... GR
   *     BGBGBGBG ... BG
   *
   * This class creates the generalized image corresponding to the green
   * part of this data, but uses the red and blue to obtain better resolution.
   *
   */
   
public:
  GICBayer_Green(const unsigned char* imagedata, 
		 int width, int height, float maxerror=0);
};


class GICBayer_Red : public GImageComponent {
  /*
   * Creates a continuous function to describe a set of observed pixel data.
   * This class is appropriate for images where the pixels completely cover
   * the imaged area (a typical image).
   *
   * General function is piecewise quasi-linear function with pieces of:
   *   f(x,y) = alpha*x + beta*y + gamma*x*y + omega, x,y e [0,1]
   *   
   * Creates a continuous function to describe a set of observed pixel data.
   * The pixel data must be arranged as follows:
   *
   *     GRGRGRGR ... GR
   *     BGBGBGBG ... BG
   *     GRGRGRGR ... GR
   *     BGBGBGBG ... BG
   *         .        .
   *         .        .
   *     GRGRGRGR ... GR
   *     BGBGBGBG ... BG
   *
   * This class creates the generalized image corresponding to the red
   * part of this data, uses the green GImageComponent to obtain better
   * resolution.
   *
   */
   
public:
  GICBayer_Red(const unsigned char* imagedata, 
	       int width, int height, GImageComponent& green, 
	       float maxerror=0);
};


class GICBayer_Blue : public GImageComponent {
  /*
   * Creates a continuous function to describe a set of observed pixel data.
   * This class is appropriate for images where the pixels completely cover
   * the imaged area (a typical image).
   *
   * General function is piecewise quasi-linear function with pieces of:
   *   f(x,y) = alpha*x + beta*y + gamma*x*y + omega, x,y e [0,1]
   *   
   * Creates a continuous function to describe a set of observed pixel data.
   * The pixel data must be arranged as follows:
   *
   *     GRGRGRGR ... GR
   *     BGBGBGBG ... BG
   *     GRGRGRGR ... GR
   *     BGBGBGBG ... BG
   *         .        .
   *         .        .
   *     GRGRGRGR ... GR
   *     BGBGBGBG ... BG
   *
   * This class creates the generalized image corresponding to the blue
   * part of this data, uses the green GImageComponent to obtain better
   * resolution.
   *
   */
   
public:
  GICBayer_Blue(const unsigned char* imagedata, 
		int width, int height, GImageComponent& green, 
		float maxerror=0);
};

#endif
