/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.PriorityQueue;

class DisjunctionSumScorer
extends Scorer {
    private final int nrScorers;
    protected final List subScorers;
    private final int minimumNrMatchers;
    private ScorerQueue scorerQueue = null;
    private int currentDoc = -1;
    protected int nrMatchers = -1;
    private float currentScore = Float.NaN;

    public DisjunctionSumScorer(List subScorers, int minimumNrMatchers) {
        super(null);
        this.nrScorers = subScorers.size();
        if (minimumNrMatchers <= 0) {
            throw new IllegalArgumentException("Minimum nr of matchers must be positive");
        }
        if (this.nrScorers <= 1) {
            throw new IllegalArgumentException("There must be at least 2 subScorers");
        }
        this.minimumNrMatchers = minimumNrMatchers;
        this.subScorers = subScorers;
    }

    public DisjunctionSumScorer(List subScorers) {
        this(subScorers, 1);
    }

    private void initScorerQueue() throws IOException {
        Iterator si = this.subScorers.iterator();
        this.scorerQueue = new ScorerQueue(this.nrScorers);
        while (si.hasNext()) {
            Scorer se = (Scorer)si.next();
            if (!se.next()) continue;
            this.scorerQueue.insert(se);
        }
    }

    public boolean next() throws IOException {
        if (this.scorerQueue == null) {
            this.initScorerQueue();
        }
        if (this.scorerQueue.size() < this.minimumNrMatchers) {
            return false;
        }
        return this.advanceAfterCurrent();
    }

    protected boolean advanceAfterCurrent() throws IOException {
        do {
            Scorer top = (Scorer)this.scorerQueue.top();
            this.currentDoc = top.doc();
            this.currentScore = top.score();
            this.nrMatchers = 1;
            while (true) {
                if (top.next()) {
                    this.scorerQueue.adjustTop();
                } else {
                    this.scorerQueue.pop();
                    if (this.scorerQueue.size() < this.minimumNrMatchers - this.nrMatchers) {
                        return false;
                    }
                    if (this.scorerQueue.size() == 0) break;
                }
                top = (Scorer)this.scorerQueue.top();
                if (top.doc() != this.currentDoc) break;
                this.currentScore += top.score();
                ++this.nrMatchers;
            }
            if (this.nrMatchers < this.minimumNrMatchers) continue;
            return true;
        } while (this.scorerQueue.size() >= this.minimumNrMatchers);
        return false;
    }

    public float score() throws IOException {
        return this.currentScore;
    }

    public int doc() {
        return this.currentDoc;
    }

    public int nrMatchers() {
        return this.nrMatchers;
    }

    public boolean skipTo(int target) throws IOException {
        if (this.scorerQueue == null) {
            this.initScorerQueue();
        }
        if (this.scorerQueue.size() < this.minimumNrMatchers) {
            return false;
        }
        if (target <= this.currentDoc) {
            return true;
        }
        while (true) {
            Scorer top;
            if ((top = (Scorer)this.scorerQueue.top()).doc() >= target) {
                return this.advanceAfterCurrent();
            }
            if (top.skipTo(target)) {
                this.scorerQueue.adjustTop();
                continue;
            }
            this.scorerQueue.pop();
            if (this.scorerQueue.size() < this.minimumNrMatchers) break;
        }
        return false;
    }

    public Explanation explain(int doc) throws IOException {
        Explanation res = new Explanation();
        res.setDescription("At least " + this.minimumNrMatchers + " of");
        Iterator ssi = this.subScorers.iterator();
        while (ssi.hasNext()) {
            res.addDetail(((Scorer)ssi.next()).explain(doc));
        }
        return res;
    }

    private class ScorerQueue
    extends PriorityQueue {
        ScorerQueue(int size) {
            this.initialize(size);
        }

        protected boolean lessThan(Object o1, Object o2) {
            return ((Scorer)o1).doc() < ((Scorer)o2).doc();
        }
    }
}

