# SPDX-FileCopyrightText: Peter Pentchev <roam@ringlet.net>
# SPDX-License-Identifier: BSD-2-Clause

{ pkgs ? import <nixpkgs> {}, perl-ver ? 536, py-ver ? 311 }:
let
  python-name = "python${toString py-ver}";
  python = builtins.getAttr python-name pkgs;
  python-pkgs = python.withPackages (p: [ p.pyparsing ] );
  perl-tree-name = "perl${toString perl-ver}Packages";
  perl-tree = builtins.getAttr perl-tree-name pkgs;
  perl-pkgs = with perl-tree; [ perl JSONXS TestCommand ];
in pkgs.mkShell {
  buildInputs = [ python python-pkgs perl-pkgs ];
  shellHook = ''
    set -e
    make test-single TEST_PROG=./python/3/feature-check.sh
    exit
  '';
}
