// --- BEGIN COPYRIGHT BLOCK ---
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; version 2 of the License.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
//
// (C) 2007 Red Hat, Inc.
// All rights reserved.
// --- END COPYRIGHT BLOCK ---
package com.netscape.admin.certsrv.config;

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import com.netscape.admin.certsrv.CMSAdminResources;
import com.netscape.admin.certsrv.CMSAdminUtil;
import com.netscape.admin.certsrv.EAdminException;
import com.netscape.admin.certsrv.connection.AdminConnection;
import com.netscape.certsrv.common.Constants;
import com.netscape.certsrv.common.DestDef;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.certsrv.common.ScopeDef;
import com.netscape.management.client.util.JButtonFactory;

/**
 * Display this dialog to get a password.
 *
 * @author chrisho
 * @author jpanchen
 * @version $Revision$, $Date$
 * @date        07/21/98
 * @deprecated The PKI console will be removed once there are CLI equivalents of desired console features.
 */

@Deprecated(since="10.14.0", forRemoval=true)
public class CMSPasswordDialog extends JDialog
    implements ActionListener, DocumentListener, MouseListener
{

    /*==========================================================
     * variables
     *==========================================================*/
    private static final int WIDTH = 300;
    private static final int HEIGHT = 216;

    private JLabel mUsernameField;      // username textfield
    private JPasswordField  mPasswordField; // password field
    private JPasswordField  mPasswordFieldAgain;    // password field
    private JPasswordField  mOldPasswordField; // old password
    private boolean mCanceled = true;       // exit state of the dialog
    private String  mUsername;              // username
    private String  mPassword;              // password
    private static final String PREFIX = "PASSWDDIALOG";
    private JFrame mParentFrame;
    private ResourceBundle mResource;
    private AdminConnection mAdmin;
    private JButton mOK, mCancel;


    /*==========================================================
     * constructors
     *==========================================================*/

    /**
     * @param parent parent frame
     */
    public CMSPasswordDialog(JFrame parent, AdminConnection conn, String uid) {
        super(parent, true);
        mParentFrame = parent;
        mAdmin = conn;
        mResource =
          ResourceBundle.getBundle(CMSAdminResources.class.getName());
        setTitle(mResource.getString(PREFIX+"_TITLE"));
        setLocationRelativeTo(parent);

        JPanel center = new JPanel();
        getContentPane().setLayout(new BorderLayout());
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        center.setLayout(gb);

        JPanel contentPanel = new JPanel();
        GridBagLayout gb1 = new GridBagLayout();
        contentPanel.setLayout(gb1);

        CMSAdminUtil.resetGBC(gbc);
        gbc.anchor = GridBagConstraints.NORTH;
        gbc.gridwidth = GridBagConstraints.REMAINDER;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gb.setConstraints(contentPanel, gbc);
        center.add(contentPanel);

        CMSAdminUtil.resetGBC(gbc);
        JLabel lUsername =
          new JLabel(mResource.getString(PREFIX+"_LABEL_USERID_LABEL"));
        lUsername.setToolTipText(
          mResource.getString(PREFIX+"_LABEL_USERID_TTIP"));

        mUsernameField = new JLabel(uid);


        CMSAdminUtil.addEntryField(contentPanel, lUsername, mUsernameField,
          gbc);

        CMSAdminUtil.resetGBC(gbc);
        JLabel lOldPassword=
          new JLabel(mResource.getString(PREFIX+"_LABEL_OLDPASSWORD_LABEL"));
        lOldPassword.setToolTipText(
          mResource.getString(PREFIX+"_LABEL_OLDPASSWORD_TTIP"));
        mOldPasswordField = new JPasswordField();
        mOldPasswordField.getDocument().addDocumentListener(this);
        mOldPasswordField.addMouseListener(this);
        CMSAdminUtil.addEntryField(contentPanel, lOldPassword,
          mOldPasswordField, gbc);

        CMSAdminUtil.resetGBC(gbc);
        JLabel lPassword=
          new JLabel(mResource.getString(PREFIX+"_LABEL_PASSWORD_LABEL"));
        lPassword.setToolTipText(
          mResource.getString(PREFIX+"_LABEL_PASSWORD_TTIP"));
        mPasswordField = new JPasswordField();
        mPasswordField.getDocument().addDocumentListener(this);
        mPasswordField.addMouseListener(this);
        CMSAdminUtil.addEntryField(contentPanel, lPassword, mPasswordField,
          gbc);

        CMSAdminUtil.resetGBC(gbc);
        JLabel lPasswordAgain=
          new JLabel(mResource.getString(PREFIX+"_LABEL_PASSWORD_AGAIN_LABEL"));
        lPassword.setToolTipText(
          mResource.getString(PREFIX+"_LABEL_PASSWORD_AGAIN_TTIP"));
        mPasswordFieldAgain = new JPasswordField();
        mPasswordFieldAgain.getDocument().addDocumentListener(this);
        mPasswordFieldAgain.addMouseListener(this);
        CMSAdminUtil.addEntryField(contentPanel, lPasswordAgain,
          mPasswordFieldAgain, gbc);

        JPanel actionPanel = makeActionPane();

        CMSAdminUtil.resetGBC(gbc);
        gbc.anchor = GridBagConstraints.NORTH;
        gbc.gridwidth = GridBagConstraints.REMAINDER;
        gbc.gridheight = GridBagConstraints.REMAINDER;
        gbc.weightx = 1.0;
        gb.setConstraints(actionPanel, gbc);
        center.add(actionPanel);

        getContentPane().add("Center",center);

        mCanceled=false;
        mUsername="";
        mPassword="";

        setSize( WIDTH, HEIGHT );
        this.setVisible(true);

        /* Cancel if the window is closed */
        addWindowListener(
            new WindowAdapter() {
                @Override
                public void windowClosing(WindowEvent e) {
                    dispose();
                    mCanceled = true;
                }
            }
        );
    }

    /*==========================================================
     * public methods
     *==========================================================*/

    /**
     *  return the exit status of the dialog
     *
     * @return true if the user hits the cancel button.
     */
    public boolean isCancel() {
        return mCanceled;
    }

    /**
     *  Returns the username typed in by the user, on OK.
     *
     * @return The selected username, if the user hits the OK button.
     */
    public String getUsername() {
        return mUsername;
    }

    /**
     *  Return the password typed in by the user, on OK.
     *
     * @return The selected password, if the user hits the OK button.
     */
    public String getPassword() {
        return mPassword;
    }


    /*==========================================================
     * EVNET HANDLER METHODS
     *==========================================================*/

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource().equals(mOK)) {
            String userid = mUsernameField.getText().trim();
            String oldpassword = mOldPasswordField.getText().trim();
            String newpassword = mPasswordField.getText().trim();
            String passwordAgain = mPasswordFieldAgain.getText().trim();

            /* PROACTIVE VERIFICATION
            if (oldpassword.equals("") || newpassword.equals("") ||
              passwordAgain.equals("")) {
                CMSAdminUtil.showMessageDialog(mParentFrame, mResource,
                  PREFIX, "EMPTYFIELD", CMSAdminUtil.ERROR_MESSAGE);
                return;
            }
            */
           if (!newpassword.equals(passwordAgain)) {
                CMSAdminUtil.showMessageDialog(mParentFrame, mResource,
                  PREFIX, "CONFIRMED", CMSAdminUtil.ERROR_MESSAGE);
                return;
            }


            NameValuePairs nvps = new NameValuePairs();
            nvps.put(Constants.PR_OLD_AGENT_PWD, oldpassword);
            nvps.put(Constants.PR_AGENT_PWD, newpassword);

            try {
                mAdmin.modify(DestDef.DEST_KRA_ADMIN,
                  ScopeDef.SC_AGENT_PWD, userid, nvps);
            } catch (EAdminException ex) {
                CMSAdminUtil.showErrorDialog(mParentFrame, mResource,
                  ex.getMessage(), CMSAdminUtil.ERROR_MESSAGE);
                if (!ex.getMessage().equals("Server Error"))
                    return;
            }

            mCanceled = false;
            this.dispose();
            return;
        }
        if (evt.getSource().equals(mCancel)) {
            //setVisible(false);
            mCanceled = true;
            this.dispose();
            return;
        }
    }


    //== DocumentListener ==
    @Override
    public void insertUpdate(DocumentEvent e) {
        setButtons();
    }

    @Override
    public void removeUpdate(DocumentEvent e){
        setButtons();
    }

    @Override
    public void changedUpdate(DocumentEvent e){
        setButtons();
    }

    //==== MOUSELISTENER ======================
    @Override
    public void mouseClicked(MouseEvent e) {
        setButtons();
    }

    @Override
    public void mousePressed(MouseEvent e) {}
    @Override
    public void mouseReleased(MouseEvent e) {}
    @Override
    public void mouseEntered(MouseEvent e) {}
    @Override
    public void mouseExited(MouseEvent e) {
        setButtons();
    }


    /*==========================================================
     * private methods
     *==========================================================*/

    private JPanel makeActionPane() {
        mOK = CMSAdminUtil.makeJButton(mResource, PREFIX, "OK", null,
          this);
        mOK.setEnabled(false);
        mCancel = CMSAdminUtil.makeJButton(mResource, PREFIX, "CANCEL",
          null, this);
        JButton[] buttons = { mOK, mCancel};
        JButtonFactory.resize( buttons );
        return CMSAdminUtil.makeJButtonPanel(buttons);
    }

    //set buttons
    private void setButtons() {
        if ( (mPasswordField.getText().trim().equals("")) ||
             (mPasswordFieldAgain.getText().trim().equals("")) ||
             (mOldPasswordField.getText().trim().equals("")) ) {
            mOK.setEnabled(false);
        } else {
            mOK.setEnabled(true);
        }
    }

}
