<!-- [metadata]>
+++
title = "Command line reference"
description = "Docker's CLI command description and usage"
keywords = ["Docker, Docker documentation, CLI,  command line"]
[menu.main]
identifier= "smn_cli"
parent = "engine_ref"
weight=-70
+++
<![end-metadata]-->



# The Docker commands

This section contains reference information on using Docker's command line client. Each command has a reference page along with samples. If you are unfamiliar with the command line, you should start by reading about how to [Use the Docker command line](cli.md).  

You start the Docker daemon with the command line. How you start the daemon affects your Docker containers. For that reason you should also make sure to read the [`daemon`](daemon.md) reference page.

### Docker management commands

* [daemon](daemon.md)
* [info](info.md)
* [inspect](inspect.md)
* [version](version.md)

### Image commands

* [build](build.md)
* [commit](commit.md)
* [export](export.md)
* [history](history.md)
* [images](images.md)
* [import](import.md)
* [load](load.md)
* [rmi](rmi.md)
* [save](save.md)
* [tag](tag.md)

### Container commands

* [attach](attach.md)
* [cp](cp.md)
* [create](create.md)
* [diff](diff.md)
* [events](events.md)
* [exec](exec.md)
* [kill](kill.md)
* [logs](logs.md)
* [pause](pause.md)
* [port](port.md)
* [ps](ps.md)
* [rename](rename.md)
* [restart](restart.md)
* [rm](rm.md)
* [run](run.md)
* [start](start.md)
* [stats](stats.md)
* [stop](stop.md)
* [top](top.md)
* [unpause](unpause.md)
* [update](update.md)
* [wait](wait.md)

### Hub and registry commands

* [login](login.md)
* [logout](logout.md)
* [pull](pull.md)
* [push](push.md)
* [search](search.md)

### Network and connectivity commands

* [network_connect](network_connect.md)
* [network_create](network_create.md)
* [network_disconnect](network_disconnect.md)
* [network_inspect](network_inspect.md)
* [network_ls](network_ls.md)
* [network_rm](network_rm.md)

### Shared data volume commands

* [volume_create](volume_create.md)
* [volume_inspect](volume_inspect.md)
* [volume_ls](volume_ls.md)
* [volume_rm](volume_rm.md)
