# -*- coding: utf-8 -*-

# Bluemindo: A really simple but powerful audio player in Python/PyGTK.
# Copyright (C) 2007-2009  Erwan Briand

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 3 of the License.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from gettext import gettext as _
from threading import Thread
from gobject import (TYPE_STRING as gString, markup_escape_text as escape,
                     timeout_add, markup_escape_text, idle_add)
from gtk.gdk import (Pixbuf as gPixbuf, threads_enter, threads_leave,
                     pixbuf_new_from_file, INTERP_BILINEAR)
from gtk import(STOCK_DIRECTORY, STOCK_CDROM, STOCK_FILE, TreeStore,
                CellRendererText, TreeViewColumn, CellRendererPixbuf,
                ICON_SIZE_MENU, ListStore)
from gtk.glade import XML as glade_XML
from os.path import join, isfile

from common.functions import Functions

from modules.explorer.playlist import Playlist
from modules.explorer.musicdb import MusicDatabase
from modules.explorer import viewscommon
unescape = viewscommon.unescape
insensitive_sort = viewscommon.insensitive_sort

class AlbumsView(object):
    ref = None
    ref2 = None

    def __new__(cls, *args, **kws):
        # Singleton
        if cls.ref is None:
            cls.ref = super(AlbumsView, cls).__new__(cls, args, kws)
        return cls.ref

    def __init__(self, glade_file, config, userconf):
        self.playlist = Playlist(glade_file, config, userconf)
        self.glade_file = glade_file
        self.config = config
        self.userconf = userconf

        self.player_data = join(self.userconf.datadir, 'modules', 'player')
        self.functions = Functions()

        # Show widget
        self.glade_file.get_widget('vbox2').show()
        self.glade_file.get_widget('vbox11').show()

        if AlbumsView.ref2 is None: 
            AlbumsView.ref2 = 42 
            self.launch()

    def launch(self):
        self.glade_file.get_widget('checkbutton1').set_active(True)

        def click(widget):
            self.reload_database()
        self.glade_file.get_widget('checkbutton1').connect('clicked', click)

        def clear_filter(widget):
            self.glade_file.get_widget('entry5').set_text('')
        self.glade_file.get_widget('button6').connect('clicked', clear_filter)

        self.glade_file.get_widget('entry5').connect('changed', self.filter_)

        # Add albums
        self.filter_widgets = []
        self.reload_database()

    def reload_database(self, force_scan=False):
        pbar = self.glade_file.get_widget('progressbar1')
        pbar.set_text(_('Opening folder…'))
        pbar.show()

        thread = Thread(group=None, target=self.insert_albums,
                        name='albums', args=(pbar, force_scan))
        self.thread_name = thread

        thread.start()

    def timeout_progress(self, pbar):
        if self.thread_name.isAlive():
            pbar.pulse()
            return True
        else:
            pbar.hide()

    def insert_albums(self, pbar, force_scan):
        """This function is called at the start-up and add artists."""
        threads_enter()

        # Call database
        musicdb = MusicDatabase(self.config, pbar)

        if self.config['scan'] or force_scan:
            musicdb.scan()

        pbar.set_text(_('Loading music…'))
        self.database = musicdb.load()

        timeout_add(100, self.timeout_progress, pbar)
        self.songs_tree = viewscommon.get_representation(self.database,
                                                        self.config['artwork'])
        self.continue_to_pulse = False

        pbar.set_text(_('Loading artists…'))
        group_artists = self.glade_file.get_widget('checkbutton1').get_active()
        self.glade_file.get_widget('checkbutton1').set_sensitive(False)
        self.glade_file.get_widget('entry5').set_sensitive(False)
        self.glade_file.get_widget('button6').set_sensitive(False)

        self.albums_tree = []
        album_names = []
        album_iter = {}

        i = 0
        for art in self.songs_tree:
            for alb in self.songs_tree[art]:
                if group_artists:
                    if alb not in album_names:
                        album_names.append(alb)
                        self.albums_tree.append({'album': alb,
                                                 'artist': [art]})
                        album_iter[alb] = i
                        i = i + 1
                    else:
                        it = album_iter[alb]
                        al = self.albums_tree[it]
                        if art not in al['artist']:
                            al['artist'].append(art)                
                else:
                    album_names.append(alb)
                    self.albums_tree.append({'album': alb, 'artist': [art]})
                    i = i + 1

        self.albums_tree.sort(insensitive_sort)

        Thread(group=None, target=self.show_albums,
               name='add_albums', args=tuple()).start()

        threads_leave()

    def show_albums(self):
        # Delete all buttons
        container = self.glade_file.get_widget('vbuttonbox1')
        for wdg in container:
            idle_add(container.remove, wdg)

        for alb in self.albums_tree:
            widgets = glade_XML(join(self.functions.datadir, 'glade',
                      'mainwindow.glade'), 'button5', domain='bluemindo')
            button = widgets.get_widget('button5')

            album_ = markup_escape_text(unicode(alb['album']))

            if len(alb['artist']) > 1:
                artist = '%d artists' % len(alb['artist'])
            else:
                artist = markup_escape_text(unicode(alb['artist'][0]))

            bdir = join(self.player_data, 'covers')
            base = join(self.functions.datadir, 'image', 'logo_head_big.png')

            if len(alb['artist']) > 1:
                for art in alb['artist']:
                    cover = join(bdir, self.functions.get_hash(album_, art))

                    if isfile(cover):
                        break
            else:
                cover = join(bdir, self.functions.get_hash(album_, artist))

            if not isfile(cover):
                icon = pixbuf_new_from_file(base)
            else:
                icon = pixbuf_new_from_file(cover)

            scaled_icon = icon.scale_simple(24, 24, INTERP_BILINEAR)

            idle_add(widgets.get_widget('image6').set_from_pixbuf, scaled_icon)
            idle_add(widgets.get_widget('label18').set_markup, '%s<b>%s</b>%s'
                     % ('<span size="small">', album_, '</span>'))
            idle_add(widgets.get_widget('label19').set_markup, '%s<i>%s</i>%s'
                     % ('<span size="small">', artist, '</span>'))

            idle_add(button.show_all)
            idle_add(container.add, button)

            self.filter_widgets.append([button, album_, alb['artist']])
            button.connect('clicked', self.click_album)

        self.filter_(self.glade_file.get_widget('entry5'))

        self.glade_file.get_widget('checkbutton1').set_sensitive(True)
        self.glade_file.get_widget('button6').set_sensitive(True)
        self.glade_file.get_widget('entry5').set_sensitive(True)
        self.glade_file.get_widget('entry5').grab_focus()

    def filter_(self, widget):
        text = widget.get_text().upper()

        for wdg in self.filter_widgets:
            if text not in wdg[1].upper():
                wdg[0].hide()
            else:
                wdg[0].show()

    def click_album(self, widget):
        for wdg in self.filter_widgets:
            if wdg[0] == widget:
                artist = eval(unescape(unicode(wdg[2])))
                album = unescape(unicode(wdg[1]))
                
                break

        group_artists = self.glade_file.get_widget('checkbutton1').get_active()
        songs = []

        if group_artists:
            for art in self.songs_tree:
                for alb in self.songs_tree[art]:
                    if alb == album:
                        for sg in self.songs_tree[art][alb]:
                            songs.append(sg)
        else:
            for sg in self.songs_tree[artist[0]][str(album)]:
                songs.append(sg)

        if len(songs) > 0:
            songs.sort(lambda x,y:cmp(x[6], y[6]))
            self.playlist.add_songs(songs, False)