/*
 * Generic triangular board representation
 * Header file
 * ---------------------------------------------------------------------------
 * $Id: triboard.h,v 1.7 2003/03/17 15:00:49 hsteoh Exp hsteoh $
 *
 * Assumptions:
 * - odd rows are always shifted 1/2 position right relative to even rows.
 *   - it's up to rendering routines to use the appropriate amount of space
 *     between cells so that the vertices come out as equilateral triangles.
 */

#ifndef TRIBOARD_H
#define TRIBOARD_H

typedef char celltype;
#define BAD_CELL	'\0'
#define EMPTY_CELL	' '

class triboard {
  unsigned int wd,ht;			// board dimensions
  int ox, oy;				// origin (unused, currently always
					// (0,0))
  celltype *board;			// (wd*ht) array
  int cells_left;			// number of empty cells left

  void copy(triboard &b);
public:
  triboard(unsigned int width, unsigned int height);
  triboard(triboard &b) { copy(b); }
  triboard &operator= (triboard &b);
  virtual ~triboard();

  // Returns BAD_CELL if no such cell
  celltype getcell(int x, int y);

  // Currently ignores bad coors; ideally, should auto-extend board? Just a
  // thought... we probably want to outlaw that unless we're sure we want
  // infinitely-extendible game boards :-)
  void setcell(int x, int y, celltype cell);

  // Returns neighbour of cell in given direction. BAD_CELL if none exists.
  // Directions are 0..5; starting on the upperleft neighbour and rotating
  // clockwise.
  celltype ngbr_of(int x, int y, int dir);

  // Compute coordinates of neighbouring cell. Returns 1 if OK, 0 if
  // bad starting coors or bad direction. It is safe for (nx,ny) to be
  // the same physical variables as (x,y).
  int ngbr_coor(int x, int y, int dir, int &nx, int &ny);

  // Returns 1 if board is full, 0 otherwise.
  int is_full() { return cells_left<=0; }

  // == for (each cell x) { f(x); }
  // Used mainly for rendering game board to screen.
  // For the sake of simplicity, this is guaranteed to traverse the board
  // row by row from top down, going left to right on each row.
  void mapcell(void (*f)(int x, int y, celltype cell, void *context),
               void *context);

  unsigned int width() { return wd; }
  unsigned int height() { return ht; }

  // Fill board with EMPTY_CELL
  void clear();
};


#endif // TRIBOARD_H
