# Contributors to OpenRCT2
Includes all git commit authors. Aliases are GitHub usernames or community nicknames.

## Development team
* Ted John (IntelOrca) - Project Founder - Programming
* Duncan Frost (duncanspumpkin) - Programming
* Michał Janiszewski (janisozaur) - Programming
* Hielke Morsink (Broxzier) - Programming
* Tulio Paschoalin Leao (tupaschoal) - Programming
* Olivier Wervers (Oli414) - Lead OpenGraphics - Programming
* Matthias Moninger (ZehMatt) - Programming
* Karst van Galen Last (AuraSpecs) - Lead OpenSoundEffects & OpenMusic
* Michael Bernardi (mrmbernardi) - Programming
* Michael Steenbeek (Gymnasiast) - Lead Localisation - Programming
* Aaron van Geffen (AaronVanGeffen) - Programming

## Support team
* Kenton Boadway (Krutonium) - Lead OpenScenarios

## Former development team members
* Lewis Fox (LRFLEW)
* Marijn van der Werf (marijnvdwerf)
* (zsilencer)
* Richard Jenkins (rwjuk)
* Rik Smeets (rik-smeets)

## Long term contributors
Appreciation for long term contributors to the project having provided substantial work.
* Edward Calver (X7123M3-256)
* Kelson Blakewood (spacek531)
* (frutiemax)

## Special Thanks
Appreciation for contributors who have provided substantial work, but are no longer active.
* Joe Minor Jr (wolfreak99)
* Matte Andersson (Nubbie)

## Implementation (RCT2)
* Ted John (IntelOrca)
* Duncan Frost (duncanspumpkin)
* Peter Hill (ZedThree) - String handling, misc.
* (qcz) - Scenery window, misc.
* Matthias Lanzinger (lnz) - Climate, finance, scenario, ride reachability
* (zsilencer) - Audio, multiplayer, misc.
* (DutchRPW) - peep_update_days_in_queue, misc. money-related functions
* Adrian Wielgosik (adrian17) - Ride window, top toolbar, map window, misc.
* (hexdec) - Music credits window, staff window, misc.
* Dennis Devriendt (ddevrien) - Banner window, map window, options window
* Maciek Baron (MaciekBaron) - Peep enums, item flags, misc.
* (Hual) - Minimap window resizing; address identification; sub_6C0C3F.
* (AngeloG) - Scrollbar input, misc.
* (jcdavis) - Misc.
* (marcotc) - Rain drawing, misc.
* (vanderkleij) - create_sprite, move_sprite_to_list
* Ben Pye (benpye) - Logo rendering on title screen
* (JeroenSack) - widget_scroll_get_part, misc.
* Sijmen Schoon (SijmenSchoon) - redraw_peep_and_rain, misc bugfixes.
* Lewis Fox (LRFLEW) - sub_69A997, OpenGL support, macOS
* Marijn van der Werf (marijnvdwerf) - Peep functions, drawing and paint code
* Nicolas Espinosa Mooser (Nicolas-EM) - staff window refactor

## Additional implementation (OpenRCT2)
* (atmaxinger) - User configuration
* (anyc) - Housecleaning, cross-platform fixes
* Michael Steenbeek (Gymnasiast) - Cheats, RCT1 ride style, misc.
* Miso Zmiric (mzmiric5) - Old Twitch integration, misc.
* Inseok Lee (dlunch) - Load save files from command line
* Jørn Lomax (jvlomax) - Configuration parser
* Alexander Overvoorde (Overv) - OpenGL improvements, Steam overlay detection, various bugfixes.
* (eezstreet) - Add finances button to toolbar, various bugfixes.
* Hielke Morsink (Broxzier) - Tile inspector, heightmap loader, misc.
* Joe Minor Jr (wolfreak99) - Various cheats, bugfixes, new About and Changelog windows.
* Thomas den Hollander (ThomasdenH) - Dithering in sprite importer, invert viewport dragging, park rating cheats misc.
* James Robertson (rd3k) - Initial tile inspector, misc changes.
* Robert Jordan (trigger-death) - UI theming, title sequence editor, misc.
* Aaron van Geffen (AaronVanGeffen) - scenario select screen, font detection, misc.
* Michał Janiszewski (janisozaur) - Linux port, crash handling, security, misc.
* Kelson Blakewood (spacek531) - title sequences, title sequence features, vehicle features
* Hugo Wallenburg (Goddesen) - Misc.
* Edward Calver (X7123M3-256) - New Hybrid Coaster track, extended sprite toolchain, more vehicle cheats, misc.
* Matte Andersson (Nubbie) - Misc, UX
* Daniel Trujillo Viedma (gDanix) - Custom currency.
* (zaxcav) - Improvements to original pathfinding algorithm.
* Jeroen D. Stout (JeroenDStout) - Light effects, train crossings, virtual floor.
* Matthias Moninger (ZehMatt) - Game actions, multiplayer synchronisation, misc.
* Joël Troch (JoelTroch) - Keyboard shortcuts for ride construction.
* Thomas Delebo (delebota) - Server descriptions and greetings.
* Richard Jenkins (rwjuk) - Path issues overlay, console improvements, bug fixes
* Brian Callahan (ibara) - OpenBSD port.
* Jens Heuseveldt (jensj12) - Mountain tool improvements, misc.
* Park Joon-Kyu (segfault87) - Allow filtering guests by name
* Harrison Gentry (hgentry) - Date-changing command, misc.
* Joshua Moerman (Jaxan) - Minimap cleanup, misc.
* Nicolas Hawrysh (xp4xbox) - Various (ride) sprite improvements.
* Albert Morgese (Fusxfaranto) - Shop auto-rotation, unicode uppercasing.
* Olivier Wervers (oli414) - Remove unused objects command, various bugfixes
* Christian Schubert (Osmodium) - Ensuring custom user content folders, incl. open folder.
* (Xkeeper0) - Improved banner tooltips; multiplayer status in toolbar.
* Kevin Strehl (bitman2049) - Tile inspector keybindings
* Anton Scharnowski (scrapes) - Added Scenery Scatter Options Window.
* Chad Ian Anderson (pizza2004) - Added New Game option, bug fixes, misc.
* Peter Ryszkiewicz (pRizz) - Added horizontal grid lines to finance charts.
* Hudson Oliveira (hdpoliveira) - Misc.
* Jim Verheijde (Jimver) - Make handymen less likely to get stuck in queue lines, misc.
* Helio Batimarqui (batimarqui) - Misc.
* Keith Stellyes (keithstellyes) - Misc.
* Bas Cantrijn (Basssiiie) - Various plugin additions, misc.
* Adrian Zdanowicz (CookiePLMonster) - Misc.
* Andrew Pratt (andrewpratt64) - Added api hook for vehicle crashes, api function to get entities on a tile
* Karst van Galen Last (AuraSpecs) - Ride paint (bounding boxes, extra track pieces), soundtrack, sound effects, misc.
* (8street) - Misc.
* Umar Ahmed (umar-ahmed) - MacOS file watcher
* Andrew Arnold (fidwell) - Misc.
* Josh Trzebiatowski (trzejos) - Ride and scenery filtering
* (kyphii) - Extended color selection, reversed ride vehicles, misc.
* Phumdol Lookthipnapha (beam41) - Misc.
* Nikolas Parshook (nparshook) - Misc.
* Wenzhao Qiu (qwzhaox) - Misc.
* Tiago Reul (reul) - Misc.
* Fredrik Tegnell (fredriktegnell) - Misc.
* Alex Parisi (alex-parisi) - Added API for returning metadata from all registered plugins.
* Arnold Zhou (mrmagic2020) - Various plugin additions, new game option, misc.
* John Dolph (johnwdolph) - Ride music UI, misc.

## Bug fixes & Refactors
* Claudio Tiecher (janclod)
* (KirilAngelov)
* (halfbro)
* (Myrtle)
* (nean)
* Ed Foley (e-foley)
* Michael Pham (nightroan)
* Lucas Riutzel (jackinloadup)
* Youngjae Yu (YJSoft)
* Chanwoong Kim (kexplo)
* Josué Acevedo (Wirlie)
* Martin Černáč (octaroot)
* (marcovmun)
* Sven Slootweg (joepie91)
* Daniel Trujillo Viedma (gDanix)
* Niels NTG Poldervaart (Niels-NTG) - Screenshot filenames
* Jonathan Haas (HaasJona)
* Jake Breen (Haekb)
* Marco Benzi Tobar (Lisergishnu)
* (ceeac)
* Tomas Dittmann (Chaosmeister)
* William Wallace (Willox)
* Christian Friedrich Coors (ccoors)
* Robbin Voortman (rvoortman)
* Willem J. Lee (telk5093)
* Ethan Smith (ethanhs) - Refactor MAX_PATH
* Robert Lewicki (rlewicki)
* Liam Parker (elInfidel)
* Tyler Ruckinger (TyPR124)
* Justin Gottula (jgottula)
* Seongsik Park (pss9205)
* (Deurklink)
* Nathan Zabriskie (NathanZabriskie)
* Toby Hinloopen (tobyhinloopen)
* Patrick Martinez (martip23)
* Andy Ford (AndyTWF)
* Matthew Beaudin (mattbeaudin)
* Øystein Dale (oystedal)
* Christian Schubert (Osmodium)
* James Lord (RCTMASTA)
* Brian Massino (Nazey), Lauren Watson (lwatson2016), Jason Myre (jmyre1999), Nicole Wright (nicolewright), Josh Tucker (joshtucker132)
* Hussein Okasha (Hokasha2016), Brandon Dupree (Bdupree5), Zetao Ye (ZbrettonYe), Jordan Arevalos (Jarevalos2017)
* Florian Will (w-flo)
* Trevor Harkness (tharkne), Steve Xu (stevexu-umich)
* (aw20368)
* Jim Armstrong (41northstudios)
* Kenny Castro-Monroy (kennycastro007)
* Joseph Atkins-Turkish (Spacerat)
* Denis Khabenkov (kodmord)
* Kevin Laframboise (klaframboise)
* Tushar Sariya (TusharSariya)
* (WantDiscussion)
* Tomáš Žilínek (TomasZilinek)
* Mustapha Elghoul (mustaphaelghoul)
* Tyler Leamon (tylerleamon)
* Michael Coates (outerwear)
* Reid Baris (Rdbaris)
* Deanna Baris (dbaris)
* Chaitanya Thengdi (chaitanyathengdi)
* Sidney Kuyateh (autinerd)
* Łukasz Pękalski (Lukasz-Pe)
* (quale)
* Arran Ireland (ion232)
* Ryan Bello (ryan-bello)
* Simon Jarrett (mwnciau)
* Richard Fine (richard-fine)
* Tom Parsons (tombomp)
* Stephan Spengler (Sadret)
* Roger Seekell (rpstester)
* Ben Johnston (gsckoco)
* (evilclownattack)
* Adam Bloom (adam-bloom)
* Geoff B. (geoff-B)
* Ryan D. (rctdude2)
* (zrowny)
* Emre Aydin (aemreaydin)
* Daniel Karandikar (DKarandikar)
* Struan Clark (xtruan)
* Kane Shaw (seifer7)
* Saad Rehman (SaadRehmanCS)
* (ocalhoun6)
* Sean Payne (seanmajorpayne)
* Soham Roy (sohamroy19)
* Gaven Rendell (Rendello)
* Christian Haase (chrhaase)
* Cory Sanin (CorySanin)
* Vinícius Hashimoto (vkhashimoto)
* Gal B. (GalBr)
* Rik Smeets (rik-smeets)
* Charles Machalow (csm10495)
* Alexander Czarnecki (alcz/zuczek4793)
* Lawrence De Mol (lawrencedemol)
* Erik Wouters (EWouters)
* Hoby R. (hobyr)
* Huu Kim Nguyen (CoderUndefined)
* Henry Cheng (jazzysoggy)
* Dan Stevens (MajeureX)
* 73 (733737)
* Raymond Zhao (rzhao271)
* Xixiang Chen (jacknull1991)
* (ReticulatingSplines)
* Conrad Cash (HouseholdVTuber)
* Michael Bickerton (mdbckrtn)
* Nehemiah Negussie (nehemiah-negussie)
* Severin Paul Höfer (zzril)
* Ernest Elgin (eaeiv)
* Ernest Wong (ErnWong)
* Joel H. (HtotheTML)
* John Mulcahy (jayjay300)
* Chase Percy (Chase-Percy)
* Wenzhao Qiu (qwzhaox)
* Michael Bernardi (mrmbernardi)
* Aram Kazorian (aramk-hub)
* Harry Hopkinson (Harry-Hopkinson)
* Jan Kelemen (jan-kelemen)
* Cory Ye (CoryfY)
* Karsten Van Fossan (karstenvanf)
* Kaavya Ramachandhran (ayvaak)
* Mike Harvey (harvito)
* Robert Yan (lewyche)

## Toolchain
* (Balletie) - macOS
* Kevin Burke (kevinburke) - macOS, Unix
* Miso Zmiric (mzmiric5) - Initial macOS toolchain
* Jarno Veuger (JarnoVgr) - Windows build server
* Ted John (IntelOrca) - Windows
* Michał Janiszewski (janisozaur) - Linux, Travis CI
* Lewis Fox (LRFLEW) - macOS
* Andrew Rimpici (Andy608) - macOS
* Adam Bloom (adam-bloom) - macOS, CI

## Documentation
* (honzi)
* Kevin Burke (kevinburke)
* James Robertson (rd3k)
* Max Boße (MakaHost)
* (MaxBareiss)
* Mithun Hunsur (Philpax)
* (RollingStar)
* (That Human Being)

## Translation
* Extracting from original files: Ted John (IntelOrca)
* Reviewing and merging: Michael Steenbeek (Gymnasiast), Matte Andersson (Nubbie), Rune Laenen (runelaenen) (formerly)
* Fixing unmaintained languages: Michael Steenbeek (Gymnasiast)
* Miscellaneous fixes: Alexander Overvoorde (Overv), Ed Foley (e-foley)

* English (UK) - Ted John (IntelOrca), (Tinytimrob)
* English (US) - Ted John (IntelOrca), Michael Steenbeek (Gymnasiast); small fixes: (LRFLEW), (mike-koch), Harry Lam (daihakken)
* Catalan - Joan Josep (J0anJosep)
* Chinese (Simplified) - Naiji Ma (naijim), (izhangfei), Eric Zhao (sczyh30), (Muhhan), Arnold Zhou (mrmagic2020)
* Chinese (Traditional) - Harry Lam (daihakken)
* Czech - Martin Černáč (octaroot), (Clonewayx), Tomáš Pazdiora (Aroidzap)
* Danish - Lars P. Sørensen (LPSGizmo)
* Dutch - Michael Steenbeek (Gymnasiast), Yannic Geurts (xzbobzx), (mrtnptrs), Thomas den Hollander (ThomasdenH), (hostbrute),  Marijn van der Werf (marijnvdwerf), Tom Kroes (ThePsionic), Karst van Galen Last (AuraSpecs); reviewing and discussion: Aaron van Geffen (AaronVanGeffen), (Balletie) and Sijmen Schoon (SijmenSchoon)
* Esperanto - (tellovishous), Raymond Zhao (rzhao271)
* Finnish - (DJHasis), (Zode), (TheWing)
* French - (fbourigault), Joël Troch (JoelTroch), Michael Steenbeek (Gymnasiast), Romain Vigier (rmnvgr), (AziasYur), Hugo Courtial (s0r00t), David Delobel (incyclum), Nicolas Hawrysh (xp4xbox)
* German - (danidoedel), (atmaxinger), (Yepoleb), Daniel Kessel (dkessel), Leon (AllGoodNamesAreTaken), (raidcookie), Gilian Rehm (gr33ndev)
* Italian - Luca Andrea Rossi (LucaRed), Precious Ugo Abara (48cfu)
* Japanese - Aaron van Geffen (AaronVanGeffen), Haruna Chinzei, Nick Hall (nickhall), (jhako), Harry Lam (daihakken)
* Korean - Willem J. Lee (telk5093), (NeverDruid); small fixes: (kexplo)
* Norwegian - Hugo Wallenburg (Goddesen)
* Polish - Adrian Wielgosik (adrian17), (lopezloo), Michał Janiszewski (janisozaur)
* Portuguese (BR) - (kaudy), (renansimoes), Tulio Paschoalin Leao (tupaschoal)
* Russian - (Soosisya)
* Spanish - Josué Acevedo (Wirlie), Diego Mateos (dimateos), (frenchiveruti), (mdtrooper), Daniel Trujillo Viedma (gDanix); small fixes: (teapartycthulu)
* Swedish - (Jinxit), (mharrys), (Slimeyo), Matte Andersson (Nubbie)
* Ukrainian - (CsyeCokTheSolly), (Veydzher), (Saba4ara)

## Graphics
* Yannic Geurts (xzbobzx) - OpenRCT2 Logo
* Nicolas Hawrysh (xp4xbox) - Booster Sprites Twister, Giga, Mini, Woodie
* Michael Steenbeek (Gymnasiast) - Extended fontset
* Olivier Wervers (Oli414) - Several icons
* Edward Calver (X7123M3-256) - Hybrid RC track & train, Single Rail RC track & train, Alpine RC track & vehicle, LIM RC extended trackset, Giga RC extended trackset
* Karst van Galen Last (AuraSpecs) - Steep log flume, Inverted RC Booster, Giga RC powered lift
* Martijn Kroese (MK98) - Diagonal brakes project
* Peter van den Berg (Recurious) - Diagonal brakes project
* Joshua Jacobs - OpenGraphics Spooky Theme

## Music
* Karst "Jalmaan" van Galen Last (AuraSpecs)
* (Flyxxpy)
* Jan Büchner (Greyfade)
* Allister Brimble - OpenRCT2 Main Theme
* Herman Riddering - Owner of the 35er Voigt, which provided new recordings for the Fairground organ styles.
* (Skyshard)
* (Blackend Blue)
* Andrew Sinclair (Approaching Nirvana) - Progressive style

## Sound Effects
* Karst van Galen Last (AuraSpecs)
* (ThatGuyYouKnow)

## RollerCoaster Tycoon 2 credits
* Allister Brimble - Music and sound effects
* Chris Sawyer - Programming
* David Ellis - Additional sound effects
* Jacqui Lyons (Marjacq Ltd.) - Representation
* Simon Foster - Graphics

Thanks to: Peter James Adcock, Joe Booth, and John Wardley

Licensed to Infogrames Interactive Inc.
