/*###############################################################################
# Linux Management Providers (LMP), Power Management provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "OpenDRIM_PowerManagementServiceAccess.h"

const string systemCreationClassName = "OpenDRIM_ComputerSystem";
const string creationClassName = "OpenDRIM_PowerManagementService";
const string Name="ACPI";
const string elementName="Advanced Configuration and Power Interface";
bool acpi_available;

int PowerManagement_OpenDRIM_PowerManagementService_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	string output;
	CF_assert(CF_runCommandFL("acpi_available && echo yes",output,errorMessage));
	acpi_available=(output=="yes");
	_L_;
	return OK;
}

int PowerManagement_OpenDRIM_PowerManagementService_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int PowerManagement_OpenDRIM_PowerManagementService_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_PowerManagementService>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	if(!acpi_available)
		return OK;
	
	//Initialize an instance
	OpenDRIM_PowerManagementService instance;
	instance.setSystemCreationClassName(systemCreationClassName);
	instance.setCreationClassName(creationClassName);
	instance.setName(Name);
	
	if (discriminant == "ei")
		CF_assert(PowerManagement_OpenDRIM_PowerManagementService_populate(instance, errorMessage));
	
	result.push_back(instance);
	_L_;
	return OK;
}

int PowerManagement_OpenDRIM_PowerManagementService_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_PowerManagementService& instance, const char** properties, string& errorMessage) {
	_E_;
	if (instance.SystemCreationClassName != systemCreationClassName ||
			instance.CreationClassName != creationClassName ||
			instance.Name != Name ||
			!acpi_available)
	{
		errorMessage = "No instance";
		return NOT_FOUND;
	}
	
	CF_assert(PowerManagement_OpenDRIM_PowerManagementService_populate(instance, errorMessage));
	_L_;
	return OK;
}

int PowerManagement_OpenDRIM_PowerManagementService_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerManagementService& newInstance, const OpenDRIM_PowerManagementService& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PowerManagement_OpenDRIM_PowerManagementService_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerManagementService& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PowerManagement_OpenDRIM_PowerManagementService_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerManagementService& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PowerManagement_OpenDRIM_PowerManagementService_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerManagementService& instance, unsigned int& returnValue, const OpenDRIM_PowerManagementService_RequestStateChange_In& in, OpenDRIM_PowerManagementService_RequestStateChange_Out& out, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PowerManagement_OpenDRIM_PowerManagementService_StartService(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerManagementService& instance, unsigned int& returnValue, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PowerManagement_OpenDRIM_PowerManagementService_StopService(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerManagementService& instance, unsigned int& returnValue, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PowerManagement_OpenDRIM_PowerManagementService_SetPowerState(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerManagementService& instance, unsigned int& returnValue, const OpenDRIM_PowerManagementService_SetPowerState_In& in, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PowerManagement_OpenDRIM_PowerManagementService_RequestPowerStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerManagementService& instance, unsigned int& returnValue, const OpenDRIM_PowerManagementService_RequestPowerStateChange_In& in, OpenDRIM_PowerManagementService_RequestPowerStateChange_Out& out, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PowerManagement_OpenDRIM_PowerManagementService_populate(OpenDRIM_PowerManagementService& instance, string& errorMessage) {
	_E_;
	instance.setElementName(elementName);
	_L_;
	return OK;
}

