/* Generated by re2c 4.0.2 */
#line 1 "../src/parse/conf_lexer.re"
#include <stdint.h>
#include <string>
#include <vector>

#include "src/encoding/enc.h"
#include "src/msg/msg.h"
#include "src/options/opt.h"
#include "src/parse/ast.h"
#include "src/parse/conf_parser.h"
#include "src/parse/input.h"
#include "src/util/file_utils.h"
#include "src/util/string_utils.h"

namespace re2c {

#line 19 "src/parse/conf_lexer.cc"
size_t LexerState::maxfill_conf() { return 32; }
#line 16 "../src/parse/conf_lexer.re"


#define YYFILL(n) do { \
    if (!fill(n)) { \
        RET_FAIL(error_at_cur("unexpected end of input in configuration")); \
    } \
} while(0)

// Immutable options are only allowed in syntax files.
#define SETCONOPT(opt, val) do { \
    if (!in_syntax_file) { \
        RET_FAIL(error_at_cur("this configuration is only allowed in syntax files")); \
    } \
    const_cast<conopt_t&>(opts.glob).init_##opt(val); \
} while (0)

// In syntax file mode do not overwrite user-defined options.
#define SETOPT(opt, val) do { \
    if (in_syntax_file) { \
        opts.init_##opt(val); \
    } else { \
        opts.set_##opt(val); \
    } \
} while (0)

#define RET_CONF_BOOL(conf) do { \
    CHECK_RET(lex_conf_bool(opts)); \
    SETOPT(conf, tmp_bool); \
    return Ret::OK; \
} while(0)

#define RET_STXCONF_BOOL(conf) do { \
    CHECK_RET(lex_conf_bool(opts)); \
    SETCONOPT(conf, tmp_bool); \
    return Ret::OK; \
} while(0)

#define RET_CONF_FEAT(conf, name) do { \
    CHECK_RET(lex_conf_bool(opts)); \
    if (tmp_bool && !opts.glob.supported_features_contains(name)) { \
        RET_FAIL(error_at_cur("`%s` feature is not supported for this backend", name)); \
    } \
    SETOPT(conf, tmp_bool); \
    return Ret::OK; \
} while(0)

#define RET_CONF_STR(conf) do { \
    CHECK_RET(lex_conf_string(opts)); \
    SETOPT(conf, tmp_str); \
    return Ret::OK; \
} while(0)

#define RET_CONF_CODE(conf) do { \
    CHECK_RET(lex_conf_code(opts)); \
    SETOPT(conf, tmp_code); \
    return Ret::OK; \
} while(0)

#define RET_CONF_ENC(enc) do { \
    CHECK_RET(lex_conf_bool(opts)); \
    if (in_syntax_file) { \
        opts.init_encoding(enc, tmp_bool); \
    } else { \
        opts.set_encoding(enc, tmp_bool); \
    } \
    return Ret::OK; \
} while(0)

#define RET_CONF_NUM_NONNEG(conf) do { \
    CHECK_RET(lex_conf_number(opts)); \
    if (tmp_num < 0) RET_FAIL(error_at_cur("expected nonnegative value in configuration")); \
    SETOPT(conf, static_cast<uint32_t>(tmp_num)); \
    return Ret::OK; \
} while(0)

#define RET_CONF_EOF(conf) do { \
    CHECK_RET(lex_conf_number(opts)); \
    SETOPT(conf, tmp_num < 0 ? NOEOF : static_cast<uint32_t>(tmp_num)); \
    return Ret::OK; \
} while(0)

#line 113 "../src/parse/conf_lexer.re"


Ret Input::lex_conf(Opt& opts) {

#line 108 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[256] = {
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,  64,   0,   0,   0,  64,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		 64,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,  32,   0,   0,
		160, 160, 160, 160, 160, 160, 160, 160,
		160, 160,  32,   0,   0,   0,   0,   0,
		  0,  32,  32,  32,  32,  32,  32,  32,
		 32,  32,  32,  32,  32,  32,  32,  32,
		 32,  32,  32,  32,  32,  32,  32,  32,
		 32,  32,  32,   0,   0,   0,   0,  32,
		  0,  32,  32,  32,  32,  32,  32,  32,
		 32,  32,  32,  32,  32,  32,  32,  32,
		 32,  32,  32,  32,  32,  32,  32,  32,
		 32,  32,  32,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0
	};
	if ((lim - cur) < 28) YYFILL(28);
	yych = *cur;
	switch (yych) {
		case '-':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case ':':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Z':
		case '_':
		case 'g':
		case 'j':
		case 'k':
		case 'o':
		case 'q':
		case 'r':
		case 'w':
		case 'x':
		case 'z': goto yy2;
		case 'Y': goto yy4;
		case 'a': goto yy5;
		case 'b': goto yy6;
		case 'c': goto yy7;
		case 'd': goto yy8;
		case 'e': goto yy9;
		case 'f': goto yy10;
		case 'h': goto yy11;
		case 'i': goto yy12;
		case 'l': goto yy13;
		case 'm': goto yy14;
		case 'n': goto yy15;
		case 'p': goto yy16;
		case 's': goto yy17;
		case 't': goto yy18;
		case 'u': goto yy19;
		case 'v': goto yy20;
		case 'y': goto yy21;
		default: goto yy1;
	}
yy1:
#line 300 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_tok(
                "unrecognized configuration '%.*s'", static_cast<int>(cur - tok), tok));
    }
#line 222 "src/parse/conf_lexer.cc"
yy2:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
yy3:
	if (yybm[0+yych] & 32) goto yy2;
	goto yy1;
yy4:
	yych = *++cur;
	if (yych == 'Y') goto yy22;
	goto yy3;
yy5:
	yych = *++cur;
	if (yych == 'p') goto yy23;
	goto yy3;
yy6:
	yych = *++cur;
	if (yych == 'i') goto yy24;
	goto yy3;
yy7:
	yych = *++cur;
	if (yych <= 'f') {
		if (yych == 'a') goto yy25;
		goto yy3;
	} else {
		if (yych <= 'g') goto yy26;
		if (yych == 'o') goto yy27;
		goto yy3;
	}
yy8:
	yych = *++cur;
	if (yych == 'a') goto yy28;
	if (yych == 'e') goto yy29;
	goto yy3;
yy9:
	yych = *++cur;
	if (yych <= 'l') goto yy3;
	if (yych <= 'm') goto yy30;
	if (yych <= 'n') goto yy31;
	if (yych <= 'o') goto yy32;
	goto yy3;
yy10:
	yych = *++cur;
	if (yych == 'l') goto yy33;
	goto yy3;
yy11:
	yych = *++cur;
	if (yych == 'e') goto yy34;
	goto yy3;
yy12:
	yych = *++cur;
	if (yych == 'n') goto yy35;
	goto yy3;
yy13:
	yych = *++cur;
	if (yych <= 'd') {
		if (yych == 'a') goto yy36;
		goto yy3;
	} else {
		if (yych <= 'e') goto yy37;
		if (yych == 'i') goto yy38;
		goto yy3;
	}
yy14:
	yych = *++cur;
	if (yych == 'o') goto yy39;
	goto yy3;
yy15:
	yych = *++cur;
	if (yych == 'e') goto yy40;
	goto yy3;
yy16:
	yych = *++cur;
	if (yych == 'o') goto yy41;
	goto yy3;
yy17:
	yych = *++cur;
	if (yych == 'e') goto yy42;
	if (yych == 't') goto yy43;
	goto yy3;
yy18:
	yych = *++cur;
	if (yych == 'a') goto yy44;
	goto yy3;
yy19:
	yych = *++cur;
	if (yych == 'n') goto yy45;
	goto yy3;
yy20:
	yych = *++cur;
	if (yych == 'a') goto yy46;
	if (yych == 'e') goto yy47;
	goto yy3;
yy21:
	yych = *++cur;
	if (yych == 'y') goto yy48;
	goto yy3;
yy22:
	yych = *++cur;
	switch (yych) {
		case 'B': goto yy49;
		case 'C': goto yy50;
		case 'D': goto yy51;
		case 'F': goto yy52;
		case 'G': goto yy53;
		case 'I': goto yy54;
		case 'L': goto yy55;
		case 'M': goto yy56;
		case 'P': goto yy57;
		case 'R': goto yy58;
		case 'S': goto yy59;
		default: goto yy3;
	}
yy23:
	yych = *++cur;
	if (yych == 'i') goto yy60;
	goto yy3;
yy24:
	yych = *++cur;
	if (yych == 't') goto yy62;
	goto yy3;
yy25:
	yych = *++cur;
	if (yych == 'p') goto yy63;
	if (yych == 's') goto yy64;
	goto yy3;
yy26:
	yych = *++cur;
	if (yych == 'o') goto yy65;
	goto yy3;
yy27:
	yych = *++cur;
	if (yych <= 'l') {
		if (yych == 'd') goto yy66;
		goto yy3;
	} else {
		if (yych <= 'm') goto yy67;
		if (yych <= 'n') goto yy68;
		goto yy3;
	}
yy28:
	yych = *++cur;
	if (yych == 't') goto yy69;
	goto yy3;
yy29:
	yych = *++cur;
	if (yych == 'b') goto yy70;
	if (yych == 'f') goto yy71;
	goto yy3;
yy30:
	yych = *++cur;
	if (yych == 'p') goto yy72;
	goto yy3;
yy31:
	yych = *++cur;
	if (yych == 'c') goto yy73;
	goto yy3;
yy32:
	yych = *++cur;
	if (yych == 'f') goto yy74;
	goto yy3;
yy33:
	yych = *++cur;
	if (yych == 'a') goto yy75;
	if (yych == 'e') goto yy76;
	goto yy3;
yy34:
	yych = *++cur;
	if (yych == 'a') goto yy77;
	goto yy3;
yy35:
	yych = *++cur;
	if (yych <= 'o') {
		if (yych == 'd') goto yy78;
		goto yy3;
	} else {
		if (yych <= 'p') goto yy79;
		if (yych == 'v') goto yy80;
		goto yy3;
	}
yy36:
	yych = *++cur;
	if (yych == 'b') goto yy81;
	goto yy3;
yy37:
	yych = *++cur;
	if (yych == 'f') goto yy82;
	goto yy3;
yy38:
	yych = *++cur;
	if (yych == 'n') goto yy83;
	goto yy3;
yy39:
	yych = *++cur;
	if (yych == 'n') goto yy84;
	goto yy3;
yy40:
	yych = *++cur;
	if (yych == 's') goto yy85;
	goto yy3;
yy41:
	yych = *++cur;
	if (yych == 's') goto yy86;
	goto yy3;
yy42:
	yych = *++cur;
	if (yych == 'n') goto yy87;
	goto yy3;
yy43:
	yych = *++cur;
	if (yych == 'a') goto yy88;
	if (yych == 'o') goto yy89;
	goto yy3;
yy44:
	yych = *++cur;
	if (yych == 'g') goto yy90;
	if (yych == 'r') goto yy91;
	goto yy3;
yy45:
	yych = *++cur;
	if (yych == 's') goto yy92;
	goto yy3;
yy46:
	yych = *++cur;
	if (yych == 'r') goto yy93;
	goto yy3;
yy47:
	yych = *++cur;
	if (yych == 'r') goto yy94;
	goto yy3;
yy48:
	yych = *++cur;
	switch (yych) {
		case 'a': goto yy95;
		case 'b': goto yy96;
		case 'c': goto yy97;
		case 'f': goto yy98;
		case 'n': goto yy99;
		case 'p': goto yy100;
		case 'r': goto yy101;
		case 's': goto yy102;
		case 't': goto yy103;
		default: goto yy3;
	}
yy49:
	yych = *++cur;
	if (yych == 'A') goto yy104;
	goto yy3;
yy50:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych == 'O') goto yy105;
		goto yy3;
	} else {
		if (yych <= 'T') goto yy106;
		if (yych <= 'U') goto yy107;
		goto yy3;
	}
yy51:
	yych = *++cur;
	if (yych == 'E') goto yy108;
	goto yy3;
yy52:
	yych = *++cur;
	if (yych == 'I') goto yy109;
	if (yych == 'N') goto yy110;
	goto yy3;
yy53:
	yych = *++cur;
	if (yych == 'E') goto yy111;
	goto yy3;
yy54:
	yych = *++cur;
	if (yych == 'N') goto yy112;
	goto yy3;
yy55:
	yych = *++cur;
	if (yych == 'E') goto yy113;
	if (yych == 'I') goto yy114;
	goto yy3;
yy56:
	yych = *++cur;
	if (yych == 'A') goto yy115;
	if (yych == 'T') goto yy116;
	goto yy3;
yy57:
	yych = *++cur;
	if (yych == 'E') goto yy117;
	goto yy3;
yy58:
	yych = *++cur;
	if (yych == 'E') goto yy118;
	goto yy3;
yy59:
	yych = *++cur;
	switch (yych) {
		case 'E': goto yy119;
		case 'H': goto yy120;
		case 'K': goto yy121;
		case 'T': goto yy122;
		default: goto yy3;
	}
yy60:
	yych = *++cur;
	if (yych <= '@') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy123;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy2;
			if (yych >= '_') goto yy2;
		} else {
			if (yych <= '`') goto yy61;
			if (yych <= 'z') goto yy2;
		}
	}
yy61:
#line 132 "../src/parse/conf_lexer.re"
	{ goto input; }
#line 546 "src/parse/conf_lexer.cc"
yy62:
	yych = *++cur;
	if (yych == '-') goto yy124;
	goto yy3;
yy63:
	yych = *++cur;
	if (yych == 't') goto yy125;
	goto yy3;
yy64:
	yych = *++cur;
	if (yych == 'e') goto yy126;
	goto yy3;
yy65:
	yych = *++cur;
	if (yych == 't') goto yy127;
	goto yy3;
yy66:
	yych = *++cur;
	if (yych == 'e') goto yy128;
	goto yy3;
yy67:
	yych = *++cur;
	if (yych == 'p') goto yy129;
	goto yy3;
yy68:
	yych = *++cur;
	if (yych == 'd') goto yy130;
	goto yy3;
yy69:
	yych = *++cur;
	if (yych == 'e') goto yy131;
	goto yy3;
yy70:
	yych = *++cur;
	if (yych == 'u') goto yy132;
	goto yy3;
yy71:
	yych = *++cur;
	if (yych == 'i') goto yy133;
	goto yy3;
yy72:
	yych = *++cur;
	if (yych == 't') goto yy134;
	goto yy3;
yy73:
	yych = *++cur;
	if (yych == 'o') goto yy135;
	goto yy3;
yy74:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 147 "../src/parse/conf_lexer.re"
	{ RET_CONF_EOF(fill_eof); }
#line 600 "src/parse/conf_lexer.cc"
yy75:
	yych = *++cur;
	if (yych == 'g') goto yy136;
	goto yy3;
yy76:
	yych = *++cur;
	if (yych == 'x') goto yy137;
	goto yy3;
yy77:
	yych = *++cur;
	if (yych == 'd') goto yy138;
	goto yy3;
yy78:
	yych = *++cur;
	if (yych == 'e') goto yy139;
	goto yy3;
yy79:
	yych = *++cur;
	if (yych == 'u') goto yy140;
	goto yy3;
yy80:
	yych = *++cur;
	if (yych == 'e') goto yy141;
	goto yy3;
yy81:
	yych = *++cur;
	if (yych == 'e') goto yy142;
	goto yy3;
yy82:
	yych = *++cur;
	if (yych == 't') goto yy143;
	goto yy3;
yy83:
	yych = *++cur;
	if (yych == 'e') goto yy144;
	goto yy3;
yy84:
	yych = *++cur;
	if (yych == 'a') goto yy145;
	goto yy3;
yy85:
	yych = *++cur;
	if (yych == 't') goto yy146;
	goto yy3;
yy86:
	yych = *++cur;
	if (yych == 'i') goto yy147;
	goto yy3;
yy87:
	yych = *++cur;
	if (yych == 't') goto yy148;
	goto yy3;
yy88:
	yych = *++cur;
	if (yych == 'r') goto yy149;
	if (yych == 't') goto yy150;
	goto yy3;
yy89:
	yych = *++cur;
	if (yych == 'r') goto yy151;
	goto yy3;
yy90:
	yych = *++cur;
	if (yych == 's') goto yy152;
	goto yy3;
yy91:
	yych = *++cur;
	if (yych == 'g') goto yy154;
	goto yy3;
yy92:
	yych = *++cur;
	if (yych == 'a') goto yy155;
	goto yy3;
yy93:
	yych = *++cur;
	if (yych == 'i') goto yy156;
	goto yy3;
yy94:
	yych = *++cur;
	if (yych == 'b') goto yy157;
	if (yych == 's') goto yy158;
	goto yy3;
yy95:
	yych = *++cur;
	if (yych == 'c') goto yy159;
	goto yy3;
yy96:
	yych = *++cur;
	if (yych == 'm') goto yy160;
	goto yy3;
yy97:
	yych = *++cur;
	if (yych <= 'n') {
		if (yych == 'h') goto yy162;
		goto yy3;
	} else {
		if (yych <= 'o') goto yy164;
		if (yych == 't') goto yy165;
		goto yy3;
	}
yy98:
	yych = *++cur;
	if (yych == 'i') goto yy166;
	if (yych == 'n') goto yy167;
	goto yy3;
yy99:
	yych = *++cur;
	if (yych == 'm') goto yy168;
	goto yy3;
yy100:
	yych = *++cur;
	if (yych == 'm') goto yy169;
	goto yy3;
yy101:
	yych = *++cur;
	if (yych == 'e') goto yy170;
	goto yy3;
yy102:
	yych = *++cur;
	if (yych == 't') goto yy171;
	goto yy3;
yy103:
	yych = *++cur;
	if (yych == 'a') goto yy172;
	goto yy3;
yy104:
	yych = *++cur;
	if (yych == 'C') goto yy173;
	goto yy3;
yy105:
	yych = *++cur;
	if (yych == 'N') goto yy174;
	if (yych == 'P') goto yy175;
	goto yy3;
yy106:
	yych = *++cur;
	if (yych <= 'W') goto yy3;
	if (yych <= 'X') goto yy176;
	if (yych <= 'Y') goto yy177;
	goto yy3;
yy107:
	yych = *++cur;
	if (yych == 'R') goto yy178;
	goto yy3;
yy108:
	yych = *++cur;
	if (yych == 'B') goto yy179;
	goto yy3;
yy109:
	yych = *++cur;
	if (yych == 'L') goto yy180;
	goto yy3;
yy110:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 232 "../src/parse/conf_lexer.re"
	{
        CHECK_RET(lex_conf_list(opts));
        if (tmp_list.size() < 1) {
            RET_FAIL(error_at_tok(
                "`re2c:YYFN` configuration value should be a nonempty list of strings"));
        }
        SETOPT(api_fn, tmp_list);
        return Ret::OK;
    }
#line 766 "src/parse/conf_lexer.cc"
yy111:
	yych = *++cur;
	if (yych == 'T') goto yy181;
	goto yy3;
yy112:
	yych = *++cur;
	if (yych == 'P') goto yy182;
	goto yy3;
yy113:
	yych = *++cur;
	if (yych == 'S') goto yy183;
	goto yy3;
yy114:
	yych = *++cur;
	if (yych == 'M') goto yy184;
	goto yy3;
yy115:
	yych = *++cur;
	if (yych == 'R') goto yy185;
	if (yych == 'X') goto yy186;
	goto yy3;
yy116:
	yych = *++cur;
	if (yych == 'A') goto yy187;
	goto yy3;
yy117:
	yych = *++cur;
	if (yych == 'E') goto yy188;
	goto yy3;
yy118:
	yych = *++cur;
	if (yych == 'S') goto yy189;
	goto yy3;
yy119:
	yych = *++cur;
	if (yych == 'T') goto yy190;
	goto yy3;
yy120:
	yych = *++cur;
	if (yych == 'I') goto yy191;
	goto yy3;
yy121:
	yych = *++cur;
	if (yych == 'I') goto yy192;
	goto yy3;
yy122:
	yych = *++cur;
	if (yych == 'A') goto yy193;
	goto yy3;
yy123:
	yych = *++cur;
	if (yych == 's') goto yy194;
	goto yy3;
yy124:
	yych = *++cur;
	if (yych == 'v') goto yy195;
	goto yy3;
yy125:
	yych = *++cur;
	if (yych <= 't') goto yy3;
	if (yych <= 'u') goto yy196;
	if (yych <= 'v') goto yy197;
	goto yy3;
yy126:
	yych = *++cur;
	if (yych == '-') goto yy198;
	goto yy3;
yy127:
	yych = *++cur;
	if (yych == 'o') goto yy199;
	goto yy3;
yy128:
	yych = *++cur;
	if (yych == '-') goto yy200;
	goto yy3;
yy129:
	yych = *++cur;
	if (yych == 'u') goto yy201;
	goto yy3;
yy130:
	yych = *++cur;
	if (yych <= 'e') {
		if (yych == ':') goto yy202;
		if (yych <= 'd') goto yy3;
		goto yy203;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy3;
			goto yy204;
		} else {
			if (yych == 'p') goto yy205;
			goto yy3;
		}
	}
yy131:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 122 "../src/parse/conf_lexer.re"
	{ RET_STXCONF_BOOL(date); }
#line 866 "src/parse/conf_lexer.cc"
yy132:
	yych = *++cur;
	if (yych == 'g') goto yy206;
	goto yy3;
yy133:
	yych = *++cur;
	if (yych == 'n') goto yy207;
	goto yy3;
yy134:
	yych = *++cur;
	if (yych == 'y') goto yy208;
	goto yy3;
yy135:
	yych = *++cur;
	if (yych == 'd') goto yy209;
	goto yy3;
yy136:
	yych = *++cur;
	if (yych == 's') goto yy210;
	goto yy3;
yy137:
	yych = *++cur;
	if (yych == '-') goto yy211;
	goto yy3;
yy138:
	yych = *++cur;
	if (yych == 'e') goto yy212;
	goto yy3;
yy139:
	yych = *++cur;
	if (yych == 'n') goto yy213;
	goto yy3;
yy140:
	yych = *++cur;
	if (yych == 't') goto yy214;
	goto yy3;
yy141:
	yych = *++cur;
	if (yych == 'r') goto yy215;
	goto yy3;
yy142:
	yych = *++cur;
	if (yych == 'l') goto yy216;
	goto yy3;
yy143:
	yych = *++cur;
	if (yych == 'm') goto yy217;
	goto yy3;
yy144:
	yych = *++cur;
	if (yych == '-') goto yy218;
	goto yy3;
yy145:
	yych = *++cur;
	if (yych == 'd') goto yy219;
	goto yy3;
yy146:
	yych = *++cur;
	if (yych == 'e') goto yy220;
	goto yy3;
yy147:
	yych = *++cur;
	if (yych == 'x') goto yy221;
	goto yy3;
yy148:
	yych = *++cur;
	if (yych == 'i') goto yy222;
	goto yy3;
yy149:
	yych = *++cur;
	if (yych == 't') goto yy223;
	goto yy3;
yy150:
	yych = *++cur;
	if (yych == 'e') goto yy224;
	goto yy3;
yy151:
	yych = *++cur;
	if (yych == 'a') goto yy225;
	goto yy3;
yy152:
	yych = *++cur;
	if (yych <= '@') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy226;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy2;
			if (yych >= '_') goto yy2;
		} else {
			if (yych <= '`') goto yy153;
			if (yych <= 'z') goto yy2;
		}
	}
yy153:
#line 156 "../src/parse/conf_lexer.re"
	{
        RET_CONF_BOOL(tags);
    }
#line 970 "src/parse/conf_lexer.cc"
yy154:
	yych = *++cur;
	if (yych == 'e') goto yy227;
	goto yy3;
yy155:
	yych = *++cur;
	if (yych == 'f') goto yy228;
	goto yy3;
yy156:
	yych = *++cur;
	if (yych == 'a') goto yy229;
	goto yy3;
yy157:
	yych = *++cur;
	if (yych == 'o') goto yy230;
	goto yy3;
yy158:
	yych = *++cur;
	if (yych == 'i') goto yy231;
	goto yy3;
yy159:
	yych = *++cur;
	if (yych == 'c') goto yy232;
	goto yy3;
yy160:
	yych = *++cur;
	if (yych <= '@') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy233;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy2;
			if (yych >= '_') goto yy2;
		} else {
			if (yych <= '`') goto yy161;
			if (yych <= 'z') goto yy2;
		}
	}
yy161:
#line 254 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(var_bitmaps); }
#line 1016 "src/parse/conf_lexer.cc"
yy162:
	yych = *++cur;
	if (yych <= '@') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy234;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy2;
			if (yych >= '_') goto yy2;
		} else {
			if (yych <= '`') goto yy163;
			if (yych <= 'z') goto yy2;
		}
	}
yy163:
#line 250 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(var_char); }
#line 1038 "src/parse/conf_lexer.cc"
yy164:
	yych = *++cur;
	if (yych == 'n') goto yy235;
	goto yy3;
yy165:
	yych = *++cur;
	if (yych == 'a') goto yy236;
	goto yy3;
yy166:
	yych = *++cur;
	if (yych == 'l') goto yy237;
	goto yy3;
yy167:
	yych = *++cur;
	if (yych == ':') goto yy238;
	goto yy3;
yy168:
	yych = *++cur;
	if (yych == 'a') goto yy239;
	goto yy3;
yy169:
	yych = *++cur;
	if (yych == 'a') goto yy240;
	goto yy3;
yy170:
	yych = *++cur;
	if (yych == 'c') goto yy241;
	goto yy3;
yy171:
	yych = *++cur;
	if (yych == 'a') goto yy242;
	goto yy3;
yy172:
	yych = *++cur;
	if (yych == 'r') goto yy243;
	goto yy3;
yy173:
	yych = *++cur;
	if (yych == 'K') goto yy244;
	goto yy3;
yy174:
	yych = *++cur;
	if (yych == 'D') goto yy245;
	goto yy3;
yy175:
	yych = *++cur;
	if (yych == 'Y') goto yy246;
	goto yy3;
yy176:
	yych = *++cur;
	if (yych == 'M') goto yy247;
	goto yy3;
yy177:
	yych = *++cur;
	if (yych == 'P') goto yy248;
	goto yy3;
yy178:
	yych = *++cur;
	if (yych == 'S') goto yy249;
	goto yy3;
yy179:
	yych = *++cur;
	if (yych == 'U') goto yy250;
	goto yy3;
yy180:
	yych = *++cur;
	if (yych == 'L') goto yy251;
	goto yy3;
yy181:
	yych = *++cur;
	if (yych <= 'B') {
		if (yych == 'A') goto yy253;
		goto yy3;
	} else {
		if (yych <= 'C') goto yy254;
		if (yych == 'S') goto yy255;
		goto yy3;
	}
yy182:
	yych = *++cur;
	if (yych == 'U') goto yy256;
	goto yy3;
yy183:
	yych = *++cur;
	if (yych == 'S') goto yy257;
	goto yy3;
yy184:
	yych = *++cur;
	if (yych == 'I') goto yy258;
	goto yy3;
yy185:
	yych = *++cur;
	if (yych == 'K') goto yy259;
	goto yy3;
yy186:
	yych = *++cur;
	if (yych == 'F') goto yy260;
	if (yych == 'N') goto yy261;
	goto yy3;
yy187:
	yych = *++cur;
	if (yych == 'G') goto yy262;
	goto yy3;
yy188:
	yych = *++cur;
	if (yych == 'K') goto yy263;
	goto yy3;
yy189:
	yych = *++cur;
	if (yych == 'T') goto yy264;
	goto yy3;
yy190:
	yych = *++cur;
	if (yych <= 'B') {
		if (yych == 'A') goto yy265;
		goto yy3;
	} else {
		if (yych <= 'C') goto yy266;
		if (yych == 'S') goto yy267;
		goto yy3;
	}
yy191:
	yych = *++cur;
	if (yych == 'F') goto yy268;
	goto yy3;
yy192:
	yych = *++cur;
	if (yych == 'P') goto yy269;
	goto yy3;
yy193:
	yych = *++cur;
	if (yych == 'G') goto yy270;
	goto yy3;
yy194:
	yych = *++cur;
	if (yych == 'i') goto yy271;
	if (yych == 't') goto yy272;
	goto yy3;
yy195:
	yych = *++cur;
	if (yych == 'e') goto yy273;
	goto yy3;
yy196:
	yych = *++cur;
	if (yych == 'r') goto yy274;
	goto yy3;
yy197:
	yych = *++cur;
	if (yych == 'a') goto yy275;
	goto yy3;
yy198:
	yych = *++cur;
	if (yych == 'i') goto yy276;
	if (yych == 'r') goto yy277;
	goto yy3;
yy199:
	yych = *++cur;
	if (yych == ':') goto yy278;
	goto yy3;
yy200:
	yych = *++cur;
	if (yych == 'm') goto yy279;
	goto yy3;
yy201:
	yych = *++cur;
	if (yych == 't') goto yy280;
	goto yy3;
yy202:
	yych = *++cur;
	switch (yych) {
		case 'a': goto yy281;
		case 'd': goto yy282;
		case 'e': goto yy203;
		case 'g': goto yy283;
		case 'p': goto yy205;
		default: goto yy3;
	}
yy203:
	yych = *++cur;
	if (yych == 'n') goto yy284;
	goto yy3;
yy204:
	yych = *++cur;
	if (yych == 't') goto yy285;
	goto yy3;
yy205:
	yych = *++cur;
	if (yych == 'r') goto yy286;
	goto yy3;
yy206:
	yych = *++cur;
	if (yych == '-') goto yy287;
	goto yy3;
yy207:
	yych = *++cur;
	if (yych == 'e') goto yy288;
	goto yy3;
yy208:
	yych = *++cur;
	if (yych == '-') goto yy289;
	goto yy3;
yy209:
	yych = *++cur;
	if (yych == 'i') goto yy290;
	goto yy3;
yy210:
	yych = *++cur;
	if (yych == ':') goto yy291;
	goto yy3;
yy211:
	yych = *++cur;
	if (yych == 's') goto yy292;
	goto yy3;
yy212:
	yych = *++cur;
	if (yych == 'r') goto yy293;
	goto yy3;
yy213:
	yych = *++cur;
	if (yych == 't') goto yy295;
	goto yy3;
yy214:
	yych = *++cur;
	if (yych == '-') goto yy296;
	goto yy3;
yy215:
	yych = *++cur;
	if (yych == 't') goto yy297;
	goto yy3;
yy216:
	yych = *++cur;
	if (yych == ':') goto yy298;
	if (yych == 'p') goto yy299;
	goto yy3;
yy217:
	yych = *++cur;
	if (yych == 'o') goto yy300;
	goto yy3;
yy218:
	yych = *++cur;
	if (yych == 'd') goto yy301;
	goto yy3;
yy219:
	yych = *++cur;
	if (yych == 'i') goto yy302;
	goto yy3;
yy220:
	yych = *++cur;
	if (yych == 'd') goto yy303;
	goto yy3;
yy221:
	yych = *++cur;
	if (yych == '-') goto yy304;
	goto yy3;
yy222:
	yych = *++cur;
	if (yych == 'n') goto yy305;
	goto yy3;
yy223:
	yych = *++cur;
	if (yych == 'l') goto yy306;
	goto yy3;
yy224:
	yych = *++cur;
	if (yych == ':') goto yy307;
	goto yy3;
yy225:
	yych = *++cur;
	if (yych == 'b') goto yy308;
	goto yy3;
yy226:
	yych = *++cur;
	if (yych <= 'm') {
		if (yych == 'e') goto yy309;
		goto yy3;
	} else {
		if (yych <= 'n') goto yy310;
		if (yych == 'p') goto yy311;
		goto yy3;
	}
yy227:
	yych = *++cur;
	if (yych == 't') goto yy312;
	goto yy3;
yy228:
	yych = *++cur;
	if (yych == 'e') goto yy313;
	goto yy3;
yy229:
	yych = *++cur;
	if (yych == 'b') goto yy314;
	goto yy3;
yy230:
	yych = *++cur;
	if (yych == 's') goto yy315;
	goto yy3;
yy231:
	yych = *++cur;
	if (yych == 'o') goto yy316;
	goto yy3;
yy232:
	yych = *++cur;
	if (yych == 'e') goto yy317;
	goto yy3;
yy233:
	yych = *++cur;
	if (yych == 'h') goto yy318;
	goto yy3;
yy234:
	yych = *++cur;
	if (yych <= 'd') {
		if (yych == 'c') goto yy319;
		goto yy3;
	} else {
		if (yych <= 'e') goto yy320;
		if (yych == 'l') goto yy321;
		goto yy3;
	}
yy235:
	yych = *++cur;
	if (yych == 'd') goto yy322;
	goto yy3;
yy236:
	yych = *++cur;
	if (yych == 'b') goto yy323;
	goto yy3;
yy237:
	yych = *++cur;
	if (yych == 'l') goto yy324;
	goto yy3;
yy238:
	yych = *++cur;
	if (yych == 's') goto yy326;
	goto yy3;
yy239:
	yych = *++cur;
	if (yych == 't') goto yy327;
	goto yy3;
yy240:
	yych = *++cur;
	if (yych == 't') goto yy328;
	goto yy3;
yy241:
	yych = *++cur;
	if (yych == 'o') goto yy329;
	goto yy3;
yy242:
	yych = *++cur;
	if (yych == 'b') goto yy330;
	if (yych == 't') goto yy331;
	goto yy3;
yy243:
	yych = *++cur;
	if (yych == 'g') goto yy332;
	goto yy3;
yy244:
	yych = *++cur;
	if (yych == 'U') goto yy333;
	goto yy3;
yy245:
	yych = *++cur;
	if (yych == 'T') goto yy334;
	goto yy3;
yy246:
	yych = *++cur;
	if (yych == 'M') goto yy335;
	if (yych == 'S') goto yy336;
	goto yy3;
yy247:
	yych = *++cur;
	if (yych == 'A') goto yy337;
	goto yy3;
yy248:
	yych = *++cur;
	if (yych == 'E') goto yy338;
	goto yy3;
yy249:
	yych = *++cur;
	if (yych == 'O') goto yy339;
	goto yy3;
yy250:
	yych = *++cur;
	if (yych == 'G') goto yy340;
	goto yy3;
yy251:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= '?') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy341;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy342;
			if (yych <= 'Z') goto yy2;
		} else {
			if (yych == '`') goto yy252;
			if (yych <= 'z') goto yy2;
		}
	}
yy252:
#line 200 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_fill); }
#line 1445 "src/parse/conf_lexer.cc"
yy253:
	yych = *++cur;
	if (yych == 'C') goto yy344;
	goto yy3;
yy254:
	yych = *++cur;
	if (yych == 'O') goto yy345;
	goto yy3;
yy255:
	yych = *++cur;
	if (yych == 'T') goto yy346;
	goto yy3;
yy256:
	yych = *++cur;
	if (yych == 'T') goto yy347;
	goto yy3;
yy257:
	yych = *++cur;
	if (yych == 'T') goto yy348;
	goto yy3;
yy258:
	yych = *++cur;
	if (yych == 'T') goto yy349;
	goto yy3;
yy259:
	yych = *++cur;
	if (yych == 'E') goto yy350;
	goto yy3;
yy260:
	yych = *++cur;
	if (yych == 'I') goto yy351;
	goto yy3;
yy261:
	yych = *++cur;
	if (yych == 'M') goto yy352;
	goto yy3;
yy262:
	yych = *++cur;
	if (yych == 'N') goto yy353;
	if (yych == 'P') goto yy354;
	goto yy3;
yy263:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 215 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_peek); }
#line 1492 "src/parse/conf_lexer.cc"
yy264:
	yych = *++cur;
	if (yych == 'O') goto yy355;
	goto yy3;
yy265:
	yych = *++cur;
	if (yych == 'C') goto yy356;
	goto yy3;
yy266:
	yych = *++cur;
	if (yych == 'O') goto yy357;
	goto yy3;
yy267:
	yych = *++cur;
	if (yych == 'T') goto yy358;
	goto yy3;
yy268:
	yych = *++cur;
	if (yych == 'T') goto yy359;
	goto yy3;
yy269:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 229 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_skip); }
#line 1518 "src/parse/conf_lexer.cc"
yy270:
	yych = *++cur;
	if (yych == 'N') goto yy361;
	if (yych == 'P') goto yy362;
	goto yy3;
yy271:
	yych = *++cur;
	if (yych == 'g') goto yy363;
	goto yy3;
yy272:
	yych = *++cur;
	if (yych == 'y') goto yy364;
	goto yy3;
yy273:
	yych = *++cur;
	if (yych == 'c') goto yy365;
	goto yy3;
yy274:
	yych = *++cur;
	if (yych == 'e') goto yy366;
	goto yy3;
yy275:
	yych = *++cur;
	if (yych == 'r') goto yy367;
	goto yy3;
yy276:
	yych = *++cur;
	if (yych == 'n') goto yy368;
	goto yy3;
yy277:
	yych = *++cur;
	if (yych == 'a') goto yy369;
	goto yy3;
yy278:
	yych = *++cur;
	if (yych == 't') goto yy370;
	goto yy3;
yy279:
	yych = *++cur;
	if (yych == 'o') goto yy371;
	goto yy3;
yy280:
	yych = *++cur;
	if (yych == 'e') goto yy372;
	goto yy3;
yy281:
	yych = *++cur;
	if (yych == 'b') goto yy373;
	goto yy3;
yy282:
	yych = *++cur;
	if (yych == 'i') goto yy374;
	goto yy3;
yy283:
	yych = *++cur;
	if (yych == 'o') goto yy375;
	goto yy3;
yy284:
	yych = *++cur;
	if (yych == 'u') goto yy376;
	goto yy3;
yy285:
	yych = *++cur;
	if (yych == 'i') goto yy377;
	goto yy3;
yy286:
	yych = *++cur;
	if (yych == 'e') goto yy378;
	goto yy3;
yy287:
	yych = *++cur;
	if (yych == 'o') goto yy379;
	goto yy3;
yy288:
	yych = *++cur;
	if (yych == ':') goto yy380;
	goto yy3;
yy289:
	yych = *++cur;
	if (yych == 'c') goto yy381;
	goto yy3;
yy290:
	yych = *++cur;
	if (yych == 'n') goto yy382;
	goto yy3;
yy291:
	yych = *++cur;
	switch (yych) {
		case '8': goto yy383;
		case 'P': goto yy384;
		case 'T': goto yy385;
		case 'b': goto yy386;
		case 'c': goto yy388;
		case 'd': goto yy389;
		case 'e': goto yy391;
		case 'g': goto yy393;
		case 'i': goto yy395;
		case 'l': goto yy396;
		case 'm': goto yy14;
		case 'n': goto yy15;
		case 'p': goto yy397;
		case 's': goto yy398;
		case 't': goto yy399;
		case 'u': goto yy400;
		case 'w': goto yy402;
		case 'x': goto yy404;
		default: goto yy3;
	}
yy292:
	yych = *++cur;
	if (yych == 'y') goto yy405;
	goto yy3;
yy293:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
yy294:
#line 137 "../src/parse/conf_lexer.re"
	{
        CHECK_RET(lex_conf_string(opts));
        if (!tmp_str.empty()) {
            std::string path(opts.glob.output_file);
            get_dir(path);
            SETOPT(header_file, path + tmp_str);
        }
        return Ret::OK;
    }
#line 1645 "src/parse/conf_lexer.cc"
yy295:
	yych = *++cur;
	if (yych == ':') goto yy406;
	goto yy3;
yy296:
	yych = *++cur;
	if (yych == 'e') goto yy407;
	goto yy3;
yy297:
	yych = *++cur;
	if (yych == '-') goto yy408;
	goto yy3;
yy298:
	yych = *++cur;
	if (yych <= 'r') {
		if (yych != 'p') goto yy3;
	} else {
		if (yych <= 's') goto yy409;
		if (yych == 'y') goto yy410;
		goto yy3;
	}
yy299:
	yych = *++cur;
	if (yych == 'r') goto yy411;
	goto yy3;
yy300:
	yych = *++cur;
	if (yych == 's') goto yy412;
	goto yy3;
yy301:
	yych = *++cur;
	if (yych == 'i') goto yy413;
	goto yy3;
yy302:
	yych = *++cur;
	if (yych == 'c') goto yy414;
	goto yy3;
yy303:
	yych = *++cur;
	if (yych == '-') goto yy415;
	goto yy3;
yy304:
	yych = *++cur;
	if (yych == 'c') goto yy416;
	goto yy3;
yy305:
	yych = *++cur;
	if (yych == 'e') goto yy417;
	goto yy3;
yy306:
	yych = *++cur;
	if (yych == 'a') goto yy418;
	goto yy3;
yy307:
	yych = *++cur;
	if (yych == 'a') goto yy419;
	if (yych == 'n') goto yy420;
	goto yy3;
yy308:
	yych = *++cur;
	if (yych == 'l') goto yy421;
	goto yy3;
yy309:
	yych = *++cur;
	if (yych == 'x') goto yy422;
	goto yy3;
yy310:
	yych = *++cur;
	if (yych == 'e') goto yy423;
	goto yy3;
yy311:
	yych = *++cur;
	if (yych == 'r') goto yy424;
	goto yy3;
yy312:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 119 "../src/parse/conf_lexer.re"
	{ goto target; }
#line 1725 "src/parse/conf_lexer.cc"
yy313:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 278 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(unsafe); }
#line 1731 "src/parse/conf_lexer.cc"
yy314:
	yych = *++cur;
	if (yych == 'l') goto yy425;
	goto yy3;
yy315:
	yych = *++cur;
	if (yych == 'e') goto yy426;
	goto yy3;
yy316:
	yych = *++cur;
	if (yych == 'n') goto yy427;
	goto yy3;
yy317:
	yych = *++cur;
	if (yych == 'p') goto yy428;
	goto yy3;
yy318:
	yych = *++cur;
	if (yych == 'e') goto yy429;
	goto yy3;
yy319:
	yych = *++cur;
	if (yych == 'o') goto yy430;
	goto yy3;
yy320:
	yych = *++cur;
	if (yych == 'm') goto yy431;
	goto yy3;
yy321:
	yych = *++cur;
	if (yych == 'i') goto yy432;
	goto yy3;
yy322:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 242 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(var_cond); }
#line 1769 "src/parse/conf_lexer.cc"
yy323:
	yych = *++cur;
	if (yych == 'l') goto yy433;
	goto yy3;
yy324:
	yych = *++cur;
	if (yych <= '@') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy434;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy2;
			if (yych >= '_') goto yy2;
		} else {
			if (yych <= '`') goto yy325;
			if (yych <= 'z') goto yy2;
		}
	}
yy325:
#line 256 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(var_fill); }
#line 1795 "src/parse/conf_lexer.cc"
yy326:
	yych = *++cur;
	if (yych == 'e') goto yy435;
	goto yy3;
yy327:
	yych = *++cur;
	if (yych == 'c') goto yy436;
	goto yy3;
yy328:
	yych = *++cur;
	if (yych == 'c') goto yy437;
	goto yy3;
yy329:
	yych = *++cur;
	if (yych == 'r') goto yy438;
	goto yy3;
yy330:
	yych = *++cur;
	if (yych == 'l') goto yy439;
	goto yy3;
yy331:
	yych = *++cur;
	if (yych == 'e') goto yy440;
	goto yy3;
yy332:
	yych = *++cur;
	if (yych == 'e') goto yy441;
	goto yy3;
yy333:
	yych = *++cur;
	if (yych == 'P') goto yy442;
	goto yy3;
yy334:
	yych = *++cur;
	if (yych == 'Y') goto yy444;
	goto yy3;
yy335:
	yych = *++cur;
	if (yych == 'T') goto yy445;
	goto yy3;
yy336:
	yych = *++cur;
	if (yych == 'T') goto yy446;
	goto yy3;
yy337:
	yych = *++cur;
	if (yych == 'R') goto yy447;
	goto yy3;
yy338:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 195 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_char_type); }
#line 1849 "src/parse/conf_lexer.cc"
yy339:
	yych = *++cur;
	if (yych == 'R') goto yy448;
	goto yy3;
yy340:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 199 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_debug); }
#line 1859 "src/parse/conf_lexer.cc"
yy341:
	yych = *++cur;
	if (yych == 'n') goto yy449;
	goto yy3;
yy342:
	yych = *++cur;
	if (yych == 'l') goto yy450;
yy343:
	cur = mar;
	if (yyaccept <= 2) {
		if (yyaccept <= 1) {
			if (yyaccept == 0) goto yy252;
			else goto yy551;
		} else {
			goto yy567;
		}
	} else {
		if (yyaccept <= 4) {
			if (yyaccept == 3) goto yy637;
			else goto yy682;
		} else {
			goto yy779;
		}
	}
yy344:
	yych = *++cur;
	if (yych == 'C') goto yy451;
	goto yy3;
yy345:
	yych = *++cur;
	if (yych == 'N') goto yy452;
	goto yy3;
yy346:
	yych = *++cur;
	if (yych == 'A') goto yy453;
	goto yy3;
yy347:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 197 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_input); }
#line 1901 "src/parse/conf_lexer.cc"
yy348:
	yych = *++cur;
	if (yych == 'H') goto yy454;
	goto yy3;
yy349:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 209 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_limit); }
#line 1911 "src/parse/conf_lexer.cc"
yy350:
	yych = *++cur;
	if (yych == 'R') goto yy455;
	goto yy3;
yy351:
	yych = *++cur;
	if (yych == 'L') goto yy456;
	goto yy3;
yy352:
	yych = *++cur;
	if (yych == 'A') goto yy457;
	goto yy3;
yy353:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 213 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_mtag_neg); }
#line 1929 "src/parse/conf_lexer.cc"
yy354:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 214 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_mtag_pos); }
#line 1935 "src/parse/conf_lexer.cc"
yy355:
	yych = *++cur;
	if (yych == 'R') goto yy458;
	goto yy3;
yy356:
	yych = *++cur;
	if (yych == 'C') goto yy459;
	goto yy3;
yy357:
	yych = *++cur;
	if (yych == 'N') goto yy460;
	goto yy3;
yy358:
	yych = *++cur;
	if (yych == 'A') goto yy461;
	goto yy3;
yy359:
	yych = *++cur;
	if (yych <= 'M') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= ':') goto yy2;
			if (yych <= '@') goto yy360;
			if (yych <= 'L') goto yy2;
			goto yy462;
		}
	} else {
		if (yych <= '^') {
			if (yych == 'S') goto yy463;
			if (yych <= 'Z') goto yy2;
		} else {
			if (yych == '`') goto yy360;
			if (yych <= 'z') goto yy2;
		}
	}
yy360:
#line 226 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_shift); }
#line 1975 "src/parse/conf_lexer.cc"
yy361:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 230 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_stag_neg); }
#line 1981 "src/parse/conf_lexer.cc"
yy362:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 231 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_stag_pos); }
#line 1987 "src/parse/conf_lexer.cc"
yy363:
	yych = *++cur;
	if (yych == 'i') goto yy464;
	goto yy3;
yy364:
	yych = *++cur;
	if (yych == 'l') goto yy465;
	goto yy3;
yy365:
	yych = *++cur;
	if (yych == 't') goto yy466;
	goto yy3;
yy366:
	yych = *++cur;
	if (yych == 's') goto yy467;
	goto yy3;
yy367:
	yych = *++cur;
	if (yych == 's') goto yy468;
	goto yy3;
yy368:
	yych = *++cur;
	if (yych == 's') goto yy469;
	if (yych == 'v') goto yy470;
	goto yy3;
yy369:
	yych = *++cur;
	if (yych == 'n') goto yy471;
	goto yy3;
yy370:
	yych = *++cur;
	if (yych == 'h') goto yy472;
	goto yy3;
yy371:
	yych = *++cur;
	if (yych == 'd') goto yy473;
	goto yy3;
yy372:
	yych = *++cur;
	if (yych == 'd') goto yy474;
	goto yy3;
yy373:
	yych = *++cur;
	if (yych == 'o') goto yy475;
	goto yy3;
yy374:
	yych = *++cur;
	if (yych == 'v') goto yy476;
	goto yy3;
yy375:
	yych = *++cur;
	if (yych == 't') goto yy477;
	goto yy3;
yy376:
	yych = *++cur;
	if (yych == 'm') goto yy478;
	goto yy3;
yy377:
	yych = *++cur;
	if (yych == 'o') goto yy479;
	goto yy3;
yy378:
	yych = *++cur;
	if (yych == 'f') goto yy480;
	goto yy3;
yy379:
	yych = *++cur;
	if (yych == 'u') goto yy481;
	goto yy3;
yy380:
	yych = *++cur;
	if (yych == 'Y') goto yy4;
	goto yy3;
yy381:
	yych = *++cur;
	if (yych == 'l') goto yy482;
	goto yy3;
yy382:
	yych = *++cur;
	if (yych == 'g') goto yy483;
	goto yy3;
yy383:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 285 "../src/parse/conf_lexer.re"
	{ RET_CONF_ENC(Enc::Type::UTF8); }
#line 2074 "src/parse/conf_lexer.cc"
yy384:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 165 "../src/parse/conf_lexer.re"
	{
        CHECK_RET(lex_conf_bool(opts));
        SETOPT(captures, tmp_bool);
        SETOPT(captures_posix, tmp_bool);
        SETOPT(captures_array, true);
        return Ret::OK;
    }
#line 2086 "src/parse/conf_lexer.cc"
yy385:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
	goto yy153;
yy386:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= ':') goto yy2;
			if (yych >= 'A') goto yy2;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy2;
		} else {
			if (yych == 'i') goto yy24;
			if (yych <= 'z') goto yy2;
		}
	}
yy387:
#line 270 "../src/parse/conf_lexer.re"
	{ RET_CONF_FEAT(bitmaps, "bitmaps"); }
#line 2111 "src/parse/conf_lexer.cc"
yy388:
	yych = *++cur;
	if (yych == 'a') goto yy484;
	if (yych == 'o') goto yy485;
	goto yy3;
yy389:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= ':') goto yy2;
			if (yych >= 'A') goto yy2;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy2;
		} else {
			if (yych == 'e') goto yy486;
			if (yych <= 'z') goto yy2;
		}
	}
yy390:
#line 271 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(debug); }
#line 2137 "src/parse/conf_lexer.cc"
yy391:
	yych = *++cur;
	if (yych <= '_') {
		if (yych <= ':') {
			if (yych == '-') goto yy2;
			if (yych >= '0') goto yy2;
		} else {
			if (yych <= '@') goto yy392;
			if (yych <= 'Z') goto yy2;
			if (yych >= '_') goto yy2;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= '`') goto yy392;
			if (yych == 'c') goto yy487;
			goto yy2;
		} else {
			if (yych <= 'm') goto yy30;
			if (yych <= 'n') goto yy488;
			if (yych <= 'z') goto yy2;
		}
	}
yy392:
#line 281 "../src/parse/conf_lexer.re"
	{ RET_CONF_ENC(Enc::Type::EBCDIC); }
#line 2163 "src/parse/conf_lexer.cc"
yy393:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
yy394:
#line 272 "../src/parse/conf_lexer.re"
	{ RET_CONF_FEAT(computed_gotos, "computed-gotos"); }
#line 2170 "src/parse/conf_lexer.cc"
yy395:
	yych = *++cur;
	if (yych == 'n') goto yy489;
	goto yy3;
yy396:
	yych = *++cur;
	if (yych == 'e') goto yy490;
	goto yy3;
yy397:
	yych = *++cur;
	if (yych == 'o') goto yy491;
	goto yy3;
yy398:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 274 "../src/parse/conf_lexer.re"
	{ RET_CONF_FEAT(nested_ifs, "nested-ifs"); }
#line 2188 "src/parse/conf_lexer.cc"
yy399:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
			goto yy294;
		} else {
			if (yych <= ':') goto yy2;
			if (yych <= '@') goto yy294;
			if (yych <= 'Z') goto yy2;
			goto yy294;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= '_') goto yy2;
			if (yych <= '`') goto yy294;
			goto yy492;
		} else {
			if (yych == 'y') goto yy493;
			if (yych <= 'z') goto yy2;
			goto yy294;
		}
	}
yy400:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= ':') goto yy2;
			if (yych <= '@') goto yy401;
			if (yych <= 'Z') goto yy2;
		}
	} else {
		if (yych <= 'n') {
			if (yych == '`') goto yy401;
			if (yych <= 'm') goto yy2;
			goto yy494;
		} else {
			if (yych == 't') goto yy495;
			if (yych <= 'z') goto yy2;
		}
	}
yy401:
#line 282 "../src/parse/conf_lexer.re"
	{ RET_CONF_ENC(Enc::Type::UTF32); }
#line 2235 "src/parse/conf_lexer.cc"
yy402:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= ':') goto yy2;
			if (yych >= 'A') goto yy2;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy2;
		} else {
			if (yych == 'i') goto yy496;
			if (yych <= 'z') goto yy2;
		}
	}
yy403:
#line 283 "../src/parse/conf_lexer.re"
	{ RET_CONF_ENC(Enc::Type::UCS2); }
#line 2256 "src/parse/conf_lexer.cc"
yy404:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 284 "../src/parse/conf_lexer.re"
	{ RET_CONF_ENC(Enc::Type::UTF16); }
#line 2262 "src/parse/conf_lexer.cc"
yy405:
	yych = *++cur;
	if (yych == 'n') goto yy497;
	goto yy3;
yy406:
	yych = *++cur;
	if (yych <= 'r') goto yy3;
	if (yych <= 's') goto yy498;
	if (yych <= 't') goto yy499;
	goto yy3;
yy407:
	yych = *++cur;
	if (yych == 'n') goto yy500;
	goto yy3;
yy408:
	yych = *++cur;
	if (yych == 'c') goto yy501;
	goto yy3;
yy409:
	yych = *++cur;
	if (yych == 't') goto yy502;
	goto yy3;
yy410:
	yych = *++cur;
	if (yych == 'y') goto yy503;
	goto yy3;
yy411:
	yych = *++cur;
	if (yych == 'e') goto yy504;
	goto yy3;
yy412:
	yych = *++cur;
	if (yych == 't') goto yy505;
	goto yy3;
yy413:
	yych = *++cur;
	if (yych == 'r') goto yy506;
	goto yy3;
yy414:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 279 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(monadic); }
#line 2306 "src/parse/conf_lexer.cc"
yy415:
	yych = *++cur;
	if (yych == 'i') goto yy507;
	goto yy3;
yy416:
	yych = *++cur;
	if (yych == 'a') goto yy508;
	goto yy3;
yy417:
	yych = *++cur;
	if (yych == 'l') goto yy509;
	goto yy3;
yy418:
	yych = *++cur;
	if (yych == 'b') goto yy510;
	goto yy3;
yy419:
	yych = *++cur;
	if (yych == 'b') goto yy511;
	goto yy3;
yy420:
	yych = *++cur;
	if (yych == 'e') goto yy512;
	goto yy3;
yy421:
	yych = *++cur;
	if (yych == 'e') goto yy513;
	goto yy3;
yy422:
	yych = *++cur;
	if (yych == 'p') goto yy514;
	goto yy3;
yy423:
	yych = *++cur;
	if (yych == 'g') goto yy515;
	goto yy3;
yy424:
	yych = *++cur;
	if (yych == 'e') goto yy516;
	goto yy3;
yy425:
	yych = *++cur;
	if (yych == 'e') goto yy517;
	goto yy3;
yy426:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 127 "../src/parse/conf_lexer.re"
	{ RET_STXCONF_BOOL(verbose); }
#line 2356 "src/parse/conf_lexer.cc"
yy427:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 123 "../src/parse/conf_lexer.re"
	{ RET_STXCONF_BOOL(version); }
#line 2362 "src/parse/conf_lexer.cc"
yy428:
	yych = *++cur;
	if (yych == 't') goto yy518;
	goto yy3;
yy429:
	yych = *++cur;
	if (yych == 'x') goto yy519;
	goto yy3;
yy430:
	yych = *++cur;
	if (yych == 'n') goto yy520;
	goto yy3;
yy431:
	yych = *++cur;
	if (yych == 'i') goto yy521;
	goto yy3;
yy432:
	yych = *++cur;
	if (yych == 't') goto yy522;
	goto yy3;
yy433:
	yych = *++cur;
	if (yych == 'e') goto yy523;
	goto yy3;
yy434:
	yych = *++cur;
	if (yych <= 'd') {
		if (yych == 'c') goto yy524;
		goto yy3;
	} else {
		if (yych <= 'e') goto yy525;
		if (yych == 'p') goto yy526;
		goto yy3;
	}
yy435:
	yych = *++cur;
	if (yych == 'p') goto yy527;
	goto yy3;
yy436:
	yych = *++cur;
	if (yych == 'h') goto yy528;
	goto yy3;
yy437:
	yych = *++cur;
	if (yych == 'h') goto yy529;
	goto yy3;
yy438:
	yych = *++cur;
	if (yych == 'd') goto yy530;
	goto yy3;
yy439:
	yych = *++cur;
	if (yych == 'e') goto yy531;
	goto yy3;
yy440:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 246 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(var_state); }
#line 2422 "src/parse/conf_lexer.cc"
yy441:
	yych = *++cur;
	if (yych == 't') goto yy532;
	goto yy3;
yy442:
	yych = *++cur;
	if (yych <= 'B') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= ':') goto yy2;
			if (yych >= 'A') goto yy2;
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'C') goto yy533;
			if (yych <= 'Z') goto yy2;
		} else {
			if (yych == '`') goto yy443;
			if (yych <= 'z') goto yy2;
		}
	}
yy443:
#line 190 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_backup); }
#line 2448 "src/parse/conf_lexer.cc"
yy444:
	yych = *++cur;
	if (yych == 'P') goto yy534;
	goto yy3;
yy445:
	yych = *++cur;
	if (yych == 'A') goto yy535;
	goto yy3;
yy446:
	yych = *++cur;
	if (yych == 'A') goto yy536;
	goto yy3;
yy447:
	yych = *++cur;
	if (yych == 'K') goto yy537;
	goto yy3;
yy448:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 198 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_cursor); }
#line 2470 "src/parse/conf_lexer.cc"
yy449:
	yych = *++cur;
	if (yych == 'a') goto yy538;
	goto yy3;
yy450:
	yych = *++cur;
	if (yych == 'e') goto yy539;
	goto yy343;
yy451:
	yych = *++cur;
	if (yych == 'E') goto yy540;
	goto yy3;
yy452:
	yych = *++cur;
	if (yych == 'D') goto yy541;
	goto yy3;
yy453:
	yych = *++cur;
	if (yych == 'T') goto yy543;
	goto yy3;
yy454:
	yych = *++cur;
	if (yych == 'A') goto yy544;
	goto yy3;
yy455:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 210 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_marker); }
#line 2500 "src/parse/conf_lexer.cc"
yy456:
	yych = *++cur;
	if (yych == 'L') goto yy545;
	goto yy3;
yy457:
	yych = *++cur;
	if (yych == 'T') goto yy546;
	goto yy3;
yy458:
	yych = *++cur;
	if (yych == 'E') goto yy547;
	goto yy3;
yy459:
	yych = *++cur;
	if (yych == 'E') goto yy549;
	goto yy3;
yy460:
	yych = *++cur;
	if (yych == 'D') goto yy550;
	goto yy3;
yy461:
	yych = *++cur;
	if (yych == 'T') goto yy552;
	goto yy3;
yy462:
	yych = *++cur;
	if (yych == 'T') goto yy553;
	goto yy3;
yy463:
	yych = *++cur;
	if (yych == 'T') goto yy554;
	goto yy3;
yy464:
	yych = *++cur;
	if (yych == 'l') goto yy555;
	goto yy3;
yy465:
	yych = *++cur;
	if (yych == 'e') goto yy556;
	goto yy3;
yy466:
	yych = *++cur;
	if (yych == 'o') goto yy557;
	goto yy3;
yy467:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 159 "../src/parse/conf_lexer.re"
	{
        CHECK_RET(lex_conf_bool(opts));
        SETOPT(captures, tmp_bool);
        SETOPT(captures_array, true);
        return Ret::OK;
    }
#line 2555 "src/parse/conf_lexer.cc"
yy468:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 172 "../src/parse/conf_lexer.re"
	{
        CHECK_RET(lex_conf_bool(opts));
        SETOPT(captures, tmp_bool);
        SETOPT(captures_array, false);
        return Ret::OK;
    }
#line 2566 "src/parse/conf_lexer.cc"
yy469:
	yych = *++cur;
	if (yych == 'e') goto yy558;
	goto yy3;
yy470:
	yych = *++cur;
	if (yych == 'e') goto yy559;
	goto yy3;
yy471:
	yych = *++cur;
	if (yych == 'g') goto yy560;
	goto yy3;
yy472:
	yych = *++cur;
	if (yych == 'r') goto yy561;
	goto yy3;
yy473:
	yych = *++cur;
	if (yych == 'e') goto yy562;
	goto yy3;
yy474:
	yych = *++cur;
	if (yych == '-') goto yy563;
	goto yy3;
yy475:
	yych = *++cur;
	if (yych == 'r') goto yy564;
	goto yy3;
yy476:
	yych = *++cur;
	if (yych == 'i') goto yy565;
	goto yy3;
yy477:
	yych = *++cur;
	if (yych == 'o') goto yy566;
	goto yy3;
yy478:
	yych = *++cur;
	if (yych == 'p') goto yy568;
	goto yy3;
yy479:
	yych = *++cur;
	if (yych == 'n') goto yy569;
	goto yy3;
yy480:
	yych = *++cur;
	if (yych == 'i') goto yy570;
	goto yy3;
yy481:
	yych = *++cur;
	if (yych == 't') goto yy571;
	goto yy3;
yy482:
	yych = *++cur;
	if (yych == 'a') goto yy572;
	goto yy3;
yy483:
	yych = *++cur;
	if (yych == '-') goto yy573;
	if (yych == ':') goto yy574;
	goto yy3;
yy484:
	yych = *++cur;
	if (yych == 'p') goto yy575;
	if (yych == 's') goto yy64;
	goto yy3;
yy485:
	yych = *++cur;
	if (yych == 'm') goto yy576;
	goto yy3;
yy486:
	yych = *++cur;
	if (yych == 'b') goto yy70;
	goto yy3;
yy487:
	yych = *++cur;
	if (yych == 'b') goto yy577;
	goto yy3;
yy488:
	yych = *++cur;
	if (yych == 'c') goto yy578;
	goto yy3;
yy489:
	yych = *++cur;
	if (yych == 'p') goto yy579;
	goto yy3;
yy490:
	yych = *++cur;
	if (yych == 'f') goto yy580;
	goto yy3;
yy491:
	yych = *++cur;
	if (yych == 's') goto yy581;
	goto yy3;
yy492:
	yych = *++cur;
	if (yych == 'g') goto yy582;
	goto yy3;
yy493:
	yych = *++cur;
	if (yych == 'p') goto yy583;
	goto yy3;
yy494:
	yych = *++cur;
	if (yych == 'i') goto yy584;
	if (yych == 's') goto yy92;
	goto yy3;
yy495:
	yych = *++cur;
	if (yych == 'f') goto yy585;
	goto yy3;
yy496:
	yych = *++cur;
	if (yych == 'd') goto yy586;
	goto yy3;
yy497:
	yych = *++cur;
	if (yych == 't') goto yy587;
	goto yy3;
yy498:
	yych = *++cur;
	if (yych == 't') goto yy588;
	goto yy3;
yy499:
	yych = *++cur;
	if (yych == 'o') goto yy589;
	goto yy3;
yy500:
	yych = *++cur;
	if (yych == 'c') goto yy590;
	goto yy3;
yy501:
	yych = *++cur;
	if (yych == 'a') goto yy591;
	goto yy3;
yy502:
	yych = *++cur;
	if (yych == 'a') goto yy592;
	goto yy3;
yy503:
	yych = *++cur;
	if (yych <= 'N') {
		if (yych == 'F') goto yy593;
		if (yych <= 'M') goto yy3;
		goto yy594;
	} else {
		if (yych <= 'f') {
			if (yych <= 'e') goto yy3;
			goto yy595;
		} else {
			if (yych == 'l') goto yy596;
			goto yy3;
		}
	}
yy504:
	yych = *++cur;
	if (yych == 'f') goto yy597;
	goto yy3;
yy505:
	yych = *++cur;
	if (yych == '-') goto yy598;
	goto yy3;
yy506:
	yych = *++cur;
	if (yych == 's') goto yy599;
	goto yy3;
yy507:
	yych = *++cur;
	if (yych == 'f') goto yy600;
	goto yy3;
yy508:
	yych = *++cur;
	if (yych == 'p') goto yy601;
	goto yy3;
yy509:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 148 "../src/parse/conf_lexer.re"
	{ RET_CONF_EOF(fill_sentinel); }
#line 2746 "src/parse/conf_lexer.cc"
yy510:
	yych = *++cur;
	if (yych == 'e') goto yy602;
	goto yy3;
yy511:
	yych = *++cur;
	if (yych == 'o') goto yy603;
	goto yy3;
yy512:
	yych = *++cur;
	if (yych == 'x') goto yy604;
	goto yy3;
yy513:
	yych = *++cur;
	if (yych == '-') goto yy605;
	goto yy3;
yy514:
	yych = *++cur;
	if (yych == 'r') goto yy606;
	goto yy3;
yy515:
	yych = *++cur;
	if (yych == 'a') goto yy607;
	goto yy3;
yy516:
	yych = *++cur;
	if (yych == 'f') goto yy608;
	goto yy3;
yy517:
	yych = *++cur;
	if (yych == ':') goto yy609;
	goto yy3;
yy518:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 244 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(var_accept); }
#line 2784 "src/parse/conf_lexer.cc"
yy519:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 255 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(bitmaps_hex); }
#line 2790 "src/parse/conf_lexer.cc"
yy520:
	yych = *++cur;
	if (yych == 'v') goto yy610;
	goto yy3;
yy521:
	yych = *++cur;
	if (yych == 't') goto yy611;
	goto yy3;
yy522:
	yych = *++cur;
	if (yych == 'e') goto yy612;
	goto yy3;
yy523:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 243 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(var_cond_table); }
#line 2808 "src/parse/conf_lexer.cc"
yy524:
	yych = *++cur;
	if (yych == 'h') goto yy613;
	goto yy3;
yy525:
	yych = *++cur;
	if (yych == 'n') goto yy614;
	goto yy3;
yy526:
	yych = *++cur;
	if (yych == 'a') goto yy615;
	goto yy3;
yy527:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 154 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(fn_sep); }
#line 2826 "src/parse/conf_lexer.cc"
yy528:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 247 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(var_nmatch); }
#line 2832 "src/parse/conf_lexer.cc"
yy529:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 248 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(var_pmatch); }
#line 2838 "src/parse/conf_lexer.cc"
yy530:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 249 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(var_record); }
#line 2844 "src/parse/conf_lexer.cc"
yy531:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 257 "../src/parse/conf_lexer.re"
	{ return lex_conf_string(opts); }
#line 2850 "src/parse/conf_lexer.cc"
yy532:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 245 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(var_computed_gotos_table); }
#line 2856 "src/parse/conf_lexer.cc"
yy533:
	yych = *++cur;
	if (yych == 'T') goto yy616;
	goto yy3;
yy534:
	yych = *++cur;
	if (yych == 'E') goto yy617;
	goto yy3;
yy535:
	yych = *++cur;
	if (yych == 'G') goto yy618;
	goto yy3;
yy536:
	yych = *++cur;
	if (yych == 'G') goto yy619;
	goto yy3;
yy537:
	yych = *++cur;
	if (yych == 'E') goto yy620;
	goto yy3;
yy538:
	yych = *++cur;
	if (yych == 'k') goto yy621;
	goto yy3;
yy539:
	yych = *++cur;
	if (yych == 'n') goto yy622;
	goto yy343;
yy540:
	yych = *++cur;
	if (yych == 'P') goto yy623;
	goto yy3;
yy541:
	yych = *++cur;
	if (yych <= 'H') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy624;
			if (yych >= 'A') goto yy2;
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'I') goto yy625;
			if (yych <= 'Z') goto yy2;
		} else {
			if (yych == '`') goto yy542;
			if (yych <= 'z') goto yy2;
		}
	}
yy542:
#line 204 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_cond_get); }
#line 2911 "src/parse/conf_lexer.cc"
yy543:
	yych = *++cur;
	if (yych == 'E') goto yy626;
	goto yy3;
yy544:
	yych = *++cur;
	if (yych == 'N') goto yy628;
	goto yy3;
yy545:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 211 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_maxfill); }
#line 2925 "src/parse/conf_lexer.cc"
yy546:
	yych = *++cur;
	if (yych == 'C') goto yy629;
	goto yy3;
yy547:
	yych = *++cur;
	if (yych <= 'C') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= ':') goto yy2;
			if (yych <= '@') goto yy548;
			if (yych <= 'B') goto yy2;
			goto yy630;
		}
	} else {
		if (yych <= '^') {
			if (yych == 'T') goto yy631;
			if (yych <= 'Z') goto yy2;
		} else {
			if (yych == '`') goto yy548;
			if (yych <= 'z') goto yy2;
		}
	}
yy548:
#line 216 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_restore); }
#line 2953 "src/parse/conf_lexer.cc"
yy549:
	yych = *++cur;
	if (yych == 'P') goto yy632;
	goto yy3;
yy550:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '@') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy633;
			if (yych >= '@') goto yy634;
		}
	} else {
		if (yych <= '^') {
			if (yych == 'I') goto yy635;
			if (yych <= 'Z') goto yy2;
		} else {
			if (yych == '`') goto yy551;
			if (yych <= 'z') goto yy2;
		}
	}
yy551:
#line 220 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_cond_set); }
#line 2981 "src/parse/conf_lexer.cc"
yy552:
	yych = *++cur;
	if (yych == 'E') goto yy636;
	goto yy3;
yy553:
	yych = *++cur;
	if (yych == 'A') goto yy638;
	goto yy3;
yy554:
	yych = *++cur;
	if (yych == 'A') goto yy639;
	goto yy3;
yy555:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 134 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(api_sigil); }
#line 2999 "src/parse/conf_lexer.cc"
yy556:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 133 "../src/parse/conf_lexer.re"
	{ goto api_style; }
#line 3005 "src/parse/conf_lexer.cc"
yy557:
	yych = *++cur;
	if (yych == 'r') goto yy640;
	goto yy3;
yy558:
	yych = *++cur;
	if (yych == 'n') goto yy641;
	goto yy3;
yy559:
	yych = *++cur;
	if (yych == 'r') goto yy642;
	goto yy3;
yy560:
	yych = *++cur;
	if (yych == 'e') goto yy643;
	goto yy3;
yy561:
	yych = *++cur;
	if (yych == 'e') goto yy644;
	goto yy3;
yy562:
	yych = *++cur;
	if (yych == 'l') goto yy645;
	goto yy3;
yy563:
	yych = *++cur;
	if (yych == 'g') goto yy646;
	goto yy3;
yy564:
	yych = *++cur;
	if (yych == 't') goto yy647;
	goto yy3;
yy565:
	yych = *++cur;
	if (yych == 'd') goto yy648;
	goto yy3;
yy566:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 32) goto yy2;
	if (yych == '@') goto yy649;
yy567:
#line 264 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(cond_goto); }
#line 3050 "src/parse/conf_lexer.cc"
yy568:
	yych = *++cur;
	if (yych == 'r') goto yy650;
	goto yy3;
yy569:
	yych = *++cur;
	if (yych == 's') goto yy651;
	goto yy3;
yy570:
	yych = *++cur;
	if (yych == 'x') goto yy652;
	goto yy3;
yy571:
	yych = *++cur;
	if (yych == 'p') goto yy653;
	goto yy3;
yy572:
	yych = *++cur;
	if (yych == 's') goto yy654;
	goto yy3;
yy573:
	yych = *++cur;
	if (yych == 'p') goto yy655;
	goto yy3;
yy574:
	yych = *++cur;
	if (yych == 'e') goto yy656;
	if (yych == 'u') goto yy657;
	goto yy3;
yy575:
	yych = *++cur;
	if (yych == 't') goto yy658;
	goto yy3;
yy576:
	yych = *++cur;
	if (yych == 'p') goto yy659;
	goto yy3;
yy577:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
	goto yy392;
yy578:
	yych = *++cur;
	if (yych == 'o') goto yy660;
	goto yy3;
yy579:
	yych = *++cur;
	if (yych == 'u') goto yy661;
	goto yy3;
yy580:
	yych = *++cur;
	if (yych == 't') goto yy662;
	goto yy3;
yy581:
	yych = *++cur;
	if (yych == 'i') goto yy663;
	goto yy3;
yy582:
	yych = *++cur;
	if (yych == 's') goto yy385;
	goto yy3;
yy583:
	yych = *++cur;
	if (yych == 'e') goto yy664;
	goto yy3;
yy584:
	yych = *++cur;
	if (yych == 'c') goto yy665;
	goto yy3;
yy585:
	yych = *++cur;
	if (yych == '-') goto yy666;
	goto yy3;
yy586:
	yych = *++cur;
	if (yych == 'e') goto yy667;
	goto yy3;
yy587:
	yych = *++cur;
	if (yych == 'a') goto yy668;
	goto yy3;
yy588:
	yych = *++cur;
	if (yych == 'r') goto yy669;
	goto yy3;
yy589:
	yych = *++cur;
	if (yych == 'p') goto yy670;
	goto yy3;
yy590:
	yych = *++cur;
	if (yych == 'o') goto yy671;
	goto yy3;
yy591:
	yych = *++cur;
	if (yych == 'p') goto yy672;
	goto yy3;
yy592:
	yych = *++cur;
	if (yych == 'r') goto yy673;
	goto yy3;
yy593:
	yych = *++cur;
	if (yych == 'i') goto yy674;
	goto yy3;
yy594:
	yych = *++cur;
	if (yych == 'e') goto yy675;
	goto yy3;
yy595:
	yych = *++cur;
	if (yych == 'i') goto yy676;
	goto yy3;
yy596:
	yych = *++cur;
	if (yych == 'o') goto yy677;
	goto yy3;
yy597:
	yych = *++cur;
	if (yych == 'i') goto yy678;
	goto yy3;
yy598:
	yych = *++cur;
	if (yych == 'c') goto yy679;
	goto yy3;
yy599:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 128 "../src/parse/conf_lexer.re"
	{ RET_STXCONF_BOOL(line_dirs); }
#line 3181 "src/parse/conf_lexer.cc"
yy600:
	yych = *++cur;
	if (yych == 's') goto yy398;
	goto yy3;
yy601:
	yych = *++cur;
	if (yych == 't') goto yy680;
	goto yy3;
yy602:
	yych = *++cur;
	if (yych == 'l') goto yy681;
	goto yy3;
yy603:
	yych = *++cur;
	if (yych == 'r') goto yy683;
	goto yy3;
yy604:
	yych = *++cur;
	if (yych == 't') goto yy684;
	goto yy3;
yy605:
	yych = *++cur;
	if (yych == 's') goto yy685;
	goto yy3;
yy606:
	yych = *++cur;
	if (yych == 'e') goto yy686;
	goto yy3;
yy607:
	yych = *++cur;
	if (yych == 't') goto yy687;
	goto yy3;
yy608:
	yych = *++cur;
	if (yych == 'i') goto yy688;
	goto yy3;
yy609:
	yych = *++cur;
	if (yych == 'y') goto yy689;
	goto yy3;
yy610:
	yych = *++cur;
	if (yych == 'e') goto yy690;
	goto yy3;
yy611:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 253 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(char_emit); }
#line 3231 "src/parse/conf_lexer.cc"
yy612:
	yych = *++cur;
	if (yych == 'r') goto yy691;
	goto yy3;
yy613:
	yych = *++cur;
	if (yych == 'e') goto yy692;
	goto yy3;
yy614:
	yych = *++cur;
	if (yych == 'a') goto yy693;
	goto yy3;
yy615:
	yych = *++cur;
	if (yych == 'r') goto yy694;
	goto yy3;
yy616:
	yych = *++cur;
	if (yych == 'X') goto yy695;
	goto yy3;
yy617:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 192 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_cond_type); }
#line 3257 "src/parse/conf_lexer.cc"
yy618:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 193 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_mtag_copy); }
#line 3263 "src/parse/conf_lexer.cc"
yy619:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 194 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_stag_copy); }
#line 3269 "src/parse/conf_lexer.cc"
yy620:
	yych = *++cur;
	if (yych == 'R') goto yy696;
	goto yy3;
yy621:
	yych = *++cur;
	if (yych == 'e') goto yy697;
	goto yy3;
yy622:
	++cur;
#line 201 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(fill_param); }
#line 3282 "src/parse/conf_lexer.cc"
yy623:
	yych = *++cur;
	if (yych == 'T') goto yy698;
	goto yy3;
yy624:
	yych = *++cur;
	if (yych == 'n') goto yy699;
	goto yy3;
yy625:
	yych = *++cur;
	if (yych == 'T') goto yy700;
	goto yy3;
yy626:
	yych = *++cur;
	if (yych <= '@') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy701;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy2;
			if (yych >= '_') goto yy2;
		} else {
			if (yych <= '`') goto yy627;
			if (yych <= 'z') goto yy2;
		}
	}
yy627:
#line 206 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_state_get); }
#line 3316 "src/parse/conf_lexer.cc"
yy628:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 208 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_less_than); }
#line 3322 "src/parse/conf_lexer.cc"
yy629:
	yych = *++cur;
	if (yych == 'H') goto yy702;
	goto yy3;
yy630:
	yych = *++cur;
	if (yych == 'T') goto yy703;
	goto yy3;
yy631:
	yych = *++cur;
	if (yych == 'A') goto yy704;
	goto yy3;
yy632:
	yych = *++cur;
	if (yych == 'T') goto yy705;
	goto yy3;
yy633:
	yych = *++cur;
	if (yych == 'n') goto yy706;
	goto yy3;
yy634:
	yych = *++cur;
	if (yych == 'c') goto yy707;
	goto yy343;
yy635:
	yych = *++cur;
	if (yych == 'T') goto yy708;
	goto yy3;
yy636:
	yyaccept = 3;
	yych = *(mar = ++cur);
	if (yych <= '?') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy709;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy710;
			if (yych <= 'Z') goto yy2;
		} else {
			if (yych == '`') goto yy637;
			if (yych <= 'z') goto yy2;
		}
	}
yy637:
#line 223 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_state_set); }
#line 3373 "src/parse/conf_lexer.cc"
yy638:
	yych = *++cur;
	if (yych == 'G') goto yy711;
	goto yy3;
yy639:
	yych = *++cur;
	if (yych == 'G') goto yy712;
	goto yy3;
yy640:
	yych = *++cur;
	if (yych == 's') goto yy713;
	goto yy3;
yy641:
	yych = *++cur;
	if (yych == 's') goto yy714;
	goto yy3;
yy642:
	yych = *++cur;
	if (yych == 't') goto yy715;
	goto yy3;
yy643:
	yych = *++cur;
	if (yych == 's') goto yy716;
	goto yy3;
yy644:
	yych = *++cur;
	if (yych == 's') goto yy717;
	goto yy3;
yy645:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 120 "../src/parse/conf_lexer.re"
	{ goto code_model; }
#line 3407 "src/parse/conf_lexer.cc"
yy646:
	yych = *++cur;
	if (yych == 'o') goto yy718;
	goto yy3;
yy647:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 259 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(cond_abort); }
#line 3417 "src/parse/conf_lexer.cc"
yy648:
	yych = *++cur;
	if (yych == 'e') goto yy719;
	goto yy3;
yy649:
	yych = *++cur;
	if (yych == 'c') goto yy720;
	goto yy343;
yy650:
	yych = *++cur;
	if (yych == 'e') goto yy721;
	goto yy3;
yy651:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 124 "../src/parse/conf_lexer.re"
	{ RET_STXCONF_BOOL(start_conditions); }
#line 3435 "src/parse/conf_lexer.cc"
yy652:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 260 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(cond_label_prefix); }
#line 3441 "src/parse/conf_lexer.cc"
yy653:
	yych = *++cur;
	if (yych == 'u') goto yy722;
	goto yy3;
yy654:
	yych = *++cur;
	if (yych == 's') goto yy723;
	goto yy3;
yy655:
	yych = *++cur;
	if (yych == 'o') goto yy724;
	goto yy3;
yy656:
	yych = *++cur;
	if (yych == 'b') goto yy725;
	goto yy3;
yy657:
	yych = *++cur;
	if (yych == 'c') goto yy726;
	if (yych == 't') goto yy727;
	goto yy3;
yy658:
	yych = *++cur;
	if (yych == 'u') goto yy196;
	goto yy3;
yy659:
	yych = *++cur;
	if (yych == 'u') goto yy728;
	goto yy3;
yy660:
	yych = *++cur;
	if (yych == 'd') goto yy729;
	goto yy3;
yy661:
	yych = *++cur;
	if (yych == 't') goto yy730;
	goto yy3;
yy662:
	yych = *++cur;
	if (yych == 'm') goto yy731;
	goto yy3;
yy663:
	yych = *++cur;
	if (yych == 'x') goto yy732;
	goto yy3;
yy664:
	yych = *++cur;
	if (yych == '-') goto yy733;
	goto yy3;
yy665:
	yych = *++cur;
	if (yych == 'o') goto yy734;
	goto yy3;
yy666:
	yych = *++cur;
	if (yych == '1') goto yy735;
	if (yych == '8') goto yy383;
	goto yy3;
yy667:
	yych = *++cur;
	if (yych == '-') goto yy736;
	goto yy3;
yy668:
	yych = *++cur;
	if (yych == 'x') goto yy737;
	goto yy3;
yy669:
	yych = *++cur;
	if (yych == 'i') goto yy738;
	goto yy3;
yy670:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 291 "../src/parse/conf_lexer.re"
	{ RET_CONF_NUM_NONNEG(indent_top); }
#line 3517 "src/parse/conf_lexer.cc"
yy671:
	yych = *++cur;
	if (yych == 'd') goto yy739;
	goto yy3;
yy672:
	yych = *++cur;
	if (yych == 't') goto yy740;
	goto yy3;
yy673:
	yych = *++cur;
	if (yych == 't') goto yy681;
	goto yy3;
yy674:
	yych = *++cur;
	if (yych == 'l') goto yy741;
	goto yy3;
yy675:
	yych = *++cur;
	if (yych == 'x') goto yy742;
	goto yy3;
yy676:
	yych = *++cur;
	if (yych == 'l') goto yy743;
	goto yy3;
yy677:
	yych = *++cur;
	if (yych == 'o') goto yy744;
	goto yy3;
yy678:
	yych = *++cur;
	if (yych == 'x') goto yy745;
	goto yy3;
yy679:
	yych = *++cur;
	if (yych == 'a') goto yy746;
	goto yy3;
yy680:
	yych = *++cur;
	if (yych <= 't') goto yy3;
	if (yych <= 'u') goto yy747;
	if (yych <= 'v') goto yy748;
	goto yy3;
yy681:
	yyaccept = 4;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 32) goto yy2;
	if (yych <= '\r') {
		if (yych == '\t') {
			ctx = cur;
			goto yy749;
		}
		if (yych >= '\r') {
			ctx = cur;
			goto yy749;
		}
	} else {
		if (yych <= ' ') {
			if (yych >= ' ') {
				ctx = cur;
				goto yy749;
			}
		} else {
			if (yych == '=') {
				ctx = cur;
				goto yy750;
			}
		}
	}
yy682:
#line 298 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(label_start); }
#line 3589 "src/parse/conf_lexer.cc"
yy683:
	yych = *++cur;
	if (yych == 't') goto yy751;
	goto yy3;
yy684:
	yych = *++cur;
	if (yych == 'l') goto yy752;
	goto yy3;
yy685:
	yych = *++cur;
	if (yych == 't') goto yy753;
	goto yy3;
yy686:
	yych = *++cur;
	if (yych == 's') goto yy754;
	goto yy3;
yy687:
	yych = *++cur;
	if (yych == 'i') goto yy755;
	goto yy3;
yy688:
	yych = *++cur;
	if (yych == 'x') goto yy756;
	goto yy3;
yy689:
	yych = *++cur;
	if (yych == 'y') goto yy757;
	goto yy3;
yy690:
	yych = *++cur;
	if (yych == 'r') goto yy758;
	goto yy3;
yy691:
	yych = *++cur;
	if (yych == 'a') goto yy759;
	goto yy3;
yy692:
	yych = *++cur;
	if (yych == 'c') goto yy760;
	goto yy3;
yy693:
	yych = *++cur;
	if (yych == 'b') goto yy761;
	goto yy3;
yy694:
	yych = *++cur;
	if (yych == 'a') goto yy762;
	goto yy3;
yy695:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 191 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_backup_ctx); }
#line 3643 "src/parse/conf_lexer.cc"
yy696:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 196 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_ctxmarker); }
#line 3649 "src/parse/conf_lexer.cc"
yy697:
	yych = *++cur;
	if (yych == 'd') goto yy763;
	goto yy3;
yy698:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 203 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_accept_get); }
#line 3659 "src/parse/conf_lexer.cc"
yy699:
	yych = *++cur;
	if (yych == 'a') goto yy764;
	goto yy3;
yy700:
	yych = *++cur;
	if (yych == 'I') goto yy765;
	goto yy3;
yy701:
	yych = *++cur;
	if (yych == 'n') goto yy766;
	goto yy3;
yy702:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 212 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_maxnmatch); }
#line 3677 "src/parse/conf_lexer.cc"
yy703:
	yych = *++cur;
	if (yych == 'X') goto yy767;
	goto yy3;
yy704:
	yych = *++cur;
	if (yych == 'G') goto yy768;
	goto yy3;
yy705:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 219 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_accept_set); }
#line 3691 "src/parse/conf_lexer.cc"
yy706:
	yych = *++cur;
	if (yych == 'a') goto yy769;
	goto yy3;
yy707:
	yych = *++cur;
	if (yych == 'o') goto yy770;
	goto yy343;
yy708:
	yych = *++cur;
	if (yych == 'I') goto yy771;
	goto yy3;
yy709:
	yych = *++cur;
	if (yych == 'n') goto yy772;
	goto yy3;
yy710:
	yych = *++cur;
	if (yych == 's') goto yy773;
	goto yy343;
yy711:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 228 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_mtag_shift); }
#line 3717 "src/parse/conf_lexer.cc"
yy712:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 227 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_stag_shift); }
#line 3723 "src/parse/conf_lexer.cc"
yy713:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
	goto yy387;
yy714:
	yych = *++cur;
	if (yych == 'i') goto yy774;
	goto yy3;
yy715:
	yych = *++cur;
	if (yych == 'e') goto yy775;
	goto yy3;
yy716:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 277 "../src/parse/conf_lexer.re"
	{ RET_CONF_FEAT(case_ranges, "case-ranges"); }
#line 3741 "src/parse/conf_lexer.cc"
yy717:
	yych = *++cur;
	if (yych == 'h') goto yy776;
	goto yy3;
yy718:
	yych = *++cur;
	if (yych == 't') goto yy777;
	goto yy3;
yy719:
	yych = *++cur;
	if (yych == 'r') goto yy778;
	goto yy3;
yy720:
	yych = *++cur;
	if (yych == 'o') goto yy780;
	goto yy343;
yy721:
	yych = *++cur;
	if (yych == 'f') goto yy781;
	goto yy3;
yy722:
	yych = *++cur;
	if (yych == 't') goto yy782;
	goto yy3;
yy723:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 288 "../src/parse/conf_lexer.re"
	{ goto empty_class; }
#line 3771 "src/parse/conf_lexer.cc"
yy724:
	yych = *++cur;
	if (yych == 'l') goto yy783;
	goto yy3;
yy725:
	yych = *++cur;
	if (yych == 'c') goto yy784;
	goto yy3;
yy726:
	yych = *++cur;
	if (yych == 's') goto yy785;
	goto yy3;
yy727:
	yych = *++cur;
	if (yych == 'f') goto yy786;
	goto yy3;
yy728:
	yych = *++cur;
	if (yych == 't') goto yy787;
	goto yy3;
yy729:
	yych = *++cur;
	if (yych == 'i') goto yy788;
	goto yy3;
yy730:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
	goto yy61;
yy731:
	yych = *++cur;
	if (yych == 'o') goto yy789;
	goto yy3;
yy732:
	yych = *++cur;
	if (yych == '-') goto yy790;
	goto yy3;
yy733:
	yych = *++cur;
	if (yych == 'h') goto yy11;
	goto yy3;
yy734:
	yych = *++cur;
	if (yych == 'd') goto yy791;
	goto yy3;
yy735:
	yych = *++cur;
	if (yych == '6') goto yy404;
	goto yy3;
yy736:
	yych = *++cur;
	if (yych == 'c') goto yy792;
	goto yy3;
yy737:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 126 "../src/parse/conf_lexer.re"
	{ RET_STXCONF_BOOL(flex_syntax); }
#line 3829 "src/parse/conf_lexer.cc"
yy738:
	yych = *++cur;
	if (yych == 'n') goto yy793;
	goto yy3;
yy739:
	yych = *++cur;
	if (yych == 'i') goto yy794;
	goto yy3;
yy740:
	yych = *++cur;
	if (yych == 'u') goto yy795;
	goto yy3;
yy741:
	yych = *++cur;
	if (yych == 'l') goto yy796;
	goto yy3;
yy742:
	yych = *++cur;
	if (yych == 't') goto yy797;
	goto yy3;
yy743:
	yych = *++cur;
	if (yych == 'l') goto yy798;
	goto yy3;
yy744:
	yych = *++cur;
	if (yych == 'p') goto yy799;
	goto yy3;
yy745:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 293 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(label_prefix); }
#line 3863 "src/parse/conf_lexer.cc"
yy746:
	yych = *++cur;
	if (yych == 'p') goto yy63;
	goto yy3;
yy747:
	yych = *++cur;
	if (yych == 'r') goto yy800;
	goto yy3;
yy748:
	yych = *++cur;
	if (yych == 'a') goto yy801;
	goto yy3;
yy749:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yybm[0+yych] & 64) goto yy749;
	if (yych != '=') goto yy343;
yy750:
	++cur;
	if ((lim - cur) < 2) YYFILL(2);
	yych = *cur;
	if (yych <= ' ') {
		if (yych <= '\f') {
			if (yych == '\t') goto yy750;
			goto yy343;
		} else {
			if (yych <= '\r') goto yy750;
			if (yych <= 0x1F) goto yy343;
			goto yy750;
		}
	} else {
		if (yych <= '/') {
			if (yych == '-') goto yy802;
			goto yy343;
		} else {
			if (yych <= '0') goto yy803;
			if (yych <= '9') goto yy805;
			goto yy343;
		}
	}
yy751:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 267 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(state_abort); }
#line 3910 "src/parse/conf_lexer.cc"
yy752:
	yych = *++cur;
	if (yych == 'a') goto yy806;
	goto yy3;
yy753:
	yych = *++cur;
	if (yych == 'a') goto yy807;
	goto yy3;
yy754:
	yych = *++cur;
	if (yych == 's') goto yy808;
	goto yy3;
yy755:
	yych = *++cur;
	if (yych == 'v') goto yy809;
	goto yy3;
yy756:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 185 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(tags_prefix); }
#line 3932 "src/parse/conf_lexer.cc"
yy757:
	yych = *++cur;
	switch (yych) {
		case 'a': goto yy95;
		case 'b': goto yy96;
		case 'c': goto yy97;
		case 'f': goto yy810;
		case 'n': goto yy99;
		case 'p': goto yy100;
		case 'r': goto yy101;
		case 's': goto yy102;
		case 't': goto yy103;
		default: goto yy3;
	}
yy758:
	yych = *++cur;
	if (yych == 's') goto yy811;
	goto yy3;
yy759:
	yych = *++cur;
	if (yych == 'l') goto yy812;
	goto yy3;
yy760:
	yych = *++cur;
	if (yych == 'k') goto yy813;
	goto yy3;
yy761:
	yych = *++cur;
	if (yych == 'l') goto yy814;
	goto yy3;
yy762:
	yych = *++cur;
	if (yych == 'm') goto yy815;
	goto yy3;
yy763:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 202 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(fill_naked); }
#line 3972 "src/parse/conf_lexer.cc"
yy764:
	yych = *++cur;
	if (yych == 'k') goto yy816;
	goto yy3;
yy765:
	yych = *++cur;
	if (yych == 'O') goto yy817;
	goto yy3;
yy766:
	yych = *++cur;
	if (yych == 'a') goto yy818;
	goto yy3;
yy767:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 217 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_restore_ctx); }
#line 3990 "src/parse/conf_lexer.cc"
yy768:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 218 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_restore_tag); }
#line 3996 "src/parse/conf_lexer.cc"
yy769:
	yych = *++cur;
	if (yych == 'k') goto yy819;
	goto yy3;
yy770:
	yych = *++cur;
	if (yych == 'n') goto yy820;
	goto yy343;
yy771:
	yych = *++cur;
	if (yych == 'O') goto yy821;
	goto yy3;
yy772:
	yych = *++cur;
	if (yych == 'a') goto yy822;
	goto yy3;
yy773:
	yych = *++cur;
	if (yych == 't') goto yy823;
	goto yy343;
yy774:
	yych = *++cur;
	if (yych == 't') goto yy824;
	goto yy3;
yy775:
	yych = *++cur;
	if (yych == 'd') goto yy825;
	goto yy3;
yy776:
	yych = *++cur;
	if (yych == 'o') goto yy826;
	goto yy3;
yy777:
	yych = *++cur;
	if (yych == 'o') goto yy827;
	goto yy3;
yy778:
	yyaccept = 5;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 32) goto yy2;
	if (yych == '@') goto yy828;
yy779:
#line 262 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(cond_div); }
#line 4041 "src/parse/conf_lexer.cc"
yy780:
	yych = *++cur;
	if (yych == 'n') goto yy829;
	goto yy343;
yy781:
	yych = *++cur;
	if (yych == 'i') goto yy830;
	goto yy3;
yy782:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
	goto yy390;
yy783:
	yych = *++cur;
	if (yych == 'i') goto yy831;
	goto yy3;
yy784:
	yych = *++cur;
	if (yych == 'd') goto yy832;
	goto yy3;
yy785:
	yych = *++cur;
	if (yych == '2') goto yy833;
	goto yy3;
yy786:
	yych = *++cur;
	if (yych <= '2') {
		if (yych == '1') goto yy735;
		goto yy3;
	} else {
		if (yych <= '3') goto yy834;
		if (yych == '8') goto yy383;
		goto yy3;
	}
yy787:
	yych = *++cur;
	if (yych == 'e') goto yy835;
	goto yy3;
yy788:
	yych = *++cur;
	if (yych == 'n') goto yy836;
	goto yy3;
yy789:
	yych = *++cur;
	if (yych == 's') goto yy837;
	goto yy3;
yy790:
	yych = *++cur;
	if (yych == 'c') goto yy838;
	goto yy3;
yy791:
	yych = *++cur;
	if (yych == 'e') goto yy839;
	goto yy3;
yy792:
	yych = *++cur;
	if (yych == 'h') goto yy840;
	goto yy3;
yy793:
	yych = *++cur;
	if (yych == 'g') goto yy841;
	goto yy3;
yy794:
	yych = *++cur;
	if (yych == 'n') goto yy842;
	goto yy3;
yy795:
	yych = *++cur;
	if (yych == 'r') goto yy843;
	goto yy3;
yy796:
	yych = *++cur;
	if (yych == 'L') goto yy844;
	goto yy3;
yy797:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 296 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(label_next); }
#line 4121 "src/parse/conf_lexer.cc"
yy798:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 294 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(label_fill); }
#line 4127 "src/parse/conf_lexer.cc"
yy799:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 295 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(label_loop); }
#line 4133 "src/parse/conf_lexer.cc"
yy800:
	yych = *++cur;
	if (yych == 'e') goto yy845;
	goto yy3;
yy801:
	yych = *++cur;
	if (yych == 'r') goto yy846;
	goto yy3;
yy802:
	yych = *++cur;
	if (yych <= '0') goto yy343;
	if (yych <= '9') goto yy805;
	goto yy343;
yy803:
	++cur;
yy804:
	cur = ctx;
#line 297 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(label_start_force); }
#line 4153 "src/parse/conf_lexer.cc"
yy805:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yybm[0+yych] & 128) goto yy805;
	goto yy804;
yy806:
	yych = *++cur;
	if (yych == 'b') goto yy847;
	goto yy3;
yy807:
	yych = *++cur;
	if (yych == 't') goto yy848;
	goto yy3;
yy808:
	yych = *++cur;
	if (yych == 'i') goto yy849;
	goto yy3;
yy809:
	yych = *++cur;
	if (yych == 'e') goto yy850;
	goto yy3;
yy810:
	yych = *++cur;
	if (yych == 'i') goto yy851;
	goto yy3;
yy811:
	yych = *++cur;
	if (yych == 'i') goto yy852;
	goto yy3;
yy812:
	yych = *++cur;
	if (yych == 's') goto yy853;
	goto yy3;
yy813:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 152 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(fill_check); }
#line 4193 "src/parse/conf_lexer.cc"
yy814:
	yych = *++cur;
	if (yych == 'e') goto yy854;
	goto yy3;
yy815:
	yych = *++cur;
	if (yych == 'e') goto yy855;
	goto yy3;
yy816:
	yych = *++cur;
	if (yych == 'e') goto yy856;
	goto yy3;
yy817:
	yych = *++cur;
	if (yych == 'N') goto yy857;
	goto yy3;
yy818:
	yych = *++cur;
	if (yych == 'k') goto yy858;
	goto yy3;
yy819:
	yych = *++cur;
	if (yych == 'e') goto yy859;
	goto yy3;
yy820:
	yych = *++cur;
	if (yych == 'd') goto yy860;
	goto yy343;
yy821:
	yych = *++cur;
	if (yych == 'N') goto yy861;
	goto yy3;
yy822:
	yych = *++cur;
	if (yych == 'k') goto yy862;
	goto yy3;
yy823:
	yych = *++cur;
	if (yych == 'a') goto yy863;
	goto yy343;
yy824:
	yych = *++cur;
	if (yych == 'i') goto yy864;
	goto yy3;
yy825:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 276 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(case_inverted); }
#line 4243 "src/parse/conf_lexer.cc"
yy826:
	yych = *++cur;
	if (yych == 'l') goto yy865;
	goto yy3;
yy827:
	yych = *++cur;
	if (yych == 's') goto yy866;
	goto yy3;
yy828:
	yych = *++cur;
	if (yych == 'c') goto yy867;
	goto yy343;
yy829:
	yych = *++cur;
	if (yych == 'd') goto yy868;
	goto yy343;
yy830:
	yych = *++cur;
	if (yych == 'x') goto yy869;
	goto yy3;
yy831:
	yych = *++cur;
	if (yych == 'c') goto yy870;
	goto yy3;
yy832:
	yych = *++cur;
	if (yych == 'i') goto yy871;
	goto yy3;
yy833:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
	goto yy403;
yy834:
	yych = *++cur;
	if (yych == '2') goto yy839;
	goto yy3;
yy835:
	yych = *++cur;
	if (yych == 'd') goto yy872;
	goto yy3;
yy836:
	yych = *++cur;
	if (yych == 'g') goto yy873;
	goto yy3;
yy837:
	yych = *++cur;
	if (yych == 't') goto yy874;
	goto yy3;
yy838:
	yych = *++cur;
	if (yych == 'a') goto yy875;
	goto yy3;
yy839:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
	goto yy401;
yy840:
	yych = *++cur;
	if (yych == 'a') goto yy876;
	goto yy3;
yy841:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 290 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(indent_str); }
#line 4309 "src/parse/conf_lexer.cc"
yy842:
	yych = *++cur;
	if (yych == 'g') goto yy877;
	goto yy3;
yy843:
	yych = *++cur;
	if (yych == 'e') goto yy878;
	goto yy3;
yy844:
	yych = *++cur;
	if (yych == 'a') goto yy879;
	goto yy3;
yy845:
	yych = *++cur;
	if (yych == 's') goto yy384;
	goto yy3;
yy846:
	yych = *++cur;
	if (yych == 's') goto yy880;
	goto yy3;
yy847:
	yych = *++cur;
	if (yych == 'e') goto yy881;
	goto yy3;
yy848:
	yych = *++cur;
	if (yych == 'e') goto yy882;
	goto yy3;
yy849:
	yych = *++cur;
	if (yych == 'o') goto yy883;
	goto yy3;
yy850:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 187 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(tags_negative); }
#line 4347 "src/parse/conf_lexer.cc"
yy851:
	yych = *++cur;
	if (yych == 'l') goto yy884;
	goto yy3;
yy852:
	yych = *++cur;
	if (yych == 'o') goto yy885;
	goto yy3;
yy853:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 252 "../src/parse/conf_lexer.re"
	{ goto char_lit; }
#line 4361 "src/parse/conf_lexer.cc"
yy854:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 150 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(fill_enable); }
#line 4367 "src/parse/conf_lexer.cc"
yy855:
	yych = *++cur;
	if (yych == 't') goto yy886;
	goto yy3;
yy856:
	yych = *++cur;
	if (yych == 'd') goto yy887;
	goto yy3;
yy857:
	yych = *++cur;
	if (yych <= '@') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
			goto yy542;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy624;
			goto yy542;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy2;
			if (yych <= '^') goto yy542;
			goto yy2;
		} else {
			if (yych <= '`') goto yy542;
			if (yych <= 'z') goto yy2;
			goto yy542;
		}
	}
yy858:
	yych = *++cur;
	if (yych == 'e') goto yy888;
	goto yy3;
yy859:
	yych = *++cur;
	if (yych == 'd') goto yy889;
	goto yy3;
yy860:
	++cur;
#line 221 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(cond_set_param); }
#line 4410 "src/parse/conf_lexer.cc"
yy861:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '?') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
			goto yy551;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy633;
			goto yy551;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy634;
			if (yych <= 'Z') goto yy2;
			goto yy551;
		} else {
			if (yych == '`') goto yy551;
			if (yych <= 'z') goto yy2;
			goto yy551;
		}
	}
yy862:
	yych = *++cur;
	if (yych == 'e') goto yy890;
	goto yy3;
yy863:
	yych = *++cur;
	if (yych == 't') goto yy891;
	goto yy343;
yy864:
	yych = *++cur;
	if (yych == 'v') goto yy892;
	goto yy3;
yy865:
	yych = *++cur;
	if (yych == 'd') goto yy893;
	goto yy3;
yy866:
	yych = *++cur;
	if (yych <= '@') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
			goto yy394;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy278;
			goto yy394;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy2;
			if (yych <= '^') goto yy394;
			goto yy2;
		} else {
			if (yych <= '`') goto yy394;
			if (yych <= 'z') goto yy2;
			goto yy394;
		}
	}
yy867:
	yych = *++cur;
	if (yych == 'o') goto yy894;
	goto yy343;
yy868:
	++cur;
#line 265 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(cond_goto_param); }
#line 4480 "src/parse/conf_lexer.cc"
yy869:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 261 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(cond_enum_prefix); }
#line 4486 "src/parse/conf_lexer.cc"
yy870:
	yych = *++cur;
	if (yych == 'y') goto yy895;
	goto yy3;
yy871:
	yych = *++cur;
	if (yych == 'c') goto yy577;
	goto yy3;
yy872:
	yych = *++cur;
	if (yych == '-') goto yy896;
	goto yy3;
yy873:
	yych = *++cur;
	if (yych == '-') goto yy573;
	goto yy3;
yy874:
	yych = *++cur;
	if (yych == '-') goto yy897;
	goto yy3;
yy875:
	yych = *++cur;
	if (yych == 'p') goto yy898;
	goto yy3;
yy876:
	yych = *++cur;
	if (yych == 'r') goto yy899;
	goto yy3;
yy877:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 121 "../src/parse/conf_lexer.re"
	{ goto input_enc; }
#line 4520 "src/parse/conf_lexer.cc"
yy878:
	yych = *++cur;
	if (yych == 's') goto yy900;
	goto yy3;
yy879:
	yych = *++cur;
	if (yych == 'b') goto yy901;
	goto yy3;
yy880:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 178 "../src/parse/conf_lexer.re"
	{
        CHECK_RET(lex_conf_bool(opts));
        SETOPT(captures, tmp_bool);
        SETOPT(captures_posix, tmp_bool);
        SETOPT(captures_array, false);
        return Ret::OK;
    }
#line 4540 "src/parse/conf_lexer.cc"
yy881:
	yych = *++cur;
	if (yych == 'l') goto yy902;
	goto yy3;
yy882:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 125 "../src/parse/conf_lexer.re"
	{ RET_STXCONF_BOOL(storable_state); }
#line 4550 "src/parse/conf_lexer.cc"
yy883:
	yych = *++cur;
	if (yych == 'n') goto yy903;
	goto yy3;
yy884:
	yych = *++cur;
	if (yych == 'l') goto yy904;
	goto yy3;
yy885:
	yych = *++cur;
	if (yych == 'n') goto yy905;
	goto yy3;
yy886:
	yych = *++cur;
	if (yych == 'e') goto yy906;
	goto yy3;
yy887:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 205 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(cond_get_naked); }
#line 4572 "src/parse/conf_lexer.cc"
yy888:
	yych = *++cur;
	if (yych == 'd') goto yy907;
	goto yy3;
yy889:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 222 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(cond_set_naked); }
#line 4582 "src/parse/conf_lexer.cc"
yy890:
	yych = *++cur;
	if (yych == 'd') goto yy908;
	goto yy3;
yy891:
	yych = *++cur;
	if (yych == 'e') goto yy909;
	goto yy343;
yy892:
	yych = *++cur;
	if (yych == 'e') goto yy910;
	goto yy3;
yy893:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 273 "../src/parse/conf_lexer.re"
	{ RET_CONF_NUM_NONNEG(computed_gotos_threshold); }
#line 4600 "src/parse/conf_lexer.cc"
yy894:
	yych = *++cur;
	if (yych == 'n') goto yy911;
	goto yy343;
yy895:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 287 "../src/parse/conf_lexer.re"
	{ goto encoding_policy; }
#line 4610 "src/parse/conf_lexer.cc"
yy896:
	yych = *++cur;
	if (yych == 'g') goto yy912;
	goto yy3;
yy897:
	yych = *++cur;
	if (yych == 'c') goto yy913;
	goto yy3;
yy898:
	yych = *++cur;
	if (yych == 't') goto yy914;
	goto yy3;
yy899:
	yych = *++cur;
	if (yych == 's') goto yy833;
	goto yy3;
yy900:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 188 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(captures_invert); }
#line 4632 "src/parse/conf_lexer.cc"
yy901:
	yych = *++cur;
	if (yych == 'e') goto yy743;
	goto yy3;
yy902:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 268 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(state_next); }
#line 4642 "src/parse/conf_lexer.cc"
yy903:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 186 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(tags_expression); }
#line 4648 "src/parse/conf_lexer.cc"
yy904:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
	goto yy325;
yy905:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 251 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(char_conv); }
#line 4658 "src/parse/conf_lexer.cc"
yy906:
	yych = *++cur;
	if (yych == 'r') goto yy915;
	goto yy3;
yy907:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 207 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(state_get_naked); }
#line 4668 "src/parse/conf_lexer.cc"
yy908:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 224 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(state_set_naked); }
#line 4674 "src/parse/conf_lexer.cc"
yy909:
	++cur;
#line 225 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(state_set_param); }
#line 4679 "src/parse/conf_lexer.cc"
yy910:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 275 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(case_insensitive); }
#line 4685 "src/parse/conf_lexer.cc"
yy911:
	yych = *++cur;
	if (yych == 'd') goto yy916;
	goto yy343;
yy912:
	yych = *++cur;
	if (yych == 'o') goto yy917;
	goto yy3;
yy913:
	yych = *++cur;
	if (yych == 'a') goto yy918;
	goto yy3;
yy914:
	yych = *++cur;
	if (yych == 'u') goto yy747;
	goto yy3;
yy915:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 151 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(fill_param_enable); }
#line 4707 "src/parse/conf_lexer.cc"
yy916:
	++cur;
#line 263 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(cond_div_param); }
#line 4712 "src/parse/conf_lexer.cc"
yy917:
	yych = *++cur;
	if (yych == 't') goto yy919;
	goto yy3;
yy918:
	yych = *++cur;
	if (yych == 'p') goto yy575;
	goto yy3;
yy919:
	yych = *++cur;
	if (yych != 'o') goto yy3;
	yych = *++cur;
	if (yych == 's') goto yy393;
	goto yy3;
}
#line 304 "../src/parse/conf_lexer.re"


target:
    CHECK_RET(lex_conf_assign());

#line 4734 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	if ((lim - cur) < 8) YYFILL(8);
	yych = *cur;
	if (yych <= 'd') {
		if (yych <= 'b') goto yy921;
		if (yych <= 'c') goto yy923;
		goto yy924;
	} else {
		if (yych == 's') goto yy925;
	}
yy921:
	++cur;
yy922:
#line 309 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_cur("bad configuration value (expected: 'code', 'skeleton', 'dot')"));
    }
#line 4753 "src/parse/conf_lexer.cc"
yy923:
	yych = *(mar = ++cur);
	if (yych == 'o') goto yy926;
	goto yy922;
yy924:
	yych = *(mar = ++cur);
	if (yych == 'o') goto yy928;
	goto yy922;
yy925:
	yych = *(mar = ++cur);
	if (yych == 'k') goto yy929;
	goto yy922;
yy926:
	yych = *++cur;
	if (yych == 'd') goto yy930;
yy927:
	cur = mar;
	goto yy922;
yy928:
	yych = *++cur;
	if (yych == 't') goto yy931;
	goto yy927;
yy929:
	yych = *++cur;
	if (yych == 'e') goto yy932;
	goto yy927;
yy930:
	yych = *++cur;
	if (yych == 'e') goto yy933;
	goto yy927;
yy931:
	++cur;
#line 314 "../src/parse/conf_lexer.re"
	{ SETCONOPT(target, Target::DOT);      goto end; }
#line 4788 "src/parse/conf_lexer.cc"
yy932:
	yych = *++cur;
	if (yych == 'l') goto yy934;
	goto yy927;
yy933:
	++cur;
#line 312 "../src/parse/conf_lexer.re"
	{ SETCONOPT(target, Target::CODE);     goto end; }
#line 4797 "src/parse/conf_lexer.cc"
yy934:
	yych = *++cur;
	if (yych != 'e') goto yy927;
	yych = *++cur;
	if (yych != 't') goto yy927;
	yych = *++cur;
	if (yych != 'o') goto yy927;
	yych = *++cur;
	if (yych != 'n') goto yy927;
	++cur;
#line 313 "../src/parse/conf_lexer.re"
	{ SETCONOPT(target, Target::SKELETON); goto end; }
#line 4810 "src/parse/conf_lexer.cc"
}
#line 315 "../src/parse/conf_lexer.re"


code_model:
    CHECK_RET(lex_conf_assign());

#line 4818 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	if ((lim - cur) < 19) YYFILL(19);
	yych = *cur;
	if (yych <= 'k') {
		if (yych == 'g') goto yy937;
	} else {
		if (yych <= 'l') goto yy938;
		if (yych == 'r') goto yy939;
	}
	++cur;
yy936:
#line 320 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_cur("bad configuration value"
            " (expected: 'goto-label', 'loop-switch', 'recursive-functions')"));
    }
#line 4836 "src/parse/conf_lexer.cc"
yy937:
	yych = *(mar = ++cur);
	if (yych == 'o') goto yy940;
	goto yy936;
yy938:
	yych = *(mar = ++cur);
	if (yych == 'o') goto yy942;
	goto yy936;
yy939:
	yych = *(mar = ++cur);
	if (yych == 'e') goto yy943;
	goto yy936;
yy940:
	yych = *++cur;
	if (yych == 't') goto yy944;
yy941:
	cur = mar;
	goto yy936;
yy942:
	yych = *++cur;
	if (yych == 'o') goto yy945;
	goto yy941;
yy943:
	yych = *++cur;
	if (yych == 'c') goto yy946;
	goto yy941;
yy944:
	yych = *++cur;
	if (yych == 'o') goto yy947;
	goto yy941;
yy945:
	yych = *++cur;
	if (yych == 'p') goto yy948;
	goto yy941;
yy946:
	yych = *++cur;
	if (yych == 'u') goto yy949;
	goto yy941;
yy947:
	yych = *++cur;
	if (yych == '-') goto yy950;
	goto yy941;
yy948:
	yych = *++cur;
	if (yych == '-') goto yy951;
	goto yy941;
yy949:
	yych = *++cur;
	if (yych == 'r') goto yy952;
	goto yy941;
yy950:
	yych = *++cur;
	if (yych == 'l') goto yy953;
	goto yy941;
yy951:
	yych = *++cur;
	if (yych == 's') goto yy954;
	goto yy941;
yy952:
	yych = *++cur;
	if (yych == 's') goto yy955;
	goto yy941;
yy953:
	yych = *++cur;
	if (yych == 'a') goto yy956;
	goto yy941;
yy954:
	yych = *++cur;
	if (yych == 'w') goto yy957;
	goto yy941;
yy955:
	yych = *++cur;
	if (yych == 'i') goto yy958;
	goto yy941;
yy956:
	yych = *++cur;
	if (yych == 'b') goto yy959;
	goto yy941;
yy957:
	yych = *++cur;
	if (yych == 'i') goto yy960;
	goto yy941;
yy958:
	yych = *++cur;
	if (yych == 'v') goto yy961;
	goto yy941;
yy959:
	yych = *++cur;
	if (yych == 'e') goto yy962;
	goto yy941;
yy960:
	yych = *++cur;
	if (yych == 't') goto yy963;
	goto yy941;
yy961:
	yych = *++cur;
	if (yych == 'e') goto yy964;
	goto yy941;
yy962:
	yych = *++cur;
	if (yych == 'l') goto yy965;
	goto yy941;
yy963:
	yych = *++cur;
	if (yych == 'c') goto yy966;
	goto yy941;
yy964:
	yych = *++cur;
	if (yych == '-') goto yy967;
	goto yy941;
yy965:
	++cur;
#line 324 "../src/parse/conf_lexer.re"
	{ SETCONOPT(code_model, CodeModel::GOTO_LABEL);  goto end; }
#line 4951 "src/parse/conf_lexer.cc"
yy966:
	yych = *++cur;
	if (yych == 'h') goto yy968;
	goto yy941;
yy967:
	yych = *++cur;
	if (yych == 'f') goto yy969;
	goto yy941;
yy968:
	++cur;
#line 325 "../src/parse/conf_lexer.re"
	{ SETCONOPT(code_model, CodeModel::LOOP_SWITCH); goto end; }
#line 4964 "src/parse/conf_lexer.cc"
yy969:
	yych = *++cur;
	if (yych != 'u') goto yy941;
	yych = *++cur;
	if (yych != 'n') goto yy941;
	yych = *++cur;
	if (yych != 'c') goto yy941;
	yych = *++cur;
	if (yych != 't') goto yy941;
	yych = *++cur;
	if (yych != 'i') goto yy941;
	yych = *++cur;
	if (yych != 'o') goto yy941;
	yych = *++cur;
	if (yych != 'n') goto yy941;
	yych = *++cur;
	if (yych != 's') goto yy941;
	++cur;
#line 326 "../src/parse/conf_lexer.re"
	{ SETCONOPT(code_model, CodeModel::REC_FUNC);    goto end; }
#line 4985 "src/parse/conf_lexer.cc"
}
#line 327 "../src/parse/conf_lexer.re"


input_enc:
    CHECK_RET(lex_conf_assign());

#line 4993 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	if ((lim - cur) < 5) YYFILL(5);
	yych = *cur;
	if (yych == 'a') goto yy972;
	if (yych == 'u') goto yy973;
	++cur;
yy971:
#line 332 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_cur("bad configuration value (expected: 'ascii', 'utf8')"));
    }
#line 5006 "src/parse/conf_lexer.cc"
yy972:
	yych = *(mar = ++cur);
	if (yych == 's') goto yy974;
	goto yy971;
yy973:
	yych = *(mar = ++cur);
	if (yych == 't') goto yy976;
	goto yy971;
yy974:
	yych = *++cur;
	if (yych == 'c') goto yy977;
yy975:
	cur = mar;
	goto yy971;
yy976:
	yych = *++cur;
	if (yych == 'f') goto yy978;
	goto yy975;
yy977:
	yych = *++cur;
	if (yych == 'i') goto yy979;
	goto yy975;
yy978:
	yych = *++cur;
	if (yych == '8') goto yy980;
	goto yy975;
yy979:
	yych = *++cur;
	if (yych == 'i') goto yy981;
	goto yy975;
yy980:
	++cur;
#line 336 "../src/parse/conf_lexer.re"
	{ SETCONOPT(input_encoding, Enc::Type::UTF8);  goto end; }
#line 5041 "src/parse/conf_lexer.cc"
yy981:
	++cur;
#line 335 "../src/parse/conf_lexer.re"
	{ SETCONOPT(input_encoding, Enc::Type::ASCII); goto end; }
#line 5046 "src/parse/conf_lexer.cc"
}
#line 337 "../src/parse/conf_lexer.re"


input:
    CHECK_RET(lex_conf_assign());

#line 5054 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	if ((lim - cur) < 7) YYFILL(7);
	yych = *cur;
	switch (yych) {
		case 'c': goto yy985;
		case 'd': goto yy986;
		case 'g': goto yy987;
		case 'r': goto yy988;
		case 's': goto yy989;
		default: goto yy983;
	}
yy983:
	++cur;
yy984:
#line 342 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_cur("bad configuration value (expected: 'simple', 'generic', 'record')"));
    }
#line 5074 "src/parse/conf_lexer.cc"
yy985:
	yych = *(mar = ++cur);
	if (yych == 'u') goto yy990;
	goto yy984;
yy986:
	yych = *(mar = ++cur);
	if (yych == 'e') goto yy992;
	goto yy984;
yy987:
	yych = *(mar = ++cur);
	if (yych == 'e') goto yy993;
	goto yy984;
yy988:
	yych = *(mar = ++cur);
	if (yych == 'e') goto yy994;
	goto yy984;
yy989:
	yych = *(mar = ++cur);
	if (yych == 'i') goto yy995;
	goto yy984;
yy990:
	yych = *++cur;
	if (yych == 's') goto yy996;
yy991:
	cur = mar;
	goto yy984;
yy992:
	yych = *++cur;
	if (yych == 'f') goto yy997;
	goto yy991;
yy993:
	yych = *++cur;
	if (yych == 'n') goto yy998;
	goto yy991;
yy994:
	yych = *++cur;
	if (yych == 'c') goto yy999;
	goto yy991;
yy995:
	yych = *++cur;
	if (yych == 'm') goto yy1000;
	goto yy991;
yy996:
	yych = *++cur;
	if (yych == 't') goto yy1001;
	goto yy991;
yy997:
	yych = *++cur;
	if (yych == 'a') goto yy1002;
	goto yy991;
yy998:
	yych = *++cur;
	if (yych == 'e') goto yy1003;
	goto yy991;
yy999:
	yych = *++cur;
	if (yych == 'o') goto yy1004;
	goto yy991;
yy1000:
	yych = *++cur;
	if (yych == 'p') goto yy1005;
	goto yy991;
yy1001:
	yych = *++cur;
	if (yych == 'o') goto yy1006;
	goto yy991;
yy1002:
	yych = *++cur;
	if (yych == 'u') goto yy1007;
	goto yy991;
yy1003:
	yych = *++cur;
	if (yych == 'r') goto yy1008;
	goto yy991;
yy1004:
	yych = *++cur;
	if (yych == 'r') goto yy1009;
	goto yy991;
yy1005:
	yych = *++cur;
	if (yych == 'l') goto yy1010;
	goto yy991;
yy1006:
	yych = *++cur;
	if (yych == 'm') goto yy1011;
	goto yy991;
yy1007:
	yych = *++cur;
	if (yych == 'l') goto yy1012;
	goto yy991;
yy1008:
	yych = *++cur;
	if (yych == 'i') goto yy1013;
	goto yy991;
yy1009:
	yych = *++cur;
	if (yych == 'd') goto yy1014;
	goto yy991;
yy1010:
	yych = *++cur;
	if (yych == 'e') goto yy1015;
	goto yy991;
yy1011:
	++cur;
#line 346 "../src/parse/conf_lexer.re"
	{ SETOPT(api, Api::GENERIC); goto end; }
#line 5181 "src/parse/conf_lexer.cc"
yy1012:
	yych = *++cur;
	if (yych == 't') goto yy1015;
	goto yy991;
yy1013:
	yych = *++cur;
	if (yych == 'c') goto yy1011;
	goto yy991;
yy1014:
	++cur;
#line 347 "../src/parse/conf_lexer.re"
	{ SETOPT(api, Api::RECORD);  goto end; }
#line 5194 "src/parse/conf_lexer.cc"
yy1015:
	++cur;
#line 345 "../src/parse/conf_lexer.re"
	{ SETOPT(api, Api::SIMPLE);  goto end; }
#line 5199 "src/parse/conf_lexer.cc"
}
#line 348 "../src/parse/conf_lexer.re"


api_style:
    CHECK_RET(lex_conf_assign());

#line 5207 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	if ((lim - cur) < 9) YYFILL(9);
	yych = *cur;
	if (yych == 'f') goto yy1018;
	++cur;
yy1017:
#line 353 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_cur("bad configuration value (expected: 'functions', 'free-form')"));
    }
#line 5219 "src/parse/conf_lexer.cc"
yy1018:
	yych = *(mar = ++cur);
	if (yych == 'r') goto yy1019;
	if (yych == 'u') goto yy1021;
	goto yy1017;
yy1019:
	yych = *++cur;
	if (yych == 'e') goto yy1022;
yy1020:
	cur = mar;
	goto yy1017;
yy1021:
	yych = *++cur;
	if (yych == 'n') goto yy1023;
	goto yy1020;
yy1022:
	yych = *++cur;
	if (yych == 'e') goto yy1024;
	goto yy1020;
yy1023:
	yych = *++cur;
	if (yych == 'c') goto yy1025;
	goto yy1020;
yy1024:
	yych = *++cur;
	if (yych == '-') goto yy1026;
	goto yy1020;
yy1025:
	yych = *++cur;
	if (yych == 't') goto yy1027;
	goto yy1020;
yy1026:
	yych = *++cur;
	if (yych == 'f') goto yy1028;
	goto yy1020;
yy1027:
	yych = *++cur;
	if (yych == 'i') goto yy1029;
	goto yy1020;
yy1028:
	yych = *++cur;
	if (yych == 'o') goto yy1030;
	goto yy1020;
yy1029:
	yych = *++cur;
	if (yych == 'o') goto yy1031;
	goto yy1020;
yy1030:
	yych = *++cur;
	if (yych == 'r') goto yy1032;
	goto yy1020;
yy1031:
	yych = *++cur;
	if (yych == 'n') goto yy1033;
	goto yy1020;
yy1032:
	yych = *++cur;
	if (yych == 'm') goto yy1034;
	goto yy1020;
yy1033:
	yych = *++cur;
	if (yych == 's') goto yy1035;
	goto yy1020;
yy1034:
	++cur;
#line 357 "../src/parse/conf_lexer.re"
	{ SETOPT(api_style, ApiStyle::FREEFORM);  goto end; }
#line 5287 "src/parse/conf_lexer.cc"
yy1035:
	++cur;
#line 356 "../src/parse/conf_lexer.re"
	{ SETOPT(api_style, ApiStyle::FUNCTIONS); goto end; }
#line 5292 "src/parse/conf_lexer.cc"
}
#line 358 "../src/parse/conf_lexer.re"


encoding_policy:
    CHECK_RET(lex_conf_assign());

#line 5300 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	if ((lim - cur) < 10) YYFILL(10);
	yych = *cur;
	if (yych <= 'h') {
		if (yych == 'f') goto yy1038;
	} else {
		if (yych <= 'i') goto yy1039;
		if (yych == 's') goto yy1040;
	}
	++cur;
yy1037:
#line 363 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_cur(
                "bad configuration value (expected: 'ignore', 'substitute', 'fail')"));
    }
#line 5318 "src/parse/conf_lexer.cc"
yy1038:
	yych = *(mar = ++cur);
	if (yych == 'a') goto yy1041;
	goto yy1037;
yy1039:
	yych = *(mar = ++cur);
	if (yych == 'g') goto yy1043;
	goto yy1037;
yy1040:
	yych = *(mar = ++cur);
	if (yych == 'u') goto yy1044;
	goto yy1037;
yy1041:
	yych = *++cur;
	if (yych == 'i') goto yy1045;
yy1042:
	cur = mar;
	goto yy1037;
yy1043:
	yych = *++cur;
	if (yych == 'n') goto yy1046;
	goto yy1042;
yy1044:
	yych = *++cur;
	if (yych == 'b') goto yy1047;
	goto yy1042;
yy1045:
	yych = *++cur;
	if (yych == 'l') goto yy1048;
	goto yy1042;
yy1046:
	yych = *++cur;
	if (yych == 'o') goto yy1049;
	goto yy1042;
yy1047:
	yych = *++cur;
	if (yych == 's') goto yy1050;
	goto yy1042;
yy1048:
	++cur;
#line 369 "../src/parse/conf_lexer.re"
	{ SETOPT(encoding_policy, Enc::Policy::FAIL);       goto end; }
#line 5361 "src/parse/conf_lexer.cc"
yy1049:
	yych = *++cur;
	if (yych == 'r') goto yy1051;
	goto yy1042;
yy1050:
	yych = *++cur;
	if (yych == 't') goto yy1052;
	goto yy1042;
yy1051:
	yych = *++cur;
	if (yych == 'e') goto yy1053;
	goto yy1042;
yy1052:
	yych = *++cur;
	if (yych == 'i') goto yy1054;
	goto yy1042;
yy1053:
	++cur;
#line 367 "../src/parse/conf_lexer.re"
	{ SETOPT(encoding_policy, Enc::Policy::IGNORE);     goto end; }
#line 5382 "src/parse/conf_lexer.cc"
yy1054:
	yych = *++cur;
	if (yych != 't') goto yy1042;
	yych = *++cur;
	if (yych != 'u') goto yy1042;
	yych = *++cur;
	if (yych != 't') goto yy1042;
	yych = *++cur;
	if (yych != 'e') goto yy1042;
	++cur;
#line 368 "../src/parse/conf_lexer.re"
	{ SETOPT(encoding_policy, Enc::Policy::SUBSTITUTE); goto end; }
#line 5395 "src/parse/conf_lexer.cc"
}
#line 370 "../src/parse/conf_lexer.re"


empty_class:
    CHECK_RET(lex_conf_assign());

#line 5403 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	if ((lim - cur) < 11) YYFILL(11);
	yych = *cur;
	if (yych == 'e') goto yy1057;
	if (yych == 'm') goto yy1058;
	++cur;
yy1056:
#line 375 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_cur(
                "bad configuration value (expected: 'match-empty', 'match-none', 'error')"));
    }
#line 5417 "src/parse/conf_lexer.cc"
yy1057:
	yych = *(mar = ++cur);
	if (yych == 'r') goto yy1059;
	goto yy1056;
yy1058:
	yych = *(mar = ++cur);
	if (yych == 'a') goto yy1061;
	goto yy1056;
yy1059:
	yych = *++cur;
	if (yych == 'r') goto yy1062;
yy1060:
	cur = mar;
	goto yy1056;
yy1061:
	yych = *++cur;
	if (yych == 't') goto yy1063;
	goto yy1060;
yy1062:
	yych = *++cur;
	if (yych == 'o') goto yy1064;
	goto yy1060;
yy1063:
	yych = *++cur;
	if (yych == 'c') goto yy1065;
	goto yy1060;
yy1064:
	yych = *++cur;
	if (yych == 'r') goto yy1066;
	goto yy1060;
yy1065:
	yych = *++cur;
	if (yych == 'h') goto yy1067;
	goto yy1060;
yy1066:
	++cur;
#line 381 "../src/parse/conf_lexer.re"
	{ SETOPT(empty_class, EmptyClass::ERROR);       goto end; }
#line 5456 "src/parse/conf_lexer.cc"
yy1067:
	yych = *++cur;
	if (yych != '-') goto yy1060;
	yych = *++cur;
	if (yych == 'e') goto yy1068;
	if (yych == 'n') goto yy1069;
	goto yy1060;
yy1068:
	yych = *++cur;
	if (yych == 'm') goto yy1070;
	goto yy1060;
yy1069:
	yych = *++cur;
	if (yych == 'o') goto yy1071;
	goto yy1060;
yy1070:
	yych = *++cur;
	if (yych == 'p') goto yy1072;
	goto yy1060;
yy1071:
	yych = *++cur;
	if (yych == 'n') goto yy1073;
	goto yy1060;
yy1072:
	yych = *++cur;
	if (yych == 't') goto yy1074;
	goto yy1060;
yy1073:
	yych = *++cur;
	if (yych == 'e') goto yy1075;
	goto yy1060;
yy1074:
	yych = *++cur;
	if (yych == 'y') goto yy1076;
	goto yy1060;
yy1075:
	++cur;
#line 380 "../src/parse/conf_lexer.re"
	{ SETOPT(empty_class, EmptyClass::MATCH_NONE);  goto end; }
#line 5496 "src/parse/conf_lexer.cc"
yy1076:
	++cur;
#line 379 "../src/parse/conf_lexer.re"
	{ SETOPT(empty_class, EmptyClass::MATCH_EMPTY); goto end; }
#line 5501 "src/parse/conf_lexer.cc"
}
#line 382 "../src/parse/conf_lexer.re"


char_lit:
    CHECK_RET(lex_conf_assign());

#line 5509 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	unsigned int yyaccept = 0;
	if ((lim - cur) < 11) YYFILL(11);
	yych = *cur;
	if (yych == 'c') goto yy1079;
	if (yych == 'h') goto yy1080;
	++cur;
yy1078:
#line 387 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_cur("bad configuration value (expected: 'char', 'hex', 'char-or-hex')"));
    }
#line 5523 "src/parse/conf_lexer.cc"
yy1079:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych == 'h') goto yy1081;
	goto yy1078;
yy1080:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych == 'e') goto yy1083;
	goto yy1078;
yy1081:
	yych = *++cur;
	if (yych == 'a') goto yy1084;
yy1082:
	cur = mar;
	if (yyaccept == 0) goto yy1078;
	else goto yy1087;
yy1083:
	yych = *++cur;
	if (yych == 'x') goto yy1085;
	goto yy1082;
yy1084:
	yych = *++cur;
	if (yych == 'r') goto yy1086;
	goto yy1082;
yy1085:
	++cur;
#line 391 "../src/parse/conf_lexer.re"
	{ SETOPT(char_literals, CharLit::HEX);         goto end; }
#line 5553 "src/parse/conf_lexer.cc"
yy1086:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych == '-') goto yy1088;
yy1087:
#line 390 "../src/parse/conf_lexer.re"
	{ SETOPT(char_literals, CharLit::CHAR);        goto end; }
#line 5561 "src/parse/conf_lexer.cc"
yy1088:
	yych = *++cur;
	if (yych != 'o') goto yy1082;
	yych = *++cur;
	if (yych != 'r') goto yy1082;
	yych = *++cur;
	if (yych != '-') goto yy1082;
	yych = *++cur;
	if (yych != 'h') goto yy1082;
	yych = *++cur;
	if (yych != 'e') goto yy1082;
	yych = *++cur;
	if (yych != 'x') goto yy1082;
	++cur;
#line 392 "../src/parse/conf_lexer.re"
	{ SETOPT(char_literals, CharLit::CHAR_OR_HEX); goto end; }
#line 5578 "src/parse/conf_lexer.cc"
}
#line 393 "../src/parse/conf_lexer.re"


end:
    return lex_conf_semicolon();
}

#undef SETOPT
#undef RET_CONF_BOOL
#undef RET_CONF_FEAT
#undef RET_CONF_STR
#undef RET_CONF_ENC
#undef RET_CONF_NUM_NONNEG
#undef RET_CONF_EOF

Ret Input::lex_spaces() {
loop: 
#line 5597 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yych <= '\f') {
		if (yych <= 0x08) goto yy1090;
		if (yych <= '\t') goto yy1091;
		if (yych <= '\n') goto yy1092;
	} else {
		if (yych <= '\r') goto yy1091;
		if (yych == ' ') goto yy1091;
	}
yy1090:
#line 411 "../src/parse/conf_lexer.re"
	{ return Ret::OK; }
#line 5613 "src/parse/conf_lexer.cc"
yy1091:
	++cur;
#line 410 "../src/parse/conf_lexer.re"
	{ goto loop; }
#line 5618 "src/parse/conf_lexer.cc"
yy1092:
	++cur;
#line 409 "../src/parse/conf_lexer.re"
	{ next_line(); goto loop; }
#line 5623 "src/parse/conf_lexer.cc"
}
#line 412 "../src/parse/conf_lexer.re"

}

Ret Input::lex_conf_assign() {
    CHECK_RET(lex_spaces());

#line 5632 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yych == '=') goto yy1094;
	++cur;
#line 419 "../src/parse/conf_lexer.re"
	{ RET_FAIL(error_at_cur("missing '=' in configuration")); }
#line 5641 "src/parse/conf_lexer.cc"
yy1094:
	++cur;
#line 418 "../src/parse/conf_lexer.re"
	{ return lex_spaces(); }
#line 5646 "src/parse/conf_lexer.cc"
}
#line 420 "../src/parse/conf_lexer.re"

}

Ret Input::lex_conf_semicolon() {
    CHECK_RET(lex_spaces());

#line 5655 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yych == ';') goto yy1096;
	++cur;
#line 427 "../src/parse/conf_lexer.re"
	{ RET_FAIL(error_at_cur("missing ending ';' in configuration")); }
#line 5664 "src/parse/conf_lexer.cc"
yy1096:
	++cur;
#line 426 "../src/parse/conf_lexer.re"
	{ return Ret::OK; }
#line 5669 "src/parse/conf_lexer.cc"
}
#line 428 "../src/parse/conf_lexer.re"

}

Ret Input::lex_conf_number(Opt& opts) {
    CHECK_RET(parse_conf(opts));
    if (conf_kind != ConfKind::NUM) {
        RET_FAIL(error_at_tok("configuration value should be a number"));
    }
    return Ret::OK;
}

inline Ret Input::lex_conf_bool(Opt& opts) {
    CHECK_RET(parse_conf(opts));
    if (conf_kind != ConfKind::NUM) {
        RET_FAIL(error_at_tok("configuration value should be a boolean value 0 or 1"));
    }
    return Ret::OK;
}

// Historically re2c allowed raw (unquoted) strings containing special symbols as configuration
// values in source files. In syntax files this is not allowed, as it would conflict with other
// parts of grammar (e.g. parentheses and question mark are used for conditionals). Therefore we
// have a legacy method for string configurations in source files.
Ret Input::lex_conf_string_legacy() {
    CHECK_RET(lex_conf_assign());
    tok = cur;

#line 5699 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	static const unsigned char yybm[256] = {
		  0, 128, 128, 128, 128, 128, 128, 128,
		128,   0,   0, 128, 128,   0, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		  0, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128,   0, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128
	};
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yych <= ' ') {
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy1098;
			if (yych <= 0x08) goto yy1099;
		} else {
			if (yych == '\r') goto yy1098;
			if (yych <= 0x1F) goto yy1099;
		}
	} else {
		if (yych <= '&') {
			if (yych == '"') goto yy1100;
			goto yy1099;
		} else {
			if (yych <= '\'') goto yy1100;
			if (yych != ';') goto yy1099;
		}
	}
yy1098:
#line 457 "../src/parse/conf_lexer.re"
	{ tmp_str.clear(); goto end; }
#line 5758 "src/parse/conf_lexer.cc"
yy1099:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yybm[0+yych] & 128) goto yy1099;
#line 455 "../src/parse/conf_lexer.re"
	{ tmp_str.assign(tok, cur); goto end; }
#line 5766 "src/parse/conf_lexer.cc"
yy1100:
	++cur;
	cur -= 1;
#line 456 "../src/parse/conf_lexer.re"
	{ tmp_str.clear(); goto loop; }
#line 5772 "src/parse/conf_lexer.cc"
}
#line 458 "../src/parse/conf_lexer.re"

loop: // lex one or more double-quoted strings separated with spaces or newlines
    tok = cur;

#line 5779 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych <= 0x08) goto yy1102;
			if (yych <= '\t') goto yy1103;
			goto yy1104;
		} else {
			if (yych == '\r') goto yy1103;
		}
	} else {
		if (yych <= '"') {
			if (yych <= ' ') goto yy1103;
			if (yych >= '"') goto yy1105;
		} else {
			if (yych == '\'') goto yy1105;
		}
	}
yy1102:
#line 465 "../src/parse/conf_lexer.re"
	{ goto end; }
#line 5803 "src/parse/conf_lexer.cc"
yy1103:
	++cur;
#line 464 "../src/parse/conf_lexer.re"
	{ goto loop; }
#line 5808 "src/parse/conf_lexer.cc"
yy1104:
	++cur;
#line 463 "../src/parse/conf_lexer.re"
	{ next_line(); goto loop; }
#line 5813 "src/parse/conf_lexer.cc"
yy1105:
	++cur;
#line 462 "../src/parse/conf_lexer.re"
	{ CHECK_RET(lex_conf_string_quoted(tok[0])); goto loop; }
#line 5818 "src/parse/conf_lexer.cc"
}
#line 466 "../src/parse/conf_lexer.re"

end:
    return lex_conf_semicolon();
}

Ret Input::lex_conf_string(Opt& opts) {
    if (!in_syntax_file) {
        return lex_conf_string_legacy();
    }

    CHECK_RET(parse_conf(opts));
    if (conf_kind != ConfKind::STR) {
        RET_FAIL(error_at_tok("configuration value should be a string"));
    }
    return Ret::OK;
}

Ret Input::lex_conf_list(Opt& opts) {
    CHECK_RET(parse_conf(opts));
    if (conf_kind != ConfKind::LIST) {
        RET_FAIL(error_at_tok("configuration value should be a list"));
    }
    return Ret::OK;
}

Ret Input::lex_conf_string_quoted(uint8_t quote) {
    AstChar c;
    bool stop;
    for (;;) {
        CHECK_RET(lex_str_chr(quote, c, stop));
        if (stop) return Ret::OK;
        if (c.chr > 0xFF) {
            RET_FAIL(error_at(c.loc, "multibyte character in configuration string: 0x%X", c.chr));
        } else if (c.chr == '\n' && in_syntax_file) {
            RET_FAIL(error_at(c.loc, "newline in a string literal (use `nl` variable instead)"));
        }
        tmp_str += static_cast<char>(c.chr);
    }
}

Ret Input::lex_conf_code(Opt& opts) {
    if (in_syntax_file) {
        conf_kind = ConfKind::CODE;
        CHECK_RET(parse_conf(opts));
    } else {
        CHECK_RET(lex_conf_string(opts));
        tmp_code = opts.make_api(tmp_str);
    }
    return Ret::OK;
}

#define RET_TOK(t) do { \
    token = t; \
    return Ret::OK; \
} while(0)

#define RET_COND(c) do { \
    token = CONF_COND; \
    yylval->cond = (c); \
    return Ret::OK; \
} while(0)

#define RET_GOPT(opt) do { \
    token = CONF_GOPT; \
    yylval->gopt = opt; \
    return Ret::OK; \
} while(0)

#define RET_LOPT(opt) do { \
    token = CONF_LOPT; \
    yylval->lopt = opt; \
    return Ret::OK; \
} while(0)

#define RET_VAR(v) do { \
    token = CONF_VAR; \
    yylval->var = v; \
    return Ret::OK; \
} while(0)

#define RET_CODE(conf) do { \
    token = CONF_CODE; \
    yylval->codeptr = const_cast<const StxCodes**>(&opts.glob.conf); \
    return Ret::OK; \
} while(0)

Ret Input::lex_conf_token(CONF_STYPE* yylval, int& token, Opt& opts) {
    if (conf_kind == ConfKind::CODE) { // one of pre-lexed `conf:` configuratins
        conf_kind = ConfKind::NONE;
        yylval->codeptr = &tmp_code;
        RET_TOK(CONF_CODE);
    }
start:
    tok = cur;

#line 5916 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[256] = {
		  0, 128, 128, 128, 128, 128, 128, 128,
		128, 136,   0, 128, 128, 136, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		136, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 192, 128,
		240, 240, 240, 240, 240, 240, 240, 240,
		240, 240, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 224,
		128, 224, 224, 224, 224, 224, 224, 224,
		224, 224, 224, 224, 224, 224, 224, 224,
		224, 224, 224, 224, 224, 224, 224, 224,
		224, 224, 224, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128
	};
	if ((lim - cur) < 32) YYFILL(32);
	yych = *cur;
	if (yybm[0+yych] & 8) goto yy1110;
	switch (yych) {
		case 0x00: goto yy1107;
		case '\t':
		case '\n': goto yy1111;
		case ' ':
		case '!':
		case '&':
		case '(':
		case ')':
		case ',':
		case ':':
		case '=':
		case '?':
		case '[':
		case ']':
		case '{':
		case '|':
		case '}': goto yy1112;
		case '"':
		case '\'': goto yy1113;
		case '-': goto yy1114;
		case '.': goto yy1115;
		case '/': goto yy1116;
		case '0': goto yy1117;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy1119;
		case ';': goto yy1120;
		case '<': goto yy1121;
		case 'Y': goto yy1122;
		case '_':
		case 'g':
		case 'h':
		case 'j':
		case 'k':
		case 'p':
		case 'q':
		case 'u':
		case 'w':
		case 'x':
		case 'z': goto yy1123;
		case 'a': goto yy1126;
		case 'b': goto yy1127;
		case 'c': goto yy1128;
		case 'd': goto yy1129;
		case 'e': goto yy1130;
		case 'f': goto yy1131;
		case 'i': goto yy1132;
		case 'l': goto yy1133;
		case 'm': goto yy1134;
		case 'n': goto yy1135;
		case 'o': goto yy1136;
		case 'r': goto yy1137;
		case 's': goto yy1138;
		case 't': goto yy1139;
		case 'v': goto yy1140;
		case 'y': goto yy1141;
		default: goto yy1108;
	}
yy1107:
	++cur;
#line 563 "../src/parse/conf_lexer.re"
	{ RET_FAIL(error_at_cur("unexpected end of input in configuration")); }
#line 6026 "src/parse/conf_lexer.cc"
yy1108:
	++cur;
yy1109:
#line 798 "../src/parse/conf_lexer.re"
	{ RET_FAIL(error_at_tok("unexpected character: '%c'", cur[-1])); }
#line 6032 "src/parse/conf_lexer.cc"
yy1110:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yybm[0+yych] & 8) goto yy1110;
#line 567 "../src/parse/conf_lexer.re"
	{ goto start; }
#line 6040 "src/parse/conf_lexer.cc"
yy1111:
	++cur;
#line 565 "../src/parse/conf_lexer.re"
	{ next_line(); goto start; }
#line 6045 "src/parse/conf_lexer.cc"
yy1112:
	++cur;
#line 583 "../src/parse/conf_lexer.re"
	{ RET_TOK(cur[-1]); }
#line 6050 "src/parse/conf_lexer.cc"
yy1113:
	++cur;
#line 576 "../src/parse/conf_lexer.re"
	{
        tmp_str.clear();
        CHECK_RET(lex_conf_string_quoted(cur[-1]));
        yylval->str = copystr(tmp_str, alc);
        RET_TOK(CONF_STRING);
    }
#line 6060 "src/parse/conf_lexer.cc"
yy1114:
	yych = *++cur;
	if (yych <= '0') goto yy1109;
	if (yych <= '9') goto yy1142;
	goto yy1109;
yy1115:
	yych = *++cur;
	if (yych <= 'h') {
		if (yych <= '_') {
			if (yych <= '/') {
				if (yych == '.') goto yy1143;
				goto yy1109;
			} else {
				if (yych <= '9') goto yy1143;
				if (yych <= '^') goto yy1109;
				goto yy1143;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy1109;
				if (yych <= 'a') goto yy1145;
				goto yy1143;
			} else {
				if (yych <= 'c') goto yy1146;
				if (yych <= 'd') goto yy1147;
				goto yy1143;
			}
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'l') {
				if (yych <= 'i') goto yy1148;
				if (yych <= 'k') goto yy1143;
				goto yy1149;
			} else {
				if (yych <= 'm') goto yy1150;
				if (yych <= 'n') goto yy1151;
				goto yy1143;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'r') goto yy1152;
				if (yych <= 's') goto yy1153;
				goto yy1154;
			} else {
				if (yych <= 'u') goto yy1155;
				if (yych <= 'v') goto yy1156;
				if (yych <= 'z') goto yy1143;
				goto yy1109;
			}
		}
	}
yy1116:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych == '/') goto yy1157;
	goto yy1109;
yy1117:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
yy1118:
#line 569 "../src/parse/conf_lexer.re"
	{
        if (!s_to_i32_unsafe(tok, cur, yylval->num)) {
            RET_FAIL(error_at_cur("configuration value overflow"));
        }
        RET_TOK(CONF_NUMBER);
    }
#line 6129 "src/parse/conf_lexer.cc"
yy1119:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yybm[0+yych] & 16) goto yy1119;
	if (yych == '_') goto yy1123;
	if (yych <= '`') goto yy1118;
	if (yych <= 'z') goto yy1123;
	goto yy1118;
yy1120:
	++cur;
#line 561 "../src/parse/conf_lexer.re"
	{ RET_TOK(CONF_EOF); }
#line 6143 "src/parse/conf_lexer.cc"
yy1121:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych == 'u') goto yy1159;
	goto yy1109;
yy1122:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych == 'Y') goto yy1160;
	goto yy1109;
yy1123:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
yy1124:
	if (yybm[0+yych] & 32) goto yy1123;
yy1125:
#line 794 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_tok("unknown variable: '%.*s'", int(cur - tok), tok));
    }
#line 6165 "src/parse/conf_lexer.cc"
yy1126:
	yych = *++cur;
	if (yych == 'r') goto yy1161;
	goto yy1124;
yy1127:
	yych = *++cur;
	if (yych == 'r') goto yy1162;
	goto yy1124;
yy1128:
	yych = *++cur;
	if (yych == 'a') goto yy1163;
	if (yych == 'o') goto yy1164;
	goto yy1124;
yy1129:
	yych = *++cur;
	if (yych == 'a') goto yy1165;
	if (yych == 'e') goto yy1166;
	goto yy1124;
yy1130:
	yych = *++cur;
	if (yych == 'l') goto yy1167;
	if (yych == 'x') goto yy1168;
	goto yy1124;
yy1131:
	yych = *++cur;
	if (yych == 'i') goto yy1169;
	if (yych == 'n') goto yy1170;
	goto yy1124;
yy1132:
	yych = *++cur;
	if (yych == 'n') goto yy1172;
	goto yy1124;
yy1133:
	yych = *++cur;
	if (yych <= 'g') {
		if (yych == 'a') goto yy1173;
		goto yy1124;
	} else {
		if (yych <= 'h') goto yy1174;
		if (yych <= 'i') goto yy1175;
		goto yy1124;
	}
yy1134:
	yych = *++cur;
	if (yych == 'a') goto yy1176;
	goto yy1124;
yy1135:
	yych = *++cur;
	if (yych <= 'd') {
		if (yych == 'a') goto yy1177;
		goto yy1124;
	} else {
		if (yych <= 'e') goto yy1178;
		if (yych == 'l') goto yy1179;
		goto yy1124;
	}
yy1136:
	yych = *++cur;
	if (yych == 'f') goto yy1180;
	goto yy1124;
yy1137:
	yych = *++cur;
	if (yych <= 'g') {
		if (yych == 'e') goto yy1181;
		goto yy1124;
	} else {
		if (yych <= 'h') goto yy1182;
		if (yych == 'o') goto yy1183;
		goto yy1124;
	}
yy1138:
	yych = *++cur;
	if (yych == 'i') goto yy1184;
	if (yych == 't') goto yy1185;
	goto yy1124;
yy1139:
	yych = *++cur;
	if (yych <= 'n') {
		if (yych == 'a') goto yy1186;
		goto yy1124;
	} else {
		if (yych <= 'o') goto yy1187;
		if (yych == 'y') goto yy1188;
		goto yy1124;
	}
yy1140:
	yych = *++cur;
	if (yych == 'a') goto yy1189;
	if (yych == 'e') goto yy1190;
	goto yy1124;
yy1141:
	yych = *++cur;
	if (yych == 'y') goto yy1191;
	goto yy1124;
yy1142:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yych <= '/') goto yy1118;
	if (yych <= '9') goto yy1142;
	goto yy1118;
yy1143:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
yy1144:
	if (yybm[0+yych] & 64) goto yy1143;
#line 790 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_tok("unknown conditional: '%.*s'", int(cur - tok), tok));
    }
#line 6277 "src/parse/conf_lexer.cc"
yy1145:
	yych = *++cur;
	if (yych == 'p') goto yy1192;
	if (yych == 'r') goto yy1193;
	goto yy1144;
yy1146:
	yych = *++cur;
	if (yych <= 'g') {
		if (yych == 'a') goto yy1194;
		goto yy1144;
	} else {
		if (yych <= 'h') goto yy1195;
		if (yych == 'o') goto yy1196;
		goto yy1144;
	}
yy1147:
	yych = *++cur;
	if (yych == 'a') goto yy1197;
	goto yy1144;
yy1148:
	yych = *++cur;
	if (yych == 'n') goto yy1198;
	goto yy1144;
yy1149:
	yych = *++cur;
	if (yych == 'o') goto yy1199;
	goto yy1144;
yy1150:
	yych = *++cur;
	if (yych == 'a') goto yy1200;
	if (yych == 'o') goto yy1201;
	goto yy1144;
yy1151:
	yych = *++cur;
	if (yych == 'e') goto yy1202;
	goto yy1144;
yy1152:
	yych = *++cur;
	if (yych == 'e') goto yy1203;
	goto yy1144;
yy1153:
	yych = *++cur;
	if (yych == 't') goto yy1204;
	goto yy1144;
yy1154:
	yych = *++cur;
	if (yych == 'y') goto yy1205;
	goto yy1144;
yy1155:
	yych = *++cur;
	if (yych == 'n') goto yy1206;
	goto yy1144;
yy1156:
	yych = *++cur;
	if (yych == 'e') goto yy1207;
	goto yy1144;
yy1157:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yybm[0+yych] & 128) goto yy1157;
	if (yych >= 0x01) goto yy1111;
yy1158:
	cur = mar;
	if (yyaccept <= 2) {
		if (yyaccept <= 1) {
			if (yyaccept == 0) goto yy1109;
			else goto yy1125;
		} else {
			goto yy1483;
		}
	} else {
		if (yyaccept == 3) goto yy1523;
		else goto yy1588;
	}
yy1159:
	yych = *++cur;
	if (yych == 'n') goto yy1208;
	goto yy1158;
yy1160:
	yych = *++cur;
	switch (yych) {
		case 'B': goto yy1209;
		case 'C': goto yy1210;
		case 'D': goto yy1211;
		case 'G': goto yy1212;
		case 'I': goto yy1213;
		case 'L': goto yy1214;
		case 'M': goto yy1215;
		case 'P': goto yy1216;
		case 'R': goto yy1217;
		case 'S': goto yy1218;
		default: goto yy1158;
	}
yy1161:
	yych = *++cur;
	if (yych == 'g') goto yy1219;
	if (yych == 'r') goto yy1220;
	goto yy1124;
yy1162:
	yych = *++cur;
	if (yych == 'a') goto yy1221;
	goto yy1124;
yy1163:
	yych = *++cur;
	if (yych == 's') goto yy1222;
	goto yy1124;
yy1164:
	yych = *++cur;
	if (yych == 'd') goto yy1223;
	if (yych == 'n') goto yy1224;
	goto yy1124;
yy1165:
	yych = *++cur;
	if (yych == 't') goto yy1225;
	goto yy1124;
yy1166:
	yych = *++cur;
	if (yych == 'd') goto yy1226;
	goto yy1124;
yy1167:
	yych = *++cur;
	if (yych == 'e') goto yy1227;
	goto yy1124;
yy1168:
	yych = *++cur;
	if (yych == 'p') goto yy1228;
	goto yy1124;
yy1169:
	yych = *++cur;
	if (yych == 'l') goto yy1229;
	goto yy1124;
yy1170:
	yych = *++cur;
	if (yych <= '_') {
		if (yych <= '/') goto yy1171;
		if (yych <= '9') goto yy1123;
		if (yych >= '_') goto yy1123;
	} else {
		if (yych <= 'c') {
			if (yych >= 'a') goto yy1123;
		} else {
			if (yych <= 'd') goto yy1230;
			if (yych <= 'z') goto yy1123;
		}
	}
yy1171:
#line 672 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::FN); }
#line 6427 "src/parse/conf_lexer.cc"
yy1172:
	yych = *++cur;
	if (yych == 'd') goto yy1231;
	if (yych == 'i') goto yy1232;
	goto yy1124;
yy1173:
	yych = *++cur;
	if (yych == 'b') goto yy1233;
	goto yy1124;
yy1174:
	yych = *++cur;
	if (yych == 's') goto yy1234;
	goto yy1124;
yy1175:
	yych = *++cur;
	if (yych == 'n') goto yy1235;
	goto yy1124;
yy1176:
	yych = *++cur;
	if (yych == 's') goto yy1236;
	goto yy1124;
yy1177:
	yych = *++cur;
	if (yych == 'm') goto yy1237;
	goto yy1124;
yy1178:
	yych = *++cur;
	if (yych == 'e') goto yy1238;
	if (yych == 'g') goto yy1239;
	goto yy1124;
yy1179:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 734 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::NEWLINE); }
#line 6463 "src/parse/conf_lexer.cc"
yy1180:
	yych = *++cur;
	if (yych == 'f') goto yy1240;
	goto yy1124;
yy1181:
	yych = *++cur;
	if (yych == 't') goto yy1241;
	goto yy1124;
yy1182:
	yych = *++cur;
	if (yych == 's') goto yy1242;
	goto yy1124;
yy1183:
	yych = *++cur;
	if (yych == 'w') goto yy1243;
	goto yy1124;
yy1184:
	yych = *++cur;
	if (yych == 'g') goto yy1244;
	if (yych == 'z') goto yy1245;
	goto yy1124;
yy1185:
	yych = *++cur;
	if (yych == 'a') goto yy1246;
	if (yych == 'm') goto yy1247;
	goto yy1124;
yy1186:
	yych = *++cur;
	if (yych == 'g') goto yy1248;
	goto yy1124;
yy1187:
	yych = *++cur;
	if (yych == 'p') goto yy1249;
	goto yy1124;
yy1188:
	yych = *++cur;
	if (yych == 'p') goto yy1250;
	goto yy1124;
yy1189:
	yych = *++cur;
	if (yych == 'l') goto yy1251;
	if (yych == 'r') goto yy1252;
	goto yy1124;
yy1190:
	yych = *++cur;
	if (yych == 'r') goto yy1253;
	goto yy1124;
yy1191:
	yych = *++cur;
	if (yych <= 'c') {
		if (yych <= 'a') goto yy1124;
		if (yych <= 'b') goto yy1254;
		goto yy1255;
	} else {
		if (yych == 'r') goto yy1256;
		goto yy1124;
	}
yy1192:
	yych = *++cur;
	if (yych == 'i') goto yy1257;
	goto yy1144;
yy1193:
	yych = *++cur;
	if (yych == 'g') goto yy1258;
	goto yy1144;
yy1194:
	yych = *++cur;
	if (yych == 's') goto yy1259;
	goto yy1144;
yy1195:
	yych = *++cur;
	if (yych == 'a') goto yy1260;
	goto yy1144;
yy1196:
	yych = *++cur;
	if (yych == 'd') goto yy1261;
	if (yych == 'n') goto yy1262;
	goto yy1144;
yy1197:
	yych = *++cur;
	if (yych == 't') goto yy1263;
	goto yy1144;
yy1198:
	yych = *++cur;
	if (yych == 'i') goto yy1264;
	goto yy1144;
yy1199:
	yych = *++cur;
	if (yych == 'o') goto yy1265;
	goto yy1144;
yy1200:
	yych = *++cur;
	if (yych == 'n') goto yy1266;
	goto yy1144;
yy1201:
	yych = *++cur;
	if (yych == 'n') goto yy1267;
	goto yy1144;
yy1202:
	yych = *++cur;
	if (yych == 's') goto yy1268;
	goto yy1144;
yy1203:
	yych = *++cur;
	if (yych == 't') goto yy1269;
	goto yy1144;
yy1204:
	yych = *++cur;
	if (yych == 'a') goto yy1270;
	if (yych == 'o') goto yy1271;
	goto yy1144;
yy1205:
	yych = *++cur;
	if (yych == 'p') goto yy1272;
	goto yy1144;
yy1206:
	yych = *++cur;
	if (yych == 's') goto yy1273;
	goto yy1144;
yy1207:
	yych = *++cur;
	if (yych == 'r') goto yy1274;
	goto yy1144;
yy1208:
	yych = *++cur;
	if (yych == 'd') goto yy1275;
	goto yy1158;
yy1209:
	yych = *++cur;
	if (yych == 'A') goto yy1276;
	goto yy1158;
yy1210:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych == 'O') goto yy1277;
		goto yy1158;
	} else {
		if (yych <= 'T') goto yy1278;
		if (yych <= 'U') goto yy1279;
		goto yy1158;
	}
yy1211:
	yych = *++cur;
	if (yych == 'E') goto yy1280;
	goto yy1158;
yy1212:
	yych = *++cur;
	if (yych == 'E') goto yy1281;
	goto yy1158;
yy1213:
	yych = *++cur;
	if (yych == 'N') goto yy1282;
	goto yy1158;
yy1214:
	yych = *++cur;
	if (yych == 'E') goto yy1283;
	if (yych == 'I') goto yy1284;
	goto yy1158;
yy1215:
	yych = *++cur;
	if (yych == 'A') goto yy1285;
	if (yych == 'T') goto yy1286;
	goto yy1158;
yy1216:
	yych = *++cur;
	if (yych == 'E') goto yy1287;
	goto yy1158;
yy1217:
	yych = *++cur;
	if (yych == 'E') goto yy1288;
	goto yy1158;
yy1218:
	yych = *++cur;
	switch (yych) {
		case 'E': goto yy1289;
		case 'H': goto yy1290;
		case 'K': goto yy1291;
		case 'T': goto yy1292;
		default: goto yy1158;
	}
yy1219:
	yych = *++cur;
	if (yych <= '`') {
		if (yych <= '9') {
			if (yych >= '0') goto yy1123;
		} else {
			if (yych == '_') goto yy1123;
		}
	} else {
		if (yych <= 's') {
			if (yych == 'n') goto yy1293;
			goto yy1123;
		} else {
			if (yych <= 't') goto yy1294;
			if (yych <= 'z') goto yy1123;
		}
	}
#line 662 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::ARG); }
#line 6663 "src/parse/conf_lexer.cc"
yy1220:
	yych = *++cur;
	if (yych == 'a') goto yy1295;
	goto yy1124;
yy1221:
	yych = *++cur;
	if (yych == 'n') goto yy1296;
	goto yy1124;
yy1222:
	yych = *++cur;
	if (yych == 'e') goto yy1297;
	goto yy1124;
yy1223:
	yych = *++cur;
	if (yych == 'e') goto yy1298;
	goto yy1124;
yy1224:
	yych = *++cur;
	if (yych == 'd') goto yy1299;
	goto yy1124;
yy1225:
	yych = *++cur;
	if (yych == 'e') goto yy1300;
	goto yy1124;
yy1226:
	yych = *++cur;
	if (yych == 'e') goto yy1301;
	goto yy1124;
yy1227:
	yych = *++cur;
	if (yych == 'm') goto yy1302;
	goto yy1124;
yy1228:
	yych = *++cur;
	if (yych == 'r') goto yy1303;
	goto yy1124;
yy1229:
	yych = *++cur;
	if (yych == 'e') goto yy1304;
	goto yy1124;
yy1230:
	yych = *++cur;
	if (yych == 'e') goto yy1305;
	goto yy1124;
yy1231:
	yych = *++cur;
	if (yych == 'e') goto yy1306;
	goto yy1124;
yy1232:
	yych = *++cur;
	if (yych == 't') goto yy1307;
	goto yy1124;
yy1233:
	yych = *++cur;
	if (yych == 'e') goto yy1308;
	goto yy1124;
yy1234:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 679 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::LHS); }
#line 6725 "src/parse/conf_lexer.cc"
yy1235:
	yych = *++cur;
	if (yych == 'e') goto yy1309;
	goto yy1124;
yy1236:
	yych = *++cur;
	if (yych == 'k') goto yy1310;
	goto yy1124;
yy1237:
	yych = *++cur;
	if (yych == 'e') goto yy1311;
	goto yy1124;
yy1238:
	yych = *++cur;
	if (yych == 'd') goto yy1312;
	goto yy1124;
yy1239:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 683 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::NEG); }
#line 6747 "src/parse/conf_lexer.cc"
yy1240:
	yych = *++cur;
	if (yych == 's') goto yy1313;
	goto yy1124;
yy1241:
	yych = *++cur;
	if (yych == 'v') goto yy1314;
	goto yy1124;
yy1242:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 687 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::RHS); }
#line 6761 "src/parse/conf_lexer.cc"
yy1243:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 688 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::ROW); }
#line 6767 "src/parse/conf_lexer.cc"
yy1244:
	yych = *++cur;
	if (yych == 'i') goto yy1315;
	goto yy1124;
yy1245:
	yych = *++cur;
	if (yych == 'e') goto yy1316;
	goto yy1124;
yy1246:
	yych = *++cur;
	if (yych == 't') goto yy1317;
	goto yy1124;
yy1247:
	yych = *++cur;
	if (yych == 't') goto yy1318;
	goto yy1124;
yy1248:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 693 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::TAG); }
#line 6789 "src/parse/conf_lexer.cc"
yy1249:
	yych = *++cur;
	if (yych == 'i') goto yy1319;
	goto yy1124;
yy1250:
	yych = *++cur;
	if (yych == 'e') goto yy1320;
	goto yy1124;
yy1251:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 695 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::VAL); }
#line 6803 "src/parse/conf_lexer.cc"
yy1252:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 696 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::VAR); }
#line 6809 "src/parse/conf_lexer.cc"
yy1253:
	yych = *++cur;
	if (yych == 's') goto yy1321;
	goto yy1124;
yy1254:
	yych = *++cur;
	if (yych == 'm') goto yy1322;
	goto yy1124;
yy1255:
	yych = *++cur;
	if (yych == 'h') goto yy1323;
	goto yy1124;
yy1256:
	yych = *++cur;
	if (yych == 'e') goto yy1324;
	goto yy1124;
yy1257:
	yych = *++cur;
	if (yych == '.') goto yy1325;
	if (yych == '_') goto yy1326;
	goto yy1144;
yy1258:
	yych = *++cur;
	if (yych == 's') goto yy1327;
	goto yy1144;
yy1259:
	yych = *++cur;
	if (yych == 'e') goto yy1328;
	if (yych == 't') goto yy1329;
	goto yy1144;
yy1260:
	yych = *++cur;
	if (yych == 'r') goto yy1330;
	goto yy1144;
yy1261:
	yych = *++cur;
	if (yych == 'e') goto yy1331;
	goto yy1144;
yy1262:
	yych = *++cur;
	if (yych == 'd') goto yy1332;
	goto yy1144;
yy1263:
	yych = *++cur;
	if (yych == 'e') goto yy1333;
	goto yy1144;
yy1264:
	yych = *++cur;
	if (yych == 't') goto yy1334;
	goto yy1144;
yy1265:
	yych = *++cur;
	if (yych == 'p') goto yy1335;
	goto yy1144;
yy1266:
	yych = *++cur;
	if (yych == 'y') goto yy1336;
	goto yy1144;
yy1267:
	yych = *++cur;
	if (yych == 'a') goto yy1337;
	goto yy1144;
yy1268:
	yych = *++cur;
	if (yych == 't') goto yy1338;
	goto yy1144;
yy1269:
	yych = *++cur;
	if (yych == 'v') goto yy1339;
	goto yy1144;
yy1270:
	yych = *++cur;
	if (yych == 'r') goto yy1340;
	goto yy1144;
yy1271:
	yych = *++cur;
	if (yych == 'r') goto yy1341;
	goto yy1144;
yy1272:
	yych = *++cur;
	if (yych == 'e') goto yy1342;
	goto yy1144;
yy1273:
	yych = *++cur;
	if (yych == 'a') goto yy1343;
	goto yy1144;
yy1274:
	yych = *++cur;
	if (yych == 's') goto yy1344;
	goto yy1144;
yy1275:
	yych = *++cur;
	if (yych == 'e') goto yy1345;
	goto yy1158;
yy1276:
	yych = *++cur;
	if (yych == 'C') goto yy1346;
	goto yy1158;
yy1277:
	yych = *++cur;
	if (yych == 'P') goto yy1347;
	goto yy1158;
yy1278:
	yych = *++cur;
	if (yych <= 'W') goto yy1158;
	if (yych <= 'X') goto yy1348;
	if (yych <= 'Y') goto yy1349;
	goto yy1158;
yy1279:
	yych = *++cur;
	if (yych == 'R') goto yy1350;
	goto yy1158;
yy1280:
	yych = *++cur;
	if (yych == 'B') goto yy1351;
	goto yy1158;
yy1281:
	yych = *++cur;
	if (yych == 'T') goto yy1352;
	goto yy1158;
yy1282:
	yych = *++cur;
	if (yych == 'P') goto yy1353;
	goto yy1158;
yy1283:
	yych = *++cur;
	if (yych == 'S') goto yy1354;
	goto yy1158;
yy1284:
	yych = *++cur;
	if (yych == 'M') goto yy1355;
	goto yy1158;
yy1285:
	yych = *++cur;
	if (yych == 'R') goto yy1356;
	goto yy1158;
yy1286:
	yych = *++cur;
	if (yych == 'A') goto yy1357;
	goto yy1158;
yy1287:
	yych = *++cur;
	if (yych == 'E') goto yy1358;
	goto yy1158;
yy1288:
	yych = *++cur;
	if (yych == 'S') goto yy1359;
	goto yy1158;
yy1289:
	yych = *++cur;
	if (yych == 'T') goto yy1360;
	goto yy1158;
yy1290:
	yych = *++cur;
	if (yych == 'I') goto yy1361;
	goto yy1158;
yy1291:
	yych = *++cur;
	if (yych == 'I') goto yy1362;
	goto yy1158;
yy1292:
	yych = *++cur;
	if (yych == 'A') goto yy1363;
	goto yy1158;
yy1293:
	yych = *++cur;
	if (yych == 'a') goto yy1364;
	goto yy1124;
yy1294:
	yych = *++cur;
	if (yych == 'y') goto yy1365;
	goto yy1124;
yy1295:
	yych = *++cur;
	if (yych == 'y') goto yy1366;
	goto yy1124;
yy1296:
	yych = *++cur;
	if (yych == 'c') goto yy1367;
	goto yy1124;
yy1297:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 667 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::CASE); }
#line 6995 "src/parse/conf_lexer.cc"
yy1298:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych == ':') goto yy1368;
	goto yy1124;
yy1299:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 668 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::COND); }
#line 7006 "src/parse/conf_lexer.cc"
yy1300:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 669 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::DATE); }
#line 7012 "src/parse/conf_lexer.cc"
yy1301:
	yych = *++cur;
	if (yych == 'n') goto yy1369;
	goto yy1124;
yy1302:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 670 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::ELEM); }
#line 7022 "src/parse/conf_lexer.cc"
yy1303:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 671 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::EXPR); }
#line 7028 "src/parse/conf_lexer.cc"
yy1304:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 673 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::FILE); }
#line 7034 "src/parse/conf_lexer.cc"
yy1305:
	yych = *++cur;
	if (yych == 'c') goto yy1370;
	if (yych == 'f') goto yy1371;
	goto yy1124;
yy1306:
	yych = *++cur;
	if (yych == 'n') goto yy1372;
	if (yych == 'x') goto yy1373;
	goto yy1124;
yy1307:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 677 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::INIT); }
#line 7050 "src/parse/conf_lexer.cc"
yy1308:
	yych = *++cur;
	if (yych == 'l') goto yy1374;
	goto yy1124;
yy1309:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 680 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::LINE); }
#line 7060 "src/parse/conf_lexer.cc"
yy1310:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 681 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::MASK); }
#line 7066 "src/parse/conf_lexer.cc"
yy1311:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 682 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::NAME); }
#line 7072 "src/parse/conf_lexer.cc"
yy1312:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 684 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::NEED); }
#line 7078 "src/parse/conf_lexer.cc"
yy1313:
	yych = *++cur;
	if (yych == 'e') goto yy1375;
	goto yy1124;
yy1314:
	yych = *++cur;
	if (yych == 'a') goto yy1376;
	goto yy1124;
yy1315:
	yych = *++cur;
	if (yych == 'l') goto yy1377;
	goto yy1124;
yy1316:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 690 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::SIZE); }
#line 7096 "src/parse/conf_lexer.cc"
yy1317:
	yych = *++cur;
	if (yych == 'e') goto yy1378;
	goto yy1124;
yy1318:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 692 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::STMT); }
#line 7106 "src/parse/conf_lexer.cc"
yy1319:
	yych = *++cur;
	if (yych == 'n') goto yy1379;
	goto yy1124;
yy1320:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 694 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::TYPE); }
#line 7116 "src/parse/conf_lexer.cc"
yy1321:
	yych = *++cur;
	if (yych == 'i') goto yy1380;
	goto yy1124;
yy1322:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 701 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::BITMAP); }
#line 7126 "src/parse/conf_lexer.cc"
yy1323:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 702 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::CHAR); }
#line 7132 "src/parse/conf_lexer.cc"
yy1324:
	yych = *++cur;
	if (yych == 'c') goto yy1381;
	goto yy1124;
yy1325:
	yych = *++cur;
	if (yych <= 'q') {
		if (yych == 'g') goto yy1382;
		goto yy1144;
	} else {
		if (yych <= 'r') goto yy1383;
		if (yych <= 's') goto yy1384;
		goto yy1144;
	}
yy1326:
	yych = *++cur;
	if (yych == 's') goto yy1385;
	goto yy1144;
yy1327:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1143;
#line 782 "../src/parse/conf_lexer.re"
	{ RET_LOPT(StxLOpt::ARGS); }
#line 7156 "src/parse/conf_lexer.cc"
yy1328:
	yych = *++cur;
	if (yych == '_') goto yy1386;
	goto yy1144;
yy1329:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1143;
#line 780 "../src/parse/conf_lexer.re"
	{ RET_LOPT(StxLOpt::CAST); }
#line 7166 "src/parse/conf_lexer.cc"
yy1330:
	yych = *++cur;
	if (yych == '_') goto yy1387;
	goto yy1144;
yy1331:
	yych = *++cur;
	if (yych == '_') goto yy1388;
	goto yy1144;
yy1332:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1143;
#line 783 "../src/parse/conf_lexer.re"
	{ RET_LOPT(StxLOpt::COND); }
#line 7180 "src/parse/conf_lexer.cc"
yy1333:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1143;
#line 769 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::DATE); }
#line 7186 "src/parse/conf_lexer.cc"
yy1334:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1143;
#line 784 "../src/parse/conf_lexer.re"
	{ RET_LOPT(StxLOpt::INIT); }
#line 7192 "src/parse/conf_lexer.cc"
yy1335:
	yych = *++cur;
	if (yych == '_') goto yy1389;
	goto yy1144;
yy1336:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1143;
#line 787 "../src/parse/conf_lexer.re"
	{ RET_LOPT(StxLOpt::MANY); }
#line 7202 "src/parse/conf_lexer.cc"
yy1337:
	yych = *++cur;
	if (yych == 'd') goto yy1390;
	goto yy1144;
yy1338:
	yych = *++cur;
	if (yych == 'e') goto yy1391;
	goto yy1144;
yy1339:
	yych = *++cur;
	if (yych == 'a') goto yy1392;
	goto yy1144;
yy1340:
	yych = *++cur;
	if (yych == 't') goto yy1393;
	goto yy1144;
yy1341:
	yych = *++cur;
	if (yych == 'a') goto yy1394;
	goto yy1144;
yy1342:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1143;
#line 786 "../src/parse/conf_lexer.re"
	{ RET_LOPT(StxLOpt::TYPE); }
#line 7228 "src/parse/conf_lexer.cc"
yy1343:
	yych = *++cur;
	if (yych == 'f') goto yy1395;
	goto yy1144;
yy1344:
	yych = *++cur;
	if (yych == 'i') goto yy1396;
	goto yy1144;
yy1345:
	yych = *++cur;
	if (yych == 'f') goto yy1397;
	goto yy1158;
yy1346:
	yych = *++cur;
	if (yych == 'K') goto yy1398;
	goto yy1158;
yy1347:
	yych = *++cur;
	if (yych == 'Y') goto yy1399;
	goto yy1158;
yy1348:
	yych = *++cur;
	if (yych == 'M') goto yy1400;
	goto yy1158;
yy1349:
	yych = *++cur;
	if (yych == 'P') goto yy1401;
	goto yy1158;
yy1350:
	yych = *++cur;
	if (yych == 'S') goto yy1402;
	goto yy1158;
yy1351:
	yych = *++cur;
	if (yych == 'U') goto yy1403;
	goto yy1158;
yy1352:
	yych = *++cur;
	if (yych <= 'B') {
		if (yych == 'A') goto yy1404;
		goto yy1158;
	} else {
		if (yych <= 'C') goto yy1405;
		if (yych == 'S') goto yy1406;
		goto yy1158;
	}
yy1353:
	yych = *++cur;
	if (yych == 'U') goto yy1407;
	goto yy1158;
yy1354:
	yych = *++cur;
	if (yych == 'S') goto yy1408;
	goto yy1158;
yy1355:
	yych = *++cur;
	if (yych == 'I') goto yy1409;
	goto yy1158;
yy1356:
	yych = *++cur;
	if (yych == 'K') goto yy1410;
	goto yy1158;
yy1357:
	yych = *++cur;
	if (yych == 'G') goto yy1411;
	goto yy1158;
yy1358:
	yych = *++cur;
	if (yych == 'K') goto yy1412;
	goto yy1158;
yy1359:
	yych = *++cur;
	if (yych == 'T') goto yy1413;
	goto yy1158;
yy1360:
	yych = *++cur;
	if (yych <= 'B') {
		if (yych == 'A') goto yy1414;
		goto yy1158;
	} else {
		if (yych <= 'C') goto yy1415;
		if (yych == 'S') goto yy1416;
		goto yy1158;
	}
yy1361:
	yych = *++cur;
	if (yych == 'F') goto yy1417;
	goto yy1158;
yy1362:
	yych = *++cur;
	if (yych == 'P') goto yy1418;
	goto yy1158;
yy1363:
	yych = *++cur;
	if (yych == 'G') goto yy1419;
	goto yy1158;
yy1364:
	yych = *++cur;
	if (yych == 'm') goto yy1420;
	goto yy1124;
yy1365:
	yych = *++cur;
	if (yych == 'p') goto yy1421;
	goto yy1124;
yy1366:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 665 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::ARRAY); }
#line 7338 "src/parse/conf_lexer.cc"
yy1367:
	yych = *++cur;
	if (yych == 'h') goto yy1422;
	goto yy1124;
yy1368:
	yych = *++cur;
	if (yych <= 'h') {
		if (yych <= 'a') {
			if (yych <= '^') {
				if (yych <= '/') goto yy1158;
				if (yych <= '9') goto yy1423;
				goto yy1158;
			} else {
				if (yych <= '_') goto yy1423;
				if (yych <= '`') goto yy1158;
				goto yy1426;
			}
		} else {
			if (yych <= 'd') {
				if (yych == 'c') goto yy1427;
				goto yy1423;
			} else {
				if (yych <= 'e') goto yy1428;
				if (yych <= 'f') goto yy1429;
				if (yych <= 'g') goto yy1430;
				goto yy1423;
			}
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'l') {
				if (yych <= 'i') goto yy1431;
				if (yych <= 'k') goto yy1423;
				goto yy1432;
			} else {
				if (yych <= 'q') goto yy1423;
				if (yych <= 'r') goto yy1433;
				goto yy1434;
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 't') goto yy1435;
				if (yych <= 'u') goto yy1423;
				goto yy1436;
			} else {
				if (yych == 'y') goto yy1437;
				if (yych <= 'z') goto yy1423;
				goto yy1158;
			}
		}
	}
yy1369:
	yych = *++cur;
	if (yych == 't') goto yy1438;
	goto yy1124;
yy1370:
	yych = *++cur;
	if (yych == 'l') goto yy1439;
	goto yy1124;
yy1371:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 675 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::FNDEF); }
#line 7403 "src/parse/conf_lexer.cc"
yy1372:
	yych = *++cur;
	if (yych == 't') goto yy1440;
	goto yy1124;
yy1373:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 676 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::INDEX); }
#line 7413 "src/parse/conf_lexer.cc"
yy1374:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 678 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::LABEL); }
#line 7419 "src/parse/conf_lexer.cc"
yy1375:
	yych = *++cur;
	if (yych == 't') goto yy1441;
	goto yy1124;
yy1376:
	yych = *++cur;
	if (yych == 'l') goto yy1442;
	goto yy1124;
yy1377:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 689 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::SIGIL); }
#line 7433 "src/parse/conf_lexer.cc"
yy1378:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 691 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::STATE); }
#line 7439 "src/parse/conf_lexer.cc"
yy1379:
	yych = *++cur;
	if (yych == 'd') goto yy1443;
	goto yy1124;
yy1380:
	yych = *++cur;
	if (yych == 'o') goto yy1444;
	goto yy1124;
yy1381:
	yych = *++cur;
	if (yych == 'o') goto yy1445;
	goto yy1124;
yy1382:
	yych = *++cur;
	if (yych == 'e') goto yy1446;
	goto yy1144;
yy1383:
	yych = *++cur;
	if (yych == 'e') goto yy1447;
	goto yy1144;
yy1384:
	yych = *++cur;
	if (yych == 'i') goto yy1448;
	goto yy1144;
yy1385:
	yych = *++cur;
	if (yych == 't') goto yy1449;
	goto yy1144;
yy1386:
	yych = *++cur;
	if (yych == 'r') goto yy1450;
	goto yy1144;
yy1387:
	yych = *++cur;
	if (yych == 'l') goto yy1451;
	goto yy1144;
yy1388:
	yych = *++cur;
	if (yych == 'm') goto yy1452;
	goto yy1144;
yy1389:
	yych = *++cur;
	if (yych == 'l') goto yy1453;
	goto yy1144;
yy1390:
	yych = *++cur;
	if (yych == 'i') goto yy1454;
	goto yy1144;
yy1391:
	yych = *++cur;
	if (yych == 'd') goto yy1455;
	goto yy1144;
yy1392:
	yych = *++cur;
	if (yych == 'l') goto yy1456;
	goto yy1144;
yy1393:
	yych = *++cur;
	if (yych == '_') goto yy1457;
	goto yy1144;
yy1394:
	yych = *++cur;
	if (yych == 'b') goto yy1458;
	goto yy1144;
yy1395:
	yych = *++cur;
	if (yych == 'e') goto yy1459;
	goto yy1144;
yy1396:
	yych = *++cur;
	if (yych == 'o') goto yy1460;
	goto yy1144;
yy1397:
	yych = *++cur;
	if (yych == 'i') goto yy1461;
	goto yy1158;
yy1398:
	yych = *++cur;
	if (yych == 'U') goto yy1462;
	goto yy1158;
yy1399:
	yych = *++cur;
	if (yych == 'M') goto yy1463;
	if (yych == 'S') goto yy1464;
	goto yy1158;
yy1400:
	yych = *++cur;
	if (yych == 'A') goto yy1465;
	goto yy1158;
yy1401:
	yych = *++cur;
	if (yych == 'E') goto yy1466;
	goto yy1158;
yy1402:
	yych = *++cur;
	if (yych == 'O') goto yy1467;
	goto yy1158;
yy1403:
	yych = *++cur;
	if (yych == 'G') goto yy1468;
	goto yy1158;
yy1404:
	yych = *++cur;
	if (yych == 'C') goto yy1469;
	goto yy1158;
yy1405:
	yych = *++cur;
	if (yych == 'O') goto yy1470;
	goto yy1158;
yy1406:
	yych = *++cur;
	if (yych == 'T') goto yy1471;
	goto yy1158;
yy1407:
	yych = *++cur;
	if (yych == 'T') goto yy1472;
	goto yy1158;
yy1408:
	yych = *++cur;
	if (yych == 'T') goto yy1473;
	goto yy1158;
yy1409:
	yych = *++cur;
	if (yych == 'T') goto yy1474;
	goto yy1158;
yy1410:
	yych = *++cur;
	if (yych == 'E') goto yy1475;
	goto yy1158;
yy1411:
	yych = *++cur;
	if (yych == 'N') goto yy1476;
	if (yych == 'P') goto yy1477;
	goto yy1158;
yy1412:
	++cur;
#line 718 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::PEEK); }
#line 7578 "src/parse/conf_lexer.cc"
yy1413:
	yych = *++cur;
	if (yych == 'O') goto yy1478;
	goto yy1158;
yy1414:
	yych = *++cur;
	if (yych == 'C') goto yy1479;
	goto yy1158;
yy1415:
	yych = *++cur;
	if (yych == 'O') goto yy1480;
	goto yy1158;
yy1416:
	yych = *++cur;
	if (yych == 'T') goto yy1481;
	goto yy1158;
yy1417:
	yych = *++cur;
	if (yych == 'T') goto yy1482;
	goto yy1158;
yy1418:
	++cur;
#line 729 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::SKIP); }
#line 7603 "src/parse/conf_lexer.cc"
yy1419:
	yych = *++cur;
	if (yych == 'N') goto yy1484;
	if (yych == 'P') goto yy1485;
	goto yy1158;
yy1420:
	yych = *++cur;
	if (yych == 'e') goto yy1486;
	goto yy1124;
yy1421:
	yych = *++cur;
	if (yych == 'e') goto yy1487;
	goto yy1124;
yy1422:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 666 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::BRANCH); }
#line 7622 "src/parse/conf_lexer.cc"
yy1423:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
yy1424:
	if (yych <= '^') {
		if (yych <= '/') goto yy1425;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1425;
		if (yych <= 'z') goto yy1423;
	}
yy1425:
#line 657 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_tok("unknown code template: '%.*s'", int(cur - tok), tok));
    }
#line 7640 "src/parse/conf_lexer.cc"
yy1426:
	yych = *++cur;
	if (yych <= 'q') {
		if (yych == 'b') goto yy1488;
		goto yy1424;
	} else {
		if (yych <= 'r') goto yy1489;
		if (yych <= 's') goto yy1490;
		goto yy1424;
	}
yy1427:
	yych = *++cur;
	if (yych == 'm') goto yy1491;
	if (yych == 'o') goto yy1492;
	goto yy1424;
yy1428:
	yych = *++cur;
	if (yych == 'n') goto yy1493;
	goto yy1424;
yy1429:
	yych = *++cur;
	if (yych == 'i') goto yy1494;
	if (yych == 'n') goto yy1495;
	goto yy1424;
yy1430:
	yych = *++cur;
	if (yych == 'o') goto yy1496;
	goto yy1424;
yy1431:
	yych = *++cur;
	if (yych == 'f') goto yy1497;
	goto yy1424;
yy1432:
	yych = *++cur;
	if (yych == 'i') goto yy1498;
	if (yych == 'o') goto yy1499;
	goto yy1424;
yy1433:
	yych = *++cur;
	if (yych == 'e') goto yy1500;
	goto yy1424;
yy1434:
	yych = *++cur;
	if (yych == 'w') goto yy1501;
	goto yy1424;
yy1435:
	yych = *++cur;
	if (yych == 'a') goto yy1502;
	if (yych == 'y') goto yy1503;
	goto yy1424;
yy1436:
	yych = *++cur;
	if (yych == 'a') goto yy1504;
	goto yy1424;
yy1437:
	yych = *++cur;
	if (yych == 'y') goto yy1505;
	goto yy1424;
yy1438:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 736 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::DEDENT); }
#line 7704 "src/parse/conf_lexer.cc"
yy1439:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 674 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::FNDECL); }
#line 7710 "src/parse/conf_lexer.cc"
yy1440:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 735 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::INDENT); }
#line 7716 "src/parse/conf_lexer.cc"
yy1441:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 685 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::OFFSET); }
#line 7722 "src/parse/conf_lexer.cc"
yy1442:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 686 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::RETVAL); }
#line 7728 "src/parse/conf_lexer.cc"
yy1443:
	yych = *++cur;
	if (yych == 'e') goto yy1506;
	goto yy1124;
yy1444:
	yych = *++cur;
	if (yych == 'n') goto yy1507;
	goto yy1124;
yy1445:
	yych = *++cur;
	if (yych == 'r') goto yy1508;
	goto yy1124;
yy1446:
	yych = *++cur;
	if (yych == 'n') goto yy1509;
	goto yy1144;
yy1447:
	yych = *++cur;
	if (yych == 'c') goto yy1510;
	goto yy1144;
yy1448:
	yych = *++cur;
	if (yych == 'm') goto yy1511;
	goto yy1144;
yy1449:
	yych = *++cur;
	if (yych == 'y') goto yy1512;
	goto yy1144;
yy1450:
	yych = *++cur;
	if (yych == 'a') goto yy1513;
	goto yy1144;
yy1451:
	yych = *++cur;
	if (yych == 'i') goto yy1514;
	goto yy1144;
yy1452:
	yych = *++cur;
	if (yych == 'o') goto yy1515;
	goto yy1144;
yy1453:
	yych = *++cur;
	if (yych == 'a') goto yy1516;
	goto yy1144;
yy1454:
	yych = *++cur;
	if (yych == 'c') goto yy1517;
	goto yy1144;
yy1455:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1143;
#line 788 "../src/parse/conf_lexer.re"
	{ RET_LOPT(StxLOpt::NESTED); }
#line 7782 "src/parse/conf_lexer.cc"
yy1456:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1143;
#line 785 "../src/parse/conf_lexer.re"
	{ RET_LOPT(StxLOpt::RETVAL); }
#line 7788 "src/parse/conf_lexer.cc"
yy1457:
	yych = *++cur;
	if (yych == 'c') goto yy1518;
	goto yy1144;
yy1458:
	yych = *++cur;
	if (yych == 'l') goto yy1519;
	goto yy1144;
yy1459:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1143;
#line 772 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::UNSAFE); }
#line 7802 "src/parse/conf_lexer.cc"
yy1460:
	yych = *++cur;
	if (yych == 'n') goto yy1520;
	goto yy1144;
yy1461:
	yych = *++cur;
	if (yych == 'n') goto yy1521;
	goto yy1158;
yy1462:
	yych = *++cur;
	if (yych == 'P') goto yy1522;
	goto yy1158;
yy1463:
	yych = *++cur;
	if (yych == 'T') goto yy1524;
	goto yy1158;
yy1464:
	yych = *++cur;
	if (yych == 'T') goto yy1525;
	goto yy1158;
yy1465:
	yych = *++cur;
	if (yych == 'R') goto yy1526;
	goto yy1158;
yy1466:
	++cur;
#line 705 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::CTYPE); }
#line 7831 "src/parse/conf_lexer.cc"
yy1467:
	yych = *++cur;
	if (yych == 'R') goto yy1527;
	goto yy1158;
yy1468:
	++cur;
#line 708 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::DEBUG); }
#line 7840 "src/parse/conf_lexer.cc"
yy1469:
	yych = *++cur;
	if (yych == 'C') goto yy1528;
	goto yy1158;
yy1470:
	yych = *++cur;
	if (yych == 'N') goto yy1529;
	goto yy1158;
yy1471:
	yych = *++cur;
	if (yych == 'A') goto yy1530;
	goto yy1158;
yy1472:
	++cur;
#line 712 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::INPUT); }
#line 7857 "src/parse/conf_lexer.cc"
yy1473:
	yych = *++cur;
	if (yych == 'H') goto yy1531;
	goto yy1158;
yy1474:
	++cur;
#line 714 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::LIMIT); }
#line 7866 "src/parse/conf_lexer.cc"
yy1475:
	yych = *++cur;
	if (yych == 'R') goto yy1532;
	goto yy1158;
yy1476:
	++cur;
#line 716 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::MTAGN); }
#line 7875 "src/parse/conf_lexer.cc"
yy1477:
	++cur;
#line 717 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::MTAGP); }
#line 7880 "src/parse/conf_lexer.cc"
yy1478:
	yych = *++cur;
	if (yych == 'R') goto yy1533;
	goto yy1158;
yy1479:
	yych = *++cur;
	if (yych == 'C') goto yy1534;
	goto yy1158;
yy1480:
	yych = *++cur;
	if (yych == 'N') goto yy1535;
	goto yy1158;
yy1481:
	yych = *++cur;
	if (yych == 'A') goto yy1536;
	goto yy1158;
yy1482:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych == 'M') goto yy1537;
	if (yych == 'S') goto yy1538;
yy1483:
#line 726 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::SHIFT); }
#line 7905 "src/parse/conf_lexer.cc"
yy1484:
	++cur;
#line 730 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::STAGN); }
#line 7910 "src/parse/conf_lexer.cc"
yy1485:
	++cur;
#line 731 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::STAGP); }
#line 7915 "src/parse/conf_lexer.cc"
yy1486:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 663 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::ARGNAME); }
#line 7921 "src/parse/conf_lexer.cc"
yy1487:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 664 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::ARGTYPE); }
#line 7927 "src/parse/conf_lexer.cc"
yy1488:
	yych = *++cur;
	if (yych == 'o') goto yy1539;
	goto yy1424;
yy1489:
	yych = *++cur;
	if (yych == 'r') goto yy1540;
	goto yy1424;
yy1490:
	yych = *++cur;
	if (yych == 's') goto yy1541;
	goto yy1424;
yy1491:
	yych = *++cur;
	if (yych == 'p') goto yy1542;
	goto yy1424;
yy1492:
	yych = *++cur;
	if (yych == 'n') goto yy1543;
	goto yy1424;
yy1493:
	yych = *++cur;
	if (yych == 'u') goto yy1544;
	goto yy1424;
yy1494:
	yych = *++cur;
	if (yych == 'n') goto yy1545;
	goto yy1424;
yy1495:
	yych = *++cur;
	if (yych <= 'b') goto yy1424;
	if (yych <= 'c') goto yy1546;
	if (yych <= 'd') goto yy1547;
	goto yy1424;
yy1496:
	yych = *++cur;
	if (yych == 't') goto yy1548;
	goto yy1424;
yy1497:
	yych = *++cur;
	if (yych == '_') goto yy1549;
	goto yy1424;
yy1498:
	yych = *++cur;
	if (yych == 'n') goto yy1550;
	goto yy1424;
yy1499:
	yych = *++cur;
	if (yych == 'o') goto yy1551;
	goto yy1424;
yy1500:
	yych = *++cur;
	if (yych == 'c') goto yy1552;
	goto yy1424;
yy1501:
	yych = *++cur;
	if (yych == 'i') goto yy1553;
	goto yy1424;
yy1502:
	yych = *++cur;
	if (yych == 'i') goto yy1554;
	goto yy1424;
yy1503:
	yych = *++cur;
	if (yych == 'p') goto yy1555;
	goto yy1424;
yy1504:
	yych = *++cur;
	if (yych == 'r') goto yy1556;
	goto yy1424;
yy1505:
	yych = *++cur;
	switch (yych) {
		case 'b': goto yy1557;
		case 'c': goto yy1558;
		case 'd': goto yy1559;
		case 'g': goto yy1560;
		case 'l': goto yy1561;
		case 'm': goto yy1562;
		case 'p': goto yy1563;
		case 'r': goto yy1564;
		case 's': goto yy1565;
		default: goto yy1424;
	}
yy1506:
	yych = *++cur;
	if (yych == 'n') goto yy1566;
	goto yy1124;
yy1507:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 697 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::VER); }
#line 8021 "src/parse/conf_lexer.cc"
yy1508:
	yych = *++cur;
	if (yych == 'd') goto yy1567;
	goto yy1124;
yy1509:
	yych = *++cur;
	if (yych == 'e') goto yy1568;
	goto yy1144;
yy1510:
	yych = *++cur;
	if (yych == 'o') goto yy1569;
	goto yy1144;
yy1511:
	yych = *++cur;
	if (yych == 'p') goto yy1570;
	goto yy1144;
yy1512:
	yych = *++cur;
	if (yych == 'l') goto yy1571;
	goto yy1144;
yy1513:
	yych = *++cur;
	if (yych == 'n') goto yy1572;
	goto yy1144;
yy1514:
	yych = *++cur;
	if (yych == 't') goto yy1573;
	goto yy1144;
yy1515:
	yych = *++cur;
	if (yych == 'd') goto yy1574;
	goto yy1144;
yy1516:
	yych = *++cur;
	if (yych == 'b') goto yy1575;
	goto yy1144;
yy1517:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1143;
#line 773 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::MONADIC); }
#line 8063 "src/parse/conf_lexer.cc"
yy1518:
	yych = *++cur;
	if (yych == 'o') goto yy1576;
	goto yy1144;
yy1519:
	yych = *++cur;
	if (yych == 'e') goto yy1577;
	goto yy1144;
yy1520:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1143;
#line 770 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::VER); }
#line 8077 "src/parse/conf_lexer.cc"
yy1521:
	yych = *++cur;
	if (yych == 'e') goto yy1578;
	goto yy1158;
yy1522:
	yyaccept = 3;
	yych = *(mar = ++cur);
	if (yych == 'C') goto yy1579;
yy1523:
#line 699 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::BACKUP); }
#line 8089 "src/parse/conf_lexer.cc"
yy1524:
	yych = *++cur;
	if (yych == 'A') goto yy1580;
	goto yy1158;
yy1525:
	yych = *++cur;
	if (yych == 'A') goto yy1581;
	goto yy1158;
yy1526:
	yych = *++cur;
	if (yych == 'K') goto yy1582;
	goto yy1158;
yy1527:
	++cur;
#line 707 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::CURSOR); }
#line 8106 "src/parse/conf_lexer.cc"
yy1528:
	yych = *++cur;
	if (yych == 'E') goto yy1583;
	goto yy1158;
yy1529:
	yych = *++cur;
	if (yych == 'D') goto yy1584;
	goto yy1158;
yy1530:
	yych = *++cur;
	if (yych == 'T') goto yy1585;
	goto yy1158;
yy1531:
	yych = *++cur;
	if (yych == 'A') goto yy1586;
	goto yy1158;
yy1532:
	++cur;
#line 715 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::MARKER); }
#line 8127 "src/parse/conf_lexer.cc"
yy1533:
	yych = *++cur;
	if (yych == 'E') goto yy1587;
	goto yy1158;
yy1534:
	yych = *++cur;
	if (yych == 'E') goto yy1589;
	goto yy1158;
yy1535:
	yych = *++cur;
	if (yych == 'D') goto yy1590;
	goto yy1158;
yy1536:
	yych = *++cur;
	if (yych == 'T') goto yy1591;
	goto yy1158;
yy1537:
	yych = *++cur;
	if (yych == 'T') goto yy1592;
	goto yy1158;
yy1538:
	yych = *++cur;
	if (yych == 'T') goto yy1593;
	goto yy1158;
yy1539:
	yych = *++cur;
	if (yych == 'r') goto yy1594;
	goto yy1424;
yy1540:
	yych = *++cur;
	if (yych == 'a') goto yy1595;
	goto yy1424;
yy1541:
	yych = *++cur;
	if (yych == 'i') goto yy1596;
	goto yy1424;
yy1542:
	yych = *++cur;
	if (yych == '_') goto yy1597;
	goto yy1424;
yy1543:
	yych = *++cur;
	if (yych <= 'r') goto yy1424;
	if (yych <= 's') goto yy1598;
	if (yych <= 't') goto yy1599;
	goto yy1424;
yy1544:
	yych = *++cur;
	if (yych == 'm') goto yy1600;
	goto yy1424;
yy1545:
	yych = *++cur;
	if (yych == 'g') goto yy1602;
	goto yy1424;
yy1546:
	yych = *++cur;
	if (yych == 'a') goto yy1603;
	goto yy1424;
yy1547:
	yych = *++cur;
	if (yych == 'e') goto yy1604;
	goto yy1424;
yy1548:
	yych = *++cur;
	if (yych == 'o') goto yy1605;
	goto yy1424;
yy1549:
	yych = *++cur;
	if (yych == 't') goto yy1607;
	goto yy1424;
yy1550:
	yych = *++cur;
	if (yych == 'e') goto yy1608;
	goto yy1424;
yy1551:
	yych = *++cur;
	if (yych == 'p') goto yy1609;
	goto yy1424;
yy1552:
	yych = *++cur;
	if (yych == 'u') goto yy1611;
	goto yy1424;
yy1553:
	yych = *++cur;
	if (yych == 't') goto yy1612;
	goto yy1424;
yy1554:
	yych = *++cur;
	if (yych == 'l') goto yy1613;
	goto yy1424;
yy1555:
	yych = *++cur;
	if (yych == 'e') goto yy1614;
	goto yy1424;
yy1556:
	yych = *++cur;
	if (yych == '_') goto yy1615;
	goto yy1424;
yy1557:
	yych = *++cur;
	if (yych == 'a') goto yy1616;
	if (yych == 'm') goto yy1617;
	goto yy1424;
yy1558:
	yych = *++cur;
	if (yych == 'o') goto yy1618;
	goto yy1424;
yy1559:
	yych = *++cur;
	if (yych == 'e') goto yy1619;
	goto yy1424;
yy1560:
	yych = *++cur;
	if (yych == 'e') goto yy1620;
	goto yy1424;
yy1561:
	yych = *++cur;
	if (yych == 'e') goto yy1621;
	goto yy1424;
yy1562:
	yych = *++cur;
	if (yych == 't') goto yy1622;
	goto yy1424;
yy1563:
	yych = *++cur;
	if (yych == 'e') goto yy1623;
	goto yy1424;
yy1564:
	yych = *++cur;
	if (yych == 'e') goto yy1624;
	goto yy1424;
yy1565:
	yych = *++cur;
	switch (yych) {
		case 'e': goto yy1625;
		case 'h': goto yy1626;
		case 'k': goto yy1627;
		case 't': goto yy1628;
		default: goto yy1424;
	}
yy1566:
	yych = *++cur;
	if (yych == 't') goto yy1629;
	goto yy1124;
yy1567:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 719 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::RECORD); }
#line 8277 "src/parse/conf_lexer.cc"
yy1568:
	yych = *++cur;
	if (yych == 'r') goto yy1630;
	goto yy1144;
yy1569:
	yych = *++cur;
	if (yych == 'r') goto yy1631;
	goto yy1144;
yy1570:
	yych = *++cur;
	if (yych == 'l') goto yy1632;
	goto yy1144;
yy1571:
	yych = *++cur;
	if (yych == 'e') goto yy1633;
	goto yy1144;
yy1572:
	yych = *++cur;
	if (yych == 'g') goto yy1634;
	goto yy1144;
yy1573:
	yych = *++cur;
	if (yych == 'e') goto yy1635;
	goto yy1144;
yy1574:
	yych = *++cur;
	if (yych == 'e') goto yy1636;
	goto yy1144;
yy1575:
	yych = *++cur;
	if (yych == 'e') goto yy1637;
	goto yy1144;
yy1576:
	yych = *++cur;
	if (yych == 'n') goto yy1638;
	goto yy1144;
yy1577:
	yych = *++cur;
	if (yych == '_') goto yy1639;
	goto yy1144;
yy1578:
	yych = *++cur;
	if (yych == 'd') goto yy1640;
	goto yy1158;
yy1579:
	yych = *++cur;
	if (yych == 'T') goto yy1641;
	goto yy1158;
yy1580:
	yych = *++cur;
	if (yych == 'G') goto yy1642;
	goto yy1158;
yy1581:
	yych = *++cur;
	if (yych == 'G') goto yy1643;
	goto yy1158;
yy1582:
	yych = *++cur;
	if (yych == 'E') goto yy1644;
	goto yy1158;
yy1583:
	yych = *++cur;
	if (yych == 'P') goto yy1645;
	goto yy1158;
yy1584:
	++cur;
#line 710 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::GETCOND); }
#line 8346 "src/parse/conf_lexer.cc"
yy1585:
	yych = *++cur;
	if (yych == 'E') goto yy1646;
	goto yy1158;
yy1586:
	yych = *++cur;
	if (yych == 'N') goto yy1647;
	goto yy1158;
yy1587:
	yyaccept = 4;
	yych = *(mar = ++cur);
	if (yych == 'C') goto yy1648;
	if (yych == 'T') goto yy1649;
yy1588:
#line 720 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::RESTORE); }
#line 8363 "src/parse/conf_lexer.cc"
yy1589:
	yych = *++cur;
	if (yych == 'P') goto yy1650;
	goto yy1158;
yy1590:
	++cur;
#line 724 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::SETCOND); }
#line 8372 "src/parse/conf_lexer.cc"
yy1591:
	yych = *++cur;
	if (yych == 'E') goto yy1651;
	goto yy1158;
yy1592:
	yych = *++cur;
	if (yych == 'A') goto yy1652;
	goto yy1158;
yy1593:
	yych = *++cur;
	if (yych == 'A') goto yy1653;
	goto yy1158;
yy1594:
	yych = *++cur;
	if (yych == 't') goto yy1654;
	goto yy1424;
yy1595:
	yych = *++cur;
	if (yych == 'y') goto yy1656;
	goto yy1424;
yy1596:
	yych = *++cur;
	if (yych == 'g') goto yy1657;
	goto yy1424;
yy1597:
	yych = *++cur;
	switch (yych) {
		case 'e': goto yy1658;
		case 'g': goto yy1659;
		case 'l': goto yy1660;
		case 'n': goto yy1661;
		default: goto yy1424;
	}
yy1598:
	yych = *++cur;
	if (yych == 't') goto yy1662;
	goto yy1424;
yy1599:
	yych = *++cur;
	if (yych == 'i') goto yy1663;
	goto yy1424;
yy1600:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1601;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych <= '_') goto yy1664;
		if (yych <= '`') goto yy1601;
		if (yych <= 'z') goto yy1423;
	}
yy1601:
#line 613 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_enum); }
#line 8427 "src/parse/conf_lexer.cc"
yy1602:
	yych = *++cur;
	if (yych == 'e') goto yy1665;
	goto yy1424;
yy1603:
	yych = *++cur;
	if (yych == 'l') goto yy1666;
	goto yy1424;
yy1604:
	yych = *++cur;
	if (yych == 'c') goto yy1667;
	if (yych == 'f') goto yy1668;
	goto yy1424;
yy1605:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1606;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1606;
		if (yych <= 'z') goto yy1423;
	}
yy1606:
#line 612 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_goto); }
#line 8453 "src/parse/conf_lexer.cc"
yy1607:
	yych = *++cur;
	if (yych == 'h') goto yy1670;
	goto yy1424;
yy1608:
	yych = *++cur;
	if (yych == '_') goto yy1671;
	goto yy1424;
yy1609:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1610;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1610;
		if (yych <= 'z') goto yy1423;
	}
yy1610:
#line 610 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_loop); }
#line 8474 "src/parse/conf_lexer.cc"
yy1611:
	yych = *++cur;
	if (yych == 'r') goto yy1672;
	goto yy1424;
yy1612:
	yych = *++cur;
	if (yych == 'c') goto yy1673;
	goto yy1424;
yy1613:
	yych = *++cur;
	if (yych == 'c') goto yy1674;
	goto yy1424;
yy1614:
	yych = *++cur;
	if (yych == '_') goto yy1675;
	goto yy1424;
yy1615:
	yych = *++cur;
	if (yych == 'g') goto yy1676;
	if (yych == 'l') goto yy1677;
	goto yy1424;
yy1616:
	yych = *++cur;
	if (yych == 'c') goto yy1678;
	goto yy1424;
yy1617:
	yych = *++cur;
	if (yych == '_') goto yy1679;
	goto yy1424;
yy1618:
	yych = *++cur;
	if (yych == 'p') goto yy1680;
	goto yy1424;
yy1619:
	yych = *++cur;
	if (yych == 'b') goto yy1681;
	goto yy1424;
yy1620:
	yych = *++cur;
	if (yych == 't') goto yy1682;
	goto yy1424;
yy1621:
	yych = *++cur;
	if (yych == 's') goto yy1683;
	goto yy1424;
yy1622:
	yych = *++cur;
	if (yych == 'a') goto yy1684;
	goto yy1424;
yy1623:
	yych = *++cur;
	if (yych == 'e') goto yy1685;
	goto yy1424;
yy1624:
	yych = *++cur;
	if (yych == 's') goto yy1686;
	goto yy1424;
yy1625:
	yych = *++cur;
	if (yych == 't') goto yy1687;
	goto yy1424;
yy1626:
	yych = *++cur;
	if (yych == 'i') goto yy1688;
	goto yy1424;
yy1627:
	yych = *++cur;
	if (yych == 'i') goto yy1689;
	goto yy1424;
yy1628:
	yych = *++cur;
	if (yych == 'a') goto yy1690;
	goto yy1424;
yy1629:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1123;
#line 737 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::TOPINDENT); }
#line 8553 "src/parse/conf_lexer.cc"
yy1630:
	yych = *++cur;
	if (yych == 'i') goto yy1691;
	goto yy1144;
yy1631:
	yych = *++cur;
	if (yych == 'd') goto yy1692;
	goto yy1144;
yy1632:
	yych = *++cur;
	if (yych == 'e') goto yy1693;
	goto yy1144;
yy1633:
	yych = *++cur;
	if (yych == '.') goto yy1694;
	goto yy1144;
yy1634:
	yych = *++cur;
	if (yych == 'e') goto yy1695;
	goto yy1144;
yy1635:
	yych = *++cur;
	if (yych == 'r') goto yy1696;
	goto yy1144;
yy1636:
	yych = *++cur;
	if (yych == 'l') goto yy1697;
	goto yy1144;
yy1637:
	yych = *++cur;
	if (yych == 'l') goto yy1698;
	goto yy1144;
yy1638:
	yych = *++cur;
	if (yych == 'd') goto yy1699;
	goto yy1144;
yy1639:
	yych = *++cur;
	if (yych == 's') goto yy1700;
	goto yy1144;
yy1640:
	yych = *++cur;
	if (yych == '>') goto yy1701;
	goto yy1158;
yy1641:
	yych = *++cur;
	if (yych == 'X') goto yy1702;
	goto yy1158;
yy1642:
	++cur;
#line 703 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::COPYMTAG); }
#line 8606 "src/parse/conf_lexer.cc"
yy1643:
	++cur;
#line 704 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::COPYSTAG); }
#line 8611 "src/parse/conf_lexer.cc"
yy1644:
	yych = *++cur;
	if (yych == 'R') goto yy1703;
	goto yy1158;
yy1645:
	yych = *++cur;
	if (yych == 'T') goto yy1704;
	goto yy1158;
yy1646:
	++cur;
#line 711 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::GETSTATE); }
#line 8624 "src/parse/conf_lexer.cc"
yy1647:
	++cur;
#line 713 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::LESSTHAN); }
#line 8629 "src/parse/conf_lexer.cc"
yy1648:
	yych = *++cur;
	if (yych == 'T') goto yy1705;
	goto yy1158;
yy1649:
	yych = *++cur;
	if (yych == 'A') goto yy1706;
	goto yy1158;
yy1650:
	yych = *++cur;
	if (yych == 'T') goto yy1707;
	goto yy1158;
yy1651:
	++cur;
#line 725 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::SETSTATE); }
#line 8646 "src/parse/conf_lexer.cc"
yy1652:
	yych = *++cur;
	if (yych == 'G') goto yy1708;
	goto yy1158;
yy1653:
	yych = *++cur;
	if (yych == 'G') goto yy1709;
	goto yy1158;
yy1654:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1655;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1655;
		if (yych <= 'z') goto yy1423;
	}
yy1655:
#line 622 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_abort); }
#line 8667 "src/parse/conf_lexer.cc"
yy1656:
	yych = *++cur;
	if (yych == '_') goto yy1710;
	goto yy1424;
yy1657:
	yych = *++cur;
	if (yych == 'n') goto yy1711;
	goto yy1424;
yy1658:
	yych = *++cur;
	if (yych == 'q') goto yy1713;
	goto yy1424;
yy1659:
	yych = *++cur;
	if (yych == 'e') goto yy1715;
	if (yych == 't') goto yy1717;
	goto yy1424;
yy1660:
	yych = *++cur;
	if (yych == 'e') goto yy1719;
	if (yych == 't') goto yy1721;
	goto yy1424;
yy1661:
	yych = *++cur;
	if (yych == 'e') goto yy1723;
	goto yy1424;
yy1662:
	yych = *++cur;
	if (yych == '_') goto yy1725;
	goto yy1424;
yy1663:
	yych = *++cur;
	if (yych == 'n') goto yy1726;
	goto yy1424;
yy1664:
	yych = *++cur;
	if (yych == 'e') goto yy1727;
	goto yy1424;
yy1665:
	yych = *++cur;
	if (yych == 'r') goto yy1728;
	goto yy1424;
yy1666:
	yych = *++cur;
	if (yych == 'l') goto yy1729;
	goto yy1424;
yy1667:
	yych = *++cur;
	if (yych == 'l') goto yy1731;
	goto yy1424;
yy1668:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1669;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1669;
		if (yych <= 'z') goto yy1423;
	}
yy1669:
#line 616 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_fndef); }
#line 8730 "src/parse/conf_lexer.cc"
yy1670:
	yych = *++cur;
	if (yych == 'e') goto yy1733;
	goto yy1424;
yy1671:
	yych = *++cur;
	if (yych == 'i') goto yy1734;
	goto yy1424;
yy1672:
	yych = *++cur;
	if (yych == 's') goto yy1735;
	goto yy1424;
yy1673:
	yych = *++cur;
	if (yych == 'h') goto yy1736;
	goto yy1424;
yy1674:
	yych = *++cur;
	if (yych == 'a') goto yy1738;
	goto yy1424;
yy1675:
	yych = *++cur;
	if (yych <= 't') {
		if (yych == 'i') goto yy1739;
		goto yy1424;
	} else {
		if (yych <= 'u') goto yy1740;
		if (yych == 'y') goto yy1741;
		goto yy1424;
	}
yy1676:
	yych = *++cur;
	if (yych == 'l') goto yy1742;
	goto yy1424;
yy1677:
	yych = *++cur;
	if (yych == 'o') goto yy1743;
	goto yy1424;
yy1678:
	yych = *++cur;
	if (yych == 'k') goto yy1744;
	goto yy1424;
yy1679:
	yych = *++cur;
	if (yych == 'f') goto yy1745;
	if (yych == 'm') goto yy1746;
	goto yy1424;
yy1680:
	yych = *++cur;
	if (yych == 'y') goto yy1747;
	goto yy1424;
yy1681:
	yych = *++cur;
	if (yych == 'u') goto yy1748;
	goto yy1424;
yy1682:
	yych = *++cur;
	if (yych <= 'b') {
		if (yych == 'a') goto yy1749;
		goto yy1424;
	} else {
		if (yych <= 'c') goto yy1750;
		if (yych == 's') goto yy1751;
		goto yy1424;
	}
yy1683:
	yych = *++cur;
	if (yych == 's') goto yy1752;
	goto yy1424;
yy1684:
	yych = *++cur;
	if (yych == 'g') goto yy1753;
	goto yy1424;
yy1685:
	yych = *++cur;
	if (yych == 'k') goto yy1754;
	goto yy1424;
yy1686:
	yych = *++cur;
	if (yych == 't') goto yy1756;
	goto yy1424;
yy1687:
	yych = *++cur;
	if (yych <= 'b') {
		if (yych == 'a') goto yy1757;
		goto yy1424;
	} else {
		if (yych <= 'c') goto yy1758;
		if (yych == 's') goto yy1759;
		goto yy1424;
	}
yy1688:
	yych = *++cur;
	if (yych == 'f') goto yy1760;
	goto yy1424;
yy1689:
	yych = *++cur;
	if (yych == 'p') goto yy1761;
	goto yy1424;
yy1690:
	yych = *++cur;
	if (yych == 'g') goto yy1763;
	goto yy1424;
yy1691:
	yych = *++cur;
	if (yych == 'c') goto yy1764;
	goto yy1144;
yy1692:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1143;
#line 764 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::API_RECORD); }
#line 8843 "src/parse/conf_lexer.cc"
yy1693:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1143;
#line 762 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::API_SIMPLE); }
#line 8849 "src/parse/conf_lexer.cc"
yy1694:
	yych = *++cur;
	if (yych == 'f') goto yy1765;
	goto yy1144;
yy1695:
	yych = *++cur;
	if (yych == 's') goto yy1766;
	goto yy1144;
yy1696:
	yych = *++cur;
	if (yych == 'a') goto yy1767;
	goto yy1144;
yy1697:
	yych = *++cur;
	if (yych == '.') goto yy1768;
	goto yy1144;
yy1698:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1143;
#line 774 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::LOOP_LABEL); }
#line 8871 "src/parse/conf_lexer.cc"
yy1699:
	yych = *++cur;
	if (yych == 'i') goto yy1769;
	goto yy1144;
yy1700:
	yych = *++cur;
	if (yych == 't') goto yy1770;
	goto yy1144;
yy1701:
	++cur;
#line 740 "../src/parse/conf_lexer.re"
	{ RET_TOK(CONF_UD); }
#line 8884 "src/parse/conf_lexer.cc"
yy1702:
	++cur;
#line 700 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::BACKUPCTX); }
#line 8889 "src/parse/conf_lexer.cc"
yy1703:
	++cur;
#line 706 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::CTXMARKER); }
#line 8894 "src/parse/conf_lexer.cc"
yy1704:
	++cur;
#line 709 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::GETACCEPT); }
#line 8899 "src/parse/conf_lexer.cc"
yy1705:
	yych = *++cur;
	if (yych == 'X') goto yy1771;
	goto yy1158;
yy1706:
	yych = *++cur;
	if (yych == 'G') goto yy1772;
	goto yy1158;
yy1707:
	++cur;
#line 723 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::SETACCEPT); }
#line 8912 "src/parse/conf_lexer.cc"
yy1708:
	++cur;
#line 727 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::SHIFTMTAG); }
#line 8917 "src/parse/conf_lexer.cc"
yy1709:
	++cur;
#line 728 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::SHIFTSTAG); }
#line 8922 "src/parse/conf_lexer.cc"
yy1710:
	yych = *++cur;
	if (yych <= 'f') {
		if (yych == 'e') goto yy1773;
		goto yy1424;
	} else {
		if (yych <= 'g') goto yy1774;
		if (yych == 'l') goto yy1775;
		goto yy1424;
	}
yy1711:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1712;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1712;
		if (yych <= 'z') goto yy1423;
	}
yy1712:
#line 596 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_assign); }
#line 8945 "src/parse/conf_lexer.cc"
yy1713:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1714;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1714;
		if (yych <= 'z') goto yy1423;
	}
yy1714:
#line 597 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_cmp_eq); }
#line 8958 "src/parse/conf_lexer.cc"
yy1715:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1716;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1716;
		if (yych <= 'z') goto yy1423;
	}
yy1716:
#line 602 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_cmp_ge); }
#line 8971 "src/parse/conf_lexer.cc"
yy1717:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1718;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1718;
		if (yych <= 'z') goto yy1423;
	}
yy1718:
#line 600 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_cmp_gt); }
#line 8984 "src/parse/conf_lexer.cc"
yy1719:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1720;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1720;
		if (yych <= 'z') goto yy1423;
	}
yy1720:
#line 601 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_cmp_le); }
#line 8997 "src/parse/conf_lexer.cc"
yy1721:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1722;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1722;
		if (yych <= 'z') goto yy1423;
	}
yy1722:
#line 599 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_cmp_lt); }
#line 9010 "src/parse/conf_lexer.cc"
yy1723:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1724;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1724;
		if (yych <= 'z') goto yy1423;
	}
yy1724:
#line 598 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_cmp_ne); }
#line 9023 "src/parse/conf_lexer.cc"
yy1725:
	yych = *++cur;
	if (yych == 'g') goto yy1776;
	if (yych == 'l') goto yy1777;
	goto yy1424;
yy1726:
	yych = *++cur;
	if (yych == 'u') goto yy1778;
	goto yy1424;
yy1727:
	yych = *++cur;
	if (yych == 'l') goto yy1779;
	goto yy1424;
yy1728:
	yych = *++cur;
	if (yych == 'p') goto yy1780;
	goto yy1424;
yy1729:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1730;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1730;
		if (yych <= 'z') goto yy1423;
	}
yy1730:
#line 617 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_fncall); }
#line 9053 "src/parse/conf_lexer.cc"
yy1731:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1732;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1732;
		if (yych <= 'z') goto yy1423;
	}
yy1732:
#line 615 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_fndecl); }
#line 9066 "src/parse/conf_lexer.cc"
yy1733:
	yych = *++cur;
	if (yych == 'n') goto yy1781;
	goto yy1424;
yy1734:
	yych = *++cur;
	if (yych == 'n') goto yy1782;
	goto yy1424;
yy1735:
	yych = *++cur;
	if (yych == 'i') goto yy1783;
	goto yy1424;
yy1736:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1737;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych <= '_') goto yy1784;
		if (yych <= '`') goto yy1737;
		if (yych <= 'z') goto yy1423;
	}
yy1737:
#line 605 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_switch); }
#line 9092 "src/parse/conf_lexer.cc"
yy1738:
	yych = *++cur;
	if (yych == 'l') goto yy1785;
	goto yy1424;
yy1739:
	yych = *++cur;
	if (yych == 'n') goto yy1786;
	goto yy1424;
yy1740:
	yych = *++cur;
	if (yych == 'i') goto yy1787;
	goto yy1424;
yy1741:
	yych = *++cur;
	if (yych == 'y') goto yy1788;
	goto yy1424;
yy1742:
	yych = *++cur;
	if (yych == 'o') goto yy1789;
	goto yy1424;
yy1743:
	yych = *++cur;
	if (yych == 'c') goto yy1790;
	goto yy1424;
yy1744:
	yych = *++cur;
	if (yych == 'u') goto yy1791;
	goto yy1424;
yy1745:
	yych = *++cur;
	if (yych == 'i') goto yy1792;
	goto yy1424;
yy1746:
	yych = *++cur;
	if (yych == 'a') goto yy1793;
	goto yy1424;
yy1747:
	yych = *++cur;
	if (yych == 'm') goto yy1794;
	if (yych == 's') goto yy1795;
	goto yy1424;
yy1748:
	yych = *++cur;
	if (yych == 'g') goto yy1796;
	goto yy1424;
yy1749:
	yych = *++cur;
	if (yych == 'c') goto yy1798;
	goto yy1424;
yy1750:
	yych = *++cur;
	if (yych == 'o') goto yy1799;
	goto yy1424;
yy1751:
	yych = *++cur;
	if (yych == 't') goto yy1800;
	goto yy1424;
yy1752:
	yych = *++cur;
	if (yych == 't') goto yy1801;
	goto yy1424;
yy1753:
	yych = *++cur;
	if (yych == 'n') goto yy1802;
	if (yych == 'p') goto yy1804;
	goto yy1424;
yy1754:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1755;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych <= '_') goto yy1806;
		if (yych <= '`') goto yy1755;
		if (yych <= 'z') goto yy1423;
	}
yy1755:
#line 624 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yypeek); }
#line 9172 "src/parse/conf_lexer.cc"
yy1756:
	yych = *++cur;
	if (yych == 'o') goto yy1807;
	goto yy1424;
yy1757:
	yych = *++cur;
	if (yych == 'c') goto yy1808;
	goto yy1424;
yy1758:
	yych = *++cur;
	if (yych == 'o') goto yy1809;
	goto yy1424;
yy1759:
	yych = *++cur;
	if (yych == 't') goto yy1810;
	goto yy1424;
yy1760:
	yych = *++cur;
	if (yych == 't') goto yy1811;
	goto yy1424;
yy1761:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1762;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych <= '_') goto yy1812;
		if (yych <= '`') goto yy1762;
		if (yych <= 'z') goto yy1423;
	}
yy1762:
#line 625 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yyskip); }
#line 9206 "src/parse/conf_lexer.cc"
yy1763:
	yych = *++cur;
	if (yych == 'n') goto yy1813;
	if (yych == 'p') goto yy1815;
	goto yy1424;
yy1764:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1143;
#line 763 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::API_GENERIC); }
#line 9217 "src/parse/conf_lexer.cc"
yy1765:
	yych = *++cur;
	if (yych == 'r') goto yy1817;
	if (yych == 'u') goto yy1818;
	goto yy1144;
yy1766:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1143;
#line 771 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::CASE_RANGES); }
#line 9228 "src/parse/conf_lexer.cc"
yy1767:
	yych = *++cur;
	if (yych == 'l') goto yy1819;
	goto yy1144;
yy1768:
	yych = *++cur;
	if (yych <= 'k') {
		if (yych == 'g') goto yy1820;
		goto yy1144;
	} else {
		if (yych <= 'l') goto yy1821;
		if (yych == 'r') goto yy1822;
		goto yy1144;
	}
yy1769:
	yych = *++cur;
	if (yych == 't') goto yy1823;
	goto yy1144;
yy1770:
	yych = *++cur;
	if (yych == 'a') goto yy1824;
	goto yy1144;
yy1771:
	++cur;
#line 721 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::RESTORECTX); }
#line 9255 "src/parse/conf_lexer.cc"
yy1772:
	++cur;
#line 722 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::RESTORETAG); }
#line 9260 "src/parse/conf_lexer.cc"
yy1773:
	yych = *++cur;
	if (yych == 'l') goto yy1825;
	goto yy1424;
yy1774:
	yych = *++cur;
	if (yych == 'l') goto yy1826;
	goto yy1424;
yy1775:
	yych = *++cur;
	if (yych == 'o') goto yy1827;
	goto yy1424;
yy1776:
	yych = *++cur;
	if (yych == 'l') goto yy1828;
	goto yy1424;
yy1777:
	yych = *++cur;
	if (yych == 'o') goto yy1829;
	goto yy1424;
yy1778:
	yych = *++cur;
	if (yych == 'e') goto yy1830;
	goto yy1424;
yy1779:
	yych = *++cur;
	if (yych == 'e') goto yy1832;
	goto yy1424;
yy1780:
	yych = *++cur;
	if (yych == 'r') goto yy1833;
	goto yy1424;
yy1781:
	yych = *++cur;
	if (yych == '_') goto yy1834;
	goto yy1424;
yy1782:
	yych = *++cur;
	if (yych == 'f') goto yy1835;
	goto yy1424;
yy1783:
	yych = *++cur;
	if (yych == 'v') goto yy1836;
	goto yy1424;
yy1784:
	yych = *++cur;
	if (yych == 'c') goto yy1837;
	goto yy1424;
yy1785:
	yych = *++cur;
	if (yych == 'l') goto yy1838;
	goto yy1424;
yy1786:
	yych = *++cur;
	if (yych == 't') goto yy1840;
	goto yy1424;
yy1787:
	yych = *++cur;
	if (yych == 'n') goto yy1842;
	goto yy1424;
yy1788:
	yych = *++cur;
	if (yych == 'b') goto yy1843;
	if (yych == 't') goto yy1844;
	goto yy1424;
yy1789:
	yych = *++cur;
	if (yych == 'b') goto yy1845;
	goto yy1424;
yy1790:
	yych = *++cur;
	if (yych == 'a') goto yy1846;
	goto yy1424;
yy1791:
	yych = *++cur;
	if (yych == 'p') goto yy1847;
	goto yy1424;
yy1792:
	yych = *++cur;
	if (yych == 'l') goto yy1849;
	goto yy1424;
yy1793:
	yych = *++cur;
	if (yych == 't') goto yy1850;
	goto yy1424;
yy1794:
	yych = *++cur;
	if (yych == 't') goto yy1851;
	goto yy1424;
yy1795:
	yych = *++cur;
	if (yych == 't') goto yy1852;
	goto yy1424;
yy1796:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1797;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1797;
		if (yych <= 'z') goto yy1423;
	}
yy1797:
#line 623 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yydebug); }
#line 9366 "src/parse/conf_lexer.cc"
yy1798:
	yych = *++cur;
	if (yych == 'c') goto yy1853;
	goto yy1424;
yy1799:
	yych = *++cur;
	if (yych == 'n') goto yy1854;
	goto yy1424;
yy1800:
	yych = *++cur;
	if (yych == 'a') goto yy1855;
	goto yy1424;
yy1801:
	yych = *++cur;
	if (yych == 'h') goto yy1856;
	goto yy1424;
yy1802:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1803;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1803;
		if (yych <= 'z') goto yy1423;
	}
yy1803:
#line 635 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yymtagn); }
#line 9395 "src/parse/conf_lexer.cc"
yy1804:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1805;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1805;
		if (yych <= 'z') goto yy1423;
	}
yy1805:
#line 637 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yymtagp); }
#line 9408 "src/parse/conf_lexer.cc"
yy1806:
	yych = *++cur;
	if (yych == 'y') goto yy1857;
	goto yy1424;
yy1807:
	yych = *++cur;
	if (yych == 'r') goto yy1858;
	goto yy1424;
yy1808:
	yych = *++cur;
	if (yych == 'c') goto yy1859;
	goto yy1424;
yy1809:
	yych = *++cur;
	if (yych == 'n') goto yy1860;
	goto yy1424;
yy1810:
	yych = *++cur;
	if (yych == 'a') goto yy1861;
	goto yy1424;
yy1811:
	yych = *++cur;
	if (yych <= '`') {
		if (yych <= '9') {
			if (yych >= '0') goto yy1423;
		} else {
			if (yych == '_') goto yy1423;
		}
	} else {
		if (yych <= 'r') {
			if (yych == 'm') goto yy1862;
			goto yy1423;
		} else {
			if (yych <= 's') goto yy1863;
			if (yych <= 'z') goto yy1423;
		}
	}
#line 631 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yyshift); }
#line 9448 "src/parse/conf_lexer.cc"
yy1812:
	yych = *++cur;
	if (yych == 'y') goto yy1864;
	goto yy1424;
yy1813:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1814;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1814;
		if (yych <= 'z') goto yy1423;
	}
yy1814:
#line 634 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yystagn); }
#line 9465 "src/parse/conf_lexer.cc"
yy1815:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1816;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1816;
		if (yych <= 'z') goto yy1423;
	}
yy1816:
#line 636 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yystagp); }
#line 9478 "src/parse/conf_lexer.cc"
yy1817:
	yych = *++cur;
	if (yych == 'e') goto yy1865;
	goto yy1144;
yy1818:
	yych = *++cur;
	if (yych == 'n') goto yy1866;
	goto yy1144;
yy1819:
	yych = *++cur;
	if (yych == 's') goto yy1867;
	goto yy1144;
yy1820:
	yych = *++cur;
	if (yych == 'o') goto yy1868;
	goto yy1144;
yy1821:
	yych = *++cur;
	if (yych == 'o') goto yy1869;
	goto yy1144;
yy1822:
	yych = *++cur;
	if (yych == 'e') goto yy1870;
	goto yy1144;
yy1823:
	yych = *++cur;
	if (yych == 'i') goto yy1871;
	goto yy1144;
yy1824:
	yych = *++cur;
	if (yych == 't') goto yy1872;
	goto yy1144;
yy1825:
	yych = *++cur;
	if (yych == 'e') goto yy1873;
	goto yy1424;
yy1826:
	yych = *++cur;
	if (yych == 'o') goto yy1874;
	goto yy1424;
yy1827:
	yych = *++cur;
	if (yych == 'c') goto yy1875;
	goto yy1424;
yy1828:
	yych = *++cur;
	if (yych == 'o') goto yy1876;
	goto yy1424;
yy1829:
	yych = *++cur;
	if (yych == 'c') goto yy1877;
	goto yy1424;
yy1830:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1831;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1831;
		if (yych <= 'z') goto yy1423;
	}
yy1831:
#line 611 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_continue); }
#line 9543 "src/parse/conf_lexer.cc"
yy1832:
	yych = *++cur;
	if (yych == 'm') goto yy1878;
	goto yy1424;
yy1833:
	yych = *++cur;
	if (yych == 'i') goto yy1880;
	goto yy1424;
yy1834:
	yych = *++cur;
	if (yych == 'e') goto yy1881;
	goto yy1424;
yy1835:
	yych = *++cur;
	if (yych == 'o') goto yy1882;
	goto yy1424;
yy1836:
	yych = *++cur;
	if (yych == 'e') goto yy1884;
	goto yy1424;
yy1837:
	yych = *++cur;
	if (yych == 'a') goto yy1885;
	goto yy1424;
yy1838:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1839;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1839;
		if (yych <= 'z') goto yy1423;
	}
yy1839:
#line 618 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_tailcall); }
#line 9580 "src/parse/conf_lexer.cc"
yy1840:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1841;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1841;
		if (yych <= 'z') goto yy1423;
	}
yy1841:
#line 592 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_type_int); }
#line 9593 "src/parse/conf_lexer.cc"
yy1842:
	yych = *++cur;
	if (yych == 't') goto yy1886;
	goto yy1424;
yy1843:
	yych = *++cur;
	if (yych == 'm') goto yy1888;
	goto yy1424;
yy1844:
	yych = *++cur;
	if (yych == 'a') goto yy1890;
	goto yy1424;
yy1845:
	yych = *++cur;
	if (yych == 'a') goto yy1891;
	goto yy1424;
yy1846:
	yych = *++cur;
	if (yych == 'l') goto yy1892;
	goto yy1424;
yy1847:
	yych = *++cur;
	if (yych <= '_') {
		if (yych <= '/') goto yy1848;
		if (yych <= '9') goto yy1423;
		if (yych >= '_') goto yy1894;
	} else {
		if (yych <= 'b') {
			if (yych >= 'a') goto yy1423;
		} else {
			if (yych <= 'c') goto yy1895;
			if (yych <= 'z') goto yy1423;
		}
	}
yy1848:
#line 626 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yybackup); }
#line 9631 "src/parse/conf_lexer.cc"
yy1849:
	yych = *++cur;
	if (yych == 't') goto yy1896;
	goto yy1424;
yy1850:
	yych = *++cur;
	if (yych == 'c') goto yy1897;
	goto yy1424;
yy1851:
	yych = *++cur;
	if (yych == 'a') goto yy1898;
	goto yy1424;
yy1852:
	yych = *++cur;
	if (yych == 'a') goto yy1899;
	goto yy1424;
yy1853:
	yych = *++cur;
	if (yych == 'e') goto yy1900;
	goto yy1424;
yy1854:
	yych = *++cur;
	if (yych == 'd') goto yy1901;
	goto yy1424;
yy1855:
	yych = *++cur;
	if (yych == 't') goto yy1903;
	goto yy1424;
yy1856:
	yych = *++cur;
	if (yych == 'a') goto yy1904;
	goto yy1424;
yy1857:
	yych = *++cur;
	if (yych == 'y') goto yy1905;
	goto yy1424;
yy1858:
	yych = *++cur;
	if (yych == 'e') goto yy1906;
	goto yy1424;
yy1859:
	yych = *++cur;
	if (yych == 'e') goto yy1907;
	goto yy1424;
yy1860:
	yych = *++cur;
	if (yych == 'd') goto yy1908;
	goto yy1424;
yy1861:
	yych = *++cur;
	if (yych == 't') goto yy1910;
	goto yy1424;
yy1862:
	yych = *++cur;
	if (yych == 't') goto yy1911;
	goto yy1424;
yy1863:
	yych = *++cur;
	if (yych == 't') goto yy1912;
	goto yy1424;
yy1864:
	yych = *++cur;
	if (yych == 'y') goto yy1913;
	goto yy1424;
yy1865:
	yych = *++cur;
	if (yych == 'e') goto yy1914;
	goto yy1144;
yy1866:
	yych = *++cur;
	if (yych == 'c') goto yy1915;
	goto yy1144;
yy1867:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1143;
#line 781 "../src/parse/conf_lexer.re"
	{ RET_LOPT(StxLOpt::CHAR_LITERALS); }
#line 9709 "src/parse/conf_lexer.cc"
yy1868:
	yych = *++cur;
	if (yych == 't') goto yy1916;
	goto yy1144;
yy1869:
	yych = *++cur;
	if (yych == 'o') goto yy1917;
	goto yy1144;
yy1870:
	yych = *++cur;
	if (yych == 'c') goto yy1918;
	goto yy1144;
yy1871:
	yych = *++cur;
	if (yych == 'o') goto yy1919;
	goto yy1144;
yy1872:
	yych = *++cur;
	if (yych == 'e') goto yy1920;
	goto yy1144;
yy1873:
	yych = *++cur;
	if (yych == 'm') goto yy1921;
	goto yy1424;
yy1874:
	yych = *++cur;
	if (yych == 'b') goto yy1923;
	goto yy1424;
yy1875:
	yych = *++cur;
	if (yych == 'a') goto yy1924;
	goto yy1424;
yy1876:
	yych = *++cur;
	if (yych == 'b') goto yy1925;
	goto yy1424;
yy1877:
	yych = *++cur;
	if (yych == 'a') goto yy1926;
	goto yy1424;
yy1878:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1879;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1879;
		if (yych <= 'z') goto yy1423;
	}
yy1879:
#line 614 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_enum_elem); }
#line 9762 "src/parse/conf_lexer.cc"
yy1880:
	yych = *++cur;
	if (yych == 'n') goto yy1927;
	goto yy1424;
yy1881:
	yych = *++cur;
	if (yych == 'l') goto yy1928;
	goto yy1424;
yy1882:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1883;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1883;
		if (yych <= 'z') goto yy1423;
	}
yy1883:
#line 621 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_line_info); }
#line 9783 "src/parse/conf_lexer.cc"
yy1884:
	yych = *++cur;
	if (yych == '_') goto yy1929;
	goto yy1424;
yy1885:
	yych = *++cur;
	if (yych == 's') goto yy1930;
	goto yy1424;
yy1886:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1887;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1887;
		if (yych <= 'z') goto yy1423;
	}
yy1887:
#line 593 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_type_uint); }
#line 9804 "src/parse/conf_lexer.cc"
yy1888:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1889;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1889;
		if (yych <= 'z') goto yy1423;
	}
yy1889:
#line 594 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_type_yybm); }
#line 9817 "src/parse/conf_lexer.cc"
yy1890:
	yych = *++cur;
	if (yych == 'r') goto yy1931;
	goto yy1424;
yy1891:
	yych = *++cur;
	if (yych == 'l') goto yy1932;
	goto yy1424;
yy1892:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1893;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1893;
		if (yych <= 'z') goto yy1423;
	}
yy1893:
#line 585 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_var_local); }
#line 9838 "src/parse/conf_lexer.cc"
yy1894:
	yych = *++cur;
	if (yych == 'y') goto yy1934;
	goto yy1424;
yy1895:
	yych = *++cur;
	if (yych == 't') goto yy1935;
	goto yy1424;
yy1896:
	yych = *++cur;
	if (yych == 'e') goto yy1936;
	goto yy1424;
yy1897:
	yych = *++cur;
	if (yych == 'h') goto yy1937;
	goto yy1424;
yy1898:
	yych = *++cur;
	if (yych == 'g') goto yy1939;
	goto yy1424;
yy1899:
	yych = *++cur;
	if (yych == 'g') goto yy1941;
	goto yy1424;
yy1900:
	yych = *++cur;
	if (yych == 'p') goto yy1943;
	goto yy1424;
yy1901:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1902;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1902;
		if (yych <= 'z') goto yy1423;
	}
yy1902:
#line 649 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yygetcond); }
#line 9879 "src/parse/conf_lexer.cc"
yy1903:
	yych = *++cur;
	if (yych == 'e') goto yy1944;
	goto yy1424;
yy1904:
	yych = *++cur;
	if (yych == 'n') goto yy1946;
	goto yy1424;
yy1905:
	yych = *++cur;
	if (yych == 's') goto yy1948;
	goto yy1424;
yy1906:
	yych = *++cur;
	if (yych <= '`') {
		if (yych <= '9') {
			if (yych >= '0') goto yy1423;
		} else {
			if (yych == '_') goto yy1423;
		}
	} else {
		if (yych <= 's') {
			if (yych == 'c') goto yy1949;
			goto yy1423;
		} else {
			if (yych <= 't') goto yy1950;
			if (yych <= 'z') goto yy1423;
		}
	}
#line 628 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yyrestore); }
#line 9911 "src/parse/conf_lexer.cc"
yy1907:
	yych = *++cur;
	if (yych == 'p') goto yy1951;
	goto yy1424;
yy1908:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1909;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1909;
		if (yych <= 'z') goto yy1423;
	}
yy1909:
#line 650 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yysetcond); }
#line 9928 "src/parse/conf_lexer.cc"
yy1910:
	yych = *++cur;
	if (yych == 'e') goto yy1952;
	goto yy1424;
yy1911:
	yych = *++cur;
	if (yych == 'a') goto yy1954;
	goto yy1424;
yy1912:
	yych = *++cur;
	if (yych == 'a') goto yy1955;
	goto yy1424;
yy1913:
	yych = *++cur;
	if (yych == 'b') goto yy1956;
	if (yych == 'p') goto yy1957;
	goto yy1424;
yy1914:
	yych = *++cur;
	if (yych == 'f') goto yy1958;
	goto yy1144;
yy1915:
	yych = *++cur;
	if (yych == 't') goto yy1959;
	goto yy1144;
yy1916:
	yych = *++cur;
	if (yych == 'o') goto yy1960;
	goto yy1144;
yy1917:
	yych = *++cur;
	if (yych == 'p') goto yy1961;
	goto yy1144;
yy1918:
	yych = *++cur;
	if (yych == 'u') goto yy1962;
	goto yy1144;
yy1919:
	yych = *++cur;
	if (yych == 'n') goto yy1963;
	goto yy1144;
yy1920:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1143;
#line 768 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::STORABLE_STATE); }
#line 9975 "src/parse/conf_lexer.cc"
yy1921:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1922;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1922;
		if (yych <= 'z') goto yy1423;
	}
yy1922:
#line 591 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_array_elem); }
#line 9988 "src/parse/conf_lexer.cc"
yy1923:
	yych = *++cur;
	if (yych == 'a') goto yy1964;
	goto yy1424;
yy1924:
	yych = *++cur;
	if (yych == 'l') goto yy1965;
	goto yy1424;
yy1925:
	yych = *++cur;
	if (yych == 'a') goto yy1967;
	goto yy1424;
yy1926:
	yych = *++cur;
	if (yych == 'l') goto yy1968;
	goto yy1424;
yy1927:
	yych = *++cur;
	if (yych == 't') goto yy1970;
	goto yy1424;
yy1928:
	yych = *++cur;
	if (yych == 's') goto yy1972;
	goto yy1424;
yy1929:
	yych = *++cur;
	if (yych == 'f') goto yy1973;
	goto yy1424;
yy1930:
	yych = *++cur;
	if (yych == 'e') goto yy1974;
	goto yy1424;
yy1931:
	yych = *++cur;
	if (yych == 'g') goto yy1975;
	goto yy1424;
yy1932:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1933;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1933;
		if (yych <= 'z') goto yy1423;
	}
yy1933:
#line 586 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_var_global); }
#line 10037 "src/parse/conf_lexer.cc"
yy1934:
	yych = *++cur;
	if (yych == 'y') goto yy1976;
	goto yy1424;
yy1935:
	yych = *++cur;
	if (yych == 'x') goto yy1977;
	goto yy1424;
yy1936:
	yych = *++cur;
	if (yych == 'r') goto yy1979;
	goto yy1424;
yy1937:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1938;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1938;
		if (yych <= 'z') goto yy1423;
	}
yy1938:
#line 655 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yybm_match); }
#line 10062 "src/parse/conf_lexer.cc"
yy1939:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1940;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1940;
		if (yych <= 'z') goto yy1423;
	}
yy1940:
#line 638 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yycopymtag); }
#line 10075 "src/parse/conf_lexer.cc"
yy1941:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1942;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1942;
		if (yych <= 'z') goto yy1423;
	}
yy1942:
#line 639 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yycopystag); }
#line 10088 "src/parse/conf_lexer.cc"
yy1943:
	yych = *++cur;
	if (yych == 't') goto yy1981;
	goto yy1424;
yy1944:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1945;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1945;
		if (yych <= 'z') goto yy1423;
	}
yy1945:
#line 651 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yygetstate); }
#line 10105 "src/parse/conf_lexer.cc"
yy1946:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1947;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1947;
		if (yych <= 'z') goto yy1423;
	}
yy1947:
#line 653 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yylessthan); }
#line 10118 "src/parse/conf_lexer.cc"
yy1948:
	yych = *++cur;
	if (yych == 'k') goto yy1983;
	goto yy1424;
yy1949:
	yych = *++cur;
	if (yych == 't') goto yy1984;
	goto yy1424;
yy1950:
	yych = *++cur;
	if (yych == 'a') goto yy1985;
	goto yy1424;
yy1951:
	yych = *++cur;
	if (yych == 't') goto yy1986;
	goto yy1424;
yy1952:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1953;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1953;
		if (yych <= 'z') goto yy1423;
	}
yy1953:
#line 652 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yysetstate); }
#line 10147 "src/parse/conf_lexer.cc"
yy1954:
	yych = *++cur;
	if (yych == 'g') goto yy1988;
	goto yy1424;
yy1955:
	yych = *++cur;
	if (yych == 'g') goto yy1990;
	goto yy1424;
yy1956:
	yych = *++cur;
	if (yych == 'a') goto yy1992;
	goto yy1424;
yy1957:
	yych = *++cur;
	if (yych == 'e') goto yy1993;
	goto yy1424;
yy1958:
	yych = *++cur;
	if (yych == 'o') goto yy1994;
	goto yy1144;
yy1959:
	yych = *++cur;
	if (yych == 'i') goto yy1995;
	goto yy1144;
yy1960:
	yych = *++cur;
	if (yych == '_') goto yy1996;
	goto yy1144;
yy1961:
	yych = *++cur;
	if (yych == '_') goto yy1997;
	goto yy1144;
yy1962:
	yych = *++cur;
	if (yych == 'r') goto yy1998;
	goto yy1144;
yy1963:
	yych = *++cur;
	if (yych == 's') goto yy1999;
	goto yy1144;
yy1964:
	yych = *++cur;
	if (yych == 'l') goto yy2000;
	goto yy1424;
yy1965:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1966;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1966;
		if (yych <= 'z') goto yy1423;
	}
yy1966:
#line 589 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_array_local); }
#line 10204 "src/parse/conf_lexer.cc"
yy1967:
	yych = *++cur;
	if (yych == 'l') goto yy2002;
	goto yy1424;
yy1968:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1969;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1969;
		if (yych <= 'z') goto yy1423;
	}
yy1969:
#line 587 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_const_local); }
#line 10221 "src/parse/conf_lexer.cc"
yy1970:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1971;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1971;
		if (yych <= 'z') goto yy1423;
	}
yy1971:
#line 620 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_fingerprint); }
#line 10234 "src/parse/conf_lexer.cc"
yy1972:
	yych = *++cur;
	if (yych == 'e') goto yy2004;
	goto yy1424;
yy1973:
	yych = *++cur;
	if (yych == 'u') goto yy2006;
	goto yy1424;
yy1974:
	yych = *++cur;
	if (yych == '_') goto yy2007;
	if (yych == 's') goto yy2008;
	goto yy1424;
yy1975:
	yych = *++cur;
	if (yych == 'e') goto yy2010;
	goto yy1424;
yy1976:
	yych = *++cur;
	if (yych == 'p') goto yy2011;
	if (yych == 's') goto yy2012;
	goto yy1424;
yy1977:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1978;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1978;
		if (yych <= 'z') goto yy1423;
	}
yy1978:
#line 627 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yybackupctx); }
#line 10269 "src/parse/conf_lexer.cc"
yy1979:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1980;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1980;
		if (yych <= 'z') goto yy1423;
	}
yy1980:
#line 654 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yybm_filter); }
#line 10282 "src/parse/conf_lexer.cc"
yy1981:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1982;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1982;
		if (yych <= 'z') goto yy1423;
	}
yy1982:
#line 647 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yygetaccept); }
#line 10295 "src/parse/conf_lexer.cc"
yy1983:
	yych = *++cur;
	if (yych == 'i') goto yy2013;
	goto yy1424;
yy1984:
	yych = *++cur;
	if (yych == 'x') goto yy2014;
	goto yy1424;
yy1985:
	yych = *++cur;
	if (yych == 'g') goto yy2016;
	goto yy1424;
yy1986:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1987;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1987;
		if (yych <= 'z') goto yy1423;
	}
yy1987:
#line 648 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yysetaccept); }
#line 10320 "src/parse/conf_lexer.cc"
yy1988:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1989;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1989;
		if (yych <= 'z') goto yy1423;
	}
yy1989:
#line 632 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yyshiftmtag); }
#line 10333 "src/parse/conf_lexer.cc"
yy1990:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1991;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy1991;
		if (yych <= 'z') goto yy1423;
	}
yy1991:
#line 633 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yyshiftstag); }
#line 10346 "src/parse/conf_lexer.cc"
yy1992:
	yych = *++cur;
	if (yych == 'c') goto yy2018;
	goto yy1424;
yy1993:
	yych = *++cur;
	if (yych == 'e') goto yy2019;
	goto yy1424;
yy1994:
	yych = *++cur;
	if (yych == 'r') goto yy2020;
	goto yy1144;
yy1995:
	yych = *++cur;
	if (yych == 'o') goto yy2021;
	goto yy1144;
yy1996:
	yych = *++cur;
	if (yych == 'l') goto yy2022;
	goto yy1144;
yy1997:
	yych = *++cur;
	if (yych == 's') goto yy2023;
	goto yy1144;
yy1998:
	yych = *++cur;
	if (yych == 's') goto yy2024;
	goto yy1144;
yy1999:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1143;
#line 767 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::START_CONDITIONS); }
#line 10380 "src/parse/conf_lexer.cc"
yy2000:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2001;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy2001;
		if (yych <= 'z') goto yy1423;
	}
yy2001:
#line 590 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_array_global); }
#line 10393 "src/parse/conf_lexer.cc"
yy2002:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2003;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy2003;
		if (yych <= 'z') goto yy1423;
	}
yy2003:
#line 588 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_const_global); }
#line 10406 "src/parse/conf_lexer.cc"
yy2004:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2005;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych <= '_') goto yy2025;
		if (yych <= '`') goto yy2005;
		if (yych <= 'z') goto yy1423;
	}
yy2005:
#line 603 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_if_then_else); }
#line 10420 "src/parse/conf_lexer.cc"
yy2006:
	yych = *++cur;
	if (yych == 'n') goto yy2026;
	goto yy1424;
yy2007:
	yych = *++cur;
	if (yych == 'd') goto yy2027;
	if (yych == 'r') goto yy2028;
	goto yy1424;
yy2008:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2009;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych <= '_') goto yy2029;
		if (yych <= '`') goto yy2009;
		if (yych <= 'z') goto yy1423;
	}
yy2009:
#line 606 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_switch_cases); }
#line 10443 "src/parse/conf_lexer.cc"
yy2010:
	yych = *++cur;
	if (yych == 't') goto yy2030;
	goto yy1424;
yy2011:
	yych = *++cur;
	if (yych == 'e') goto yy2032;
	goto yy1424;
yy2012:
	yych = *++cur;
	if (yych == 'k') goto yy2033;
	goto yy1424;
yy2013:
	yych = *++cur;
	if (yych == 'p') goto yy2034;
	goto yy1424;
yy2014:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2015;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy2015;
		if (yych <= 'z') goto yy1423;
	}
yy2015:
#line 629 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yyrestorectx); }
#line 10472 "src/parse/conf_lexer.cc"
yy2016:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2017;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy2017;
		if (yych <= 'z') goto yy1423;
	}
yy2017:
#line 630 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yyrestoretag); }
#line 10485 "src/parse/conf_lexer.cc"
yy2018:
	yych = *++cur;
	if (yych == 'k') goto yy2036;
	goto yy1424;
yy2019:
	yych = *++cur;
	if (yych == 'k') goto yy2037;
	goto yy1424;
yy2020:
	yych = *++cur;
	if (yych == 'm') goto yy2039;
	goto yy1144;
yy2021:
	yych = *++cur;
	if (yych == 'n') goto yy2040;
	goto yy1144;
yy2022:
	yych = *++cur;
	if (yych == 'a') goto yy2041;
	goto yy1144;
yy2023:
	yych = *++cur;
	if (yych == 'w') goto yy2042;
	goto yy1144;
yy2024:
	yych = *++cur;
	if (yych == 'i') goto yy2043;
	goto yy1144;
yy2025:
	yych = *++cur;
	if (yych == 'o') goto yy2044;
	goto yy1424;
yy2026:
	yych = *++cur;
	if (yych == 'c') goto yy2045;
	goto yy1424;
yy2027:
	yych = *++cur;
	if (yych == 'e') goto yy2046;
	goto yy1424;
yy2028:
	yych = *++cur;
	if (yych == 'a') goto yy2047;
	goto yy1424;
yy2029:
	yych = *++cur;
	if (yych == 'o') goto yy2048;
	goto yy1424;
yy2030:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2031;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy2031;
		if (yych <= 'z') goto yy1423;
	}
yy2031:
#line 595 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_type_yytarget); }
#line 10546 "src/parse/conf_lexer.cc"
yy2032:
	yych = *++cur;
	if (yych == 'e') goto yy2049;
	goto yy1424;
yy2033:
	yych = *++cur;
	if (yych == 'i') goto yy2050;
	goto yy1424;
yy2034:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2035;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy2035;
		if (yych <= 'z') goto yy1423;
	}
yy2035:
#line 641 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yypeek_yyskip); }
#line 10567 "src/parse/conf_lexer.cc"
yy2036:
	yych = *++cur;
	if (yych == 'u') goto yy2051;
	goto yy1424;
yy2037:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2038;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy2038;
		if (yych <= 'z') goto yy1423;
	}
yy2038:
#line 640 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yyskip_yypeek); }
#line 10584 "src/parse/conf_lexer.cc"
yy2039:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1143;
#line 766 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::API_STYLE_FREEFORM); }
#line 10590 "src/parse/conf_lexer.cc"
yy2040:
	yych = *++cur;
	if (yych == 's') goto yy2052;
	goto yy1144;
yy2041:
	yych = *++cur;
	if (yych == 'b') goto yy2053;
	goto yy1144;
yy2042:
	yych = *++cur;
	if (yych == 'i') goto yy2054;
	goto yy1144;
yy2043:
	yych = *++cur;
	if (yych == 'v') goto yy2055;
	goto yy1144;
yy2044:
	yych = *++cur;
	if (yych == 'n') goto yy2056;
	goto yy1424;
yy2045:
	yych = *++cur;
	if (yych == 't') goto yy2057;
	goto yy1424;
yy2046:
	yych = *++cur;
	if (yych == 'f') goto yy2058;
	goto yy1424;
yy2047:
	yych = *++cur;
	if (yych == 'n') goto yy2059;
	goto yy1424;
yy2048:
	yych = *++cur;
	if (yych == 'n') goto yy2060;
	goto yy1424;
yy2049:
	yych = *++cur;
	if (yych == 'k') goto yy2061;
	goto yy1424;
yy2050:
	yych = *++cur;
	if (yych == 'p') goto yy2063;
	goto yy1424;
yy2051:
	yych = *++cur;
	if (yych == 'p') goto yy2065;
	goto yy1424;
yy2052:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1143;
#line 765 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::API_STYLE_FUNCTIONS); }
#line 10644 "src/parse/conf_lexer.cc"
yy2053:
	yych = *++cur;
	if (yych == 'e') goto yy2067;
	goto yy1144;
yy2054:
	yych = *++cur;
	if (yych == 't') goto yy2068;
	goto yy1144;
yy2055:
	yych = *++cur;
	if (yych == 'e') goto yy2069;
	goto yy1144;
yy2056:
	yych = *++cur;
	if (yych == 'e') goto yy2070;
	goto yy1424;
yy2057:
	yych = *++cur;
	if (yych == 'i') goto yy2071;
	goto yy1424;
yy2058:
	yych = *++cur;
	if (yych == 'a') goto yy2072;
	goto yy1424;
yy2059:
	yych = *++cur;
	if (yych == 'g') goto yy2073;
	goto yy1424;
yy2060:
	yych = *++cur;
	if (yych == 'e') goto yy2074;
	goto yy1424;
yy2061:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2062;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych <= '_') goto yy2075;
		if (yych <= '`') goto yy2062;
		if (yych <= 'z') goto yy1423;
	}
yy2062:
#line 644 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yybackup_yypeek); }
#line 10690 "src/parse/conf_lexer.cc"
yy2063:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2064;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy2064;
		if (yych <= 'z') goto yy1423;
	}
yy2064:
#line 643 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yybackup_yyskip); }
#line 10703 "src/parse/conf_lexer.cc"
yy2065:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2066;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych <= '_') goto yy2076;
		if (yych <= '`') goto yy2066;
		if (yych <= 'z') goto yy1423;
	}
yy2066:
#line 642 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yyskip_yybackup); }
#line 10717 "src/parse/conf_lexer.cc"
yy2067:
	yych = *++cur;
	if (yych == 'l') goto yy2077;
	goto yy1144;
yy2068:
	yych = *++cur;
	if (yych == 'c') goto yy2078;
	goto yy1144;
yy2069:
	yych = *++cur;
	if (yych == '_') goto yy2079;
	goto yy1144;
yy2070:
	yych = *++cur;
	if (yych == 'l') goto yy2080;
	goto yy1424;
yy2071:
	yych = *++cur;
	if (yych == 'o') goto yy2081;
	goto yy1424;
yy2072:
	yych = *++cur;
	if (yych == 'u') goto yy2082;
	goto yy1424;
yy2073:
	yych = *++cur;
	if (yych == 'e') goto yy2083;
	goto yy1424;
yy2074:
	yych = *++cur;
	if (yych == 'l') goto yy2085;
	goto yy1424;
yy2075:
	yych = *++cur;
	if (yych == 'y') goto yy2086;
	goto yy1424;
yy2076:
	yych = *++cur;
	if (yych == 'y') goto yy2087;
	goto yy1424;
yy2077:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1143;
#line 750 "../src/parse/conf_lexer.re"
	{ RET_COND(globopts->code_model == CodeModel::GOTO_LABEL); }
#line 10763 "src/parse/conf_lexer.cc"
yy2078:
	yych = *++cur;
	if (yych == 'h') goto yy2088;
	goto yy1144;
yy2079:
	yych = *++cur;
	if (yych == 'f') goto yy2089;
	goto yy1144;
yy2080:
	yych = *++cur;
	if (yych == 'i') goto yy2090;
	goto yy1424;
yy2081:
	yych = *++cur;
	if (yych == 'n') goto yy2091;
	goto yy1424;
yy2082:
	yych = *++cur;
	if (yych == 'l') goto yy2092;
	goto yy1424;
yy2083:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2084;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy2084;
		if (yych <= 'z') goto yy1423;
	}
yy2084:
#line 608 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_switch_case_range); }
#line 10796 "src/parse/conf_lexer.cc"
yy2085:
	yych = *++cur;
	if (yych == 'i') goto yy2093;
	goto yy1424;
yy2086:
	yych = *++cur;
	if (yych == 'y') goto yy2094;
	goto yy1424;
yy2087:
	yych = *++cur;
	if (yych == 'y') goto yy2095;
	goto yy1424;
yy2088:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1143;
#line 751 "../src/parse/conf_lexer.re"
	{ RET_COND(globopts->code_model == CodeModel::LOOP_SWITCH); }
#line 10814 "src/parse/conf_lexer.cc"
yy2089:
	yych = *++cur;
	if (yych == 'u') goto yy2096;
	goto yy1144;
yy2090:
	yych = *++cur;
	if (yych == 'n') goto yy2097;
	goto yy1424;
yy2091:
	yych = *++cur;
	if (yych == 's') goto yy2098;
	goto yy1424;
yy2092:
	yych = *++cur;
	if (yych == 't') goto yy2100;
	goto yy1424;
yy2093:
	yych = *++cur;
	if (yych == 'n') goto yy2102;
	goto yy1424;
yy2094:
	yych = *++cur;
	if (yych == 's') goto yy2103;
	goto yy1424;
yy2095:
	yych = *++cur;
	if (yych == 'p') goto yy2104;
	goto yy1424;
yy2096:
	yych = *++cur;
	if (yych == 'n') goto yy2105;
	goto yy1144;
yy2097:
	yych = *++cur;
	if (yych == 'e') goto yy2106;
	goto yy1424;
yy2098:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2099;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy2099;
		if (yych <= 'z') goto yy1423;
	}
yy2099:
#line 619 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_recursive_functions); }
#line 10863 "src/parse/conf_lexer.cc"
yy2100:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2101;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy2101;
		if (yych <= 'z') goto yy1423;
	}
yy2101:
#line 609 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_switch_case_default); }
#line 10876 "src/parse/conf_lexer.cc"
yy2102:
	yych = *++cur;
	if (yych == 'e') goto yy2108;
	goto yy1424;
yy2103:
	yych = *++cur;
	if (yych == 'k') goto yy2110;
	goto yy1424;
yy2104:
	yych = *++cur;
	if (yych == 'e') goto yy2111;
	goto yy1424;
yy2105:
	yych = *++cur;
	if (yych == 'c') goto yy2112;
	goto yy1144;
yy2106:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2107;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy2107;
		if (yych <= 'z') goto yy1423;
	}
yy2107:
#line 604 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_if_then_else_oneline); }
#line 10905 "src/parse/conf_lexer.cc"
yy2108:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2109;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy2109;
		if (yych <= 'z') goto yy1423;
	}
yy2109:
#line 607 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_switch_cases_oneline); }
#line 10918 "src/parse/conf_lexer.cc"
yy2110:
	yych = *++cur;
	if (yych == 'i') goto yy2113;
	goto yy1424;
yy2111:
	yych = *++cur;
	if (yych == 'e') goto yy2114;
	goto yy1424;
yy2112:
	yych = *++cur;
	if (yych == 't') goto yy2115;
	goto yy1144;
yy2113:
	yych = *++cur;
	if (yych == 'p') goto yy2116;
	goto yy1424;
yy2114:
	yych = *++cur;
	if (yych == 'k') goto yy2118;
	goto yy1424;
yy2115:
	yych = *++cur;
	if (yych == 'i') goto yy2120;
	goto yy1144;
yy2116:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2117;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy2117;
		if (yych <= 'z') goto yy1423;
	}
yy2117:
#line 646 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yybackup_yypeek_yyskip); }
#line 10955 "src/parse/conf_lexer.cc"
yy2118:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2119;
		if (yych <= '9') goto yy1423;
	} else {
		if (yych == '`') goto yy2119;
		if (yych <= 'z') goto yy1423;
	}
yy2119:
#line 645 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yyskip_yybackup_yypeek); }
#line 10968 "src/parse/conf_lexer.cc"
yy2120:
	yych = *++cur;
	if (yych != 'o') goto yy1144;
	yych = *++cur;
	if (yych != 'n') goto yy1144;
	yych = *++cur;
	if (yych != 's') goto yy1144;
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1143;
#line 752 "../src/parse/conf_lexer.re"
	{ RET_COND(globopts->code_model == CodeModel::REC_FUNC); }
#line 10980 "src/parse/conf_lexer.cc"
}
#line 799 "../src/parse/conf_lexer.re"


    UNREACHABLE();
    return Ret::FAIL; // unreachable
}

#undef RET_TOK
#undef RET_OPT
#undef RET_GOPT
#undef RET_LOPT
#undef RET_VAR
#undef RET_CODE

#define SAVE_CONF_BOOL(conf) do { \
    CHECK_RET(lex_conf_bool(opts)); \
    opts.set_##conf(tmp_bool); \
    goto start; \
} while(0)

#define SAVE_CONF_LIST(conf) do { \
    CHECK_RET(lex_conf_list(opts)); \
    opts.set_##conf(tmp_list); \
    CHECK_RET(opts.check_##conf()); \
    tmp_list.clear(); \
    goto start; \
} while(0)

Ret Input::lex_syntax_file(Opt& opts) {
start:
    tok = cur;
    location = cur_loc();

#line 11015 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	static const unsigned char yybm[256] = {
		  0, 128, 128, 128, 128, 128, 128, 128,
		128, 192,   0, 128, 128, 192, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		192, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128
	};
	if ((lim - cur) < 23) YYFILL(23);
	yych = *cur;
	if (yybm[0+yych] & 64) goto yy2125;
	if (yych <= 'c') {
		if (yych <= '.') {
			if (yych <= 0x00) goto yy2122;
			if (yych <= 0x08) goto yy2123;
			if (yych <= '\n') goto yy2126;
			goto yy2123;
		} else {
			if (yych <= '/') goto yy2127;
			if (yych <= 'a') goto yy2123;
			if (yych <= 'b') goto yy2128;
			goto yy2129;
		}
	} else {
		if (yych <= 'r') {
			if (yych == 'i') goto yy2130;
			if (yych <= 'q') goto yy2123;
			goto yy2131;
		} else {
			if (yych <= 's') goto yy2132;
			if (yych == 'w') goto yy2133;
			goto yy2123;
		}
	}
yy2122:
	++cur;
#line 831 "../src/parse/conf_lexer.re"
	{ return Ret::OK; }
#line 11082 "src/parse/conf_lexer.cc"
yy2123:
	++cur;
yy2124:
#line 854 "../src/parse/conf_lexer.re"
	{ RET_FAIL(error_at_tok("unexpected character: '%c'", cur[-1])); }
#line 11088 "src/parse/conf_lexer.cc"
yy2125:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yybm[0+yych] & 64) goto yy2125;
#line 835 "../src/parse/conf_lexer.re"
	{ goto start; }
#line 11096 "src/parse/conf_lexer.cc"
yy2126:
	++cur;
#line 833 "../src/parse/conf_lexer.re"
	{ next_line(); goto start; }
#line 11101 "src/parse/conf_lexer.cc"
yy2127:
	yych = *(mar = ++cur);
	if (yych == '/') goto yy2134;
	goto yy2124;
yy2128:
	yych = *(mar = ++cur);
	if (yych == 'a') goto yy2136;
	goto yy2124;
yy2129:
	yych = *(mar = ++cur);
	if (yych == 'o') goto yy2137;
	goto yy2124;
yy2130:
	yych = *(mar = ++cur);
	if (yych == 'n') goto yy2138;
	goto yy2124;
yy2131:
	yych = *(mar = ++cur);
	if (yych == 'e') goto yy2139;
	goto yy2124;
yy2132:
	yych = *(mar = ++cur);
	if (yych <= 'h') {
		if (yych == 'e') goto yy2140;
		goto yy2124;
	} else {
		if (yych <= 'i') goto yy2141;
		if (yych == 'u') goto yy2142;
		goto yy2124;
	}
yy2133:
	yych = *(mar = ++cur);
	if (yych == 'r') goto yy2143;
	goto yy2124;
yy2134:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yybm[0+yych] & 128) goto yy2134;
	if (yych >= 0x01) goto yy2126;
yy2135:
	cur = mar;
	goto yy2124;
yy2136:
	yych = *++cur;
	if (yych == 'c') goto yy2144;
	goto yy2135;
yy2137:
	yych = *++cur;
	if (yych == 'd') goto yy2145;
	goto yy2135;
yy2138:
	yych = *++cur;
	if (yych == 'd') goto yy2146;
	goto yy2135;
yy2139:
	yych = *++cur;
	if (yych == '2') goto yy2147;
	goto yy2135;
yy2140:
	yych = *++cur;
	if (yych == 'm') goto yy2148;
	goto yy2135;
yy2141:
	yych = *++cur;
	if (yych == 'n') goto yy2149;
	goto yy2135;
yy2142:
	yych = *++cur;
	if (yych == 'p') goto yy2150;
	goto yy2135;
yy2143:
	yych = *++cur;
	if (yych == 'a') goto yy2151;
	goto yy2135;
yy2144:
	yych = *++cur;
	if (yych == 'k') goto yy2152;
	goto yy2135;
yy2145:
	yych = *++cur;
	if (yych == 'e') goto yy2153;
	goto yy2135;
yy2146:
	yych = *++cur;
	if (yych == 'e') goto yy2154;
	goto yy2135;
yy2147:
	yych = *++cur;
	if (yych == 'c') goto yy2155;
	goto yy2135;
yy2148:
	yych = *++cur;
	if (yych == 'i') goto yy2156;
	goto yy2135;
yy2149:
	yych = *++cur;
	if (yych == 'g') goto yy2157;
	goto yy2135;
yy2150:
	yych = *++cur;
	if (yych == 'p') goto yy2158;
	goto yy2135;
yy2151:
	yych = *++cur;
	if (yych == 'p') goto yy2159;
	goto yy2135;
yy2152:
	yych = *++cur;
	if (yych == 't') goto yy2160;
	goto yy2135;
yy2153:
	yych = *++cur;
	if (yych == ':') goto yy2161;
	goto yy2135;
yy2154:
	yych = *++cur;
	if (yych == 'n') goto yy2162;
	goto yy2135;
yy2155:
	yych = *++cur;
	if (yych == ':') goto yy2163;
	goto yy2135;
yy2156:
	yych = *++cur;
	if (yych == 'c') goto yy2164;
	goto yy2135;
yy2157:
	yych = *++cur;
	if (yych == 'l') goto yy2165;
	goto yy2135;
yy2158:
	yych = *++cur;
	if (yych == 'o') goto yy2166;
	goto yy2135;
yy2159:
	yych = *++cur;
	if (yych == '_') goto yy2167;
	goto yy2135;
yy2160:
	yych = *++cur;
	if (yych == 'i') goto yy2168;
	goto yy2135;
yy2161:
	++cur;
	cur -= 5;
#line 839 "../src/parse/conf_lexer.re"
	{ if (conf_parse(*this, opts) != 0) return Ret::FAIL; goto start; }
#line 11250 "src/parse/conf_lexer.cc"
yy2162:
	yych = *++cur;
	if (yych == 't') goto yy2169;
	goto yy2135;
yy2163:
	++cur;
#line 837 "../src/parse/conf_lexer.re"
	{ CHECK_RET(lex_conf(opts)); goto start; }
#line 11259 "src/parse/conf_lexer.cc"
yy2164:
	yych = *++cur;
	if (yych == 'o') goto yy2170;
	goto yy2135;
yy2165:
	yych = *++cur;
	if (yych == 'e') goto yy2171;
	goto yy2135;
yy2166:
	yych = *++cur;
	if (yych == 'r') goto yy2172;
	goto yy2135;
yy2167:
	yych = *++cur;
	if (yych == 'b') goto yy2173;
	goto yy2135;
yy2168:
	yych = *++cur;
	if (yych == 'c') goto yy2174;
	goto yy2135;
yy2169:
	yych = *++cur;
	if (yych == 'a') goto yy2175;
	goto yy2135;
yy2170:
	yych = *++cur;
	if (yych == 'l') goto yy2176;
	goto yy2135;
yy2171:
	yych = *++cur;
	if (yych == '_') goto yy2177;
	goto yy2135;
yy2172:
	yych = *++cur;
	if (yych == 't') goto yy2178;
	goto yy2135;
yy2173:
	yych = *++cur;
	if (yych == 'l') goto yy2179;
	goto yy2135;
yy2174:
	yych = *++cur;
	if (yych == 'k') goto yy2180;
	goto yy2135;
yy2175:
	yych = *++cur;
	if (yych == 't') goto yy2181;
	goto yy2135;
yy2176:
	yych = *++cur;
	if (yych == 'o') goto yy2182;
	goto yy2135;
yy2177:
	yych = *++cur;
	if (yych == 'q') goto yy2183;
	goto yy2135;
yy2178:
	yych = *++cur;
	if (yych == 'e') goto yy2184;
	goto yy2135;
yy2179:
	yych = *++cur;
	if (yych == 'o') goto yy2185;
	goto yy2135;
yy2180:
	yych = *++cur;
	if (yych == '_') goto yy2186;
	goto yy2135;
yy2181:
	yych = *++cur;
	if (yych == 'i') goto yy2187;
	goto yy2135;
yy2182:
	yych = *++cur;
	if (yych == 'n') goto yy2188;
	goto yy2135;
yy2183:
	yych = *++cur;
	if (yych == 'u') goto yy2189;
	goto yy2135;
yy2184:
	yych = *++cur;
	if (yych == 'd') goto yy2190;
	goto yy2135;
yy2185:
	yych = *++cur;
	if (yych == 'c') goto yy2191;
	goto yy2135;
yy2186:
	yych = *++cur;
	if (yych == 'q') goto yy2192;
	goto yy2135;
yy2187:
	yych = *++cur;
	if (yych == 'o') goto yy2193;
	goto yy2135;
yy2188:
	yych = *++cur;
	if (yych == 's') goto yy2194;
	goto yy2135;
yy2189:
	yych = *++cur;
	if (yych == 'o') goto yy2195;
	goto yy2135;
yy2190:
	yych = *++cur;
	if (yych == '_') goto yy2196;
	goto yy2135;
yy2191:
	yych = *++cur;
	if (yych == 'k') goto yy2197;
	goto yy2135;
yy2192:
	yych = *++cur;
	if (yych == 'u') goto yy2198;
	goto yy2135;
yy2193:
	yych = *++cur;
	if (yych == 'n') goto yy2199;
	goto yy2135;
yy2194:
	++cur;
#line 847 "../src/parse/conf_lexer.re"
	{ SAVE_CONF_BOOL(semicolons); }
#line 11384 "src/parse/conf_lexer.cc"
yy2195:
	yych = *++cur;
	if (yych == 't') goto yy2200;
	goto yy2135;
yy2196:
	yych = *++cur;
	switch (yych) {
		case 'a': goto yy2201;
		case 'c': goto yy2202;
		case 'f': goto yy2203;
		case 't': goto yy2204;
		default: goto yy2135;
	}
yy2197:
	yych = *++cur;
	if (yych == 's') goto yy2205;
	goto yy2135;
yy2198:
	yych = *++cur;
	if (yych == 'o') goto yy2206;
	goto yy2135;
yy2199:
	yych = *++cur;
	if (yych == '_') goto yy2207;
	goto yy2135;
yy2200:
	yych = *++cur;
	if (yych == 'e') goto yy2208;
	goto yy2135;
yy2201:
	yych = *++cur;
	if (yych == 'p') goto yy2209;
	goto yy2135;
yy2202:
	yych = *++cur;
	if (yych == 'o') goto yy2210;
	goto yy2135;
yy2203:
	yych = *++cur;
	if (yych == 'e') goto yy2211;
	goto yy2135;
yy2204:
	yych = *++cur;
	if (yych == 'a') goto yy2212;
	goto yy2135;
yy2205:
	yych = *++cur;
	if (yych == '_') goto yy2213;
	goto yy2135;
yy2206:
	yych = *++cur;
	if (yych == 't') goto yy2214;
	goto yy2135;
yy2207:
	yych = *++cur;
	if (yych == 's') goto yy2215;
	goto yy2135;
yy2208:
	yych = *++cur;
	if (yych == 'd') goto yy2216;
	goto yy2135;
yy2209:
	yych = *++cur;
	if (yych == 'i') goto yy2217;
	goto yy2135;
yy2210:
	yych = *++cur;
	if (yych == 'd') goto yy2218;
	goto yy2135;
yy2211:
	yych = *++cur;
	if (yych == 'a') goto yy2219;
	goto yy2135;
yy2212:
	yych = *++cur;
	if (yych == 'r') goto yy2220;
	goto yy2135;
yy2213:
	yych = *++cur;
	if (yych == 'i') goto yy2221;
	goto yy2135;
yy2214:
	yych = *++cur;
	if (yych == 'e') goto yy2222;
	goto yy2135;
yy2215:
	yych = *++cur;
	if (yych == 'e') goto yy2223;
	goto yy2135;
yy2216:
	yych = *++cur;
	if (yych == '_') goto yy2224;
	goto yy2135;
yy2217:
	yych = *++cur;
	if (yych == '_') goto yy2225;
	if (yych == 's') goto yy2226;
	goto yy2135;
yy2218:
	yych = *++cur;
	if (yych == 'e') goto yy2227;
	goto yy2135;
yy2219:
	yych = *++cur;
	if (yych == 't') goto yy2228;
	goto yy2135;
yy2220:
	yych = *++cur;
	if (yych == 'g') goto yy2229;
	goto yy2135;
yy2221:
	yych = *++cur;
	if (yych == 'n') goto yy2230;
	goto yy2135;
yy2222:
	yych = *++cur;
	if (yych == 'd') goto yy2231;
	goto yy2135;
yy2223:
	yych = *++cur;
	if (yych == 'n') goto yy2232;
	goto yy2135;
yy2224:
	yych = *++cur;
	if (yych == 's') goto yy2233;
	goto yy2135;
yy2225:
	yych = *++cur;
	if (yych == 's') goto yy2234;
	goto yy2135;
yy2226:
	++cur;
#line 841 "../src/parse/conf_lexer.re"
	{ SAVE_CONF_LIST(supported_apis); }
#line 11519 "src/parse/conf_lexer.cc"
yy2227:
	yych = *++cur;
	if (yych == '_') goto yy2235;
	goto yy2135;
yy2228:
	yych = *++cur;
	if (yych == 'u') goto yy2236;
	goto yy2135;
yy2229:
	yych = *++cur;
	if (yych == 'e') goto yy2237;
	goto yy2135;
yy2230:
	yych = *++cur;
	if (yych == '_') goto yy2238;
	goto yy2135;
yy2231:
	yych = *++cur;
	if (yych == '_') goto yy2239;
	goto yy2135;
yy2232:
	yych = *++cur;
	if (yych == 's') goto yy2240;
	goto yy2135;
yy2233:
	yych = *++cur;
	if (yych == 't') goto yy2241;
	goto yy2135;
yy2234:
	yych = *++cur;
	if (yych == 't') goto yy2242;
	goto yy2135;
yy2235:
	yych = *++cur;
	if (yych == 'm') goto yy2243;
	goto yy2135;
yy2236:
	yych = *++cur;
	if (yych == 'r') goto yy2244;
	goto yy2135;
yy2237:
	yych = *++cur;
	if (yych == 't') goto yy2245;
	goto yy2135;
yy2238:
	yych = *++cur;
	if (yych == 'b') goto yy2246;
	goto yy2135;
yy2239:
	yych = *++cur;
	if (yych == 's') goto yy2247;
	goto yy2135;
yy2240:
	yych = *++cur;
	if (yych == 'i') goto yy2248;
	goto yy2135;
yy2241:
	yych = *++cur;
	if (yych == 'r') goto yy2249;
	goto yy2135;
yy2242:
	yych = *++cur;
	if (yych == 'y') goto yy2250;
	goto yy2135;
yy2243:
	yych = *++cur;
	if (yych == 'o') goto yy2251;
	goto yy2135;
yy2244:
	yych = *++cur;
	if (yych == 'e') goto yy2252;
	goto yy2135;
yy2245:
	yych = *++cur;
	if (yych == 's') goto yy2253;
	goto yy2135;
yy2246:
	yych = *++cur;
	if (yych == 'r') goto yy2254;
	goto yy2135;
yy2247:
	yych = *++cur;
	if (yych == 't') goto yy2255;
	goto yy2135;
yy2248:
	yych = *++cur;
	if (yych == 't') goto yy2256;
	goto yy2135;
yy2249:
	yych = *++cur;
	if (yych == 'i') goto yy2257;
	goto yy2135;
yy2250:
	yych = *++cur;
	if (yych == 'l') goto yy2258;
	goto yy2135;
yy2251:
	yych = *++cur;
	if (yych == 'd') goto yy2259;
	goto yy2135;
yy2252:
	yych = *++cur;
	if (yych == 's') goto yy2260;
	goto yy2135;
yy2253:
	++cur;
#line 844 "../src/parse/conf_lexer.re"
	{ SAVE_CONF_LIST(supported_targets); }
#line 11628 "src/parse/conf_lexer.cc"
yy2254:
	yych = *++cur;
	if (yych == 'a') goto yy2261;
	goto yy2135;
yy2255:
	yych = *++cur;
	if (yych == 'r') goto yy2262;
	goto yy2135;
yy2256:
	yych = *++cur;
	if (yych == 'i') goto yy2263;
	goto yy2135;
yy2257:
	yych = *++cur;
	if (yych == 'n') goto yy2264;
	goto yy2135;
yy2258:
	yych = *++cur;
	if (yych == 'e') goto yy2265;
	goto yy2135;
yy2259:
	yych = *++cur;
	if (yych == 'e') goto yy2266;
	goto yy2135;
yy2260:
	++cur;
#line 845 "../src/parse/conf_lexer.re"
	{ SAVE_CONF_LIST(supported_features); }
#line 11657 "src/parse/conf_lexer.cc"
yy2261:
	yych = *++cur;
	if (yych == 'c') goto yy2267;
	goto yy2135;
yy2262:
	yych = *++cur;
	if (yych == 'i') goto yy2268;
	goto yy2135;
yy2263:
	yych = *++cur;
	if (yych == 'v') goto yy2269;
	goto yy2135;
yy2264:
	yych = *++cur;
	if (yych == 'g') goto yy2270;
	goto yy2135;
yy2265:
	yych = *++cur;
	if (yych == 's') goto yy2271;
	goto yy2135;
yy2266:
	yych = *++cur;
	if (yych == 'l') goto yy2272;
	goto yy2135;
yy2267:
	yych = *++cur;
	if (yych == 'e') goto yy2273;
	goto yy2135;
yy2268:
	yych = *++cur;
	if (yych == 'n') goto yy2274;
	goto yy2135;
yy2269:
	yych = *++cur;
	if (yych == 'e') goto yy2275;
	goto yy2135;
yy2270:
	yych = *++cur;
	if (yych == 's') goto yy2276;
	goto yy2135;
yy2271:
	++cur;
#line 842 "../src/parse/conf_lexer.re"
	{ SAVE_CONF_LIST(supported_api_styles); }
#line 11702 "src/parse/conf_lexer.cc"
yy2272:
	yych = *++cur;
	if (yych == 's') goto yy2277;
	goto yy2135;
yy2273:
	yych = *++cur;
	if (yych == 's') goto yy2278;
	goto yy2135;
yy2274:
	yych = *++cur;
	if (yych == 'g') goto yy2279;
	goto yy2135;
yy2275:
	++cur;
#line 850 "../src/parse/conf_lexer.re"
	{ SAVE_CONF_BOOL(indentation_sensitive); }
#line 11719 "src/parse/conf_lexer.cc"
yy2276:
	++cur;
#line 849 "../src/parse/conf_lexer.re"
	{ SAVE_CONF_BOOL(single_quoted_strings); }
#line 11724 "src/parse/conf_lexer.cc"
yy2277:
	++cur;
#line 843 "../src/parse/conf_lexer.re"
	{ SAVE_CONF_LIST(supported_code_models); }
#line 11729 "src/parse/conf_lexer.cc"
yy2278:
	++cur;
#line 851 "../src/parse/conf_lexer.re"
	{ SAVE_CONF_BOOL(wrap_blocks_in_braces); }
#line 11734 "src/parse/conf_lexer.cc"
yy2279:
	yych = *++cur;
	if (yych != 's') goto yy2135;
	++cur;
#line 848 "../src/parse/conf_lexer.re"
	{ SAVE_CONF_BOOL(backtick_quoted_strings); }
#line 11741 "src/parse/conf_lexer.cc"
}
#line 855 "../src/parse/conf_lexer.re"


    UNREACHABLE();
    return Ret::FAIL;
}

#undef SAVE_CONF_BOOL
#undef SAVE_CONF_LIST

#undef YYFILL

} // namespace re2c
