/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import java.util.regex.Pattern;
import org.odftoolkit.odfdom.type.OdfDataType;

public class CellRangeAddress
implements OdfDataType {
    private String mCellRangeAddress;
    private static final Pattern cellRangeAddressPattern1 = Pattern.compile("^(\\$?([^\\. ']+|'([^']|'')+'))?\\.\\$?[A-Z]+\\$?[0-9]+(:(\\$?([^\\. ']+|'([^']|'')+'))?\\.\\$?[A-Z]+\\$?[0-9]+)?$");
    private static final Pattern cellRangeAddressPattern2 = Pattern.compile("^(\\$?([^\\. ']+|'([^']|'')+'))?\\.\\$?[0-9]+:(\\$?([^\\. ']+|'([^']|'')+'))?\\.\\$?[0-9]+$");
    private static final Pattern cellRangeAddressPattern3 = Pattern.compile("^(\\$?([^\\. ']+|'([^']|'')+'))?\\.\\$?[A-Z]+:(\\$?([^\\. ']+|'([^']|'')+'))?\\.\\$?[A-Z]+$");

    public CellRangeAddress(String cellRangeAddress) throws IllegalArgumentException {
        if (!CellRangeAddress.isValid(cellRangeAddress)) {
            throw new IllegalArgumentException("parameter is invalid for datatype CellRangeAddress");
        }
        this.mCellRangeAddress = cellRangeAddress;
    }

    public String toString() {
        return this.mCellRangeAddress;
    }

    public static CellRangeAddress valueOf(String stringValue) throws IllegalArgumentException {
        return new CellRangeAddress(stringValue);
    }

    public static boolean isValid(String stringValue) {
        return stringValue != null && (cellRangeAddressPattern1.matcher(stringValue).matches() || cellRangeAddressPattern2.matcher(stringValue).matches() || cellRangeAddressPattern3.matcher(stringValue).matches());
    }
}

