#!/bin/sh -e

# called by uscan with '--upstream-version' <version> <file>
VERSION=$2
DIR=ivy-$VERSION.orig
TAR=../ivy_${VERSION}.orig.tar.xz

# clean up the upstream tarball
tar -z -x -f $3
mv apache-ivy* $DIR
XZ_OPT=--best tar -c -J -v -f $TAR --exclude '*/test*' --exclude '*/doc*' $DIR
rm -rf $DIR $3

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $3 $origDir
  echo "moved $3 to $origDir"
fi
