.\"
.\" "$Id: cupsctl.man 12854 2015-08-28 14:08:00Z msweet $"
.\"
.\" cupsctl man page for CUPS.
.\"
.\" Copyright 2007-2014 by Apple Inc.
.\" Copyright 2007 by Easy Software Products.
.\"
.\" These coded instructions, statements, and computer programs are the
.\" property of Apple Inc. and are protected by Federal copyright
.\" law.  Distribution and use rights are outlined in the file "LICENSE.txt"
.\" which should have been included with this file.  If this file is
.\" file is missing or damaged, see the license at "http://www.cups.org/".
.\"
.TH cupsctl 8 "CUPS" "11 June 2014" "Apple Inc."
.SH NAME
cupsctl \- configure cupsd.conf options
.SH SYNOPSIS
.B cupsctl
[
.B \-E
] [
.B \-U
.I username
] [
.B \-h
\fIserver\fR[\fB:\fIport\fR]
] [
\fB\-\-\fR[\fBno\-\fR]\fBdebug\-logging\fR
] [
\fB\-\-\fR[\fBno\-\fR]\fBremote\-admin\fR
] [
\fB\-\-\fR[\fBno\-\fR]\fBremote\-any\fR
] [
\fB\-\-\fR[\fBno\-\fR]\fBshare\-printers\fR
] [
\fB\-\-\fR[\fBno\-\fR]\fBuser\-cancel\-any\fR
] [
.I name=value
]
.SH DESCRIPTION
\fBcupsctl\fR updates or queries the \fIcupsd.conf\fR file for a server. When
no changes are requested, the current configuration values are written to the
standard output in the format "name=value", one per line.
.SH OPTIONS
The following options are recognized:
.TP 5
.B \-E
Enables encryption on the connection to the scheduler.
.TP 5
\fB\-U \fIusername\fR
Specifies an alternate username to use when authenticating with the scheduler.
.TP 5
\fB\-h \fIserver\fR[\fB:\fIport\fR]
Specifies the server address.
.TP 5
.B \-\-\fR[\fBno\-\fR]\fBdebug\-logging
Enables (disables) debug logging to the \fIerror_log\fR file.
.TP 5
.B \-\-\fR[\fBno\-\fR]\fBremote\-admin
Enables (disables) remote administration.
.TP 5
.B \-\-\fR[\fBno\-\fR]\fBremote\-any
Enables (disables) printing from any address, e.g., the Internet.
.TP 5
.B \-\-\fR[\fBno\-\fR]\fBshare\-printers
Enables (disables) sharing of local printers with other computers.
.TP 5
.B \-\-\fR[\fBno\-\fR]\fBuser\-cancel\-any
Allows (prevents) users to cancel jobs owned by others.
.SH EXAMPLES
Display the current settings:
.nf

    cupsctl

.fi
Enable debug logging:
.nf

    cupsctl --debug-logging

.fi
Get the current debug logging state:
.nf

    cupsctl | grep '^_debug_logging' | awk -F= '{print $2}'

.fi
Disable printer sharing:
.nf

    cupsctl --no-share-printers
.fi
.SH KNOWN ISSUES
You cannot set the Listen or Port directives using \fBcupsctl\fR.
.SH SEE ALSO
.BR cupsd.conf (5),
.BR cupsd (8),
.br
CUPS Online Help (http://localhost:631/help)
.SH COPYRIGHT
Copyright \[co] 2007-2015 by Apple Inc.
.\"
.\" End of "$Id: cupsctl.man 12854 2015-08-28 14:08:00Z msweet $".
.\"
