// *** THIS FILE IS GENERATED - DO NOT EDIT ***
// See command_validation_generator.py for modifications

/***************************************************************************
 *
 * Copyright (c) 2021-2024 Valve Corporation
 * Copyright (c) 2021-2024 LunarG, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ****************************************************************************/

// NOLINTBEGIN

#include "error_message/logging.h"
#include "core_checks/core_validation.h"

enum CMD_SCOPE_TYPE { CMD_SCOPE_INSIDE, CMD_SCOPE_OUTSIDE, CMD_SCOPE_BOTH };

struct CommandValidationInfo {
    const char* recording_vuid;
    const char* buffer_level_vuid;

    VkQueueFlags queue_flags;
    const char* queue_vuid;

    CMD_SCOPE_TYPE render_pass;
    const char* render_pass_vuid;

    CMD_SCOPE_TYPE video_coding;
    const char* video_coding_vuid;
};

using Func = vvl::Func;
// clang-format off
static const vvl::unordered_map<Func, CommandValidationInfo> kCommandValidationTable {
{Func::vkCmdBindPipeline, {
    "VUID-vkCmdBindPipeline-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBindPipeline-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBindPipeline-videocoding",
}},
{Func::vkCmdSetViewport, {
    "VUID-vkCmdSetViewport-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetViewport-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetViewport-videocoding",
}},
{Func::vkCmdSetScissor, {
    "VUID-vkCmdSetScissor-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetScissor-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetScissor-videocoding",
}},
{Func::vkCmdSetLineWidth, {
    "VUID-vkCmdSetLineWidth-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetLineWidth-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetLineWidth-videocoding",
}},
{Func::vkCmdSetDepthBias, {
    "VUID-vkCmdSetDepthBias-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthBias-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDepthBias-videocoding",
}},
{Func::vkCmdSetBlendConstants, {
    "VUID-vkCmdSetBlendConstants-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetBlendConstants-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetBlendConstants-videocoding",
}},
{Func::vkCmdSetDepthBounds, {
    "VUID-vkCmdSetDepthBounds-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthBounds-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDepthBounds-videocoding",
}},
{Func::vkCmdSetStencilCompareMask, {
    "VUID-vkCmdSetStencilCompareMask-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetStencilCompareMask-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetStencilCompareMask-videocoding",
}},
{Func::vkCmdSetStencilWriteMask, {
    "VUID-vkCmdSetStencilWriteMask-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetStencilWriteMask-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetStencilWriteMask-videocoding",
}},
{Func::vkCmdSetStencilReference, {
    "VUID-vkCmdSetStencilReference-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetStencilReference-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetStencilReference-videocoding",
}},
{Func::vkCmdBindDescriptorSets, {
    "VUID-vkCmdBindDescriptorSets-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBindDescriptorSets-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBindDescriptorSets-videocoding",
}},
{Func::vkCmdBindIndexBuffer, {
    "VUID-vkCmdBindIndexBuffer-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBindIndexBuffer-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBindIndexBuffer-videocoding",
}},
{Func::vkCmdBindVertexBuffers, {
    "VUID-vkCmdBindVertexBuffers-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBindVertexBuffers-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBindVertexBuffers-videocoding",
}},
{Func::vkCmdDraw, {
    "VUID-vkCmdDraw-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDraw-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdDraw-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDraw-videocoding",
}},
{Func::vkCmdDrawIndexed, {
    "VUID-vkCmdDrawIndexed-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawIndexed-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdDrawIndexed-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawIndexed-videocoding",
}},
{Func::vkCmdDrawIndirect, {
    "VUID-vkCmdDrawIndirect-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawIndirect-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdDrawIndirect-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawIndirect-videocoding",
}},
{Func::vkCmdDrawIndexedIndirect, {
    "VUID-vkCmdDrawIndexedIndirect-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawIndexedIndirect-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdDrawIndexedIndirect-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawIndexedIndirect-videocoding",
}},
{Func::vkCmdDispatch, {
    "VUID-vkCmdDispatch-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDispatch-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDispatch-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDispatch-videocoding",
}},
{Func::vkCmdDispatchIndirect, {
    "VUID-vkCmdDispatchIndirect-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDispatchIndirect-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDispatchIndirect-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDispatchIndirect-videocoding",
}},
{Func::vkCmdCopyBuffer, {
    "VUID-vkCmdCopyBuffer-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdCopyBuffer-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyBuffer-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyBuffer-videocoding",
}},
{Func::vkCmdCopyImage, {
    "VUID-vkCmdCopyImage-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdCopyImage-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyImage-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyImage-videocoding",
}},
{Func::vkCmdBlitImage, {
    "VUID-vkCmdBlitImage-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBlitImage-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBlitImage-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBlitImage-videocoding",
}},
{Func::vkCmdCopyBufferToImage, {
    "VUID-vkCmdCopyBufferToImage-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdCopyBufferToImage-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyBufferToImage-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyBufferToImage-videocoding",
}},
{Func::vkCmdCopyImageToBuffer, {
    "VUID-vkCmdCopyImageToBuffer-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdCopyImageToBuffer-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyImageToBuffer-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyImageToBuffer-videocoding",
}},
{Func::vkCmdUpdateBuffer, {
    "VUID-vkCmdUpdateBuffer-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdUpdateBuffer-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdUpdateBuffer-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdUpdateBuffer-videocoding",
}},
{Func::vkCmdFillBuffer, {
    "VUID-vkCmdFillBuffer-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdFillBuffer-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdFillBuffer-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdFillBuffer-videocoding",
}},
{Func::vkCmdClearColorImage, {
    "VUID-vkCmdClearColorImage-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdClearColorImage-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdClearColorImage-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdClearColorImage-videocoding",
}},
{Func::vkCmdClearDepthStencilImage, {
    "VUID-vkCmdClearDepthStencilImage-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdClearDepthStencilImage-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdClearDepthStencilImage-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdClearDepthStencilImage-videocoding",
}},
{Func::vkCmdClearAttachments, {
    "VUID-vkCmdClearAttachments-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdClearAttachments-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdClearAttachments-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdClearAttachments-videocoding",
}},
{Func::vkCmdResolveImage, {
    "VUID-vkCmdResolveImage-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdResolveImage-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdResolveImage-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdResolveImage-videocoding",
}},
{Func::vkCmdSetEvent, {
    "VUID-vkCmdSetEvent-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdSetEvent-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetEvent-renderpass",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
}},
{Func::vkCmdResetEvent, {
    "VUID-vkCmdResetEvent-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdResetEvent-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdResetEvent-renderpass",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
}},
{Func::vkCmdWaitEvents, {
    "VUID-vkCmdWaitEvents-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdWaitEvents-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
}},
{Func::vkCmdPipelineBarrier, {
    "VUID-vkCmdPipelineBarrier-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdPipelineBarrier-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
}},
{Func::vkCmdBeginQuery, {
    "VUID-vkCmdBeginQuery-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdBeginQuery-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
}},
{Func::vkCmdEndQuery, {
    "VUID-vkCmdEndQuery-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdEndQuery-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
}},
{Func::vkCmdResetQueryPool, {
    "VUID-vkCmdResetQueryPool-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR | VK_QUEUE_OPTICAL_FLOW_BIT_NV, "VUID-vkCmdResetQueryPool-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdResetQueryPool-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdResetQueryPool-videocoding",
}},
{Func::vkCmdWriteTimestamp, {
    "VUID-vkCmdWriteTimestamp-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR | VK_QUEUE_OPTICAL_FLOW_BIT_NV, "VUID-vkCmdWriteTimestamp-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
}},
{Func::vkCmdCopyQueryPoolResults, {
    "VUID-vkCmdCopyQueryPoolResults-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyQueryPoolResults-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyQueryPoolResults-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyQueryPoolResults-videocoding",
}},
{Func::vkCmdPushConstants, {
    "VUID-vkCmdPushConstants-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdPushConstants-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdPushConstants-videocoding",
}},
{Func::vkCmdBeginRenderPass, {
    "VUID-vkCmdBeginRenderPass-commandBuffer-recording",
    "VUID-vkCmdBeginRenderPass-bufferlevel",
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBeginRenderPass-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBeginRenderPass-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBeginRenderPass-videocoding",
}},
{Func::vkCmdNextSubpass, {
    "VUID-vkCmdNextSubpass-commandBuffer-recording",
    "VUID-vkCmdNextSubpass-bufferlevel",
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdNextSubpass-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdNextSubpass-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdNextSubpass-videocoding",
}},
{Func::vkCmdEndRenderPass, {
    "VUID-vkCmdEndRenderPass-commandBuffer-recording",
    "VUID-vkCmdEndRenderPass-bufferlevel",
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdEndRenderPass-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdEndRenderPass-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdEndRenderPass-videocoding",
}},
{Func::vkCmdExecuteCommands, {
    "VUID-vkCmdExecuteCommands-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdExecuteCommands-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdExecuteCommands-videocoding",
}},
{Func::vkCmdSetDeviceMask, {
    "VUID-vkCmdSetDeviceMask-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdSetDeviceMask-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
}},
{Func::vkCmdDispatchBase, {
    "VUID-vkCmdDispatchBase-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDispatchBase-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDispatchBase-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDispatchBase-videocoding",
}},
{Func::vkCmdDrawIndirectCount, {
    "VUID-vkCmdDrawIndirectCount-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawIndirectCount-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdDrawIndirectCount-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawIndirectCount-videocoding",
}},
{Func::vkCmdDrawIndexedIndirectCount, {
    "VUID-vkCmdDrawIndexedIndirectCount-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawIndexedIndirectCount-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdDrawIndexedIndirectCount-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawIndexedIndirectCount-videocoding",
}},
{Func::vkCmdBeginRenderPass2, {
    "VUID-vkCmdBeginRenderPass2-commandBuffer-recording",
    "VUID-vkCmdBeginRenderPass2-bufferlevel",
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBeginRenderPass2-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBeginRenderPass2-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBeginRenderPass2-videocoding",
}},
{Func::vkCmdNextSubpass2, {
    "VUID-vkCmdNextSubpass2-commandBuffer-recording",
    "VUID-vkCmdNextSubpass2-bufferlevel",
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdNextSubpass2-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdNextSubpass2-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdNextSubpass2-videocoding",
}},
{Func::vkCmdEndRenderPass2, {
    "VUID-vkCmdEndRenderPass2-commandBuffer-recording",
    "VUID-vkCmdEndRenderPass2-bufferlevel",
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdEndRenderPass2-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdEndRenderPass2-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdEndRenderPass2-videocoding",
}},
{Func::vkCmdSetEvent2, {
    "VUID-vkCmdSetEvent2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdSetEvent2-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetEvent2-renderpass",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
}},
{Func::vkCmdResetEvent2, {
    "VUID-vkCmdResetEvent2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdResetEvent2-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdResetEvent2-renderpass",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
}},
{Func::vkCmdWaitEvents2, {
    "VUID-vkCmdWaitEvents2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdWaitEvents2-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
}},
{Func::vkCmdPipelineBarrier2, {
    "VUID-vkCmdPipelineBarrier2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdPipelineBarrier2-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
}},
{Func::vkCmdWriteTimestamp2, {
    "VUID-vkCmdWriteTimestamp2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdWriteTimestamp2-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
}},
{Func::vkCmdCopyBuffer2, {
    "VUID-vkCmdCopyBuffer2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdCopyBuffer2-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyBuffer2-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyBuffer2-videocoding",
}},
{Func::vkCmdCopyImage2, {
    "VUID-vkCmdCopyImage2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdCopyImage2-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyImage2-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyImage2-videocoding",
}},
{Func::vkCmdCopyBufferToImage2, {
    "VUID-vkCmdCopyBufferToImage2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdCopyBufferToImage2-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyBufferToImage2-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyBufferToImage2-videocoding",
}},
{Func::vkCmdCopyImageToBuffer2, {
    "VUID-vkCmdCopyImageToBuffer2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdCopyImageToBuffer2-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyImageToBuffer2-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyImageToBuffer2-videocoding",
}},
{Func::vkCmdBlitImage2, {
    "VUID-vkCmdBlitImage2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBlitImage2-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBlitImage2-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBlitImage2-videocoding",
}},
{Func::vkCmdResolveImage2, {
    "VUID-vkCmdResolveImage2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdResolveImage2-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdResolveImage2-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdResolveImage2-videocoding",
}},
{Func::vkCmdBeginRendering, {
    "VUID-vkCmdBeginRendering-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBeginRendering-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBeginRendering-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBeginRendering-videocoding",
}},
{Func::vkCmdEndRendering, {
    "VUID-vkCmdEndRendering-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdEndRendering-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdEndRendering-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdEndRendering-videocoding",
}},
{Func::vkCmdSetCullMode, {
    "VUID-vkCmdSetCullMode-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetCullMode-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetCullMode-videocoding",
}},
{Func::vkCmdSetFrontFace, {
    "VUID-vkCmdSetFrontFace-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetFrontFace-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetFrontFace-videocoding",
}},
{Func::vkCmdSetPrimitiveTopology, {
    "VUID-vkCmdSetPrimitiveTopology-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetPrimitiveTopology-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetPrimitiveTopology-videocoding",
}},
{Func::vkCmdSetViewportWithCount, {
    "VUID-vkCmdSetViewportWithCount-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetViewportWithCount-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetViewportWithCount-videocoding",
}},
{Func::vkCmdSetScissorWithCount, {
    "VUID-vkCmdSetScissorWithCount-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetScissorWithCount-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetScissorWithCount-videocoding",
}},
{Func::vkCmdBindVertexBuffers2, {
    "VUID-vkCmdBindVertexBuffers2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBindVertexBuffers2-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBindVertexBuffers2-videocoding",
}},
{Func::vkCmdSetDepthTestEnable, {
    "VUID-vkCmdSetDepthTestEnable-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthTestEnable-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDepthTestEnable-videocoding",
}},
{Func::vkCmdSetDepthWriteEnable, {
    "VUID-vkCmdSetDepthWriteEnable-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthWriteEnable-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDepthWriteEnable-videocoding",
}},
{Func::vkCmdSetDepthCompareOp, {
    "VUID-vkCmdSetDepthCompareOp-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthCompareOp-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDepthCompareOp-videocoding",
}},
{Func::vkCmdSetDepthBoundsTestEnable, {
    "VUID-vkCmdSetDepthBoundsTestEnable-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthBoundsTestEnable-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDepthBoundsTestEnable-videocoding",
}},
{Func::vkCmdSetStencilTestEnable, {
    "VUID-vkCmdSetStencilTestEnable-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetStencilTestEnable-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetStencilTestEnable-videocoding",
}},
{Func::vkCmdSetStencilOp, {
    "VUID-vkCmdSetStencilOp-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetStencilOp-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetStencilOp-videocoding",
}},
{Func::vkCmdSetRasterizerDiscardEnable, {
    "VUID-vkCmdSetRasterizerDiscardEnable-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetRasterizerDiscardEnable-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetRasterizerDiscardEnable-videocoding",
}},
{Func::vkCmdSetDepthBiasEnable, {
    "VUID-vkCmdSetDepthBiasEnable-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthBiasEnable-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDepthBiasEnable-videocoding",
}},
{Func::vkCmdSetPrimitiveRestartEnable, {
    "VUID-vkCmdSetPrimitiveRestartEnable-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetPrimitiveRestartEnable-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetPrimitiveRestartEnable-videocoding",
}},
{Func::vkCmdBeginVideoCodingKHR, {
    "VUID-vkCmdBeginVideoCodingKHR-commandBuffer-recording",
    "VUID-vkCmdBeginVideoCodingKHR-bufferlevel",
    VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdBeginVideoCodingKHR-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBeginVideoCodingKHR-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBeginVideoCodingKHR-videocoding",
}},
{Func::vkCmdEndVideoCodingKHR, {
    "VUID-vkCmdEndVideoCodingKHR-commandBuffer-recording",
    "VUID-vkCmdEndVideoCodingKHR-bufferlevel",
    VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdEndVideoCodingKHR-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdEndVideoCodingKHR-renderpass",
    CMD_SCOPE_INSIDE, "VUID-vkCmdEndVideoCodingKHR-videocoding",
}},
{Func::vkCmdControlVideoCodingKHR, {
    "VUID-vkCmdControlVideoCodingKHR-commandBuffer-recording",
    "VUID-vkCmdControlVideoCodingKHR-bufferlevel",
    VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdControlVideoCodingKHR-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdControlVideoCodingKHR-renderpass",
    CMD_SCOPE_INSIDE, "VUID-vkCmdControlVideoCodingKHR-videocoding",
}},
{Func::vkCmdDecodeVideoKHR, {
    "VUID-vkCmdDecodeVideoKHR-commandBuffer-recording",
    "VUID-vkCmdDecodeVideoKHR-bufferlevel",
    VK_QUEUE_VIDEO_DECODE_BIT_KHR, "VUID-vkCmdDecodeVideoKHR-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDecodeVideoKHR-renderpass",
    CMD_SCOPE_INSIDE, "VUID-vkCmdDecodeVideoKHR-videocoding",
}},
{Func::vkCmdBeginRenderingKHR, {
    "VUID-vkCmdBeginRendering-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBeginRendering-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBeginRendering-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBeginRendering-videocoding",
}},
{Func::vkCmdEndRenderingKHR, {
    "VUID-vkCmdEndRendering-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdEndRendering-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdEndRendering-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdEndRendering-videocoding",
}},
{Func::vkCmdSetDeviceMaskKHR, {
    "VUID-vkCmdSetDeviceMask-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdSetDeviceMask-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
}},
{Func::vkCmdDispatchBaseKHR, {
    "VUID-vkCmdDispatchBase-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDispatchBase-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDispatchBase-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDispatchBase-videocoding",
}},
{Func::vkCmdPushDescriptorSetKHR, {
    "VUID-vkCmdPushDescriptorSetKHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdPushDescriptorSetKHR-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdPushDescriptorSetKHR-videocoding",
}},
{Func::vkCmdPushDescriptorSetWithTemplateKHR, {
    "VUID-vkCmdPushDescriptorSetWithTemplateKHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdPushDescriptorSetWithTemplateKHR-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdPushDescriptorSetWithTemplateKHR-videocoding",
}},
{Func::vkCmdBeginRenderPass2KHR, {
    "VUID-vkCmdBeginRenderPass2-commandBuffer-recording",
    "VUID-vkCmdBeginRenderPass2-bufferlevel",
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBeginRenderPass2-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBeginRenderPass2-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBeginRenderPass2-videocoding",
}},
{Func::vkCmdNextSubpass2KHR, {
    "VUID-vkCmdNextSubpass2-commandBuffer-recording",
    "VUID-vkCmdNextSubpass2-bufferlevel",
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdNextSubpass2-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdNextSubpass2-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdNextSubpass2-videocoding",
}},
{Func::vkCmdEndRenderPass2KHR, {
    "VUID-vkCmdEndRenderPass2-commandBuffer-recording",
    "VUID-vkCmdEndRenderPass2-bufferlevel",
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdEndRenderPass2-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdEndRenderPass2-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdEndRenderPass2-videocoding",
}},
{Func::vkCmdDrawIndirectCountKHR, {
    "VUID-vkCmdDrawIndirectCount-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawIndirectCount-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdDrawIndirectCount-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawIndirectCount-videocoding",
}},
{Func::vkCmdDrawIndexedIndirectCountKHR, {
    "VUID-vkCmdDrawIndexedIndirectCount-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawIndexedIndirectCount-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdDrawIndexedIndirectCount-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawIndexedIndirectCount-videocoding",
}},
{Func::vkCmdSetFragmentShadingRateKHR, {
    "VUID-vkCmdSetFragmentShadingRateKHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetFragmentShadingRateKHR-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetFragmentShadingRateKHR-videocoding",
}},
{Func::vkCmdSetRenderingAttachmentLocationsKHR, {
    "VUID-vkCmdSetRenderingAttachmentLocationsKHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetRenderingAttachmentLocationsKHR-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdSetRenderingAttachmentLocationsKHR-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetRenderingAttachmentLocationsKHR-videocoding",
}},
{Func::vkCmdSetRenderingInputAttachmentIndicesKHR, {
    "VUID-vkCmdSetRenderingInputAttachmentIndicesKHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetRenderingInputAttachmentIndicesKHR-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdSetRenderingInputAttachmentIndicesKHR-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetRenderingInputAttachmentIndicesKHR-videocoding",
}},
{Func::vkCmdEncodeVideoKHR, {
    "VUID-vkCmdEncodeVideoKHR-commandBuffer-recording",
    "VUID-vkCmdEncodeVideoKHR-bufferlevel",
    VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdEncodeVideoKHR-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdEncodeVideoKHR-renderpass",
    CMD_SCOPE_INSIDE, "VUID-vkCmdEncodeVideoKHR-videocoding",
}},
{Func::vkCmdSetEvent2KHR, {
    "VUID-vkCmdSetEvent2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdSetEvent2-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetEvent2-renderpass",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
}},
{Func::vkCmdResetEvent2KHR, {
    "VUID-vkCmdResetEvent2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdResetEvent2-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdResetEvent2-renderpass",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
}},
{Func::vkCmdWaitEvents2KHR, {
    "VUID-vkCmdWaitEvents2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdWaitEvents2-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
}},
{Func::vkCmdPipelineBarrier2KHR, {
    "VUID-vkCmdPipelineBarrier2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdPipelineBarrier2-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
}},
{Func::vkCmdWriteTimestamp2KHR, {
    "VUID-vkCmdWriteTimestamp2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdWriteTimestamp2-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
}},
{Func::vkCmdWriteBufferMarker2AMD, {
    "VUID-vkCmdWriteBufferMarker2AMD-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdWriteBufferMarker2AMD-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdWriteBufferMarker2AMD-videocoding",
}},
{Func::vkCmdCopyBuffer2KHR, {
    "VUID-vkCmdCopyBuffer2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdCopyBuffer2-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyBuffer2-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyBuffer2-videocoding",
}},
{Func::vkCmdCopyImage2KHR, {
    "VUID-vkCmdCopyImage2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdCopyImage2-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyImage2-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyImage2-videocoding",
}},
{Func::vkCmdCopyBufferToImage2KHR, {
    "VUID-vkCmdCopyBufferToImage2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdCopyBufferToImage2-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyBufferToImage2-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyBufferToImage2-videocoding",
}},
{Func::vkCmdCopyImageToBuffer2KHR, {
    "VUID-vkCmdCopyImageToBuffer2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdCopyImageToBuffer2-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyImageToBuffer2-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyImageToBuffer2-videocoding",
}},
{Func::vkCmdBlitImage2KHR, {
    "VUID-vkCmdBlitImage2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBlitImage2-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBlitImage2-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBlitImage2-videocoding",
}},
{Func::vkCmdResolveImage2KHR, {
    "VUID-vkCmdResolveImage2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdResolveImage2-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdResolveImage2-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdResolveImage2-videocoding",
}},
{Func::vkCmdTraceRaysIndirect2KHR, {
    "VUID-vkCmdTraceRaysIndirect2KHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdTraceRaysIndirect2KHR-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdTraceRaysIndirect2KHR-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdTraceRaysIndirect2KHR-videocoding",
}},
{Func::vkCmdBindIndexBuffer2KHR, {
    "VUID-vkCmdBindIndexBuffer2KHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBindIndexBuffer2KHR-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBindIndexBuffer2KHR-videocoding",
}},
{Func::vkCmdSetLineStippleKHR, {
    "VUID-vkCmdSetLineStippleKHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetLineStippleKHR-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetLineStippleKHR-videocoding",
}},
{Func::vkCmdBindDescriptorSets2KHR, {
    "VUID-vkCmdBindDescriptorSets2KHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBindDescriptorSets2KHR-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBindDescriptorSets2KHR-videocoding",
}},
{Func::vkCmdPushConstants2KHR, {
    "VUID-vkCmdPushConstants2KHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdPushConstants2KHR-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdPushConstants2KHR-videocoding",
}},
{Func::vkCmdPushDescriptorSet2KHR, {
    "VUID-vkCmdPushDescriptorSet2KHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdPushDescriptorSet2KHR-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdPushDescriptorSet2KHR-videocoding",
}},
{Func::vkCmdPushDescriptorSetWithTemplate2KHR, {
    "VUID-vkCmdPushDescriptorSetWithTemplate2KHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdPushDescriptorSetWithTemplate2KHR-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdPushDescriptorSetWithTemplate2KHR-videocoding",
}},
{Func::vkCmdSetDescriptorBufferOffsets2EXT, {
    "VUID-vkCmdSetDescriptorBufferOffsets2EXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdSetDescriptorBufferOffsets2EXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDescriptorBufferOffsets2EXT-videocoding",
}},
{Func::vkCmdBindDescriptorBufferEmbeddedSamplers2EXT, {
    "VUID-vkCmdBindDescriptorBufferEmbeddedSamplers2EXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBindDescriptorBufferEmbeddedSamplers2EXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBindDescriptorBufferEmbeddedSamplers2EXT-videocoding",
}},
{Func::vkCmdDebugMarkerBeginEXT, {
    "VUID-vkCmdDebugMarkerBeginEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDebugMarkerBeginEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDebugMarkerBeginEXT-videocoding",
}},
{Func::vkCmdDebugMarkerEndEXT, {
    "VUID-vkCmdDebugMarkerEndEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDebugMarkerEndEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDebugMarkerEndEXT-videocoding",
}},
{Func::vkCmdDebugMarkerInsertEXT, {
    "VUID-vkCmdDebugMarkerInsertEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDebugMarkerInsertEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDebugMarkerInsertEXT-videocoding",
}},
{Func::vkCmdBindTransformFeedbackBuffersEXT, {
    "VUID-vkCmdBindTransformFeedbackBuffersEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBindTransformFeedbackBuffersEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBindTransformFeedbackBuffersEXT-videocoding",
}},
{Func::vkCmdBeginTransformFeedbackEXT, {
    "VUID-vkCmdBeginTransformFeedbackEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBeginTransformFeedbackEXT-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdBeginTransformFeedbackEXT-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBeginTransformFeedbackEXT-videocoding",
}},
{Func::vkCmdEndTransformFeedbackEXT, {
    "VUID-vkCmdEndTransformFeedbackEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdEndTransformFeedbackEXT-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdEndTransformFeedbackEXT-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdEndTransformFeedbackEXT-videocoding",
}},
{Func::vkCmdBeginQueryIndexedEXT, {
    "VUID-vkCmdBeginQueryIndexedEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdBeginQueryIndexedEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBeginQueryIndexedEXT-videocoding",
}},
{Func::vkCmdEndQueryIndexedEXT, {
    "VUID-vkCmdEndQueryIndexedEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdEndQueryIndexedEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdEndQueryIndexedEXT-videocoding",
}},
{Func::vkCmdDrawIndirectByteCountEXT, {
    "VUID-vkCmdDrawIndirectByteCountEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawIndirectByteCountEXT-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdDrawIndirectByteCountEXT-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawIndirectByteCountEXT-videocoding",
}},
{Func::vkCmdCuLaunchKernelNVX, {
    "VUID-vkCmdCuLaunchKernelNVX-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCuLaunchKernelNVX-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCuLaunchKernelNVX-videocoding",
}},
{Func::vkCmdDrawIndirectCountAMD, {
    "VUID-vkCmdDrawIndirectCount-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawIndirectCount-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdDrawIndirectCount-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawIndirectCount-videocoding",
}},
{Func::vkCmdDrawIndexedIndirectCountAMD, {
    "VUID-vkCmdDrawIndexedIndirectCount-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawIndexedIndirectCount-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdDrawIndexedIndirectCount-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawIndexedIndirectCount-videocoding",
}},
{Func::vkCmdBeginConditionalRenderingEXT, {
    "VUID-vkCmdBeginConditionalRenderingEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBeginConditionalRenderingEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBeginConditionalRenderingEXT-videocoding",
}},
{Func::vkCmdEndConditionalRenderingEXT, {
    "VUID-vkCmdEndConditionalRenderingEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdEndConditionalRenderingEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdEndConditionalRenderingEXT-videocoding",
}},
{Func::vkCmdSetViewportWScalingNV, {
    "VUID-vkCmdSetViewportWScalingNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetViewportWScalingNV-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetViewportWScalingNV-videocoding",
}},
{Func::vkCmdSetDiscardRectangleEXT, {
    "VUID-vkCmdSetDiscardRectangleEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDiscardRectangleEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDiscardRectangleEXT-videocoding",
}},
{Func::vkCmdSetDiscardRectangleEnableEXT, {
    "VUID-vkCmdSetDiscardRectangleEnableEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDiscardRectangleEnableEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDiscardRectangleEnableEXT-videocoding",
}},
{Func::vkCmdSetDiscardRectangleModeEXT, {
    "VUID-vkCmdSetDiscardRectangleModeEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDiscardRectangleModeEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDiscardRectangleModeEXT-videocoding",
}},
{Func::vkCmdBeginDebugUtilsLabelEXT, {
    "VUID-vkCmdBeginDebugUtilsLabelEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBeginDebugUtilsLabelEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBeginDebugUtilsLabelEXT-videocoding",
}},
{Func::vkCmdEndDebugUtilsLabelEXT, {
    "VUID-vkCmdEndDebugUtilsLabelEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdEndDebugUtilsLabelEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdEndDebugUtilsLabelEXT-videocoding",
}},
{Func::vkCmdInsertDebugUtilsLabelEXT, {
    "VUID-vkCmdInsertDebugUtilsLabelEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdInsertDebugUtilsLabelEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdInsertDebugUtilsLabelEXT-videocoding",
}},
{Func::vkCmdInitializeGraphScratchMemoryAMDX, {
    "VUID-vkCmdInitializeGraphScratchMemoryAMDX-commandBuffer-recording",
    "VUID-vkCmdInitializeGraphScratchMemoryAMDX-bufferlevel",
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdInitializeGraphScratchMemoryAMDX-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdInitializeGraphScratchMemoryAMDX-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdInitializeGraphScratchMemoryAMDX-videocoding",
}},
{Func::vkCmdDispatchGraphAMDX, {
    "VUID-vkCmdDispatchGraphAMDX-commandBuffer-recording",
    "VUID-vkCmdDispatchGraphAMDX-bufferlevel",
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDispatchGraphAMDX-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDispatchGraphAMDX-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDispatchGraphAMDX-videocoding",
}},
{Func::vkCmdDispatchGraphIndirectAMDX, {
    "VUID-vkCmdDispatchGraphIndirectAMDX-commandBuffer-recording",
    "VUID-vkCmdDispatchGraphIndirectAMDX-bufferlevel",
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDispatchGraphIndirectAMDX-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDispatchGraphIndirectAMDX-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDispatchGraphIndirectAMDX-videocoding",
}},
{Func::vkCmdDispatchGraphIndirectCountAMDX, {
    "VUID-vkCmdDispatchGraphIndirectCountAMDX-commandBuffer-recording",
    "VUID-vkCmdDispatchGraphIndirectCountAMDX-bufferlevel",
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDispatchGraphIndirectCountAMDX-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDispatchGraphIndirectCountAMDX-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDispatchGraphIndirectCountAMDX-videocoding",
}},
{Func::vkCmdSetSampleLocationsEXT, {
    "VUID-vkCmdSetSampleLocationsEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetSampleLocationsEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetSampleLocationsEXT-videocoding",
}},
{Func::vkCmdBindShadingRateImageNV, {
    "VUID-vkCmdBindShadingRateImageNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBindShadingRateImageNV-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBindShadingRateImageNV-videocoding",
}},
{Func::vkCmdSetViewportShadingRatePaletteNV, {
    "VUID-vkCmdSetViewportShadingRatePaletteNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetViewportShadingRatePaletteNV-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetViewportShadingRatePaletteNV-videocoding",
}},
{Func::vkCmdSetCoarseSampleOrderNV, {
    "VUID-vkCmdSetCoarseSampleOrderNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetCoarseSampleOrderNV-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetCoarseSampleOrderNV-videocoding",
}},
{Func::vkCmdBuildAccelerationStructureNV, {
    "VUID-vkCmdBuildAccelerationStructureNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBuildAccelerationStructureNV-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBuildAccelerationStructureNV-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBuildAccelerationStructureNV-videocoding",
}},
{Func::vkCmdCopyAccelerationStructureNV, {
    "VUID-vkCmdCopyAccelerationStructureNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyAccelerationStructureNV-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyAccelerationStructureNV-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyAccelerationStructureNV-videocoding",
}},
{Func::vkCmdTraceRaysNV, {
    "VUID-vkCmdTraceRaysNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdTraceRaysNV-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdTraceRaysNV-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdTraceRaysNV-videocoding",
}},
{Func::vkCmdWriteAccelerationStructuresPropertiesNV, {
    "VUID-vkCmdWriteAccelerationStructuresPropertiesNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdWriteAccelerationStructuresPropertiesNV-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdWriteAccelerationStructuresPropertiesNV-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdWriteAccelerationStructuresPropertiesNV-videocoding",
}},
{Func::vkCmdWriteBufferMarkerAMD, {
    "VUID-vkCmdWriteBufferMarkerAMD-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdWriteBufferMarkerAMD-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdWriteBufferMarkerAMD-videocoding",
}},
{Func::vkCmdDrawMeshTasksNV, {
    "VUID-vkCmdDrawMeshTasksNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawMeshTasksNV-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdDrawMeshTasksNV-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawMeshTasksNV-videocoding",
}},
{Func::vkCmdDrawMeshTasksIndirectNV, {
    "VUID-vkCmdDrawMeshTasksIndirectNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawMeshTasksIndirectNV-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdDrawMeshTasksIndirectNV-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawMeshTasksIndirectNV-videocoding",
}},
{Func::vkCmdDrawMeshTasksIndirectCountNV, {
    "VUID-vkCmdDrawMeshTasksIndirectCountNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawMeshTasksIndirectCountNV-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdDrawMeshTasksIndirectCountNV-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawMeshTasksIndirectCountNV-videocoding",
}},
{Func::vkCmdSetExclusiveScissorEnableNV, {
    "VUID-vkCmdSetExclusiveScissorEnableNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetExclusiveScissorEnableNV-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetExclusiveScissorEnableNV-videocoding",
}},
{Func::vkCmdSetExclusiveScissorNV, {
    "VUID-vkCmdSetExclusiveScissorNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetExclusiveScissorNV-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetExclusiveScissorNV-videocoding",
}},
{Func::vkCmdSetCheckpointNV, {
    "VUID-vkCmdSetCheckpointNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdSetCheckpointNV-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetCheckpointNV-videocoding",
}},
{Func::vkCmdSetPerformanceMarkerINTEL, {
    "VUID-vkCmdSetPerformanceMarkerINTEL-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdSetPerformanceMarkerINTEL-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetPerformanceMarkerINTEL-videocoding",
}},
{Func::vkCmdSetPerformanceStreamMarkerINTEL, {
    "VUID-vkCmdSetPerformanceStreamMarkerINTEL-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdSetPerformanceStreamMarkerINTEL-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetPerformanceStreamMarkerINTEL-videocoding",
}},
{Func::vkCmdSetPerformanceOverrideINTEL, {
    "VUID-vkCmdSetPerformanceOverrideINTEL-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdSetPerformanceOverrideINTEL-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetPerformanceOverrideINTEL-videocoding",
}},
{Func::vkCmdSetLineStippleEXT, {
    "VUID-vkCmdSetLineStippleKHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetLineStippleKHR-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetLineStippleKHR-videocoding",
}},
{Func::vkCmdSetCullModeEXT, {
    "VUID-vkCmdSetCullMode-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetCullMode-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetCullMode-videocoding",
}},
{Func::vkCmdSetFrontFaceEXT, {
    "VUID-vkCmdSetFrontFace-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetFrontFace-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetFrontFace-videocoding",
}},
{Func::vkCmdSetPrimitiveTopologyEXT, {
    "VUID-vkCmdSetPrimitiveTopology-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetPrimitiveTopology-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetPrimitiveTopology-videocoding",
}},
{Func::vkCmdSetViewportWithCountEXT, {
    "VUID-vkCmdSetViewportWithCount-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetViewportWithCount-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetViewportWithCount-videocoding",
}},
{Func::vkCmdSetScissorWithCountEXT, {
    "VUID-vkCmdSetScissorWithCount-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetScissorWithCount-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetScissorWithCount-videocoding",
}},
{Func::vkCmdBindVertexBuffers2EXT, {
    "VUID-vkCmdBindVertexBuffers2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBindVertexBuffers2-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBindVertexBuffers2-videocoding",
}},
{Func::vkCmdSetDepthTestEnableEXT, {
    "VUID-vkCmdSetDepthTestEnable-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthTestEnable-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDepthTestEnable-videocoding",
}},
{Func::vkCmdSetDepthWriteEnableEXT, {
    "VUID-vkCmdSetDepthWriteEnable-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthWriteEnable-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDepthWriteEnable-videocoding",
}},
{Func::vkCmdSetDepthCompareOpEXT, {
    "VUID-vkCmdSetDepthCompareOp-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthCompareOp-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDepthCompareOp-videocoding",
}},
{Func::vkCmdSetDepthBoundsTestEnableEXT, {
    "VUID-vkCmdSetDepthBoundsTestEnable-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthBoundsTestEnable-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDepthBoundsTestEnable-videocoding",
}},
{Func::vkCmdSetStencilTestEnableEXT, {
    "VUID-vkCmdSetStencilTestEnable-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetStencilTestEnable-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetStencilTestEnable-videocoding",
}},
{Func::vkCmdSetStencilOpEXT, {
    "VUID-vkCmdSetStencilOp-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetStencilOp-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetStencilOp-videocoding",
}},
{Func::vkCmdPreprocessGeneratedCommandsNV, {
    "VUID-vkCmdPreprocessGeneratedCommandsNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdPreprocessGeneratedCommandsNV-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdPreprocessGeneratedCommandsNV-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdPreprocessGeneratedCommandsNV-videocoding",
}},
{Func::vkCmdExecuteGeneratedCommandsNV, {
    "VUID-vkCmdExecuteGeneratedCommandsNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdExecuteGeneratedCommandsNV-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdExecuteGeneratedCommandsNV-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdExecuteGeneratedCommandsNV-videocoding",
}},
{Func::vkCmdBindPipelineShaderGroupNV, {
    "VUID-vkCmdBindPipelineShaderGroupNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBindPipelineShaderGroupNV-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBindPipelineShaderGroupNV-videocoding",
}},
{Func::vkCmdSetDepthBias2EXT, {
    "VUID-vkCmdSetDepthBias2EXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthBias2EXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDepthBias2EXT-videocoding",
}},
{Func::vkCmdCudaLaunchKernelNV, {
    "VUID-vkCmdCudaLaunchKernelNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCudaLaunchKernelNV-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCudaLaunchKernelNV-videocoding",
}},
{Func::vkCmdBindDescriptorBuffersEXT, {
    "VUID-vkCmdBindDescriptorBuffersEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBindDescriptorBuffersEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBindDescriptorBuffersEXT-videocoding",
}},
{Func::vkCmdSetDescriptorBufferOffsetsEXT, {
    "VUID-vkCmdSetDescriptorBufferOffsetsEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdSetDescriptorBufferOffsetsEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDescriptorBufferOffsetsEXT-videocoding",
}},
{Func::vkCmdBindDescriptorBufferEmbeddedSamplersEXT, {
    "VUID-vkCmdBindDescriptorBufferEmbeddedSamplersEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBindDescriptorBufferEmbeddedSamplersEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBindDescriptorBufferEmbeddedSamplersEXT-videocoding",
}},
{Func::vkCmdSetFragmentShadingRateEnumNV, {
    "VUID-vkCmdSetFragmentShadingRateEnumNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetFragmentShadingRateEnumNV-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetFragmentShadingRateEnumNV-videocoding",
}},
{Func::vkCmdSetVertexInputEXT, {
    "VUID-vkCmdSetVertexInputEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetVertexInputEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetVertexInputEXT-videocoding",
}},
{Func::vkCmdSubpassShadingHUAWEI, {
    "VUID-vkCmdSubpassShadingHUAWEI-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSubpassShadingHUAWEI-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdSubpassShadingHUAWEI-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSubpassShadingHUAWEI-videocoding",
}},
{Func::vkCmdBindInvocationMaskHUAWEI, {
    "VUID-vkCmdBindInvocationMaskHUAWEI-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBindInvocationMaskHUAWEI-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBindInvocationMaskHUAWEI-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBindInvocationMaskHUAWEI-videocoding",
}},
{Func::vkCmdSetPatchControlPointsEXT, {
    "VUID-vkCmdSetPatchControlPointsEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetPatchControlPointsEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetPatchControlPointsEXT-videocoding",
}},
{Func::vkCmdSetRasterizerDiscardEnableEXT, {
    "VUID-vkCmdSetRasterizerDiscardEnable-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetRasterizerDiscardEnable-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetRasterizerDiscardEnable-videocoding",
}},
{Func::vkCmdSetDepthBiasEnableEXT, {
    "VUID-vkCmdSetDepthBiasEnable-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthBiasEnable-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDepthBiasEnable-videocoding",
}},
{Func::vkCmdSetLogicOpEXT, {
    "VUID-vkCmdSetLogicOpEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetLogicOpEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetLogicOpEXT-videocoding",
}},
{Func::vkCmdSetPrimitiveRestartEnableEXT, {
    "VUID-vkCmdSetPrimitiveRestartEnable-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetPrimitiveRestartEnable-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetPrimitiveRestartEnable-videocoding",
}},
{Func::vkCmdSetColorWriteEnableEXT, {
    "VUID-vkCmdSetColorWriteEnableEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetColorWriteEnableEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetColorWriteEnableEXT-videocoding",
}},
{Func::vkCmdDrawMultiEXT, {
    "VUID-vkCmdDrawMultiEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawMultiEXT-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdDrawMultiEXT-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawMultiEXT-videocoding",
}},
{Func::vkCmdDrawMultiIndexedEXT, {
    "VUID-vkCmdDrawMultiIndexedEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawMultiIndexedEXT-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdDrawMultiIndexedEXT-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawMultiIndexedEXT-videocoding",
}},
{Func::vkCmdBuildMicromapsEXT, {
    "VUID-vkCmdBuildMicromapsEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBuildMicromapsEXT-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBuildMicromapsEXT-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBuildMicromapsEXT-videocoding",
}},
{Func::vkCmdCopyMicromapEXT, {
    "VUID-vkCmdCopyMicromapEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyMicromapEXT-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyMicromapEXT-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyMicromapEXT-videocoding",
}},
{Func::vkCmdCopyMicromapToMemoryEXT, {
    "VUID-vkCmdCopyMicromapToMemoryEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyMicromapToMemoryEXT-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyMicromapToMemoryEXT-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyMicromapToMemoryEXT-videocoding",
}},
{Func::vkCmdCopyMemoryToMicromapEXT, {
    "VUID-vkCmdCopyMemoryToMicromapEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyMemoryToMicromapEXT-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyMemoryToMicromapEXT-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyMemoryToMicromapEXT-videocoding",
}},
{Func::vkCmdWriteMicromapsPropertiesEXT, {
    "VUID-vkCmdWriteMicromapsPropertiesEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdWriteMicromapsPropertiesEXT-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdWriteMicromapsPropertiesEXT-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdWriteMicromapsPropertiesEXT-videocoding",
}},
{Func::vkCmdDrawClusterHUAWEI, {
    "VUID-vkCmdDrawClusterHUAWEI-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawClusterHUAWEI-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdDrawClusterHUAWEI-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawClusterHUAWEI-videocoding",
}},
{Func::vkCmdDrawClusterIndirectHUAWEI, {
    "VUID-vkCmdDrawClusterIndirectHUAWEI-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawClusterIndirectHUAWEI-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdDrawClusterIndirectHUAWEI-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawClusterIndirectHUAWEI-videocoding",
}},
{Func::vkCmdCopyMemoryIndirectNV, {
    "VUID-vkCmdCopyMemoryIndirectNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdCopyMemoryIndirectNV-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyMemoryIndirectNV-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyMemoryIndirectNV-videocoding",
}},
{Func::vkCmdCopyMemoryToImageIndirectNV, {
    "VUID-vkCmdCopyMemoryToImageIndirectNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdCopyMemoryToImageIndirectNV-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyMemoryToImageIndirectNV-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyMemoryToImageIndirectNV-videocoding",
}},
{Func::vkCmdDecompressMemoryNV, {
    "VUID-vkCmdDecompressMemoryNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDecompressMemoryNV-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDecompressMemoryNV-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDecompressMemoryNV-videocoding",
}},
{Func::vkCmdDecompressMemoryIndirectCountNV, {
    "VUID-vkCmdDecompressMemoryIndirectCountNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDecompressMemoryIndirectCountNV-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDecompressMemoryIndirectCountNV-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDecompressMemoryIndirectCountNV-videocoding",
}},
{Func::vkCmdUpdatePipelineIndirectBufferNV, {
    "VUID-vkCmdUpdatePipelineIndirectBufferNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdUpdatePipelineIndirectBufferNV-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdUpdatePipelineIndirectBufferNV-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdUpdatePipelineIndirectBufferNV-videocoding",
}},
{Func::vkCmdSetDepthClampEnableEXT, {
    "VUID-vkCmdSetDepthClampEnableEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthClampEnableEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDepthClampEnableEXT-videocoding",
}},
{Func::vkCmdSetPolygonModeEXT, {
    "VUID-vkCmdSetPolygonModeEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetPolygonModeEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetPolygonModeEXT-videocoding",
}},
{Func::vkCmdSetRasterizationSamplesEXT, {
    "VUID-vkCmdSetRasterizationSamplesEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetRasterizationSamplesEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetRasterizationSamplesEXT-videocoding",
}},
{Func::vkCmdSetSampleMaskEXT, {
    "VUID-vkCmdSetSampleMaskEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetSampleMaskEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetSampleMaskEXT-videocoding",
}},
{Func::vkCmdSetAlphaToCoverageEnableEXT, {
    "VUID-vkCmdSetAlphaToCoverageEnableEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetAlphaToCoverageEnableEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetAlphaToCoverageEnableEXT-videocoding",
}},
{Func::vkCmdSetAlphaToOneEnableEXT, {
    "VUID-vkCmdSetAlphaToOneEnableEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetAlphaToOneEnableEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetAlphaToOneEnableEXT-videocoding",
}},
{Func::vkCmdSetLogicOpEnableEXT, {
    "VUID-vkCmdSetLogicOpEnableEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetLogicOpEnableEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetLogicOpEnableEXT-videocoding",
}},
{Func::vkCmdSetColorBlendEnableEXT, {
    "VUID-vkCmdSetColorBlendEnableEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetColorBlendEnableEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetColorBlendEnableEXT-videocoding",
}},
{Func::vkCmdSetColorBlendEquationEXT, {
    "VUID-vkCmdSetColorBlendEquationEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetColorBlendEquationEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetColorBlendEquationEXT-videocoding",
}},
{Func::vkCmdSetColorWriteMaskEXT, {
    "VUID-vkCmdSetColorWriteMaskEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetColorWriteMaskEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetColorWriteMaskEXT-videocoding",
}},
{Func::vkCmdSetTessellationDomainOriginEXT, {
    "VUID-vkCmdSetTessellationDomainOriginEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetTessellationDomainOriginEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetTessellationDomainOriginEXT-videocoding",
}},
{Func::vkCmdSetRasterizationStreamEXT, {
    "VUID-vkCmdSetRasterizationStreamEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetRasterizationStreamEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetRasterizationStreamEXT-videocoding",
}},
{Func::vkCmdSetConservativeRasterizationModeEXT, {
    "VUID-vkCmdSetConservativeRasterizationModeEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetConservativeRasterizationModeEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetConservativeRasterizationModeEXT-videocoding",
}},
{Func::vkCmdSetExtraPrimitiveOverestimationSizeEXT, {
    "VUID-vkCmdSetExtraPrimitiveOverestimationSizeEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetExtraPrimitiveOverestimationSizeEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetExtraPrimitiveOverestimationSizeEXT-videocoding",
}},
{Func::vkCmdSetDepthClipEnableEXT, {
    "VUID-vkCmdSetDepthClipEnableEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthClipEnableEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDepthClipEnableEXT-videocoding",
}},
{Func::vkCmdSetSampleLocationsEnableEXT, {
    "VUID-vkCmdSetSampleLocationsEnableEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetSampleLocationsEnableEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetSampleLocationsEnableEXT-videocoding",
}},
{Func::vkCmdSetColorBlendAdvancedEXT, {
    "VUID-vkCmdSetColorBlendAdvancedEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetColorBlendAdvancedEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetColorBlendAdvancedEXT-videocoding",
}},
{Func::vkCmdSetProvokingVertexModeEXT, {
    "VUID-vkCmdSetProvokingVertexModeEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetProvokingVertexModeEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetProvokingVertexModeEXT-videocoding",
}},
{Func::vkCmdSetLineRasterizationModeEXT, {
    "VUID-vkCmdSetLineRasterizationModeEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetLineRasterizationModeEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetLineRasterizationModeEXT-videocoding",
}},
{Func::vkCmdSetLineStippleEnableEXT, {
    "VUID-vkCmdSetLineStippleEnableEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetLineStippleEnableEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetLineStippleEnableEXT-videocoding",
}},
{Func::vkCmdSetDepthClipNegativeOneToOneEXT, {
    "VUID-vkCmdSetDepthClipNegativeOneToOneEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthClipNegativeOneToOneEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetDepthClipNegativeOneToOneEXT-videocoding",
}},
{Func::vkCmdSetViewportWScalingEnableNV, {
    "VUID-vkCmdSetViewportWScalingEnableNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetViewportWScalingEnableNV-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetViewportWScalingEnableNV-videocoding",
}},
{Func::vkCmdSetViewportSwizzleNV, {
    "VUID-vkCmdSetViewportSwizzleNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetViewportSwizzleNV-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetViewportSwizzleNV-videocoding",
}},
{Func::vkCmdSetCoverageToColorEnableNV, {
    "VUID-vkCmdSetCoverageToColorEnableNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetCoverageToColorEnableNV-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetCoverageToColorEnableNV-videocoding",
}},
{Func::vkCmdSetCoverageToColorLocationNV, {
    "VUID-vkCmdSetCoverageToColorLocationNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetCoverageToColorLocationNV-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetCoverageToColorLocationNV-videocoding",
}},
{Func::vkCmdSetCoverageModulationModeNV, {
    "VUID-vkCmdSetCoverageModulationModeNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetCoverageModulationModeNV-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetCoverageModulationModeNV-videocoding",
}},
{Func::vkCmdSetCoverageModulationTableEnableNV, {
    "VUID-vkCmdSetCoverageModulationTableEnableNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetCoverageModulationTableEnableNV-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetCoverageModulationTableEnableNV-videocoding",
}},
{Func::vkCmdSetCoverageModulationTableNV, {
    "VUID-vkCmdSetCoverageModulationTableNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetCoverageModulationTableNV-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetCoverageModulationTableNV-videocoding",
}},
{Func::vkCmdSetShadingRateImageEnableNV, {
    "VUID-vkCmdSetShadingRateImageEnableNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetShadingRateImageEnableNV-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetShadingRateImageEnableNV-videocoding",
}},
{Func::vkCmdSetRepresentativeFragmentTestEnableNV, {
    "VUID-vkCmdSetRepresentativeFragmentTestEnableNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetRepresentativeFragmentTestEnableNV-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetRepresentativeFragmentTestEnableNV-videocoding",
}},
{Func::vkCmdSetCoverageReductionModeNV, {
    "VUID-vkCmdSetCoverageReductionModeNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetCoverageReductionModeNV-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetCoverageReductionModeNV-videocoding",
}},
{Func::vkCmdOpticalFlowExecuteNV, {
    "VUID-vkCmdOpticalFlowExecuteNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_OPTICAL_FLOW_BIT_NV, "VUID-vkCmdOpticalFlowExecuteNV-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdOpticalFlowExecuteNV-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdOpticalFlowExecuteNV-videocoding",
}},
{Func::vkCmdBindShadersEXT, {
    "VUID-vkCmdBindShadersEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBindShadersEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBindShadersEXT-videocoding",
}},
{Func::vkCmdSetAttachmentFeedbackLoopEnableEXT, {
    "VUID-vkCmdSetAttachmentFeedbackLoopEnableEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetAttachmentFeedbackLoopEnableEXT-commandBuffer-cmdpool",
    CMD_SCOPE_BOTH, "kVUIDUndefined",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetAttachmentFeedbackLoopEnableEXT-videocoding",
}},
{Func::vkCmdBuildAccelerationStructuresKHR, {
    "VUID-vkCmdBuildAccelerationStructuresKHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBuildAccelerationStructuresKHR-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBuildAccelerationStructuresKHR-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBuildAccelerationStructuresKHR-videocoding",
}},
{Func::vkCmdBuildAccelerationStructuresIndirectKHR, {
    "VUID-vkCmdBuildAccelerationStructuresIndirectKHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBuildAccelerationStructuresIndirectKHR-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBuildAccelerationStructuresIndirectKHR-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdBuildAccelerationStructuresIndirectKHR-videocoding",
}},
{Func::vkCmdCopyAccelerationStructureKHR, {
    "VUID-vkCmdCopyAccelerationStructureKHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyAccelerationStructureKHR-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyAccelerationStructureKHR-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyAccelerationStructureKHR-videocoding",
}},
{Func::vkCmdCopyAccelerationStructureToMemoryKHR, {
    "VUID-vkCmdCopyAccelerationStructureToMemoryKHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyAccelerationStructureToMemoryKHR-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyAccelerationStructureToMemoryKHR-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyAccelerationStructureToMemoryKHR-videocoding",
}},
{Func::vkCmdCopyMemoryToAccelerationStructureKHR, {
    "VUID-vkCmdCopyMemoryToAccelerationStructureKHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyMemoryToAccelerationStructureKHR-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyMemoryToAccelerationStructureKHR-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdCopyMemoryToAccelerationStructureKHR-videocoding",
}},
{Func::vkCmdWriteAccelerationStructuresPropertiesKHR, {
    "VUID-vkCmdWriteAccelerationStructuresPropertiesKHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdWriteAccelerationStructuresPropertiesKHR-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdWriteAccelerationStructuresPropertiesKHR-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdWriteAccelerationStructuresPropertiesKHR-videocoding",
}},
{Func::vkCmdTraceRaysKHR, {
    "VUID-vkCmdTraceRaysKHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdTraceRaysKHR-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdTraceRaysKHR-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdTraceRaysKHR-videocoding",
}},
{Func::vkCmdTraceRaysIndirectKHR, {
    "VUID-vkCmdTraceRaysIndirectKHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdTraceRaysIndirectKHR-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdTraceRaysIndirectKHR-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdTraceRaysIndirectKHR-videocoding",
}},
{Func::vkCmdSetRayTracingPipelineStackSizeKHR, {
    "VUID-vkCmdSetRayTracingPipelineStackSizeKHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdSetRayTracingPipelineStackSizeKHR-commandBuffer-cmdpool",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetRayTracingPipelineStackSizeKHR-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdSetRayTracingPipelineStackSizeKHR-videocoding",
}},
{Func::vkCmdDrawMeshTasksEXT, {
    "VUID-vkCmdDrawMeshTasksEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawMeshTasksEXT-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdDrawMeshTasksEXT-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawMeshTasksEXT-videocoding",
}},
{Func::vkCmdDrawMeshTasksIndirectEXT, {
    "VUID-vkCmdDrawMeshTasksIndirectEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawMeshTasksIndirectEXT-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdDrawMeshTasksIndirectEXT-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawMeshTasksIndirectEXT-videocoding",
}},
{Func::vkCmdDrawMeshTasksIndirectCountEXT, {
    "VUID-vkCmdDrawMeshTasksIndirectCountEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawMeshTasksIndirectCountEXT-commandBuffer-cmdpool",
    CMD_SCOPE_INSIDE, "VUID-vkCmdDrawMeshTasksIndirectCountEXT-renderpass",
    CMD_SCOPE_OUTSIDE, "VUID-vkCmdDrawMeshTasksIndirectCountEXT-videocoding",
}},
};
// clang-format on

// Ran on all vkCmd* commands
// Because it validate the implicit VUs that stateless can't, if this fails, it is likely
// the input is very bad and other checks will crash dereferencing null pointers
bool CoreChecks::ValidateCmd(const vvl::CommandBuffer& cb_state, const Location& loc) const {
    bool skip = false;

    auto info_it = kCommandValidationTable.find(loc.function);
    if (info_it == kCommandValidationTable.end()) {
        assert(false);
    }
    const auto& info = info_it->second;

    // Validate the given command being added to the specified cmd buffer,
    // flagging errors if CB is not in the recording state or if there's an issue with the Cmd ordering
    switch (cb_state.state) {
        case CbState::Recording:
            skip |= ValidateCmdSubpassState(cb_state, loc, info.recording_vuid);
            break;

        case CbState::InvalidComplete:
        case CbState::InvalidIncomplete:
            skip |= ReportInvalidCommandBuffer(cb_state, loc, info.recording_vuid);
            break;

        default:
            assert(loc.function != Func::Empty);
            skip |= LogError(info.recording_vuid, cb_state.Handle(), loc, "was called before vkBeginCommandBuffer().");
    }

    // Validate the command pool from which the command buffer is from that the command is allowed for queue type
    if (!HasRequiredQueueFlags(cb_state, *physical_device_state, info.queue_flags)) {
        const LogObjectList objlist(cb_state.Handle(), cb_state.command_pool->Handle());
        skip |= LogError(info.queue_vuid, objlist, loc, "%s",
                         DescribeRequiredQueueFlag(cb_state, *physical_device_state, info.queue_flags).c_str());
    }

    // Validate if command is inside or outside a render pass if applicable
    if (info.render_pass == CMD_SCOPE_INSIDE) {
        skip |= OutsideRenderPass(cb_state, loc, info.render_pass_vuid);
    } else if (info.render_pass == CMD_SCOPE_OUTSIDE) {
        skip |= InsideRenderPass(cb_state, loc, info.render_pass_vuid);
    }

    // Validate if command is inside or outside a video coding scope if applicable
    if (info.video_coding == CMD_SCOPE_INSIDE) {
        skip |= OutsideVideoCodingScope(cb_state, loc, info.video_coding_vuid);
    } else if (info.video_coding == CMD_SCOPE_OUTSIDE) {
        skip |= InsideVideoCodingScope(cb_state, loc, info.video_coding_vuid);
    }

    // Validate if command has to be recorded in a primary command buffer
    if (info.buffer_level_vuid != nullptr) {
        skip |= ValidatePrimaryCommandBuffer(cb_state, loc, info.buffer_level_vuid);
    }

    return skip;
}
// NOLINTEND
