vpath = 'https://github.com/marcomusy/vedo/tree/master/examples';

vedo_example_db =
[
    {
        pyname: 'buildmesh',    // python script name
        kbd   : '',             // python script name as appearing in back of card
        categ : 'basic',        // category
        short : 'hello world mesh',  // short description, as card footer
        long  : 'Build a simple Mesh starting from a set of points and faces.',
        imgsrc: 'images/basic/buildmesh.png',  //image path
    },
    {
        pyname: 'colorcubes',
        kbd   : '',
        categ : 'basic',
        short : 'color schemes',
        long  : 'Show a cube for each available color name. Multiple color schemes are available (matplotlib, bootstrap, vtk).',
        imgsrc: 'images/basic/colorcubes.png',
    },
    {
        pyname: 'texturecubes',
        kbd   : '',
        categ : 'basic',
        short : 'mesh textures',
        long  : 'Show a cube for each available texture name. Any jpg file can be used as texture.',
        imgsrc: 'images/basic/texturecubes.png',
    },
    {
        pyname: 'colormap_list',
        kbd   : '',
        categ : 'basic',
        short : 'color map list',
        long  : 'Show all available colormaps in vedo',
        imgsrc: 'images/basic/colormap_list.png',
    },
    {
        pyname: 'colormaps',
        kbd   : '',
        categ : 'basic',
        short : 'discrete color mapping',
        long  : 'Assign a color to each mesh vertex using a matplotlib discretized map',
        imgsrc: 'images/basic/colormaps.png',
    },
    {
        pyname: 'light_sources',
        kbd   : '',
        categ : 'basic',
        short : 'set up lights',
        long  : 'Set custom lights to a 3D scene. Direction, position, intensity and color can be specified',
        imgsrc: 'images/basic/lights.png',
    },
    {
        pyname: 'mesh_custom',
        kbd   : '',
        categ : 'basic',
        short : 'colorize a mesh',
        long  : 'Control the color and transparency of a mesh with various color map definitions',
        imgsrc: 'images/basic/mesh_custom.png',
    },
    {
        pyname: 'color_mesh_cells1',
        kbd   : '',
        categ : 'basic',
        short : 'color mesh faces',
        long  : 'Colorize faces of a Mesh passing a 1-to-1 list of colors and optionally a list of transparencies',
        imgsrc: 'images/basic/colorMeshCells.png',
    },
    {
        pyname: 'color_mesh_cells2',
        kbd   : '',
        categ : 'basic',
        short : 'color mesh faces',
        long  : 'Colorize faces of a Mesh passing a 1-to-1 list of colors and optionally a list of transparencies',
        imgsrc: 'images/basic/color_mesh_cells2.png',
    },
    {
        pyname: 'mesh_lut',
        kbd   : '',
        categ : 'basic',
        short : 'custom mesh colormap',
        long  : 'Build a custom colormap, including out-of-range, NaN  and labels colors',
        imgsrc: 'images/basic/mesh_lut.png',
    },
    {
        pyname: 'multirenderers',
        kbd   : '',
        categ : 'basic',
        short : 'multiple subrenderers',
        long  : 'Manually define the number, shape and position of the renderers inside the rendering window',
        imgsrc: 'images/basic/multirenderers.png',
    },
    {
        pyname: 'silhouette1',
        kbd   : '',
        categ : 'basic',
        short : 'draw silhouettes',
        long  : 'Generate the silhouette of a mesh as seen along a specified direction',
        imgsrc: 'images/basic/silhouette1.png',
    },
    {
        pyname: 'silhouette2',
        kbd   : '',
        categ : 'basic',
        short : 'projecting silhouettes',
        long  : 'Generate the silhouette of a mesh as seen along a specified direction',
        imgsrc: 'images/basic/silhouette2.png',
    },
    {
        pyname: 'cutter',
        kbd   : '',
        categ : 'basic',
        short : 'interactive mesh cutter',
        long  : 'Cut a mesh interactively and save the result to file',
        imgsrc: 'images/basic/cutter.gif',
    },
    {
        pyname: 'cut_freehand',
        kbd   : '',
        categ : 'basic',
        short : 'free-hand mesh cutter',
        long  : 'Cut a mesh interactively by free-hand drawing a contour',
        imgsrc: 'images/basic/cutFreeHand.gif',
    },
    {
        pyname: 'shrink',
        kbd   : '',
        categ : 'basic',
        short : 'shrink mesh triangles',
        long  : 'Shrink mesh polygons to make the inside visible',
        imgsrc: 'images/basic/shrink.png',
    },
    {
        pyname: 'boundaries',
        kbd   : '',
        categ : 'basic',
        short : 'mesh boundaries',
        long  : 'Extract points on the boundary of a mesh. Add a label to all vertices',
        imgsrc: 'images/basic/boundaries.png',
    },
    {
        pyname: 'mesh_modify',
        kbd   : '',
        categ : 'basic',
        short : 'move mesh vertices',
        long  : 'Modify mesh vertex positions',
        imgsrc: 'images/basic/mesh_modify.png',
    },
    {
        pyname: 'connected_vtx',
        kbd   : '',
        categ : 'basic',
        short : 'connected vertices',
        long  : 'Find all the vertices that are connected to a specific vertex in a mesh',
        imgsrc: 'images/basic/connVtx.png',
    },
    {
        pyname: 'largestregion',
        kbd   : '',
        categ : 'basic',
        short : 'largest surface',
        long  : 'Extract the mesh region that has the largest connected surface',
        imgsrc: 'images/basic/largestregion.png',
    },
    {
        pyname: 'fillholes',
        kbd   : '',
        categ : 'basic',
        short : 'fill mesh holes',
        long  : 'Fill holes of an input mesh, identified by locating boundary edges, linking them into loops, and triangulating',
        imgsrc: 'images/basic/fillholes.png',
    },
    {
        pyname: 'sliders1',
        kbd   : '',
        categ : 'basic',
        short : 'slider controls',
        long  : 'Use two sliders to change color and transparency of a mesh',
        imgsrc: 'images/basic/sliders1.png',
    },
    {
        pyname: 'boolean',
        kbd   : '',
        categ : 'basic',
        short : 'boolean operations',
        long  : 'Perform various Boolean operations with meshes',
        imgsrc: 'images/basic/boolean.png',
    },
    {
        pyname: 'delaunay2d',
        kbd   : '',
        categ : 'basic',
        short : 'delaunay in 2d',
        long  : 'Perform 2D triangulation using the Delaunay algorithm',
        imgsrc: 'images/basic/delaunay2d.png',
    },
    {
        pyname: 'voronoi1',
        kbd   : '',
        categ : 'basic',
        short : 'voronoi tessellation',
        long  : 'Perform 2D Voronoi tessellation of a set of input points',
        imgsrc: 'images/basic/voronoi1.png',
    },
    {
        pyname: 'flatarrow',
        kbd   : '',
        categ : 'basic',
        short : 'flat arrows',
        long  : 'Use two lines to define a flat arrow',
        imgsrc: 'images/basic/flatarrow.png',
    },
    {
        pyname: 'shadow1',
        kbd   : '',
        categ : 'basic',
        short : 'cast a simple shadow',
        long  : 'Project a shadow of two meshes on the x,y, or z wall',
        imgsrc: 'images/basic/shadow1.png',
    },
    {
        pyname: 'shadow2',
        kbd   : '',
        categ : 'basic',
        short : 'cast multiple shadows',
        long  : 'Project realistic shadows of two meshes on the xy plane',
        imgsrc: 'images/basic/shadow2.png',
    },
    {
        pyname: 'extrude',
        kbd   : '',
        categ : 'basic',
        short : 'polygon extrusion',
        long  : 'Extruding a 2D polygon along the vertical axis',
        imgsrc: 'images/basic/extrude.png',
    },
    {
        pyname: 'align1',
        kbd   : '',
        categ : 'basic',
        short : 'register two shapes',
        long  : 'Align (register) the red line to the yellow shape using the '+insertLink('ICP algorithm','en.wikipedia.org/wiki/Iterative_closest_point'),
        imgsrc: 'images/basic/align1.png',
    },
    {
        pyname: 'align2',
        kbd   : '',
        categ : 'basic',
        short : 'register point clouds',
        long  : 'Generate two random sets of points and align them using the '+insertLink('ICP algorithm','en.wikipedia.org/wiki/Iterative_closest_point'),
        imgsrc: 'images/basic/align2.png',
    },
    {
        pyname: 'align4',
        kbd   : '',
        categ : 'basic',
        short : 'procrustes registration',
        long  : 'Align a set of curves in space with the'+insertLink('Procrustes method','en.wikipedia.org/wiki/Procrustes_analysis'),
        imgsrc: 'images/basic/align4.png',
    },
    {
        pyname: 'align5',
        kbd   : '',
        categ : 'basic',
        short : 'landmark registration',
        long  : 'Transform a mesh by defining how a specific set of points (landmarks) must move',
        imgsrc: 'images/basic/align5.png',
    },
    {
        pyname: 'buttons1',
        kbd   : '',
        categ : 'basic',
        short : 'add buttons',
        long  : 'Add a button with N possible states to the rendering window calling an external function',
        imgsrc: 'images/basic/buttons.png',
    },
    {
        pyname: 'cells_within_bounds',
        kbd   : 'cells_within',
        categ : 'basic',
        short : 'find mesh cells',
        long  : 'Find cells within specified bounds along x, y and/or z',
        imgsrc: 'images/basic/cellsWithinBounds.png',
    },
    {
        pyname: 'clustering',
        kbd   : '',
        categ : 'basic',
        short : 'clustering & outliers',
        long  : 'Automatic clustering of point clouds and outliers removal',
        imgsrc: 'images/basic/clustering.png',
    },
    {
        pyname: 'pca_ellipsoid',
        kbd   : '',
        categ : 'basic',
        short : 'fit ellipsoid',
        long  : 'Fit an ellipsoid to a point cloud using PCA (Principal Component Analysis)',
        imgsrc: 'images/basic/pca.png',
    },
    {
        pyname: 'manypoints',
        kbd   : '',
        categ : 'basic',
        short : 'large point cloud (1M)',
        long  : 'Draw a very large number (1M) of points with different colors and transparency',
        imgsrc: 'images/basic/manypoints.jpg',
    },
    {
        pyname: 'manyspheres',
        kbd   : '',
        categ : 'basic',
        short : '50k sphere radii',
        long  : 'Draw a very large number (50k) of spheres or points with different colors or different radii',
        imgsrc: 'images/basic/manyspheres.jpg',
    },
    {
        pyname: 'colorlines',
        kbd   : '',
        categ : 'basic',
        short : 'color lines by scalar',
        long  : 'Color line cells using a scalar array and a matplotlib colormap',
        imgsrc: 'images/basic/colorlines.png',
    },
    {
        pyname: 'ribbon',
        kbd   : '',
        categ : 'basic',
        short : 'ribbon surface',
        long  : 'Create a ribbon-like surface by joining two lines, or one single line along its tangent',
        imgsrc: 'images/basic/ribbon.png',
    },
    {
        pyname: 'mirror',
        kbd   : '',
        categ : 'basic',
        short : 'mirror mesh',
        long  : 'Mirror a mesh along one of the Cartesian axes. Hover mouse to identify original and mirrored.',
        imgsrc: 'images/basic/mirror.png',
    },
    {
        pyname: 'delete_mesh_pts',
        kbd   : 'delete_mesh',
        categ : 'basic',
        short : 'remove points and cells',
        long  : 'Remove points and cells from a mesh which are closest to a specified point',
        imgsrc: 'images/basic/deleteMeshPoints.png',
    },
    {
        pyname: 'mousehighlight',
        kbd   : '',
        categ : 'basic',
        short : 'highlight mesh',
        long  : 'Click an object to select and highlight it',
        imgsrc: 'images/basic/mousehighlight.png',
    },
    {
        pyname: 'mousehover1',
        kbd   : '',
        categ : 'basic',
        short : 'hovering mouse',
        long  : 'Visualize scalar values interactively by hovering the mouse on a mesh',
        imgsrc: 'images/basic/mousehover1.gif',
    },
    {
        pyname: 'mousehover2',
        kbd   : '',
        categ : 'basic',
        short : 'hover and fit',
        long  : 'Interactively fit a sphere on a region of a mesh by hovering the mouse pointer on it',
        imgsrc: 'images/basic/mousehover2.gif',
    },
    {
        pyname: 'mousehover3',
        kbd   : '',
        categ : 'basic',
        short : 'world coordinates',
        long  : 'Compute 3D world coordinates from 2D screen pixel coordinates while hovering the mouse',
        imgsrc: 'images/basic/mousehover3.jpg',
    },
    {
        pyname: 'spline_tool',
        kbd   : '',
        categ : 'basic',
        short : 'interactive spline tool',
        long  : 'Modify a spline interactively by clicking and dragging the mouse',
        imgsrc: 'images/basic/spline_tool.png',
    },
    {
        pyname: 'distance2mesh',
        kbd   : '',
        categ : 'basic',
        short : 'mesh signed distance',
        long  : 'Computes the signed distance of one mesh from another and store the array in the mesh itself',
        imgsrc: 'images/basic/distance2mesh.png',
    },
    {
        pyname: 'glyphs1',
        kbd   : '',
        categ : 'basic',
        short : 'create a glyphed mesh',
        long  : 'Glyphs: for each vertex of a mesh (e.g. a sphere), attach another mesh with various orientation options',
        imgsrc: 'images/basic/glyphs.png',
    },
    {
        pyname: 'glyphs3',
        kbd   : '',
        categ : 'basic',
        short : 'create glyph symbols',
        long  : 'Glyphs: attach an oriented mesh (here a cone) to each 3D point. Colormap by vector magnitude',
        imgsrc: 'images/pyplot/glyphs3.png',
    },
    {
        pyname: 'lightings',
        kbd   : '',
        categ : 'basic',
        short : 'mesh lightings',
        long  : 'Ligthing of a mesh can be modified at will to change its appearance',
        imgsrc: 'images/basic/lightings.png',
    },
    {
        pyname: 'cartoony',
        kbd   : '',
        categ : 'basic',
        short : 'cartoony look&feel',
        long  : 'Give a cartoony appearance to a 3D polygonal mesh',
        imgsrc: 'images/basic/cartoony.png',
    },
    {
        pyname: 'ssao',
        kbd   : '',
        categ : 'basic',
        short : 'ambient occlusion',
        long  : 'Render a scene with Screen Space Ambient Occlusion (SSAO)',
        imgsrc: 'images/basic/ssao.jpg',
    },
    {
        pyname: 'surf_intersect',
        kbd   : '',
        categ : 'basic',
        short : 'intersect meshes',
        long  : 'Find the intersection line of two polygonal meshes',
        imgsrc: 'images/basic/surfIntersect.png',
    },
    {
        pyname: 'lin_interpolate',
        kbd   : '',
        categ : 'basic',
        short : 'interpolate vectors',
        long  : 'Linear interpolation of vectors which are defined at specific points in space',
        imgsrc: 'images/basic/linInterpolate.png',
    },
    {
        pyname: 'mesh_map2cell',
        kbd   : 'map2cell',
        categ : 'basic',
        short : 'map points to cells',
        long  : 'Map an array, which is originally defined on the mesh vertices, to its cells',
        imgsrc: 'images/basic/mesh_map2cell.png',
    },
    {
        pyname: 'tube_radii',
        kbd   : '',
        categ : 'basic',
        short : 'radius-varying tube',
        long  : 'Use an array to vary the radius and color of a line so that it is represented as a tube',
        imgsrc: 'images/basic/tube.png',
    },
    {
        pyname: 'rotate_image',
        kbd   : 'rotate_image',
        categ : 'basic',
        short : 'rotate a jpg image',
        long  : 'Normal jpg/png images can be loaded, cropped, rotated and positioned anywhere in 3D scenes',
        imgsrc: 'images/basic/rotateImage.png',
    },
    {
        pyname: 'background_image',
        kbd   : 'background',
        categ : 'basic',
        short : 'wallpapers',
        long  : 'Set a jpeg background image on a separate rendering layer',
        imgsrc: 'images/basic/bgImage.png',
    },
    {
        pyname: 'skybox',
        kbd   : '',
        categ : 'basic',
        short : 'skybox environment',
        long  : 'Embed a mesh into a skybox environment. Mesh lighting is by Physically Based Rendering (PBR)',
        imgsrc: 'images/basic/skybox.jpg',
    },


    /////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////ADVANCED
    {
        pyname: 'geological_model',
        kbd   : '',
        categ : 'advanced',
        short : 'geological model',
        long  : 'Recreate a complex 3D model of a geothermal reservoir in Utah (USA). Export it to a '+insertLink('webpage.','vedo.embl.es/examples/geo_scene.html'),
        imgsrc: 'images/advanced/geological_model.jpg',
    },
    {
        pyname: 'geodesic',
        kbd   : '',
        categ : 'advanced',
        short : 'geodesic lines',
        long  : 'Dijkstra algorithm to compute the geodesic: the shortest distance between two points on a surface',
        imgsrc: 'images/advanced/geodesic.png',
    },
    {
        pyname: 'moving_least_squares1D',
        kbd   : 'least_squares1d',
        categ : 'advanced',
        short : 'moving least squares 1d',
        long  : 'Use the '+insertLink('Moving Least Squares','en.wikipedia.org/wiki/Moving_least_squares')+'algorithm to project a cloud of points to a smooth line',
        imgsrc: 'images/advanced/moving_least_squares1D.png',
    },
    {
        pyname: 'moving_least_squares2D',
        kbd   : 'least_squares2d',
        categ : 'advanced',
        short : 'moving least squares 2d',
        long  : 'Use the '+insertLink('Moving Least Squares','en.wikipedia.org/wiki/Moving_least_squares')+'algorithm to project a cloud of points to a smooth surface',
        imgsrc: 'images/advanced/least_squares2D.png',
    },
    {
        pyname: 'recosurface',
        kbd   : '',
        categ : 'advanced',
        short : 'point cloud to mesh',
        long  : 'Reconstruct a triangular mesh from a noisy cloud of points.',
        imgsrc: 'images/advanced/recosurface.png',
    },
    {
        pyname: 'line2mesh_tri',
        kbd   : 'mesh_tri',
        categ : 'advanced',
        short : 'generate a tri-mesh',
        long  : 'Generate a triangular mesh from a line contour in 2D.',
        imgsrc: 'images/advanced/line2mesh_tri.jpg',
    },
    {
        pyname: 'line2mesh_quads',
        kbd   : 'mesh_quads',
        categ : 'advanced',
        short : 'generate a quad-mesh',
        long  : 'Generate a quad-mesh from a line contour in 2D.',
        imgsrc: 'images/advanced/line2mesh_quads.png',
    },
    {
        pyname: 'voronoi2',
        kbd   : '',
        categ : 'advanced',
        short : 'voronoi tessellation',
        long  : 'Perform 2D Voronoi tessellation of a set of input points and a grid',
        imgsrc: 'images/advanced/voronoi2.png',
    },
    {
        pyname: 'meshquality',
        kbd   : '',
        categ : 'advanced',
        short : 'mesh quality metrics',
        long  : 'Visualize various metrics of quality for the cells of a triangular mesh',
        imgsrc: 'images/advanced/meshquality.png',
    },
    {
        pyname: 'mesh_smoother2',
        kbd   : '',
        categ : 'advanced',
        short : 'smoothing a mesh',
        long  : 'Smoothing a mesh using different combinations of algorithms and parameters',
        imgsrc: 'images/advanced/mesh_smoother2.png',
    },
    {
        pyname: 'warp1',
        kbd   : '',
        categ : 'advanced',
        short : 'thin plate splines',
        long  : 'Thin Plate Spline transformations describe a nonlinear warping defined by source and target points',
        imgsrc: 'images/advanced/warp1.png',
    },
    {
        pyname: 'warp2',
        kbd   : '',
        categ : 'advanced',
        short : 'thin plate splines 3d',
        long  : 'Warp part of a mesh using Thin Plate Splines. Red points stay fixed while one point in space moves along the arrow',
        imgsrc: 'images/advanced/warp2.png',
    },
    {
        pyname: 'warp3',
        kbd   : '',
        categ : 'advanced',
        short : 'warping fit in 2d',
        long  : 'Two sets of landmark points define a displacement field using thin plate splines as a model',
        imgsrc: 'images/advanced/warp3.png',
    },
    {
        pyname: 'warp4a',
        kbd   : '',
        categ : 'advanced',
        short : 'interactive morphing 2d',
        long  : 'Morph/warp a 2D shape by manually setting displacement arrows',
        imgsrc: 'images/advanced/warp4.png',
    },
    {
        pyname: 'warp4b',
        kbd   : '',
        categ : 'advanced',
        short : 'interactive morphing 3d',
        long  : 'Morph/warp a 3D shape by manually assigning a set of corresponding landmarks',
        imgsrc: 'images/advanced/warp4b.jpg',
    },
    {
        pyname: 'warp5',
        kbd   : '',
        categ : 'advanced',
        short : 'quadratic fit morphing',
        long  : 'Morph source on target mesh by fitting the 18 parameters of a quadratic transformation',
        imgsrc: 'images/advanced/warp5.png',
    },
    {
        pyname: 'splitmesh',
        kbd   : '',
        categ : 'advanced',
        short : 'mesh connectivity',
        long  : 'Split a mesh by connectivity and order the pieces by their surface area',
        imgsrc: 'images/advanced/splitmesh.png',
    },
    {
        pyname: 'fitline',
        kbd   : '',
        categ : 'advanced',
        short : 'fit lines and planes',
        long  : 'Fit a line and a plane to a cloud of points in 3D',
        imgsrc: 'images/advanced/fitline.png',
    },
    {
        pyname: 'fitspheres1',
        kbd   : '',
        categ : 'advanced',
        short : 'fit a sphere',
        long  : 'Fit spheres to a region of a surface defined by n points that are closest to a given point',
        imgsrc: 'images/advanced/fitspheres1.jpg',
    },
    {
        pyname: 'convex_hull',
        kbd   : '',
        categ : 'advanced',
        short : 'convex hull',
        long  : 'Create the Convex Hull of a mesh or a set of input points ',
        imgsrc: 'images/advanced/convexHull.png',
    },
    {
        pyname: 'contours2mesh',
        kbd   : '',
        categ : 'advanced',
        short : 'countours to mesh',
        long  : 'Generate a surface mesh by joining a set of closeby countour lines',
        imgsrc: 'images/advanced/contours2mesh.png',
    },
    {
        pyname: 'interpolate_field',
        kbd   : '',
        categ : 'advanced',
        short : 'interpolate field',
        long  : 'Interpolate a vectorial field with Thin Plate Splines or Radial Basis Function. Share camera btw different windows',
        imgsrc: 'images/advanced/interpolateField.png',
    },
    {
        pyname: 'interpolate_scalar1',
        kbd   : '',
        categ : 'advanced',
        short : 'transfer mesh array',
        long  : 'Interpolate the scalar values from one mesh or point clouds object onto another one',
        imgsrc: 'images/advanced/interpolateScalar1.png',
    },
    {
        pyname: 'interpolate_scalar2',
        kbd   : '',
        categ : 'advanced',
        short : 'interpolate array',
        long  : 'Use scipy Radial Basis Function to interpolate a scalar known on a set of points on a mesh the scalar is not defined',
        imgsrc: 'images/advanced/interpolateScalar2.png',
    },
    {
        pyname: 'interpolate_scalar3',
        kbd   : '',
        categ : 'advanced',
        short : 'interpolate array',
        long  : 'Interpolate the arrays of a source mesh onto another (the ellipsoid) by averaging closest point values',
        imgsrc: 'images/advanced/interpolateScalar3.png',
    },
    {
        pyname: 'interpolate_scalar4',
        kbd   : '',
        categ : 'advanced',
        short : 'interpolate array',
        long  : 'Interpolate cell values from a quad-mesh to a tri-mesh of different resolution',
        imgsrc: 'images/advanced/interpolateScalar4.png',
    },
    {
        pyname: 'diffuse_data',
        kbd   : '',
        categ : 'advanced',
        short : 'smooth array',
        long  : 'Smooth/diffuse an array of scalars on a mesh',
        imgsrc: 'images/advanced/diffuse_data.png',
    },
    {
        pyname: 'cut_with_mesh1',
        kbd   : '',
        categ : 'advanced',
        short : 'cut mesh with mesh',
        long  : 'Cut a mesh with another mesh',
        imgsrc: 'images/advanced/cutWithMesh1.jpg',
    },
    {
        pyname: 'cut_with_points1',
        kbd   : '',
        categ : 'advanced',
        short : 'cut mesh with points',
        long  : 'Set a loop of points on a mesh to cut/select a region of it.',
        imgsrc: 'images/advanced/cutWithPoints1.png',
    },
    {
        pyname: 'cut_with_points2',
        kbd   : '',
        categ : 'advanced',
        short : 'cut mesh with loop',
        long  : 'Set a loop of points on a mesh to cut/select inside cells.',
        imgsrc: 'images/advanced/cutWithPoints2.png',
    },
    {
        pyname: 'cut_and_cap',
        kbd   : '',
        categ : 'advanced',
        short : 'cut&cap',
        long  : 'Cut a mesh with an other mesh and cap the holes',
        imgsrc: 'images/advanced/cutAndCap.png',
    },
    {
        pyname: 'gyroid',
        kbd   : '',
        categ : 'advanced',
        short : 'textured gyroid shape',
        long  : 'A textured gyroid shape cut by a sphere. Any image texture can be downloaded on the fly.',
        imgsrc: 'images/advanced/gyroid.png',
    },
    {
        pyname: 'multi_viewer2',
        kbd   : '',
        categ : 'advanced',
        short : 'multi window viewer',
        long  : 'Create two windows that can interact and share functions',
        imgsrc: 'images/advanced/multi_viewer.png',
    },
    {
        pyname: 'timer_callback2',
        kbd   : '',
        categ : 'advanced',
        short : 'play/pause application',
        long  : 'Create a simple application controlled by a timer callback function',
        imgsrc: 'images/advanced/timer_callback1.jpg',
    },
    {
        pyname: 'spline_draw',
        kbd   : '',
        categ : 'advanced',
        short : 'draw a spline',
        long  : 'Draw a spline on a Picture interactively',
        imgsrc: 'images/advanced/spline_draw.png',
    },


    /////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////// Volumetric
    /////////////////////////////////////////////////////////////////////
    {
        pyname: 'numpy2volume2',
        kbd   : '',
        categ : 'volumetric',
        short : 'numpy array to volume',
        long  : 'Create a Volume dataset from a'+insertLink('numpy','numpy.org')+'array',
        imgsrc: 'images/volumetric/numpy2volume2.png',
    },
    {
        pyname: 'numpy2volume1',
        kbd   : '',
        categ : 'volumetric',
        short : 'numpy mgrid to volume',
        long  : 'Create a Volume dataset from a'+insertLink('numpy.mgrid','numpy.org/doc/stable/reference/generated/numpy.mgrid.html')+'object',
        imgsrc: 'images/volumetric/numpy2volume1.png',
    },
    {
        pyname: 'app_isobrowser',
        kbd   : 'isobrowser',
        categ : 'volumetric',
        short : 'browse isosurfaces',
        long  : 'Peel isosurfaces from an input Volume using a slider',
        imgsrc: 'images/advanced/app_isobrowser.gif',
    },
    {
        pyname: 'app_raycaster',
        kbd   : 'raycaster',
        categ : 'volumetric',
        short : 'ray cast rendering',
        long  : 'Visualize an input Volume using ray casting in different modes',
        imgsrc: 'images/advanced/app_raycaster.gif',
    },
    {
        pyname: 'slicer1',
        kbd   : '',
        categ : 'volumetric',
        short : 'slice a volume',
        long  : 'Use sliders to control planes slicing an input volume. Create a button to change colormap',
        imgsrc: 'images/volumetric/slicer1.jpg',
    },
    {
        pyname: 'read_volume3',
        kbd   : '',
        categ : 'volumetric',
        short : '2d interactive slices',
        long  : 'Inspect a vloumetric dataset interactively by slicing 2d planes with the mouse.',
        imgsrc: 'images/volumetric/read_volume3.jpg',
    },
    {
        pyname: 'isosurfaces1',
        kbd   : '',
        categ : 'volumetric',
        short : 'isosurface sets',
        long  : 'Generate the isosurfaces corresponding to a set of thresholds. These surfaces constitute a single object',
        imgsrc: 'images/volumetric/isosurfaces.png',
    },
    {
        pyname: 'read_volume1',
        kbd   : '',
        categ : 'volumetric',
        short : 'transfer functions',
        long  : 'Load a 3D volume and set color and visibility of voxels by defining transfer functions',
        imgsrc: 'images/volumetric/read_volume1.png',
    },
    {
        pyname: 'read_volume2',
        kbd   : '',
        categ : 'volumetric',
        short : 'rendering modes',
        long  : 'Load a 3D volume and visualize it with either "composite" or "maximum-projection" rendering',
        imgsrc: 'images/volumetric/read_volume2.png',
    },
    {
        pyname: 'interpolate_volume',
        kbd   : 'interpolate_vol',
        categ : 'volumetric',
        short : 'interpolate a volume',
        long  : 'Generate a volume by interpolating a scalar which is only known on a scattered set of points',
        imgsrc: 'images/volumetric/59095175-1ec5a300-8918-11e9-8bc0-fd35c8981e2b.jpg',
    },
    {
        pyname: 'densifycloud',
        kbd   : '',
        categ : 'volumetric',
        short : 'densify point cloud',
        long  : 'Adds new points to an input point cloud. Points are created so that they are within a target distance of one another',
        imgsrc: 'images/volumetric/densifycloud.png',
    },
    {
        pyname: 'legosurface',
        kbd   : '',
        categ : 'volumetric',
        short : 'lego-style voxels',
        long  : "Represent a volume as lego blocks (voxels). Colors correspond to the volume's scalar",
        imgsrc: 'images/volumetric/56820682-da40e500-684c-11e9-8ea3-91cbcba24b3a.png',
    },
    {
        pyname: 'streamlines2',
        kbd   : '',
        categ : 'volumetric',
        short : 'stream lines',
        long  : 'Load an existing structured grid and draw the streamlines of a velocity field',
        imgsrc: 'images/volumetric/56964001-9145a500-6b5a-11e9-935b-1b2425bd7dd2.png',
    },
    {
        pyname: 'streamlines4',
        kbd   : '',
        categ : 'volumetric',
        short : 'stream lines in 2d',
        long  : 'Draw the streamlines of a 2D vector field',
        imgsrc: 'images/volumetric/81459343-b9210d00-919f-11ea-846c-152d62cba06e.png',
    },
    {
        pyname: 'office',
        kbd   : '',
        categ : 'volumetric',
        short : 'stream tubes airflow',
        long  : 'Stream tubes airflow in an office with ventilation and a burning cigarette',
        imgsrc: 'images/volumetric/56964003-9145a500-6b5a-11e9-9d9e-9736d90e1900.png',
    },
    {
        pyname: 'streamlines3',
        kbd   : '',
        categ : 'volumetric',
        short : 'OpenFOAM cavity',
        long  : 'Draw streamlines for the cavity case from the '+insertLink('OpenFOAM tutorial','cfd.direct/openfoam/user-guide/v6-cavity'),
        imgsrc: 'images/volumetric/streamlines3.png',
    },
    {
        pyname: 'tensors',
        kbd   : '',
        categ : 'volumetric',
        short : 'tensors',
        long  : 'Visualize stress tensors as oriented ellipsoids',
        imgsrc: 'images/volumetric/tensors.png',
    },
    {
        pyname: 'multiscalars',
        kbd   : '',
        categ : 'volumetric',
        short : 'scalar channels',
        long  : 'Extract one scalar channel from a volumetric dataset with multiple scalars associated to each voxel',
        imgsrc: 'images/volumetric/multiscalars.png',
    },
    {
        pyname: 'lowpassfilter',
        kbd   : '',
        categ : 'volumetric',
        short : 'low-pass filter',
        long  : 'High frequencies of the Fourier Transform are cut off in a volumetric dataset',
        imgsrc: 'images/volumetric/lowpassfilter.png',
    },
    {
        pyname: 'erode_dilate',
        kbd   : '',
        categ : 'volumetric',
        short : 'erode and dilate',
        long  : 'Erode or dilate a Volume by replacing a voxel with the max/min over an ellipsoidal neighborhood',
        imgsrc: 'images/volumetric/erode_dilate.png',
    },
    {
        pyname: 'mesh2volume',
        kbd   : '',
        categ : 'volumetric',
        short : 'binarize a volume',
        long  : 'Build a volume from a mesh where the inside voxels are set to 1 and the outside voxels are set to 0',
        imgsrc: 'images/volumetric/mesh2volume.png',
    },
    {
        pyname: 'probe_points',
        kbd   : '',
        categ : 'volumetric',
        short : 'probing points',
        long  : 'Probe a volumetric dataset with a point cloud and plot the intensity values',
        imgsrc: 'images/volumetric/probePoints.png',
    },
    {
        pyname: 'probe_line2',
        kbd   : '',
        categ : 'volumetric',
        short : 'probing line',
        long  : 'Probe a volumetric dataset with a line and plot the intensity values',
        imgsrc: 'images/volumetric/probeLine2.png',
    },
    {
        pyname: 'probe_line1',
        kbd   : '',
        categ : 'volumetric',
        short : 'probing lines',
        long  : 'Probe a volumetric dataset with a lines and color-code them',
        imgsrc: 'images/volumetric/probeLine1.png',
    },
    {
        pyname: 'slice_plane1',
        kbd   : '',
        categ : 'volumetric',
        short : 'probing plane',
        long  : 'Slice/probe a Volume with a simple oriented plane',
        imgsrc: 'images/volumetric/slicePlane1.gif',
    },
    {
        pyname: 'slice_plane2',
        kbd   : '',
        categ : 'volumetric',
        short : 'probing planes',
        long  : 'Slice/probe a Volume with multiple planes. Make low values of the scalar completely transparent',
        imgsrc: 'images/volumetric/slicePlane2.png',
    },
    {
        pyname: 'slice_plane3',
        kbd   : '',
        categ : 'volumetric',
        short : 'interactive probing',
        long  : 'Slice/probe a Volume interactively.',
        imgsrc: 'images/volumetric/slicePlane3.jpg',
    },
    {
        pyname: 'slab_vol',
        kbd   : '',
        categ : 'volumetric',
        short : 'slice a slab',
        long  : 'Average intensity over a thick "slab" of a Volume.',
        imgsrc: 'images/volumetric/slab_vol.jpg',
    },
    {
        pyname: 'slice_mesh',
        kbd   : '',
        categ : 'volumetric',
        short : 'probing mesh',
        long  : 'Slice/probe a Volume with a polygonal mesh',
        imgsrc: 'images/volumetric/sliceMesh.png',
    },
    {
        pyname: 'delaunay3d',
        kbd   : '',
        categ : 'volumetric',
        short : 'delaunay 3d',
        long  : 'Use Delaunay algorithm to generate a tetrahedral mesh of a convex surface',
        imgsrc: 'images/volumetric/delaunay3d.png',
    },
    {
        pyname: 'tetralize_surface',
        kbd   : 'tetralize',
        categ : 'volumetric',
        short : 'tetralize any surface',
        long  : 'Generate a tetrahedral mesh from an arbitrary closed polygonal surface',
        imgsrc: 'images/volumetric/tetralize_surface.jpg',
    },
    {
        pyname: 'tet_threshold',
        kbd   : '',
        categ : 'volumetric',
        short : 'tetmesh thresholding',
        long  : 'Threshold a tetrahedral mesh using a scalar array',
        imgsrc: 'images/volumetric/82767103-2500a800-9e25-11ea-8506-e583e8ec4b01.jpg',
    },
    {
        pyname: 'tet_cut1',
        kbd   : '',
        categ : 'volumetric',
        short : 'tetmesh cutting',
        long  : 'Cut a tetrahedral mesh with an arbitrary polygonal mesh',
        imgsrc: 'images/volumetric/82767107-2631d500-9e25-11ea-967c-42558f98f721.jpg',
    },
    {
        pyname: 'tet_isos_slice',
        kbd   : '',
        categ : 'volumetric',
        short : 'tetmesh slicing',
        long  : 'Slice a tetrahedral mesh with a plane',
        imgsrc: 'images/volumetric/tet_isos_slice.png',
    },
    {
        pyname: 'earth_model',
        kbd   : '',
        categ : 'volumetric',
        short : 'earth model',
        long  : 'Customized representation of a tetrahedral mesh of a Earth model',
        imgsrc: 'images/volumetric/earth_model.jpg',
    },
    {
        pyname: 'ugrid2',
        kbd   : '',
        categ : 'volumetric',
        short: 'unstructured grids',
        long : 'Cut an unstructured grid with a plane',
        imgsrc: 'images/volumetric/ugrid2.png',
    },
    {
        pyname: 'image_rgba',
        kbd   : '',
        categ : 'volumetric',
        short : 'numpy to image',
        long  : 'Create an image from a numpy array containing an alpha channel for opacity',
        imgsrc: 'images/volumetric/image_rgba.png',
    },
    {
        pyname: 'image_false_colors',
        kbd   : '',
        categ : 'volumetric',
        short : 'image false colors',
        long  : 'Generate the Mandelbrot set as a color-mapped Picture object',
        imgsrc: 'images/volumetric/image_false_colors.png',
    },
    {
        pyname: 'image_to_mesh',
        kbd   : '',
        categ : 'volumetric',
        short : 'image to mesh',
        long  : 'Transform a normal jpg/png picture into a polygonal mesh or threshold it',
        imgsrc: 'images/volumetric/image_to_mesh.jpg',
    },
    {
        pyname: 'image_probe',
        kbd   : '',
        categ : 'volumetric',
        short: 'probe image pixels',
        long : 'Probe image intensities along a set of lines',
        imgsrc: 'images/volumetric/image_probe.jpg',
    },
    {
        pyname: 'image_fft',
        kbd   : '',
        categ : 'volumetric',
        short : '2d fourier transform',
        long  : 'Perform 2D Fast Fourier Transform of an image',
        imgsrc: 'images/volumetric/image_fft.png',
    },



    /////////////////////////////////////////////////////////////////////////////////// simulations
    {
        pyname: 'spline_ease',
        kbd   : '',
        categ : 'simulations',
        short : 'spline with easing',
        long  : 'Spline a set of points to form a line of given resolution. Control point density to create an'+insertLink('easing','easings.net')+'effect.',
        imgsrc: 'images/simulations/spline_ease.gif',
    },
    {
        pyname: 'trail',
        kbd   : '',
        categ : 'simulations',
        short : 'add a trailing line',
        long  : 'Add a trailing line to a moving object',
        imgsrc: 'images/simulations/trail.gif',
    },
    {
        pyname: 'airplane2',
        kbd   : '',
        categ : 'simulations',
        short : 'airplanes',
        long  : 'Draw the shadow and trailing lines of two objects moving',
        imgsrc: 'images/simulations/57341963-b8910900-713c-11e9-898a-84b6d3712bce.gif',
    },
    {
        pyname: 'aspring1',
        kbd   : 'spring1',
        categ : 'simulations',
        short : 'dumped spring motion',
        long  : 'Simulation of a block connected to a spring in a viscous medium',
        imgsrc: 'images/simulations/50738955-7e891800-11d9-11e9-85cd-02bd4f3f13ea.gif',
    },
    {
        pyname: 'mag_field1',
        kbd   : '',
        categ : 'simulations',
        short : 'biot-savart law',
        long  : 'Drag points to compute and visualize the magnetic field generated by a wire',
        imgsrc: 'images/simulations/mag_field.png',
    },
    {
        pyname: 'grayscott',
        kbd   : '',
        categ : 'simulations',
        short : 'reaction-diffusion',
        long  : 'Turing system of reaction-diffusion between two molecules:<br>the'+insertLink('Gray-Scott','mrob.com/pub/comp/xmorphia/index.html')+'model.',
        imgsrc: 'images/simulations/grayscott.gif',
    },
    {
        pyname: 'doubleslit',
        kbd   : '',
        categ : 'simulations',
        short : 'the double slit exp.',
        long  : 'Simulation of the double slit experiment. Any number of slits of any geometry can be simulated',
        imgsrc: 'images/simulations/96374703-86c70300-1174-11eb-9bfb-431a1ae5346d.png',
    },
    {
        pyname: 'tunnelling1',
        kbd   : '',
        categ : 'simulations',
        short : 'quantum tunneling',
        long  : 'Quantum Tunneling effect using 4th order Runge-Kutta method with arbitrary potential shape',
        imgsrc: 'images/simulations/96375030-e0c8c800-1176-11eb-8fde-83a65de41330.gif',
    },
    {
        pyname: 'tunnelling2',
        kbd   : '',
        categ : 'simulations',
        short : 'quantum grid',
        long  : 'Evolution of a particle in a box hitting a potential barrier of sinusoidal shape',
        imgsrc: 'images/simulations/tunneling2.gif',
    },
    {
        pyname: 'particle_simulator',
        kbd   : 'particle_sim',
        categ : 'simulations',
        short : 'particle scattering',
        long  : 'Rutherford scattering. Simulate interacting charged particles in 3D space',
        imgsrc: 'images/simulations/50738891-db380300-11d8-11e9-84c2-0f55be7228f1.gif',
    },
    {
        pyname: 'lorenz',
        kbd   : '',
        categ : 'simulations',
        short : 'Lorenz attractor',
        long  : 'The most classic'+insertLink('Lorenz attractor','en.wikipedia.org/wiki/Lorenz_system'),
        imgsrc: 'images/simulations/lorenz.png',
    },
    {
        pyname: 'fourier_epicycles',
        kbd   : 'epicycles',
        categ : 'simulations',
        short : 'fourier epicycles',
        long  : 'Fourier reconstruction of a 2D shape showing the '+insertLink('epicycle components','thecodingtrain.com/CodingChallenges/130.2-fourier-transform-drawing.html'),
        imgsrc: 'images/simulations/fourier_epicycles.gif',
    },
    {
        pyname: 'pendulum_ode',
        kbd   : '',
        categ : 'simulations',
        short : 'double pendulum in 2d',
        long  : 'Simulation of a composite pendulum by solving the corresponding set of ODE',
        imgsrc: 'images/simulations/pendulum_ode.gif',
    },
    {
        pyname: 'pendulum_3d',
        kbd   : '',
        categ : 'simulations',
        short : 'double pendulum in 3d',
        long  : 'Simulation of a '+ insertLink('composite pendulum','www.youtube.com/watch?v=MtG9cueB548') +' with lagrangian mechanics in 3D',
        imgsrc: 'images/simulations/pendulum_3d.gif',
    },
    {
        pyname: 'multiple_pendulum',
        kbd   : '',
        categ : 'simulations',
        short : 'multiple pendulum',
        long  : 'Multiple pendulum simulation by simple Euler integration',
        imgsrc: 'images/simulations/multiple_pendulum.gif',
    },
    {
        pyname: 'gyroscope1',
        kbd   : '',
        categ : 'simulations',
        short : 'hanging gyroscope',
        long  : 'Simulation of a gyroscope hanging from a spring',
        imgsrc: 'images/simulations/39766016-85c1c1d6-52e3-11e8-8575-d167b7ce5217.gif',
    },
    {
        pyname: 'wave_equation1d',
        kbd   : '',
        categ : 'simulations',
        short : 'coupled oscillators',
        long  : 'Simulate a set of coupled oscillators to compare two integration schemes: Euler vs. Runge-Kutta4',
        imgsrc: 'images/simulations/39360796-ea5f9ef0-4a1f-11e8-85cb-f3e21072c7d5.gif',
    },
    {
        pyname: 'wave_equation2d',
        kbd   : '',
        categ : 'simulations',
        short : '2d waves',
        long  : 'Solve the 2D wave equation using finite differences and forward Euler method',
        imgsrc: 'images/simulations/wave2d.gif',
    },
    {
        pyname: 'brownian2d',
        kbd   : '',
        categ : 'simulations',
        short : 'brownian motion',
        long  : 'Motion of a big brownian  particle in a swarm of small particles in 2D',
        imgsrc: 'images/simulations/50738948-73ce8300-11d9-11e9-8ef6-fc4f64c4a9ce.gif',
    },
    {
        pyname: 'gas',
        kbd   : '',
        categ : 'simulations',
        short : 'gas in a toroidal tank',
        long  : 'A model of an ideal gas with hard-sphere collisions',
        imgsrc: 'images/simulations//50738954-7e891800-11d9-11e9-95aa-67c92ca6476b.gif',
    },
    {
        pyname: 'volterra',
        kbd   : '',
        categ : 'simulations',
        short : 'lotka-volterra model',
        long  : 'The Lotka-Volterra model where: x is the number of preys and y the number of predators',
        imgsrc: 'images/simulations/volterra.png',
    },
    {
        pyname: 'drag_chain',
        kbd   : '',
        categ : 'simulations',
        short : 'forward kinematics',
        long  : 'Move the mouse over a 3D surface to drag the chain of rigid segments',
        imgsrc: 'images/simulations/drag_chain.gif',
    },
    {
        pyname: 'optics_main2',
        kbd   : '',
        categ : 'simulations',
        short : 'optics simulation',
        long  : 'Simulation of an optical system with lenses of arbitrary shapes and orientations',
        imgsrc: 'images/simulations/optics_main2.png',
    },
    {
        pyname: 'optics_main3',
        kbd   : '',
        categ : 'simulations',
        short : 'the butterfly effect',
        long  : 'The '+insertLink('butterfly effect','www.youtube.com/watch?v=kBow0kTVn3s')+' with cylindrical mirrors, a laser and a photon detector',
        imgsrc: 'images/simulations/optics_main3.gif',
    },
    {
        pyname: 'self_org_maps2d',
        kbd   : 'org_maps2d',
        categ : 'simulations',
        short : 'self organizing maps',
        long  : 'Self organizing maps'+insertLink('(SOM):','en.wikipedia.org/wiki/Self-organizing_map')+'a type of artificial neural network trained by unsupervised learning',
        imgsrc: 'images/simulations/self_org_maps2d.gif',
    },
    {
        pyname: 'value_iteration',
        kbd   : 'value_iter',
        categ : 'simulations',
        short : 'solve a random maze',
        long  : 'Solve a random maze with Markovian Decision Process'+insertLink('(MDP)','en.wikipedia.org/wiki/Markov_decision_process'),
        imgsrc: 'images/simulations/value_iteration.png',
    },


    ///////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////// plotting
    ///////////////////////////////////////////////////////////
    {
        pyname: 'earthquake_browser',
        kbd   : 'earthquake',
        categ : 'plotting',
        short : "earthquake browser",
        long  : 'Visualize magnitude 2.5+ earthquakes in the past 30 days via a slider. Areas are proportional to energy release',
        imgsrc: 'images/pyplot/earthquake_browser.jpg',
    },
    {
        pyname: 'caption',
        kbd   : '',
        categ : 'plotting',
        short : 'add 2d captions',
        long  : 'Attach a 2D caption to an object and use Chinese, Japanese and Russian fonts',
        imgsrc: 'images/pyplot/caption.png',
    },
    {
        pyname: 'fonts3d',
        kbd   : '',
        categ : 'plotting',
        short : 'polygonal 3d fonts',
        long  : 'Visualize all available 2D and 3D polygonal fonts (check for more '+insertLink('here','vedo.embl.es/fonts')+')',
        imgsrc: 'images/pyplot/fonts3d.png',
    },
    {
        pyname: 'latex',
        kbd   : '',
        categ : 'plotting',
        short : 'latex formulas',
        long  : 'Generate an expression image from standard Latex syntax',
        imgsrc: 'images/pyplot/latex.png',
    },
    {
        pyname: 'custom_axes1',
        kbd   : '',
        categ : 'plotting',
        short : 'customize axes',
        long  : 'Create customized axes with more than 40 paramenter options',
        imgsrc: 'images/pyplot/customAxes1.png',
    },
    {
        pyname: 'custom_axes2',
        kbd   : '',
        categ : 'plotting',
        short : 'invert axes',
        long  : 'Shift and invert axes direction and labels',
        imgsrc: 'images/pyplot/customAxes2.png',
    },
    {
        pyname: 'custom_axes3',
        kbd   : '',
        categ : 'plotting',
        short : 'shift axis planes',
        long  : 'Cartesian planes can be displaced from their lower-range default positions',
        imgsrc: 'images/pyplot/customAxes3.png',
    },
    {
        pyname: 'custom_axes4',
        kbd   : '',
        categ : 'plotting',
        short : 'axes for all',
        long  : 'Create individual axes for each object in a scene. Access any element to change its size and color',
        imgsrc: 'images/pyplot/customIndividualAxes.png',
    },
    {
        pyname: 'markpoint',
        kbd   : '',
        categ : 'plotting',
        short : 'follow the camera',
        long  : 'Lock an object orientation to constantly face the scene camera',
        imgsrc: 'images/pyplot/markpoint.jpg',
    },
    {
        pyname: 'scatter2',
        kbd   : '',
        categ : 'plotting',
        short : 'variable marker sizes',
        long  : 'A scatter plot with marker size proportional to sin(2x) red level proportional to cos(2x)',
        imgsrc: 'images/pyplot/scatter2.png',
    },
    {
        pyname: 'scatter3',
        kbd   : '',
        categ : 'plotting',
        short : 'scatter plot',
        long  : 'Create a scatter plot to overlay three different distributions of points',
        imgsrc: 'images/pyplot/scatter3.png',
    },
    {
        pyname: 'plot_errbars',
        kbd   : '',
        categ : 'plotting',
        short : 'plot styles',
        long  : 'Superpose 1D plots with different line and marker styles',
        imgsrc: 'images/pyplot/plot_errbars.png',
    },
    {
        pyname: 'plot_pip',
        kbd   : '',
        categ : 'plotting',
        short : 'picture in picture',
        long  : 'Picture in picture plotting',
        imgsrc: 'images/pyplot/plot_pip.png',
    },
    {
        pyname: 'fit_polynomial1',
        kbd   : '',
        categ : 'plotting',
        short : 'linear fit',
        long  : 'Linear fitting. Use a MonteCarlo + boostrap technique to obtain <b>correct</b> errors and error bands',
        imgsrc: 'images/pyplot/fitPolynomial1.png',
    },
    {
        pyname: 'fit_polynomial2',
        kbd   : '',
        categ : 'plotting',
        short : 'fit data w/ error bars',
        long  : 'Polynomial fitting. Use a MonteCarlo + boostrap technique to obtain <b>correct</b> errors and error bands',
        imgsrc: 'images/pyplot/fitPolynomial2.png',
    },
    {
        pyname: 'fit_erf',
        kbd   : '',
        categ : 'plotting',
        short : 'fit data w/ error bars',
        long  : 'Fit data with error bars to a custom function. Add labels to the figure.',
        imgsrc: 'images/pyplot/fit_erf.png',
    },
    {
        pyname: 'fit_curve',
        kbd   : '',
        categ : 'plotting',
        short : 'fit data w/ error bars',
        long  : 'Fitting a curve to a dataset. Add a legend to the figure.',
        imgsrc: 'images/pyplot/fit_curve.png',
    },
    {
        pyname: 'plot_errband',
        kbd   : 'errband',
        categ : 'plotting',
        short : 'line with error bands',
        long  : 'Plotting continuous functions with known error bands',
        imgsrc: 'images/pyplot/plot_errband.png',
    },
    {
        pyname: 'plot_extra_yaxis',
        kbd   : 'extra_yaxis',
        categ : 'plotting',
        short : 'extra y-axis',
        long  : 'Add a secondary y-axis for units conversion to a plot and embed it in the 3D world coords system',
        imgsrc: 'images/pyplot/plot_extra_yaxis.png',
    },
    {
        pyname: 'fit_circle',
        kbd   : '',
        categ : 'plotting',
        short : 'fit circles in 3d',
        long  : 'Fast, analytic fitting of a circle in 3D. Compute the signed curvature of a curve in space.',
        imgsrc: 'images/pyplot/fitCircle.png',
    },
    {
        pyname: 'lines_intersect',
        kbd   : '',
        categ : 'plotting',
        short : 'coplanar intersections',
        long  : 'Find the intersection points of two coplanar lines',
        imgsrc: 'images/pyplot/lines_intersect.png',
    },
    {
        pyname: 'intersect2d',
        kbd   : '',
        categ : 'plotting',
        short : 'intersect triangles',
        long  : 'Find the overlapping area of 2 triangles',
        imgsrc: 'images/pyplot/intersect2d.png',
    },
    {
        pyname: 'explore5d',
        kbd   : '',
        categ : 'plotting',
        short : 'point cloud analysis',
        long  : 'Read a data from ascii file and make a simple analysis visualizing 3 of the 5 dimensions of the dataset',
        imgsrc: 'images/pyplot/explore5d.png',
    },
    {
        pyname: 'plot_density2d',
        kbd   : 'density2d',
        categ : 'plotting',
        short : 'density plot in 2d',
        long  : 'Density plot from a distribution of points in 2D',
        imgsrc: 'images/pyplot/plot_density2d.png',
    },
    {
        pyname: 'plot_density3d',
        kbd   : 'density3d',
        categ : 'plotting',
        short : 'density plot in 3d',
        long  : 'A volumetric density plot from a distribution of points in 3D',
        imgsrc: 'images/pyplot/plot_density3d.png',
    },
    {
        pyname: 'plot_density4d',
        kbd   : 'density4d',
        categ : 'plotting',
        short : 'density plot in 4d',
        long  : 'Plot the time evolution of a density field in space',
        imgsrc: 'images/pyplot/plot_density4d.gif',
    },
    {
        pyname: 'goniometer',
        kbd   : '',
        categ : 'plotting',
        short : 'goniometer',
        long  : 'A 3D-ruler axis style, a vignette and a goniometer',
        imgsrc: 'images/pyplot/goniometer.png',
    },
    {
        pyname: 'graph_network',
        kbd   : '',
        categ : 'plotting',
        short : 'graph network',
        long  : 'Optimize and visualize a 2D/3D network with its properties',
        imgsrc: 'images/pyplot/graph_network.png',
    },
    {
        pyname: 'graph_lineage',
        kbd   : '',
        categ : 'plotting',
        short : 'lineage graph',
        long  : 'Generate a lineage graph of cell divisions',
        imgsrc: 'images/pyplot/graph_lineage.png',
    },
    {
        pyname: 'plot_fxy1',
        kbd   : 'fxy1',
        categ : 'plotting',
        short : 'plot real/complex func.',
        long  : 'Draw z = f(x,y) surface specified as a string or as a reference to an external function.',
        imgsrc: 'images/pyplot/plot_fxy.png',
    },
    {
        pyname: 'plot_fxy2',
        kbd   : 'fxy2',
        categ : 'plotting',
        short : 'plot real/complex func.',
        long  : 'Draw z = f(x,y) surface specified as a string or as a reference to an external function.',
        imgsrc: 'images/pyplot/plot_fxy2.jpg',
    },
    {
        pyname: 'isolines',
        kbd   : '',
        categ : 'plotting',
        short : 'isolines and gradients',
        long  : 'Draw the isolines and isobands of a scalar field on a surface. Compute the gradient of the field.' ,
        imgsrc: 'images/pyplot/isolines.png',
    },
    {
        pyname: 'histo_1d_b',
        kbd   : '',
        categ : 'plotting',
        short : 'simple 1d histogram',
        long  : 'Create and overlay a simple 1D histogram with error bars',
        imgsrc: 'images/pyplot/histo_1D.png',
    },
    {
        pyname: 'histo_gauss',
        kbd   : '',
        categ : 'plotting',
        short : 'histograms and curves',
        long  : 'Create and overlay a simple 1D histogram with fitting curves',
        imgsrc: 'images/pyplot/histo_gauss.png',
    },
    {
        pyname: 'histo_pca',
        kbd   : '',
        categ : 'plotting',
        short : 'histogram along axis',
        long  : '1D histogram of a distribution along a PCA axis',
        imgsrc: 'images/pyplot/histo_pca.png',
    },
    {
        pyname: 'plot_bars',
        kbd   : '',
        categ : 'plotting',
        short : 'bar plot style',
        long  : 'A bar-style plot. Useful to plot categories.',
        imgsrc: 'images/pyplot/plot_bars.png',
    },
    {
        pyname: 'histo_2d_a',
        kbd   : '',
        categ : 'plotting',
        short : 'histogram in 2d',
        long  : 'Histogram of two independent variables',
        imgsrc: 'images/pyplot/histo_2D.png',
    },
    {
        pyname: 'np_matrix',
        kbd   : 'matrix',
        categ : 'plotting',
        short : 'plot numpy arrays',
        long  : 'Visualize a numpy array, or a categorical 2D scalar',
        imgsrc: 'images/pyplot/np_matrix.png',
    },
    {
        pyname: 'histo_hexagonal',
        kbd   : 'hexagonal',
        categ : 'plotting',
        short : 'histogram in 2d',
        long  : 'Histogram of 2 independent variables in hexagonal shaped bins',
        imgsrc: 'images/pyplot/histo_hexagonal.png',
    },
    {
        pyname: 'histo_3d',
        kbd   : '',
        categ : 'plotting',
        short : 'histogram in 3d',
        long  : 'Histogram of 3 independent variables',
        imgsrc: 'images/pyplot/histo_3D.png',
    },
    {
        pyname: 'plot_hexcells',
        kbd   : 'plot_hex',
        categ : 'plotting',
        short : 'hex bar plot',
        long : 'Plotting of 2  independent variables in hexagonal shaped bars',
        imgsrc: 'images/pyplot/plot_hexcells.png',
    },
    {
        pyname: 'plot_spheric',
        kbd   : '',
        categ : 'plotting',
        short : 'spherical coords plot',
        long  : 'Surface plotting in spherical coordinates. Spherical harmonic function is Y(l=2, m=0)',
        imgsrc: 'images/pyplot/plot_spheric.png',
    },
    {
        pyname: 'quiver',
        kbd   : '',
        categ : 'plotting',
        short : 'quiver plot',
        long  : 'A simple quiver-style plot',
        imgsrc: 'images/pyplot/quiver.png',
    },
    {
        pyname: 'plot_stream',
        kbd   : '',
        categ : 'plotting',
        short : 'stream lines',
        long  : 'Plot streamlines of the 2D field starting from a given set  of seeding points ',
        imgsrc: 'images/pyplot/plot_stream.png',
    },
    {
        pyname: 'histo_violin',
        kbd   : '',
        categ : 'plotting',
        short : 'violin style',
        long  : 'A "violin" style plot of a few well known statistical distributions',
        imgsrc: 'images/pyplot/histo_violin.png',
    },
    {
        pyname: 'whiskers',
        kbd   : '',
        categ : 'plotting',
        short : 'whisker-style plot',
        long  : 'Whisker-style plot with quantiles indication (horizontal line shows the mean value)',
        imgsrc: 'images/pyplot/whiskers.png',
    },
    {
        pyname: 'anim_lines',
        kbd   : '',
        categ : 'plotting',
        short : 'temporal data plot',
        long  : 'Animated plot showing the evolution of multiple temporal data sets',
        imgsrc: 'images/pyplot/anim_lines.gif',
    },
    {
        pyname: 'triangulate2d',
        kbd   : '',
        categ : 'plotting',
        short : 'triangulate areas',
        long  : 'Triangulate arbitrary line contours in 2D. The contours may be concave and even contain holes',
        imgsrc: 'images/pyplot/triangulate2d.png',
    },
    {
        pyname: 'donut',
        kbd   : '',
        categ : 'plotting',
        short : 'donut plot',
        long  : 'Create a "donut"-style plot with labels',
        imgsrc: 'images/pyplot/donut.png',
    },
    {
        pyname: 'plot_polar',
        kbd   : '',
        categ : 'plotting',
        short : 'splined polar plot',
        long  : 'Create a polar function plot with optional splining of the coordinates.',
        imgsrc: 'images/pyplot/plot_polar.png',
    },
    {
        pyname: 'histo_polar',
        kbd   : '',
        categ : 'plotting',
        short : 'polar histogram',
        long  : 'Create a polar histogram with error bars and/or color mapping',
        imgsrc: 'images/pyplot/histo_polar.png',
    },
    {
        pyname: 'histo_spheric',
        kbd   : '',
        categ : 'plotting',
        short : 'spherical histogram',
        long  : 'Create a polar histogram with elevation and/or color mapping',
        imgsrc: 'images/pyplot/histo_spheric.png',
    },


    /////////////////////////////////////////////////other
    {
        pyname: 'make_video',
        kbd   : '',
        categ : 'other',
        short : 'video shooting',
        long  : 'Make a video by setting a sequence of camera positions or by adding individual frames',
        imgsrc: 'images/other/makeVideo.gif',
    },
    {
        pyname: 'clone2d',
        kbd   : '',
        categ : 'other',
        short : '2D clone copies',
        long  : 'Make a static 2D copy of a 3D mesh and place it anywhere in the rendering window',
        imgsrc: 'images/other/clone2d.png',
    },
    {
        pyname: 'inset',
        kbd   : '',
        categ : 'other',
        short : 'inset rendering',
        long  : 'Render meshes and other custom objects into inset frames (which can optionally be dragged)',
        imgsrc: 'images/other/inset.png',
    },
    {
        pyname: 'flag_labels1',
        kbd   : '',
        categ : 'other',
        short : 'add flags to objects',
        long  : 'Add a flag-style label and/or add a flagpole indicator which can follow the camera',
        imgsrc: 'images/other/flag_labels.png',
    },
    {
        pyname: 'flag_labels2',
        kbd   : '',
        categ : 'other',
        short : 'add flags to objects',
        long  : 'Add a flag-post style indicator which can follow the camera',
        imgsrc: 'images/other/flag_labels2.png',
    },
    {
        pyname: 'qt_window2',
        kbd   : '',
        categ : 'other',
        short : 'Qt toolkit',
        long  : 'A minimal example of how to embed a rendering window into a '+insertLink('Qt','www.qt.io/')+'application',
        imgsrc: 'images/other/qt_window2.png',
    },
    {
        pyname: 'spherical_harmonics1',
        kbd   : 'harmonics1',
        categ : 'other',
        short : 'spherical harmonics',
        long  : 'Expand and reconstruct any surface (here a simple box) into'+insertLink('spherical harmonics','en.wikipedia.org/wiki/Spherical_harmonics')+'with'+insertLink('SHTOOLS','shtools.oca.eu/shtools/public/index.html') ,
        imgsrc: 'images/other/spherical_harmonics1.png',
    },
    {
        pyname: 'ellipt_fourier_desc',
        kbd   : 'harmonics1',
        categ : 'other',
        short : 'elliptic fourier',
        long  : 'Reconstruct a line with '+insertLink('Elliptic Fourier Descriptors','github.com/hbldh/pyefd'),
        imgsrc: 'images/other/ellipt_fourier_desc.png',
    },
    {
        pyname: 'nevergrad_opt',
        kbd   : '',
        categ : 'other',
        short : 'nevergrad library',
        long  : 'Visulization of a 2D minimization problem solved by '+insertLink('nevergrad','github.com/facebookresearch/nevergrad') ,
        imgsrc: 'images/other/nevergrad_opt.png',
    },
    {
        pyname: 'iminuit1',
        kbd   : '',
        categ : 'other',
        short : 'iminuit library',
        long  : 'Visulization of a 3D minimization problem solved by '+insertLink('iminuit','github.com/scikit-hep/iminuit') ,
        imgsrc: 'images/other/iminuit1.jpg',
    },
    {
        pyname: 'trimesh/section',
        kbd   : 'section',
        categ : 'other',
        short : 'trimesh library',
        long  : 'Section of a model showing how to interface vedo to the'+insertLink('trimesh library','github.com/mikedh/trimesh'),
        imgsrc: 'images/other/section.png',
    },
    {
        pyname: 'meshio_read',
        kbd   : '',
        categ : 'other',
        short : 'meshio library',
        long  : 'Interface vedo to the'+insertLink('meshio library','github.com/nschloe/meshio'),
        imgsrc: 'images/other/meshio_read.png',
    },
    {
        pyname: 'pymeshlab1',
        kbd   : '',
        categ : 'other',
        short : 'pymeshlab library',
        long  : 'Use vedo with the'+insertLink('pymeshlab library','github.com/cnr-isti-vclab/PyMeshLab'),
        imgsrc: 'images/other/pymeshlab1.jpg',
    },
    {
        pyname: 'madcad1',
        kbd   : '',
        categ : 'other',
        short : 'pymadcad library',
        long  : 'Use vedo with the'+insertLink('madcad library','pymadcad.readthedocs.io/en/latest/index.html'),
        imgsrc: 'images/other/madcad1.png',
    },
    {
        pyname: 'pygeodesic1',
        kbd   : '',
        categ : 'other',
        short : 'pygeodesic library',
        long  : 'Compute geodesic distance between any points on a surface with the'+insertLink('pygeodesic library','github.com/mhogg/pygeodesic'),
        imgsrc: 'images/other/pygeodesic1.jpg',
    },
    {
        pyname: 'pygmsh_cut',
        kbd   : 'pygmsh',
        categ : 'other',
        short : 'pygmsh library',
        long  : 'Use vedo with the'+insertLink('pygmsh library','github.com/nschloe/pygmsh'),
        imgsrc: 'images/other/pygmsh_cut.png',
    },
    {
        pyname: 'tetgen1',
        kbd   : '',
        categ : 'other',
        short : 'tetgenpy library',
        long  : 'Interface vedo to the'+insertLink('tetgenpy','github.com/tataratat/tetgenpy')+'library to create tetrahedral meshes.',
        imgsrc: 'images/other/tetgen1.png',
    },
    {
        pyname: 'remesh_ACVD',
        kbd   : 'acvd',
        categ : 'other',
        short : 'pyvista library',
        long  : 'Interface vedo to the'+insertLink('pyvista','github.com/pyvista/pyvista')+'and'+insertLink('pyacvd', 'github.com/akaszynski/pyacvd')+'libraries.',
        imgsrc: 'images/other/remesh_ACVD.png',
    },
    {
        pyname: 'fast_simpl',
        kbd   : '',
        categ : 'other',
        short : 'fast mesh decimation',
        long  : 'Use the'+insertLink('fast-simplification','github.com/pyvista/fast-simplification')+'lib to decimate a mesh and transfer data defined on the original vertices.',
        imgsrc: 'images/other/fast_decim.jpg',
    },
    {
        pyname: 'napari1',
        kbd   : '',
        categ : 'other',
        short : 'napari library',
        long  : 'Visualize a vedo mesh in the '+insertLink('napari','napari.org/')+' image viewer. Check out also the '+insertLink('napari-vedo plugin','github.com/jo-mueller/napari-vedo-bridge')+'for napari.',
        imgsrc: 'images/other/napari1.png',
    },
    {
        pyname: 'magic-class1',
        kbd   : '',
        categ : 'other',
        short : 'magic-class library',
        long  : 'Visualize objects using the '+insertLink('magic-class','github.com/hanjinliu/magic-class')+' library.',
        imgsrc: 'images/other/magic-class1.png',
    },
    {
        pyname: 'dolfin/elasticity2',
        kbd   : '',
        categ : 'other',
        short : 'hyperelastic model',
        long  : 'Model deformation of an (hyper)elastic with '+insertLink('FEniCS','fenicsproject.org'),
        imgsrc: 'images/other/ex06_elasticity2.png',
    },
    {
        pyname: 'dolfin/elastodynamics',
        kbd   : 'elastodynamics',
        categ : 'other',
        short : 'elasto-dynamics',
        long  : 'Time-integration of the elastodynamics equation with '+insertLink('FEniCS','fenicsproject.org'),
        imgsrc: 'images/other/elastodynamics.gif',
    },
    {
        pyname: 'dolfin/awefem',
        kbd   : 'awefem',
        categ : 'other',
        short : '2D wave equation',
        long  : 'Solve the constant velocity scalar wave equation in an arbitrary number of dimensions using '+insertLink('FEniCS','fenicsproject.org'),
        imgsrc: 'images/feats/fenics1.gif',
    },
    {
        pyname: 'dolfin/heatconv',
        kbd   : 'heatconv',
        categ : 'other',
        short : 'heat equation',
        long  : 'Heat equation in a moving media  with '+insertLink('FEniCS','fenicsproject.org'),
        imgsrc: 'images/other/heatconv.gif',
    },
    {
        pyname: 'icon',
        kbd   : '',
        categ : 'other',
        short : 'icons and logos',
        long  : 'Make a icon to indicate orientation and place it in one of the 4 corners within the same renderer',
        imgsrc: 'images/other/icon.png',
    },

];
