/**
 *
 */
package org.jboss.cache.eviction;

import org.jboss.cache.config.ConfigurationComponent;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.EvictionPolicyConfig;

/**
 * Configuration class for {@link NullEvictionPolicy}.
 *
 * @author Brian Stansberry
 */
public class NullEvictionPolicyConfig
      extends ConfigurationComponent
      implements EvictionPolicyConfig
{

   private static final long serialVersionUID = -6591180473728241737L;

   /**
    * Returns {@link NullEvictionPolicy}.
    */
   public String getEvictionPolicyClass()
   {
      return NullEvictionPolicy.class.getName();
   }

   /**
    * No-op
    */
   public void reset()
   {
      // no-op
   }

   /**
    * No-op
    */
   public void validate() throws ConfigurationException
   {
      // no-op
   }

}
