
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQListWidgetItem.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QListWidgetItem>
#include <QBrush>
#include <QDataStream>
#include <QFont>
#include <QIcon>
#include <QListWidget>
#include <QSize>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QListWidgetItem

// QBrush QListWidgetItem::background()


static void _init_f_background_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QBrush > ();
}

static void _call_f_background_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QBrush > ((QBrush)((QListWidgetItem *)cls)->background ());
}


// Qt::CheckState QListWidgetItem::checkState()


static void _init_f_checkState_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::CheckState>::target_type > ();
}

static void _call_f_checkState_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::CheckState>::target_type > ((qt_gsi::Converter<Qt::CheckState>::target_type)qt_gsi::CppToQtAdaptor<Qt::CheckState>(((QListWidgetItem *)cls)->checkState ()));
}


// QListWidgetItem *QListWidgetItem::clone()


static void _init_f_clone_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QListWidgetItem * > ();
}

static void _call_f_clone_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QListWidgetItem * > ((QListWidgetItem *)((QListWidgetItem *)cls)->clone ());
}


// QVariant QListWidgetItem::data(int role)


static void _init_f_data_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("role");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_data_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QVariant > ((QVariant)((QListWidgetItem *)cls)->data (arg1));
}


// QFlags<Qt::ItemFlag> QListWidgetItem::flags()


static void _init_f_flags_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::ItemFlag> > ();
}

static void _call_f_flags_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::ItemFlag> > ((QFlags<Qt::ItemFlag>)((QListWidgetItem *)cls)->flags ());
}


// QFont QListWidgetItem::font()


static void _init_f_font_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFont > ();
}

static void _call_f_font_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFont > ((QFont)((QListWidgetItem *)cls)->font ());
}


// QBrush QListWidgetItem::foreground()


static void _init_f_foreground_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QBrush > ();
}

static void _call_f_foreground_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QBrush > ((QBrush)((QListWidgetItem *)cls)->foreground ());
}


// QIcon QListWidgetItem::icon()


static void _init_f_icon_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QIcon > ();
}

static void _call_f_icon_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QIcon > ((QIcon)((QListWidgetItem *)cls)->icon ());
}


// bool QListWidgetItem::isHidden()


static void _init_f_isHidden_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isHidden_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QListWidgetItem *)cls)->isHidden ());
}


// bool QListWidgetItem::isSelected()


static void _init_f_isSelected_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSelected_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QListWidgetItem *)cls)->isSelected ());
}


// QListWidget *QListWidgetItem::listWidget()


static void _init_f_listWidget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QListWidget * > ();
}

static void _call_f_listWidget_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QListWidget * > ((QListWidget *)((QListWidgetItem *)cls)->listWidget ());
}


// bool QListWidgetItem::operator<(const QListWidgetItem &other)


static void _init_f_operator_lt__c2817 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QListWidgetItem & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_lt__c2817 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QListWidgetItem &arg1 = gsi::arg_reader<const QListWidgetItem & >() (args, heap);
  ret.write<bool > ((bool)((QListWidgetItem *)cls)->operator< (arg1));
}


// QListWidgetItem &QListWidgetItem::operator=(const QListWidgetItem &other)


static void _init_f_operator_eq__2817 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QListWidgetItem & > (argspec_0);
  decl->set_return<QListWidgetItem & > ();
}

static void _call_f_operator_eq__2817 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QListWidgetItem &arg1 = gsi::arg_reader<const QListWidgetItem & >() (args, heap);
  ret.write<QListWidgetItem & > ((QListWidgetItem &)((QListWidgetItem *)cls)->operator= (arg1));
}


// void QListWidgetItem::read(QDataStream &in)


static void _init_f_read_1697 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("in");
  decl->add_arg<QDataStream & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_read_1697 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDataStream &arg1 = gsi::arg_reader<QDataStream & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QListWidgetItem *)cls)->read (arg1);
}


// void QListWidgetItem::setBackground(const QBrush &brush)


static void _init_f_setBackground_1910 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("brush");
  decl->add_arg<const QBrush & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBackground_1910 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QBrush &arg1 = gsi::arg_reader<const QBrush & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QListWidgetItem *)cls)->setBackground (arg1);
}


// void QListWidgetItem::setCheckState(Qt::CheckState state)


static void _init_f_setCheckState_1740 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<const qt_gsi::Converter<Qt::CheckState>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCheckState_1740 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::CheckState>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::CheckState>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QListWidgetItem *)cls)->setCheckState (qt_gsi::QtToCppAdaptor<Qt::CheckState>(arg1).cref());
}


// void QListWidgetItem::setData(int role, const QVariant &value)


static void _init_f_setData_2778 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("role");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setData_2778 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QVariant &arg2 = gsi::arg_reader<const QVariant & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QListWidgetItem *)cls)->setData (arg1, arg2);
}


// void QListWidgetItem::setFlags(QFlags<Qt::ItemFlag> flags)


static void _init_f_setFlags_2222 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags");
  decl->add_arg<QFlags<Qt::ItemFlag> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFlags_2222 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<Qt::ItemFlag> arg1 = gsi::arg_reader<QFlags<Qt::ItemFlag> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QListWidgetItem *)cls)->setFlags (arg1);
}


// void QListWidgetItem::setFont(const QFont &font)


static void _init_f_setFont_1801 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("font");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFont_1801 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFont &arg1 = gsi::arg_reader<const QFont & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QListWidgetItem *)cls)->setFont (arg1);
}


// void QListWidgetItem::setForeground(const QBrush &brush)


static void _init_f_setForeground_1910 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("brush");
  decl->add_arg<const QBrush & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setForeground_1910 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QBrush &arg1 = gsi::arg_reader<const QBrush & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QListWidgetItem *)cls)->setForeground (arg1);
}


// void QListWidgetItem::setHidden(bool hide)


static void _init_f_setHidden_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hide");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHidden_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QListWidgetItem *)cls)->setHidden (arg1);
}


// void QListWidgetItem::setIcon(const QIcon &icon)


static void _init_f_setIcon_1787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIcon_1787 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QIcon &arg1 = gsi::arg_reader<const QIcon & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QListWidgetItem *)cls)->setIcon (arg1);
}


// void QListWidgetItem::setSelected(bool select)


static void _init_f_setSelected_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("select");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSelected_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QListWidgetItem *)cls)->setSelected (arg1);
}


// void QListWidgetItem::setSizeHint(const QSize &size)


static void _init_f_setSizeHint_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSizeHint_1805 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSize &arg1 = gsi::arg_reader<const QSize & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QListWidgetItem *)cls)->setSizeHint (arg1);
}


// void QListWidgetItem::setStatusTip(const QString &statusTip)


static void _init_f_setStatusTip_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("statusTip");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStatusTip_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QListWidgetItem *)cls)->setStatusTip (arg1);
}


// void QListWidgetItem::setText(const QString &text)


static void _init_f_setText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setText_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QListWidgetItem *)cls)->setText (arg1);
}


// void QListWidgetItem::setTextAlignment(int alignment)


static void _init_f_setTextAlignment_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("alignment");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTextAlignment_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QListWidgetItem *)cls)->setTextAlignment (arg1);
}


// void QListWidgetItem::setToolTip(const QString &toolTip)


static void _init_f_setToolTip_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("toolTip");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setToolTip_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QListWidgetItem *)cls)->setToolTip (arg1);
}


// void QListWidgetItem::setWhatsThis(const QString &whatsThis)


static void _init_f_setWhatsThis_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("whatsThis");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWhatsThis_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QListWidgetItem *)cls)->setWhatsThis (arg1);
}


// QSize QListWidgetItem::sizeHint()


static void _init_f_sizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QListWidgetItem *)cls)->sizeHint ());
}


// QString QListWidgetItem::statusTip()


static void _init_f_statusTip_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_statusTip_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QListWidgetItem *)cls)->statusTip ());
}


// QString QListWidgetItem::text()


static void _init_f_text_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_text_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QListWidgetItem *)cls)->text ());
}


// int QListWidgetItem::textAlignment()


static void _init_f_textAlignment_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_textAlignment_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QListWidgetItem *)cls)->textAlignment ());
}


// QString QListWidgetItem::toolTip()


static void _init_f_toolTip_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_toolTip_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QListWidgetItem *)cls)->toolTip ());
}


// int QListWidgetItem::type()


static void _init_f_type_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_type_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QListWidgetItem *)cls)->type ());
}


// QString QListWidgetItem::whatsThis()


static void _init_f_whatsThis_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_whatsThis_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QListWidgetItem *)cls)->whatsThis ());
}


// void QListWidgetItem::write(QDataStream &out)


static void _init_f_write_c1697 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("out");
  decl->add_arg<QDataStream & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_write_c1697 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDataStream &arg1 = gsi::arg_reader<QDataStream & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QListWidgetItem *)cls)->write (arg1);
}


namespace gsi
{

static gsi::Methods methods_QListWidgetItem () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod (":background", "@brief Method QBrush QListWidgetItem::background()\n", true, &_init_f_background_c0, &_call_f_background_c0);
  methods += new qt_gsi::GenericMethod (":checkState", "@brief Method Qt::CheckState QListWidgetItem::checkState()\n", true, &_init_f_checkState_c0, &_call_f_checkState_c0);
  methods += new qt_gsi::GenericMethod ("clone", "@brief Method QListWidgetItem *QListWidgetItem::clone()\n", true, &_init_f_clone_c0, &_call_f_clone_c0);
  methods += new qt_gsi::GenericMethod ("data", "@brief Method QVariant QListWidgetItem::data(int role)\n", true, &_init_f_data_c767, &_call_f_data_c767);
  methods += new qt_gsi::GenericMethod (":flags", "@brief Method QFlags<Qt::ItemFlag> QListWidgetItem::flags()\n", true, &_init_f_flags_c0, &_call_f_flags_c0);
  methods += new qt_gsi::GenericMethod (":font", "@brief Method QFont QListWidgetItem::font()\n", true, &_init_f_font_c0, &_call_f_font_c0);
  methods += new qt_gsi::GenericMethod (":foreground", "@brief Method QBrush QListWidgetItem::foreground()\n", true, &_init_f_foreground_c0, &_call_f_foreground_c0);
  methods += new qt_gsi::GenericMethod (":icon", "@brief Method QIcon QListWidgetItem::icon()\n", true, &_init_f_icon_c0, &_call_f_icon_c0);
  methods += new qt_gsi::GenericMethod ("isHidden?|:hidden", "@brief Method bool QListWidgetItem::isHidden()\n", true, &_init_f_isHidden_c0, &_call_f_isHidden_c0);
  methods += new qt_gsi::GenericMethod ("isSelected?|:selected", "@brief Method bool QListWidgetItem::isSelected()\n", true, &_init_f_isSelected_c0, &_call_f_isSelected_c0);
  methods += new qt_gsi::GenericMethod ("listWidget", "@brief Method QListWidget *QListWidgetItem::listWidget()\n", true, &_init_f_listWidget_c0, &_call_f_listWidget_c0);
  methods += new qt_gsi::GenericMethod ("<", "@brief Method bool QListWidgetItem::operator<(const QListWidgetItem &other)\n", true, &_init_f_operator_lt__c2817, &_call_f_operator_lt__c2817);
  methods += new qt_gsi::GenericMethod ("assign", "@brief Method QListWidgetItem &QListWidgetItem::operator=(const QListWidgetItem &other)\n", false, &_init_f_operator_eq__2817, &_call_f_operator_eq__2817);
  methods += new qt_gsi::GenericMethod ("read", "@brief Method void QListWidgetItem::read(QDataStream &in)\n", false, &_init_f_read_1697, &_call_f_read_1697);
  methods += new qt_gsi::GenericMethod ("setBackground|background=", "@brief Method void QListWidgetItem::setBackground(const QBrush &brush)\n", false, &_init_f_setBackground_1910, &_call_f_setBackground_1910);
  methods += new qt_gsi::GenericMethod ("setCheckState|checkState=", "@brief Method void QListWidgetItem::setCheckState(Qt::CheckState state)\n", false, &_init_f_setCheckState_1740, &_call_f_setCheckState_1740);
  methods += new qt_gsi::GenericMethod ("setData", "@brief Method void QListWidgetItem::setData(int role, const QVariant &value)\n", false, &_init_f_setData_2778, &_call_f_setData_2778);
  methods += new qt_gsi::GenericMethod ("setFlags|flags=", "@brief Method void QListWidgetItem::setFlags(QFlags<Qt::ItemFlag> flags)\n", false, &_init_f_setFlags_2222, &_call_f_setFlags_2222);
  methods += new qt_gsi::GenericMethod ("setFont|font=", "@brief Method void QListWidgetItem::setFont(const QFont &font)\n", false, &_init_f_setFont_1801, &_call_f_setFont_1801);
  methods += new qt_gsi::GenericMethod ("setForeground|foreground=", "@brief Method void QListWidgetItem::setForeground(const QBrush &brush)\n", false, &_init_f_setForeground_1910, &_call_f_setForeground_1910);
  methods += new qt_gsi::GenericMethod ("setHidden|hidden=", "@brief Method void QListWidgetItem::setHidden(bool hide)\n", false, &_init_f_setHidden_864, &_call_f_setHidden_864);
  methods += new qt_gsi::GenericMethod ("setIcon|icon=", "@brief Method void QListWidgetItem::setIcon(const QIcon &icon)\n", false, &_init_f_setIcon_1787, &_call_f_setIcon_1787);
  methods += new qt_gsi::GenericMethod ("setSelected|selected=", "@brief Method void QListWidgetItem::setSelected(bool select)\n", false, &_init_f_setSelected_864, &_call_f_setSelected_864);
  methods += new qt_gsi::GenericMethod ("setSizeHint|sizeHint=", "@brief Method void QListWidgetItem::setSizeHint(const QSize &size)\n", false, &_init_f_setSizeHint_1805, &_call_f_setSizeHint_1805);
  methods += new qt_gsi::GenericMethod ("setStatusTip|statusTip=", "@brief Method void QListWidgetItem::setStatusTip(const QString &statusTip)\n", false, &_init_f_setStatusTip_2025, &_call_f_setStatusTip_2025);
  methods += new qt_gsi::GenericMethod ("setText|text=", "@brief Method void QListWidgetItem::setText(const QString &text)\n", false, &_init_f_setText_2025, &_call_f_setText_2025);
  methods += new qt_gsi::GenericMethod ("setTextAlignment|textAlignment=", "@brief Method void QListWidgetItem::setTextAlignment(int alignment)\n", false, &_init_f_setTextAlignment_767, &_call_f_setTextAlignment_767);
  methods += new qt_gsi::GenericMethod ("setToolTip|toolTip=", "@brief Method void QListWidgetItem::setToolTip(const QString &toolTip)\n", false, &_init_f_setToolTip_2025, &_call_f_setToolTip_2025);
  methods += new qt_gsi::GenericMethod ("setWhatsThis|whatsThis=", "@brief Method void QListWidgetItem::setWhatsThis(const QString &whatsThis)\n", false, &_init_f_setWhatsThis_2025, &_call_f_setWhatsThis_2025);
  methods += new qt_gsi::GenericMethod (":sizeHint", "@brief Method QSize QListWidgetItem::sizeHint()\n", true, &_init_f_sizeHint_c0, &_call_f_sizeHint_c0);
  methods += new qt_gsi::GenericMethod (":statusTip", "@brief Method QString QListWidgetItem::statusTip()\n", true, &_init_f_statusTip_c0, &_call_f_statusTip_c0);
  methods += new qt_gsi::GenericMethod (":text", "@brief Method QString QListWidgetItem::text()\n", true, &_init_f_text_c0, &_call_f_text_c0);
  methods += new qt_gsi::GenericMethod (":textAlignment", "@brief Method int QListWidgetItem::textAlignment()\n", true, &_init_f_textAlignment_c0, &_call_f_textAlignment_c0);
  methods += new qt_gsi::GenericMethod (":toolTip", "@brief Method QString QListWidgetItem::toolTip()\n", true, &_init_f_toolTip_c0, &_call_f_toolTip_c0);
  methods += new qt_gsi::GenericMethod ("type", "@brief Method int QListWidgetItem::type()\n", true, &_init_f_type_c0, &_call_f_type_c0);
  methods += new qt_gsi::GenericMethod (":whatsThis", "@brief Method QString QListWidgetItem::whatsThis()\n", true, &_init_f_whatsThis_c0, &_call_f_whatsThis_c0);
  methods += new qt_gsi::GenericMethod ("write", "@brief Method void QListWidgetItem::write(QDataStream &out)\n", true, &_init_f_write_c1697, &_call_f_write_c1697);
  return methods;
}

gsi::Class<QListWidgetItem> decl_QListWidgetItem ("QtWidgets", "QListWidgetItem_Native",
  methods_QListWidgetItem (),
  "@hide\n@alias QListWidgetItem");

GSI_QTWIDGETS_PUBLIC gsi::Class<QListWidgetItem> &qtdecl_QListWidgetItem () { return decl_QListWidgetItem; }

}


class QListWidgetItem_Adaptor : public QListWidgetItem, public qt_gsi::QtObjectBase
{
public:

  virtual ~QListWidgetItem_Adaptor();

  //  [adaptor ctor] QListWidgetItem::QListWidgetItem(QListWidget *listview, int type)
  QListWidgetItem_Adaptor() : QListWidgetItem()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QListWidgetItem::QListWidgetItem(QListWidget *listview, int type)
  QListWidgetItem_Adaptor(QListWidget *listview) : QListWidgetItem(listview)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QListWidgetItem::QListWidgetItem(QListWidget *listview, int type)
  QListWidgetItem_Adaptor(QListWidget *listview, int type) : QListWidgetItem(listview, type)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QListWidgetItem::QListWidgetItem(const QString &text, QListWidget *listview, int type)
  QListWidgetItem_Adaptor(const QString &text) : QListWidgetItem(text)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QListWidgetItem::QListWidgetItem(const QString &text, QListWidget *listview, int type)
  QListWidgetItem_Adaptor(const QString &text, QListWidget *listview) : QListWidgetItem(text, listview)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QListWidgetItem::QListWidgetItem(const QString &text, QListWidget *listview, int type)
  QListWidgetItem_Adaptor(const QString &text, QListWidget *listview, int type) : QListWidgetItem(text, listview, type)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QListWidgetItem::QListWidgetItem(const QIcon &icon, const QString &text, QListWidget *listview, int type)
  QListWidgetItem_Adaptor(const QIcon &icon, const QString &text) : QListWidgetItem(icon, text)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QListWidgetItem::QListWidgetItem(const QIcon &icon, const QString &text, QListWidget *listview, int type)
  QListWidgetItem_Adaptor(const QIcon &icon, const QString &text, QListWidget *listview) : QListWidgetItem(icon, text, listview)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QListWidgetItem::QListWidgetItem(const QIcon &icon, const QString &text, QListWidget *listview, int type)
  QListWidgetItem_Adaptor(const QIcon &icon, const QString &text, QListWidget *listview, int type) : QListWidgetItem(icon, text, listview, type)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QListWidgetItem::QListWidgetItem(const QListWidgetItem &other)
  QListWidgetItem_Adaptor(const QListWidgetItem &other) : QListWidgetItem(other)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor impl] QListWidgetItem *QListWidgetItem::clone()
  QListWidgetItem * cbs_clone_c0_0() const
  {
    return QListWidgetItem::clone();
  }

  virtual QListWidgetItem * clone() const
  {
    if (cb_clone_c0_0.can_issue()) {
      return cb_clone_c0_0.issue<QListWidgetItem_Adaptor, QListWidgetItem *>(&QListWidgetItem_Adaptor::cbs_clone_c0_0);
    } else {
      return QListWidgetItem::clone();
    }
  }

  //  [adaptor impl] QVariant QListWidgetItem::data(int role)
  QVariant cbs_data_c767_0(int role) const
  {
    return QListWidgetItem::data(role);
  }

  virtual QVariant data(int role) const
  {
    if (cb_data_c767_0.can_issue()) {
      return cb_data_c767_0.issue<QListWidgetItem_Adaptor, QVariant, int>(&QListWidgetItem_Adaptor::cbs_data_c767_0, role);
    } else {
      return QListWidgetItem::data(role);
    }
  }

  //  [adaptor impl] bool QListWidgetItem::operator<(const QListWidgetItem &other)
  bool cbs_operator_lt__c2817_0(const QListWidgetItem &other) const
  {
    return QListWidgetItem::operator<(other);
  }

  virtual bool operator<(const QListWidgetItem &other) const
  {
    if (cb_operator_lt__c2817_0.can_issue()) {
      return cb_operator_lt__c2817_0.issue<QListWidgetItem_Adaptor, bool, const QListWidgetItem &>(&QListWidgetItem_Adaptor::cbs_operator_lt__c2817_0, other);
    } else {
      return QListWidgetItem::operator<(other);
    }
  }

  //  [adaptor impl] void QListWidgetItem::read(QDataStream &in)
  void cbs_read_1697_0(QDataStream &in)
  {
    QListWidgetItem::read(in);
  }

  virtual void read(QDataStream &in)
  {
    if (cb_read_1697_0.can_issue()) {
      cb_read_1697_0.issue<QListWidgetItem_Adaptor, QDataStream &>(&QListWidgetItem_Adaptor::cbs_read_1697_0, in);
    } else {
      QListWidgetItem::read(in);
    }
  }

  //  [adaptor impl] void QListWidgetItem::setData(int role, const QVariant &value)
  void cbs_setData_2778_0(int role, const QVariant &value)
  {
    QListWidgetItem::setData(role, value);
  }

  virtual void setData(int role, const QVariant &value)
  {
    if (cb_setData_2778_0.can_issue()) {
      cb_setData_2778_0.issue<QListWidgetItem_Adaptor, int, const QVariant &>(&QListWidgetItem_Adaptor::cbs_setData_2778_0, role, value);
    } else {
      QListWidgetItem::setData(role, value);
    }
  }

  //  [adaptor impl] void QListWidgetItem::write(QDataStream &out)
  void cbs_write_c1697_0(QDataStream &out) const
  {
    QListWidgetItem::write(out);
  }

  virtual void write(QDataStream &out) const
  {
    if (cb_write_c1697_0.can_issue()) {
      cb_write_c1697_0.issue<QListWidgetItem_Adaptor, QDataStream &>(&QListWidgetItem_Adaptor::cbs_write_c1697_0, out);
    } else {
      QListWidgetItem::write(out);
    }
  }

  gsi::Callback cb_clone_c0_0;
  gsi::Callback cb_data_c767_0;
  gsi::Callback cb_operator_lt__c2817_0;
  gsi::Callback cb_read_1697_0;
  gsi::Callback cb_setData_2778_0;
  gsi::Callback cb_write_c1697_0;
};

QListWidgetItem_Adaptor::~QListWidgetItem_Adaptor() { }

//  Constructor QListWidgetItem::QListWidgetItem(QListWidget *listview, int type) (adaptor class)

static void _init_ctor_QListWidgetItem_Adaptor_2386 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("listview", true, "nullptr");
  decl->add_arg<QListWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("type", true, "QListWidgetItem::Type");
  decl->add_arg<int > (argspec_1);
  decl->set_return_new<QListWidgetItem_Adaptor> ();
}

static void _call_ctor_QListWidgetItem_Adaptor_2386 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QListWidget *arg1 = args ? gsi::arg_reader<QListWidget * >() (args, heap) : gsi::arg_maker<QListWidget * >() (nullptr, heap);
  int arg2 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (QListWidgetItem::Type, heap);
  QListWidgetItem_Adaptor *obj = new QListWidgetItem_Adaptor (arg1, arg2);
  if (arg1) {
    qt_gsi::qt_keep (obj);
  } else {
    qt_gsi::qt_release (obj);
  }
  ret.write<QListWidgetItem_Adaptor *> (obj);
}


//  Constructor QListWidgetItem::QListWidgetItem(const QString &text, QListWidget *listview, int type) (adaptor class)

static void _init_ctor_QListWidgetItem_Adaptor_4303 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("listview", true, "nullptr");
  decl->add_arg<QListWidget * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("type", true, "QListWidgetItem::Type");
  decl->add_arg<int > (argspec_2);
  decl->set_return_new<QListWidgetItem_Adaptor> ();
}

static void _call_ctor_QListWidgetItem_Adaptor_4303 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  QListWidget *arg2 = args ? gsi::arg_reader<QListWidget * >() (args, heap) : gsi::arg_maker<QListWidget * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (QListWidgetItem::Type, heap);
  ret.write<QListWidgetItem_Adaptor *> (new QListWidgetItem_Adaptor (arg1, arg2, arg3));
}


//  Constructor QListWidgetItem::QListWidgetItem(const QIcon &icon, const QString &text, QListWidget *listview, int type) (adaptor class)

static void _init_ctor_QListWidgetItem_Adaptor_5982 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("text");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("listview", true, "nullptr");
  decl->add_arg<QListWidget * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("type", true, "QListWidgetItem::Type");
  decl->add_arg<int > (argspec_3);
  decl->set_return_new<QListWidgetItem_Adaptor> ();
}

static void _call_ctor_QListWidgetItem_Adaptor_5982 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QIcon &arg1 = gsi::arg_reader<const QIcon & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  QListWidget *arg3 = args ? gsi::arg_reader<QListWidget * >() (args, heap) : gsi::arg_maker<QListWidget * >() (nullptr, heap);
  int arg4 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (QListWidgetItem::Type, heap);
  ret.write<QListWidgetItem_Adaptor *> (new QListWidgetItem_Adaptor (arg1, arg2, arg3, arg4));
}


//  Constructor QListWidgetItem::QListWidgetItem(const QListWidgetItem &other) (adaptor class)

static void _init_ctor_QListWidgetItem_Adaptor_2817 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QListWidgetItem & > (argspec_0);
  decl->set_return_new<QListWidgetItem_Adaptor> ();
}

static void _call_ctor_QListWidgetItem_Adaptor_2817 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QListWidgetItem &arg1 = gsi::arg_reader<const QListWidgetItem & >() (args, heap);
  ret.write<QListWidgetItem_Adaptor *> (new QListWidgetItem_Adaptor (arg1));
}


// QListWidgetItem *QListWidgetItem::clone()

static void _init_cbs_clone_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QListWidgetItem * > ();
}

static void _call_cbs_clone_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QListWidgetItem * > ((QListWidgetItem *)((QListWidgetItem_Adaptor *)cls)->cbs_clone_c0_0 ());
}

static void _set_callback_cbs_clone_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidgetItem_Adaptor *)cls)->cb_clone_c0_0 = cb;
}


// QVariant QListWidgetItem::data(int role)

static void _init_cbs_data_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("role");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_data_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<QVariant > ((QVariant)((QListWidgetItem_Adaptor *)cls)->cbs_data_c767_0 (arg1));
}

static void _set_callback_cbs_data_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidgetItem_Adaptor *)cls)->cb_data_c767_0 = cb;
}


// bool QListWidgetItem::operator<(const QListWidgetItem &other)

static void _init_cbs_operator_lt__c2817_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QListWidgetItem & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_operator_lt__c2817_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QListWidgetItem &arg1 = args.read<const QListWidgetItem & > (heap);
  ret.write<bool > ((bool)((QListWidgetItem_Adaptor *)cls)->cbs_operator_lt__c2817_0 (arg1));
}

static void _set_callback_cbs_operator_lt__c2817_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidgetItem_Adaptor *)cls)->cb_operator_lt__c2817_0 = cb;
}


// void QListWidgetItem::read(QDataStream &in)

static void _init_cbs_read_1697_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("in");
  decl->add_arg<QDataStream & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_read_1697_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDataStream &arg1 = args.read<QDataStream & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QListWidgetItem_Adaptor *)cls)->cbs_read_1697_0 (arg1);
}

static void _set_callback_cbs_read_1697_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidgetItem_Adaptor *)cls)->cb_read_1697_0 = cb;
}


// void QListWidgetItem::setData(int role, const QVariant &value)

static void _init_cbs_setData_2778_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("role");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setData_2778_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const QVariant &arg2 = args.read<const QVariant & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QListWidgetItem_Adaptor *)cls)->cbs_setData_2778_0 (arg1, arg2);
}

static void _set_callback_cbs_setData_2778_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidgetItem_Adaptor *)cls)->cb_setData_2778_0 = cb;
}


// void QListWidgetItem::write(QDataStream &out)

static void _init_cbs_write_c1697_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("out");
  decl->add_arg<QDataStream & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_write_c1697_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDataStream &arg1 = args.read<QDataStream & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QListWidgetItem_Adaptor *)cls)->cbs_write_c1697_0 (arg1);
}

static void _set_callback_cbs_write_c1697_0 (void *cls, const gsi::Callback &cb)
{
  ((QListWidgetItem_Adaptor *)cls)->cb_write_c1697_0 = cb;
}


namespace gsi
{

gsi::Class<QListWidgetItem> &qtdecl_QListWidgetItem ();

static gsi::Methods methods_QListWidgetItem_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QListWidgetItem::QListWidgetItem(QListWidget *listview, int type)\nThis method creates an object of class QListWidgetItem.", &_init_ctor_QListWidgetItem_Adaptor_2386, &_call_ctor_QListWidgetItem_Adaptor_2386);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QListWidgetItem::QListWidgetItem(const QString &text, QListWidget *listview, int type)\nThis method creates an object of class QListWidgetItem.", &_init_ctor_QListWidgetItem_Adaptor_4303, &_call_ctor_QListWidgetItem_Adaptor_4303);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QListWidgetItem::QListWidgetItem(const QIcon &icon, const QString &text, QListWidget *listview, int type)\nThis method creates an object of class QListWidgetItem.", &_init_ctor_QListWidgetItem_Adaptor_5982, &_call_ctor_QListWidgetItem_Adaptor_5982);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QListWidgetItem::QListWidgetItem(const QListWidgetItem &other)\nThis method creates an object of class QListWidgetItem.", &_init_ctor_QListWidgetItem_Adaptor_2817, &_call_ctor_QListWidgetItem_Adaptor_2817);
  methods += new qt_gsi::GenericMethod ("clone", "@brief Virtual method QListWidgetItem *QListWidgetItem::clone()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_clone_c0_0, &_call_cbs_clone_c0_0);
  methods += new qt_gsi::GenericMethod ("clone", "@hide", true, &_init_cbs_clone_c0_0, &_call_cbs_clone_c0_0, &_set_callback_cbs_clone_c0_0);
  methods += new qt_gsi::GenericMethod ("data", "@brief Virtual method QVariant QListWidgetItem::data(int role)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_data_c767_0, &_call_cbs_data_c767_0);
  methods += new qt_gsi::GenericMethod ("data", "@hide", true, &_init_cbs_data_c767_0, &_call_cbs_data_c767_0, &_set_callback_cbs_data_c767_0);
  methods += new qt_gsi::GenericMethod ("<", "@brief Virtual method bool QListWidgetItem::operator<(const QListWidgetItem &other)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_operator_lt__c2817_0, &_call_cbs_operator_lt__c2817_0);
  methods += new qt_gsi::GenericMethod ("<", "@hide", true, &_init_cbs_operator_lt__c2817_0, &_call_cbs_operator_lt__c2817_0, &_set_callback_cbs_operator_lt__c2817_0);
  methods += new qt_gsi::GenericMethod ("read", "@brief Virtual method void QListWidgetItem::read(QDataStream &in)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_read_1697_0, &_call_cbs_read_1697_0);
  methods += new qt_gsi::GenericMethod ("read", "@hide", false, &_init_cbs_read_1697_0, &_call_cbs_read_1697_0, &_set_callback_cbs_read_1697_0);
  methods += new qt_gsi::GenericMethod ("setData", "@brief Virtual method void QListWidgetItem::setData(int role, const QVariant &value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setData_2778_0, &_call_cbs_setData_2778_0);
  methods += new qt_gsi::GenericMethod ("setData", "@hide", false, &_init_cbs_setData_2778_0, &_call_cbs_setData_2778_0, &_set_callback_cbs_setData_2778_0);
  methods += new qt_gsi::GenericMethod ("write", "@brief Virtual method void QListWidgetItem::write(QDataStream &out)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_write_c1697_0, &_call_cbs_write_c1697_0);
  methods += new qt_gsi::GenericMethod ("write", "@hide", true, &_init_cbs_write_c1697_0, &_call_cbs_write_c1697_0, &_set_callback_cbs_write_c1697_0);
  return methods;
}

gsi::Class<QListWidgetItem_Adaptor> decl_QListWidgetItem_Adaptor (qtdecl_QListWidgetItem (), "QtWidgets", "QListWidgetItem",
  methods_QListWidgetItem_Adaptor (),
  "@qt\n@brief Binding of QListWidgetItem");

}

