
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQRadioData.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QRadioData>
#include <QChildEvent>
#include <QEvent>
#include <QMediaObject>
#include <QMetaMethod>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QRadioData

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QRadioData::staticMetaObject);
}


// void QRadioData::alternativeFrequenciesEnabledChanged(bool enabled)


static void _init_f_alternativeFrequenciesEnabledChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_alternativeFrequenciesEnabledChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioData *)cls)->alternativeFrequenciesEnabledChanged (arg1);
}


// QMultimedia::AvailabilityStatus QRadioData::availability()


static void _init_f_availability_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type > ();
}

static void _call_f_availability_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type > ((qt_gsi::Converter<QMultimedia::AvailabilityStatus>::target_type)qt_gsi::CppToQtAdaptor<QMultimedia::AvailabilityStatus>(((QRadioData *)cls)->availability ()));
}


// QRadioData::Error QRadioData::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QRadioData::Error>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QRadioData::Error>::target_type > ((qt_gsi::Converter<QRadioData::Error>::target_type)qt_gsi::CppToQtAdaptor<QRadioData::Error>(((QRadioData *)cls)->error ()));
}


// void QRadioData::error(QRadioData::Error error)


static void _init_f_error_2028 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("error");
  decl->add_arg<const qt_gsi::Converter<QRadioData::Error>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_error_2028 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QRadioData::Error>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QRadioData::Error>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioData *)cls)->error (qt_gsi::QtToCppAdaptor<QRadioData::Error>(arg1).cref());
}


// QString QRadioData::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QRadioData *)cls)->errorString ());
}


// bool QRadioData::isAlternativeFrequenciesEnabled()


static void _init_f_isAlternativeFrequenciesEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isAlternativeFrequenciesEnabled_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QRadioData *)cls)->isAlternativeFrequenciesEnabled ());
}


// QMediaObject *QRadioData::mediaObject()


static void _init_f_mediaObject_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaObject * > ();
}

static void _call_f_mediaObject_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaObject * > ((QMediaObject *)((QRadioData *)cls)->mediaObject ());
}


// QRadioData::ProgramType QRadioData::programType()


static void _init_f_programType_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QRadioData::ProgramType>::target_type > ();
}

static void _call_f_programType_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QRadioData::ProgramType>::target_type > ((qt_gsi::Converter<QRadioData::ProgramType>::target_type)qt_gsi::CppToQtAdaptor<QRadioData::ProgramType>(((QRadioData *)cls)->programType ()));
}


// void QRadioData::programTypeChanged(QRadioData::ProgramType programType)


static void _init_f_programTypeChanged_2652 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("programType");
  decl->add_arg<const qt_gsi::Converter<QRadioData::ProgramType>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_programTypeChanged_2652 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QRadioData::ProgramType>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QRadioData::ProgramType>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioData *)cls)->programTypeChanged (qt_gsi::QtToCppAdaptor<QRadioData::ProgramType>(arg1).cref());
}


// QString QRadioData::programTypeName()


static void _init_f_programTypeName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_programTypeName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QRadioData *)cls)->programTypeName ());
}


// void QRadioData::programTypeNameChanged(QString programTypeName)


static void _init_f_programTypeNameChanged_1148 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("programTypeName");
  decl->add_arg<QString > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_programTypeNameChanged_1148 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QString arg1 = gsi::arg_reader<QString >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioData *)cls)->programTypeNameChanged (arg1);
}


// QString QRadioData::radioText()


static void _init_f_radioText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_radioText_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QRadioData *)cls)->radioText ());
}


// void QRadioData::radioTextChanged(QString radioText)


static void _init_f_radioTextChanged_1148 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("radioText");
  decl->add_arg<QString > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_radioTextChanged_1148 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QString arg1 = gsi::arg_reader<QString >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioData *)cls)->radioTextChanged (arg1);
}


// void QRadioData::setAlternativeFrequenciesEnabled(bool enabled)


static void _init_f_setAlternativeFrequenciesEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAlternativeFrequenciesEnabled_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioData *)cls)->setAlternativeFrequenciesEnabled (arg1);
}


// QString QRadioData::stationId()


static void _init_f_stationId_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_stationId_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QRadioData *)cls)->stationId ());
}


// void QRadioData::stationIdChanged(QString stationId)


static void _init_f_stationIdChanged_1148 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("stationId");
  decl->add_arg<QString > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_stationIdChanged_1148 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QString arg1 = gsi::arg_reader<QString >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioData *)cls)->stationIdChanged (arg1);
}


// QString QRadioData::stationName()


static void _init_f_stationName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_stationName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QRadioData *)cls)->stationName ());
}


// void QRadioData::stationNameChanged(QString stationName)


static void _init_f_stationNameChanged_1148 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("stationName");
  decl->add_arg<QString > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_stationNameChanged_1148 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QString arg1 = gsi::arg_reader<QString >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioData *)cls)->stationNameChanged (arg1);
}


// static QString QRadioData::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QRadioData::tr (arg1, arg2, arg3));
}


// static QString QRadioData::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QRadioData::trUtf8 (arg1, arg2, arg3));
}


//  base class cast for QObject

static void _init_f_QRadioData_as_QObject (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject *> ();
}

static void _call_f_QRadioData_as_QObject (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<QObject *> ((QObject *)(QRadioData *)cls);
}

static void _init_f_QRadioData_as_const_QObject (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QObject *> ();
}

static void _call_f_QRadioData_as_const_QObject (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QObject *> ((const QObject *)(const QRadioData *)cls);
}

//  base class cast for QMediaBindableInterface

static void _init_f_QRadioData_as_QMediaBindableInterface (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaBindableInterface *> ();
}

static void _call_f_QRadioData_as_QMediaBindableInterface (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<QMediaBindableInterface *> ((QMediaBindableInterface *)(QRadioData *)cls);
}

static void _init_f_QRadioData_as_const_QMediaBindableInterface (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QMediaBindableInterface *> ();
}

static void _call_f_QRadioData_as_const_QMediaBindableInterface (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMediaBindableInterface *> ((const QMediaBindableInterface *)(const QRadioData *)cls);
}


namespace gsi
{

static gsi::Methods methods_QRadioData () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("alternativeFrequenciesEnabledChanged", "@brief Method void QRadioData::alternativeFrequenciesEnabledChanged(bool enabled)\n", false, &_init_f_alternativeFrequenciesEnabledChanged_864, &_call_f_alternativeFrequenciesEnabledChanged_864);
  methods += new qt_gsi::GenericMethod ("availability", "@brief Method QMultimedia::AvailabilityStatus QRadioData::availability()\n", true, &_init_f_availability_c0, &_call_f_availability_c0);
  methods += new qt_gsi::GenericMethod ("error", "@brief Method QRadioData::Error QRadioData::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
  methods += new qt_gsi::GenericMethod ("error_sig", "@brief Method void QRadioData::error(QRadioData::Error error)\n", false, &_init_f_error_2028, &_call_f_error_2028);
  methods += new qt_gsi::GenericMethod ("errorString", "@brief Method QString QRadioData::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
  methods += new qt_gsi::GenericMethod ("isAlternativeFrequenciesEnabled?|:alternativeFrequenciesEnabled", "@brief Method bool QRadioData::isAlternativeFrequenciesEnabled()\n", true, &_init_f_isAlternativeFrequenciesEnabled_c0, &_call_f_isAlternativeFrequenciesEnabled_c0);
  methods += new qt_gsi::GenericMethod ("mediaObject", "@brief Method QMediaObject *QRadioData::mediaObject()\nThis is a reimplementation of QMediaBindableInterface::mediaObject", true, &_init_f_mediaObject_c0, &_call_f_mediaObject_c0);
  methods += new qt_gsi::GenericMethod (":programType", "@brief Method QRadioData::ProgramType QRadioData::programType()\n", true, &_init_f_programType_c0, &_call_f_programType_c0);
  methods += new qt_gsi::GenericMethod ("programTypeChanged", "@brief Method void QRadioData::programTypeChanged(QRadioData::ProgramType programType)\n", false, &_init_f_programTypeChanged_2652, &_call_f_programTypeChanged_2652);
  methods += new qt_gsi::GenericMethod (":programTypeName", "@brief Method QString QRadioData::programTypeName()\n", true, &_init_f_programTypeName_c0, &_call_f_programTypeName_c0);
  methods += new qt_gsi::GenericMethod ("programTypeNameChanged", "@brief Method void QRadioData::programTypeNameChanged(QString programTypeName)\n", false, &_init_f_programTypeNameChanged_1148, &_call_f_programTypeNameChanged_1148);
  methods += new qt_gsi::GenericMethod (":radioText", "@brief Method QString QRadioData::radioText()\n", true, &_init_f_radioText_c0, &_call_f_radioText_c0);
  methods += new qt_gsi::GenericMethod ("radioTextChanged", "@brief Method void QRadioData::radioTextChanged(QString radioText)\n", false, &_init_f_radioTextChanged_1148, &_call_f_radioTextChanged_1148);
  methods += new qt_gsi::GenericMethod ("setAlternativeFrequenciesEnabled|alternativeFrequenciesEnabled=", "@brief Method void QRadioData::setAlternativeFrequenciesEnabled(bool enabled)\n", false, &_init_f_setAlternativeFrequenciesEnabled_864, &_call_f_setAlternativeFrequenciesEnabled_864);
  methods += new qt_gsi::GenericMethod (":stationId", "@brief Method QString QRadioData::stationId()\n", true, &_init_f_stationId_c0, &_call_f_stationId_c0);
  methods += new qt_gsi::GenericMethod ("stationIdChanged", "@brief Method void QRadioData::stationIdChanged(QString stationId)\n", false, &_init_f_stationIdChanged_1148, &_call_f_stationIdChanged_1148);
  methods += new qt_gsi::GenericMethod (":stationName", "@brief Method QString QRadioData::stationName()\n", true, &_init_f_stationName_c0, &_call_f_stationName_c0);
  methods += new qt_gsi::GenericMethod ("stationNameChanged", "@brief Method void QRadioData::stationNameChanged(QString stationName)\n", false, &_init_f_stationNameChanged_1148, &_call_f_stationNameChanged_1148);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QRadioData::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QRadioData::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  methods += new qt_gsi::GenericMethod ("asQObject", "@brief Delivers the base class interface QObject of QRadioData\nClass QRadioData is derived from multiple base classes. This method delivers the QObject base class aspect.", false, &_init_f_QRadioData_as_QObject, &_call_f_QRadioData_as_QObject);
  methods += new qt_gsi::GenericMethod ("asConstQObject", "@brief Delivers the base class interface QObject of QRadioData\nClass QRadioData is derived from multiple base classes. This method delivers the QObject base class aspect.\n\nUse this version if you have a const reference.", true, &_init_f_QRadioData_as_const_QObject, &_call_f_QRadioData_as_const_QObject);
  methods += new qt_gsi::GenericMethod ("asQMediaBindableInterface", "@brief Delivers the base class interface QMediaBindableInterface of QRadioData\nClass QRadioData is derived from multiple base classes. This method delivers the QMediaBindableInterface base class aspect.", false, &_init_f_QRadioData_as_QMediaBindableInterface, &_call_f_QRadioData_as_QMediaBindableInterface);
  methods += new qt_gsi::GenericMethod ("asConstQMediaBindableInterface", "@brief Delivers the base class interface QMediaBindableInterface of QRadioData\nClass QRadioData is derived from multiple base classes. This method delivers the QMediaBindableInterface base class aspect.\n\nUse this version if you have a const reference.", true, &_init_f_QRadioData_as_const_QMediaBindableInterface, &_call_f_QRadioData_as_const_QMediaBindableInterface);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QRadioData> decl_QRadioData (qtdecl_QObject (), "QtMultimedia", "QRadioData_Native",
  methods_QRadioData (),
  "@hide\n@alias QRadioData");

//  Additional base classes

gsi::Class<QMediaBindableInterface> &qtdecl_QMediaBindableInterface ();

gsi::ClassExt<QRadioData> base_class_QMediaBindableInterface_in_QRadioData (qtdecl_QMediaBindableInterface ());

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QRadioData> &qtdecl_QRadioData () { return decl_QRadioData; }

}


class QRadioData_Adaptor : public QRadioData, public qt_gsi::QtObjectBase
{
public:

  virtual ~QRadioData_Adaptor();

  //  [adaptor ctor] QRadioData::QRadioData(QMediaObject *mediaObject, QObject *parent)
  QRadioData_Adaptor(QMediaObject *mediaObject) : QRadioData(mediaObject)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QRadioData::QRadioData(QMediaObject *mediaObject, QObject *parent)
  QRadioData_Adaptor(QMediaObject *mediaObject, QObject *parent) : QRadioData(mediaObject, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QRadioData::isSignalConnected(const QMetaMethod &signal)
  bool fp_QRadioData_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QRadioData::isSignalConnected(signal);
  }

  //  [expose] int QRadioData::receivers(const char *signal)
  int fp_QRadioData_receivers_c1731 (const char *signal) const {
    return QRadioData::receivers(signal);
  }

  //  [expose] QObject *QRadioData::sender()
  QObject * fp_QRadioData_sender_c0 () const {
    return QRadioData::sender();
  }

  //  [expose] int QRadioData::senderSignalIndex()
  int fp_QRadioData_senderSignalIndex_c0 () const {
    return QRadioData::senderSignalIndex();
  }

  //  [adaptor impl] bool QRadioData::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QRadioData::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QRadioData_Adaptor, bool, QEvent *>(&QRadioData_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QRadioData::event(arg1);
    }
  }

  //  [adaptor impl] bool QRadioData::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QRadioData::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QRadioData_Adaptor, bool, QObject *, QEvent *>(&QRadioData_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QRadioData::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] QMediaObject *QRadioData::mediaObject()
  QMediaObject * cbs_mediaObject_c0_0() const
  {
    return QRadioData::mediaObject();
  }

  virtual QMediaObject * mediaObject() const
  {
    if (cb_mediaObject_c0_0.can_issue()) {
      return cb_mediaObject_c0_0.issue<QRadioData_Adaptor, QMediaObject *>(&QRadioData_Adaptor::cbs_mediaObject_c0_0);
    } else {
      return QRadioData::mediaObject();
    }
  }

  //  [adaptor impl] void QRadioData::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QRadioData::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QRadioData_Adaptor, QChildEvent *>(&QRadioData_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QRadioData::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QRadioData::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QRadioData::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QRadioData_Adaptor, QEvent *>(&QRadioData_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QRadioData::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QRadioData::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QRadioData::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QRadioData_Adaptor, const QMetaMethod &>(&QRadioData_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QRadioData::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] bool QRadioData::setMediaObject(QMediaObject *)
  bool cbs_setMediaObject_1782_0(QMediaObject *arg1)
  {
    return QRadioData::setMediaObject(arg1);
  }

  virtual bool setMediaObject(QMediaObject *arg1)
  {
    if (cb_setMediaObject_1782_0.can_issue()) {
      return cb_setMediaObject_1782_0.issue<QRadioData_Adaptor, bool, QMediaObject *>(&QRadioData_Adaptor::cbs_setMediaObject_1782_0, arg1);
    } else {
      return QRadioData::setMediaObject(arg1);
    }
  }

  //  [adaptor impl] void QRadioData::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QRadioData::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QRadioData_Adaptor, QTimerEvent *>(&QRadioData_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QRadioData::timerEvent(arg1);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_mediaObject_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_setMediaObject_1782_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QRadioData_Adaptor::~QRadioData_Adaptor() { }

//  Constructor QRadioData::QRadioData(QMediaObject *mediaObject, QObject *parent) (adaptor class)

static void _init_ctor_QRadioData_Adaptor_2976 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mediaObject");
  decl->add_arg<QMediaObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QRadioData_Adaptor> ();
}

static void _call_ctor_QRadioData_Adaptor_2976 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMediaObject *arg1 = gsi::arg_reader<QMediaObject * >() (args, heap);
  QObject *arg2 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QRadioData_Adaptor *> (new QRadioData_Adaptor (arg1, arg2));
}


// void QRadioData::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioData_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioData_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QRadioData::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioData_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioData_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// void QRadioData::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioData_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioData_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QRadioData::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QRadioData_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioData_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QRadioData::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QRadioData_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioData_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed bool QRadioData::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QRadioData_Adaptor *)cls)->fp_QRadioData_isSignalConnected_c2394 (arg1));
}


// QMediaObject *QRadioData::mediaObject()

static void _init_cbs_mediaObject_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaObject * > ();
}

static void _call_cbs_mediaObject_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaObject * > ((QMediaObject *)((QRadioData_Adaptor *)cls)->cbs_mediaObject_c0_0 ());
}

static void _set_callback_cbs_mediaObject_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioData_Adaptor *)cls)->cb_mediaObject_c0_0 = cb;
}


// exposed int QRadioData::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QRadioData_Adaptor *)cls)->fp_QRadioData_receivers_c1731 (arg1));
}


// exposed QObject *QRadioData::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QRadioData_Adaptor *)cls)->fp_QRadioData_sender_c0 ());
}


// exposed int QRadioData::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QRadioData_Adaptor *)cls)->fp_QRadioData_senderSignalIndex_c0 ());
}


// bool QRadioData::setMediaObject(QMediaObject *)

static void _init_cbs_setMediaObject_1782_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMediaObject * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_setMediaObject_1782_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMediaObject *arg1 = args.read<QMediaObject * > (heap);
  ret.write<bool > ((bool)((QRadioData_Adaptor *)cls)->cbs_setMediaObject_1782_0 (arg1));
}

static void _set_callback_cbs_setMediaObject_1782_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioData_Adaptor *)cls)->cb_setMediaObject_1782_0 = cb;
}


// void QRadioData::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRadioData_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QRadioData_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QRadioData> &qtdecl_QRadioData ();

static gsi::Methods methods_QRadioData_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QRadioData::QRadioData(QMediaObject *mediaObject, QObject *parent)\nThis method creates an object of class QRadioData.", &_init_ctor_QRadioData_Adaptor_2976, &_call_ctor_QRadioData_Adaptor_2976);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QRadioData::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QRadioData::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QRadioData::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QRadioData::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QRadioData::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QRadioData::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("mediaObject", "@brief Virtual method QMediaObject *QRadioData::mediaObject()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mediaObject_c0_0, &_call_cbs_mediaObject_c0_0);
  methods += new qt_gsi::GenericMethod ("mediaObject", "@hide", true, &_init_cbs_mediaObject_c0_0, &_call_cbs_mediaObject_c0_0, &_set_callback_cbs_mediaObject_c0_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QRadioData::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QRadioData::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QRadioData::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*setMediaObject", "@brief Virtual method bool QRadioData::setMediaObject(QMediaObject *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setMediaObject_1782_0, &_call_cbs_setMediaObject_1782_0);
  methods += new qt_gsi::GenericMethod ("*setMediaObject", "@hide", false, &_init_cbs_setMediaObject_1782_0, &_call_cbs_setMediaObject_1782_0, &_set_callback_cbs_setMediaObject_1782_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QRadioData::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QRadioData_Adaptor> decl_QRadioData_Adaptor (qtdecl_QRadioData (), "QtMultimedia", "QRadioData",
  methods_QRadioData_Adaptor (),
  "@qt\n@brief Binding of QRadioData");

}


//  Implementation of the enum wrapper class for QRadioData::Error
namespace qt_gsi
{

static gsi::Enum<QRadioData::Error> decl_QRadioData_Error_Enum ("QtMultimedia", "QRadioData_Error",
    gsi::enum_const ("NoError", QRadioData::NoError, "@brief Enum constant QRadioData::NoError") +
    gsi::enum_const ("ResourceError", QRadioData::ResourceError, "@brief Enum constant QRadioData::ResourceError") +
    gsi::enum_const ("OpenError", QRadioData::OpenError, "@brief Enum constant QRadioData::OpenError") +
    gsi::enum_const ("OutOfRangeError", QRadioData::OutOfRangeError, "@brief Enum constant QRadioData::OutOfRangeError"),
  "@qt\n@brief This class represents the QRadioData::Error enum");

static gsi::QFlagsClass<QRadioData::Error > decl_QRadioData_Error_Enums ("QtMultimedia", "QRadioData_QFlags_Error",
  "@qt\n@brief This class represents the QFlags<QRadioData::Error> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QRadioData> inject_QRadioData_Error_Enum_in_parent (decl_QRadioData_Error_Enum.defs ());
static gsi::ClassExt<QRadioData> decl_QRadioData_Error_Enum_as_child (decl_QRadioData_Error_Enum, "Error");
static gsi::ClassExt<QRadioData> decl_QRadioData_Error_Enums_as_child (decl_QRadioData_Error_Enums, "QFlags_Error");

}


//  Implementation of the enum wrapper class for QRadioData::ProgramType
namespace qt_gsi
{

static gsi::Enum<QRadioData::ProgramType> decl_QRadioData_ProgramType_Enum ("QtMultimedia", "QRadioData_ProgramType",
    gsi::enum_const ("Undefined", QRadioData::Undefined, "@brief Enum constant QRadioData::Undefined") +
    gsi::enum_const ("News", QRadioData::News, "@brief Enum constant QRadioData::News") +
    gsi::enum_const ("CurrentAffairs", QRadioData::CurrentAffairs, "@brief Enum constant QRadioData::CurrentAffairs") +
    gsi::enum_const ("Information", QRadioData::Information, "@brief Enum constant QRadioData::Information") +
    gsi::enum_const ("Sport", QRadioData::Sport, "@brief Enum constant QRadioData::Sport") +
    gsi::enum_const ("Education", QRadioData::Education, "@brief Enum constant QRadioData::Education") +
    gsi::enum_const ("Drama", QRadioData::Drama, "@brief Enum constant QRadioData::Drama") +
    gsi::enum_const ("Culture", QRadioData::Culture, "@brief Enum constant QRadioData::Culture") +
    gsi::enum_const ("Science", QRadioData::Science, "@brief Enum constant QRadioData::Science") +
    gsi::enum_const ("Varied", QRadioData::Varied, "@brief Enum constant QRadioData::Varied") +
    gsi::enum_const ("PopMusic", QRadioData::PopMusic, "@brief Enum constant QRadioData::PopMusic") +
    gsi::enum_const ("RockMusic", QRadioData::RockMusic, "@brief Enum constant QRadioData::RockMusic") +
    gsi::enum_const ("EasyListening", QRadioData::EasyListening, "@brief Enum constant QRadioData::EasyListening") +
    gsi::enum_const ("LightClassical", QRadioData::LightClassical, "@brief Enum constant QRadioData::LightClassical") +
    gsi::enum_const ("SeriousClassical", QRadioData::SeriousClassical, "@brief Enum constant QRadioData::SeriousClassical") +
    gsi::enum_const ("OtherMusic", QRadioData::OtherMusic, "@brief Enum constant QRadioData::OtherMusic") +
    gsi::enum_const ("Weather", QRadioData::Weather, "@brief Enum constant QRadioData::Weather") +
    gsi::enum_const ("Finance", QRadioData::Finance, "@brief Enum constant QRadioData::Finance") +
    gsi::enum_const ("ChildrensProgrammes", QRadioData::ChildrensProgrammes, "@brief Enum constant QRadioData::ChildrensProgrammes") +
    gsi::enum_const ("SocialAffairs", QRadioData::SocialAffairs, "@brief Enum constant QRadioData::SocialAffairs") +
    gsi::enum_const ("Religion", QRadioData::Religion, "@brief Enum constant QRadioData::Religion") +
    gsi::enum_const ("PhoneIn", QRadioData::PhoneIn, "@brief Enum constant QRadioData::PhoneIn") +
    gsi::enum_const ("Travel", QRadioData::Travel, "@brief Enum constant QRadioData::Travel") +
    gsi::enum_const ("Leisure", QRadioData::Leisure, "@brief Enum constant QRadioData::Leisure") +
    gsi::enum_const ("JazzMusic", QRadioData::JazzMusic, "@brief Enum constant QRadioData::JazzMusic") +
    gsi::enum_const ("CountryMusic", QRadioData::CountryMusic, "@brief Enum constant QRadioData::CountryMusic") +
    gsi::enum_const ("NationalMusic", QRadioData::NationalMusic, "@brief Enum constant QRadioData::NationalMusic") +
    gsi::enum_const ("OldiesMusic", QRadioData::OldiesMusic, "@brief Enum constant QRadioData::OldiesMusic") +
    gsi::enum_const ("FolkMusic", QRadioData::FolkMusic, "@brief Enum constant QRadioData::FolkMusic") +
    gsi::enum_const ("Documentary", QRadioData::Documentary, "@brief Enum constant QRadioData::Documentary") +
    gsi::enum_const ("AlarmTest", QRadioData::AlarmTest, "@brief Enum constant QRadioData::AlarmTest") +
    gsi::enum_const ("Alarm", QRadioData::Alarm, "@brief Enum constant QRadioData::Alarm") +
    gsi::enum_const ("Talk", QRadioData::Talk, "@brief Enum constant QRadioData::Talk") +
    gsi::enum_const ("ClassicRock", QRadioData::ClassicRock, "@brief Enum constant QRadioData::ClassicRock") +
    gsi::enum_const ("AdultHits", QRadioData::AdultHits, "@brief Enum constant QRadioData::AdultHits") +
    gsi::enum_const ("SoftRock", QRadioData::SoftRock, "@brief Enum constant QRadioData::SoftRock") +
    gsi::enum_const ("Top40", QRadioData::Top40, "@brief Enum constant QRadioData::Top40") +
    gsi::enum_const ("Soft", QRadioData::Soft, "@brief Enum constant QRadioData::Soft") +
    gsi::enum_const ("Nostalgia", QRadioData::Nostalgia, "@brief Enum constant QRadioData::Nostalgia") +
    gsi::enum_const ("Classical", QRadioData::Classical, "@brief Enum constant QRadioData::Classical") +
    gsi::enum_const ("RhythmAndBlues", QRadioData::RhythmAndBlues, "@brief Enum constant QRadioData::RhythmAndBlues") +
    gsi::enum_const ("SoftRhythmAndBlues", QRadioData::SoftRhythmAndBlues, "@brief Enum constant QRadioData::SoftRhythmAndBlues") +
    gsi::enum_const ("Language", QRadioData::Language, "@brief Enum constant QRadioData::Language") +
    gsi::enum_const ("ReligiousMusic", QRadioData::ReligiousMusic, "@brief Enum constant QRadioData::ReligiousMusic") +
    gsi::enum_const ("ReligiousTalk", QRadioData::ReligiousTalk, "@brief Enum constant QRadioData::ReligiousTalk") +
    gsi::enum_const ("Personality", QRadioData::Personality, "@brief Enum constant QRadioData::Personality") +
    gsi::enum_const ("Public", QRadioData::Public, "@brief Enum constant QRadioData::Public") +
    gsi::enum_const ("College", QRadioData::College, "@brief Enum constant QRadioData::College"),
  "@qt\n@brief This class represents the QRadioData::ProgramType enum");

static gsi::QFlagsClass<QRadioData::ProgramType > decl_QRadioData_ProgramType_Enums ("QtMultimedia", "QRadioData_QFlags_ProgramType",
  "@qt\n@brief This class represents the QFlags<QRadioData::ProgramType> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QRadioData> inject_QRadioData_ProgramType_Enum_in_parent (decl_QRadioData_ProgramType_Enum.defs ());
static gsi::ClassExt<QRadioData> decl_QRadioData_ProgramType_Enum_as_child (decl_QRadioData_ProgramType_Enum, "ProgramType");
static gsi::ClassExt<QRadioData> decl_QRadioData_ProgramType_Enums_as_child (decl_QRadioData_ProgramType_Enums, "QFlags_ProgramType");

}

