set -e

# prepare test environment
prepare() {
    cp -a default.build.properties Gemfile Rakefile rakelib spec test "$AUTOPKGTEST_TMP"
    ln -s /usr/share/jruby/bin "$AUTOPKGTEST_TMP/bin"
    ln -s /usr/share/jruby/lib "$AUTOPKGTEST_TMP/lib"
    export LANG=C.UTF-8
    export LC_ALL=C.UTF-8
}

# install rspec for jruby
# requires the ruby-spec debian package
install_rspec() {
    sudo mkdir -p /usr/share/jruby/lib/ruby/gems/shared/gems
    sudo mkdir -p /usr/share/jruby/lib/ruby/gems/shared/specifications
    for gem in diff-lcs minitest power_assert rake rspec rspec-core rspec-expectations rspec-mocks rspec-support test-unit; do
        # some gems are copied from libruby*, others from local rubygems
        if test -e /usr/lib/ruby/gems/*/gems/${gem}-*; then
            gembase="/usr/lib/ruby/gems/*"
        else
            gembase=/usr/share/rubygems-integration/all
        fi
        echo "installing ${gem} gem into jruby ..."
        sudo cp -a ${gembase}/gems/${gem}-* /usr/share/jruby/lib/ruby/gems/shared/gems
        sudo cp -a ${gembase}/specifications/${gem}-* /usr/share/jruby/lib/ruby/gems/shared/specifications
    done
    mkdir -p ./bin
    # installing bin/rake for jruby
    sudo cp /usr/bin/rake ./bin/rake
    sed -i '1s|^#!.*|#!/usr/bin/jruby|' ./bin/rake
}
