// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file monitorservice_types.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifndef FAST_DDS_GENERATED__EPROSIMA_FASTDDS_STATISTICS_MONITORSERVICE_TYPES_HPP
#define FAST_DDS_GENERATED__EPROSIMA_FASTDDS_STATISTICS_MONITORSERVICE_TYPES_HPP

#include <array>
#include <cstdint>
#include <functional>
#include <utility>
#include <vector>

#include <fastcdr/exceptions/BadParamException.h>

#include "types.hpp"

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(MONITORSERVICE_TYPES_SOURCE)
#define MONITORSERVICE_TYPES_DllAPI __declspec( dllexport )
#else
#define MONITORSERVICE_TYPES_DllAPI __declspec( dllimport )
#endif // MONITORSERVICE_TYPES_SOURCE
#else
#define MONITORSERVICE_TYPES_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define MONITORSERVICE_TYPES_DllAPI
#endif // _WIN32

namespace eprosima {

namespace fastdds {

namespace statistics {

/*!
 * @brief This class represents the enumeration ConnectionMode defined by the user in the IDL file.
 * @ingroup monitorservice_types
 */
enum class ConnectionMode : int32_t
{
    DATA_SHARING,
    INTRAPROCESS,
    TRANSPORT
};
/*!
 * @brief This class represents the structure Connection defined by the user in the IDL file.
 * @ingroup monitorservice_types
 */
class Connection
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Connection()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Connection()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Connection that will be copied.
     */
    eProsima_user_DllExport Connection(
            const Connection& x)
    {
                    m_mode = x.m_mode;

                    m_guid = x.m_guid;

                    m_announced_locators = x.m_announced_locators;

                    m_used_locators = x.m_used_locators;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Connection that will be copied.
     */
    eProsima_user_DllExport Connection(
            Connection&& x) noexcept
    {
        m_mode = x.m_mode;
        m_guid = std::move(x.m_guid);
        m_announced_locators = std::move(x.m_announced_locators);
        m_used_locators = std::move(x.m_used_locators);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Connection that will be copied.
     */
    eProsima_user_DllExport Connection& operator =(
            const Connection& x)
    {

                    m_mode = x.m_mode;

                    m_guid = x.m_guid;

                    m_announced_locators = x.m_announced_locators;

                    m_used_locators = x.m_used_locators;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Connection that will be copied.
     */
    eProsima_user_DllExport Connection& operator =(
            Connection&& x) noexcept
    {

        m_mode = x.m_mode;
        m_guid = std::move(x.m_guid);
        m_announced_locators = std::move(x.m_announced_locators);
        m_used_locators = std::move(x.m_used_locators);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Connection object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Connection& x) const
    {
        return (m_mode == x.m_mode &&
           m_guid == x.m_guid &&
           m_announced_locators == x.m_announced_locators &&
           m_used_locators == x.m_used_locators);
    }

    /*!
     * @brief Comparison operator.
     * @param x Connection object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Connection& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member mode
     * @param _mode New value for member mode
     */
    eProsima_user_DllExport void mode(
            ConnectionMode _mode)
    {
        m_mode = _mode;
    }

    /*!
     * @brief This function returns the value of member mode
     * @return Value of member mode
     */
    eProsima_user_DllExport ConnectionMode mode() const
    {
        return m_mode;
    }

    /*!
     * @brief This function returns a reference to member mode
     * @return Reference to member mode
     */
    eProsima_user_DllExport ConnectionMode& mode()
    {
        return m_mode;
    }


    /*!
     * @brief This function copies the value in member guid
     * @param _guid New value to be copied in member guid
     */
    eProsima_user_DllExport void guid(
            const detail::GUID_s& _guid)
    {
        m_guid = _guid;
    }

    /*!
     * @brief This function moves the value in member guid
     * @param _guid New value to be moved in member guid
     */
    eProsima_user_DllExport void guid(
            detail::GUID_s&& _guid)
    {
        m_guid = std::move(_guid);
    }

    /*!
     * @brief This function returns a constant reference to member guid
     * @return Constant reference to member guid
     */
    eProsima_user_DllExport const detail::GUID_s& guid() const
    {
        return m_guid;
    }

    /*!
     * @brief This function returns a reference to member guid
     * @return Reference to member guid
     */
    eProsima_user_DllExport detail::GUID_s& guid()
    {
        return m_guid;
    }


    /*!
     * @brief This function copies the value in member announced_locators
     * @param _announced_locators New value to be copied in member announced_locators
     */
    eProsima_user_DllExport void announced_locators(
            const std::vector<detail::Locator_s>& _announced_locators)
    {
        m_announced_locators = _announced_locators;
    }

    /*!
     * @brief This function moves the value in member announced_locators
     * @param _announced_locators New value to be moved in member announced_locators
     */
    eProsima_user_DllExport void announced_locators(
            std::vector<detail::Locator_s>&& _announced_locators)
    {
        m_announced_locators = std::move(_announced_locators);
    }

    /*!
     * @brief This function returns a constant reference to member announced_locators
     * @return Constant reference to member announced_locators
     */
    eProsima_user_DllExport const std::vector<detail::Locator_s>& announced_locators() const
    {
        return m_announced_locators;
    }

    /*!
     * @brief This function returns a reference to member announced_locators
     * @return Reference to member announced_locators
     */
    eProsima_user_DllExport std::vector<detail::Locator_s>& announced_locators()
    {
        return m_announced_locators;
    }


    /*!
     * @brief This function copies the value in member used_locators
     * @param _used_locators New value to be copied in member used_locators
     */
    eProsima_user_DllExport void used_locators(
            const std::vector<detail::Locator_s>& _used_locators)
    {
        m_used_locators = _used_locators;
    }

    /*!
     * @brief This function moves the value in member used_locators
     * @param _used_locators New value to be moved in member used_locators
     */
    eProsima_user_DllExport void used_locators(
            std::vector<detail::Locator_s>&& _used_locators)
    {
        m_used_locators = std::move(_used_locators);
    }

    /*!
     * @brief This function returns a constant reference to member used_locators
     * @return Constant reference to member used_locators
     */
    eProsima_user_DllExport const std::vector<detail::Locator_s>& used_locators() const
    {
        return m_used_locators;
    }

    /*!
     * @brief This function returns a reference to member used_locators
     * @return Reference to member used_locators
     */
    eProsima_user_DllExport std::vector<detail::Locator_s>& used_locators()
    {
        return m_used_locators;
    }



private:

    ConnectionMode m_mode{ConnectionMode::DATA_SHARING};
    detail::GUID_s m_guid;
    std::vector<detail::Locator_s> m_announced_locators;
    std::vector<detail::Locator_s> m_used_locators;

};
/*!
 * @brief This class represents the structure QosPolicyCount_s defined by the user in the IDL file.
 * @ingroup monitorservice_types
 */
class QosPolicyCount_s
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport QosPolicyCount_s()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~QosPolicyCount_s()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object QosPolicyCount_s that will be copied.
     */
    eProsima_user_DllExport QosPolicyCount_s(
            const QosPolicyCount_s& x)
    {
                    m_policy_id = x.m_policy_id;

                    m_count = x.m_count;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object QosPolicyCount_s that will be copied.
     */
    eProsima_user_DllExport QosPolicyCount_s(
            QosPolicyCount_s&& x) noexcept
    {
        m_policy_id = x.m_policy_id;
        m_count = x.m_count;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object QosPolicyCount_s that will be copied.
     */
    eProsima_user_DllExport QosPolicyCount_s& operator =(
            const QosPolicyCount_s& x)
    {

                    m_policy_id = x.m_policy_id;

                    m_count = x.m_count;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object QosPolicyCount_s that will be copied.
     */
    eProsima_user_DllExport QosPolicyCount_s& operator =(
            QosPolicyCount_s&& x) noexcept
    {

        m_policy_id = x.m_policy_id;
        m_count = x.m_count;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x QosPolicyCount_s object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const QosPolicyCount_s& x) const
    {
        return (m_policy_id == x.m_policy_id &&
           m_count == x.m_count);
    }

    /*!
     * @brief Comparison operator.
     * @param x QosPolicyCount_s object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const QosPolicyCount_s& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member policy_id
     * @param _policy_id New value for member policy_id
     */
    eProsima_user_DllExport void policy_id(
            uint32_t _policy_id)
    {
        m_policy_id = _policy_id;
    }

    /*!
     * @brief This function returns the value of member policy_id
     * @return Value of member policy_id
     */
    eProsima_user_DllExport uint32_t policy_id() const
    {
        return m_policy_id;
    }

    /*!
     * @brief This function returns a reference to member policy_id
     * @return Reference to member policy_id
     */
    eProsima_user_DllExport uint32_t& policy_id()
    {
        return m_policy_id;
    }


    /*!
     * @brief This function sets a value in member count
     * @param _count New value for member count
     */
    eProsima_user_DllExport void count(
            uint32_t _count)
    {
        m_count = _count;
    }

    /*!
     * @brief This function returns the value of member count
     * @return Value of member count
     */
    eProsima_user_DllExport uint32_t count() const
    {
        return m_count;
    }

    /*!
     * @brief This function returns a reference to member count
     * @return Reference to member count
     */
    eProsima_user_DllExport uint32_t& count()
    {
        return m_count;
    }



private:

    uint32_t m_policy_id{0};
    uint32_t m_count{0};

};
/*!
 * @brief This class represents the structure BaseStatus_s defined by the user in the IDL file.
 * @ingroup monitorservice_types
 */
class BaseStatus_s
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport BaseStatus_s()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~BaseStatus_s()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object BaseStatus_s that will be copied.
     */
    eProsima_user_DllExport BaseStatus_s(
            const BaseStatus_s& x)
    {
                    m_total_count = x.m_total_count;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object BaseStatus_s that will be copied.
     */
    eProsima_user_DllExport BaseStatus_s(
            BaseStatus_s&& x) noexcept
    {
        m_total_count = x.m_total_count;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object BaseStatus_s that will be copied.
     */
    eProsima_user_DllExport BaseStatus_s& operator =(
            const BaseStatus_s& x)
    {

                    m_total_count = x.m_total_count;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object BaseStatus_s that will be copied.
     */
    eProsima_user_DllExport BaseStatus_s& operator =(
            BaseStatus_s&& x) noexcept
    {

        m_total_count = x.m_total_count;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x BaseStatus_s object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const BaseStatus_s& x) const
    {
        return (m_total_count == x.m_total_count);
    }

    /*!
     * @brief Comparison operator.
     * @param x BaseStatus_s object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const BaseStatus_s& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member total_count
     * @param _total_count New value for member total_count
     */
    eProsima_user_DllExport void total_count(
            uint32_t _total_count)
    {
        m_total_count = _total_count;
    }

    /*!
     * @brief This function returns the value of member total_count
     * @return Value of member total_count
     */
    eProsima_user_DllExport uint32_t total_count() const
    {
        return m_total_count;
    }

    /*!
     * @brief This function returns a reference to member total_count
     * @return Reference to member total_count
     */
    eProsima_user_DllExport uint32_t& total_count()
    {
        return m_total_count;
    }



private:

    uint32_t m_total_count{0};

};
typedef std::vector<QosPolicyCount_s> QosPolicyCountSeq_s;

/*!
 * @brief This class represents the structure IncompatibleQoSStatus_s defined by the user in the IDL file.
 * @ingroup monitorservice_types
 */
class IncompatibleQoSStatus_s
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport IncompatibleQoSStatus_s()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~IncompatibleQoSStatus_s()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object IncompatibleQoSStatus_s that will be copied.
     */
    eProsima_user_DllExport IncompatibleQoSStatus_s(
            const IncompatibleQoSStatus_s& x)
    {
                    m_total_count = x.m_total_count;

                    m_last_policy_id = x.m_last_policy_id;

                    m_policies = x.m_policies;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object IncompatibleQoSStatus_s that will be copied.
     */
    eProsima_user_DllExport IncompatibleQoSStatus_s(
            IncompatibleQoSStatus_s&& x) noexcept
    {
        m_total_count = x.m_total_count;
        m_last_policy_id = x.m_last_policy_id;
        m_policies = std::move(x.m_policies);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object IncompatibleQoSStatus_s that will be copied.
     */
    eProsima_user_DllExport IncompatibleQoSStatus_s& operator =(
            const IncompatibleQoSStatus_s& x)
    {

                    m_total_count = x.m_total_count;

                    m_last_policy_id = x.m_last_policy_id;

                    m_policies = x.m_policies;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object IncompatibleQoSStatus_s that will be copied.
     */
    eProsima_user_DllExport IncompatibleQoSStatus_s& operator =(
            IncompatibleQoSStatus_s&& x) noexcept
    {

        m_total_count = x.m_total_count;
        m_last_policy_id = x.m_last_policy_id;
        m_policies = std::move(x.m_policies);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x IncompatibleQoSStatus_s object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const IncompatibleQoSStatus_s& x) const
    {
        return (m_total_count == x.m_total_count &&
           m_last_policy_id == x.m_last_policy_id &&
           m_policies == x.m_policies);
    }

    /*!
     * @brief Comparison operator.
     * @param x IncompatibleQoSStatus_s object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const IncompatibleQoSStatus_s& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member total_count
     * @param _total_count New value for member total_count
     */
    eProsima_user_DllExport void total_count(
            uint32_t _total_count)
    {
        m_total_count = _total_count;
    }

    /*!
     * @brief This function returns the value of member total_count
     * @return Value of member total_count
     */
    eProsima_user_DllExport uint32_t total_count() const
    {
        return m_total_count;
    }

    /*!
     * @brief This function returns a reference to member total_count
     * @return Reference to member total_count
     */
    eProsima_user_DllExport uint32_t& total_count()
    {
        return m_total_count;
    }


    /*!
     * @brief This function sets a value in member last_policy_id
     * @param _last_policy_id New value for member last_policy_id
     */
    eProsima_user_DllExport void last_policy_id(
            uint32_t _last_policy_id)
    {
        m_last_policy_id = _last_policy_id;
    }

    /*!
     * @brief This function returns the value of member last_policy_id
     * @return Value of member last_policy_id
     */
    eProsima_user_DllExport uint32_t last_policy_id() const
    {
        return m_last_policy_id;
    }

    /*!
     * @brief This function returns a reference to member last_policy_id
     * @return Reference to member last_policy_id
     */
    eProsima_user_DllExport uint32_t& last_policy_id()
    {
        return m_last_policy_id;
    }


    /*!
     * @brief This function copies the value in member policies
     * @param _policies New value to be copied in member policies
     */
    eProsima_user_DllExport void policies(
            const QosPolicyCountSeq_s& _policies)
    {
        m_policies = _policies;
    }

    /*!
     * @brief This function moves the value in member policies
     * @param _policies New value to be moved in member policies
     */
    eProsima_user_DllExport void policies(
            QosPolicyCountSeq_s&& _policies)
    {
        m_policies = std::move(_policies);
    }

    /*!
     * @brief This function returns a constant reference to member policies
     * @return Constant reference to member policies
     */
    eProsima_user_DllExport const QosPolicyCountSeq_s& policies() const
    {
        return m_policies;
    }

    /*!
     * @brief This function returns a reference to member policies
     * @return Reference to member policies
     */
    eProsima_user_DllExport QosPolicyCountSeq_s& policies()
    {
        return m_policies;
    }



private:

    uint32_t m_total_count{0};
    uint32_t m_last_policy_id{0};
    QosPolicyCountSeq_s m_policies;

};
/*!
 * @brief This class represents the structure LivelinessChangedStatus_s defined by the user in the IDL file.
 * @ingroup monitorservice_types
 */
class LivelinessChangedStatus_s
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport LivelinessChangedStatus_s()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~LivelinessChangedStatus_s()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object LivelinessChangedStatus_s that will be copied.
     */
    eProsima_user_DllExport LivelinessChangedStatus_s(
            const LivelinessChangedStatus_s& x)
    {
                    m_alive_count = x.m_alive_count;

                    m_not_alive_count = x.m_not_alive_count;

                    m_last_publication_handle = x.m_last_publication_handle;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object LivelinessChangedStatus_s that will be copied.
     */
    eProsima_user_DllExport LivelinessChangedStatus_s(
            LivelinessChangedStatus_s&& x) noexcept
    {
        m_alive_count = x.m_alive_count;
        m_not_alive_count = x.m_not_alive_count;
        m_last_publication_handle = std::move(x.m_last_publication_handle);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object LivelinessChangedStatus_s that will be copied.
     */
    eProsima_user_DllExport LivelinessChangedStatus_s& operator =(
            const LivelinessChangedStatus_s& x)
    {

                    m_alive_count = x.m_alive_count;

                    m_not_alive_count = x.m_not_alive_count;

                    m_last_publication_handle = x.m_last_publication_handle;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object LivelinessChangedStatus_s that will be copied.
     */
    eProsima_user_DllExport LivelinessChangedStatus_s& operator =(
            LivelinessChangedStatus_s&& x) noexcept
    {

        m_alive_count = x.m_alive_count;
        m_not_alive_count = x.m_not_alive_count;
        m_last_publication_handle = std::move(x.m_last_publication_handle);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x LivelinessChangedStatus_s object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const LivelinessChangedStatus_s& x) const
    {
        return (m_alive_count == x.m_alive_count &&
           m_not_alive_count == x.m_not_alive_count &&
           m_last_publication_handle == x.m_last_publication_handle);
    }

    /*!
     * @brief Comparison operator.
     * @param x LivelinessChangedStatus_s object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const LivelinessChangedStatus_s& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member alive_count
     * @param _alive_count New value for member alive_count
     */
    eProsima_user_DllExport void alive_count(
            uint32_t _alive_count)
    {
        m_alive_count = _alive_count;
    }

    /*!
     * @brief This function returns the value of member alive_count
     * @return Value of member alive_count
     */
    eProsima_user_DllExport uint32_t alive_count() const
    {
        return m_alive_count;
    }

    /*!
     * @brief This function returns a reference to member alive_count
     * @return Reference to member alive_count
     */
    eProsima_user_DllExport uint32_t& alive_count()
    {
        return m_alive_count;
    }


    /*!
     * @brief This function sets a value in member not_alive_count
     * @param _not_alive_count New value for member not_alive_count
     */
    eProsima_user_DllExport void not_alive_count(
            uint32_t _not_alive_count)
    {
        m_not_alive_count = _not_alive_count;
    }

    /*!
     * @brief This function returns the value of member not_alive_count
     * @return Value of member not_alive_count
     */
    eProsima_user_DllExport uint32_t not_alive_count() const
    {
        return m_not_alive_count;
    }

    /*!
     * @brief This function returns a reference to member not_alive_count
     * @return Reference to member not_alive_count
     */
    eProsima_user_DllExport uint32_t& not_alive_count()
    {
        return m_not_alive_count;
    }


    /*!
     * @brief This function copies the value in member last_publication_handle
     * @param _last_publication_handle New value to be copied in member last_publication_handle
     */
    eProsima_user_DllExport void last_publication_handle(
            const std::array<uint8_t, 16>& _last_publication_handle)
    {
        m_last_publication_handle = _last_publication_handle;
    }

    /*!
     * @brief This function moves the value in member last_publication_handle
     * @param _last_publication_handle New value to be moved in member last_publication_handle
     */
    eProsima_user_DllExport void last_publication_handle(
            std::array<uint8_t, 16>&& _last_publication_handle)
    {
        m_last_publication_handle = std::move(_last_publication_handle);
    }

    /*!
     * @brief This function returns a constant reference to member last_publication_handle
     * @return Constant reference to member last_publication_handle
     */
    eProsima_user_DllExport const std::array<uint8_t, 16>& last_publication_handle() const
    {
        return m_last_publication_handle;
    }

    /*!
     * @brief This function returns a reference to member last_publication_handle
     * @return Reference to member last_publication_handle
     */
    eProsima_user_DllExport std::array<uint8_t, 16>& last_publication_handle()
    {
        return m_last_publication_handle;
    }



private:

    uint32_t m_alive_count{0};
    uint32_t m_not_alive_count{0};
    std::array<uint8_t, 16> m_last_publication_handle{0};

};
/*!
 * @brief This class represents the structure DeadlineMissedStatus_s defined by the user in the IDL file.
 * @ingroup monitorservice_types
 */
class DeadlineMissedStatus_s
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport DeadlineMissedStatus_s()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~DeadlineMissedStatus_s()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object DeadlineMissedStatus_s that will be copied.
     */
    eProsima_user_DllExport DeadlineMissedStatus_s(
            const DeadlineMissedStatus_s& x)
    {
                    m_total_count = x.m_total_count;

                    m_last_instance_handle = x.m_last_instance_handle;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object DeadlineMissedStatus_s that will be copied.
     */
    eProsima_user_DllExport DeadlineMissedStatus_s(
            DeadlineMissedStatus_s&& x) noexcept
    {
        m_total_count = x.m_total_count;
        m_last_instance_handle = std::move(x.m_last_instance_handle);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object DeadlineMissedStatus_s that will be copied.
     */
    eProsima_user_DllExport DeadlineMissedStatus_s& operator =(
            const DeadlineMissedStatus_s& x)
    {

                    m_total_count = x.m_total_count;

                    m_last_instance_handle = x.m_last_instance_handle;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object DeadlineMissedStatus_s that will be copied.
     */
    eProsima_user_DllExport DeadlineMissedStatus_s& operator =(
            DeadlineMissedStatus_s&& x) noexcept
    {

        m_total_count = x.m_total_count;
        m_last_instance_handle = std::move(x.m_last_instance_handle);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x DeadlineMissedStatus_s object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const DeadlineMissedStatus_s& x) const
    {
        return (m_total_count == x.m_total_count &&
           m_last_instance_handle == x.m_last_instance_handle);
    }

    /*!
     * @brief Comparison operator.
     * @param x DeadlineMissedStatus_s object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const DeadlineMissedStatus_s& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member total_count
     * @param _total_count New value for member total_count
     */
    eProsima_user_DllExport void total_count(
            uint32_t _total_count)
    {
        m_total_count = _total_count;
    }

    /*!
     * @brief This function returns the value of member total_count
     * @return Value of member total_count
     */
    eProsima_user_DllExport uint32_t total_count() const
    {
        return m_total_count;
    }

    /*!
     * @brief This function returns a reference to member total_count
     * @return Reference to member total_count
     */
    eProsima_user_DllExport uint32_t& total_count()
    {
        return m_total_count;
    }


    /*!
     * @brief This function copies the value in member last_instance_handle
     * @param _last_instance_handle New value to be copied in member last_instance_handle
     */
    eProsima_user_DllExport void last_instance_handle(
            const std::array<uint8_t, 16>& _last_instance_handle)
    {
        m_last_instance_handle = _last_instance_handle;
    }

    /*!
     * @brief This function moves the value in member last_instance_handle
     * @param _last_instance_handle New value to be moved in member last_instance_handle
     */
    eProsima_user_DllExport void last_instance_handle(
            std::array<uint8_t, 16>&& _last_instance_handle)
    {
        m_last_instance_handle = std::move(_last_instance_handle);
    }

    /*!
     * @brief This function returns a constant reference to member last_instance_handle
     * @return Constant reference to member last_instance_handle
     */
    eProsima_user_DllExport const std::array<uint8_t, 16>& last_instance_handle() const
    {
        return m_last_instance_handle;
    }

    /*!
     * @brief This function returns a reference to member last_instance_handle
     * @return Reference to member last_instance_handle
     */
    eProsima_user_DllExport std::array<uint8_t, 16>& last_instance_handle()
    {
        return m_last_instance_handle;
    }



private:

    uint32_t m_total_count{0};
    std::array<uint8_t, 16> m_last_instance_handle{0};

};
typedef BaseStatus_s LivelinessLostStatus_s;

typedef BaseStatus_s InconsistentTopicStatus_s;

typedef BaseStatus_s SampleLostStatus_s;

namespace StatusKind {

typedef uint32_t StatusKind;

const StatusKind PROXY = 0;
const StatusKind CONNECTION_LIST = 1;
const StatusKind INCOMPATIBLE_QOS = 2;
const StatusKind INCONSISTENT_TOPIC = 3;
const StatusKind LIVELINESS_LOST = 4;
const StatusKind LIVELINESS_CHANGED = 5;
const StatusKind DEADLINE_MISSED = 6;
const StatusKind SAMPLE_LOST = 7;
const StatusKind STATUSES_SIZE = 8;

} // namespace StatusKind
/*!
 * @brief This class represents the union MonitorServiceData defined by the user in the IDL file.
 * @ingroup monitorservice_types
 */
class MonitorServiceData
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MonitorServiceData()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MonitorServiceData()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MonitorServiceData that will be copied.
     */
    eProsima_user_DllExport MonitorServiceData(
            const MonitorServiceData& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            entity_proxy_() = x.m_entity_proxy;
                            break;

                        case 0x00000002:
                            connection_list_() = x.m_connection_list;
                            break;

                        case 0x00000003:
                            incompatible_qos_status_() = x.m_incompatible_qos_status;
                            break;

                        case 0x00000004:
                            inconsistent_topic_status_() = x.m_inconsistent_topic_status;
                            break;

                        case 0x00000005:
                            liveliness_lost_status_() = x.m_liveliness_lost_status;
                            break;

                        case 0x00000006:
                            liveliness_changed_status_() = x.m_liveliness_changed_status;
                            break;

                        case 0x00000007:
                            deadline_missed_status_() = x.m_deadline_missed_status;
                            break;

                        case 0x00000008:
                            sample_lost_status_() = x.m_sample_lost_status;
                            break;

                        case 0x00000009:
                            statuses_size_() = x.m_statuses_size;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MonitorServiceData that will be copied.
     */
    eProsima_user_DllExport MonitorServiceData(
            MonitorServiceData&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            entity_proxy_() = std::move(x.m_entity_proxy);
                            break;

                        case 0x00000002:
                            connection_list_() = std::move(x.m_connection_list);
                            break;

                        case 0x00000003:
                            incompatible_qos_status_() = std::move(x.m_incompatible_qos_status);
                            break;

                        case 0x00000004:
                            inconsistent_topic_status_() = std::move(x.m_inconsistent_topic_status);
                            break;

                        case 0x00000005:
                            liveliness_lost_status_() = std::move(x.m_liveliness_lost_status);
                            break;

                        case 0x00000006:
                            liveliness_changed_status_() = std::move(x.m_liveliness_changed_status);
                            break;

                        case 0x00000007:
                            deadline_missed_status_() = std::move(x.m_deadline_missed_status);
                            break;

                        case 0x00000008:
                            sample_lost_status_() = std::move(x.m_sample_lost_status);
                            break;

                        case 0x00000009:
                            statuses_size_() = std::move(x.m_statuses_size);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MonitorServiceData that will be copied.
     */
    eProsima_user_DllExport MonitorServiceData& operator =(
            const MonitorServiceData& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            entity_proxy_() = x.m_entity_proxy;
                            break;

                        case 0x00000002:
                            connection_list_() = x.m_connection_list;
                            break;

                        case 0x00000003:
                            incompatible_qos_status_() = x.m_incompatible_qos_status;
                            break;

                        case 0x00000004:
                            inconsistent_topic_status_() = x.m_inconsistent_topic_status;
                            break;

                        case 0x00000005:
                            liveliness_lost_status_() = x.m_liveliness_lost_status;
                            break;

                        case 0x00000006:
                            liveliness_changed_status_() = x.m_liveliness_changed_status;
                            break;

                        case 0x00000007:
                            deadline_missed_status_() = x.m_deadline_missed_status;
                            break;

                        case 0x00000008:
                            sample_lost_status_() = x.m_sample_lost_status;
                            break;

                        case 0x00000009:
                            statuses_size_() = x.m_statuses_size;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MonitorServiceData that will be copied.
     */
    eProsima_user_DllExport MonitorServiceData& operator =(
            MonitorServiceData&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            entity_proxy_() = std::move(x.m_entity_proxy);
                            break;

                        case 0x00000002:
                            connection_list_() = std::move(x.m_connection_list);
                            break;

                        case 0x00000003:
                            incompatible_qos_status_() = std::move(x.m_incompatible_qos_status);
                            break;

                        case 0x00000004:
                            inconsistent_topic_status_() = std::move(x.m_inconsistent_topic_status);
                            break;

                        case 0x00000005:
                            liveliness_lost_status_() = std::move(x.m_liveliness_lost_status);
                            break;

                        case 0x00000006:
                            liveliness_changed_status_() = std::move(x.m_liveliness_changed_status);
                            break;

                        case 0x00000007:
                            deadline_missed_status_() = std::move(x.m_deadline_missed_status);
                            break;

                        case 0x00000008:
                            sample_lost_status_() = std::move(x.m_sample_lost_status);
                            break;

                        case 0x00000009:
                            statuses_size_() = std::move(x.m_statuses_size);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MonitorServiceData object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MonitorServiceData& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_entity_proxy == m_entity_proxy);
                                                        break;

                                                    case 0x00000002:
                                                        ret_value = (x.m_connection_list == m_connection_list);
                                                        break;

                                                    case 0x00000003:
                                                        ret_value = (x.m_incompatible_qos_status == m_incompatible_qos_status);
                                                        break;

                                                    case 0x00000004:
                                                        ret_value = (x.m_inconsistent_topic_status == m_inconsistent_topic_status);
                                                        break;

                                                    case 0x00000005:
                                                        ret_value = (x.m_liveliness_lost_status == m_liveliness_lost_status);
                                                        break;

                                                    case 0x00000006:
                                                        ret_value = (x.m_liveliness_changed_status == m_liveliness_changed_status);
                                                        break;

                                                    case 0x00000007:
                                                        ret_value = (x.m_deadline_missed_status == m_deadline_missed_status);
                                                        break;

                                                    case 0x00000008:
                                                        ret_value = (x.m_sample_lost_status == m_sample_lost_status);
                                                        break;

                                                    case 0x00000009:
                                                        ret_value = (x.m_statuses_size == m_statuses_size);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x MonitorServiceData object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MonitorServiceData& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            StatusKind::StatusKind __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case StatusKind::PROXY:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case StatusKind::CONNECTION_LIST:
                            if (0x00000002 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case StatusKind::INCOMPATIBLE_QOS:
                            if (0x00000003 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case StatusKind::INCONSISTENT_TOPIC:
                            if (0x00000004 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case StatusKind::LIVELINESS_LOST:
                            if (0x00000005 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case StatusKind::LIVELINESS_CHANGED:
                            if (0x00000006 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case StatusKind::DEADLINE_MISSED:
                            if (0x00000007 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case StatusKind::SAMPLE_LOST:
                            if (0x00000008 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case StatusKind::STATUSES_SIZE:
                            if (0x00000009 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport StatusKind::StatusKind _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function copies the value in member entity_proxy
     * @param _entity_proxy New value to be copied in member entity_proxy
     */
    eProsima_user_DllExport void entity_proxy(
            const std::vector<uint8_t>& _entity_proxy)
    {
        entity_proxy_() = _entity_proxy;
        m__d = StatusKind::PROXY;
    }

    /*!
     * @brief This function moves the value in member entity_proxy
     * @param _entity_proxy New value to be moved in member entity_proxy
     */
    eProsima_user_DllExport void entity_proxy(
            std::vector<uint8_t>&& _entity_proxy)
    {
        entity_proxy_() = _entity_proxy;
        m__d = StatusKind::PROXY;
    }

    /*!
     * @brief This function returns a constant reference to member entity_proxy
     * @return Constant reference to member entity_proxy
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const std::vector<uint8_t>& entity_proxy() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_entity_proxy;
    }

    /*!
     * @brief This function returns a reference to member entity_proxy
     * @return Reference to member entity_proxy
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport std::vector<uint8_t>& entity_proxy()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_entity_proxy;
    }


    /*!
     * @brief This function copies the value in member connection_list
     * @param _connection_list New value to be copied in member connection_list
     */
    eProsima_user_DllExport void connection_list(
            const std::vector<Connection>& _connection_list)
    {
        connection_list_() = _connection_list;
        m__d = StatusKind::CONNECTION_LIST;
    }

    /*!
     * @brief This function moves the value in member connection_list
     * @param _connection_list New value to be moved in member connection_list
     */
    eProsima_user_DllExport void connection_list(
            std::vector<Connection>&& _connection_list)
    {
        connection_list_() = _connection_list;
        m__d = StatusKind::CONNECTION_LIST;
    }

    /*!
     * @brief This function returns a constant reference to member connection_list
     * @return Constant reference to member connection_list
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const std::vector<Connection>& connection_list() const
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_connection_list;
    }

    /*!
     * @brief This function returns a reference to member connection_list
     * @return Reference to member connection_list
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport std::vector<Connection>& connection_list()
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_connection_list;
    }


    /*!
     * @brief This function copies the value in member incompatible_qos_status
     * @param _incompatible_qos_status New value to be copied in member incompatible_qos_status
     */
    eProsima_user_DllExport void incompatible_qos_status(
            const IncompatibleQoSStatus_s& _incompatible_qos_status)
    {
        incompatible_qos_status_() = _incompatible_qos_status;
        m__d = StatusKind::INCOMPATIBLE_QOS;
    }

    /*!
     * @brief This function moves the value in member incompatible_qos_status
     * @param _incompatible_qos_status New value to be moved in member incompatible_qos_status
     */
    eProsima_user_DllExport void incompatible_qos_status(
            IncompatibleQoSStatus_s&& _incompatible_qos_status)
    {
        incompatible_qos_status_() = _incompatible_qos_status;
        m__d = StatusKind::INCOMPATIBLE_QOS;
    }

    /*!
     * @brief This function returns a constant reference to member incompatible_qos_status
     * @return Constant reference to member incompatible_qos_status
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const IncompatibleQoSStatus_s& incompatible_qos_status() const
    {
        if (0x00000003 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_incompatible_qos_status;
    }

    /*!
     * @brief This function returns a reference to member incompatible_qos_status
     * @return Reference to member incompatible_qos_status
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport IncompatibleQoSStatus_s& incompatible_qos_status()
    {
        if (0x00000003 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_incompatible_qos_status;
    }


    /*!
     * @brief This function copies the value in member inconsistent_topic_status
     * @param _inconsistent_topic_status New value to be copied in member inconsistent_topic_status
     */
    eProsima_user_DllExport void inconsistent_topic_status(
            const InconsistentTopicStatus_s& _inconsistent_topic_status)
    {
        inconsistent_topic_status_() = _inconsistent_topic_status;
        m__d = StatusKind::INCONSISTENT_TOPIC;
    }

    /*!
     * @brief This function moves the value in member inconsistent_topic_status
     * @param _inconsistent_topic_status New value to be moved in member inconsistent_topic_status
     */
    eProsima_user_DllExport void inconsistent_topic_status(
            InconsistentTopicStatus_s&& _inconsistent_topic_status)
    {
        inconsistent_topic_status_() = _inconsistent_topic_status;
        m__d = StatusKind::INCONSISTENT_TOPIC;
    }

    /*!
     * @brief This function returns a constant reference to member inconsistent_topic_status
     * @return Constant reference to member inconsistent_topic_status
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const InconsistentTopicStatus_s& inconsistent_topic_status() const
    {
        if (0x00000004 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_inconsistent_topic_status;
    }

    /*!
     * @brief This function returns a reference to member inconsistent_topic_status
     * @return Reference to member inconsistent_topic_status
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport InconsistentTopicStatus_s& inconsistent_topic_status()
    {
        if (0x00000004 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_inconsistent_topic_status;
    }


    /*!
     * @brief This function copies the value in member liveliness_lost_status
     * @param _liveliness_lost_status New value to be copied in member liveliness_lost_status
     */
    eProsima_user_DllExport void liveliness_lost_status(
            const LivelinessLostStatus_s& _liveliness_lost_status)
    {
        liveliness_lost_status_() = _liveliness_lost_status;
        m__d = StatusKind::LIVELINESS_LOST;
    }

    /*!
     * @brief This function moves the value in member liveliness_lost_status
     * @param _liveliness_lost_status New value to be moved in member liveliness_lost_status
     */
    eProsima_user_DllExport void liveliness_lost_status(
            LivelinessLostStatus_s&& _liveliness_lost_status)
    {
        liveliness_lost_status_() = _liveliness_lost_status;
        m__d = StatusKind::LIVELINESS_LOST;
    }

    /*!
     * @brief This function returns a constant reference to member liveliness_lost_status
     * @return Constant reference to member liveliness_lost_status
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const LivelinessLostStatus_s& liveliness_lost_status() const
    {
        if (0x00000005 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_liveliness_lost_status;
    }

    /*!
     * @brief This function returns a reference to member liveliness_lost_status
     * @return Reference to member liveliness_lost_status
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport LivelinessLostStatus_s& liveliness_lost_status()
    {
        if (0x00000005 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_liveliness_lost_status;
    }


    /*!
     * @brief This function copies the value in member liveliness_changed_status
     * @param _liveliness_changed_status New value to be copied in member liveliness_changed_status
     */
    eProsima_user_DllExport void liveliness_changed_status(
            const LivelinessChangedStatus_s& _liveliness_changed_status)
    {
        liveliness_changed_status_() = _liveliness_changed_status;
        m__d = StatusKind::LIVELINESS_CHANGED;
    }

    /*!
     * @brief This function moves the value in member liveliness_changed_status
     * @param _liveliness_changed_status New value to be moved in member liveliness_changed_status
     */
    eProsima_user_DllExport void liveliness_changed_status(
            LivelinessChangedStatus_s&& _liveliness_changed_status)
    {
        liveliness_changed_status_() = _liveliness_changed_status;
        m__d = StatusKind::LIVELINESS_CHANGED;
    }

    /*!
     * @brief This function returns a constant reference to member liveliness_changed_status
     * @return Constant reference to member liveliness_changed_status
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const LivelinessChangedStatus_s& liveliness_changed_status() const
    {
        if (0x00000006 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_liveliness_changed_status;
    }

    /*!
     * @brief This function returns a reference to member liveliness_changed_status
     * @return Reference to member liveliness_changed_status
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport LivelinessChangedStatus_s& liveliness_changed_status()
    {
        if (0x00000006 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_liveliness_changed_status;
    }


    /*!
     * @brief This function copies the value in member deadline_missed_status
     * @param _deadline_missed_status New value to be copied in member deadline_missed_status
     */
    eProsima_user_DllExport void deadline_missed_status(
            const DeadlineMissedStatus_s& _deadline_missed_status)
    {
        deadline_missed_status_() = _deadline_missed_status;
        m__d = StatusKind::DEADLINE_MISSED;
    }

    /*!
     * @brief This function moves the value in member deadline_missed_status
     * @param _deadline_missed_status New value to be moved in member deadline_missed_status
     */
    eProsima_user_DllExport void deadline_missed_status(
            DeadlineMissedStatus_s&& _deadline_missed_status)
    {
        deadline_missed_status_() = _deadline_missed_status;
        m__d = StatusKind::DEADLINE_MISSED;
    }

    /*!
     * @brief This function returns a constant reference to member deadline_missed_status
     * @return Constant reference to member deadline_missed_status
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const DeadlineMissedStatus_s& deadline_missed_status() const
    {
        if (0x00000007 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_deadline_missed_status;
    }

    /*!
     * @brief This function returns a reference to member deadline_missed_status
     * @return Reference to member deadline_missed_status
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport DeadlineMissedStatus_s& deadline_missed_status()
    {
        if (0x00000007 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_deadline_missed_status;
    }


    /*!
     * @brief This function copies the value in member sample_lost_status
     * @param _sample_lost_status New value to be copied in member sample_lost_status
     */
    eProsima_user_DllExport void sample_lost_status(
            const SampleLostStatus_s& _sample_lost_status)
    {
        sample_lost_status_() = _sample_lost_status;
        m__d = StatusKind::SAMPLE_LOST;
    }

    /*!
     * @brief This function moves the value in member sample_lost_status
     * @param _sample_lost_status New value to be moved in member sample_lost_status
     */
    eProsima_user_DllExport void sample_lost_status(
            SampleLostStatus_s&& _sample_lost_status)
    {
        sample_lost_status_() = _sample_lost_status;
        m__d = StatusKind::SAMPLE_LOST;
    }

    /*!
     * @brief This function returns a constant reference to member sample_lost_status
     * @return Constant reference to member sample_lost_status
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const SampleLostStatus_s& sample_lost_status() const
    {
        if (0x00000008 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_sample_lost_status;
    }

    /*!
     * @brief This function returns a reference to member sample_lost_status
     * @return Reference to member sample_lost_status
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport SampleLostStatus_s& sample_lost_status()
    {
        if (0x00000008 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_sample_lost_status;
    }


    /*!
     * @brief This function sets a value in member statuses_size
     * @param _statuses_size New value for member statuses_size
     */
    eProsima_user_DllExport void statuses_size(
            uint8_t _statuses_size)
    {
        statuses_size_() = _statuses_size;
        m__d = StatusKind::STATUSES_SIZE;
    }

    /*!
     * @brief This function returns the value of member statuses_size
     * @return Value of member statuses_size
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport uint8_t statuses_size() const
    {
        if (0x00000009 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_statuses_size;
    }

    /*!
     * @brief This function returns a reference to member statuses_size
     * @return Reference to member statuses_size
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport uint8_t& statuses_size()
    {
        if (0x00000009 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_statuses_size;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            std::vector<uint8_t>& entity_proxy_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = [&]() {m_entity_proxy.~vector();};
                    new(&m_entity_proxy) std::vector<uint8_t>();

                }

                return m_entity_proxy;
            }

            std::vector<Connection>& connection_list_()
            {
                if (0x00000002 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000002;
                    member_destructor_ = [&]() {m_connection_list.~vector();};
                    new(&m_connection_list) std::vector<Connection>();

                }

                return m_connection_list;
            }

            IncompatibleQoSStatus_s& incompatible_qos_status_()
            {
                if (0x00000003 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000003;
                    member_destructor_ = [&]() {m_incompatible_qos_status.~IncompatibleQoSStatus_s();};
                    new(&m_incompatible_qos_status) IncompatibleQoSStatus_s();

                }

                return m_incompatible_qos_status;
            }

            InconsistentTopicStatus_s& inconsistent_topic_status_()
            {
                if (0x00000004 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000004;
                    member_destructor_ = [&]() {m_inconsistent_topic_status.~InconsistentTopicStatus_s();};
                    new(&m_inconsistent_topic_status) InconsistentTopicStatus_s();

                }

                return m_inconsistent_topic_status;
            }

            LivelinessLostStatus_s& liveliness_lost_status_()
            {
                if (0x00000005 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000005;
                    member_destructor_ = [&]() {m_liveliness_lost_status.~LivelinessLostStatus_s();};
                    new(&m_liveliness_lost_status) LivelinessLostStatus_s();

                }

                return m_liveliness_lost_status;
            }

            LivelinessChangedStatus_s& liveliness_changed_status_()
            {
                if (0x00000006 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000006;
                    member_destructor_ = [&]() {m_liveliness_changed_status.~LivelinessChangedStatus_s();};
                    new(&m_liveliness_changed_status) LivelinessChangedStatus_s();

                }

                return m_liveliness_changed_status;
            }

            DeadlineMissedStatus_s& deadline_missed_status_()
            {
                if (0x00000007 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000007;
                    member_destructor_ = [&]() {m_deadline_missed_status.~DeadlineMissedStatus_s();};
                    new(&m_deadline_missed_status) DeadlineMissedStatus_s();

                }

                return m_deadline_missed_status;
            }

            SampleLostStatus_s& sample_lost_status_()
            {
                if (0x00000008 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000008;
                    member_destructor_ = [&]() {m_sample_lost_status.~SampleLostStatus_s();};
                    new(&m_sample_lost_status) SampleLostStatus_s();

                }

                return m_sample_lost_status;
            }

            uint8_t& statuses_size_()
            {
                if (0x00000009 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000009;
                    member_destructor_ = nullptr;
                    m_statuses_size = {0};

                }

                return m_statuses_size;
            }


    StatusKind::StatusKind m__d {2147483647};

    union
    {
        std::vector<uint8_t> m_entity_proxy;
        std::vector<Connection> m_connection_list;
        IncompatibleQoSStatus_s m_incompatible_qos_status;
        InconsistentTopicStatus_s m_inconsistent_topic_status;
        LivelinessLostStatus_s m_liveliness_lost_status;
        LivelinessChangedStatus_s m_liveliness_changed_status;
        DeadlineMissedStatus_s m_deadline_missed_status;
        SampleLostStatus_s m_sample_lost_status;
        uint8_t m_statuses_size;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the structure MonitorServiceStatusData defined by the user in the IDL file.
 * @ingroup monitorservice_types
 */
class MonitorServiceStatusData
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MonitorServiceStatusData()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MonitorServiceStatusData()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MonitorServiceStatusData that will be copied.
     */
    eProsima_user_DllExport MonitorServiceStatusData(
            const MonitorServiceStatusData& x)
    {
                    m_local_entity = x.m_local_entity;

                    m_status_kind = x.m_status_kind;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MonitorServiceStatusData that will be copied.
     */
    eProsima_user_DllExport MonitorServiceStatusData(
            MonitorServiceStatusData&& x) noexcept
    {
        m_local_entity = std::move(x.m_local_entity);
        m_status_kind = x.m_status_kind;
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MonitorServiceStatusData that will be copied.
     */
    eProsima_user_DllExport MonitorServiceStatusData& operator =(
            const MonitorServiceStatusData& x)
    {

                    m_local_entity = x.m_local_entity;

                    m_status_kind = x.m_status_kind;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MonitorServiceStatusData that will be copied.
     */
    eProsima_user_DllExport MonitorServiceStatusData& operator =(
            MonitorServiceStatusData&& x) noexcept
    {

        m_local_entity = std::move(x.m_local_entity);
        m_status_kind = x.m_status_kind;
        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MonitorServiceStatusData object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MonitorServiceStatusData& x) const
    {
        return (m_local_entity == x.m_local_entity &&
           m_status_kind == x.m_status_kind &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x MonitorServiceStatusData object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MonitorServiceStatusData& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member local_entity
     * @param _local_entity New value to be copied in member local_entity
     */
    eProsima_user_DllExport void local_entity(
            const detail::GUID_s& _local_entity)
    {
        m_local_entity = _local_entity;
    }

    /*!
     * @brief This function moves the value in member local_entity
     * @param _local_entity New value to be moved in member local_entity
     */
    eProsima_user_DllExport void local_entity(
            detail::GUID_s&& _local_entity)
    {
        m_local_entity = std::move(_local_entity);
    }

    /*!
     * @brief This function returns a constant reference to member local_entity
     * @return Constant reference to member local_entity
     */
    eProsima_user_DllExport const detail::GUID_s& local_entity() const
    {
        return m_local_entity;
    }

    /*!
     * @brief This function returns a reference to member local_entity
     * @return Reference to member local_entity
     */
    eProsima_user_DllExport detail::GUID_s& local_entity()
    {
        return m_local_entity;
    }


    /*!
     * @brief This function sets a value in member status_kind
     * @param _status_kind New value for member status_kind
     */
    eProsima_user_DllExport void status_kind(
            StatusKind::StatusKind _status_kind)
    {
        m_status_kind = _status_kind;
    }

    /*!
     * @brief This function returns the value of member status_kind
     * @return Value of member status_kind
     */
    eProsima_user_DllExport StatusKind::StatusKind status_kind() const
    {
        return m_status_kind;
    }

    /*!
     * @brief This function returns a reference to member status_kind
     * @return Reference to member status_kind
     */
    eProsima_user_DllExport StatusKind::StatusKind& status_kind()
    {
        return m_status_kind;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const MonitorServiceData& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            MonitorServiceData&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const MonitorServiceData& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport MonitorServiceData& value()
    {
        return m_value;
    }



private:

    detail::GUID_s m_local_entity;
    StatusKind::StatusKind m_status_kind{0};
    MonitorServiceData m_value;

};

} // namespace statistics

} // namespace fastdds

} // namespace eprosima

#endif // _FAST_DDS_GENERATED_EPROSIMA_FASTDDS_STATISTICS_MONITORSERVICE_TYPES_HPP_


