// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file monitorservice_typesTypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen.
 */

#include "monitorservice_typesTypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>

#include "monitorservice_types.hpp"

#include "types.hpp"

using namespace eprosima::fastdds::dds::xtypes;

namespace eprosima {
namespace fastdds {
namespace statistics {
void register_ConnectionMode_type_identifier(
        TypeIdentifierPair& type_ids_ConnectionMode)
{
    ReturnCode_t return_code_ConnectionMode {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ConnectionMode =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::statistics::ConnectionMode", type_ids_ConnectionMode);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ConnectionMode)
    {
        EnumTypeFlag enum_flags_ConnectionMode = 0;
        BitBound bit_bound_ConnectionMode = 32;
        CommonEnumeratedHeader common_ConnectionMode = TypeObjectUtils::build_common_enumerated_header(bit_bound_ConnectionMode);
        QualifiedTypeName type_name_ConnectionMode = "eprosima::fastdds::statistics::ConnectionMode";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ConnectionMode;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ConnectionMode;
        CompleteTypeDetail detail_ConnectionMode = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ConnectionMode, ann_custom_ConnectionMode, type_name_ConnectionMode.to_string());
        CompleteEnumeratedHeader header_ConnectionMode = TypeObjectUtils::build_complete_enumerated_header(common_ConnectionMode, detail_ConnectionMode);
        CompleteEnumeratedLiteralSeq literal_seq_ConnectionMode;
        {
            EnumeratedLiteralFlag flags_DATA_SHARING = TypeObjectUtils::build_enumerated_literal_flag(false);
            CommonEnumeratedLiteral common_DATA_SHARING = TypeObjectUtils::build_common_enumerated_literal(0, flags_DATA_SHARING);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_DATA_SHARING;
            ann_custom_ConnectionMode.reset();
            MemberName name_DATA_SHARING = "DATA_SHARING";
            CompleteMemberDetail detail_DATA_SHARING = TypeObjectUtils::build_complete_member_detail(name_DATA_SHARING, member_ann_builtin_DATA_SHARING, ann_custom_ConnectionMode);
            CompleteEnumeratedLiteral literal_DATA_SHARING = TypeObjectUtils::build_complete_enumerated_literal(common_DATA_SHARING, detail_DATA_SHARING);
            TypeObjectUtils::add_complete_enumerated_literal(literal_seq_ConnectionMode, literal_DATA_SHARING);
        }
        {
            EnumeratedLiteralFlag flags_INTRAPROCESS = TypeObjectUtils::build_enumerated_literal_flag(false);
            CommonEnumeratedLiteral common_INTRAPROCESS = TypeObjectUtils::build_common_enumerated_literal(1, flags_INTRAPROCESS);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_INTRAPROCESS;
            ann_custom_ConnectionMode.reset();
            MemberName name_INTRAPROCESS = "INTRAPROCESS";
            CompleteMemberDetail detail_INTRAPROCESS = TypeObjectUtils::build_complete_member_detail(name_INTRAPROCESS, member_ann_builtin_INTRAPROCESS, ann_custom_ConnectionMode);
            CompleteEnumeratedLiteral literal_INTRAPROCESS = TypeObjectUtils::build_complete_enumerated_literal(common_INTRAPROCESS, detail_INTRAPROCESS);
            TypeObjectUtils::add_complete_enumerated_literal(literal_seq_ConnectionMode, literal_INTRAPROCESS);
        }
        {
            EnumeratedLiteralFlag flags_TRANSPORT = TypeObjectUtils::build_enumerated_literal_flag(false);
            CommonEnumeratedLiteral common_TRANSPORT = TypeObjectUtils::build_common_enumerated_literal(2, flags_TRANSPORT);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_TRANSPORT;
            ann_custom_ConnectionMode.reset();
            MemberName name_TRANSPORT = "TRANSPORT";
            CompleteMemberDetail detail_TRANSPORT = TypeObjectUtils::build_complete_member_detail(name_TRANSPORT, member_ann_builtin_TRANSPORT, ann_custom_ConnectionMode);
            CompleteEnumeratedLiteral literal_TRANSPORT = TypeObjectUtils::build_complete_enumerated_literal(common_TRANSPORT, detail_TRANSPORT);
            TypeObjectUtils::add_complete_enumerated_literal(literal_seq_ConnectionMode, literal_TRANSPORT);
        }
        CompleteEnumeratedType enumerated_type_ConnectionMode = TypeObjectUtils::build_complete_enumerated_type(enum_flags_ConnectionMode, header_ConnectionMode,
                literal_seq_ConnectionMode);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_enumerated_type_object(enumerated_type_ConnectionMode, type_name_ConnectionMode.to_string(), type_ids_ConnectionMode))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "eprosima::fastdds::statistics::ConnectionMode already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Connection_type_identifier(
        TypeIdentifierPair& type_ids_Connection)
{

    ReturnCode_t return_code_Connection {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Connection =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::statistics::Connection", type_ids_Connection);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Connection)
    {
        StructTypeFlag struct_flags_Connection = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Connection = "eprosima::fastdds::statistics::Connection";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Connection;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Connection;
        CompleteTypeDetail detail_Connection = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Connection, ann_custom_Connection, type_name_Connection.to_string());
        CompleteStructHeader header_Connection;
        header_Connection = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Connection);
        CompleteStructMemberSeq member_seq_Connection;
        {
            TypeIdentifierPair type_ids_mode;
            ReturnCode_t return_code_mode {eprosima::fastdds::dds::RETCODE_OK};
            return_code_mode =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::ConnectionMode", type_ids_mode);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_mode)
            {
                eprosima::fastdds::statistics::register_ConnectionMode_type_identifier(type_ids_mode);
            }
            StructMemberFlag member_flags_mode = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_mode = 0x00000000;
            bool common_mode_ec {false};
            CommonStructMember common_mode {TypeObjectUtils::build_common_struct_member(member_id_mode, member_flags_mode, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_mode, common_mode_ec))};
            if (!common_mode_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure mode member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_mode = "mode";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_mode;
            ann_custom_Connection.reset();
            CompleteMemberDetail detail_mode = TypeObjectUtils::build_complete_member_detail(name_mode, member_ann_builtin_mode, ann_custom_Connection);
            CompleteStructMember member_mode = TypeObjectUtils::build_complete_struct_member(common_mode, detail_mode);
            TypeObjectUtils::add_complete_struct_member(member_seq_Connection, member_mode);
        }
        {
            TypeIdentifierPair type_ids_guid;
            ReturnCode_t return_code_guid {eprosima::fastdds::dds::RETCODE_OK};
            return_code_guid =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::detail::GUID_s", type_ids_guid);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_guid)
            {
                eprosima::fastdds::statistics::detail::register_GUID_s_type_identifier(type_ids_guid);
            }
            StructMemberFlag member_flags_guid = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_guid = 0x00000001;
            bool common_guid_ec {false};
            CommonStructMember common_guid {TypeObjectUtils::build_common_struct_member(member_id_guid, member_flags_guid, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_guid, common_guid_ec))};
            if (!common_guid_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure guid member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_guid = "guid";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_guid;
            ann_custom_Connection.reset();
            CompleteMemberDetail detail_guid = TypeObjectUtils::build_complete_member_detail(name_guid, member_ann_builtin_guid, ann_custom_Connection);
            CompleteStructMember member_guid = TypeObjectUtils::build_complete_struct_member(common_guid, detail_guid);
            TypeObjectUtils::add_complete_struct_member(member_seq_Connection, member_guid);
        }
        {
            TypeIdentifierPair type_ids_announced_locators;
            ReturnCode_t return_code_announced_locators {eprosima::fastdds::dds::RETCODE_OK};
            return_code_announced_locators =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_eprosima_fastdds_statistics_detail_Locator_s_unbounded", type_ids_announced_locators);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_announced_locators)
            {
                return_code_announced_locators =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "eprosima::fastdds::statistics::detail::Locator_s", type_ids_announced_locators);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_announced_locators)
                {
                    eprosima::fastdds::statistics::detail::register_Locator_s_type_identifier(type_ids_announced_locators);
                }
                bool element_identifier_anonymous_sequence_eprosima_fastdds_statistics_detail_Locator_s_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_eprosima_fastdds_statistics_detail_Locator_s_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_announced_locators, element_identifier_anonymous_sequence_eprosima_fastdds_statistics_detail_Locator_s_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_eprosima_fastdds_statistics_detail_Locator_s_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_eprosima_fastdds_statistics_detail_Locator_s_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_announced_locators.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_eprosima_fastdds_statistics_detail_Locator_s_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_eprosima_fastdds_statistics_detail_Locator_s_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_eprosima_fastdds_statistics_detail_Locator_s_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_eprosima_fastdds_statistics_detail_Locator_s_unbounded, element_flags_anonymous_sequence_eprosima_fastdds_statistics_detail_Locator_s_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_eprosima_fastdds_statistics_detail_Locator_s_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_eprosima_fastdds_statistics_detail_Locator_s_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_eprosima_fastdds_statistics_detail_Locator_s_unbounded", type_ids_announced_locators))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_eprosima_fastdds_statistics_detail_Locator_s_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_announced_locators = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_announced_locators = 0x00000002;
            bool common_announced_locators_ec {false};
            CommonStructMember common_announced_locators {TypeObjectUtils::build_common_struct_member(member_id_announced_locators, member_flags_announced_locators, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_announced_locators, common_announced_locators_ec))};
            if (!common_announced_locators_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure announced_locators member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_announced_locators = "announced_locators";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_announced_locators;
            ann_custom_Connection.reset();
            CompleteMemberDetail detail_announced_locators = TypeObjectUtils::build_complete_member_detail(name_announced_locators, member_ann_builtin_announced_locators, ann_custom_Connection);
            CompleteStructMember member_announced_locators = TypeObjectUtils::build_complete_struct_member(common_announced_locators, detail_announced_locators);
            TypeObjectUtils::add_complete_struct_member(member_seq_Connection, member_announced_locators);
        }
        {
            TypeIdentifierPair type_ids_used_locators;
            ReturnCode_t return_code_used_locators {eprosima::fastdds::dds::RETCODE_OK};
            return_code_used_locators =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_eprosima_fastdds_statistics_detail_Locator_s_unbounded", type_ids_used_locators);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_used_locators)
            {
                return_code_used_locators =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "eprosima::fastdds::statistics::detail::Locator_s", type_ids_used_locators);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_used_locators)
                {
                    eprosima::fastdds::statistics::detail::register_Locator_s_type_identifier(type_ids_used_locators);
                }
                bool element_identifier_anonymous_sequence_eprosima_fastdds_statistics_detail_Locator_s_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_eprosima_fastdds_statistics_detail_Locator_s_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_used_locators, element_identifier_anonymous_sequence_eprosima_fastdds_statistics_detail_Locator_s_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_eprosima_fastdds_statistics_detail_Locator_s_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_eprosima_fastdds_statistics_detail_Locator_s_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_used_locators.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_eprosima_fastdds_statistics_detail_Locator_s_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_eprosima_fastdds_statistics_detail_Locator_s_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_eprosima_fastdds_statistics_detail_Locator_s_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_eprosima_fastdds_statistics_detail_Locator_s_unbounded, element_flags_anonymous_sequence_eprosima_fastdds_statistics_detail_Locator_s_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_eprosima_fastdds_statistics_detail_Locator_s_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_eprosima_fastdds_statistics_detail_Locator_s_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_eprosima_fastdds_statistics_detail_Locator_s_unbounded", type_ids_used_locators))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_eprosima_fastdds_statistics_detail_Locator_s_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_used_locators = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_used_locators = 0x00000003;
            bool common_used_locators_ec {false};
            CommonStructMember common_used_locators {TypeObjectUtils::build_common_struct_member(member_id_used_locators, member_flags_used_locators, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_used_locators, common_used_locators_ec))};
            if (!common_used_locators_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure used_locators member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_used_locators = "used_locators";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_used_locators;
            ann_custom_Connection.reset();
            CompleteMemberDetail detail_used_locators = TypeObjectUtils::build_complete_member_detail(name_used_locators, member_ann_builtin_used_locators, ann_custom_Connection);
            CompleteStructMember member_used_locators = TypeObjectUtils::build_complete_struct_member(common_used_locators, detail_used_locators);
            TypeObjectUtils::add_complete_struct_member(member_seq_Connection, member_used_locators);
        }
        CompleteStructType struct_type_Connection = TypeObjectUtils::build_complete_struct_type(struct_flags_Connection, header_Connection, member_seq_Connection);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Connection, type_name_Connection.to_string(), type_ids_Connection))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::statistics::Connection already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_QosPolicyCount_s_type_identifier(
        TypeIdentifierPair& type_ids_QosPolicyCount_s)
{

    ReturnCode_t return_code_QosPolicyCount_s {eprosima::fastdds::dds::RETCODE_OK};
    return_code_QosPolicyCount_s =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::statistics::QosPolicyCount_s", type_ids_QosPolicyCount_s);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_QosPolicyCount_s)
    {
        StructTypeFlag struct_flags_QosPolicyCount_s = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_QosPolicyCount_s = "eprosima::fastdds::statistics::QosPolicyCount_s";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_QosPolicyCount_s;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_QosPolicyCount_s;
        CompleteTypeDetail detail_QosPolicyCount_s = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_QosPolicyCount_s, ann_custom_QosPolicyCount_s, type_name_QosPolicyCount_s.to_string());
        CompleteStructHeader header_QosPolicyCount_s;
        header_QosPolicyCount_s = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_QosPolicyCount_s);
        CompleteStructMemberSeq member_seq_QosPolicyCount_s;
        {
            TypeIdentifierPair type_ids_policy_id;
            ReturnCode_t return_code_policy_id {eprosima::fastdds::dds::RETCODE_OK};
            return_code_policy_id =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_policy_id);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_policy_id)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "policy_id Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_policy_id = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_policy_id = 0x00000000;
            bool common_policy_id_ec {false};
            CommonStructMember common_policy_id {TypeObjectUtils::build_common_struct_member(member_id_policy_id, member_flags_policy_id, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_policy_id, common_policy_id_ec))};
            if (!common_policy_id_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure policy_id member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_policy_id = "policy_id";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_policy_id;
            ann_custom_QosPolicyCount_s.reset();
            CompleteMemberDetail detail_policy_id = TypeObjectUtils::build_complete_member_detail(name_policy_id, member_ann_builtin_policy_id, ann_custom_QosPolicyCount_s);
            CompleteStructMember member_policy_id = TypeObjectUtils::build_complete_struct_member(common_policy_id, detail_policy_id);
            TypeObjectUtils::add_complete_struct_member(member_seq_QosPolicyCount_s, member_policy_id);
        }
        {
            TypeIdentifierPair type_ids_count;
            ReturnCode_t return_code_count {eprosima::fastdds::dds::RETCODE_OK};
            return_code_count =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_count);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_count)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "count Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_count = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_count = 0x00000001;
            bool common_count_ec {false};
            CommonStructMember common_count {TypeObjectUtils::build_common_struct_member(member_id_count, member_flags_count, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_count, common_count_ec))};
            if (!common_count_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure count member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_count = "count";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_count;
            ann_custom_QosPolicyCount_s.reset();
            CompleteMemberDetail detail_count = TypeObjectUtils::build_complete_member_detail(name_count, member_ann_builtin_count, ann_custom_QosPolicyCount_s);
            CompleteStructMember member_count = TypeObjectUtils::build_complete_struct_member(common_count, detail_count);
            TypeObjectUtils::add_complete_struct_member(member_seq_QosPolicyCount_s, member_count);
        }
        CompleteStructType struct_type_QosPolicyCount_s = TypeObjectUtils::build_complete_struct_type(struct_flags_QosPolicyCount_s, header_QosPolicyCount_s, member_seq_QosPolicyCount_s);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_QosPolicyCount_s, type_name_QosPolicyCount_s.to_string(), type_ids_QosPolicyCount_s))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::statistics::QosPolicyCount_s already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_BaseStatus_s_type_identifier(
        TypeIdentifierPair& type_ids_BaseStatus_s)
{

    ReturnCode_t return_code_BaseStatus_s {eprosima::fastdds::dds::RETCODE_OK};
    return_code_BaseStatus_s =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::statistics::BaseStatus_s", type_ids_BaseStatus_s);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_BaseStatus_s)
    {
        StructTypeFlag struct_flags_BaseStatus_s = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_BaseStatus_s = "eprosima::fastdds::statistics::BaseStatus_s";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_BaseStatus_s;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_BaseStatus_s;
        CompleteTypeDetail detail_BaseStatus_s = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_BaseStatus_s, ann_custom_BaseStatus_s, type_name_BaseStatus_s.to_string());
        CompleteStructHeader header_BaseStatus_s;
        header_BaseStatus_s = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_BaseStatus_s);
        CompleteStructMemberSeq member_seq_BaseStatus_s;
        {
            TypeIdentifierPair type_ids_total_count;
            ReturnCode_t return_code_total_count {eprosima::fastdds::dds::RETCODE_OK};
            return_code_total_count =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_total_count);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_total_count)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "total_count Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_total_count = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_total_count = 0x00000000;
            bool common_total_count_ec {false};
            CommonStructMember common_total_count {TypeObjectUtils::build_common_struct_member(member_id_total_count, member_flags_total_count, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_total_count, common_total_count_ec))};
            if (!common_total_count_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure total_count member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_total_count = "total_count";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_total_count;
            ann_custom_BaseStatus_s.reset();
            CompleteMemberDetail detail_total_count = TypeObjectUtils::build_complete_member_detail(name_total_count, member_ann_builtin_total_count, ann_custom_BaseStatus_s);
            CompleteStructMember member_total_count = TypeObjectUtils::build_complete_struct_member(common_total_count, detail_total_count);
            TypeObjectUtils::add_complete_struct_member(member_seq_BaseStatus_s, member_total_count);
        }
        CompleteStructType struct_type_BaseStatus_s = TypeObjectUtils::build_complete_struct_type(struct_flags_BaseStatus_s, header_BaseStatus_s, member_seq_BaseStatus_s);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_BaseStatus_s, type_name_BaseStatus_s.to_string(), type_ids_BaseStatus_s))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::statistics::BaseStatus_s already registered in TypeObjectRegistry for a different type.");
        }
    }
}
void register_QosPolicyCountSeq_s_type_identifier(
        TypeIdentifierPair& type_ids_QosPolicyCountSeq_s)
{
    ReturnCode_t return_code_QosPolicyCountSeq_s {eprosima::fastdds::dds::RETCODE_OK};
    return_code_QosPolicyCountSeq_s =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::statistics::QosPolicyCountSeq_s", type_ids_QosPolicyCountSeq_s);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_QosPolicyCountSeq_s)
    {
        AliasTypeFlag alias_flags_QosPolicyCountSeq_s = 0;
        QualifiedTypeName type_name_QosPolicyCountSeq_s = "eprosima::fastdds::statistics::QosPolicyCountSeq_s";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_QosPolicyCountSeq_s;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_QosPolicyCountSeq_s;
        CompleteTypeDetail detail_QosPolicyCountSeq_s = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_QosPolicyCountSeq_s, ann_custom_QosPolicyCountSeq_s, type_name_QosPolicyCountSeq_s.to_string());
        CompleteAliasHeader header_QosPolicyCountSeq_s = TypeObjectUtils::build_complete_alias_header(detail_QosPolicyCountSeq_s);
        AliasMemberFlag related_flags_QosPolicyCountSeq_s = 0;
        return_code_QosPolicyCountSeq_s =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "anonymous_sequence_eprosima_fastdds_statistics_QosPolicyCount_s_unbounded", type_ids_QosPolicyCountSeq_s);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_QosPolicyCountSeq_s)
        {
            return_code_QosPolicyCountSeq_s =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::QosPolicyCount_s", type_ids_QosPolicyCountSeq_s);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_QosPolicyCountSeq_s)
            {
                eprosima::fastdds::statistics::register_QosPolicyCount_s_type_identifier(type_ids_QosPolicyCountSeq_s);
            }
            bool element_identifier_anonymous_sequence_eprosima_fastdds_statistics_QosPolicyCount_s_unbounded_ec {false};
            TypeIdentifier* element_identifier_anonymous_sequence_eprosima_fastdds_statistics_QosPolicyCount_s_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_QosPolicyCountSeq_s, element_identifier_anonymous_sequence_eprosima_fastdds_statistics_QosPolicyCount_s_unbounded_ec))};
            if (!element_identifier_anonymous_sequence_eprosima_fastdds_statistics_QosPolicyCount_s_unbounded_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                return;
            }
            EquivalenceKind equiv_kind_anonymous_sequence_eprosima_fastdds_statistics_QosPolicyCount_s_unbounded = EK_COMPLETE;
            if (TK_NONE == type_ids_QosPolicyCountSeq_s.type_identifier2()._d())
            {
                equiv_kind_anonymous_sequence_eprosima_fastdds_statistics_QosPolicyCount_s_unbounded = EK_BOTH;
            }
            CollectionElementFlag element_flags_anonymous_sequence_eprosima_fastdds_statistics_QosPolicyCount_s_unbounded = 0;
            PlainCollectionHeader header_anonymous_sequence_eprosima_fastdds_statistics_QosPolicyCount_s_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_eprosima_fastdds_statistics_QosPolicyCount_s_unbounded, element_flags_anonymous_sequence_eprosima_fastdds_statistics_QosPolicyCount_s_unbounded);
            {
                SBound bound = 0;
                PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_eprosima_fastdds_statistics_QosPolicyCount_s_unbounded, bound,
                            eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_eprosima_fastdds_statistics_QosPolicyCount_s_unbounded));
                if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                        TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_eprosima_fastdds_statistics_QosPolicyCount_s_unbounded", type_ids_QosPolicyCountSeq_s))
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_sequence_eprosima_fastdds_statistics_QosPolicyCount_s_unbounded already registered in TypeObjectRegistry for a different type.");
                }
            }
        }
        bool common_QosPolicyCountSeq_s_ec {false};
        CommonAliasBody common_QosPolicyCountSeq_s {TypeObjectUtils::build_common_alias_body(related_flags_QosPolicyCountSeq_s,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_QosPolicyCountSeq_s, common_QosPolicyCountSeq_s_ec))};
        if (!common_QosPolicyCountSeq_s_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "eprosima::fastdds::statistics::QosPolicyCountSeq_s related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_QosPolicyCountSeq_s;
        ann_custom_QosPolicyCountSeq_s.reset();
        CompleteAliasBody body_QosPolicyCountSeq_s = TypeObjectUtils::build_complete_alias_body(common_QosPolicyCountSeq_s,
                member_ann_builtin_QosPolicyCountSeq_s, ann_custom_QosPolicyCountSeq_s);
        CompleteAliasType alias_type_QosPolicyCountSeq_s = TypeObjectUtils::build_complete_alias_type(alias_flags_QosPolicyCountSeq_s,
                header_QosPolicyCountSeq_s, body_QosPolicyCountSeq_s);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_QosPolicyCountSeq_s,
                    type_name_QosPolicyCountSeq_s.to_string(), type_ids_QosPolicyCountSeq_s))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "eprosima::fastdds::statistics::QosPolicyCountSeq_s already registered in TypeObjectRegistry for a different type.");
        }
    }
}

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_IncompatibleQoSStatus_s_type_identifier(
        TypeIdentifierPair& type_ids_IncompatibleQoSStatus_s)
{

    ReturnCode_t return_code_IncompatibleQoSStatus_s {eprosima::fastdds::dds::RETCODE_OK};
    return_code_IncompatibleQoSStatus_s =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::statistics::IncompatibleQoSStatus_s", type_ids_IncompatibleQoSStatus_s);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_IncompatibleQoSStatus_s)
    {
        StructTypeFlag struct_flags_IncompatibleQoSStatus_s = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_IncompatibleQoSStatus_s = "eprosima::fastdds::statistics::IncompatibleQoSStatus_s";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_IncompatibleQoSStatus_s;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_IncompatibleQoSStatus_s;
        CompleteTypeDetail detail_IncompatibleQoSStatus_s = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_IncompatibleQoSStatus_s, ann_custom_IncompatibleQoSStatus_s, type_name_IncompatibleQoSStatus_s.to_string());
        CompleteStructHeader header_IncompatibleQoSStatus_s;
        header_IncompatibleQoSStatus_s = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_IncompatibleQoSStatus_s);
        CompleteStructMemberSeq member_seq_IncompatibleQoSStatus_s;
        {
            TypeIdentifierPair type_ids_total_count;
            ReturnCode_t return_code_total_count {eprosima::fastdds::dds::RETCODE_OK};
            return_code_total_count =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_total_count);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_total_count)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "total_count Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_total_count = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_total_count = 0x00000000;
            bool common_total_count_ec {false};
            CommonStructMember common_total_count {TypeObjectUtils::build_common_struct_member(member_id_total_count, member_flags_total_count, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_total_count, common_total_count_ec))};
            if (!common_total_count_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure total_count member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_total_count = "total_count";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_total_count;
            ann_custom_IncompatibleQoSStatus_s.reset();
            CompleteMemberDetail detail_total_count = TypeObjectUtils::build_complete_member_detail(name_total_count, member_ann_builtin_total_count, ann_custom_IncompatibleQoSStatus_s);
            CompleteStructMember member_total_count = TypeObjectUtils::build_complete_struct_member(common_total_count, detail_total_count);
            TypeObjectUtils::add_complete_struct_member(member_seq_IncompatibleQoSStatus_s, member_total_count);
        }
        {
            TypeIdentifierPair type_ids_last_policy_id;
            ReturnCode_t return_code_last_policy_id {eprosima::fastdds::dds::RETCODE_OK};
            return_code_last_policy_id =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_last_policy_id);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_last_policy_id)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "last_policy_id Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_last_policy_id = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_last_policy_id = 0x00000001;
            bool common_last_policy_id_ec {false};
            CommonStructMember common_last_policy_id {TypeObjectUtils::build_common_struct_member(member_id_last_policy_id, member_flags_last_policy_id, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_last_policy_id, common_last_policy_id_ec))};
            if (!common_last_policy_id_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure last_policy_id member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_last_policy_id = "last_policy_id";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_last_policy_id;
            ann_custom_IncompatibleQoSStatus_s.reset();
            CompleteMemberDetail detail_last_policy_id = TypeObjectUtils::build_complete_member_detail(name_last_policy_id, member_ann_builtin_last_policy_id, ann_custom_IncompatibleQoSStatus_s);
            CompleteStructMember member_last_policy_id = TypeObjectUtils::build_complete_struct_member(common_last_policy_id, detail_last_policy_id);
            TypeObjectUtils::add_complete_struct_member(member_seq_IncompatibleQoSStatus_s, member_last_policy_id);
        }
        {
            TypeIdentifierPair type_ids_policies;
            ReturnCode_t return_code_policies {eprosima::fastdds::dds::RETCODE_OK};
            return_code_policies =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::QosPolicyCountSeq_s", type_ids_policies);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_policies)
            {
                eprosima::fastdds::statistics::register_QosPolicyCountSeq_s_type_identifier(type_ids_policies);
            }
            StructMemberFlag member_flags_policies = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_policies = 0x00000002;
            bool common_policies_ec {false};
            CommonStructMember common_policies {TypeObjectUtils::build_common_struct_member(member_id_policies, member_flags_policies, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_policies, common_policies_ec))};
            if (!common_policies_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure policies member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_policies = "policies";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_policies;
            ann_custom_IncompatibleQoSStatus_s.reset();
            CompleteMemberDetail detail_policies = TypeObjectUtils::build_complete_member_detail(name_policies, member_ann_builtin_policies, ann_custom_IncompatibleQoSStatus_s);
            CompleteStructMember member_policies = TypeObjectUtils::build_complete_struct_member(common_policies, detail_policies);
            TypeObjectUtils::add_complete_struct_member(member_seq_IncompatibleQoSStatus_s, member_policies);
        }
        CompleteStructType struct_type_IncompatibleQoSStatus_s = TypeObjectUtils::build_complete_struct_type(struct_flags_IncompatibleQoSStatus_s, header_IncompatibleQoSStatus_s, member_seq_IncompatibleQoSStatus_s);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_IncompatibleQoSStatus_s, type_name_IncompatibleQoSStatus_s.to_string(), type_ids_IncompatibleQoSStatus_s))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::statistics::IncompatibleQoSStatus_s already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_LivelinessChangedStatus_s_type_identifier(
        TypeIdentifierPair& type_ids_LivelinessChangedStatus_s)
{

    ReturnCode_t return_code_LivelinessChangedStatus_s {eprosima::fastdds::dds::RETCODE_OK};
    return_code_LivelinessChangedStatus_s =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::statistics::LivelinessChangedStatus_s", type_ids_LivelinessChangedStatus_s);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_LivelinessChangedStatus_s)
    {
        StructTypeFlag struct_flags_LivelinessChangedStatus_s = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_LivelinessChangedStatus_s = "eprosima::fastdds::statistics::LivelinessChangedStatus_s";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_LivelinessChangedStatus_s;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_LivelinessChangedStatus_s;
        CompleteTypeDetail detail_LivelinessChangedStatus_s = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_LivelinessChangedStatus_s, ann_custom_LivelinessChangedStatus_s, type_name_LivelinessChangedStatus_s.to_string());
        CompleteStructHeader header_LivelinessChangedStatus_s;
        header_LivelinessChangedStatus_s = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_LivelinessChangedStatus_s);
        CompleteStructMemberSeq member_seq_LivelinessChangedStatus_s;
        {
            TypeIdentifierPair type_ids_alive_count;
            ReturnCode_t return_code_alive_count {eprosima::fastdds::dds::RETCODE_OK};
            return_code_alive_count =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_alive_count);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_alive_count)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "alive_count Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_alive_count = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_alive_count = 0x00000000;
            bool common_alive_count_ec {false};
            CommonStructMember common_alive_count {TypeObjectUtils::build_common_struct_member(member_id_alive_count, member_flags_alive_count, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_alive_count, common_alive_count_ec))};
            if (!common_alive_count_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure alive_count member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_alive_count = "alive_count";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_alive_count;
            ann_custom_LivelinessChangedStatus_s.reset();
            CompleteMemberDetail detail_alive_count = TypeObjectUtils::build_complete_member_detail(name_alive_count, member_ann_builtin_alive_count, ann_custom_LivelinessChangedStatus_s);
            CompleteStructMember member_alive_count = TypeObjectUtils::build_complete_struct_member(common_alive_count, detail_alive_count);
            TypeObjectUtils::add_complete_struct_member(member_seq_LivelinessChangedStatus_s, member_alive_count);
        }
        {
            TypeIdentifierPair type_ids_not_alive_count;
            ReturnCode_t return_code_not_alive_count {eprosima::fastdds::dds::RETCODE_OK};
            return_code_not_alive_count =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_not_alive_count);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_not_alive_count)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "not_alive_count Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_not_alive_count = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_not_alive_count = 0x00000001;
            bool common_not_alive_count_ec {false};
            CommonStructMember common_not_alive_count {TypeObjectUtils::build_common_struct_member(member_id_not_alive_count, member_flags_not_alive_count, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_not_alive_count, common_not_alive_count_ec))};
            if (!common_not_alive_count_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure not_alive_count member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_not_alive_count = "not_alive_count";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_not_alive_count;
            ann_custom_LivelinessChangedStatus_s.reset();
            CompleteMemberDetail detail_not_alive_count = TypeObjectUtils::build_complete_member_detail(name_not_alive_count, member_ann_builtin_not_alive_count, ann_custom_LivelinessChangedStatus_s);
            CompleteStructMember member_not_alive_count = TypeObjectUtils::build_complete_struct_member(common_not_alive_count, detail_not_alive_count);
            TypeObjectUtils::add_complete_struct_member(member_seq_LivelinessChangedStatus_s, member_not_alive_count);
        }
        {
            TypeIdentifierPair type_ids_last_publication_handle;
            ReturnCode_t return_code_last_publication_handle {eprosima::fastdds::dds::RETCODE_OK};
            return_code_last_publication_handle =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_uint8_t_16", type_ids_last_publication_handle);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_last_publication_handle)
            {
                return_code_last_publication_handle =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_byte", type_ids_last_publication_handle);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_last_publication_handle)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_uint8_t_16_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_uint8_t_16 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_last_publication_handle, element_identifier_anonymous_array_uint8_t_16_ec))};
                if (!element_identifier_anonymous_array_uint8_t_16_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_uint8_t_16 = EK_COMPLETE;
                if (TK_NONE == type_ids_last_publication_handle.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_uint8_t_16 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_uint8_t_16 = 0;
                PlainCollectionHeader header_anonymous_array_uint8_t_16 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_uint8_t_16, element_flags_anonymous_array_uint8_t_16);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(16));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_uint8_t_16, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_uint8_t_16));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_uint8_t_16", type_ids_last_publication_handle))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_uint8_t_16 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_last_publication_handle = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_last_publication_handle = 0x00000002;
            bool common_last_publication_handle_ec {false};
            CommonStructMember common_last_publication_handle {TypeObjectUtils::build_common_struct_member(member_id_last_publication_handle, member_flags_last_publication_handle, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_last_publication_handle, common_last_publication_handle_ec))};
            if (!common_last_publication_handle_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure last_publication_handle member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_last_publication_handle = "last_publication_handle";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_last_publication_handle;
            ann_custom_LivelinessChangedStatus_s.reset();
            CompleteMemberDetail detail_last_publication_handle = TypeObjectUtils::build_complete_member_detail(name_last_publication_handle, member_ann_builtin_last_publication_handle, ann_custom_LivelinessChangedStatus_s);
            CompleteStructMember member_last_publication_handle = TypeObjectUtils::build_complete_struct_member(common_last_publication_handle, detail_last_publication_handle);
            TypeObjectUtils::add_complete_struct_member(member_seq_LivelinessChangedStatus_s, member_last_publication_handle);
        }
        CompleteStructType struct_type_LivelinessChangedStatus_s = TypeObjectUtils::build_complete_struct_type(struct_flags_LivelinessChangedStatus_s, header_LivelinessChangedStatus_s, member_seq_LivelinessChangedStatus_s);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_LivelinessChangedStatus_s, type_name_LivelinessChangedStatus_s.to_string(), type_ids_LivelinessChangedStatus_s))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::statistics::LivelinessChangedStatus_s already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_DeadlineMissedStatus_s_type_identifier(
        TypeIdentifierPair& type_ids_DeadlineMissedStatus_s)
{

    ReturnCode_t return_code_DeadlineMissedStatus_s {eprosima::fastdds::dds::RETCODE_OK};
    return_code_DeadlineMissedStatus_s =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::statistics::DeadlineMissedStatus_s", type_ids_DeadlineMissedStatus_s);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_DeadlineMissedStatus_s)
    {
        StructTypeFlag struct_flags_DeadlineMissedStatus_s = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_DeadlineMissedStatus_s = "eprosima::fastdds::statistics::DeadlineMissedStatus_s";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_DeadlineMissedStatus_s;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_DeadlineMissedStatus_s;
        CompleteTypeDetail detail_DeadlineMissedStatus_s = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_DeadlineMissedStatus_s, ann_custom_DeadlineMissedStatus_s, type_name_DeadlineMissedStatus_s.to_string());
        CompleteStructHeader header_DeadlineMissedStatus_s;
        header_DeadlineMissedStatus_s = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_DeadlineMissedStatus_s);
        CompleteStructMemberSeq member_seq_DeadlineMissedStatus_s;
        {
            TypeIdentifierPair type_ids_total_count;
            ReturnCode_t return_code_total_count {eprosima::fastdds::dds::RETCODE_OK};
            return_code_total_count =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_total_count);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_total_count)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "total_count Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_total_count = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_total_count = 0x00000000;
            bool common_total_count_ec {false};
            CommonStructMember common_total_count {TypeObjectUtils::build_common_struct_member(member_id_total_count, member_flags_total_count, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_total_count, common_total_count_ec))};
            if (!common_total_count_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure total_count member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_total_count = "total_count";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_total_count;
            ann_custom_DeadlineMissedStatus_s.reset();
            CompleteMemberDetail detail_total_count = TypeObjectUtils::build_complete_member_detail(name_total_count, member_ann_builtin_total_count, ann_custom_DeadlineMissedStatus_s);
            CompleteStructMember member_total_count = TypeObjectUtils::build_complete_struct_member(common_total_count, detail_total_count);
            TypeObjectUtils::add_complete_struct_member(member_seq_DeadlineMissedStatus_s, member_total_count);
        }
        {
            TypeIdentifierPair type_ids_last_instance_handle;
            ReturnCode_t return_code_last_instance_handle {eprosima::fastdds::dds::RETCODE_OK};
            return_code_last_instance_handle =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_uint8_t_16", type_ids_last_instance_handle);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_last_instance_handle)
            {
                return_code_last_instance_handle =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_byte", type_ids_last_instance_handle);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_last_instance_handle)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_uint8_t_16_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_uint8_t_16 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_last_instance_handle, element_identifier_anonymous_array_uint8_t_16_ec))};
                if (!element_identifier_anonymous_array_uint8_t_16_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_uint8_t_16 = EK_COMPLETE;
                if (TK_NONE == type_ids_last_instance_handle.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_uint8_t_16 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_uint8_t_16 = 0;
                PlainCollectionHeader header_anonymous_array_uint8_t_16 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_uint8_t_16, element_flags_anonymous_array_uint8_t_16);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(16));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_uint8_t_16, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_uint8_t_16));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_uint8_t_16", type_ids_last_instance_handle))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_uint8_t_16 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_last_instance_handle = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_last_instance_handle = 0x00000001;
            bool common_last_instance_handle_ec {false};
            CommonStructMember common_last_instance_handle {TypeObjectUtils::build_common_struct_member(member_id_last_instance_handle, member_flags_last_instance_handle, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_last_instance_handle, common_last_instance_handle_ec))};
            if (!common_last_instance_handle_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure last_instance_handle member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_last_instance_handle = "last_instance_handle";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_last_instance_handle;
            ann_custom_DeadlineMissedStatus_s.reset();
            CompleteMemberDetail detail_last_instance_handle = TypeObjectUtils::build_complete_member_detail(name_last_instance_handle, member_ann_builtin_last_instance_handle, ann_custom_DeadlineMissedStatus_s);
            CompleteStructMember member_last_instance_handle = TypeObjectUtils::build_complete_struct_member(common_last_instance_handle, detail_last_instance_handle);
            TypeObjectUtils::add_complete_struct_member(member_seq_DeadlineMissedStatus_s, member_last_instance_handle);
        }
        CompleteStructType struct_type_DeadlineMissedStatus_s = TypeObjectUtils::build_complete_struct_type(struct_flags_DeadlineMissedStatus_s, header_DeadlineMissedStatus_s, member_seq_DeadlineMissedStatus_s);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_DeadlineMissedStatus_s, type_name_DeadlineMissedStatus_s.to_string(), type_ids_DeadlineMissedStatus_s))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::statistics::DeadlineMissedStatus_s already registered in TypeObjectRegistry for a different type.");
        }
    }
}
void register_LivelinessLostStatus_s_type_identifier(
        TypeIdentifierPair& type_ids_LivelinessLostStatus_s)
{
    ReturnCode_t return_code_LivelinessLostStatus_s {eprosima::fastdds::dds::RETCODE_OK};
    return_code_LivelinessLostStatus_s =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::statistics::LivelinessLostStatus_s", type_ids_LivelinessLostStatus_s);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_LivelinessLostStatus_s)
    {
        AliasTypeFlag alias_flags_LivelinessLostStatus_s = 0;
        QualifiedTypeName type_name_LivelinessLostStatus_s = "eprosima::fastdds::statistics::LivelinessLostStatus_s";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_LivelinessLostStatus_s;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_LivelinessLostStatus_s;
        CompleteTypeDetail detail_LivelinessLostStatus_s = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_LivelinessLostStatus_s, ann_custom_LivelinessLostStatus_s, type_name_LivelinessLostStatus_s.to_string());
        CompleteAliasHeader header_LivelinessLostStatus_s = TypeObjectUtils::build_complete_alias_header(detail_LivelinessLostStatus_s);
        AliasMemberFlag related_flags_LivelinessLostStatus_s = 0;
        return_code_LivelinessLostStatus_s =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "eprosima::fastdds::statistics::BaseStatus_s", type_ids_LivelinessLostStatus_s);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_LivelinessLostStatus_s)
        {
            eprosima::fastdds::statistics::register_BaseStatus_s_type_identifier(type_ids_LivelinessLostStatus_s);
        }
        bool common_LivelinessLostStatus_s_ec {false};
        CommonAliasBody common_LivelinessLostStatus_s {TypeObjectUtils::build_common_alias_body(related_flags_LivelinessLostStatus_s,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_LivelinessLostStatus_s, common_LivelinessLostStatus_s_ec))};
        if (!common_LivelinessLostStatus_s_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "eprosima::fastdds::statistics::LivelinessLostStatus_s related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_LivelinessLostStatus_s;
        ann_custom_LivelinessLostStatus_s.reset();
        CompleteAliasBody body_LivelinessLostStatus_s = TypeObjectUtils::build_complete_alias_body(common_LivelinessLostStatus_s,
                member_ann_builtin_LivelinessLostStatus_s, ann_custom_LivelinessLostStatus_s);
        CompleteAliasType alias_type_LivelinessLostStatus_s = TypeObjectUtils::build_complete_alias_type(alias_flags_LivelinessLostStatus_s,
                header_LivelinessLostStatus_s, body_LivelinessLostStatus_s);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_LivelinessLostStatus_s,
                    type_name_LivelinessLostStatus_s.to_string(), type_ids_LivelinessLostStatus_s))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "eprosima::fastdds::statistics::LivelinessLostStatus_s already registered in TypeObjectRegistry for a different type.");
        }
    }
}

void register_InconsistentTopicStatus_s_type_identifier(
        TypeIdentifierPair& type_ids_InconsistentTopicStatus_s)
{
    ReturnCode_t return_code_InconsistentTopicStatus_s {eprosima::fastdds::dds::RETCODE_OK};
    return_code_InconsistentTopicStatus_s =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::statistics::InconsistentTopicStatus_s", type_ids_InconsistentTopicStatus_s);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_InconsistentTopicStatus_s)
    {
        AliasTypeFlag alias_flags_InconsistentTopicStatus_s = 0;
        QualifiedTypeName type_name_InconsistentTopicStatus_s = "eprosima::fastdds::statistics::InconsistentTopicStatus_s";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_InconsistentTopicStatus_s;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_InconsistentTopicStatus_s;
        CompleteTypeDetail detail_InconsistentTopicStatus_s = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_InconsistentTopicStatus_s, ann_custom_InconsistentTopicStatus_s, type_name_InconsistentTopicStatus_s.to_string());
        CompleteAliasHeader header_InconsistentTopicStatus_s = TypeObjectUtils::build_complete_alias_header(detail_InconsistentTopicStatus_s);
        AliasMemberFlag related_flags_InconsistentTopicStatus_s = 0;
        return_code_InconsistentTopicStatus_s =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "eprosima::fastdds::statistics::BaseStatus_s", type_ids_InconsistentTopicStatus_s);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_InconsistentTopicStatus_s)
        {
            eprosima::fastdds::statistics::register_BaseStatus_s_type_identifier(type_ids_InconsistentTopicStatus_s);
        }
        bool common_InconsistentTopicStatus_s_ec {false};
        CommonAliasBody common_InconsistentTopicStatus_s {TypeObjectUtils::build_common_alias_body(related_flags_InconsistentTopicStatus_s,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_InconsistentTopicStatus_s, common_InconsistentTopicStatus_s_ec))};
        if (!common_InconsistentTopicStatus_s_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "eprosima::fastdds::statistics::InconsistentTopicStatus_s related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_InconsistentTopicStatus_s;
        ann_custom_InconsistentTopicStatus_s.reset();
        CompleteAliasBody body_InconsistentTopicStatus_s = TypeObjectUtils::build_complete_alias_body(common_InconsistentTopicStatus_s,
                member_ann_builtin_InconsistentTopicStatus_s, ann_custom_InconsistentTopicStatus_s);
        CompleteAliasType alias_type_InconsistentTopicStatus_s = TypeObjectUtils::build_complete_alias_type(alias_flags_InconsistentTopicStatus_s,
                header_InconsistentTopicStatus_s, body_InconsistentTopicStatus_s);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_InconsistentTopicStatus_s,
                    type_name_InconsistentTopicStatus_s.to_string(), type_ids_InconsistentTopicStatus_s))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "eprosima::fastdds::statistics::InconsistentTopicStatus_s already registered in TypeObjectRegistry for a different type.");
        }
    }
}

void register_SampleLostStatus_s_type_identifier(
        TypeIdentifierPair& type_ids_SampleLostStatus_s)
{
    ReturnCode_t return_code_SampleLostStatus_s {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SampleLostStatus_s =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::statistics::SampleLostStatus_s", type_ids_SampleLostStatus_s);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SampleLostStatus_s)
    {
        AliasTypeFlag alias_flags_SampleLostStatus_s = 0;
        QualifiedTypeName type_name_SampleLostStatus_s = "eprosima::fastdds::statistics::SampleLostStatus_s";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SampleLostStatus_s;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SampleLostStatus_s;
        CompleteTypeDetail detail_SampleLostStatus_s = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SampleLostStatus_s, ann_custom_SampleLostStatus_s, type_name_SampleLostStatus_s.to_string());
        CompleteAliasHeader header_SampleLostStatus_s = TypeObjectUtils::build_complete_alias_header(detail_SampleLostStatus_s);
        AliasMemberFlag related_flags_SampleLostStatus_s = 0;
        return_code_SampleLostStatus_s =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "eprosima::fastdds::statistics::BaseStatus_s", type_ids_SampleLostStatus_s);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_SampleLostStatus_s)
        {
            eprosima::fastdds::statistics::register_BaseStatus_s_type_identifier(type_ids_SampleLostStatus_s);
        }
        bool common_SampleLostStatus_s_ec {false};
        CommonAliasBody common_SampleLostStatus_s {TypeObjectUtils::build_common_alias_body(related_flags_SampleLostStatus_s,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_SampleLostStatus_s, common_SampleLostStatus_s_ec))};
        if (!common_SampleLostStatus_s_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "eprosima::fastdds::statistics::SampleLostStatus_s related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_SampleLostStatus_s;
        ann_custom_SampleLostStatus_s.reset();
        CompleteAliasBody body_SampleLostStatus_s = TypeObjectUtils::build_complete_alias_body(common_SampleLostStatus_s,
                member_ann_builtin_SampleLostStatus_s, ann_custom_SampleLostStatus_s);
        CompleteAliasType alias_type_SampleLostStatus_s = TypeObjectUtils::build_complete_alias_type(alias_flags_SampleLostStatus_s,
                header_SampleLostStatus_s, body_SampleLostStatus_s);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_SampleLostStatus_s,
                    type_name_SampleLostStatus_s.to_string(), type_ids_SampleLostStatus_s))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "eprosima::fastdds::statistics::SampleLostStatus_s already registered in TypeObjectRegistry for a different type.");
        }
    }
}

namespace StatusKind {
void register_StatusKind_type_identifier(
        TypeIdentifierPair& type_ids_StatusKind)
{
    ReturnCode_t return_code_StatusKind {eprosima::fastdds::dds::RETCODE_OK};
    return_code_StatusKind =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::statistics::StatusKind::StatusKind", type_ids_StatusKind);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_StatusKind)
    {
        AliasTypeFlag alias_flags_StatusKind = 0;
        QualifiedTypeName type_name_StatusKind = "eprosima::fastdds::statistics::StatusKind::StatusKind";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_StatusKind;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_StatusKind;
        CompleteTypeDetail detail_StatusKind = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_StatusKind, ann_custom_StatusKind, type_name_StatusKind.to_string());
        CompleteAliasHeader header_StatusKind = TypeObjectUtils::build_complete_alias_header(detail_StatusKind);
        AliasMemberFlag related_flags_StatusKind = 0;
        return_code_StatusKind =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_uint32_t", type_ids_StatusKind);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_StatusKind)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::statistics::StatusKind::StatusKind related TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        bool common_StatusKind_ec {false};
        CommonAliasBody common_StatusKind {TypeObjectUtils::build_common_alias_body(related_flags_StatusKind,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_StatusKind, common_StatusKind_ec))};
        if (!common_StatusKind_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "eprosima::fastdds::statistics::StatusKind::StatusKind related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_StatusKind;
        ann_custom_StatusKind.reset();
        CompleteAliasBody body_StatusKind = TypeObjectUtils::build_complete_alias_body(common_StatusKind,
                member_ann_builtin_StatusKind, ann_custom_StatusKind);
        CompleteAliasType alias_type_StatusKind = TypeObjectUtils::build_complete_alias_type(alias_flags_StatusKind,
                header_StatusKind, body_StatusKind);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_StatusKind,
                    type_name_StatusKind.to_string(), type_ids_StatusKind))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "eprosima::fastdds::statistics::StatusKind::StatusKind already registered in TypeObjectRegistry for a different type.");
        }
    }
}


} // namespace StatusKind
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MonitorServiceData_type_identifier(
        TypeIdentifierPair& type_ids_MonitorServiceData)
{
    ReturnCode_t return_code_MonitorServiceData {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MonitorServiceData =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::statistics::MonitorServiceData", type_ids_MonitorServiceData);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MonitorServiceData)
    {
        UnionTypeFlag union_flags_MonitorServiceData = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MonitorServiceData = "eprosima::fastdds::statistics::MonitorServiceData";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MonitorServiceData;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MonitorServiceData;
        CompleteTypeDetail detail_MonitorServiceData = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MonitorServiceData, ann_custom_MonitorServiceData, type_name_MonitorServiceData.to_string());
        CompleteUnionHeader header_MonitorServiceData = TypeObjectUtils::build_complete_union_header(detail_MonitorServiceData);
        UnionDiscriminatorFlag member_flags_MonitorServiceData = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_MonitorServiceData =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "eprosima::fastdds::statistics::StatusKind::StatusKind", type_ids_MonitorServiceData);

        if (return_code_MonitorServiceData != eprosima::fastdds::dds::RETCODE_OK)
        {
            eprosima::fastdds::statistics::StatusKind::register_StatusKind_type_identifier(type_ids_MonitorServiceData);
        }
        CommonDiscriminatorMember common_MonitorServiceData;
        if (EK_COMPLETE == type_ids_MonitorServiceData.type_identifier1()._d() || TK_NONE == type_ids_MonitorServiceData.type_identifier2()._d())
        {
            common_MonitorServiceData = TypeObjectUtils::build_common_discriminator_member(member_flags_MonitorServiceData, type_ids_MonitorServiceData.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_MonitorServiceData.type_identifier2()._d())
        {
            common_MonitorServiceData = TypeObjectUtils::build_common_discriminator_member(member_flags_MonitorServiceData, type_ids_MonitorServiceData.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::statistics::MonitorServiceData discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_MonitorServiceData.reset();
        ann_custom_MonitorServiceData.reset();
        CompleteDiscriminatorMember discriminator_MonitorServiceData = TypeObjectUtils::build_complete_discriminator_member(common_MonitorServiceData,
                type_ann_builtin_MonitorServiceData, ann_custom_MonitorServiceData);
        CompleteUnionMemberSeq member_seq_MonitorServiceData;
        {
            return_code_MonitorServiceData =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_uint8_t_unbounded", type_ids_MonitorServiceData);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_MonitorServiceData)
            {
                return_code_MonitorServiceData =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_byte", type_ids_MonitorServiceData);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_MonitorServiceData)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_uint8_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_uint8_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_MonitorServiceData, element_identifier_anonymous_sequence_uint8_t_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_uint8_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_uint8_t_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_MonitorServiceData.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_uint8_t_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_uint8_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_uint8_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_uint8_t_unbounded, element_flags_anonymous_sequence_uint8_t_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_uint8_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_uint8_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_uint8_t_unbounded", type_ids_MonitorServiceData))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_uint8_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            UnionMemberFlag member_flags_entity_proxy = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_entity_proxy;
            TypeObjectUtils::add_union_case_label(label_seq_entity_proxy, static_cast<int32_t>(StatusKind::PROXY));
            MemberId member_id_entity_proxy = 0x00000001;
            bool common_entity_proxy_ec {false};
            CommonUnionMember common_entity_proxy {TypeObjectUtils::build_common_union_member(member_id_entity_proxy,
                    member_flags_entity_proxy, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_MonitorServiceData,
                        common_entity_proxy_ec), label_seq_entity_proxy)};
            if (!common_entity_proxy_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union entity_proxy member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_entity_proxy = "entity_proxy";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_entity_proxy;
            ann_custom_MonitorServiceData.reset();
            CompleteMemberDetail detail_entity_proxy = TypeObjectUtils::build_complete_member_detail(name_entity_proxy, member_ann_builtin_entity_proxy, ann_custom_MonitorServiceData);
            CompleteUnionMember member_entity_proxy = TypeObjectUtils::build_complete_union_member(common_entity_proxy, detail_entity_proxy);
            TypeObjectUtils::add_complete_union_member(member_seq_MonitorServiceData, member_entity_proxy);
        }
        {
            return_code_MonitorServiceData =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_eprosima_fastdds_statistics_Connection_unbounded", type_ids_MonitorServiceData);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_MonitorServiceData)
            {
                return_code_MonitorServiceData =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "eprosima::fastdds::statistics::Connection", type_ids_MonitorServiceData);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_MonitorServiceData)
                {
                    eprosima::fastdds::statistics::register_Connection_type_identifier(type_ids_MonitorServiceData);
                }
                bool element_identifier_anonymous_sequence_eprosima_fastdds_statistics_Connection_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_eprosima_fastdds_statistics_Connection_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_MonitorServiceData, element_identifier_anonymous_sequence_eprosima_fastdds_statistics_Connection_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_eprosima_fastdds_statistics_Connection_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_eprosima_fastdds_statistics_Connection_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_MonitorServiceData.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_eprosima_fastdds_statistics_Connection_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_eprosima_fastdds_statistics_Connection_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_eprosima_fastdds_statistics_Connection_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_eprosima_fastdds_statistics_Connection_unbounded, element_flags_anonymous_sequence_eprosima_fastdds_statistics_Connection_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_eprosima_fastdds_statistics_Connection_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_eprosima_fastdds_statistics_Connection_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_eprosima_fastdds_statistics_Connection_unbounded", type_ids_MonitorServiceData))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_eprosima_fastdds_statistics_Connection_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            UnionMemberFlag member_flags_connection_list = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_connection_list;
            TypeObjectUtils::add_union_case_label(label_seq_connection_list, static_cast<int32_t>(StatusKind::CONNECTION_LIST));
            MemberId member_id_connection_list = 0x00000002;
            bool common_connection_list_ec {false};
            CommonUnionMember common_connection_list {TypeObjectUtils::build_common_union_member(member_id_connection_list,
                    member_flags_connection_list, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_MonitorServiceData,
                        common_connection_list_ec), label_seq_connection_list)};
            if (!common_connection_list_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union connection_list member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_connection_list = "connection_list";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_connection_list;
            ann_custom_MonitorServiceData.reset();
            CompleteMemberDetail detail_connection_list = TypeObjectUtils::build_complete_member_detail(name_connection_list, member_ann_builtin_connection_list, ann_custom_MonitorServiceData);
            CompleteUnionMember member_connection_list = TypeObjectUtils::build_complete_union_member(common_connection_list, detail_connection_list);
            TypeObjectUtils::add_complete_union_member(member_seq_MonitorServiceData, member_connection_list);
        }
        {
            return_code_MonitorServiceData =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::IncompatibleQoSStatus_s", type_ids_MonitorServiceData);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_MonitorServiceData)
            {
                eprosima::fastdds::statistics::register_IncompatibleQoSStatus_s_type_identifier(type_ids_MonitorServiceData);
            }
            UnionMemberFlag member_flags_incompatible_qos_status = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_incompatible_qos_status;
            TypeObjectUtils::add_union_case_label(label_seq_incompatible_qos_status, static_cast<int32_t>(StatusKind::INCOMPATIBLE_QOS));
            MemberId member_id_incompatible_qos_status = 0x00000003;
            bool common_incompatible_qos_status_ec {false};
            CommonUnionMember common_incompatible_qos_status {TypeObjectUtils::build_common_union_member(member_id_incompatible_qos_status,
                    member_flags_incompatible_qos_status, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_MonitorServiceData,
                        common_incompatible_qos_status_ec), label_seq_incompatible_qos_status)};
            if (!common_incompatible_qos_status_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union incompatible_qos_status member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_incompatible_qos_status = "incompatible_qos_status";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_incompatible_qos_status;
            ann_custom_MonitorServiceData.reset();
            CompleteMemberDetail detail_incompatible_qos_status = TypeObjectUtils::build_complete_member_detail(name_incompatible_qos_status, member_ann_builtin_incompatible_qos_status, ann_custom_MonitorServiceData);
            CompleteUnionMember member_incompatible_qos_status = TypeObjectUtils::build_complete_union_member(common_incompatible_qos_status, detail_incompatible_qos_status);
            TypeObjectUtils::add_complete_union_member(member_seq_MonitorServiceData, member_incompatible_qos_status);
        }
        {
            return_code_MonitorServiceData =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::InconsistentTopicStatus_s", type_ids_MonitorServiceData);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_MonitorServiceData)
            {
                eprosima::fastdds::statistics::register_InconsistentTopicStatus_s_type_identifier(type_ids_MonitorServiceData);
            }
            UnionMemberFlag member_flags_inconsistent_topic_status = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_inconsistent_topic_status;
            TypeObjectUtils::add_union_case_label(label_seq_inconsistent_topic_status, static_cast<int32_t>(StatusKind::INCONSISTENT_TOPIC));
            MemberId member_id_inconsistent_topic_status = 0x00000004;
            bool common_inconsistent_topic_status_ec {false};
            CommonUnionMember common_inconsistent_topic_status {TypeObjectUtils::build_common_union_member(member_id_inconsistent_topic_status,
                    member_flags_inconsistent_topic_status, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_MonitorServiceData,
                        common_inconsistent_topic_status_ec), label_seq_inconsistent_topic_status)};
            if (!common_inconsistent_topic_status_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union inconsistent_topic_status member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_inconsistent_topic_status = "inconsistent_topic_status";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_inconsistent_topic_status;
            ann_custom_MonitorServiceData.reset();
            CompleteMemberDetail detail_inconsistent_topic_status = TypeObjectUtils::build_complete_member_detail(name_inconsistent_topic_status, member_ann_builtin_inconsistent_topic_status, ann_custom_MonitorServiceData);
            CompleteUnionMember member_inconsistent_topic_status = TypeObjectUtils::build_complete_union_member(common_inconsistent_topic_status, detail_inconsistent_topic_status);
            TypeObjectUtils::add_complete_union_member(member_seq_MonitorServiceData, member_inconsistent_topic_status);
        }
        {
            return_code_MonitorServiceData =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::LivelinessLostStatus_s", type_ids_MonitorServiceData);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_MonitorServiceData)
            {
                eprosima::fastdds::statistics::register_LivelinessLostStatus_s_type_identifier(type_ids_MonitorServiceData);
            }
            UnionMemberFlag member_flags_liveliness_lost_status = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_liveliness_lost_status;
            TypeObjectUtils::add_union_case_label(label_seq_liveliness_lost_status, static_cast<int32_t>(StatusKind::LIVELINESS_LOST));
            MemberId member_id_liveliness_lost_status = 0x00000005;
            bool common_liveliness_lost_status_ec {false};
            CommonUnionMember common_liveliness_lost_status {TypeObjectUtils::build_common_union_member(member_id_liveliness_lost_status,
                    member_flags_liveliness_lost_status, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_MonitorServiceData,
                        common_liveliness_lost_status_ec), label_seq_liveliness_lost_status)};
            if (!common_liveliness_lost_status_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union liveliness_lost_status member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_liveliness_lost_status = "liveliness_lost_status";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_liveliness_lost_status;
            ann_custom_MonitorServiceData.reset();
            CompleteMemberDetail detail_liveliness_lost_status = TypeObjectUtils::build_complete_member_detail(name_liveliness_lost_status, member_ann_builtin_liveliness_lost_status, ann_custom_MonitorServiceData);
            CompleteUnionMember member_liveliness_lost_status = TypeObjectUtils::build_complete_union_member(common_liveliness_lost_status, detail_liveliness_lost_status);
            TypeObjectUtils::add_complete_union_member(member_seq_MonitorServiceData, member_liveliness_lost_status);
        }
        {
            return_code_MonitorServiceData =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::LivelinessChangedStatus_s", type_ids_MonitorServiceData);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_MonitorServiceData)
            {
                eprosima::fastdds::statistics::register_LivelinessChangedStatus_s_type_identifier(type_ids_MonitorServiceData);
            }
            UnionMemberFlag member_flags_liveliness_changed_status = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_liveliness_changed_status;
            TypeObjectUtils::add_union_case_label(label_seq_liveliness_changed_status, static_cast<int32_t>(StatusKind::LIVELINESS_CHANGED));
            MemberId member_id_liveliness_changed_status = 0x00000006;
            bool common_liveliness_changed_status_ec {false};
            CommonUnionMember common_liveliness_changed_status {TypeObjectUtils::build_common_union_member(member_id_liveliness_changed_status,
                    member_flags_liveliness_changed_status, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_MonitorServiceData,
                        common_liveliness_changed_status_ec), label_seq_liveliness_changed_status)};
            if (!common_liveliness_changed_status_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union liveliness_changed_status member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_liveliness_changed_status = "liveliness_changed_status";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_liveliness_changed_status;
            ann_custom_MonitorServiceData.reset();
            CompleteMemberDetail detail_liveliness_changed_status = TypeObjectUtils::build_complete_member_detail(name_liveliness_changed_status, member_ann_builtin_liveliness_changed_status, ann_custom_MonitorServiceData);
            CompleteUnionMember member_liveliness_changed_status = TypeObjectUtils::build_complete_union_member(common_liveliness_changed_status, detail_liveliness_changed_status);
            TypeObjectUtils::add_complete_union_member(member_seq_MonitorServiceData, member_liveliness_changed_status);
        }
        {
            return_code_MonitorServiceData =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::DeadlineMissedStatus_s", type_ids_MonitorServiceData);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_MonitorServiceData)
            {
                eprosima::fastdds::statistics::register_DeadlineMissedStatus_s_type_identifier(type_ids_MonitorServiceData);
            }
            UnionMemberFlag member_flags_deadline_missed_status = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_deadline_missed_status;
            TypeObjectUtils::add_union_case_label(label_seq_deadline_missed_status, static_cast<int32_t>(StatusKind::DEADLINE_MISSED));
            MemberId member_id_deadline_missed_status = 0x00000007;
            bool common_deadline_missed_status_ec {false};
            CommonUnionMember common_deadline_missed_status {TypeObjectUtils::build_common_union_member(member_id_deadline_missed_status,
                    member_flags_deadline_missed_status, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_MonitorServiceData,
                        common_deadline_missed_status_ec), label_seq_deadline_missed_status)};
            if (!common_deadline_missed_status_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union deadline_missed_status member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_deadline_missed_status = "deadline_missed_status";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_deadline_missed_status;
            ann_custom_MonitorServiceData.reset();
            CompleteMemberDetail detail_deadline_missed_status = TypeObjectUtils::build_complete_member_detail(name_deadline_missed_status, member_ann_builtin_deadline_missed_status, ann_custom_MonitorServiceData);
            CompleteUnionMember member_deadline_missed_status = TypeObjectUtils::build_complete_union_member(common_deadline_missed_status, detail_deadline_missed_status);
            TypeObjectUtils::add_complete_union_member(member_seq_MonitorServiceData, member_deadline_missed_status);
        }
        {
            return_code_MonitorServiceData =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::SampleLostStatus_s", type_ids_MonitorServiceData);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_MonitorServiceData)
            {
                eprosima::fastdds::statistics::register_SampleLostStatus_s_type_identifier(type_ids_MonitorServiceData);
            }
            UnionMemberFlag member_flags_sample_lost_status = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_sample_lost_status;
            TypeObjectUtils::add_union_case_label(label_seq_sample_lost_status, static_cast<int32_t>(StatusKind::SAMPLE_LOST));
            MemberId member_id_sample_lost_status = 0x00000008;
            bool common_sample_lost_status_ec {false};
            CommonUnionMember common_sample_lost_status {TypeObjectUtils::build_common_union_member(member_id_sample_lost_status,
                    member_flags_sample_lost_status, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_MonitorServiceData,
                        common_sample_lost_status_ec), label_seq_sample_lost_status)};
            if (!common_sample_lost_status_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union sample_lost_status member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_sample_lost_status = "sample_lost_status";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_sample_lost_status;
            ann_custom_MonitorServiceData.reset();
            CompleteMemberDetail detail_sample_lost_status = TypeObjectUtils::build_complete_member_detail(name_sample_lost_status, member_ann_builtin_sample_lost_status, ann_custom_MonitorServiceData);
            CompleteUnionMember member_sample_lost_status = TypeObjectUtils::build_complete_union_member(common_sample_lost_status, detail_sample_lost_status);
            TypeObjectUtils::add_complete_union_member(member_seq_MonitorServiceData, member_sample_lost_status);
        }
        {
            return_code_MonitorServiceData =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_MonitorServiceData);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_MonitorServiceData)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "statuses_size Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_statuses_size = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_statuses_size;
            TypeObjectUtils::add_union_case_label(label_seq_statuses_size, static_cast<int32_t>(StatusKind::STATUSES_SIZE));
            MemberId member_id_statuses_size = 0x00000009;
            bool common_statuses_size_ec {false};
            CommonUnionMember common_statuses_size {TypeObjectUtils::build_common_union_member(member_id_statuses_size,
                    member_flags_statuses_size, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_MonitorServiceData,
                        common_statuses_size_ec), label_seq_statuses_size)};
            if (!common_statuses_size_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union statuses_size member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_statuses_size = "statuses_size";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_statuses_size;
            ann_custom_MonitorServiceData.reset();
            CompleteMemberDetail detail_statuses_size = TypeObjectUtils::build_complete_member_detail(name_statuses_size, member_ann_builtin_statuses_size, ann_custom_MonitorServiceData);
            CompleteUnionMember member_statuses_size = TypeObjectUtils::build_complete_union_member(common_statuses_size, detail_statuses_size);
            TypeObjectUtils::add_complete_union_member(member_seq_MonitorServiceData, member_statuses_size);
        }
        CompleteUnionType union_type_MonitorServiceData = TypeObjectUtils::build_complete_union_type(union_flags_MonitorServiceData, header_MonitorServiceData, discriminator_MonitorServiceData,
                member_seq_MonitorServiceData);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_MonitorServiceData, type_name_MonitorServiceData.to_string(), type_ids_MonitorServiceData))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::statistics::MonitorServiceData already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MonitorServiceStatusData_type_identifier(
        TypeIdentifierPair& type_ids_MonitorServiceStatusData)
{

    ReturnCode_t return_code_MonitorServiceStatusData {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MonitorServiceStatusData =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "eprosima::fastdds::statistics::MonitorServiceStatusData", type_ids_MonitorServiceStatusData);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MonitorServiceStatusData)
    {
        StructTypeFlag struct_flags_MonitorServiceStatusData = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MonitorServiceStatusData = "eprosima::fastdds::statistics::MonitorServiceStatusData";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MonitorServiceStatusData;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MonitorServiceStatusData;
        CompleteTypeDetail detail_MonitorServiceStatusData = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MonitorServiceStatusData, ann_custom_MonitorServiceStatusData, type_name_MonitorServiceStatusData.to_string());
        CompleteStructHeader header_MonitorServiceStatusData;
        header_MonitorServiceStatusData = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MonitorServiceStatusData);
        CompleteStructMemberSeq member_seq_MonitorServiceStatusData;
        {
            TypeIdentifierPair type_ids_local_entity;
            ReturnCode_t return_code_local_entity {eprosima::fastdds::dds::RETCODE_OK};
            return_code_local_entity =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::detail::GUID_s", type_ids_local_entity);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_local_entity)
            {
                eprosima::fastdds::statistics::detail::register_GUID_s_type_identifier(type_ids_local_entity);
            }
            StructMemberFlag member_flags_local_entity = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_local_entity = 0x00000000;
            bool common_local_entity_ec {false};
            CommonStructMember common_local_entity {TypeObjectUtils::build_common_struct_member(member_id_local_entity, member_flags_local_entity, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_local_entity, common_local_entity_ec))};
            if (!common_local_entity_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure local_entity member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_local_entity = "local_entity";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_local_entity;
            ann_custom_MonitorServiceStatusData.reset();
            AppliedAnnotationSeq tmp_ann_custom_local_entity;
            eprosima::fastcdr::optional<std::string> unit_local_entity;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_local_entity;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_local_entity;
            eprosima::fastcdr::optional<std::string> hash_id_local_entity;
            if (unit_local_entity.has_value() || min_local_entity.has_value() || max_local_entity.has_value() || hash_id_local_entity.has_value())
            {
                member_ann_builtin_local_entity = TypeObjectUtils::build_applied_builtin_member_annotations(unit_local_entity, min_local_entity, max_local_entity, hash_id_local_entity);
            }
            if (!tmp_ann_custom_local_entity.empty())
            {
                ann_custom_MonitorServiceStatusData = tmp_ann_custom_local_entity;
            }
            CompleteMemberDetail detail_local_entity = TypeObjectUtils::build_complete_member_detail(name_local_entity, member_ann_builtin_local_entity, ann_custom_MonitorServiceStatusData);
            CompleteStructMember member_local_entity = TypeObjectUtils::build_complete_struct_member(common_local_entity, detail_local_entity);
            TypeObjectUtils::add_complete_struct_member(member_seq_MonitorServiceStatusData, member_local_entity);
        }
        {
            TypeIdentifierPair type_ids_status_kind;
            ReturnCode_t return_code_status_kind {eprosima::fastdds::dds::RETCODE_OK};
            return_code_status_kind =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::StatusKind::StatusKind", type_ids_status_kind);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_status_kind)
            {
                eprosima::fastdds::statistics::StatusKind::register_StatusKind_type_identifier(type_ids_status_kind);
            }
            StructMemberFlag member_flags_status_kind = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, true, false);
            MemberId member_id_status_kind = 0x00000001;
            bool common_status_kind_ec {false};
            CommonStructMember common_status_kind {TypeObjectUtils::build_common_struct_member(member_id_status_kind, member_flags_status_kind, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_status_kind, common_status_kind_ec))};
            if (!common_status_kind_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure status_kind member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_status_kind = "status_kind";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_status_kind;
            ann_custom_MonitorServiceStatusData.reset();
            AppliedAnnotationSeq tmp_ann_custom_status_kind;
            eprosima::fastcdr::optional<std::string> unit_status_kind;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_status_kind;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_status_kind;
            eprosima::fastcdr::optional<std::string> hash_id_status_kind;
            if (unit_status_kind.has_value() || min_status_kind.has_value() || max_status_kind.has_value() || hash_id_status_kind.has_value())
            {
                member_ann_builtin_status_kind = TypeObjectUtils::build_applied_builtin_member_annotations(unit_status_kind, min_status_kind, max_status_kind, hash_id_status_kind);
            }
            if (!tmp_ann_custom_status_kind.empty())
            {
                ann_custom_MonitorServiceStatusData = tmp_ann_custom_status_kind;
            }
            CompleteMemberDetail detail_status_kind = TypeObjectUtils::build_complete_member_detail(name_status_kind, member_ann_builtin_status_kind, ann_custom_MonitorServiceStatusData);
            CompleteStructMember member_status_kind = TypeObjectUtils::build_complete_struct_member(common_status_kind, detail_status_kind);
            TypeObjectUtils::add_complete_struct_member(member_seq_MonitorServiceStatusData, member_status_kind);
        }
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "eprosima::fastdds::statistics::MonitorServiceData", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
                eprosima::fastdds::statistics::register_MonitorServiceData_type_identifier(type_ids_value);
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value = 0x00000002;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_MonitorServiceStatusData.reset();
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_MonitorServiceStatusData);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_MonitorServiceStatusData, member_value);
        }
        CompleteStructType struct_type_MonitorServiceStatusData = TypeObjectUtils::build_complete_struct_type(struct_flags_MonitorServiceStatusData, header_MonitorServiceStatusData, member_seq_MonitorServiceStatusData);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MonitorServiceStatusData, type_name_MonitorServiceStatusData.to_string(), type_ids_MonitorServiceStatusData))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "eprosima::fastdds::statistics::MonitorServiceStatusData already registered in TypeObjectRegistry for a different type.");
        }
    }
}

} // namespace statistics

} // namespace fastdds

} // namespace eprosima

