// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file FilteringExample.cpp
 * This source file contains the implementation of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifdef _WIN32
// Remove linker warning LNK4221 on Visual Studio
namespace {
char dummy;
}  // namespace
#endif  // _WIN32

#include "FilteringExample.h"

#if FASTCDR_VERSION_MAJOR > 1

#include <fastcdr/Cdr.h>


#include <fastcdr/exceptions/BadParamException.h>
using namespace eprosima::fastcdr::exception;

#include <utility>




FilteringExample::FilteringExample()
{
}

FilteringExample::~FilteringExample()
{
}

FilteringExample::FilteringExample(
        const FilteringExample& x)
{
    m_sampleNumber = x.m_sampleNumber;
}

FilteringExample::FilteringExample(
        FilteringExample&& x) noexcept
{
    m_sampleNumber = x.m_sampleNumber;
}

FilteringExample& FilteringExample::operator =(
        const FilteringExample& x)
{

    m_sampleNumber = x.m_sampleNumber;
    return *this;
}

FilteringExample& FilteringExample::operator =(
        FilteringExample&& x) noexcept
{

    m_sampleNumber = x.m_sampleNumber;
    return *this;
}

bool FilteringExample::operator ==(
        const FilteringExample& x) const
{
    return (m_sampleNumber == x.m_sampleNumber);
}

bool FilteringExample::operator !=(
        const FilteringExample& x) const
{
    return !(*this == x);
}

/*!
 * @brief This function sets a value in member sampleNumber
 * @param _sampleNumber New value for member sampleNumber
 */
void FilteringExample::sampleNumber(
        int32_t _sampleNumber)
{
    m_sampleNumber = _sampleNumber;
}

/*!
 * @brief This function returns the value of member sampleNumber
 * @return Value of member sampleNumber
 */
int32_t FilteringExample::sampleNumber() const
{
    return m_sampleNumber;
}

/*!
 * @brief This function returns a reference to member sampleNumber
 * @return Reference to member sampleNumber
 */
int32_t& FilteringExample::sampleNumber()
{
    return m_sampleNumber;
}


// Include auxiliary functions like for serializing/deserializing.
#include "FilteringExampleCdrAux.ipp"

#endif // FASTCDR_VERSION_MAJOR > 1
