# efm-langserver

- [1. Property `commands`](#commands)
  - [1.1. commands items](#autogenerated_heading_2)
    - [1.1.1. Property `arguments`](#commands_items_arguments)
      - [1.1.1.1. arguments items](#autogenerated_heading_3)
    - [1.1.2. Property `command`](#commands_items_command)
    - [1.1.3. Property `os`](#commands_items_os)
    - [1.1.4. Property `title`](#commands_items_title)
- [2. Property `languages`](#languages)
  - [2.1. Pattern Property `^([a-z0-9_-]+)+$`](#languages_pattern1)
    - [2.1.1. tool-definition](#autogenerated_heading_4)
      - [2.1.1.1. Property `prefix`](#languages_pattern1_items_prefix)
      - [2.1.1.2. Property `format-can-range`](#languages_pattern1_items_format-can-range)
      - [2.1.1.3. Property `format-command`](#languages_pattern1_items_format-command)
      - [2.1.1.4. Property `format-stdin`](#languages_pattern1_items_format-stdin)
      - [2.1.1.5. Property `hover-command`](#languages_pattern1_items_hover-command)
      - [2.1.1.6. Property `hover-stdin`](#languages_pattern1_items_hover-stdin)
      - [2.1.1.7. Property `hover-type`](#languages_pattern1_items_hover-type)
      - [2.1.1.8. Property `env`](#languages_pattern1_items_env)
        - [2.1.1.8.1. env items](#autogenerated_heading_5)
      - [2.1.1.9. Property `lint-command`](#languages_pattern1_items_lint-command)
      - [2.1.1.10. Property `lint-offset-columns`](#languages_pattern1_items_lint-offset-columns)
      - [2.1.1.11. Property `lint-category-map`](#languages_pattern1_items_lint-category-map)
      - [2.1.1.12. Property `lint-formats`](#languages_pattern1_items_lint-formats)
        - [2.1.1.12.1. lint-formats items](#autogenerated_heading_6)
      - [2.1.1.13. Property `lint-ignore-exit-code`](#languages_pattern1_items_lint-ignore-exit-code)
      - [2.1.1.14. Property `lint-offset`](#languages_pattern1_items_lint-offset)
      - [2.1.1.15. Property `lint-stdin`](#languages_pattern1_items_lint-stdin)
      - [2.1.1.16. Property `completion-command`](#languages_pattern1_items_completion-command)
      - [2.1.1.17. Property `completion-stdin`](#languages_pattern1_items_completion-stdin)
      - [2.1.1.18. Property `root-markers`](#languages_pattern1_items_root-markers)
        - [2.1.1.18.1. root-markers items](#autogenerated_heading_7)
      - [2.1.1.19. Property `require-marker`](#languages_pattern1_items_require-marker)
      - [2.1.1.20. Property `commands`](#languages_pattern1_items_commands)
- [3. Property `tools`](#tools)
  - [3.1. Pattern Property `tool-definition`](#tools_pattern1)
- [4. Property `version`](#version)
- [5. Property `root-markers`](#root-markers)
  - [5.1. root-markers items](#autogenerated_heading_8)
- [6. Property `log-file`](#log-file)
- [7. Property `log-level`](#log-level)
- [8. Property `lint-debounce`](#lint-debounce)
- [9. Property `trigger-chars`](#trigger-chars)
  - [9.1. trigger-chars items](#autogenerated_heading_9)

**Title:** efm-langserver

|                           |                                                         |
| ------------------------- | ------------------------------------------------------- |
| **Type**                  | `object`                                                |
| **Required**              | No                                                      |
| **Additional properties** | [[Not allowed]](# "Additional Properties not allowed.") |

**Description:** If configuring via `DidChangeConfiguration` (e.g. an editor API such as `nvim-lspconfig`), all properties should be in camelCase instead of kebab-case.

| Property                           | Pattern | Type            | Deprecated | Definition                          | Title/Description                 |
| ---------------------------------- | ------- | --------------- | ---------- | ----------------------------------- | --------------------------------- |
| - [commands](#commands )           | No      | array of object | No         | In #/definitions/command-definition | list of commands                  |
| - [languages](#languages )         | No      | object          | No         | -                                   | list of language                  |
| - [tools](#tools )                 | No      | object          | No         | -                                   | definition of tools               |
| - [version](#version )             | No      | number          | No         | -                                   | version of this yaml format       |
| - [root-markers](#root-markers )   | No      | array of string | No         | -                                   | markers to find root directory    |
| - [log-file](#log-file )           | No      | string          | No         | -                                   | path to log file                  |
| - [log-level](#log-level )         | No      | number          | No         | -                                   | log level                         |
| - [lint-debounce](#lint-debounce ) | No      | string          | No         | -                                   | debounce for lints                |
| - [trigger-chars](#trigger-chars ) | No      | array of string | No         | -                                   | trigger characters for completion |

## <a name="commands"></a>1. Property `commands`

|                |                                  |
| -------------- | -------------------------------- |
| **Type**       | `array of object`                |
| **Required**   | No                               |
| **Defined in** | #/definitions/command-definition |

**Description:** list of commands

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be   | Description |
| --------------------------------- | ----------- |
| [commands items](#commands_items) | -           |

### <a name="autogenerated_heading_2"></a>1.1. commands items

|                           |                                                         |
| ------------------------- | ------------------------------------------------------- |
| **Type**                  | `object`                                                |
| **Required**              | No                                                      |
| **Additional properties** | [[Not allowed]](# "Additional Properties not allowed.") |

| Property                                  | Pattern | Type            | Deprecated | Definition | Title/Description                 |
| ----------------------------------------- | ------- | --------------- | ---------- | ---------- | --------------------------------- |
| - [arguments](#commands_items_arguments ) | No      | array of string | No         | -          | arguments for the command         |
| - [command](#commands_items_command )     | No      | string          | No         | -          | command to execute                |
| - [os](#commands_items_os )               | No      | string          | No         | -          | command executable OS environment |
| - [title](#commands_items_title )         | No      | string          | No         | -          | title for clients                 |

#### <a name="commands_items_arguments"></a>1.1.1. Property `arguments`

|              |                   |
| ------------ | ----------------- |
| **Type**     | `array of string` |
| **Required** | No                |

**Description:** arguments for the command

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be                    | Description |
| -------------------------------------------------- | ----------- |
| [arguments items](#commands_items_arguments_items) | -           |

##### <a name="autogenerated_heading_3"></a>1.1.1.1. arguments items

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

#### <a name="commands_items_command"></a>1.1.2. Property `command`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** command to execute

#### <a name="commands_items_os"></a>1.1.3. Property `os`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** command executable OS environment

#### <a name="commands_items_title"></a>1.1.4. Property `title`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** title for clients

## <a name="languages"></a>2. Property `languages`

|                           |                                                                           |
| ------------------------- | ------------------------------------------------------------------------- |
| **Type**                  | `object`                                                                  |
| **Required**              | No                                                                        |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |

**Description:** list of language

| Property                                   | Pattern | Type  | Deprecated | Definition | Title/Description |
| ------------------------------------------ | ------- | ----- | ---------- | ---------- | ----------------- |
| - [^([a-z0-9_-]+)+$](#languages_pattern1 ) | Yes     | array | No         | -          | -                 |

### <a name="languages_pattern1"></a>2.1. Pattern Property `^([a-z0-9_-]+)+$`
> All properties whose name matches the regular expression
```^([a-z0-9_-]+)+$``` ([Test](https://regex101.com/?regex=%5E%28%5Ba-z0-9_-%5D%2B%29%2B%24))
must respect the following conditions

|              |         |
| ------------ | ------- |
| **Type**     | `array` |
| **Required** | No      |

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be              | Description            |
| -------------------------------------------- | ---------------------- |
| [tool-definition](#languages_pattern1_items) | definition of the tool |

#### <a name="autogenerated_heading_4"></a>2.1.1. tool-definition

|                           |                                                         |
| ------------------------- | ------------------------------------------------------- |
| **Type**                  | `object`                                                |
| **Required**              | No                                                      |
| **Additional properties** | [[Not allowed]](# "Additional Properties not allowed.") |
| **Defined in**            | #/definitions/tool-definition                           |

**Description:** definition of the tool

| Property                                                                    | Pattern | Type             | Deprecated | Definition                     | Title/Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| --------------------------------------------------------------------------- | ------- | ---------------- | ---------- | ------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| - [prefix](#languages_pattern1_items_prefix )                               | No      | string           | No         | -                              | If `lint-source` doesn't work, you can set a prefix here instead, which will render the messages as "[prefix] message".                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| - [format-can-range](#languages_pattern1_items_format-can-range )           | No      | boolean          | No         | -                              | Whether the formatting command handles range start and range end                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| - [format-command](#languages_pattern1_items_format-command )               | No      | string           | No         | -                              | Formatting command. Input filename can be injected using `${INPUT}`, and flags can be injected using `${--flag:key}` (adds `--flag <value>` if value exists for key), `${--flag=key}` (adds `--flag=<value>` if value exists for key), or `${--flag:!key}` (adds `--flag` if value for key is falsy).<br /><br />`efm-langserver` may provide values for keys `charStart`, `charEnd`, `rowStart`, `rowEnd`, `colStart`, `colEnd`, or any key in [`interface FormattingOptions`](https://microsoft.github.io/language-server-protocol/specifications/lsp/3.17/specification/#formattingOptions).<br /><br />Example: `prettier --stdin --stdin-filepath ${INPUT} ${--tab-width:tabWidth} ${--use-tabs:insertSpaces} ${--range-start=charStart} ${--range-start=charEnd}` |
| - [format-stdin](#languages_pattern1_items_format-stdin )                   | No      | boolean          | No         | -                              | use stdin for the format                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| - [hover-command](#languages_pattern1_items_hover-command )                 | No      | string           | No         | -                              | hover command                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| - [hover-stdin](#languages_pattern1_items_hover-stdin )                     | No      | boolean          | No         | -                              | use stdin for the hover                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| - [hover-type](#languages_pattern1_items_hover-type )                       | No      | enum (of string) | No         | -                              | hover result type                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| - [env](#languages_pattern1_items_env )                                     | No      | array of string  | No         | -                              | command environment variables and values                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| - [lint-command](#languages_pattern1_items_lint-command )                   | No      | string           | No         | -                              | Lint command. Input filename can be injected using `${INPUT}`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| - [lint-offset-columns](#languages_pattern1_items_lint-offset-columns )     | No      | number           | No         | -                              | offset value to skip columns                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| - [lint-category-map](#languages_pattern1_items_lint-category-map )         | No      | object           | No         | -                              | Map linter categories to LSP categories                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| - [lint-formats](#languages_pattern1_items_lint-formats )                   | No      | array of string  | No         | -                              | List of Vim errorformats to capture. See: https://vimhelp.org/quickfix.txt.html#errorformats. If this is not expressive enough, you can edit the `lint-command` to do some preprocessing, e.g. using `sed` or `jq`.<br /><br />`efm-langserver` uses a Go implementation to parse the errors, which comes with a CLI for quick testing: https://github.com/reviewdog/errorformat                                                                                                                                                                                                                                                                                                                                                                                                                |
| - [lint-ignore-exit-code](#languages_pattern1_items_lint-ignore-exit-code ) | No      | boolean          | No         | -                              | ignore exit code of lint                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| - [lint-offset](#languages_pattern1_items_lint-offset )                     | No      | number           | No         | -                              | offset value to skip lines                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| - [lint-stdin](#languages_pattern1_items_lint-stdin )                       | No      | boolean          | No         | -                              | use stdin for the lint                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| - [completion-command](#languages_pattern1_items_completion-command )       | No      | string           | No         | -                              | completion command                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| - [completion-stdin](#languages_pattern1_items_completion-stdin )           | No      | boolean          | No         | -                              | use stdin for the completion                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| - [root-markers](#languages_pattern1_items_root-markers )                   | No      | array of string  | No         | -                              | markers to find root directory                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| - [require-marker](#languages_pattern1_items_require-marker )               | No      | boolean          | No         | -                              | require a marker to run linter                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| - [commands](#languages_pattern1_items_commands )                           | No      | array of object  | No         | Same as [commands](#commands ) | list of commands                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |

##### <a name="languages_pattern1_items_prefix"></a>2.1.1.1. Property `prefix`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** If `lint-source` doesn't work, you can set a prefix here instead, which will render the messages as "[prefix] message".

##### <a name="languages_pattern1_items_format-can-range"></a>2.1.1.2. Property `format-can-range`

|              |           |
| ------------ | --------- |
| **Type**     | `boolean` |
| **Required** | No        |

**Description:** Whether the formatting command handles range start and range end

##### <a name="languages_pattern1_items_format-command"></a>2.1.1.3. Property `format-command`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** Formatting command. Input filename can be injected using `${INPUT}`, and flags can be injected using `${--flag:key}` (adds `--flag <value>` if value exists for key), `${--flag=key}` (adds `--flag=<value>` if value exists for key), or `${--flag:!key}` (adds `--flag` if value for key is falsy).

`efm-langserver` may provide values for keys `charStart`, `charEnd`, `rowStart`, `rowEnd`, `colStart`, `colEnd`, or any key in [`interface FormattingOptions`](https://microsoft.github.io/language-server-protocol/specifications/lsp/3.17/specification/#formattingOptions).

Example: `prettier --stdin --stdin-filepath ${INPUT} ${--tab-width:tabWidth} ${--use-tabs:insertSpaces} ${--range-start=charStart} ${--range-start=charEnd}`

##### <a name="languages_pattern1_items_format-stdin"></a>2.1.1.4. Property `format-stdin`

|              |           |
| ------------ | --------- |
| **Type**     | `boolean` |
| **Required** | No        |

**Description:** use stdin for the format

##### <a name="languages_pattern1_items_hover-command"></a>2.1.1.5. Property `hover-command`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** hover command

##### <a name="languages_pattern1_items_hover-stdin"></a>2.1.1.6. Property `hover-stdin`

|              |           |
| ------------ | --------- |
| **Type**     | `boolean` |
| **Required** | No        |

**Description:** use stdin for the hover

##### <a name="languages_pattern1_items_hover-type"></a>2.1.1.7. Property `hover-type`

|              |                    |
| ------------ | ------------------ |
| **Type**     | `enum (of string)` |
| **Required** | No                 |

**Description:** hover result type

Must be one of:
* "markdown"
* "plaintext"

##### <a name="languages_pattern1_items_env"></a>2.1.1.8. Property `env`

|              |                   |
| ------------ | ----------------- |
| **Type**     | `array of string` |
| **Required** | No                |

**Description:** command environment variables and values

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be                  | Description |
| ------------------------------------------------ | ----------- |
| [env items](#languages_pattern1_items_env_items) | -           |

##### <a name="autogenerated_heading_5"></a>2.1.1.8.1. env items

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

| Restrictions                      |                                                                     |
| --------------------------------- | ------------------------------------------------------------------- |
| **Must match regular expression** | ```^.+=.+$``` [Test](https://regex101.com/?regex=%5E.%2B%3D.%2B%24) |

##### <a name="languages_pattern1_items_lint-command"></a>2.1.1.9. Property `lint-command`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** Lint command. Input filename can be injected using `${INPUT}`.

##### <a name="languages_pattern1_items_lint-offset-columns"></a>2.1.1.10. Property `lint-offset-columns`

|              |          |
| ------------ | -------- |
| **Type**     | `number` |
| **Required** | No       |

**Description:** offset value to skip columns

##### <a name="languages_pattern1_items_lint-category-map"></a>2.1.1.11. Property `lint-category-map`

|                           |                                                                           |
| ------------------------- | ------------------------------------------------------------------------- |
| **Type**                  | `object`                                                                  |
| **Required**              | No                                                                        |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |

**Description:** Map linter categories to LSP categories

##### <a name="languages_pattern1_items_lint-formats"></a>2.1.1.12. Property `lint-formats`

|              |                   |
| ------------ | ----------------- |
| **Type**     | `array of string` |
| **Required** | No                |

**Description:** List of Vim errorformats to capture. See: https://vimhelp.org/quickfix.txt.html#errorformats. If this is not expressive enough, you can edit the `lint-command` to do some preprocessing, e.g. using `sed` or `jq`.

`efm-langserver` uses a Go implementation to parse the errors, which comes with a CLI for quick testing: https://github.com/reviewdog/errorformat

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be                                    | Description |
| ------------------------------------------------------------------ | ----------- |
| [lint-formats items](#languages_pattern1_items_lint-formats_items) | -           |

##### <a name="autogenerated_heading_6"></a>2.1.1.12.1. lint-formats items

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

##### <a name="languages_pattern1_items_lint-ignore-exit-code"></a>2.1.1.13. Property `lint-ignore-exit-code`

|              |           |
| ------------ | --------- |
| **Type**     | `boolean` |
| **Required** | No        |
| **Default**  | `true`    |

**Description:** ignore exit code of lint

##### <a name="languages_pattern1_items_lint-offset"></a>2.1.1.14. Property `lint-offset`

|              |          |
| ------------ | -------- |
| **Type**     | `number` |
| **Required** | No       |

**Description:** offset value to skip lines

##### <a name="languages_pattern1_items_lint-stdin"></a>2.1.1.15. Property `lint-stdin`

|              |           |
| ------------ | --------- |
| **Type**     | `boolean` |
| **Required** | No        |
| **Default**  | `true`    |

**Description:** use stdin for the lint

##### <a name="languages_pattern1_items_completion-command"></a>2.1.1.16. Property `completion-command`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** completion command

##### <a name="languages_pattern1_items_completion-stdin"></a>2.1.1.17. Property `completion-stdin`

|              |           |
| ------------ | --------- |
| **Type**     | `boolean` |
| **Required** | No        |
| **Default**  | `true`    |

**Description:** use stdin for the completion

##### <a name="languages_pattern1_items_root-markers"></a>2.1.1.18. Property `root-markers`

|              |                   |
| ------------ | ----------------- |
| **Type**     | `array of string` |
| **Required** | No                |

**Description:** markers to find root directory

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be                                    | Description |
| ------------------------------------------------------------------ | ----------- |
| [root-markers items](#languages_pattern1_items_root-markers_items) | -           |

##### <a name="autogenerated_heading_7"></a>2.1.1.18.1. root-markers items

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

##### <a name="languages_pattern1_items_require-marker"></a>2.1.1.19. Property `require-marker`

|              |           |
| ------------ | --------- |
| **Type**     | `boolean` |
| **Required** | No        |

**Description:** require a marker to run linter

##### <a name="languages_pattern1_items_commands"></a>2.1.1.20. Property `commands`

|                        |                       |
| ---------------------- | --------------------- |
| **Type**               | `array of object`     |
| **Required**           | No                    |
| **Same definition as** | [commands](#commands) |

**Description:** list of commands

## <a name="tools"></a>3. Property `tools`

|                           |                                                                           |
| ------------------------- | ------------------------------------------------------------------------- |
| **Type**                  | `object`                                                                  |
| **Required**              | No                                                                        |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |

**Description:** definition of tools

| Property                               | Pattern | Type   | Deprecated | Definition                                                     | Title/Description      |
| -------------------------------------- | ------- | ------ | ---------- | -------------------------------------------------------------- | ---------------------- |
| - [^([a-z0-9_-]+)+$](#tools_pattern1 ) | Yes     | object | No         | Same as [languages_pattern1_items](#languages_pattern1_items ) | definition of the tool |

### <a name="tools_pattern1"></a>3.1. Pattern Property `tool-definition`
> All properties whose name matches the regular expression
```^([a-z0-9_-]+)+$``` ([Test](https://regex101.com/?regex=%5E%28%5Ba-z0-9_-%5D%2B%29%2B%24))
must respect the following conditions

|                           |                                                         |
| ------------------------- | ------------------------------------------------------- |
| **Type**                  | `object`                                                |
| **Required**              | No                                                      |
| **Additional properties** | [[Not allowed]](# "Additional Properties not allowed.") |
| **Same definition as**    | [languages_pattern1_items](#languages_pattern1_items)   |

**Description:** definition of the tool

## <a name="version"></a>4. Property `version`

|              |          |
| ------------ | -------- |
| **Type**     | `number` |
| **Required** | No       |

**Description:** version of this yaml format

## <a name="root-markers"></a>5. Property `root-markers`

|              |                   |
| ------------ | ----------------- |
| **Type**     | `array of string` |
| **Required** | No                |

**Description:** markers to find root directory

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be           | Description |
| ----------------------------------------- | ----------- |
| [root-markers items](#root-markers_items) | -           |

### <a name="autogenerated_heading_8"></a>5.1. root-markers items

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

## <a name="log-file"></a>6. Property `log-file`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** path to log file

## <a name="log-level"></a>7. Property `log-level`

|              |          |
| ------------ | -------- |
| **Type**     | `number` |
| **Required** | No       |

**Description:** log level

| Restrictions |        |
| ------------ | ------ |
| **Minimum**  | &ge; 1 |

## <a name="lint-debounce"></a>8. Property `lint-debounce`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

**Description:** debounce for lints

## <a name="trigger-chars"></a>9. Property `trigger-chars`

|              |                   |
| ------------ | ----------------- |
| **Type**     | `array of string` |
| **Required** | No                |

**Description:** trigger characters for completion

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be             | Description |
| ------------------------------------------- | ----------- |
| [trigger-chars items](#trigger-chars_items) | -           |

### <a name="autogenerated_heading_9"></a>9.1. trigger-chars items

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

----------------------------------------------------------------------------------------------------------------------------
Generated using [json-schema-for-humans](https://github.com/coveooss/json-schema-for-humans) on 2023-07-23 at 21:21:30 -0700
