﻿# ASP.NET Core Razor

This repository is the open-source implementation for the [Razor](https://docs.microsoft.com/en-us/aspnet/core/razor-pages) experience in ASP.NET Core. It contains the compiler and IDE tools for working on Razor ASP.NET Core apps using [Visual Studio](https://visualstudio.com), [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/), and [Visual Studio Code](https://code.visualstudio.com/).

## Contributing

All work on Razor happens directly on GitHub. Both core team members and external contributors send pull requests which go through the same review process. Some of the best ways to contribute are to try things out, [file issues](https://github.com/dotnet/razor/issues/new/choose), join in design conversations,
and make pull requests.

* Check out the [contributing](CONTRIBUTING.md) page to see the best places to log issues, start discussions, and for general contributing guidelines.
* [Instructions to build Razor Tooling source code](https://github.com/dotnet/razor/blob/main/docs/contributing/BuildFromSource.md)
* Follow along with the development of ASP.NET Core:
  * [Community Standup](http://live.asp.net): The community standup is held every week and streamed live to YouTube. You can view past standups in the linked playlist.

## Getting Started with Razor

If you are unfamiliar with ASP.NET Core or Razor, follow the links below to learn more:

* ASP.NET Core apps: Follow the [Getting Started](https://docs.microsoft.com/aspnet/core/getting-started) instructions in the [ASP.NET Core docs](https://docs.microsoft.com/aspnet/index).
* Razor pages: Visit the [tutorial](https://docs.microsoft.com/en-us/aspnet/core/tutorials/razor-pages/razor-pages-start?view=aspnetcore-5.0&tabs=visual-studio) on getting started with Razor pages.

Also check out the [.NET Homepage](https://www.microsoft.com/net) for released versions of .NET, getting started guides, and learning resources.

## Reporting security issues and bugs

Security issues and bugs should be reported privately, via email, to the Microsoft Security Response Center (MSRC)  secure@microsoft.com. You should receive a response within 24 hours. If for some reason you do not, please follow up via email to ensure we received your original message. Further information, including the MSRC PGP key, can be found in the [Security TechCenter](https://technet.microsoft.com/en-us/security/ff852094.aspx).

## Status  
[![Build Status](https://dev.azure.com/dnceng-public/public/_apis/build/status/dotnet/razor-tooling/razor-tooling-ci?branchName=main)](https://dev.azure.com/dnceng-public/public/_build/latest?definitionId=103&branchName=main)

## Related projects

These are some other repos for related projects:

* [ASP.NET Core](https://github.com/dotnet/aspnetcore) - the ASP.NET Core framework
* [Documentation](https://github.com/aspnet/Docs) - documentation sources for <https://docs.microsoft.com/aspnet/core/>
* [Extensions](https://github.com/dotnet/extensions) - Logging, configuration, dependency injection, and more.

## Code of conduct

See [CODE-OF-CONDUCT.md](./CODE-OF-CONDUCT.md)
