# Team Guide

## Introduction
The intent of this document is to describe (not prescribe) how we do things within our team.  Every team has their norms, and we're no exception.  Given the shift to hybrid, coming up with our new norms is critical.  This document hopes to reflect and articulate what we've learned that works.

This is a living document, meant to be updated as we learn and adjust.  That is to say, this document should say *something* about most everything we do - and then we change it as we see fit.

## Team Guide Principles
- Every person on the team is encouraged to submit a PR to this doc as they see things that could/should be improved.
- It's more important to try *something* than to find the perfect solution.
- Experiment, learn, adjust and try again.

## Dev Guide Discussion Guidelines
As we try things, find they do/don't work, there's going to be a lot of discussion - with a wide variety of views.  This is good.  As we discuss and wrestle with these challenges before us, let's keep the following in mind:
- Pointing out that something simply won't work is only helpful when there's also a proposal as we're looking for our best guess to try.
- Expressing concerns is different than stating that something just won't work.  We should all express our concerns.
- Making an extra effort to point out parts that *should* work is very helpful.  Not only does this improve how we all feel about things as a whole, but it serves as a reminder of what not to get rid of.
- Keep in mind that nobody actually knows how this will work.  We're all figuring this out together.
- As always, be kind.
- It's very important to capture data such that we're able to better explain our learnings.  This will help also with any infrastructure investments we might need to make.
- We will discuss the current state of the hybrid/async process during our monthly retrospectives to determine what is working, what isn't working, and how we can improve our process.

## What Success Looks Like
Let's not forget the whole point of why we're trying to write down how we think we should best work as a team.
-   Each team person feels like they belong, and are able to do their best work.
-	Team impact and throughput remains high (or even increases).
-	Where the dev lives, or what time of day they’re working, has limited effect on their own personal and overall team effectiveness.
-	Working groups (v-teams) span the globe, yet are effective.
-	Devs are often able to arrange their day and work when they are most productive and best for their situation.
-	Devs are rarely blocked by others in making forward progress.
-	Team diversity continues to increase.
-	Team morale and satisfaction are high.
-	Team responsiveness continues to be high and within the SLA.

## Table of Contents
This is a work-in-progress and is far from complete.  The idea is to start with the trickiest areas we think we'll encounter after Stage 6 re-opening.

- [Hybrid Team Principles](hybridprinciples.md)
- [Making Hybrid Work....Work](hybridcollab.md)
- [General Availability Guidance](availability.md)
- [General Meetings](meetings.md)
- Criteria for when to have synchronous meetings
- [Hybrid Triage](hybridtriage.md)
- [Stand Ups](standup.md)
- [Documentation Guidelines](documentationguidelines.md)
- [Happy Hour](happyhour.md)

<!-- Begin Generated Content: Doc Feedback -->
<sub>Was this helpful? [![Yes](https://helix.dot.net/f/ip/5?p=Documentation%5CTeamProcess%5CDevGuide%5Creadme.md)](https://helix.dot.net/f/p/5?p=Documentation%5CTeamProcess%5CDevGuide%5Creadme.md) [![No](https://helix.dot.net/f/in)](https://helix.dot.net/f/n/5?p=Documentation%5CTeamProcess%5CDevGuide%5Creadme.md)</sub>
<!-- End Generated Content-->
