# Hybrid Triage

## Triage Logistics:
* One 30 minute synchronous meeting per week at each locale.  In this case that’s one for Redmond, and a separate one for Prague.
* One triage driver per locale, although the driver could be shared or rotating.  Triage driver responsibilities:
  * Running CLI tool twice a week.  Once the morning of the day synchronous triage occurs, and once 4 days later.
  * Scheduling and running the weekly synchronous triage meeting, and keeping it on track and focused.
  * Making sure stale issues are taken care of.
* It continues to be expected that issues are reviewed async (offline) by each senior dev at least once during the week.  This should be made much easier using the new async tool – however, I’m well aware that there will be a strong propensity to just waiting until the weekly synchronous meeting.  However, please remember the following:
  * Seniors are expected to do things they don’t necessary like or are hard to do.
  * 30 minutes is not enough time to get through all the issues if we don’t keep up during the week.
  * The weekly meeting should be reserved for discussions about challenging or interesting issues – which is the thing that has been one of the things most missed.  If we spend our time triaging boring issues….we won’t get that value.
  * The added visibility has been super important, and the easiest way to solve this is to review the majority of issues throughout the week.
*	Both locales should continue to review/triage all incoming issues.  This is part of how we share context.

## Scope:
For now, we will limit triage to core-eng and arcade issues.  Depending on how things go, we can discuss bringing other repos in later.  (e.g. xharness etc)  

## Tools:
*	**Async Triage CLI**  is a brand new tool that stuffs issue activity into the Async Triage Teams Channel.  
*	We also use **ZenHub** to manage our issues and epics.  Please let your lead know if you have problems with ZenHub licenses or want to know more how to use the tool.  (for example one super nice feature is the ability to manage issues across multiple repos)

## Policy:
*	Any dev can (and should) ask for further clarification as to what any issue is about from the creator.  (any issue that does not get further clarification w/in 1 week is automatically closed)
*	Any dev can triage (assign the issue to an epic) if they feel confident in doing so.
*	All issues must be triaged within one week.
*	Any issues that are > 1 week old, must be dealt with at the weekly synchronous meeting.

## What triage is:  (refresher)
*	An issue is considered triaged when it’s assigned to a business priority.  (we calls these Epics)
*	The V-Team assigned to an epic is responsible for triaging/prioritizing the issues within their Epic – which may include “kicking” issues back out for triage again – e.g. unassigning them from an epic.
*	Our current (now dated) documentation on Epics is here:  https://dev.azure.com/dnceng/internal/_wiki/wikis/DNCEng%20Services%20Wiki/107/Sprint-Planning-and-Execution for a bit more background/rationale.  Also, be sure and talk to your lead for further clarification, or you can reach out to me (Mark Wilkie) directly.

## For a bit of history, a few things I think we’ve learned:
*	We tried async triage, and it does actually work (sorta/mostly) and would work even better with the new CLI tool.
*	Our teammates in Prague have appreciated the increased visibility (which is something we must continuing doing).
*	Most every dev didn't like not meeting synchronously.
*	The cost of not having serendipitous conversations is significant – but hard to quantify.
*	Ironically, async triage seemed less inclusive because the participation has gone down, not up.  (it’s been falling to a subset of folks to make sure things are triaged)


<!-- Begin Generated Content: Doc Feedback -->
<sub>Was this helpful? [![Yes](https://helix.dot.net/f/ip/5?p=Documentation%5CTeamProcess%5CDevGuide%5Chybridtriage.md)](https://helix.dot.net/f/p/5?p=Documentation%5CTeamProcess%5CDevGuide%5Chybridtriage.md) [![No](https://helix.dot.net/f/in)](https://helix.dot.net/f/n/5?p=Documentation%5CTeamProcess%5CDevGuide%5Chybridtriage.md)</sub>
<!-- End Generated Content-->
