# Hybrid/Async Team Principles

- Business goals are fully described, “done” is specified, and the path to completion articulated such that anyone from the working group can understand the purpose of the work with minimal clarification.      
  -	Epics are how we’re currently doing this.  
- The majority of communication done through “typed” (or formal) channels.  
  -	Each v-team has its own Teams channel – which has the entire dnceng team on it.  (this has been working well so far)         
  -	Meeting notes and/or recordings are always taken and made widely available.  
- It’s easily knowable what each dev is working on, status, and next steps.
  -	Stand ups are still an important team sync point.  (For example, all work done is reflected on a team Kanban board)
  -	Each dev may also set weekly expectations.   
  -	The specifics are more fully described in this dev guide.
- Our team’s “dev process” (how we work) is written down as a living document.
  -	How our team does what we do is codified in a "dev guide" (this set of md's in github) - which is constantly iterated on by devs themselves.
  -	The goal is that this document is actually useful day-to-day for the devs.  This is key to keeping the document truly “alive” and relevant.
  -	As things change or are further clarified, the handbook is laid out well enough that it’s well known where to update it by anyone.
- Async discussions are generally (but not always) prioritized over synchronous.
  -	Devs are encouraged to question meetings by making sure there’s a clear agenda that would benefit by being conducted synchronously.  
  -	Synchronous meetings are still *extremely* important.
- Intentional social interactions continue to be a top priority.
  -	We're continuing “happy hour” 
  - Periodic lunches and/or other events are scheduled every couple of months at a minimum
- Everything starts with a document.  
  -	Proposal (Used to be meeting, but we need to move to a proposal first, then a meeting)
  -	Team Process (Used to be “ask a manager”, but we need to move to update the handbook)
- Each dev is a “manager of one”.  
  -	Each dev is largely autonomous, consistently unblock themselves, and make things better for themselves and the entire team.
- Always iterating.  
  -	Work is done is in the smallest chunks possible, then iterating.    Velocity is more important than size of change.  
  -	This thinking helps devs not get blocked on others.  
- Intentional handoff
  - When handing work to someone, make sure they have context
  - Any investigation/existing work should be written down in the same place the handoff is happening to make the handoff productive
  - Be clear why the handoff is happening (avoid mentions/forwards without indicating expectations or reasoning)


<!-- Begin Generated Content: Doc Feedback -->
<sub>Was this helpful? [![Yes](https://helix.dot.net/f/ip/5?p=Documentation%5CTeamProcess%5CDevGuide%5Chybridprinciples.md)](https://helix.dot.net/f/p/5?p=Documentation%5CTeamProcess%5CDevGuide%5Chybridprinciples.md) [![No](https://helix.dot.net/f/in)](https://helix.dot.net/f/n/5?p=Documentation%5CTeamProcess%5CDevGuide%5Chybridprinciples.md)</sub>
<!-- End Generated Content-->
