/****************************************************************************
 *    lib/c/Term.h - This file is part of coala								*
 *																			*
 *    Copyright (C) 2009  Torsten Grote										*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/


#ifndef TERM_H
#define TERM_H

#include <string>
#include <vector>
#include <set>

#include "Printer.h"

using namespace std;

namespace C {

class Variable;

class Term
{
public:

	Term ( );

	virtual ~Term ( );

	string print(Printer* p = NULL);

	/**
	 * @return vector<Variable*>
	 */
	virtual set<Variable*>* getVariables();

protected:

	string text_;
	enum TermKind { CONSTANT, VARIABLE, FUNCTION, POOL, INTERVAL };
	TermKind term_kind_;

public:

	/**
	 * Set the value of text
	 * @param new_var the new value of text
	 */
	void setText ( string new_var );

	/**
	 * Get the value of text
	 * @return the value of text
	 */
	string getText ( );


	/**
	 * Set the value of term_kind
	 * @param new_var the new value of term_kind
	 */
	void setTerm_kind ( TermKind new_var );

	/**
	 * Get the value of term_kind
	 * @return the value of term_kind
	 */
	TermKind getKind ( );

};
}; // end of package namespace

#endif // TERM_H
