# AC_CLIPPER_OPTIONS      
# ------------------
# target compilation optons
#
AC_DEFUN([AC_CLIPPER_OPTIONS],
[
#specifics for various machines
test "${target:+set}" = set || target="$host_os"
case "$target" in
  *osf* | *64* )
    if test "`basename $CXX`" = cxx; then
      case "$CXXFLAGS" in
        *strict_ansi* ) ;;
        * )
          CXXFLAGS="$CXXFLAGS -ieee -std strict_ansi -alternative_tokens -timplicit_local -no_implicit_include"
        esac
    fi
  ;;
  *linux* ) ;;
  *irix* )
    if test "`basename $CXX`" = CC; then
      case "$CXXFLAGS" in
        *LANG:std* ) ;;
        * )
          CXXFLAGS="$CXXFLAGS -LANG:std -ptused"
        esac
    fi
  ;;
  *darwin* )
    if test "`basename $CXX`" = gcc || test "`basename $CXX`" = g++; then
      case `$CXX -v 2>&1` in 
       *3.1*)
# problem with PIC relocation tables for 3.1
        case "$CXXFLAGS" in
         *-O* | *-O1* | *-O2* | *-O3* )
          CXXFLAGS=`echo $CXXFLAGS | sed s%-O[\ 123]%-O0%g`
          ;;
         *-O0* ) ;;
         * )
          CXXFLAGS="$CXXFLAGS -O0"
        esac
        ;;
      *) 
      esac
    fi
  ;;
  *solaris* )
    if test "`basename $CXX`" = CC; then
      AR=CC
      AR_FLAGS="-xar -o"
    fi
  ;;
  * )
esac

# disable strict aliasing in all versions of gcc
if test "`basename $CXX`" = gcc || test "`basename $CXX`" = g++; then
  CXXFLAGS="$CXXFLAGS -fno-strict-aliasing"
fi

] )  # AC_CLIPPER_OPTIONS      

