<?php
/*
+--------------------------------------------------------------------+
| CiviCRM version 4.7                                                |
+--------------------------------------------------------------------+
| Copyright CiviCRM LLC (c) 2004-2017                                |
+--------------------------------------------------------------------+
| This file is a part of CiviCRM.                                    |
|                                                                    |
| CiviCRM is free software; you can copy, modify, and distribute it  |
| under the terms of the GNU Affero General Public License           |
| Version 3, 19 November 2007 and the CiviCRM Licensing Exception.   |
|                                                                    |
| CiviCRM is distributed in the hope that it will be useful, but     |
| WITHOUT ANY WARRANTY; without even the implied warranty of         |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               |
| See the GNU Affero General Public License for more details.        |
|                                                                    |
| You should have received a copy of the GNU Affero General Public   |
| License and the CiviCRM Licensing Exception along                  |
| with this program; if not, contact CiviCRM LLC                     |
| at info[AT]civicrm[DOT]org. If you have questions about the        |
| GNU Affero General Public License or the licensing of CiviCRM,     |
| see the CiviCRM license FAQ at http://civicrm.org/licensing        |
+--------------------------------------------------------------------+
*/
/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2017
 *
 * Generated from xml/schema/CRM/Core/Note.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:9f5e4f2a7e73840743efc268ffb4dbfd)
 */
require_once 'CRM/Core/DAO.php';
require_once 'CRM/Utils/Type.php';
/**
 * CRM_Core_DAO_Note constructor.
 */
class CRM_Core_DAO_Note extends CRM_Core_DAO {
  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  static $_tableName = 'civicrm_note';
  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var boolean
   */
  static $_log = true;
  /**
   * Note ID
   *
   * @var int unsigned
   */
  public $id;
  /**
   * Name of table where item being referenced is stored.
   *
   * @var string
   */
  public $entity_table;
  /**
   * Foreign key to the referenced item.
   *
   * @var int unsigned
   */
  public $entity_id;
  /**
   * Note and/or Comment.
   *
   * @var text
   */
  public $note;
  /**
   * FK to Contact ID creator
   *
   * @var int unsigned
   */
  public $contact_id;
  /**
   * When was this note last modified/edited
   *
   * @var date
   */
  public $modified_date;
  /**
   * subject of note description
   *
   * @var string
   */
  public $subject;
  /**
   * Foreign Key to Note Privacy Level (which is an option value pair and hence an implicit FK)
   *
   * @var string
   */
  public $privacy;
  /**
   * Class constructor.
   */
  function __construct() {
    $this->__table = 'civicrm_note';
    parent::__construct();
  }
  /**
   * Returns foreign keys and entity references.
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  static function getReferenceColumns() {
    if (!isset(Civi::$statics[__CLASS__]['links'])) {
      Civi::$statics[__CLASS__]['links'] = static ::createReferenceColumns(__CLASS__);
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName() , 'contact_id', 'civicrm_contact', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Dynamic(self::getTableName() , 'entity_id', NULL, 'id', 'entity_table');
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'links_callback', Civi::$statics[__CLASS__]['links']);
    }
    return Civi::$statics[__CLASS__]['links'];
  }
  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = array(
        'id' => array(
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Note ID') ,
          'description' => 'Note ID',
          'required' => true,
          'table_name' => 'civicrm_note',
          'entity' => 'Note',
          'bao' => 'CRM_Core_BAO_Note',
          'localizable' => 0,
        ) ,
        'entity_table' => array(
          'name' => 'entity_table',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Note Entity') ,
          'description' => 'Name of table where item being referenced is stored.',
          'required' => true,
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'table_name' => 'civicrm_note',
          'entity' => 'Note',
          'bao' => 'CRM_Core_BAO_Note',
          'localizable' => 0,
          'pseudoconstant' => array(
            'callback' => 'CRM_Core_BAO_Note::entityTables',
          )
        ) ,
        'entity_id' => array(
          'name' => 'entity_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Note Entity ID') ,
          'description' => 'Foreign key to the referenced item.',
          'required' => true,
          'table_name' => 'civicrm_note',
          'entity' => 'Note',
          'bao' => 'CRM_Core_BAO_Note',
          'localizable' => 0,
        ) ,
        'note' => array(
          'name' => 'note',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Note') ,
          'description' => 'Note and/or Comment.',
          'rows' => 4,
          'cols' => 60,
          'import' => true,
          'where' => 'civicrm_note.note',
          'headerPattern' => '/Note|Comment/i',
          'dataPattern' => '//',
          'export' => true,
          'table_name' => 'civicrm_note',
          'entity' => 'Note',
          'bao' => 'CRM_Core_BAO_Note',
          'localizable' => 0,
          'html' => array(
            'type' => 'TextArea',
          ) ,
        ) ,
        'contact_id' => array(
          'name' => 'contact_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Note Created By') ,
          'description' => 'FK to Contact ID creator',
          'table_name' => 'civicrm_note',
          'entity' => 'Note',
          'bao' => 'CRM_Core_BAO_Note',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_Contact',
        ) ,
        'modified_date' => array(
          'name' => 'modified_date',
          'type' => CRM_Utils_Type::T_DATE,
          'title' => ts('Note Modified By') ,
          'description' => 'When was this note last modified/edited',
          'table_name' => 'civicrm_note',
          'entity' => 'Note',
          'bao' => 'CRM_Core_BAO_Note',
          'localizable' => 0,
        ) ,
        'subject' => array(
          'name' => 'subject',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Subject') ,
          'description' => 'subject of note description',
          'maxlength' => 255,
          'size' => 60,
          'table_name' => 'civicrm_note',
          'entity' => 'Note',
          'bao' => 'CRM_Core_BAO_Note',
          'localizable' => 0,
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'privacy' => array(
          'name' => 'privacy',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Privacy') ,
          'description' => 'Foreign Key to Note Privacy Level (which is an option value pair and hence an implicit FK)',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_note',
          'entity' => 'Note',
          'bao' => 'CRM_Core_BAO_Note',
          'localizable' => 0,
          'pseudoconstant' => array(
            'optionGroupName' => 'note_privacy',
            'optionEditPath' => 'civicrm/admin/options/note_privacy',
          )
        ) ,
      );
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }
  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }
  /**
   * Returns the names of this table
   *
   * @return string
   */
  static function getTableName() {
    return self::$_tableName;
  }
  /**
   * Returns if this table needs to be logged
   *
   * @return boolean
   */
  function getLog() {
    return self::$_log;
  }
  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &import($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'note', $prefix, array());
    return $r;
  }
  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &export($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'note', $prefix, array());
    return $r;
  }
  /**
   * Returns the list of indices
   */
  public static function indices($localize = TRUE) {
    $indices = array(
      'index_entity' => array(
        'name' => 'index_entity',
        'field' => array(
          0 => 'entity_table',
          1 => 'entity_id',
        ) ,
        'localizable' => false,
        'sig' => 'civicrm_note::0::entity_table::entity_id',
      ) ,
    );
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }
}
