//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Model/FitParameterHelper.cpp
//! @brief     Implements namespace FitModelHelper
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/Model/Model/FitParameterHelper.h"
#include "Base/Util/Assert.h"
#include "GUI/Model/Job/JobItem.h"
#include "GUI/Model/Job/ParameterTreeItems.h"

ParameterItem* FitParameterHelper::getParameterItem(JobItem* jobItem, const QString& link)
{
    ASSERT(jobItem);
    return jobItem->parameterContainerItem()->findParameterItem(link);
}
